//---------------------------------------------------------------------------
// Copyright (C) 2000 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
// Read binary TAG based file and print in human readable format.
//
// Version 2.00
//

#include "msginc.h"

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>

// external prototypes
extern int TAGToString(TAGType *, char *, int);

//----------------------------------------------------------------------
//  This is the Main routine for dumpobm.
//
int main(short argc, char **argv)
{
   FILE *infp;
   TAGType OutTAG;
   char buf[5048];

   // check arguments to see if request instruction with '?' or too many
   if (argc != 2)
   {
       printf("\nusage: dumpobm input_filename\n"
              "  - Dump TAG file \n"
              "  - argument 1, input_filename: input filename\n"
              "  - version 1.00\n");
       exit(1);
   }

   // open the input file
   infp = fopen(argv[1],"rb");
   if(infp == NULL)
   {
      printf("ERROR, Could not open input file!\n");
      exit(1);
   }
   else
      printf("File '%s' opened to read.\n",
              argv[1]);

   // read the input file 
   OutTAG.msglen = fread(&OutTAG.msg[0],1,MSGMAX,infp);

   // clean up opened file
   fclose(infp);
   printf("File '%s' closed.\n",
           argv[1]);

   // print out the TAG Tag in human readable form
   if (TAGToString(&OutTAG,buf,sizeof(buf)))
      printf("\n%s\n",buf);
   else
      printf("\n%s\nERROR parsing TAG\n",buf);

   // normal exit
   exit(0);

   return 0;
}

