/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.MySQLDialect;

public class MySQLDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private final MySQLDialectHelper _dialect = new MySQLDialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 6) {
            return 53;
        }
        return 38;
    }

    @Override
    public String getDisplayName() {
        return "MySQL";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase().startsWith("mysql") && !databaseProductVersion.startsWith("5");
    }

    public String getModifyColumnNullabilitySQL(String tableName, TableColumnInfo info, boolean nullable) {
        StringBuilder result = new StringBuilder();
        result.append(" ALTER TABLE ");
        result.append(tableName);
        result.append(" MODIFY ");
        result.append(info.getColumnName());
        result.append(" ");
        result.append(DialectUtils.getTypeName(info, this));
        if (nullable) {
            result.append(" NULL ");
        } else {
            result.append(" NOT NULL ");
        }
        return result.toString();
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE ");
        result.append(info.getTableName());
        result.append(" MODIFY ");
        result.append(info.getColumnName());
        result.append(" ");
        result.append(DialectUtils.getTypeName(info, this));
        DialectUtils.appendDefaultClause(info, result);
        return result.toString();
    }

    @Override
    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE ");
        result.append(info.getTableName());
        result.append(" MODIFY ");
        result.append(info.getColumnName());
        result.append(" ");
        result.append(DialectUtils.getTypeName(info, this));
        result.append(" COMMENT '");
        result.append(info.getRemarks());
        result.append("'");
        return result.toString();
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "MODIFY COLUMN";
        prefs.setQuoteColumnNames(false);
        String columnNullableAlterSql = DialectUtils.getColumnNullableAlterSQL(info, this, "MODIFY COLUMN", true, qualifier, prefs);
        return new String[]{columnNullableAlterSql};
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE ");
        result.append(from.getTableName());
        result.append(" CHANGE ");
        result.append(from.getColumnName());
        result.append(" ");
        result.append(to.getColumnName());
        result.append(" ");
        result.append(DialectUtils.getTypeName(from, this));
        return result.toString();
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE ");
        result.append(from.getTableName());
        result.append(" CHANGE ");
        result.append(to.getColumnName());
        result.append(" ");
        result.append(to.getColumnName());
        result.append(" ");
        result.append(DialectUtils.getTypeName(to, this));
        ArrayList<String> list = new ArrayList<String>();
        list.add(result.toString());
        return list;
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, false, false, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("ALTER TABLE ");
        tmp.append(tableName);
        tmp.append(" DROP FOREIGN KEY ");
        tmp.append(fkName);
        return tmp.toString();
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.MYSQL;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"UNIQUE", "FULLTEXT", "SPATIAL"};
    }

    @Override
    public String[] getIndexStorageOptions() {
        return new String[]{"BTREE", "HASH"};
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "ALTER TABLE $tableName$ MODIFY $columnName$ BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY";
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ MODIFY $columnName$ BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("tableName", column.getTableName());
        valuesMap.put("columnName", column.getColumnName());
        String addAutoIncrementSql = DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
        addAutoIncrementSql = DialectUtils.stripQuotesFromIdentifier(this, column.getColumnName(), addAutoIncrementSql);
        return new String[]{addAutoIncrementSql};
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = true;
        boolean addNullClause = true;
        prefs.setQuoteColumnNames(false);
        String addColumnSql = DialectUtils.getAddColumSQL(column, this, true, true, true, qualifier, prefs);
        return new String[]{addColumnSql};
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String fkTemplateStr = "ALTER TABLE $childTableName$ ADD $constraint$ $constraintName$ FOREIGN KEY ( $childColumn; separator=\",\"$ ) REFERENCES $parentTableName$ ( $parentColumn; separator=\",\"$ )";
        StringTemplate fkst = new StringTemplate("ALTER TABLE $childTableName$ ADD $constraint$ $constraintName$ FOREIGN KEY ( $childColumn; separator=\",\"$ ) REFERENCES $parentTableName$ ( $parentColumn; separator=\",\"$ )");
        HashMap<String, String> fkValuesMap = new HashMap<String, String>();
        fkValuesMap.put("childTableName", localTableName);
        if (constraintName != null) {
            fkValuesMap.put("constraint", "CONSTRAINT");
            fkValuesMap.put("constraintName", constraintName);
        }
        fkValuesMap.put("parentTableName", refTableName);
        StringTemplate ckIndexSt = null;
        HashMap<String, String> ckIndexValuesMap = null;
        if (autoFKIndex) {
            ckIndexSt = new StringTemplate("CREATE $unique$ $storageOption$ INDEX $indexName$ ON $tableName$ ( $columnName; separator=\",\"$ )");
            ckIndexValuesMap = new HashMap<String, String>();
            ckIndexValuesMap.put("indexName", "fk_child_idx");
            ckIndexValuesMap.put("tableName", localTableName);
        }
        prefs.setQuoteColumnNames(false);
        return DialectUtils.getAddForeignKeyConstraintSQL(fkst, fkValuesMap, ckIndexSt, ckIndexValuesMap, localRefColumns, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "ALTER TABLE $tableName$ ADD $constraint$ $constraintName$ UNIQUE $index$ $indexName$ $indexType$ ($columnName;  separator=\",\"$)";
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ADD $constraint$ $constraintName$ UNIQUE $index$ $indexName$ $indexType$ ($columnName;  separator=\",\"$)");
        st.setAttribute("tableName", (Object)tableName);
        if (constraintName != null) {
            st.setAttribute("constraint", (Object)"CONSTRAINT");
            st.setAttribute("constraintName", (Object)constraintName);
        }
        for (TableColumnInfo columnInfo : columns) {
            st.setAttribute("columnName", (Object)columnInfo.getColumnName());
        }
        return new String[]{st.toString()};
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 16;
        String msg = DialectUtils.getUnsupportedMessage(this, 16);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "CREATE $accessMethod$ INDEX $indexName$ $indexType$ ON $tableName$ ( $columnName; separator=\",\"$ )";
        StringTemplate st = new StringTemplate("CREATE $accessMethod$ INDEX $indexName$ $indexType$ ON $tableName$ ( $columnName; separator=\",\"$ )");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        if (accessMethod != null && !accessMethod.toLowerCase().equals("default")) {
            valuesMap.put("accessMethod", accessMethod);
        }
        valuesMap.put("indexName", indexName);
        valuesMap.put("tableName", tableName);
        String addIndexSql = DialectUtils.getAddIndexSQL(this, st, valuesMap, columns, qualifier, prefs);
        for (String column : columns) {
            addIndexSql = DialectUtils.stripQuotesFromIdentifier(this, column, addIndexSql);
        }
        return addIndexSql;
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 15;
        String msg = DialectUtils.getUnsupportedMessage(this, 15);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getCreateTableSQL(String tableName, List<TableColumnInfo> columns, List<TableColumnInfo> primaryKeys, SqlGenerationPreferences prefs, DatabaseObjectQualifier qualifier) {
        prefs.setQuoteColumnNames(false);
        return DialectUtils.getCreateTableSQL(tableName, columns, primaryKeys, prefs, qualifier, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 10;
        String msg = DialectUtils.getUnsupportedMessage(this, 10);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 22;
        String msg = DialectUtils.getUnsupportedMessage(this, 22);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropIndexSQL(tableName, indexName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 18;
        String msg = DialectUtils.getUnsupportedMessage(this, 18);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 12;
        String msg = DialectUtils.getUnsupportedMessage(this, 12);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getInsertIntoSQL(String tableName, List<String> columns, String valuesPart, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getInsertIntoSQL(tableName, columns, valuesPart, qualifier, prefs, this);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String renameTableSql = DialectUtils.getRenameTableSQL(oldTableName, newTableName, qualifier, prefs, this);
        return DialectUtils.stripQuotesFromIdentifier(this, newTableName, renameTableSql);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 11;
        String msg = DialectUtils.getUnsupportedMessage(this, 11);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 17;
        String msg = DialectUtils.getUnsupportedMessage(this, 17);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getUpdateSQL(String tableName, String[] setColumns, String[] setValues, String[] fromTables, String[] whereColumns, String[] whereValues, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "";
        templateStr = fromTables != null ? "UPDATE $destTableName$ SET $columnName$ = (SELECT $columnName$ FROM $sourceTableName$ where $sourceTableName$.$whereColumnName$ = $destTableName$.$whereValue$)" : "UPDATE $destTableName$ SET $columnName$ = $columnValue$ where $whereColumnName$ = $whereValue$";
        StringTemplate st = new StringTemplate(templateStr);
        return DialectUtils.getUpdateSQL(st, tableName, setColumns, setValues, fromTables, whereColumns, whereValues, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAccessMethods() {
        return true;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return false;
    }

    @Override
    public boolean supportsDropConstraint() {
        return false;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return false;
    }

    @Override
    public boolean supportsDropView() {
        return false;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return true;
    }

    @Override
    public boolean supportsRenameTable() {
        return true;
    }

    @Override
    public boolean supportsRenameView() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return false;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return false;
    }

    @Override
    public boolean supportsTablespace() {
        return true;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return false;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        throw new UnsupportedOperationException("getViewDefinitionSQL: MySQL 4 and below doesn't support views");
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return identifier;
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        prefs.setQuoteColumnNames(false);
        prefs.setQuoteConstraintNames(false);
        return super.getColumnDropSQL(tableName, columnName, qualifier, prefs);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] colInfos, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        prefs.setQuoteColumnNames(false);
        prefs.setQuoteConstraintNames(false);
        return super.getAddPrimaryKeySQL(pkName, colInfos, ti, qualifier, prefs);
    }

    @Override
    public String getBinaryLiteralString(byte[] binaryData) {
        return "x" + DialectUtils.toHexString(binaryData);
    }

    class MySQLDialectHelper
    extends MySQLDialect {
        public MySQLDialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, 255, "binary($l)");
            this.registerColumnType(-2, 65532, "blob");
            this.registerColumnType(-2, "longblob");
            this.registerColumnType(-7, "bit");
            this.registerColumnType(2004, 65532, "blob");
            this.registerColumnType(2004, "longblob");
            this.registerColumnType(16, "bool");
            this.registerColumnType(1, 255, "char($l)");
            this.registerColumnType(1, 65532, "text");
            this.registerColumnType(1, "longtext");
            this.registerColumnType(2005, "longtext");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p,$s)");
            this.registerColumnType(8, "double");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, "longblob");
            this.registerColumnType(-1, "longtext");
            this.registerColumnType(2, "numeric($p,$s)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, 255, "varbinary($l)");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(12, "text");
        }
    }
}

