/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Color;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class BigDataToTextareaLoader {
    private static final int CHUNK_SIZE = 1024;
    private String content;
    private PlainDocument doc;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BigDataToTextareaLoader.class);

    public BigDataToTextareaLoader(String content) {
        this.content = content;
        this.doc = new PlainDocument();
    }

    public void startFillingInBackground() {
        final SimpleAttributeSet attrSet = new SimpleAttributeSet();
        if (this.content.length() <= 1024) {
            try {
                this.doc.insertString(0, this.content, attrSet);
            }
            catch (BadLocationException e) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            }
        } else {
            try {
                attrSet.addAttribute(StyleConstants.Foreground, Color.RED);
                this.doc.insertString(0, i18n.LOADING_MSG, attrSet);
            }
            catch (BadLocationException e) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int offset = i18n.LOADING_MSG.length();
                    attrSet.addAttribute(StyleConstants.Foreground, Color.BLACK);
                    try {
                        for (int i = 0; i < BigDataToTextareaLoader.this.content.length(); i += 1024) {
                            int endIndex = Math.min(i + 1024, BigDataToTextareaLoader.this.content.length());
                            BigDataToTextareaLoader.this.doc.insertString(offset, BigDataToTextareaLoader.this.content.substring(i, endIndex), attrSet);
                            offset += 1024;
                        }
                        BigDataToTextareaLoader.this.doc.remove(0, i18n.LOADING_MSG.length());
                    }
                    catch (BadLocationException e) {
                        UIManager.getLookAndFeel().provideErrorFeedback(null);
                    }
                }
            });
        }
    }

    public Document getDoc() {
        return this.doc;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String LOADING_MSG = BigDataToTextareaLoader.access$000().getString("BigDataToTextareaLoader.loading");
    }
}

