/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class NonExistentingTableInfoPlaceHolder
implements ITableInfo {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(NonExistentingTableInfoPlaceHolder.class);
    private String _catalog;
    private String _schema;
    private String _tableName;

    public NonExistentingTableInfoPlaceHolder(String catalog, String schema, String tableName) {
        this._catalog = catalog;
        this._schema = schema;
        this._tableName = tableName;
    }

    public String getType() {
        return "TABLE";
    }

    public String getRemarks() {
        return null;
    }

    public ITableInfo[] getChildTables() {
        return new ITableInfo[0];
    }

    public ForeignKeyInfo[] getImportedKeys() {
        return new ForeignKeyInfo[0];
    }

    public ForeignKeyInfo[] getExportedKeys() {
        return new ForeignKeyInfo[0];
    }

    public void setExportedKeys(ForeignKeyInfo[] foreignKeys) {
    }

    public void setImportedKeys(ForeignKeyInfo[] foreignKeys) {
    }

    public String getCatalogName() {
        return null;
    }

    public String getSchemaName() {
        return this._schema;
    }

    public String getSimpleName() {
        return s_stringMgr.getString("nonExistentingTableInfoPlaceHolder.tableNotExisting", new Object[]{this._tableName});
    }

    public String getQualifiedName() {
        String qualifiedTableName = SQLUtilities.getQualifiedTableName((String)this._catalog, (String)this._schema, (String)this._tableName);
        return s_stringMgr.getString("nonExistentingTableInfoPlaceHolder.tableNotExisting", new Object[]{qualifiedTableName});
    }

    public DatabaseObjectType getDatabaseObjectType() {
        return DatabaseObjectType.TABLE;
    }

    public int compareTo(IDatabaseObjectInfo o) {
        if (!(o instanceof NonExistentingTableInfoPlaceHolder)) {
            return 1;
        }
        NonExistentingTableInfoPlaceHolder neth = (NonExistentingTableInfoPlaceHolder)o;
        return this.getQualifiedName().compareTo(neth.getQualifiedName());
    }
}

