/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.fife.ui.UIUtil;

public class KeyStrokeField
extends JTextField {
    private KeyStroke stroke;
    private FocusAdapter listener = new FocusHandler();

    public KeyStrokeField() {
        super(20);
        this.addFocusListener(this.listener);
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    protected void processKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (e.getID() == 401 && keyCode != 10 && keyCode != 8) {
            int modifiers = e.getModifiers();
            this.setKeyStroke(KeyStroke.getKeyStroke(keyCode, modifiers));
            return;
        }
        if (keyCode == 8) {
            this.stroke = null;
            this.setText(null);
        }
    }

    public void setKeyStroke(KeyStroke ks) {
        this.stroke = ks;
        this.setText(UIUtil.getPrettyStringFor(this.stroke));
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            KeyStrokeField.this.selectAll();
        }
    }
}

