/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2;

import com.sshtools.j2ssh.SshClient;
import edu.harvard.mgh.purcell.gCLINE.general.ErrorManager;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.data.Project;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class PLINK_Open
extends JDialog {
    private Logger logger = Logger.getLogger(PLINK_Open.class);
    private GPLINK parent;
    private GCFileChooser localChooser;
    private JButton remoteBrowse;
    private GCFileChooser remoteChooser;
    private JTextField localProject;
    private JTextField remoteProject;
    private JTextField host;
    private JTextField user;
    private JTextField port;
    private SshClient conn;
    private JCheckBox remoteFlag;
    private JButton ok;
    private JPanel remotePanel;

    private void checkButtons() {
        this.ok.setEnabled(false);
        this.remoteBrowse.setEnabled(false);
        this.remoteFlag.setEnabled(false);
        if (!this.localProject.getText().matches("^\\s*$")) {
            this.remoteFlag.setEnabled(true);
            if (this.remoteFlag.isSelected()) {
                if (this.conn != null) {
                    this.remoteBrowse.setEnabled(true);
                    if (!this.remoteProject.getText().matches("^\\s*$")) {
                        this.ok.setEnabled(true);
                    }
                }
            } else {
                this.ok.setEnabled(true);
            }
        }
    }

    private JPanel createLocal() {
        JPanel ans = new JPanel();
        this.localProject = new JTextField(20);
        this.localChooser = new GCFileChooser(this.parent, (FileFilter)new gCLINEFilter(), true, true, null, "");
        this.localChooser.addFileChoosenListener(new GCFileChooser.FileChoosenListener(){

            public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                PLINK_Open.this.logger.info("(createLocal()) adding the localProject");
                PLINK_Open.this.localProject.setText(((PLINK_Open)PLINK_Open.this).localChooser.fileName);
            }
        });
        JButton browse = new JButton("Browse");
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PLINK_Open.this.localChooser.showChooser();
            }
        });
        ans.add(this.localProject);
        ans.add(browse);
        return ans;
    }

    private JPanel createRemoteFlag() {
        JPanel ans = new JPanel();
        this.remoteFlag = new JCheckBox("SSH link to remote project (Linux/Unix host)");
        this.remoteFlag.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PLINK_Open.this.checkButtons();
                PLINK_Open.this.remotePanel.setVisible(PLINK_Open.this.remoteFlag.isSelected());
                PLINK_Open.this.pack();
            }
        });
        this.remoteFlag.setEnabled(false);
        ans.add(this.remoteFlag);
        return ans;
    }

    private JPanel createConnection() {
        JPanel ans = new JPanel();
        this.user = new JTextField(10);
        this.host = new JTextField(30);
        this.port = new JTextField("22", 5);
        JButton login = new JButton("Login");
        login.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PLINK_Open.this.conn = Project.connect(new ErrorManager(PLINK_Open.this.parent), PLINK_Open.this.parent, PLINK_Open.this.host.getText(), PLINK_Open.this.user.getText(), new Integer(PLINK_Open.this.port.getText()));
                PLINK_Open.this.checkButtons();
            }
        });
        ans.add(new JLabel("user: "));
        ans.add(this.user);
        ans.add(new JLabel("host: "));
        ans.add(this.host);
        ans.add(new JLabel("port: "));
        ans.add(this.port);
        ans.add(login);
        return ans;
    }

    private JPanel createRemote() {
        JPanel ans = new JPanel();
        this.remoteProject = new JTextField(20);
        this.remoteBrowse = new JButton("Browse");
        this.remoteBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PLINK_Open.this.remoteChooser = new GCFileChooser(PLINK_Open.this.parent, null, false, true, PLINK_Open.this.conn, "");
                PLINK_Open.this.remoteChooser.addFileChoosenListener(new GCFileChooser.FileChoosenListener(){

                    public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                        PLINK_Open.this.remoteProject.setText(((PLINK_Open)(this).PLINK_Open.this).remoteChooser.fileName);
                    }
                });
                PLINK_Open.this.remoteChooser.showChooser();
            }
        });
        this.remoteBrowse.setEnabled(false);
        ans.add(new JLabel("Remote Project:"));
        ans.add(this.remoteProject);
        ans.add(this.remoteBrowse);
        return ans;
    }

    private JPanel createButton() {
        this.logger.info("(createButton()) Create the panel");
        JPanel ans = new JPanel();
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PLINK_Open.this.logger.info("[createButton()] The ok button is activated");
                if (((PLINK_Open)PLINK_Open.this).parent.data != null) {
                    ((PLINK_Open)PLINK_Open.this).parent.data.properClosing();
                    ((PLINK_Open)PLINK_Open.this).parent.data = null;
                }
                ((PLINK_Open)PLINK_Open.this).parent.data = PLINK_Open.this.remoteFlag.isSelected() ? new Project(PLINK_Open.this.parent, PLINK_Open.this.localProject.getText(), PLINK_Open.this.remoteProject.getText(), PLINK_Open.this.host.getText(), PLINK_Open.this.user.getText(), PLINK_Open.this.port.getText(), PLINK_Open.this.conn) : new Project(PLINK_Open.this.parent, PLINK_Open.this.localProject.getText());
                PLINK_Open.this.parent.layoutPanels(((PLINK_Open)PLINK_Open.this).parent.data);
                PLINK_Open.this.dispose();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((PLINK_Open)PLINK_Open.this).parent.data != null) {
                    ((PLINK_Open)PLINK_Open.this).parent.data.properClosing();
                }
                ((PLINK_Open)PLINK_Open.this).parent.data = new Project(PLINK_Open.this.parent);
                PLINK_Open.this.parent.layoutPanels(((PLINK_Open)PLINK_Open.this).parent.data);
                PLINK_Open.this.dispose();
            }
        });
        ans.add(this.ok);
        ans.add(cancel);
        return ans;
    }

    public PLINK_Open(GPLINK p) {
        super((Frame)p, "Open project");
        this.logger.info("PLINK_Open(GPLINK) Starting the constructor");
        this.parent = p;
        this.remotePanel = new JPanel();
        this.remotePanel.setLayout(new BoxLayout(this.remotePanel, 3));
        this.remotePanel.add(this.createConnection());
        this.remotePanel.add(this.createRemote());
        this.remotePanel.setVisible(false);
        this.getRootPane().setLayout(new BoxLayout(this.getRootPane(), 3));
        this.getRootPane().add(this.createLocal());
        this.getRootPane().add(this.createRemoteFlag());
        this.getRootPane().add(new JSeparator());
        this.getRootPane().add(this.remotePanel);
        this.getRootPane().add(this.createButton());
        this.checkButtons();
        this.remoteProject.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                PLINK_Open.this.checkButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                PLINK_Open.this.checkButtons();
            }
        });
        this.localProject.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                PLINK_Open.this.checkButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                PLINK_Open.this.checkButtons();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public PLINK_Open(GPLINK f, String local) {
        this(f);
        this.localProject.setText(local);
    }

    public PLINK_Open(GPLINK f, String local, String givenRemote, String givenHost, String givenUser, String givenPort) {
        this(f);
        this.localProject.setText(local);
        this.remoteFlag.setSelected(true);
        this.remoteProject.setText(givenRemote);
        this.host.setText(givenHost);
        this.user.setText(givenUser);
        this.port.setText(givenPort);
    }

    private class gCLINEFilter
    extends FileFilter {
        private gCLINEFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }

        public String getDescription() {
            return "directory";
        }
    }
}

