/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2;

import edu.harvard.mgh.purcell.gCLINE.general.Configure;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.data.Project;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class PLINK_Config
extends Configure {
    private JTextField plinkPath;
    private JTextField plinkPrefix;
    private JTextField haploPath;
    private JTextField haploAppend;
    private Project data;
    private GPLINK frame;

    public PLINK_Config(GPLINK f) {
        super(f.data);
        this.data = f.data;
        this.frame = f;
        this.plinkPath = new JTextField(this.data.getPlinkPath(), 30);
        this.plinkPrefix = new JTextField(this.data.getPlinkPrefix(), 10);
        this.haploPath = new JTextField(this.data.getHaploPath(), 30);
        this.haploAppend = new JTextField(this.data.getHaploAppend(), 10);
        this.getRootPane().add((Component)this.createFormSpecific(), 1);
    }

    protected JPanel createFormSpecific() {
        JPanel ans = new JPanel();
        ans.setLayout(new BoxLayout(ans, 3));
        ans.add(this.createHaplo());
        ans.add(this.createPlink());
        return ans;
    }

    private JPanel createHaplo() {
        JPanel ans = new JPanel();
        ans.setLayout(new BoxLayout(ans, 3));
        ans.setBorder(new TitledBorder("Haploview settings"));
        JPanel temp1 = new JPanel();
        temp1.add(new JLabel("Haploview path:"));
        temp1.add(this.haploPath);
        temp1.add(new BrowseButton(this.haploPath, true));
        JPanel temp2 = new JPanel();
        temp2.add(new JLabel("Haploview append:"));
        temp2.add(this.haploAppend);
        ans.add(temp1);
        ans.add(temp2);
        return ans;
    }

    private JPanel createPlink() {
        JPanel ans = new JPanel();
        ans.setLayout(new BoxLayout(ans, 3));
        ans.setBorder(new TitledBorder("PLINK settings"));
        JPanel temp1 = new JPanel();
        temp1.add(new JLabel("PLINK path:"));
        temp1.add(this.plinkPath);
        temp1.add(new BrowseButton(this.plinkPath));
        JPanel temp2 = new JPanel();
        temp2.add(new JLabel("PLINK prefix:"));
        temp2.add(this.plinkPrefix);
        ans.add(temp2);
        ans.add(temp1);
        return ans;
    }

    public void process() {
        if (this.data.isRemote()) {
            if (!new Integer(this.data.getRemoteUpdateSec()).toString().equals(this.updateField.getText())) {
                this.data.setRemoteUpdateSec(new Integer(this.updateField.getText()));
                this.frame.layoutPanels(this.data);
            }
        } else if (!new Integer(this.data.getLocalUpdateSec()).toString().equals(this.updateField.getText())) {
            this.data.setLocalUpdateSec(new Integer(this.updateField.getText()));
            this.frame.layoutPanels(this.data);
        }
        this.data.setAltEditor(this.editor.getText());
        this.data.setPlinkPath(this.plinkPath.getText());
        this.data.setPlinkPrefix(this.plinkPrefix.getText());
        this.data.setHaploAppend(this.haploAppend.getText());
        this.data.setHaploPath(this.haploPath.getText());
        this.data.saveConfig();
    }

    private class BrowseButton
    extends JButton {
        private JTextField target;
        private GCFileChooser pick;
        private boolean flagLocal;

        BrowseButton(JTextField givenTarget) {
            super("Browse");
            this.target = givenTarget;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowseButton.this.pick = new GCFileChooser(PLINK_Config.this, null, !PLINK_Config.this.data.isRemote(), false, PLINK_Config.this.data.getConn(), PLINK_Config.this.data.getHomeFolder());
                    BrowseButton.this.pick.addFileChoosenListener(new GCFileChooser.FileChoosenListener(this){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                            BrowseButton.access$2(1.access$0(this.this$2)).setText(BrowseButton.access$1((BrowseButton)1.access$0(this.this$2)).fileName);
                        }
                    });
                    BrowseButton.this.pick.showChooser();
                }

                static /* synthetic */ BrowseButton access$0(1 var0) {
                    return var0.BrowseButton.this;
                }
            });
        }

        BrowseButton(JTextField givenTarget, boolean local) {
            super("Browse");
            this.target = givenTarget;
            this.flagLocal = local;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowseButton.this.pick = new GCFileChooser(PLINK_Config.this, null, BrowseButton.this.flagLocal, false, null, PLINK_Config.this.data.getHomeFolder());
                    BrowseButton.this.pick.addFileChoosenListener(new GCFileChooser.FileChoosenListener(this){
                        final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                            BrowseButton.access$2(2.access$0(this.this$2)).setText(BrowseButton.access$1((BrowseButton)2.access$0(this.this$2)).fileName);
                        }
                    });
                    BrowseButton.this.pick.showChooser();
                }

                static /* synthetic */ BrowseButton access$0(2 var0) {
                    return var0.BrowseButton.this;
                }
            });
        }

        static /* synthetic */ JTextField access$2(BrowseButton browseButton) {
            return browseButton.target;
        }
    }
}

