/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.data;

import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.general.ErrorManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class Lock {
    public static String UNLOCKED_KEY = "";
    private Logger logger = Logger.getLogger(Lock.class);
    private ErrorManager error;
    private String key;
    private File lockFile;
    private String remoteFile;
    private Record data;
    private StartFrame frame;

    public Lock(StartFrame givenFrame, Record d) {
        this.logger.info("[Lock(StartFrame, Record)] Entering.");
        this.frame = givenFrame;
        this.data = d;
        if (this.data.isRemote()) {
            this.remoteFile = String.valueOf(this.data.getRemoteFolder()) + ".lock_gPLINK";
            this.logger.info("[Lock(StartFrame, Record)] data is remote");
        } else {
            this.remoteFile = null;
        }
        this.lockFile = new File(this.data.getLocalFolder(), ".lock_gPLINK");
        this.error = this.frame.messanger;
        try {
            this.lockFile.createNewFile();
        }
        catch (IOException e1) {
            this.error.createError("Error creating lock file [" + this.lockFile.getAbsolutePath() + "] \n ------------------ \n" + e1.getMessage(), "Lock@Lock.java");
            this.logger.error("(Lock())Error creating lock file [" + this.lockFile.getAbsolutePath() + "]");
        }
        this.key = Integer.valueOf((int)(Math.random() * 1.0E8)).toString();
        this.logger.info("[Lock(StartFrame, Record)] key set: " + this.key);
        this.logger.info("[Lock(StartFrame, Record)] reading lock now");
        this.readLock();
        this.logger.info("[Lock(StartFrame, Record)] ...exiting");
    }

    public boolean availableLock() {
        String lock = this.readLock();
        this.logger.info("[availableLock()] checking avaliablity, lock: " + lock + "== unlock: " + UNLOCKED_KEY);
        return lock == null || lock.equals(UNLOCKED_KEY);
    }

    public boolean hasLock() {
        String lock = this.readLock();
        this.logger.info("[hasLock()] checking owner, lock: " + lock + "== key: " + this.getKey());
        return lock != null && lock.equals(this.getKey());
    }

    public boolean stealLock() {
        this.logger.info("[stealLock()] entering stealing lock");
        int responce = JOptionPane.showConfirmDialog(this.frame, "Another instance of gPLINK has locked this project.\nEither gPLINK is open elsewhere, or the last instance did not close cleanly.\nUnless you think somebody else is currently working on this project, select Yes\nOtherwise it will open in Browse-only mode\nDo you wish to steal it?");
        if (responce == 0) {
            if (!this.lockFile()) {
                this.logger.warn("[stealLock()] unable to steal lock file (1)");
                return false;
            }
            this.logger.info("[stealLock()] stolen lock file sucessfull");
            return true;
        }
        this.logger.warn("[stealLock()] unable to steal lock file (2)");
        return false;
    }

    private String getKey() {
        this.logger.info("[getKey()] Getting key: [" + this.key + "]");
        return this.key;
    }

    private String readLock() {
        if (this.data.isRemote()) {
            StartFrame startFrame = this.frame;
            startFrame.getClass();
            new StartFrame.Download(startFrame, this.data, true, this.data.getLocalFolder(), new String[]{this.remoteFile}).run();
        }
        String lock = "";
        if (!this.lockFile.isFile()) {
            this.logger.info("[readLock()] not a file! returning lock: " + lock);
            return lock;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.lockFile));
            lock = in.readLine();
            in.close();
        }
        catch (IOException e) {
            this.error.createError("Error trying to read in local lock.", "readLock@Lock.java");
        }
        this.logger.info("[readLock()] returning lock: " + lock);
        return lock;
    }

    public boolean lockFile() {
        this.logger.info("[lockFile()] locking " + this.lockFile.getAbsolutePath() + " with " + this.key);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.lockFile));
            out.write(this.key);
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            this.logger.error("[lockFile()] Error writing the lock file locally.");
            return false;
        }
        if (this.data.isRemote()) {
            StartFrame startFrame = this.frame;
            startFrame.getClass();
            new StartFrame.Upload(startFrame, this.data, false, this.data.getRemoteFolder(), new File[]{this.lockFile}).run();
        }
        this.logger.info("[lockFile()] Exiting locking, " + this.lockFile.getAbsolutePath() + " is:" + this.readLock());
        return true;
    }

    public boolean unlockFile() {
        this.logger.info("[unlockFile()] unlocking " + this.lockFile.getAbsolutePath() + " with \"" + UNLOCKED_KEY + "\"");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.lockFile));
            out.write(UNLOCKED_KEY);
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            this.logger.error("[unLock()] Error writing the unlock file locally.");
            return false;
        }
        if (this.data.isRemote()) {
            StartFrame startFrame = this.frame;
            startFrame.getClass();
            new StartFrame.Upload(startFrame, this.data, false, this.data.getRemoteFolder(), new File[]{this.lockFile}).run();
        }
        return true;
    }
}

