/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE;

import edu.harvard.mgh.purcell.gCLINE.TransfureFiles;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.general.ErrorManager;
import edu.harvard.mgh.purcell.gCLINE.pane.FileView;
import edu.harvard.mgh.purcell.gCLINE.pane.FolderView;
import edu.harvard.mgh.purcell.gCLINE.pane.OpView;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class StartFrame
extends JFrame {
    private static Logger logger = Logger.getLogger(StartFrame.class);
    protected FileView fileViewer;
    public FolderView folderViewer;
    protected OpView opViewer;
    public String version;
    public ErrorManager messanger;
    protected JLabel statusBar;
    protected Vector<String> filesInTransit;
    public ActionListener closing;
    public WindowListener properClosing;
    protected boolean isBrowseOnly;

    protected abstract void setVersion();

    public abstract void layoutPanels();

    public abstract void setBrowseOnly(boolean var1);

    public boolean getBrowseOnly() {
        return this.isBrowseOnly;
    }

    public StartFrame(String name) {
        super(name);
        BasicConfigurator.configure();
        Logger.getLogger("com.sshtools").setLevel(Level.OFF);
        Logger.getLogger("edu.harvard.mgh.purcell.gCLINE").setLevel(Level.OFF);
        this.messanger = new ErrorManager(this);
        this.statusBar = new JLabel("Ready!");
        this.setBrowseOnly(false);
        this.setVersion();
        this.layoutPanels();
    }

    public void setFileViewer(File givenFile) {
        if (givenFile != null) {
            this.fileViewer.viewFile(givenFile.getAbsolutePath());
        } else {
            logger.info("(setFileViewer(File)) the given file is null.");
        }
    }

    private synchronized void setStatus(String message) {
        this.statusBar.setText(message);
    }

    private synchronized void changeTransitFile(String[] files, boolean addFile) {
        String s;
        int n;
        int n2;
        String[] stringArray;
        if (addFile) {
            stringArray = files;
            n2 = 0;
            n = stringArray.length;
            while (n2 < n) {
                s = stringArray[n2];
                this.filesInTransit.add(s);
                ++n2;
            }
        } else {
            stringArray = files;
            n2 = 0;
            n = stringArray.length;
            while (n2 < n) {
                s = stringArray[n2];
                this.filesInTransit.remove(s);
                ++n2;
            }
        }
        if (this.filesInTransit.isEmpty()) {
            this.setStatus("Ready!");
        } else {
            String message = "Down/Uploading: ";
            for (String file : this.filesInTransit) {
                message = String.valueOf(message) + " [" + file + "]";
            }
            logger.info("[changeTrasitFile(String[], boolean)] " + message);
            this.setStatus(message);
        }
    }

    public boolean inTransit(String f) {
        return this.filesInTransit.contains(f);
    }

    public class Download
    extends TransfureFiles {
        public Download(Record d, boolean ignoreFailure, File givenLocalFolder, String[] givenRemoteFiles) {
            super(d, ignoreFailure, givenLocalFolder, givenRemoteFiles);
        }

        public void run() {
            StartFrame.this.changeTransitFile(this.remoteFiles, true);
            super.run();
            StartFrame.this.changeTransitFile(this.remoteFiles, false);
        }
    }

    public class Upload
    extends TransfureFiles {
        public Upload(Record d, boolean ignoreFailure, String givenRemoteFolder, File[] givenLocalFiles) {
            super(d, ignoreFailure, givenRemoteFolder, givenLocalFiles);
            logger.info("[Upload(Record, boolean, String, File[])] ending");
        }

        public void run() {
            logger.info("[run()] starting");
            if (!StartFrame.this.getBrowseOnly()) {
                StartFrame.this.changeTransitFile(this.localFiles, true);
                super.run();
                StartFrame.this.changeTransitFile(this.localFiles, false);
            } else {
                new ErrorManager(StartFrame.this).createError("Can no upload files [" + this.localFiles[0] + "] when set in browse mode.", "run():Upload@StartFrame.java");
            }
            logger.info("[run()] ending");
        }
    }
}

