/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE;

import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class RestoreDataDialog
extends JDialog {
    private Logger logger = Logger.getLogger(RestoreDataDialog.class);
    JTextField fileField;
    private GCFileChooser localChooser;
    Record data;

    public RestoreDataDialog(JFrame parent, Record d) {
        super((Frame)parent, "Restore from xml");
        this.data = d;
        this.fileField = new JTextField(40);
        this.getRootPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        this.localChooser = new GCFileChooser(this, new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getAbsolutePath().endsWith(".xml");
            }

            public String getDescription() {
                return "XML file";
            }
        }, true, false, null, this.data.getLocalFolder().getAbsolutePath());
        this.localChooser.addFileChoosenListener(new GCFileChooser.FileChoosenListener(){

            public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                RestoreDataDialog.this.logger.info("(createLocal()) adding the localProject");
                RestoreDataDialog.this.fileField.setText(((RestoreDataDialog)RestoreDataDialog.this).localChooser.fileName);
            }
        });
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.getRootPane().add((Component)this.fileField, c);
        JButton browse = new JButton("Browse");
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RestoreDataDialog.this.localChooser.showChooser();
            }
        });
        c.weightx = 0.0;
        c.gridx = 1;
        this.getRootPane().add((Component)browse, c);
        JPanel buttons = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RestoreDataDialog.this.data.loadData(new File(RestoreDataDialog.this.fileField.getText()), RestoreDataDialog.this.data.getHomeFolder(), RestoreDataDialog.this.data.isRemote());
                RestoreDataDialog.this.dispose();
            }
        });
        buttons.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RestoreDataDialog.this.dispose();
            }
        });
        buttons.add(cancel);
        c.weightx = 1.0;
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 2;
        this.getRootPane().add((Component)buttons, c);
        this.pack();
        this.setVisible(true);
    }
}

