/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.configuration;

import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SshAPIConfiguration
extends DefaultHandler
implements com.sshtools.j2ssh.configuration.SshAPIConfiguration {
    private String defaultCipher = null;
    private String defaultMac = null;
    private String defaultCompression = null;
    private String defaultPublicKey = null;
    private String defaultKeyExchange = null;
    private List cipherExtensions = new ArrayList();
    private List macExtensions = new ArrayList();
    private List compressionExtensions = new ArrayList();
    private List pkExtensions = new ArrayList();
    private List kexExtensions = new ArrayList();
    private List authExtensions = new ArrayList();
    private List pkFormats = new ArrayList();
    private List prvFormats = new ArrayList();
    private String defaultPublicFormat = null;
    private String defaultPrivateFormat = null;
    private String currentElement = null;
    private String parentElement = null;
    private List currentList = null;
    private ExtensionAlgorithm currentExt = null;

    public SshAPIConfiguration(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        this.reload(in);
    }

    public void reload(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        this.defaultCipher = null;
        this.defaultMac = null;
        this.defaultCompression = null;
        this.defaultKeyExchange = null;
        this.defaultPublicKey = null;
        this.defaultPublicFormat = null;
        this.defaultPrivateFormat = null;
        this.cipherExtensions.clear();
        this.macExtensions.clear();
        this.compressionExtensions.clear();
        this.pkExtensions.clear();
        this.kexExtensions.clear();
        this.authExtensions.clear();
        this.pkFormats.clear();
        this.prvFormats.clear();
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)this);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if (this.currentElement != null) {
            if (this.currentElement.equals("AlgorithmName")) {
                if (this.currentExt == null) {
                    throw new SAXException("Unexpected AlgorithmName element!");
                }
                this.currentExt.setAlgorithmName(value);
                return;
            }
            if (this.currentElement.equals("ImplementationClass")) {
                if (this.currentExt == null) {
                    throw new SAXException("Unexpected ImplementationClass element!");
                }
                this.currentExt.setImplementationClass(value);
                return;
            }
            if (this.currentElement.equals("DefaultAlgorithm")) {
                if (this.parentElement.equals("CipherConfiguration")) {
                    this.defaultCipher = value;
                } else if (this.parentElement.equals("MacConfiguration")) {
                    this.defaultMac = value;
                } else if (this.parentElement.equals("CompressionConfiguration")) {
                    this.defaultCompression = value;
                } else if (this.parentElement.equals("PublicKeyConfiguration")) {
                    this.defaultPublicKey = value;
                } else if (this.parentElement.equals("KeyExchangeConfiguration")) {
                    this.defaultKeyExchange = value;
                } else {
                    throw new SAXException("Unexpected parent elemenet for DefaultAlgorithm element");
                }
            }
            if (this.currentElement.equals("DefaultPublicFormat")) {
                this.defaultPublicFormat = value;
            }
            if (this.currentElement.equals("DefaultPrivateFormat")) {
                this.defaultPrivateFormat = value;
            }
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.currentElement != null) {
            if (!this.currentElement.equals(qname)) {
                throw new SAXException("Unexpected end element found " + qname);
            }
            if (this.currentElement.equals("SshAPIConfiguration")) {
                this.currentElement = null;
            } else if (this.currentElement.equals("CipherConfiguration") || this.currentElement.equals("MacConfiguration") || this.currentElement.equals("PublicKeyConfiguration") || this.currentElement.equals("CompressionConfiguration") || this.currentElement.equals("KeyExchangeConfiguration") || this.currentElement.equals("AuthenticationConfiguration")) {
                this.currentList = null;
                this.currentElement = "SshAPIConfiguration";
            } else if (this.currentElement.equals("ExtensionAlgorithm")) {
                if (this.currentExt == null) {
                    throw new SAXException("Critical error, null extension algortihm");
                }
                if (this.currentExt.getAlgorithmName() == null || this.currentExt.getImplementationClass() == null) {
                    throw new SAXException("Unexpected end of ExtensionAlgorithm Element");
                }
                this.currentList.add(this.currentExt);
                this.currentExt = null;
                this.currentElement = this.parentElement;
            } else if (this.currentElement.equals("DefaultAlgorithm") || this.currentElement.equals("DefaultPublicFormat") || this.currentElement.equals("DefaultPrivateFormat") || this.currentElement.equals("PublicKeyFormat") || this.currentElement.equals("PrivateKeyFormat")) {
                this.currentElement = this.parentElement;
            } else if (this.currentElement.equals("AlgorithmName")) {
                this.currentElement = "ExtensionAlgorithm";
            } else if (this.currentElement.equals("ImplementationClass")) {
                this.currentElement = "ExtensionAlgorithm";
            } else {
                throw new SAXException("Unexpected end element " + qname);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        if (this.currentElement == null) {
            if (!qname.equals("SshAPIConfiguration")) {
                throw new SAXException("Unexpected root element " + qname);
            }
        } else if (this.currentElement.equals("SshAPIConfiguration")) {
            if (!(qname.equals("CipherConfiguration") || qname.equals("MacConfiguration") || qname.equals("CompressionConfiguration") || qname.equals("PublicKeyConfiguration") || qname.equals("AuthenticationConfiguration") || qname.equals("KeyExchangeConfiguration"))) {
                throw new SAXException("Unexpected <" + qname + "> element after SshAPIConfiguration");
            }
        } else if (this.currentElement.equals("CipherConfiguration")) {
            if (qname.equals("ExtensionAlgorithm")) {
                this.currentList = this.cipherExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else {
                if (!qname.equals("DefaultAlgorithm")) throw new SAXException("Unexpected element <" + qname + "> found after CipherConfiguration");
                this.parentElement = this.currentElement;
            }
        } else if (this.currentElement.equals("MacConfiguration")) {
            if (qname.equals("ExtensionAlgorithm")) {
                this.currentList = this.macExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else {
                if (!qname.equals("DefaultAlgorithm")) throw new SAXException("Unexpected element <" + qname + "> found after CipherConfiguration");
                this.parentElement = this.currentElement;
            }
        } else if (this.currentElement.equals("CompressionConfiguration")) {
            if (qname.equals("ExtensionAlgorithm")) {
                this.currentList = this.compressionExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else {
                if (!qname.equals("DefaultAlgorithm")) throw new SAXException("Unexpected element <" + qname + "> found after CompressionConfiguration");
                this.parentElement = this.currentElement;
            }
        } else if (this.currentElement.equals("PublicKeyConfiguration")) {
            if (qname.equals("ExtensionAlgorithm")) {
                this.currentList = this.pkExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else if (qname.equals("DefaultAlgorithm")) {
                this.parentElement = this.currentElement;
            } else if (qname.equals("PublicKeyFormat")) {
                String cls = attrs.getValue("ImplementationClass");
                if (cls == null) {
                    throw new SAXException("<PublicKeyFormat> element requries the ImplementationClass attribute");
                }
                this.pkFormats.add(cls);
            } else if (qname.equals("PrivateKeyFormat")) {
                String cls = attrs.getValue("ImplementationClass");
                if (cls == null) {
                    throw new SAXException("<PrivateKeyFormat> element requries the ImplementationClass attribute");
                }
                this.prvFormats.add(cls);
            } else if (qname.equals("DefaultPublicFormat")) {
                this.parentElement = this.currentElement;
            } else {
                if (!qname.equals("DefaultPrivateFormat")) throw new SAXException("Unexpected element <" + qname + "> found after PublicKeyConfiguration");
                this.parentElement = this.currentElement;
            }
        } else if (this.currentElement.equals("AuthenticationConfiguration")) {
            if (!qname.equals("ExtensionAlgorithm")) throw new SAXException("Unexpected element <" + qname + "> found after AuthenticationConfiguration");
            this.currentList = this.authExtensions;
            this.parentElement = this.currentElement;
            this.currentExt = new ExtensionAlgorithm();
        } else if (this.currentElement.equals("KeyExchangeConfiguration")) {
            if (qname.equals("ExtensionAlgorithm")) {
                this.currentList = this.kexExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else {
                if (!qname.equals("DefaultAlgorithm")) throw new SAXException("Unexpected element <" + qname + "> found after KeyExchangeConfiguration");
                this.parentElement = this.currentElement;
            }
        } else if (!(this.currentElement.equals("ExtensionAlgorithm") && qname.equals("AlgorithmName") || this.currentElement.equals("ExtensionAlgorithm") && qname.equals("ImplementationClass"))) {
            throw new SAXException("Unexpected element " + qname);
        }
        this.currentElement = qname;
    }

    public List getCompressionExtensions() {
        return this.compressionExtensions;
    }

    public List getCipherExtensions() {
        return this.cipherExtensions;
    }

    public List getMacExtensions() {
        return this.macExtensions;
    }

    public List getAuthenticationExtensions() {
        return this.authExtensions;
    }

    public List getPublicKeyExtensions() {
        return this.pkExtensions;
    }

    public List getKeyExchangeExtensions() {
        return this.kexExtensions;
    }

    public String getDefaultCipher() {
        return this.defaultCipher;
    }

    public String getDefaultMac() {
        return this.defaultMac;
    }

    public String getDefaultCompression() {
        return this.defaultCompression;
    }

    public String getDefaultPublicKey() {
        return this.defaultPublicKey;
    }

    public String getDefaultKeyExchange() {
        return this.defaultKeyExchange;
    }

    public String getDefaultPublicKeyFormat() {
        return this.defaultPublicFormat;
    }

    public String getDefaultPrivateKeyFormat() {
        return this.defaultPrivateFormat;
    }

    public List getPublicKeyFormats() {
        return this.pkFormats;
    }

    public List getPrivateKeyFormats() {
        return this.prvFormats;
    }

    public String toString() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = String.valueOf(xml) + "<!-- Sshtools J2SSH Configuration file -->\n";
        xml = String.valueOf(xml) + "<SshAPIConfiguration>\n";
        xml = String.valueOf(xml) + "   <!-- The Cipher configuration, add or overide default cipher implementations -->\n";
        xml = String.valueOf(xml) + "   <CipherConfiguration>\n";
        for (ExtensionAlgorithm ext : this.cipherExtensions) {
            xml = String.valueOf(xml) + "      <ExtensionAlgorithm>\n";
            xml = String.valueOf(xml) + "         <AlgorithmName>" + ext.getAlgorithmName() + "</AlgorithmName>\n";
            xml = String.valueOf(xml) + "         <ImplementationClass>" + ext.getImplementationClass() + "</ImplementationClass>\n";
            xml = String.valueOf(xml) + "      </ExtensionAlgorithm>\n";
        }
        xml = String.valueOf(xml) + "      <DefaultAlgorithm>" + this.defaultCipher + "</DefaultAlgorithm>\n";
        xml = String.valueOf(xml) + "   </CipherConfiguration>\n";
        xml = String.valueOf(xml) + "   <!-- The Mac configuration, add or overide default mac implementations -->\n";
        xml = String.valueOf(xml) + "   <MacConfiguration>\n";
        for (ExtensionAlgorithm ext : this.macExtensions) {
            xml = String.valueOf(xml) + "      <ExtensionAlgorithm>\n";
            xml = String.valueOf(xml) + "         <AlgorithmName>" + ext.getAlgorithmName() + "</AlgorithmName>\n";
            xml = String.valueOf(xml) + "         <ImplementationClass>" + ext.getImplementationClass() + "</ImplementationClass>\n";
            xml = String.valueOf(xml) + "      </ExtensionAlgorithm>\n";
        }
        xml = String.valueOf(xml) + "      <DefaultAlgorithm>" + this.defaultMac + "</DefaultAlgorithm>\n";
        xml = String.valueOf(xml) + "   </MacConfiguration>\n";
        xml = String.valueOf(xml) + "   <!-- The Compression configuration, add or overide default compression implementations -->\n";
        xml = String.valueOf(xml) + "   <CompressionConfiguration>\n";
        for (ExtensionAlgorithm ext : this.compressionExtensions) {
            xml = String.valueOf(xml) + "      <ExtensionAlgorithm>\n";
            xml = String.valueOf(xml) + "         <AlgorithmName>" + ext.getAlgorithmName() + "</AlgorithmName>\n";
            xml = String.valueOf(xml) + "         <ImplementationClass>" + ext.getImplementationClass() + "</ImplementationClass>\n";
            xml = String.valueOf(xml) + "      </ExtensionAlgorithm>\n";
        }
        xml = String.valueOf(xml) + "      <DefaultAlgorithm>" + this.defaultCompression + "</DefaultAlgorithm>\n";
        xml = String.valueOf(xml) + "   </CompressionConfiguration>\n";
        xml = String.valueOf(xml) + "   <!-- The Public Key configuration, add or overide default public key implementations -->\n";
        xml = String.valueOf(xml) + "   <PublicKeyConfiguration>\n";
        for (ExtensionAlgorithm ext : this.pkExtensions) {
            xml = String.valueOf(xml) + "      <ExtensionAlgorithm>\n";
            xml = String.valueOf(xml) + "         <AlgorithmName>" + ext.getAlgorithmName() + "</AlgorithmName>\n";
            xml = String.valueOf(xml) + "         <ImplementationClass>" + ext.getImplementationClass() + "</ImplementationClass>\n";
            xml = String.valueOf(xml) + "      </ExtensionAlgorithm>\n";
        }
        xml = String.valueOf(xml) + "      <DefaultAlgorithm>" + this.defaultPublicKey + "</DefaultAlgorithm>\n";
        for (String cls : this.pkFormats) {
            xml = String.valueOf(xml) + "      <PublicKeyFormat ImplementationClass=\"" + cls + "\"/>\n";
        }
        for (String cls : this.prvFormats) {
            xml = String.valueOf(xml) + "      <PrivateKeyFormat ImplementationClass=\"" + cls + "\"/>\n";
        }
        xml = String.valueOf(xml) + "      <DefaultPublicFormat>" + this.defaultPublicFormat + "</DefaultPublicFormat>\n";
        xml = String.valueOf(xml) + "      <DefaultPrivateFormat>" + this.defaultPrivateFormat + "</DefaultPrivateFormat>\n";
        xml = String.valueOf(xml) + "   </PublicKeyConfiguration>\n";
        xml = String.valueOf(xml) + "   <!-- The Key Exchange configuration, add or overide default key exchange implementations -->\n";
        xml = String.valueOf(xml) + "   <KeyExchangeConfiguration>\n";
        for (ExtensionAlgorithm ext : this.kexExtensions) {
            xml = String.valueOf(xml) + "      <ExtensionAlgorithm>\n";
            xml = String.valueOf(xml) + "         <AlgorithmName>" + ext.getAlgorithmName() + "</AlgorithmName>\n";
            xml = String.valueOf(xml) + "         <ImplementationClass>" + ext.getImplementationClass() + "</ImplementationClass>\n";
            xml = String.valueOf(xml) + "      </ExtensionAlgorithm>\n";
        }
        xml = String.valueOf(xml) + "      <DefaultAlgorithm>" + this.defaultKeyExchange + "</DefaultAlgorithm>\n";
        xml = String.valueOf(xml) + "   </KeyExchangeConfiguration>\n";
        xml = String.valueOf(xml) + "   <!-- The Authentication configuration, add or overide default authentication implementations -->\n";
        xml = String.valueOf(xml) + "   <AuthenticationConfiguration>\n";
        for (ExtensionAlgorithm ext : this.authExtensions) {
            xml = String.valueOf(xml) + "      <ExtensionAlgorithm>\n";
            xml = String.valueOf(xml) + "         <AlgorithmName>" + ext.getAlgorithmName() + "</AlgorithmName>\n";
            xml = String.valueOf(xml) + "         <ImplementationClass>" + ext.getImplementationClass() + "</ImplementationClass>\n";
            xml = String.valueOf(xml) + "      </ExtensionAlgorithm>\n";
        }
        xml = String.valueOf(xml) + "   </AuthenticationConfiguration>\n";
        xml = String.valueOf(xml) + "</SshAPIConfiguration>";
        return xml;
    }
}

