/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.authentication;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordAuthenticationDialog
extends JDialog
implements SshAuthenticationPrompt {
    static final String KEY_ICON = "largecard.png";
    PasswordAuthenticationClient instance;
    JButton jButtonCancel = new JButton();
    JButton jButtonOK = new JButton();
    JPasswordField jPasswordField = new JPasswordField(20);
    XTextField jTextUsername = new XTextField(20);
    boolean userCancelled = false;

    public PasswordAuthenticationDialog() {
        super((Frame)null, "Password Authentication", true);
        this.init(null);
    }

    public PasswordAuthenticationDialog(Frame parent) {
        super(parent, "Password Authentication", true);
        this.init(parent);
    }

    public PasswordAuthenticationDialog(Dialog parent) {
        super(parent, "Password Authentication", true);
        this.init(parent);
    }

    public String getPassword() {
        return String.valueOf(this.jPasswordField.getPassword());
    }

    public String getUsername() {
        return this.jTextUsername.getText();
    }

    public void setUsername(String username) {
        if (username != null) {
            this.jTextUsername.setText(username);
        }
    }

    public void setInstance(SshAuthenticationClient instance) throws AuthenticationProtocolException {
        if (!(instance instanceof PasswordAuthenticationClient)) {
            throw new AuthenticationProtocolException("PasswordAuthenticationClient instance required");
        }
        this.instance = (PasswordAuthenticationClient)instance;
    }

    public boolean showPrompt(SshAuthenticationClient inst) throws AuthenticationProtocolException {
        if (inst instanceof PasswordAuthenticationClient) {
            this.instance = (PasswordAuthenticationClient)inst;
            if (this.instance.getUsername() != null) {
                this.jTextUsername.setText(this.instance.getUsername());
            }
            if (!this.jTextUsername.getText().equals("")) {
                this.jPasswordField.grabFocus();
            }
            UIUtil.positionComponent(0, this);
            this.setVisible(true);
            if (!this.userCancelled) {
                this.instance.setUsername(this.getUsername());
                this.instance.setPassword(this.getPassword());
                return true;
            }
            return false;
        }
        throw new AuthenticationProtocolException("PasswordAuthenticationClient instance required");
    }

    void init(Window parent) {
        this.setModal(true);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        if (parent != null) {
            try {
                Method m = this.getClass().getMethod("setLocationRelativeTo", parent.getClass());
                m.invoke((Object)this, parent);
            }
            catch (Throwable m) {
                // empty catch block
            }
        }
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.userCancelled = true;
        this.setVisible(false);
    }

    void jButtonOK_actionPerformed(ActionEvent e) {
        if (this.jTextUsername.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, "You must enter a username!", "Password Authentication", 0);
            return;
        }
        this.setVisible(false);
    }

    void jbInit() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PasswordAuthenticationDialog.this.userCancelled = true;
            }
        });
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PasswordAuthenticationDialog.this.jButtonOK_actionPerformed(e);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setMnemonic('o');
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PasswordAuthenticationDialog.this.jButtonCancel_actionPerformed(e);
            }
        });
        JPanel userPasswordPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 2, 2, 2);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(userPasswordPanel, new JLabel("User"), gbc, 0);
        gbc.fill = 2;
        UIUtil.jGridBagAdd(userPasswordPanel, this.jTextUsername, gbc, 0);
        gbc.fill = 0;
        UIUtil.jGridBagAdd(userPasswordPanel, new JLabel("Password"), gbc, 0);
        gbc.fill = 2;
        UIUtil.jGridBagAdd(userPasswordPanel, this.jPasswordField, gbc, 0);
        gbc.fill = 0;
        IconWrapperPanel centerPanel = new IconWrapperPanel(new ResourceIcon(PasswordAuthenticationDialog.class, KEY_ICON), userPasswordPanel);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(6, 6, 0, 0);
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(buttonPanel, this.jButtonOK, gbc, -1);
        UIUtil.jGridBagAdd(buttonPanel, this.jButtonCancel, gbc, 0);
        JPanel southPanel = new JPanel(new FlowLayout(2, 0, 0));
        southPanel.add(buttonPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)southPanel, "South");
        this.getContentPane().add(mainPanel);
        this.jPasswordField.grabFocus();
    }
}

