// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dataportability provides access to the Data Portability API.
//
// For product documentation, see: https://developers.google.com/data-portability
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/dataportability/v1"
//	...
//	ctx := context.Background()
//	dataportabilityService, err := dataportability.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	dataportabilityService, err := dataportability.NewService(ctx, option.WithScopes(dataportability.DataportabilityYoutubeUnlistedVideosScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	dataportabilityService, err := dataportability.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	dataportabilityService, err := dataportability.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package dataportability // import "google.golang.org/api/dataportability/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "dataportability:v1"
const apiName = "dataportability"
const apiVersion = "v1"
const basePath = "https://dataportability.googleapis.com/"
const basePathTemplate = "https://dataportability.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://dataportability.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Move a copy of the Google Alerts subscriptions you created
	DataportabilityAlertsSubscriptionsScope = "https://www.googleapis.com/auth/dataportability.alerts.subscriptions"

	// Move a copy of messages between you and the businesses you have
	// conversations with across Google services
	DataportabilityBusinessmessagingConversationsScope = "https://www.googleapis.com/auth/dataportability.businessmessaging.conversations"

	// Move a copy of the information you entered into online forms in Chrome
	DataportabilityChromeAutofillScope = "https://www.googleapis.com/auth/dataportability.chrome.autofill"

	// Move a copy of pages you bookmarked in Chrome
	DataportabilityChromeBookmarksScope = "https://www.googleapis.com/auth/dataportability.chrome.bookmarks"

	// Move a copy of words you added to Chrome's dictionary
	DataportabilityChromeDictionaryScope = "https://www.googleapis.com/auth/dataportability.chrome.dictionary"

	// Move a copy of extensions you installed from the Chrome Web Store
	DataportabilityChromeExtensionsScope = "https://www.googleapis.com/auth/dataportability.chrome.extensions"

	// Move a copy of sites you visited in Chrome
	DataportabilityChromeHistoryScope = "https://www.googleapis.com/auth/dataportability.chrome.history"

	// Move a copy of pages you added to your reading list in Chrome
	DataportabilityChromeReadingListScope = "https://www.googleapis.com/auth/dataportability.chrome.reading_list"

	// Move a copy of your settings in Chrome
	DataportabilityChromeSettingsScope = "https://www.googleapis.com/auth/dataportability.chrome.settings"

	// Move a copy of searches and sites you follow, saved by Discover
	DataportabilityDiscoverFollowsScope = "https://www.googleapis.com/auth/dataportability.discover.follows"

	// Move a copy of links to your liked documents, saved by Discover
	DataportabilityDiscoverLikesScope = "https://www.googleapis.com/auth/dataportability.discover.likes"

	// Move a copy of content you marked as not interested, saved by Discover
	DataportabilityDiscoverNotInterestedScope = "https://www.googleapis.com/auth/dataportability.discover.not_interested"

	// Move a copy of the places you labeled on Maps
	DataportabilityMapsAliasedPlacesScope = "https://www.googleapis.com/auth/dataportability.maps.aliased_places"

	// Move a copy of your pinned trips on Maps
	DataportabilityMapsCommuteRoutesScope = "https://www.googleapis.com/auth/dataportability.maps.commute_routes"

	// Move a copy of your commute settings on Maps
	DataportabilityMapsCommuteSettingsScope = "https://www.googleapis.com/auth/dataportability.maps.commute_settings"

	// Move a copy of your electric vehicle profile on Maps
	DataportabilityMapsEvProfileScope = "https://www.googleapis.com/auth/dataportability.maps.ev_profile"

	// Move a copy of the corrections you made to places or map information on Maps
	DataportabilityMapsFactualContributionsScope = "https://www.googleapis.com/auth/dataportability.maps.factual_contributions"

	// Move a copy of your updates to places on Maps
	DataportabilityMapsOfferingContributionsScope = "https://www.googleapis.com/auth/dataportability.maps.offering_contributions"

	// Move a copy of the photos and videos you posted on Maps
	DataportabilityMapsPhotosVideosScope = "https://www.googleapis.com/auth/dataportability.maps.photos_videos"

	// Move a copy of the questions and answers you posted on Maps
	DataportabilityMapsQuestionsAnswersScope = "https://www.googleapis.com/auth/dataportability.maps.questions_answers"

	// Move a copy of your reviews and posts on Maps
	DataportabilityMapsReviewsScope = "https://www.googleapis.com/auth/dataportability.maps.reviews"

	// Move a copy of your Starred places list on Maps
	DataportabilityMapsStarredPlacesScope = "https://www.googleapis.com/auth/dataportability.maps.starred_places"

	// Move a copy of your vehicle profile on Maps
	DataportabilityMapsVehicleProfileScope = "https://www.googleapis.com/auth/dataportability.maps.vehicle_profile"

	// Move a copy of your Maps activity
	DataportabilityMyactivityMapsScope = "https://www.googleapis.com/auth/dataportability.myactivity.maps"

	// Move a copy of your My Ad Center activity
	DataportabilityMyactivityMyadcenterScope = "https://www.googleapis.com/auth/dataportability.myactivity.myadcenter"

	// Move a copy of your Google Play activity
	DataportabilityMyactivityPlayScope = "https://www.googleapis.com/auth/dataportability.myactivity.play"

	// Move a copy of your Google Search activity
	DataportabilityMyactivitySearchScope = "https://www.googleapis.com/auth/dataportability.myactivity.search"

	// Move a copy of your Shopping activity
	DataportabilityMyactivityShoppingScope = "https://www.googleapis.com/auth/dataportability.myactivity.shopping"

	// Move a copy of your YouTube activity
	DataportabilityMyactivityYoutubeScope = "https://www.googleapis.com/auth/dataportability.myactivity.youtube"

	// Move a copy of the maps you created in My Maps
	DataportabilityMymapsMapsScope = "https://www.googleapis.com/auth/dataportability.mymaps.maps"

	// Move a copy of your food purchase and reservation activity
	DataportabilityOrderReservePurchasesReservationsScope = "https://www.googleapis.com/auth/dataportability.order_reserve.purchases_reservations"

	// Move a copy of information about your devices with Google Play Store
	// installed
	DataportabilityPlayDevicesScope = "https://www.googleapis.com/auth/dataportability.play.devices"

	// Move a copy of your Google Play Store Grouping tags created by app
	// developers
	DataportabilityPlayGroupingScope = "https://www.googleapis.com/auth/dataportability.play.grouping"

	// Move a copy of your Google Play Store app installations
	DataportabilityPlayInstallsScope = "https://www.googleapis.com/auth/dataportability.play.installs"

	// Move a copy of your Google Play Store downloads, including books, games, and
	// apps
	DataportabilityPlayLibraryScope = "https://www.googleapis.com/auth/dataportability.play.library"

	// Move a copy of information about your Google Play Store Points
	DataportabilityPlayPlaypointsScope = "https://www.googleapis.com/auth/dataportability.play.playpoints"

	// Move a copy of information about your Google Play Store promotions
	DataportabilityPlayPromotionsScope = "https://www.googleapis.com/auth/dataportability.play.promotions"

	// Move a copy of your Google Play Store purchases
	DataportabilityPlayPurchasesScope = "https://www.googleapis.com/auth/dataportability.play.purchases"

	// Move a copy of your Google Play Store redemption activities
	DataportabilityPlayRedemptionsScope = "https://www.googleapis.com/auth/dataportability.play.redemptions"

	// Move a copy of your Google Play Store subscriptions
	DataportabilityPlaySubscriptionsScope = "https://www.googleapis.com/auth/dataportability.play.subscriptions"

	// Move a copy of your Google Play Store user settings and preferences
	DataportabilityPlayUsersettingsScope = "https://www.googleapis.com/auth/dataportability.play.usersettings"

	// Move a copy of your saved links, images, places, and collections from your
	// use of Google services
	DataportabilitySavedCollectionsScope = "https://www.googleapis.com/auth/dataportability.saved.collections"

	// Move a copy of your comments on Google Search
	DataportabilitySearchUgcCommentsScope = "https://www.googleapis.com/auth/dataportability.search_ugc.comments"

	// Move a copy of your media reviews on Google Search
	DataportabilitySearchUgcMediaReviewsAndStarsScope = "https://www.googleapis.com/auth/dataportability.search_ugc.media.reviews_and_stars"

	// Move a copy of your self-reported video streaming provider preferences from
	// Google Search and Google TV
	DataportabilitySearchUgcMediaStreamingVideoProvidersScope = "https://www.googleapis.com/auth/dataportability.search_ugc.media.streaming_video_providers"

	// Move a copy of your indicated thumbs up and thumbs down on media in Google
	// Search and Google TV
	DataportabilitySearchUgcMediaThumbsScope = "https://www.googleapis.com/auth/dataportability.search_ugc.media.thumbs"

	// Move a copy of information about the movies and TV shows you marked as
	// watched on Google Search and Google TV
	DataportabilitySearchUgcMediaWatchedScope = "https://www.googleapis.com/auth/dataportability.search_ugc.media.watched"

	// Move a copy of your notification settings on the Google Search app
	DataportabilitySearchnotificationsSettingsScope = "https://www.googleapis.com/auth/dataportability.searchnotifications.settings"

	// Move a copy of your notification subscriptions on Google Search app
	DataportabilitySearchnotificationsSubscriptionsScope = "https://www.googleapis.com/auth/dataportability.searchnotifications.subscriptions"

	// Move a copy of your shipping information on Shopping
	DataportabilityShoppingAddressesScope = "https://www.googleapis.com/auth/dataportability.shopping.addresses"

	// Move a copy of reviews you wrote about products or online stores on Google
	// Search
	DataportabilityShoppingReviewsScope = "https://www.googleapis.com/auth/dataportability.shopping.reviews"

	// Move a copy of the images and videos you uploaded to Street View
	DataportabilityStreetviewImageryScope = "https://www.googleapis.com/auth/dataportability.streetview.imagery"

	// Move a copy of information about your YouTube channel
	DataportabilityYoutubeChannelScope = "https://www.googleapis.com/auth/dataportability.youtube.channel"

	// Move a copy of your YouTube clips metadata
	DataportabilityYoutubeClipsScope = "https://www.googleapis.com/auth/dataportability.youtube.clips"

	// Move a copy of your YouTube comments
	DataportabilityYoutubeCommentsScope = "https://www.googleapis.com/auth/dataportability.youtube.comments"

	// Move a copy of your YouTube messages in live chat
	DataportabilityYoutubeLiveChatScope = "https://www.googleapis.com/auth/dataportability.youtube.live_chat"

	// Move a copy of your uploaded YouTube music tracks and your YouTube music
	// library
	DataportabilityYoutubeMusicScope = "https://www.googleapis.com/auth/dataportability.youtube.music"

	// Move a copy of your YouTube playables saved game progress files
	DataportabilityYoutubePlayableScope = "https://www.googleapis.com/auth/dataportability.youtube.playable"

	// Move a copy of your YouTube posts
	DataportabilityYoutubePostsScope = "https://www.googleapis.com/auth/dataportability.youtube.posts"

	// Move a copy of your YouTube private playlists
	DataportabilityYoutubePrivatePlaylistsScope = "https://www.googleapis.com/auth/dataportability.youtube.private_playlists"

	// Move a copy of your private YouTube videos and information about them
	DataportabilityYoutubePrivateVideosScope = "https://www.googleapis.com/auth/dataportability.youtube.private_videos"

	// Move a copy of your public YouTube playlists
	DataportabilityYoutubePublicPlaylistsScope = "https://www.googleapis.com/auth/dataportability.youtube.public_playlists"

	// Move a copy of your public YouTube videos and information about them
	DataportabilityYoutubePublicVideosScope = "https://www.googleapis.com/auth/dataportability.youtube.public_videos"

	// Move a copy of your YouTube shopping wishlists, and wishlist items
	DataportabilityYoutubeShoppingScope = "https://www.googleapis.com/auth/dataportability.youtube.shopping"

	// Move a copy of your YouTube channel subscriptions, even if they're private
	DataportabilityYoutubeSubscriptionsScope = "https://www.googleapis.com/auth/dataportability.youtube.subscriptions"

	// Move a copy of your unlisted YouTube playlists
	DataportabilityYoutubeUnlistedPlaylistsScope = "https://www.googleapis.com/auth/dataportability.youtube.unlisted_playlists"

	// Move a copy of your unlisted YouTube videos and information about them
	DataportabilityYoutubeUnlistedVideosScope = "https://www.googleapis.com/auth/dataportability.youtube.unlisted_videos"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/dataportability.alerts.subscriptions",
		"https://www.googleapis.com/auth/dataportability.businessmessaging.conversations",
		"https://www.googleapis.com/auth/dataportability.chrome.autofill",
		"https://www.googleapis.com/auth/dataportability.chrome.bookmarks",
		"https://www.googleapis.com/auth/dataportability.chrome.dictionary",
		"https://www.googleapis.com/auth/dataportability.chrome.extensions",
		"https://www.googleapis.com/auth/dataportability.chrome.history",
		"https://www.googleapis.com/auth/dataportability.chrome.reading_list",
		"https://www.googleapis.com/auth/dataportability.chrome.settings",
		"https://www.googleapis.com/auth/dataportability.discover.follows",
		"https://www.googleapis.com/auth/dataportability.discover.likes",
		"https://www.googleapis.com/auth/dataportability.discover.not_interested",
		"https://www.googleapis.com/auth/dataportability.maps.aliased_places",
		"https://www.googleapis.com/auth/dataportability.maps.commute_routes",
		"https://www.googleapis.com/auth/dataportability.maps.commute_settings",
		"https://www.googleapis.com/auth/dataportability.maps.ev_profile",
		"https://www.googleapis.com/auth/dataportability.maps.factual_contributions",
		"https://www.googleapis.com/auth/dataportability.maps.offering_contributions",
		"https://www.googleapis.com/auth/dataportability.maps.photos_videos",
		"https://www.googleapis.com/auth/dataportability.maps.questions_answers",
		"https://www.googleapis.com/auth/dataportability.maps.reviews",
		"https://www.googleapis.com/auth/dataportability.maps.starred_places",
		"https://www.googleapis.com/auth/dataportability.maps.vehicle_profile",
		"https://www.googleapis.com/auth/dataportability.myactivity.maps",
		"https://www.googleapis.com/auth/dataportability.myactivity.myadcenter",
		"https://www.googleapis.com/auth/dataportability.myactivity.play",
		"https://www.googleapis.com/auth/dataportability.myactivity.search",
		"https://www.googleapis.com/auth/dataportability.myactivity.shopping",
		"https://www.googleapis.com/auth/dataportability.myactivity.youtube",
		"https://www.googleapis.com/auth/dataportability.mymaps.maps",
		"https://www.googleapis.com/auth/dataportability.order_reserve.purchases_reservations",
		"https://www.googleapis.com/auth/dataportability.play.devices",
		"https://www.googleapis.com/auth/dataportability.play.grouping",
		"https://www.googleapis.com/auth/dataportability.play.installs",
		"https://www.googleapis.com/auth/dataportability.play.library",
		"https://www.googleapis.com/auth/dataportability.play.playpoints",
		"https://www.googleapis.com/auth/dataportability.play.promotions",
		"https://www.googleapis.com/auth/dataportability.play.purchases",
		"https://www.googleapis.com/auth/dataportability.play.redemptions",
		"https://www.googleapis.com/auth/dataportability.play.subscriptions",
		"https://www.googleapis.com/auth/dataportability.play.usersettings",
		"https://www.googleapis.com/auth/dataportability.saved.collections",
		"https://www.googleapis.com/auth/dataportability.search_ugc.comments",
		"https://www.googleapis.com/auth/dataportability.search_ugc.media.reviews_and_stars",
		"https://www.googleapis.com/auth/dataportability.search_ugc.media.streaming_video_providers",
		"https://www.googleapis.com/auth/dataportability.search_ugc.media.thumbs",
		"https://www.googleapis.com/auth/dataportability.search_ugc.media.watched",
		"https://www.googleapis.com/auth/dataportability.searchnotifications.settings",
		"https://www.googleapis.com/auth/dataportability.searchnotifications.subscriptions",
		"https://www.googleapis.com/auth/dataportability.shopping.addresses",
		"https://www.googleapis.com/auth/dataportability.shopping.reviews",
		"https://www.googleapis.com/auth/dataportability.streetview.imagery",
		"https://www.googleapis.com/auth/dataportability.youtube.channel",
		"https://www.googleapis.com/auth/dataportability.youtube.clips",
		"https://www.googleapis.com/auth/dataportability.youtube.comments",
		"https://www.googleapis.com/auth/dataportability.youtube.live_chat",
		"https://www.googleapis.com/auth/dataportability.youtube.music",
		"https://www.googleapis.com/auth/dataportability.youtube.playable",
		"https://www.googleapis.com/auth/dataportability.youtube.posts",
		"https://www.googleapis.com/auth/dataportability.youtube.private_playlists",
		"https://www.googleapis.com/auth/dataportability.youtube.private_videos",
		"https://www.googleapis.com/auth/dataportability.youtube.public_playlists",
		"https://www.googleapis.com/auth/dataportability.youtube.public_videos",
		"https://www.googleapis.com/auth/dataportability.youtube.shopping",
		"https://www.googleapis.com/auth/dataportability.youtube.subscriptions",
		"https://www.googleapis.com/auth/dataportability.youtube.unlisted_playlists",
		"https://www.googleapis.com/auth/dataportability.youtube.unlisted_videos",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.AccessType = NewAccessTypeService(s)
	s.ArchiveJobs = NewArchiveJobsService(s)
	s.Authorization = NewAuthorizationService(s)
	s.PortabilityArchive = NewPortabilityArchiveService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	AccessType *AccessTypeService

	ArchiveJobs *ArchiveJobsService

	Authorization *AuthorizationService

	PortabilityArchive *PortabilityArchiveService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccessTypeService(s *Service) *AccessTypeService {
	rs := &AccessTypeService{s: s}
	return rs
}

type AccessTypeService struct {
	s *Service
}

func NewArchiveJobsService(s *Service) *ArchiveJobsService {
	rs := &ArchiveJobsService{s: s}
	return rs
}

type ArchiveJobsService struct {
	s *Service
}

func NewAuthorizationService(s *Service) *AuthorizationService {
	rs := &AuthorizationService{s: s}
	return rs
}

type AuthorizationService struct {
	s *Service
}

func NewPortabilityArchiveService(s *Service) *PortabilityArchiveService {
	rs := &PortabilityArchiveService{s: s}
	return rs
}

type PortabilityArchiveService struct {
	s *Service
}

// CancelPortabilityArchiveRequest: Request to cancel a Portability Archive
// job.
type CancelPortabilityArchiveRequest struct {
}

// CancelPortabilityArchiveResponse: Response to canceling a Data Portability
// Archive job.
type CancelPortabilityArchiveResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// CheckAccessTypeRequest: Request to check the token's access type. All
// required information is derived from the attached OAuth token.
type CheckAccessTypeRequest struct {
}

// CheckAccessTypeResponse: Response to checking the token's access type.
type CheckAccessTypeResponse struct {
	// OneTimeResources: Jobs initiated with this token will be one-time if any
	// requested resources have one-time access.
	OneTimeResources []string `json:"oneTimeResources,omitempty"`
	// TimeBasedResources: Jobs initiated with this token will be time-based if all
	// requested resources have time-based access.
	TimeBasedResources []string `json:"timeBasedResources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "OneTimeResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OneTimeResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckAccessTypeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckAccessTypeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// InitiatePortabilityArchiveRequest: Request to kick off an Archive job.
type InitiatePortabilityArchiveRequest struct {
	// EndTime: Optional. The timestamp that represents the end point for the data
	// you are exporting. If the end_time is not specified in the
	// InitiatePortabilityArchiveRequest, this field is set to the latest available
	// data.
	EndTime string `json:"endTime,omitempty"`
	// Resources: The resources from which you're exporting data. These values have
	// a 1:1 correspondence with the OAuth scopes.
	Resources []string `json:"resources,omitempty"`
	// StartTime: Optional. The timestamp that represents the starting point for
	// the data you are exporting. If the start_time is not specified in the
	// InitiatePortabilityArchiveRequest, the field is set to the earliest
	// available data.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InitiatePortabilityArchiveRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InitiatePortabilityArchiveRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InitiatePortabilityArchiveResponse: Response from initiating an Archive job.
type InitiatePortabilityArchiveResponse struct {
	// AccessType: The access type of the Archive job initiated by the API.
	//
	// Possible values:
	//   "ACCESS_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "ACCESS_TYPE_ONE_TIME" - One-time access to the requested scopes.
	//   "ACCESS_TYPE_TIME_BASED" - Multiple exports allowed over 30 days. Enum
	// value subject to change before launch.
	AccessType string `json:"accessType,omitempty"`
	// ArchiveJobId: The archive job ID that is initiated in the API. This can be
	// used to get the state of the job.
	ArchiveJobId string `json:"archiveJobId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InitiatePortabilityArchiveResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InitiatePortabilityArchiveResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PortabilityArchiveState: Resource that contains the state of an Archive job.
type PortabilityArchiveState struct {
	// ExportTime: The timestamp that represents the end point for the data you are
	// exporting. If the end_time value is set in the
	// InitiatePortabilityArchiveRequest, this field is set to that value. If
	// end_time is not set, this value is set to the time the export was requested.
	ExportTime string `json:"exportTime,omitempty"`
	// Name: The resource name of ArchiveJob's PortabilityArchiveState singleton.
	// The format is: archiveJobs/{archive_job}/portabilityArchiveState.
	// archive_job is the job ID provided in the request.
	Name string `json:"name,omitempty"`
	// StartTime: The timestamp that represents the starting point for the data you
	// are exporting. This field is set only if the start_time field is specified
	// in the InitiatePortabilityArchiveRequest.
	StartTime string `json:"startTime,omitempty"`
	// State: Resource that represents the state of the Archive job.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "IN_PROGRESS" - The job is in progress.
	//   "COMPLETE" - The job is complete.
	//   "FAILED" - The job failed.
	//   "CANCELLED" - The job is cancelled.
	State string `json:"state,omitempty"`
	// Urls: If the state is complete, this method returns the signed URLs of the
	// objects in the Cloud Storage bucket.
	Urls []string `json:"urls,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExportTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PortabilityArchiveState) MarshalJSON() ([]byte, error) {
	type NoMethod PortabilityArchiveState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResetAuthorizationRequest: Request to reset exhausted OAuth scopes.
type ResetAuthorizationRequest struct {
}

// RetryPortabilityArchiveRequest: Request to retry a failed Portability
// Archive job.
type RetryPortabilityArchiveRequest struct {
}

// RetryPortabilityArchiveResponse: Response from retrying a Portability
// Archive.
type RetryPortabilityArchiveResponse struct {
	// ArchiveJobId: The archive job ID that is initiated by the retry endpoint.
	// This can be used to get the state of the new job.
	ArchiveJobId string `json:"archiveJobId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ArchiveJobId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveJobId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RetryPortabilityArchiveResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RetryPortabilityArchiveResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccessTypeCheckCall struct {
	s                      *Service
	checkaccesstyperequest *CheckAccessTypeRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Check: Gets the access type of the token.
func (r *AccessTypeService) Check(checkaccesstyperequest *CheckAccessTypeRequest) *AccessTypeCheckCall {
	c := &AccessTypeCheckCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.checkaccesstyperequest = checkaccesstyperequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccessTypeCheckCall) Fields(s ...googleapi.Field) *AccessTypeCheckCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccessTypeCheckCall) Context(ctx context.Context) *AccessTypeCheckCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccessTypeCheckCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccessTypeCheckCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.checkaccesstyperequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accessType:check")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataportability.accessType.check", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataportability.accessType.check" call.
// Any non-2xx status code is an error. Response headers are in either
// *CheckAccessTypeResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccessTypeCheckCall) Do(opts ...googleapi.CallOption) (*CheckAccessTypeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CheckAccessTypeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataportability.accessType.check", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ArchiveJobsCancelCall struct {
	s                               *Service
	name                            string
	cancelportabilityarchiverequest *CancelPortabilityArchiveRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Cancel: Cancels a Portability Archive job.
//
//   - name: The Archive job ID you're canceling. This is returned by the
//     InitiatePortabilityArchive response. The format is:
//     archiveJobs/{archive_job}. Canceling is only executed if the job is in
//     progress.
func (r *ArchiveJobsService) Cancel(name string, cancelportabilityarchiverequest *CancelPortabilityArchiveRequest) *ArchiveJobsCancelCall {
	c := &ArchiveJobsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cancelportabilityarchiverequest = cancelportabilityarchiverequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ArchiveJobsCancelCall) Fields(s ...googleapi.Field) *ArchiveJobsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ArchiveJobsCancelCall) Context(ctx context.Context) *ArchiveJobsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ArchiveJobsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ArchiveJobsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cancelportabilityarchiverequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataportability.archiveJobs.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataportability.archiveJobs.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *CancelPortabilityArchiveResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ArchiveJobsCancelCall) Do(opts ...googleapi.CallOption) (*CancelPortabilityArchiveResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CancelPortabilityArchiveResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataportability.archiveJobs.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ArchiveJobsGetPortabilityArchiveStateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetPortabilityArchiveState: Retrieves the state of an Archive job for the
// Portability API.
//
//   - name: The archive job ID that is returned when you request the state of
//     the job. The format is: archiveJobs/{archive_job}/portabilityArchiveState.
//     archive_job is the job ID returned by the
//     InitiatePortabilityArchiveResponse.
func (r *ArchiveJobsService) GetPortabilityArchiveState(name string) *ArchiveJobsGetPortabilityArchiveStateCall {
	c := &ArchiveJobsGetPortabilityArchiveStateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ArchiveJobsGetPortabilityArchiveStateCall) Fields(s ...googleapi.Field) *ArchiveJobsGetPortabilityArchiveStateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ArchiveJobsGetPortabilityArchiveStateCall) IfNoneMatch(entityTag string) *ArchiveJobsGetPortabilityArchiveStateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ArchiveJobsGetPortabilityArchiveStateCall) Context(ctx context.Context) *ArchiveJobsGetPortabilityArchiveStateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ArchiveJobsGetPortabilityArchiveStateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ArchiveJobsGetPortabilityArchiveStateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataportability.archiveJobs.getPortabilityArchiveState", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataportability.archiveJobs.getPortabilityArchiveState" call.
// Any non-2xx status code is an error. Response headers are in either
// *PortabilityArchiveState.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ArchiveJobsGetPortabilityArchiveStateCall) Do(opts ...googleapi.CallOption) (*PortabilityArchiveState, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PortabilityArchiveState{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataportability.archiveJobs.getPortabilityArchiveState", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ArchiveJobsRetryCall struct {
	s                              *Service
	name                           string
	retryportabilityarchiverequest *RetryPortabilityArchiveRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Retry: Retries a failed Portability Archive job.
//
//   - name: The Archive job ID you're retrying. This is returned by the
//     InitiatePortabilityArchiveResponse. Retrying is only executed if the
//     initial job failed.
func (r *ArchiveJobsService) Retry(name string, retryportabilityarchiverequest *RetryPortabilityArchiveRequest) *ArchiveJobsRetryCall {
	c := &ArchiveJobsRetryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.retryportabilityarchiverequest = retryportabilityarchiverequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ArchiveJobsRetryCall) Fields(s ...googleapi.Field) *ArchiveJobsRetryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ArchiveJobsRetryCall) Context(ctx context.Context) *ArchiveJobsRetryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ArchiveJobsRetryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ArchiveJobsRetryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.retryportabilityarchiverequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:retry")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataportability.archiveJobs.retry", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataportability.archiveJobs.retry" call.
// Any non-2xx status code is an error. Response headers are in either
// *RetryPortabilityArchiveResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ArchiveJobsRetryCall) Do(opts ...googleapi.CallOption) (*RetryPortabilityArchiveResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RetryPortabilityArchiveResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataportability.archiveJobs.retry", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AuthorizationResetCall struct {
	s                         *Service
	resetauthorizationrequest *ResetAuthorizationRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Reset: Revokes OAuth tokens and resets exhausted scopes for a user/project
// pair. This method allows you to initiate a request after a new consent is
// granted. This method also indicates that previous archives can be garbage
// collected. You should call this method when all jobs are complete and all
// archives are downloaded. Do not call it only when you start a new job.
func (r *AuthorizationService) Reset(resetauthorizationrequest *ResetAuthorizationRequest) *AuthorizationResetCall {
	c := &AuthorizationResetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resetauthorizationrequest = resetauthorizationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AuthorizationResetCall) Fields(s ...googleapi.Field) *AuthorizationResetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AuthorizationResetCall) Context(ctx context.Context) *AuthorizationResetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AuthorizationResetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AuthorizationResetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.resetauthorizationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/authorization:reset")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataportability.authorization.reset", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataportability.authorization.reset" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AuthorizationResetCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataportability.authorization.reset", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PortabilityArchiveInitiateCall struct {
	s                                 *Service
	initiateportabilityarchiverequest *InitiatePortabilityArchiveRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Initiate: Initiates a new Archive job for the Portability API.
func (r *PortabilityArchiveService) Initiate(initiateportabilityarchiverequest *InitiatePortabilityArchiveRequest) *PortabilityArchiveInitiateCall {
	c := &PortabilityArchiveInitiateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.initiateportabilityarchiverequest = initiateportabilityarchiverequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PortabilityArchiveInitiateCall) Fields(s ...googleapi.Field) *PortabilityArchiveInitiateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PortabilityArchiveInitiateCall) Context(ctx context.Context) *PortabilityArchiveInitiateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PortabilityArchiveInitiateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PortabilityArchiveInitiateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.initiateportabilityarchiverequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/portabilityArchive:initiate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataportability.portabilityArchive.initiate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataportability.portabilityArchive.initiate" call.
// Any non-2xx status code is an error. Response headers are in either
// *InitiatePortabilityArchiveResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PortabilityArchiveInitiateCall) Do(opts ...googleapi.CallOption) (*InitiatePortabilityArchiveResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InitiatePortabilityArchiveResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataportability.portabilityArchive.initiate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
