// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package cloudidentity provides access to the Cloud Identity API.
//
// For product documentation, see: https://cloud.google.com/identity/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/cloudidentity/v1beta1"
//	...
//	ctx := context.Background()
//	cloudidentityService, err := cloudidentity.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	cloudidentityService, err := cloudidentity.NewService(ctx, option.WithScopes(cloudidentity.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	cloudidentityService, err := cloudidentity.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	cloudidentityService, err := cloudidentity.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package cloudidentity // import "google.golang.org/api/cloudidentity/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "cloudidentity:v1beta1"
const apiName = "cloudidentity"
const apiVersion = "v1beta1"
const basePath = "https://cloudidentity.googleapis.com/"
const basePathTemplate = "https://cloudidentity.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://cloudidentity.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Private Service: https://www.googleapis.com/auth/cloud-identity.devices
	CloudIdentityDevicesScope = "https://www.googleapis.com/auth/cloud-identity.devices"

	// See your device details
	CloudIdentityDevicesLookupScope = "https://www.googleapis.com/auth/cloud-identity.devices.lookup"

	// Private Service:
	// https://www.googleapis.com/auth/cloud-identity.devices.readonly
	CloudIdentityDevicesReadonlyScope = "https://www.googleapis.com/auth/cloud-identity.devices.readonly"

	// See, change, create, and delete any of the Cloud Identity Groups that you
	// can access, including the members of each group
	CloudIdentityGroupsScope = "https://www.googleapis.com/auth/cloud-identity.groups"

	// See any Cloud Identity Groups that you can access, including group members
	// and their emails
	CloudIdentityGroupsReadonlyScope = "https://www.googleapis.com/auth/cloud-identity.groups.readonly"

	// See and edit all of the Inbound SSO profiles and their assignments to any
	// Org Units or Google Groups in your Cloud Identity Organization.
	CloudIdentityInboundssoScope = "https://www.googleapis.com/auth/cloud-identity.inboundsso"

	// See all of the Inbound SSO profiles and their assignments to any Org Units
	// or Google Groups in your Cloud Identity Organization.
	CloudIdentityInboundssoReadonlyScope = "https://www.googleapis.com/auth/cloud-identity.inboundsso.readonly"

	// List, Move orgmembers of an OrgUnit in your Cloud Identity Organization.
	CloudIdentityOrgunitsScope = "https://www.googleapis.com/auth/cloud-identity.orgunits"

	// List org members of an OrgUnit in your Cloud Identity Organization.
	CloudIdentityOrgunitsReadonlyScope = "https://www.googleapis.com/auth/cloud-identity.orgunits.readonly"

	// See and edit policies in your Cloud Identity Organization.
	CloudIdentityPoliciesScope = "https://www.googleapis.com/auth/cloud-identity.policies"

	// See policies in your Cloud Identity Organization.
	CloudIdentityPoliciesReadonlyScope = "https://www.googleapis.com/auth/cloud-identity.policies.readonly"

	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-identity.devices",
		"https://www.googleapis.com/auth/cloud-identity.devices.lookup",
		"https://www.googleapis.com/auth/cloud-identity.devices.readonly",
		"https://www.googleapis.com/auth/cloud-identity.groups",
		"https://www.googleapis.com/auth/cloud-identity.groups.readonly",
		"https://www.googleapis.com/auth/cloud-identity.inboundsso",
		"https://www.googleapis.com/auth/cloud-identity.inboundsso.readonly",
		"https://www.googleapis.com/auth/cloud-identity.orgunits",
		"https://www.googleapis.com/auth/cloud-identity.orgunits.readonly",
		"https://www.googleapis.com/auth/cloud-identity.policies",
		"https://www.googleapis.com/auth/cloud-identity.policies.readonly",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Customers = NewCustomersService(s)
	s.Devices = NewDevicesService(s)
	s.Groups = NewGroupsService(s)
	s.InboundSamlSsoProfiles = NewInboundSamlSsoProfilesService(s)
	s.InboundSsoAssignments = NewInboundSsoAssignmentsService(s)
	s.OrgUnits = NewOrgUnitsService(s)
	s.Policies = NewPoliciesService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Customers *CustomersService

	Devices *DevicesService

	Groups *GroupsService

	InboundSamlSsoProfiles *InboundSamlSsoProfilesService

	InboundSsoAssignments *InboundSsoAssignmentsService

	OrgUnits *OrgUnitsService

	Policies *PoliciesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCustomersService(s *Service) *CustomersService {
	rs := &CustomersService{s: s}
	rs.Userinvitations = NewCustomersUserinvitationsService(s)
	return rs
}

type CustomersService struct {
	s *Service

	Userinvitations *CustomersUserinvitationsService
}

func NewCustomersUserinvitationsService(s *Service) *CustomersUserinvitationsService {
	rs := &CustomersUserinvitationsService{s: s}
	return rs
}

type CustomersUserinvitationsService struct {
	s *Service
}

func NewDevicesService(s *Service) *DevicesService {
	rs := &DevicesService{s: s}
	rs.DeviceUsers = NewDevicesDeviceUsersService(s)
	return rs
}

type DevicesService struct {
	s *Service

	DeviceUsers *DevicesDeviceUsersService
}

func NewDevicesDeviceUsersService(s *Service) *DevicesDeviceUsersService {
	rs := &DevicesDeviceUsersService{s: s}
	rs.ClientStates = NewDevicesDeviceUsersClientStatesService(s)
	return rs
}

type DevicesDeviceUsersService struct {
	s *Service

	ClientStates *DevicesDeviceUsersClientStatesService
}

func NewDevicesDeviceUsersClientStatesService(s *Service) *DevicesDeviceUsersClientStatesService {
	rs := &DevicesDeviceUsersClientStatesService{s: s}
	return rs
}

type DevicesDeviceUsersClientStatesService struct {
	s *Service
}

func NewGroupsService(s *Service) *GroupsService {
	rs := &GroupsService{s: s}
	rs.Memberships = NewGroupsMembershipsService(s)
	return rs
}

type GroupsService struct {
	s *Service

	Memberships *GroupsMembershipsService
}

func NewGroupsMembershipsService(s *Service) *GroupsMembershipsService {
	rs := &GroupsMembershipsService{s: s}
	return rs
}

type GroupsMembershipsService struct {
	s *Service
}

func NewInboundSamlSsoProfilesService(s *Service) *InboundSamlSsoProfilesService {
	rs := &InboundSamlSsoProfilesService{s: s}
	rs.IdpCredentials = NewInboundSamlSsoProfilesIdpCredentialsService(s)
	return rs
}

type InboundSamlSsoProfilesService struct {
	s *Service

	IdpCredentials *InboundSamlSsoProfilesIdpCredentialsService
}

func NewInboundSamlSsoProfilesIdpCredentialsService(s *Service) *InboundSamlSsoProfilesIdpCredentialsService {
	rs := &InboundSamlSsoProfilesIdpCredentialsService{s: s}
	return rs
}

type InboundSamlSsoProfilesIdpCredentialsService struct {
	s *Service
}

func NewInboundSsoAssignmentsService(s *Service) *InboundSsoAssignmentsService {
	rs := &InboundSsoAssignmentsService{s: s}
	return rs
}

type InboundSsoAssignmentsService struct {
	s *Service
}

func NewOrgUnitsService(s *Service) *OrgUnitsService {
	rs := &OrgUnitsService{s: s}
	rs.Memberships = NewOrgUnitsMembershipsService(s)
	return rs
}

type OrgUnitsService struct {
	s *Service

	Memberships *OrgUnitsMembershipsService
}

func NewOrgUnitsMembershipsService(s *Service) *OrgUnitsMembershipsService {
	rs := &OrgUnitsMembershipsService{s: s}
	return rs
}

type OrgUnitsMembershipsService struct {
	s *Service
}

func NewPoliciesService(s *Service) *PoliciesService {
	rs := &PoliciesService{s: s}
	return rs
}

type PoliciesService struct {
	s *Service
}

// AddIdpCredentialOperationMetadata: LRO response metadata for
// InboundSamlSsoProfilesService.AddIdpCredential.
type AddIdpCredentialOperationMetadata struct {
	// State: State of this Operation Will be "awaiting-multi-party-approval" when
	// the operation is deferred due to the target customer having enabled
	// Multi-party approval for sensitive actions
	// (https://support.google.com/a/answer/13790448).
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddIdpCredentialOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AddIdpCredentialOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AddIdpCredentialRequest: The request for creating an IdpCredential with its
// associated payload. An InboundSamlSsoProfile can own up to 2 credentials.
type AddIdpCredentialRequest struct {
	// PemData: PEM encoded x509 certificate containing the public key for
	// verifying IdP signatures.
	PemData string `json:"pemData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PemData") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PemData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddIdpCredentialRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddIdpCredentialRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AndroidAttributes: Resource representing the Android specific attributes of
// a Device.
type AndroidAttributes struct {
	// CtsProfileMatch: Whether the device passes Android CTS compliance.
	CtsProfileMatch bool `json:"ctsProfileMatch,omitempty"`
	// EnabledUnknownSources: Whether applications from unknown sources can be
	// installed on device.
	EnabledUnknownSources bool `json:"enabledUnknownSources,omitempty"`
	// HasPotentiallyHarmfulApps: Whether any potentially harmful apps were
	// detected on the device.
	HasPotentiallyHarmfulApps bool `json:"hasPotentiallyHarmfulApps,omitempty"`
	// OwnerProfileAccount: Whether this account is on an owner/primary profile.
	// For phones, only true for owner profiles. Android 4+ devices can have
	// secondary or restricted user profiles.
	OwnerProfileAccount bool `json:"ownerProfileAccount,omitempty"`
	// OwnershipPrivilege: Ownership privileges on device.
	//
	// Possible values:
	//   "OWNERSHIP_PRIVILEGE_UNSPECIFIED" - Ownership privilege is not set.
	//   "DEVICE_ADMINISTRATOR" - Active device administrator privileges on the
	// device.
	//   "PROFILE_OWNER" - Profile Owner privileges. The account is in a managed
	// corporate profile.
	//   "DEVICE_OWNER" - Device Owner privileges on the device.
	OwnershipPrivilege string `json:"ownershipPrivilege,omitempty"`
	// SupportsWorkProfile: Whether device supports Android work profiles. If
	// false, this service will not block access to corp data even if an
	// administrator turns on the "Enforce Work Profile" policy.
	SupportsWorkProfile bool `json:"supportsWorkProfile,omitempty"`
	// VerifiedBoot: Whether Android verified boot status is GREEN.
	VerifiedBoot bool `json:"verifiedBoot,omitempty"`
	// VerifyAppsEnabled: Whether Google Play Protect Verify Apps is enabled.
	VerifyAppsEnabled bool `json:"verifyAppsEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CtsProfileMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CtsProfileMatch") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AndroidAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod AndroidAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApproveDeviceUserRequest: Request message for approving the device to access
// user data.
type ApproveDeviceUserRequest struct {
	// Customer: Optional. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the customer. If
	// you're using this API for your own organization, use `customers/my_customer`
	// If you're using this API to manage another organization, use
	// `customers/{customer_id}`, where customer_id is the customer to whom the
	// device belongs.
	Customer string `json:"customer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApproveDeviceUserRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ApproveDeviceUserRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApproveDeviceUserResponse: Response message for approving the device to
// access user data.
type ApproveDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *DeviceUser `json:"deviceUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApproveDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ApproveDeviceUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BlockDeviceUserRequest: Request message for blocking account on device.
type BlockDeviceUserRequest struct {
	// Customer: Optional. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the customer. If
	// you're using this API for your own organization, use `customers/my_customer`
	// If you're using this API to manage another organization, use
	// `customers/{customer_id}`, where customer_id is the customer to whom the
	// device belongs.
	Customer string `json:"customer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BlockDeviceUserRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BlockDeviceUserRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BlockDeviceUserResponse: Response message for blocking the device from
// accessing user data.
type BlockDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *DeviceUser `json:"deviceUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BlockDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BlockDeviceUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BrowserAttributes: Contains information about browser profiles reported by
// the Endpoint Verification extension
// (https://chromewebstore.google.com/detail/endpoint-verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
type BrowserAttributes struct {
	// ChromeBrowserInfo: Represents the current state of the Chrome browser
	// attributes
	// (https://cloud.google.com/access-context-manager/docs/browser-attributes)
	// sent by the Endpoint Verification extension
	// (https://chromewebstore.google.com/detail/endpoint-verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
	ChromeBrowserInfo *BrowserInfo `json:"chromeBrowserInfo,omitempty"`
	// ChromeProfileId: Chrome profile ID that is exposed by the Chrome API. It is
	// unique for each device.
	ChromeProfileId string `json:"chromeProfileId,omitempty"`
	// LastProfileSyncTime: Timestamp in milliseconds since the Unix epoch when the
	// profile/gcm id was last synced.
	LastProfileSyncTime string `json:"lastProfileSyncTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChromeBrowserInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChromeBrowserInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BrowserAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod BrowserAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BrowserInfo: Browser-specific fields reported by the Endpoint Verification
// extension
// (https://chromewebstore.google.com/detail/endpoint-verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
type BrowserInfo struct {
	// BrowserManagementState: Output only. Browser's management state.
	//
	// Possible values:
	//   "UNSPECIFIED" - Management state is not specified.
	//   "UNMANAGED" - Browser/Profile is not managed by any customer.
	//   "MANAGED_BY_OTHER_DOMAIN" - Browser/Profile is managed, but by some other
	// customer.
	//   "PROFILE_MANAGED" - Profile is managed by customer.
	//   "BROWSER_MANAGED" - Browser is managed by customer.
	BrowserManagementState string `json:"browserManagementState,omitempty"`
	// BrowserVersion: Version of the request initiating browser. E.g.
	// `91.0.4442.4`.
	BrowserVersion string `json:"browserVersion,omitempty"`
	// IsBuiltInDnsClientEnabled: Current state of built-in DNS client
	// (https://chromeenterprise.google/policies/#BuiltInDnsClientEnabled).
	IsBuiltInDnsClientEnabled bool `json:"isBuiltInDnsClientEnabled,omitempty"`
	// IsBulkDataEntryAnalysisEnabled: Current state of bulk data analysis
	// (https://chromeenterprise.google/policies/#OnBulkDataEntryEnterpriseConnector).
	// Set to true if provider list from Chrome is non-empty.
	IsBulkDataEntryAnalysisEnabled bool `json:"isBulkDataEntryAnalysisEnabled,omitempty"`
	// IsChromeCleanupEnabled: Current state of Chrome Cleanup
	// (https://chromeenterprise.google/policies/#ChromeCleanupEnabled).
	IsChromeCleanupEnabled bool `json:"isChromeCleanupEnabled,omitempty"`
	// IsChromeRemoteDesktopAppBlocked: Current state of Chrome Remote Desktop app
	// (https://chromeenterprise.google/policies/#URLBlocklist).
	IsChromeRemoteDesktopAppBlocked bool `json:"isChromeRemoteDesktopAppBlocked,omitempty"`
	// IsFileDownloadAnalysisEnabled: Current state of file download analysis
	// (https://chromeenterprise.google/policies/#OnFileDownloadedEnterpriseConnector).
	// Set to true if provider list from Chrome is non-empty.
	IsFileDownloadAnalysisEnabled bool `json:"isFileDownloadAnalysisEnabled,omitempty"`
	// IsFileUploadAnalysisEnabled: Current state of file upload analysis
	// (https://chromeenterprise.google/policies/#OnFileAttachedEnterpriseConnector).
	// Set to true if provider list from Chrome is non-empty.
	IsFileUploadAnalysisEnabled bool `json:"isFileUploadAnalysisEnabled,omitempty"`
	// IsRealtimeUrlCheckEnabled: Current state of real-time URL check
	// (https://chromeenterprise.google/policies/#EnterpriseRealTimeUrlCheckMode).
	// Set to true if provider list from Chrome is non-empty.
	IsRealtimeUrlCheckEnabled bool `json:"isRealtimeUrlCheckEnabled,omitempty"`
	// IsSecurityEventAnalysisEnabled: Current state of security event analysis
	// (https://chromeenterprise.google/policies/#OnSecurityEventEnterpriseConnector).
	// Set to true if provider list from Chrome is non-empty.
	IsSecurityEventAnalysisEnabled bool `json:"isSecurityEventAnalysisEnabled,omitempty"`
	// IsSiteIsolationEnabled: Current state of site isolation
	// (https://chromeenterprise.google/policies/?policy=IsolateOrigins).
	IsSiteIsolationEnabled bool `json:"isSiteIsolationEnabled,omitempty"`
	// IsThirdPartyBlockingEnabled: Current state of third-party blocking
	// (https://chromeenterprise.google/policies/#ThirdPartyBlockingEnabled).
	IsThirdPartyBlockingEnabled bool `json:"isThirdPartyBlockingEnabled,omitempty"`
	// PasswordProtectionWarningTrigger: Current state of password protection
	// trigger
	// (https://chromeenterprise.google/policies/#PasswordProtectionWarningTrigger).
	//
	// Possible values:
	//   "PASSWORD_PROTECTION_TRIGGER_UNSPECIFIED" - Password protection is not
	// specified.
	//   "PROTECTION_OFF" - Password reuse is never detected.
	//   "PASSWORD_REUSE" - Warning is shown when the user reuses their protected
	// password on a non-allowed site.
	//   "PHISHING_REUSE" - Warning is shown when the user reuses their protected
	// password on a phishing site.
	PasswordProtectionWarningTrigger string `json:"passwordProtectionWarningTrigger,omitempty"`
	// SafeBrowsingProtectionLevel: Current state of Safe Browsing protection level
	// (https://chromeenterprise.google/policies/#SafeBrowsingProtectionLevel).
	//
	// Possible values:
	//   "SAFE_BROWSING_LEVEL_UNSPECIFIED" - Browser protection level is not
	// specified.
	//   "DISABLED" - No protection against dangerous websites, downloads, and
	// extensions.
	//   "STANDARD" - Standard protection against websites, downloads, and
	// extensions that are known to be dangerous.
	//   "ENHANCED" - Faster, proactive protection against dangerous websites,
	// downloads, and extensions.
	SafeBrowsingProtectionLevel string `json:"safeBrowsingProtectionLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BrowserManagementState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BrowserManagementState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BrowserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BrowserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelUserInvitationRequest: Request to cancel sent invitation for target
// email in UserInvitation.
type CancelUserInvitationRequest struct {
}

// CancelWipeDeviceRequest: Request message for cancelling an unfinished device
// wipe.
type CancelWipeDeviceRequest struct {
	// Customer: Optional. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the customer. If
	// you're using this API for your own organization, use `customers/my_customer`
	// If you're using this API to manage another organization, use
	// `customers/{customer_id}`, where customer_id is the customer to whom the
	// device belongs.
	Customer string `json:"customer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CancelWipeDeviceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CancelWipeDeviceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelWipeDeviceResponse: Response message for cancelling an unfinished
// device wipe.
type CancelWipeDeviceResponse struct {
	// Device: Resultant Device object for the action. Note that asset tags will
	// not be returned in the device object.
	Device *Device `json:"device,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Device") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CancelWipeDeviceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CancelWipeDeviceResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelWipeDeviceUserRequest: Request message for cancelling an unfinished
// user account wipe.
type CancelWipeDeviceUserRequest struct {
	// Customer: Optional. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the customer. If
	// you're using this API for your own organization, use `customers/my_customer`
	// If you're using this API to manage another organization, use
	// `customers/{customer_id}`, where customer_id is the customer to whom the
	// device belongs.
	Customer string `json:"customer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CancelWipeDeviceUserRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CancelWipeDeviceUserRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelWipeDeviceUserResponse: Response message for cancelling an unfinished
// user account wipe.
type CancelWipeDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *DeviceUser `json:"deviceUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CancelWipeDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CancelWipeDeviceUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CertificateAttributes: Stores information about a certificate.
type CertificateAttributes struct {
	// CertificateTemplate: The X.509 extension for CertificateTemplate.
	CertificateTemplate *CertificateTemplate `json:"certificateTemplate,omitempty"`
	// Fingerprint: The encoded certificate fingerprint.
	Fingerprint string `json:"fingerprint,omitempty"`
	// Issuer: The name of the issuer of this certificate.
	Issuer string `json:"issuer,omitempty"`
	// SerialNumber: Serial number of the certificate, Example: "123456789".
	SerialNumber string `json:"serialNumber,omitempty"`
	// Subject: The subject name of this certificate.
	Subject string `json:"subject,omitempty"`
	// Thumbprint: The certificate thumbprint.
	Thumbprint string `json:"thumbprint,omitempty"`
	// ValidationState: Validation state of this certificate.
	//
	// Possible values:
	//   "CERTIFICATE_VALIDATION_STATE_UNSPECIFIED" - Default value.
	//   "VALIDATION_SUCCESSFUL" - Certificate validation was successful.
	//   "VALIDATION_FAILED" - Certificate validation failed.
	ValidationState string `json:"validationState,omitempty"`
	// ValidityExpirationTime: Certificate not valid at or after this timestamp.
	ValidityExpirationTime string `json:"validityExpirationTime,omitempty"`
	// ValidityStartTime: Certificate not valid before this timestamp.
	ValidityStartTime string `json:"validityStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CertificateAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod CertificateAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CertificateTemplate: CertificateTemplate (v3 Extension in X.509).
type CertificateTemplate struct {
	// Id: The template id of the template. Example:
	// "1.3.6.1.4.1.311.21.8.15608621.11768144.5720724.16068415.6889630.81.2472537.7
	// 784047".
	Id string `json:"id,omitempty"`
	// MajorVersion: The Major version of the template. Example: 100.
	MajorVersion int64 `json:"majorVersion,omitempty"`
	// MinorVersion: The minor version of the template. Example: 12.
	MinorVersion int64 `json:"minorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CertificateTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod CertificateTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckTransitiveMembershipResponse: The response message for
// MembershipsService.CheckTransitiveMembership.
type CheckTransitiveMembershipResponse struct {
	// HasMembership: Response does not include the possible roles of a member
	// since the behavior of this rpc is not all-or-nothing unlike the other rpcs.
	// So, it may not be possible to list all the roles definitively, due to
	// possible lack of authorization in some of the paths.
	HasMembership bool `json:"hasMembership,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "HasMembership") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HasMembership") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckTransitiveMembershipResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckTransitiveMembershipResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClientState: Represents the state associated with an API client calling the
// Devices API. Resource representing ClientState and supports updates from API
// users
type ClientState struct {
	// AssetTags: The caller can specify asset tags for this resource
	AssetTags []string `json:"assetTags,omitempty"`
	// ComplianceState: The compliance state of the resource as specified by the
	// API client.
	//
	// Possible values:
	//   "COMPLIANCE_STATE_UNSPECIFIED" - The compliance state of the resource is
	// unknown or unspecified.
	//   "COMPLIANT" - Device is compliant with third party policies
	//   "NON_COMPLIANT" - Device is not compliant with third party policies
	ComplianceState string `json:"complianceState,omitempty"`
	// CreateTime: Output only. The time the client state data was created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomId: This field may be used to store a unique identifier for the API
	// resource within which these CustomAttributes are a field.
	CustomId string `json:"customId,omitempty"`
	// Etag: The token that needs to be passed back for concurrency control in
	// updates. Token needs to be passed back in UpdateRequest
	Etag string `json:"etag,omitempty"`
	// HealthScore: The Health score of the resource
	//
	// Possible values:
	//   "HEALTH_SCORE_UNSPECIFIED" - Default value
	//   "VERY_POOR" - The object is in very poor health as defined by the caller.
	//   "POOR" - The object is in poor health as defined by the caller.
	//   "NEUTRAL" - The object health is neither good nor poor, as defined by the
	// caller.
	//   "GOOD" - The object is in good health as defined by the caller.
	//   "VERY_GOOD" - The object is in very good health as defined by the caller.
	HealthScore string `json:"healthScore,omitempty"`
	// KeyValuePairs: The map of key-value attributes stored by callers specific to
	// a device. The total serialized length of this map may not exceed 10KB. No
	// limit is placed on the number of attributes in a map.
	KeyValuePairs map[string]CustomAttributeValue `json:"keyValuePairs,omitempty"`
	// LastUpdateTime: Output only. The time the client state data was last
	// updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// Managed: The management state of the resource as specified by the API
	// client.
	//
	// Possible values:
	//   "MANAGED_STATE_UNSPECIFIED" - The management state of the resource is
	// unknown or unspecified.
	//   "MANAGED" - The resource is managed.
	//   "UNMANAGED" - The resource is not managed.
	Managed string `json:"managed,omitempty"`
	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the ClientState in
	// format:
	// `devices/{device_id}/deviceUsers/{device_user_id}/clientState/{partner_id}`,
	// where partner_id corresponds to the partner storing the data.
	Name string `json:"name,omitempty"`
	// OwnerType: Output only. The owner of the ClientState
	//
	// Possible values:
	//   "OWNER_TYPE_UNSPECIFIED" - Unknown owner type
	//   "OWNER_TYPE_CUSTOMER" - Customer is the owner
	//   "OWNER_TYPE_PARTNER" - Partner is the owner
	OwnerType string `json:"ownerType,omitempty"`
	// ScoreReason: A descriptive cause of the health score.
	ScoreReason string `json:"scoreReason,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssetTags") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssetTags") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClientState) MarshalJSON() ([]byte, error) {
	type NoMethod ClientState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateDeviceRequest: Request message for creating a Company Owned device.
type CreateDeviceRequest struct {
	// Customer: Optional. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the customer. If
	// you're using this API for your own organization, use `customers/my_customer`
	// If you're using this API to manage another organization, use
	// `customers/{customer_id}`, where customer_id is the customer to whom the
	// device belongs.
	Customer string `json:"customer,omitempty"`
	// Device: Required. The device to be created. The name field within this
	// device is ignored in the create method. A new name is created by the method,
	// and returned within the response. Only the fields `device_type`,
	// `serial_number` and `asset_tag` (if present) are used to create the device.
	// All other fields are ignored. The `device_type` and `serial_number` fields
	// are required.
	Device *Device `json:"device,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateDeviceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateDeviceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateInboundSamlSsoProfileOperationMetadata: LRO response metadata for
// InboundSamlSsoProfilesService.CreateInboundSamlSsoProfile.
type CreateInboundSamlSsoProfileOperationMetadata struct {
	// State: State of this Operation Will be "awaiting-multi-party-approval" when
	// the operation is deferred due to the target customer having enabled
	// Multi-party approval for sensitive actions
	// (https://support.google.com/a/answer/13790448).
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateInboundSamlSsoProfileOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CreateInboundSamlSsoProfileOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateInboundSsoAssignmentOperationMetadata: LRO response metadata for
// InboundSsoAssignmentsService.CreateInboundSsoAssignment.
type CreateInboundSsoAssignmentOperationMetadata struct {
}

// CustomAttributeValue: Additional custom attribute values may be one of these
// types
type CustomAttributeValue struct {
	// BoolValue: Represents a boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// NumberValue: Represents a double value.
	NumberValue float64 `json:"numberValue,omitempty"`
	// StringValue: Represents a string value.
	StringValue string `json:"stringValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomAttributeValue) MarshalJSON() ([]byte, error) {
	type NoMethod CustomAttributeValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CustomAttributeValue) UnmarshalJSON(data []byte) error {
	type NoMethod CustomAttributeValue
	var s1 struct {
		NumberValue gensupport.JSONFloat64 `json:"numberValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumberValue = float64(s1.NumberValue)
	return nil
}

// DeleteIdpCredentialOperationMetadata: LRO response metadata for
// InboundSamlSsoProfilesService.DeleteIdpCredential.
type DeleteIdpCredentialOperationMetadata struct {
}

// DeleteInboundSamlSsoProfileOperationMetadata: LRO response metadata for
// InboundSamlSsoProfilesService.DeleteInboundSamlSsoProfile.
type DeleteInboundSamlSsoProfileOperationMetadata struct {
}

// DeleteInboundSsoAssignmentOperationMetadata: LRO response metadata for
// InboundSsoAssignmentsService.DeleteInboundSsoAssignment.
type DeleteInboundSsoAssignmentOperationMetadata struct {
}

// Device: A Device within the Cloud Identity Devices API. Represents a Device
// known to Google Cloud, independent of the device ownership, type, and
// whether it is assigned or in use by a user. Important: Device API scopes
// require that you use domain-wide delegation to access the API. For more
// information, see Set up the Devices API
// (https://cloud.google.com/identity/docs/how-to/setup-devices).
type Device struct {
	// AndroidSpecificAttributes: Output only. Attributes specific to Android
	// devices.
	AndroidSpecificAttributes *AndroidAttributes `json:"androidSpecificAttributes,omitempty"`
	// AssetTag: Asset tag of the device.
	AssetTag string `json:"assetTag,omitempty"`
	// BasebandVersion: Output only. Baseband version of the device.
	BasebandVersion string `json:"basebandVersion,omitempty"`
	// BootloaderVersion: Output only. Device bootloader version. Example: 0.6.7.
	BootloaderVersion string `json:"bootloaderVersion,omitempty"`
	// Brand: Output only. Device brand. Example: Samsung.
	Brand string `json:"brand,omitempty"`
	// BuildNumber: Output only. Build number of the device.
	BuildNumber string `json:"buildNumber,omitempty"`
	// ClientTypes: List of the clients the device is reporting to.
	//
	// Possible values:
	//   "CLIENT_TYPE_UNSPECIFIED" - Default value
	//   "DRIVE_FS" - Managed by DriveFS
	//   "FUNDAMENTAL" - Management type for every secure device
	//   "ENDPOINT_VERIFICATION" - Managed by Endpoint Verification
	//   "WINDOWS_ADVANCED" - Managed by Windows
	//   "GOOGLE_CREDENTIALS_PROVIDER_FOR_WINDOWS" - Managed by Google credential
	// provider for windows
	ClientTypes []string `json:"clientTypes,omitempty"`
	// CompromisedState: Output only. Represents whether the Device is compromised.
	//
	// Possible values:
	//   "COMPROMISED_STATE_UNSPECIFIED" - Default value.
	//   "COMPROMISED" - The device is compromised (currently, this means Android
	// device is rooted).
	//   "UNCOMPROMISED" - The device is safe (currently, this means Android device
	// is unrooted).
	CompromisedState string `json:"compromisedState,omitempty"`
	// CreateTime: Output only. When the Company-Owned device was imported. This
	// field is empty for BYOD devices.
	CreateTime string `json:"createTime,omitempty"`
	// DeviceId: Unique identifier for the device.
	DeviceId string `json:"deviceId,omitempty"`
	// DeviceType: Output only. Type of device.
	//
	// Possible values:
	//   "DEVICE_TYPE_UNSPECIFIED" - Unknown device type
	//   "ANDROID" - Device is an Android device
	//   "IOS" - Device is an iOS device
	//   "GOOGLE_SYNC" - Device is a Google Sync device.
	//   "WINDOWS" - Device is a Windows device.
	//   "MAC_OS" - Device is a MacOS device.
	//   "LINUX" - Device is a Linux device.
	//   "CHROME_OS" - Device is a ChromeOS device.
	DeviceType string `json:"deviceType,omitempty"`
	// EnabledDeveloperOptions: Output only. Whether developer options is enabled
	// on device.
	EnabledDeveloperOptions bool `json:"enabledDeveloperOptions,omitempty"`
	// EnabledUsbDebugging: Output only. Whether USB debugging is enabled on
	// device.
	EnabledUsbDebugging bool `json:"enabledUsbDebugging,omitempty"`
	// EncryptionState: Output only. Device encryption state.
	//
	// Possible values:
	//   "ENCRYPTION_STATE_UNSPECIFIED" - Encryption Status is not set.
	//   "UNSUPPORTED_BY_DEVICE" - Device doesn't support encryption.
	//   "ENCRYPTED" - Device is encrypted.
	//   "NOT_ENCRYPTED" - Device is not encrypted.
	EncryptionState string `json:"encryptionState,omitempty"`
	// EndpointVerificationSpecificAttributes: Output only. Attributes specific to
	// Endpoint Verification
	// (https://cloud.google.com/endpoint-verification/docs/overview) devices.
	EndpointVerificationSpecificAttributes *EndpointVerificationSpecificAttributes `json:"endpointVerificationSpecificAttributes,omitempty"`
	// Hostname: Host name of the device.
	Hostname string `json:"hostname,omitempty"`
	// Imei: Output only. IMEI number of device if GSM device; empty otherwise.
	Imei string `json:"imei,omitempty"`
	// KernelVersion: Output only. Kernel version of the device.
	KernelVersion string `json:"kernelVersion,omitempty"`
	// LastSyncTime: Most recent time when device synced with this service.
	LastSyncTime string `json:"lastSyncTime,omitempty"`
	// ManagementState: Output only. Management state of the device
	//
	// Possible values:
	//   "MANAGEMENT_STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "APPROVED" - Device is approved.
	//   "BLOCKED" - Device is blocked.
	//   "PENDING" - Device is pending approval.
	//   "UNPROVISIONED" - The device is not provisioned. Device will start from
	// this state until some action is taken (i.e. a user starts using the device).
	//   "WIPING" - Data and settings on the device are being removed.
	//   "WIPED" - All data and settings on the device are removed.
	ManagementState string `json:"managementState,omitempty"`
	// Manufacturer: Output only. Device manufacturer. Example: Motorola.
	Manufacturer string `json:"manufacturer,omitempty"`
	// Meid: Output only. MEID number of device if CDMA device; empty otherwise.
	Meid string `json:"meid,omitempty"`
	// Model: Output only. Model name of device. Example: Pixel 3.
	Model string `json:"model,omitempty"`
	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the Device in
	// format: `devices/{device_id}`, where device_id is the unique id assigned to
	// the Device.
	Name string `json:"name,omitempty"`
	// NetworkOperator: Output only. Mobile or network operator of device, if
	// available.
	NetworkOperator string `json:"networkOperator,omitempty"`
	// OsVersion: Output only. OS version of the device. Example: Android 8.1.0.
	OsVersion string `json:"osVersion,omitempty"`
	// OtherAccounts: Output only. Domain name for Google accounts on device. Type
	// for other accounts on device. On Android, will only be populated if
	// |ownership_privilege| is |PROFILE_OWNER| or |DEVICE_OWNER|. Does not include
	// the account signed in to the device policy app if that account's domain has
	// only one account. Examples: "com.example", "xyz.com".
	OtherAccounts []string `json:"otherAccounts,omitempty"`
	// OwnerType: Output only. Whether the device is owned by the company or an
	// individual
	//
	// Possible values:
	//   "DEVICE_OWNERSHIP_UNSPECIFIED" - Default value. The value is unused.
	//   "COMPANY" - Company owns the device.
	//   "BYOD" - Bring Your Own Device (i.e. individual owns the device)
	OwnerType string `json:"ownerType,omitempty"`
	// ReleaseVersion: Output only. OS release version. Example: 6.0.
	ReleaseVersion string `json:"releaseVersion,omitempty"`
	// SecurityPatchTime: Output only. OS security patch update time on device.
	SecurityPatchTime string `json:"securityPatchTime,omitempty"`
	// SerialNumber: Serial Number of device. Example: HT82V1A01076.
	SerialNumber string `json:"serialNumber,omitempty"`
	// UnifiedDeviceId: Output only. Unified device id of the device.
	UnifiedDeviceId string `json:"unifiedDeviceId,omitempty"`
	// WifiMacAddresses: WiFi MAC addresses of device.
	WifiMacAddresses []string `json:"wifiMacAddresses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AndroidSpecificAttributes")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AndroidSpecificAttributes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Device) MarshalJSON() ([]byte, error) {
	type NoMethod Device
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeviceUser: Represents a user's use of a Device in the Cloud Identity
// Devices API. A DeviceUser is a resource representing a user's use of a
// Device
type DeviceUser struct {
	// CompromisedState: Compromised State of the DeviceUser object
	//
	// Possible values:
	//   "COMPROMISED_STATE_UNSPECIFIED" - Compromised state of Device User account
	// is unknown or unspecified.
	//   "COMPROMISED" - Device User Account is compromised.
	//   "NOT_COMPROMISED" - Device User Account is not compromised.
	CompromisedState string `json:"compromisedState,omitempty"`
	// CreateTime: When the user first signed in to the device
	CreateTime string `json:"createTime,omitempty"`
	// FirstSyncTime: Output only. Most recent time when user registered with this
	// service.
	FirstSyncTime string `json:"firstSyncTime,omitempty"`
	// LanguageCode: Output only. Default locale used on device, in IETF BCP-47
	// format.
	LanguageCode string `json:"languageCode,omitempty"`
	// LastSyncTime: Output only. Last time when user synced with policies.
	LastSyncTime string `json:"lastSyncTime,omitempty"`
	// ManagementState: Output only. Management state of the user on the device.
	//
	// Possible values:
	//   "MANAGEMENT_STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "WIPING" - This user's data and profile is being removed from the device.
	//   "WIPED" - This user's data and profile is removed from the device.
	//   "APPROVED" - User is approved to access data on the device.
	//   "BLOCKED" - User is blocked from accessing data on the device.
	//   "PENDING_APPROVAL" - User is awaiting approval.
	//   "UNENROLLED" - User is unenrolled from Advanced Windows Management, but
	// the Windows account is still intact.
	ManagementState string `json:"managementState,omitempty"`
	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the DeviceUser in
	// format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
	// `device_user_id` uniquely identifies a user's use of a device.
	Name string `json:"name,omitempty"`
	// PasswordState: Password state of the DeviceUser object
	//
	// Possible values:
	//   "PASSWORD_STATE_UNSPECIFIED" - Password state not set.
	//   "PASSWORD_SET" - Password set in object.
	//   "PASSWORD_NOT_SET" - Password not set in object.
	PasswordState string `json:"passwordState,omitempty"`
	// UserAgent: Output only. User agent on the device for this specific user
	UserAgent string `json:"userAgent,omitempty"`
	// UserEmail: Email address of the user registered on the device.
	UserEmail string `json:"userEmail,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompromisedState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompromisedState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeviceUser) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceUser
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DsaPublicKeyInfo: Information of a DSA public key.
type DsaPublicKeyInfo struct {
	// KeySize: Key size in bits (size of parameter P).
	KeySize int64 `json:"keySize,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KeySize") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KeySize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DsaPublicKeyInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DsaPublicKeyInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DynamicGroupMetadata: Dynamic group metadata like queries and status.
type DynamicGroupMetadata struct {
	// Queries: Memberships will be the union of all queries. Only one entry with
	// USER resource is currently supported. Customers can create up to 500 dynamic
	// groups.
	Queries []*DynamicGroupQuery `json:"queries,omitempty"`
	// Status: Output only. Status of the dynamic group.
	Status *DynamicGroupStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Queries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Queries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DynamicGroupMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod DynamicGroupMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DynamicGroupQuery: Defines a query on a resource.
type DynamicGroupQuery struct {
	// Query: Query that determines the memberships of the dynamic group. Examples:
	// All users with at least one `organizations.department` of engineering.
	// `user.organizations.exists(org, org.department=='engineering')` All users
	// with at least one location that has `area` of `foo` and `building_id` of
	// `bar`. `user.locations.exists(loc, loc.area=='foo' &&
	// loc.building_id=='bar')` All users with any variation of the name John Doe
	// (case-insensitive queries add `equalsIgnoreCase()` to the value being
	// queried). `user.name.value.equalsIgnoreCase('jOhn DoE')`
	Query string `json:"query,omitempty"`
	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED" - Default value (not valid)
	//   "USER" - For queries on User
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DynamicGroupQuery) MarshalJSON() ([]byte, error) {
	type NoMethod DynamicGroupQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DynamicGroupStatus: The current status of a dynamic group along with
// timestamp.
type DynamicGroupStatus struct {
	// Status: Status of the dynamic group.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Default.
	//   "UP_TO_DATE" - The dynamic group is up-to-date.
	//   "UPDATING_MEMBERSHIPS" - The dynamic group has just been created and
	// memberships are being updated.
	//   "INVALID_QUERY" - Group is in an unrecoverable state and its memberships
	// can't be updated.
	Status string `json:"status,omitempty"`
	// StatusTime: The latest time at which the dynamic group is guaranteed to be
	// in the given status. If status is `UP_TO_DATE`, the latest time at which the
	// dynamic group was confirmed to be up-to-date. If status is
	// `UPDATING_MEMBERSHIPS`, the time at which dynamic group was created.
	StatusTime string `json:"statusTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DynamicGroupStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DynamicGroupStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EndpointVerificationSpecificAttributes: Resource representing the Endpoint
// Verification-specific attributes
// (https://cloud.google.com/endpoint-verification/docs/device-information) of
// a device.
type EndpointVerificationSpecificAttributes struct {
	// AdditionalSignals: Additional signals
	// (https://cloud.google.com/endpoint-verification/docs/device-information)
	// reported by Endpoint Verification. It includes the following attributes: *
	// Non-configurable attributes: hotfixes, av_installed, av_enabled,
	// windows_domain_name, is_os_native_firewall_enabled, and
	// is_secure_boot_enabled. * Configurable attributes
	// (https://cloud.google.com/endpoint-verification/docs/collect-config-attributes):
	// file, folder, and binary attributes; registry entries; and properties in a
	// plist.
	AdditionalSignals googleapi.RawMessage `json:"additionalSignals,omitempty"`
	// BrowserAttributes: Details of browser profiles reported by Endpoint
	// Verification.
	BrowserAttributes []*BrowserAttributes `json:"browserAttributes,omitempty"`
	// CertificateAttributes: Details of certificates.
	CertificateAttributes []*CertificateAttributes `json:"certificateAttributes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalSignals") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EndpointVerificationSpecificAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod EndpointVerificationSpecificAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EntityKey: A unique identifier for an entity in the Cloud Identity Groups
// API. An entity can represent either a group with an optional `namespace` or
// a user without a `namespace`. The combination of `id` and `namespace` must
// be unique; however, the same `id` can be used with different `namespace`s.
type EntityKey struct {
	// Id: The ID of the entity. For Google-managed entities, the `id` must be the
	// email address of an existing group or user. For external-identity-mapped
	// entities, the `id` must be a string conforming to the Identity Source's
	// requirements. Must be unique within a `namespace`.
	Id string `json:"id,omitempty"`
	// Namespace: The namespace in which the entity exists. If not specified, the
	// `EntityKey` represents a Google-managed entity such as a Google user or a
	// Google Group. If specified, the `EntityKey` represents an
	// external-identity-mapped group. The namespace must correspond to an identity
	// source created in Admin Console and must be in the form of
	// `identitysources/{identity_source_id}`.
	Namespace string `json:"namespace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EntityKey) MarshalJSON() ([]byte, error) {
	type NoMethod EntityKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExpiryDetail: The `MembershipRole` expiry details.
type ExpiryDetail struct {
	// ExpireTime: The time at which the `MembershipRole` will expire.
	ExpireTime string `json:"expireTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpireTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpireTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExpiryDetail) MarshalJSON() ([]byte, error) {
	type NoMethod ExpiryDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetMembershipGraphResponse: The response message for
// MembershipsService.GetMembershipGraph.
type GetMembershipGraphResponse struct {
	// AdjacencyList: The membership graph's path information represented as an
	// adjacency list.
	AdjacencyList []*MembershipAdjacencyList `json:"adjacencyList,omitempty"`
	// Groups: The resources representing each group in the adjacency list. Each
	// group in this list can be correlated to a 'group' of the
	// MembershipAdjacencyList using the 'name' of the Group resource.
	Groups []*Group `json:"groups,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdjacencyList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdjacencyList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetMembershipGraphResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetMembershipGraphResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1AndroidAttributes: Resource representing the
// Android specific attributes of a Device.
type GoogleAppsCloudidentityDevicesV1AndroidAttributes struct {
	// CtsProfileMatch: Whether the device passes Android CTS compliance.
	CtsProfileMatch bool `json:"ctsProfileMatch,omitempty"`
	// EnabledUnknownSources: Whether applications from unknown sources can be
	// installed on device.
	EnabledUnknownSources bool `json:"enabledUnknownSources,omitempty"`
	// HasPotentiallyHarmfulApps: Whether any potentially harmful apps were
	// detected on the device.
	HasPotentiallyHarmfulApps bool `json:"hasPotentiallyHarmfulApps,omitempty"`
	// OwnerProfileAccount: Whether this account is on an owner/primary profile.
	// For phones, only true for owner profiles. Android 4+ devices can have
	// secondary or restricted user profiles.
	OwnerProfileAccount bool `json:"ownerProfileAccount,omitempty"`
	// OwnershipPrivilege: Ownership privileges on device.
	//
	// Possible values:
	//   "OWNERSHIP_PRIVILEGE_UNSPECIFIED" - Ownership privilege is not set.
	//   "DEVICE_ADMINISTRATOR" - Active device administrator privileges on the
	// device.
	//   "PROFILE_OWNER" - Profile Owner privileges. The account is in a managed
	// corporate profile.
	//   "DEVICE_OWNER" - Device Owner privileges on the device.
	OwnershipPrivilege string `json:"ownershipPrivilege,omitempty"`
	// SupportsWorkProfile: Whether device supports Android work profiles. If
	// false, this service will not block access to corp data even if an
	// administrator turns on the "Enforce Work Profile" policy.
	SupportsWorkProfile bool `json:"supportsWorkProfile,omitempty"`
	// VerifiedBoot: Whether Android verified boot status is GREEN.
	VerifiedBoot bool `json:"verifiedBoot,omitempty"`
	// VerifyAppsEnabled: Whether Google Play Protect Verify Apps is enabled.
	VerifyAppsEnabled bool `json:"verifyAppsEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CtsProfileMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CtsProfileMatch") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1AndroidAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1AndroidAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1ApproveDeviceUserMetadata: Metadata for
// ApproveDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1ApproveDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse: Response message
// for approving the device to access user data.
type GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *GoogleAppsCloudidentityDevicesV1DeviceUser `json:"deviceUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1BlockDeviceUserMetadata: Metadata for
// BlockDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1BlockDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1BlockDeviceUserResponse: Response message
// for blocking the device from accessing user data.
type GoogleAppsCloudidentityDevicesV1BlockDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *GoogleAppsCloudidentityDevicesV1DeviceUser `json:"deviceUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1BlockDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1BlockDeviceUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1BrowserAttributes: Contains information
// about browser profiles reported by the Endpoint Verification extension
// (https://chromewebstore.google.com/detail/endpoint-verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
type GoogleAppsCloudidentityDevicesV1BrowserAttributes struct {
	// ChromeBrowserInfo: Represents the current state of the Chrome browser
	// attributes
	// (https://cloud.google.com/access-context-manager/docs/browser-attributes)
	// sent by the Endpoint Verification extension
	// (https://chromewebstore.google.com/detail/endpoint-verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
	ChromeBrowserInfo *GoogleAppsCloudidentityDevicesV1BrowserInfo `json:"chromeBrowserInfo,omitempty"`
	// ChromeProfileId: Chrome profile ID that is exposed by the Chrome API. It is
	// unique for each device.
	ChromeProfileId string `json:"chromeProfileId,omitempty"`
	// LastProfileSyncTime: Timestamp in milliseconds since the Unix epoch when the
	// profile/gcm id was last synced.
	LastProfileSyncTime string `json:"lastProfileSyncTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChromeBrowserInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChromeBrowserInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1BrowserAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1BrowserAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1BrowserInfo: Browser-specific fields
// reported by the Endpoint Verification extension
// (https://chromewebstore.google.com/detail/endpoint-verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
type GoogleAppsCloudidentityDevicesV1BrowserInfo struct {
	// BrowserManagementState: Output only. Browser's management state.
	//
	// Possible values:
	//   "UNSPECIFIED" - Management state is not specified.
	//   "UNMANAGED" - Browser/Profile is not managed by any customer.
	//   "MANAGED_BY_OTHER_DOMAIN" - Browser/Profile is managed, but by some other
	// customer.
	//   "PROFILE_MANAGED" - Profile is managed by customer.
	//   "BROWSER_MANAGED" - Browser is managed by customer.
	BrowserManagementState string `json:"browserManagementState,omitempty"`
	// BrowserVersion: Version of the request initiating browser. E.g.
	// `91.0.4442.4`.
	BrowserVersion string `json:"browserVersion,omitempty"`
	// IsBuiltInDnsClientEnabled: Current state of built-in DNS client
	// (https://chromeenterprise.google/policies/#BuiltInDnsClientEnabled).
	IsBuiltInDnsClientEnabled bool `json:"isBuiltInDnsClientEnabled,omitempty"`
	// IsBulkDataEntryAnalysisEnabled: Current state of bulk data analysis
	// (https://chromeenterprise.google/policies/#OnBulkDataEntryEnterpriseConnector).
	// Set to true if provider list from Chrome is non-empty.
	IsBulkDataEntryAnalysisEnabled bool `json:"isBulkDataEntryAnalysisEnabled,omitempty"`
	// IsChromeCleanupEnabled: Current state of Chrome Cleanup
	// (https://chromeenterprise.google/policies/#ChromeCleanupEnabled).
	IsChromeCleanupEnabled bool `json:"isChromeCleanupEnabled,omitempty"`
	// IsChromeRemoteDesktopAppBlocked: Current state of Chrome Remote Desktop app
	// (https://chromeenterprise.google/policies/#URLBlocklist).
	IsChromeRemoteDesktopAppBlocked bool `json:"isChromeRemoteDesktopAppBlocked,omitempty"`
	// IsFileDownloadAnalysisEnabled: Current state of file download analysis
	// (https://chromeenterprise.google/policies/#OnFileDownloadedEnterpriseConnector).
	// Set to true if provider list from Chrome is non-empty.
	IsFileDownloadAnalysisEnabled bool `json:"isFileDownloadAnalysisEnabled,omitempty"`
	// IsFileUploadAnalysisEnabled: Current state of file upload analysis
	// (https://chromeenterprise.google/policies/#OnFileAttachedEnterpriseConnector).
	// Set to true if provider list from Chrome is non-empty.
	IsFileUploadAnalysisEnabled bool `json:"isFileUploadAnalysisEnabled,omitempty"`
	// IsRealtimeUrlCheckEnabled: Current state of real-time URL check
	// (https://chromeenterprise.google/policies/#EnterpriseRealTimeUrlCheckMode).
	// Set to true if provider list from Chrome is non-empty.
	IsRealtimeUrlCheckEnabled bool `json:"isRealtimeUrlCheckEnabled,omitempty"`
	// IsSecurityEventAnalysisEnabled: Current state of security event analysis
	// (https://chromeenterprise.google/policies/#OnSecurityEventEnterpriseConnector).
	// Set to true if provider list from Chrome is non-empty.
	IsSecurityEventAnalysisEnabled bool `json:"isSecurityEventAnalysisEnabled,omitempty"`
	// IsSiteIsolationEnabled: Current state of site isolation
	// (https://chromeenterprise.google/policies/?policy=IsolateOrigins).
	IsSiteIsolationEnabled bool `json:"isSiteIsolationEnabled,omitempty"`
	// IsThirdPartyBlockingEnabled: Current state of third-party blocking
	// (https://chromeenterprise.google/policies/#ThirdPartyBlockingEnabled).
	IsThirdPartyBlockingEnabled bool `json:"isThirdPartyBlockingEnabled,omitempty"`
	// PasswordProtectionWarningTrigger: Current state of password protection
	// trigger
	// (https://chromeenterprise.google/policies/#PasswordProtectionWarningTrigger).
	//
	// Possible values:
	//   "PASSWORD_PROTECTION_TRIGGER_UNSPECIFIED" - Password protection is not
	// specified.
	//   "PROTECTION_OFF" - Password reuse is never detected.
	//   "PASSWORD_REUSE" - Warning is shown when the user reuses their protected
	// password on a non-allowed site.
	//   "PHISHING_REUSE" - Warning is shown when the user reuses their protected
	// password on a phishing site.
	PasswordProtectionWarningTrigger string `json:"passwordProtectionWarningTrigger,omitempty"`
	// SafeBrowsingProtectionLevel: Current state of Safe Browsing protection level
	// (https://chromeenterprise.google/policies/#SafeBrowsingProtectionLevel).
	//
	// Possible values:
	//   "SAFE_BROWSING_LEVEL_UNSPECIFIED" - Browser protection level is not
	// specified.
	//   "DISABLED" - No protection against dangerous websites, downloads, and
	// extensions.
	//   "STANDARD" - Standard protection against websites, downloads, and
	// extensions that are known to be dangerous.
	//   "ENHANCED" - Faster, proactive protection against dangerous websites,
	// downloads, and extensions.
	SafeBrowsingProtectionLevel string `json:"safeBrowsingProtectionLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BrowserManagementState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BrowserManagementState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1BrowserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1BrowserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1CancelWipeDeviceMetadata: Metadata for
// CancelWipeDevice LRO.
type GoogleAppsCloudidentityDevicesV1CancelWipeDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1CancelWipeDeviceResponse: Response message
// for cancelling an unfinished device wipe.
type GoogleAppsCloudidentityDevicesV1CancelWipeDeviceResponse struct {
	// Device: Resultant Device object for the action. Note that asset tags will
	// not be returned in the device object.
	Device *GoogleAppsCloudidentityDevicesV1Device `json:"device,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Device") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1CancelWipeDeviceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1CancelWipeDeviceResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserMetadata: Metadata for
// CancelWipeDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserResponse: Response
// message for cancelling an unfinished user account wipe.
type GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *GoogleAppsCloudidentityDevicesV1DeviceUser `json:"deviceUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1CertificateAttributes: Stores information
// about a certificate.
type GoogleAppsCloudidentityDevicesV1CertificateAttributes struct {
	// CertificateTemplate: The X.509 extension for CertificateTemplate.
	CertificateTemplate *GoogleAppsCloudidentityDevicesV1CertificateTemplate `json:"certificateTemplate,omitempty"`
	// Fingerprint: The encoded certificate fingerprint.
	Fingerprint string `json:"fingerprint,omitempty"`
	// Issuer: The name of the issuer of this certificate.
	Issuer string `json:"issuer,omitempty"`
	// SerialNumber: Serial number of the certificate, Example: "123456789".
	SerialNumber string `json:"serialNumber,omitempty"`
	// Subject: The subject name of this certificate.
	Subject string `json:"subject,omitempty"`
	// Thumbprint: The certificate thumbprint.
	Thumbprint string `json:"thumbprint,omitempty"`
	// ValidationState: Output only. Validation state of this certificate.
	//
	// Possible values:
	//   "CERTIFICATE_VALIDATION_STATE_UNSPECIFIED" - Default value.
	//   "VALIDATION_SUCCESSFUL" - Certificate validation was successful.
	//   "VALIDATION_FAILED" - Certificate validation failed.
	ValidationState string `json:"validationState,omitempty"`
	// ValidityExpirationTime: Certificate not valid at or after this timestamp.
	ValidityExpirationTime string `json:"validityExpirationTime,omitempty"`
	// ValidityStartTime: Certificate not valid before this timestamp.
	ValidityStartTime string `json:"validityStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1CertificateAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1CertificateAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1CertificateTemplate: CertificateTemplate (v3
// Extension in X.509).
type GoogleAppsCloudidentityDevicesV1CertificateTemplate struct {
	// Id: The template id of the template. Example:
	// "1.3.6.1.4.1.311.21.8.15608621.11768144.5720724.16068415.6889630.81.2472537.7
	// 784047".
	Id string `json:"id,omitempty"`
	// MajorVersion: The Major version of the template. Example: 100.
	MajorVersion int64 `json:"majorVersion,omitempty"`
	// MinorVersion: The minor version of the template. Example: 12.
	MinorVersion int64 `json:"minorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1CertificateTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1CertificateTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1ClientState: Represents the state associated
// with an API client calling the Devices API. Resource representing
// ClientState and supports updates from API users
type GoogleAppsCloudidentityDevicesV1ClientState struct {
	// AssetTags: The caller can specify asset tags for this resource
	AssetTags []string `json:"assetTags,omitempty"`
	// ComplianceState: The compliance state of the resource as specified by the
	// API client.
	//
	// Possible values:
	//   "COMPLIANCE_STATE_UNSPECIFIED" - The compliance state of the resource is
	// unknown or unspecified.
	//   "COMPLIANT" - Device is compliant with third party policies
	//   "NON_COMPLIANT" - Device is not compliant with third party policies
	ComplianceState string `json:"complianceState,omitempty"`
	// CreateTime: Output only. The time the client state data was created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomId: This field may be used to store a unique identifier for the API
	// resource within which these CustomAttributes are a field.
	CustomId string `json:"customId,omitempty"`
	// Etag: The token that needs to be passed back for concurrency control in
	// updates. Token needs to be passed back in UpdateRequest
	Etag string `json:"etag,omitempty"`
	// HealthScore: The Health score of the resource. The Health score is the
	// callers specification of the condition of the device from a usability point
	// of view. For example, a third-party device management provider may specify a
	// health score based on its compliance with organizational policies.
	//
	// Possible values:
	//   "HEALTH_SCORE_UNSPECIFIED" - Default value
	//   "VERY_POOR" - The object is in very poor health as defined by the caller.
	//   "POOR" - The object is in poor health as defined by the caller.
	//   "NEUTRAL" - The object health is neither good nor poor, as defined by the
	// caller.
	//   "GOOD" - The object is in good health as defined by the caller.
	//   "VERY_GOOD" - The object is in very good health as defined by the caller.
	HealthScore string `json:"healthScore,omitempty"`
	// KeyValuePairs: The map of key-value attributes stored by callers specific to
	// a device. The total serialized length of this map may not exceed 10KB. No
	// limit is placed on the number of attributes in a map.
	KeyValuePairs map[string]GoogleAppsCloudidentityDevicesV1CustomAttributeValue `json:"keyValuePairs,omitempty"`
	// LastUpdateTime: Output only. The time the client state data was last
	// updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// Managed: The management state of the resource as specified by the API
	// client.
	//
	// Possible values:
	//   "MANAGED_STATE_UNSPECIFIED" - The management state of the resource is
	// unknown or unspecified.
	//   "MANAGED" - The resource is managed.
	//   "UNMANAGED" - The resource is not managed.
	Managed string `json:"managed,omitempty"`
	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the ClientState in
	// format: `devices/{device}/deviceUsers/{device_user}/clientState/{partner}`,
	// where partner corresponds to the partner storing the data. For partners
	// belonging to the "BeyondCorp Alliance", this is the partner ID specified to
	// you by Google. For all other callers, this is a string of the form:
	// `{customer}-suffix`, where `customer` is your customer ID. The *suffix* is
	// any string the caller specifies. This string will be displayed verbatim in
	// the administration console. This suffix is used in setting up Custom Access
	// Levels in Context-Aware Access. Your organization's customer ID can be
	// obtained from the URL: `GET
	// https://www.googleapis.com/admin/directory/v1/customers/my_customer` The
	// `id` field in the response contains the customer ID starting with the letter
	// 'C'. The customer ID to be used in this API is the string after the letter
	// 'C' (not including 'C')
	Name string `json:"name,omitempty"`
	// OwnerType: Output only. The owner of the ClientState
	//
	// Possible values:
	//   "OWNER_TYPE_UNSPECIFIED" - Unknown owner type
	//   "OWNER_TYPE_CUSTOMER" - Customer is the owner
	//   "OWNER_TYPE_PARTNER" - Partner is the owner
	OwnerType string `json:"ownerType,omitempty"`
	// ScoreReason: A descriptive cause of the health score.
	ScoreReason string `json:"scoreReason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssetTags") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssetTags") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1ClientState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1ClientState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1CreateDeviceMetadata: Metadata for
// CreateDevice LRO.
type GoogleAppsCloudidentityDevicesV1CreateDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1CustomAttributeValue: Additional custom
// attribute values may be one of these types
type GoogleAppsCloudidentityDevicesV1CustomAttributeValue struct {
	// BoolValue: Represents a boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// NumberValue: Represents a double value.
	NumberValue float64 `json:"numberValue,omitempty"`
	// StringValue: Represents a string value.
	StringValue string `json:"stringValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1CustomAttributeValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1CustomAttributeValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleAppsCloudidentityDevicesV1CustomAttributeValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAppsCloudidentityDevicesV1CustomAttributeValue
	var s1 struct {
		NumberValue gensupport.JSONFloat64 `json:"numberValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumberValue = float64(s1.NumberValue)
	return nil
}

// GoogleAppsCloudidentityDevicesV1DeleteDeviceMetadata: Metadata for
// DeleteDevice LRO.
type GoogleAppsCloudidentityDevicesV1DeleteDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1DeleteDeviceUserMetadata: Metadata for
// DeleteDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1DeleteDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1Device:  A Device within the Cloud Identity
// Devices API. Represents a Device known to Google Cloud, independent of the
// device ownership, type, and whether it is assigned or in use by a user.
type GoogleAppsCloudidentityDevicesV1Device struct {
	// AndroidSpecificAttributes: Output only. Attributes specific to Android
	// devices.
	AndroidSpecificAttributes *GoogleAppsCloudidentityDevicesV1AndroidAttributes `json:"androidSpecificAttributes,omitempty"`
	// AssetTag: Asset tag of the device.
	AssetTag string `json:"assetTag,omitempty"`
	// BasebandVersion: Output only. Baseband version of the device.
	BasebandVersion string `json:"basebandVersion,omitempty"`
	// BootloaderVersion: Output only. Device bootloader version. Example: 0.6.7.
	BootloaderVersion string `json:"bootloaderVersion,omitempty"`
	// Brand: Output only. Device brand. Example: Samsung.
	Brand string `json:"brand,omitempty"`
	// BuildNumber: Output only. Build number of the device.
	BuildNumber string `json:"buildNumber,omitempty"`
	// CompromisedState: Output only. Represents whether the Device is compromised.
	//
	// Possible values:
	//   "COMPROMISED_STATE_UNSPECIFIED" - Default value.
	//   "COMPROMISED" - The device is compromised (currently, this means Android
	// device is rooted).
	//   "UNCOMPROMISED" - The device is safe (currently, this means Android device
	// is unrooted).
	CompromisedState string `json:"compromisedState,omitempty"`
	// CreateTime: Output only. When the Company-Owned device was imported. This
	// field is empty for BYOD devices.
	CreateTime string `json:"createTime,omitempty"`
	// DeviceId: Unique identifier for the device.
	DeviceId string `json:"deviceId,omitempty"`
	// DeviceType: Output only. Type of device.
	//
	// Possible values:
	//   "DEVICE_TYPE_UNSPECIFIED" - Unknown device type
	//   "ANDROID" - Device is an Android device
	//   "IOS" - Device is an iOS device
	//   "GOOGLE_SYNC" - Device is a Google Sync device.
	//   "WINDOWS" - Device is a Windows device.
	//   "MAC_OS" - Device is a MacOS device.
	//   "LINUX" - Device is a Linux device.
	//   "CHROME_OS" - Device is a ChromeOS device.
	DeviceType string `json:"deviceType,omitempty"`
	// EnabledDeveloperOptions: Output only. Whether developer options is enabled
	// on device.
	EnabledDeveloperOptions bool `json:"enabledDeveloperOptions,omitempty"`
	// EnabledUsbDebugging: Output only. Whether USB debugging is enabled on
	// device.
	EnabledUsbDebugging bool `json:"enabledUsbDebugging,omitempty"`
	// EncryptionState: Output only. Device encryption state.
	//
	// Possible values:
	//   "ENCRYPTION_STATE_UNSPECIFIED" - Encryption Status is not set.
	//   "UNSUPPORTED_BY_DEVICE" - Device doesn't support encryption.
	//   "ENCRYPTED" - Device is encrypted.
	//   "NOT_ENCRYPTED" - Device is not encrypted.
	EncryptionState string `json:"encryptionState,omitempty"`
	// EndpointVerificationSpecificAttributes: Output only. Attributes specific to
	// Endpoint Verification
	// (https://cloud.google.com/endpoint-verification/docs/overview) devices.
	EndpointVerificationSpecificAttributes *GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes `json:"endpointVerificationSpecificAttributes,omitempty"`
	// Hostname: Host name of the device.
	Hostname string `json:"hostname,omitempty"`
	// Imei: Output only. IMEI number of device if GSM device; empty otherwise.
	Imei string `json:"imei,omitempty"`
	// KernelVersion: Output only. Kernel version of the device.
	KernelVersion string `json:"kernelVersion,omitempty"`
	// LastSyncTime: Most recent time when device synced with this service.
	LastSyncTime string `json:"lastSyncTime,omitempty"`
	// ManagementState: Output only. Management state of the device
	//
	// Possible values:
	//   "MANAGEMENT_STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "APPROVED" - Device is approved.
	//   "BLOCKED" - Device is blocked.
	//   "PENDING" - Device is pending approval.
	//   "UNPROVISIONED" - The device is not provisioned. Device will start from
	// this state until some action is taken (i.e. a user starts using the device).
	//   "WIPING" - Data and settings on the device are being removed.
	//   "WIPED" - All data and settings on the device are removed.
	ManagementState string `json:"managementState,omitempty"`
	// Manufacturer: Output only. Device manufacturer. Example: Motorola.
	Manufacturer string `json:"manufacturer,omitempty"`
	// Meid: Output only. MEID number of device if CDMA device; empty otherwise.
	Meid string `json:"meid,omitempty"`
	// Model: Output only. Model name of device. Example: Pixel 3.
	Model string `json:"model,omitempty"`
	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the Device in
	// format: `devices/{device}`, where device is the unique id assigned to the
	// Device. Important: Device API scopes require that you use domain-wide
	// delegation to access the API. For more information, see Set up the Devices
	// API (https://cloud.google.com/identity/docs/how-to/setup-devices).
	Name string `json:"name,omitempty"`
	// NetworkOperator: Output only. Mobile or network operator of device, if
	// available.
	NetworkOperator string `json:"networkOperator,omitempty"`
	// OsVersion: Output only. OS version of the device. Example: Android 8.1.0.
	OsVersion string `json:"osVersion,omitempty"`
	// OtherAccounts: Output only. Domain name for Google accounts on device. Type
	// for other accounts on device. On Android, will only be populated if
	// |ownership_privilege| is |PROFILE_OWNER| or |DEVICE_OWNER|. Does not include
	// the account signed in to the device policy app if that account's domain has
	// only one account. Examples: "com.example", "xyz.com".
	OtherAccounts []string `json:"otherAccounts,omitempty"`
	// OwnerType: Output only. Whether the device is owned by the company or an
	// individual
	//
	// Possible values:
	//   "DEVICE_OWNERSHIP_UNSPECIFIED" - Default value. The value is unused.
	//   "COMPANY" - Company owns the device.
	//   "BYOD" - Bring Your Own Device (i.e. individual owns the device)
	OwnerType string `json:"ownerType,omitempty"`
	// ReleaseVersion: Output only. OS release version. Example: 6.0.
	ReleaseVersion string `json:"releaseVersion,omitempty"`
	// SecurityPatchTime: Output only. OS security patch update time on device.
	SecurityPatchTime string `json:"securityPatchTime,omitempty"`
	// SerialNumber: Serial Number of device. Example: HT82V1A01076.
	SerialNumber string `json:"serialNumber,omitempty"`
	// UnifiedDeviceId: Output only. Unified device id of the device.
	UnifiedDeviceId string `json:"unifiedDeviceId,omitempty"`
	// WifiMacAddresses: WiFi MAC addresses of device.
	WifiMacAddresses []string `json:"wifiMacAddresses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AndroidSpecificAttributes")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AndroidSpecificAttributes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1Device) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1Device
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1DeviceUser: Represents a user's use of a
// Device in the Cloud Identity Devices API. A DeviceUser is a resource
// representing a user's use of a Device
type GoogleAppsCloudidentityDevicesV1DeviceUser struct {
	// CompromisedState: Compromised State of the DeviceUser object
	//
	// Possible values:
	//   "COMPROMISED_STATE_UNSPECIFIED" - Compromised state of Device User account
	// is unknown or unspecified.
	//   "COMPROMISED" - Device User Account is compromised.
	//   "NOT_COMPROMISED" - Device User Account is not compromised.
	CompromisedState string `json:"compromisedState,omitempty"`
	// CreateTime: When the user first signed in to the device
	CreateTime string `json:"createTime,omitempty"`
	// FirstSyncTime: Output only. Most recent time when user registered with this
	// service.
	FirstSyncTime string `json:"firstSyncTime,omitempty"`
	// LanguageCode: Output only. Default locale used on device, in IETF BCP-47
	// format.
	LanguageCode string `json:"languageCode,omitempty"`
	// LastSyncTime: Output only. Last time when user synced with policies.
	LastSyncTime string `json:"lastSyncTime,omitempty"`
	// ManagementState: Output only. Management state of the user on the device.
	//
	// Possible values:
	//   "MANAGEMENT_STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "WIPING" - This user's data and profile is being removed from the device.
	//   "WIPED" - This user's data and profile is removed from the device.
	//   "APPROVED" - User is approved to access data on the device.
	//   "BLOCKED" - User is blocked from accessing data on the device.
	//   "PENDING_APPROVAL" - User is awaiting approval.
	//   "UNENROLLED" - User is unenrolled from Advanced Windows Management, but
	// the Windows account is still intact.
	ManagementState string `json:"managementState,omitempty"`
	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the DeviceUser in
	// format: `devices/{device}/deviceUsers/{device_user}`, where `device_user`
	// uniquely identifies a user's use of a device.
	Name string `json:"name,omitempty"`
	// PasswordState: Password state of the DeviceUser object
	//
	// Possible values:
	//   "PASSWORD_STATE_UNSPECIFIED" - Password state not set.
	//   "PASSWORD_SET" - Password set in object.
	//   "PASSWORD_NOT_SET" - Password not set in object.
	PasswordState string `json:"passwordState,omitempty"`
	// UserAgent: Output only. User agent on the device for this specific user
	UserAgent string `json:"userAgent,omitempty"`
	// UserEmail: Email address of the user registered on the device.
	UserEmail string `json:"userEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompromisedState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompromisedState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1DeviceUser) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1DeviceUser
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes:
// Resource representing the Endpoint Verification-specific attributes
// (https://cloud.google.com/endpoint-verification/docs/device-information) of
// a device.
type GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes struct {
	// AdditionalSignals: Additional signals
	// (https://cloud.google.com/endpoint-verification/docs/device-information)
	// reported by Endpoint Verification. It includes the following attributes: *
	// Non-configurable attributes: hotfixes, av_installed, av_enabled,
	// windows_domain_name, is_os_native_firewall_enabled, and
	// is_secure_boot_enabled. * Configurable attributes
	// (https://cloud.google.com/endpoint-verification/docs/collect-config-attributes):
	// file, folder, and binary attributes; registry entries; and properties in a
	// plist.
	AdditionalSignals googleapi.RawMessage `json:"additionalSignals,omitempty"`
	// BrowserAttributes: Details of browser profiles reported by Endpoint
	// Verification.
	BrowserAttributes []*GoogleAppsCloudidentityDevicesV1BrowserAttributes `json:"browserAttributes,omitempty"`
	// CertificateAttributes: Details of certificates.
	CertificateAttributes []*GoogleAppsCloudidentityDevicesV1CertificateAttributes `json:"certificateAttributes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalSignals") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1ListEndpointAppsMetadata: Metadata for
// ListEndpointApps LRO.
type GoogleAppsCloudidentityDevicesV1ListEndpointAppsMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1SignoutDeviceUserMetadata: Metadata for
// SignoutDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1SignoutDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1UpdateClientStateMetadata: Metadata for
// UpdateClientState LRO.
type GoogleAppsCloudidentityDevicesV1UpdateClientStateMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1UpdateDeviceMetadata: Metadata for
// UpdateDevice LRO.
type GoogleAppsCloudidentityDevicesV1UpdateDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1WipeDeviceMetadata: Metadata for WipeDevice
// LRO.
type GoogleAppsCloudidentityDevicesV1WipeDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1WipeDeviceResponse: Response message for
// wiping all data on the device.
type GoogleAppsCloudidentityDevicesV1WipeDeviceResponse struct {
	// Device: Resultant Device object for the action. Note that asset tags will
	// not be returned in the device object.
	Device *GoogleAppsCloudidentityDevicesV1Device `json:"device,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Device") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1WipeDeviceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1WipeDeviceResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1WipeDeviceUserMetadata: Metadata for
// WipeDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1WipeDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1WipeDeviceUserResponse: Response message for
// wiping the user's account from the device.
type GoogleAppsCloudidentityDevicesV1WipeDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *GoogleAppsCloudidentityDevicesV1DeviceUser `json:"deviceUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAppsCloudidentityDevicesV1WipeDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1WipeDeviceUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Group: A group within the Cloud Identity Groups API. A `Group` is a
// collection of entities, where each entity is either a user, another group,
// or a service account.
type Group struct {
	// AdditionalGroupKeys: Output only. Additional group keys associated with the
	// Group.
	AdditionalGroupKeys []*EntityKey `json:"additionalGroupKeys,omitempty"`
	// CreateTime: Output only. The time when the `Group` was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: An extended description to help users determine the purpose of
	// a `Group`. Must not be longer than 4,096 characters.
	Description string `json:"description,omitempty"`
	// DisplayName: The display name of the `Group`.
	DisplayName string `json:"displayName,omitempty"`
	// DynamicGroupMetadata: Optional. Dynamic group metadata like queries and
	// status.
	DynamicGroupMetadata *DynamicGroupMetadata `json:"dynamicGroupMetadata,omitempty"`
	// GroupKey: Required. The `EntityKey` of the `Group`.
	GroupKey *EntityKey `json:"groupKey,omitempty"`
	// Labels: Required. One or more label entries that apply to the Group. Labels
	// contain a key with an empty value. Google Groups are the default type of
	// group and have a label with a key of
	// `cloudidentity.googleapis.com/groups.discussion_forum` and an empty value.
	// Existing Google Groups can have an additional label with a key of
	// `cloudidentity.googleapis.com/groups.security` and an empty value added to
	// them. **This is an immutable change and the security label cannot be removed
	// once added.** Dynamic groups have a label with a key of
	// `cloudidentity.googleapis.com/groups.dynamic`. Identity-mapped groups for
	// Cloud Search have a label with a key of `system/groups/external` and an
	// empty value. (Beta) Google Groups can be locked
	// (https://support.google.com/a?p=locked-groups). To lock a group, add a label
	// with a key of `cloudidentity.googleapis.com/groups.locked` and an empty
	// value. Doing so locks the group. To unlock the group, remove this label.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the `Group`. Shall
	// be of the form `groups/{group_id}`.
	Name string `json:"name,omitempty"`
	// Parent: Required. Immutable. The resource name of the entity under which
	// this `Group` resides in the Cloud Identity resource hierarchy. Must be of
	// the form `identitysources/{identity_source}` for external identity-mapped
	// groups (https://support.google.com/a/answer/9039510) or
	// `customers/{customer_id}` for Google Groups. The `customer_id` must begin
	// with "C" (for example, 'C046psxkn'). [Find your customer ID.]
	// (https://support.google.com/cloudidentity/answer/10070793)
	Parent string `json:"parent,omitempty"`
	// PosixGroups: Optional. The POSIX groups associated with the `Group`.
	PosixGroups []*PosixGroup `json:"posixGroups,omitempty"`
	// UpdateTime: Output only. The time when the `Group` was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdditionalGroupKeys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalGroupKeys") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Group) MarshalJSON() ([]byte, error) {
	type NoMethod Group
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GroupRelation: Message representing a transitive group of a user or a group.
type GroupRelation struct {
	// DisplayName: Display name for this group.
	DisplayName string `json:"displayName,omitempty"`
	// Group: Resource name for this group.
	Group string `json:"group,omitempty"`
	// GroupKey: Entity key has an id and a namespace. In case of discussion
	// forums, the id will be an email address without a namespace.
	GroupKey *EntityKey `json:"groupKey,omitempty"`
	// Labels: Labels for Group resource.
	Labels map[string]string `json:"labels,omitempty"`
	// RelationType: The relation between the member and the transitive group.
	//
	// Possible values:
	//   "RELATION_TYPE_UNSPECIFIED" - The relation type is undefined or
	// undetermined.
	//   "DIRECT" - The two entities have only a direct membership with each other.
	//   "INDIRECT" - The two entities have only an indirect membership with each
	// other.
	//   "DIRECT_AND_INDIRECT" - The two entities have both a direct and an
	// indirect membership with each other.
	RelationType string `json:"relationType,omitempty"`
	// Roles: Membership roles of the member for the group.
	Roles []*TransitiveMembershipRole `json:"roles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroupRelation) MarshalJSON() ([]byte, error) {
	type NoMethod GroupRelation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdpCredential: Credential for verifying signatures produced by the Identity
// Provider.
type IdpCredential struct {
	// DsaKeyInfo: Output only. Information of a DSA public key.
	DsaKeyInfo *DsaPublicKeyInfo `json:"dsaKeyInfo,omitempty"`
	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the credential.
	Name string `json:"name,omitempty"`
	// RsaKeyInfo: Output only. Information of a RSA public key.
	RsaKeyInfo *RsaPublicKeyInfo `json:"rsaKeyInfo,omitempty"`
	// UpdateTime: Output only. Time when the `IdpCredential` was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DsaKeyInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DsaKeyInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdpCredential) MarshalJSON() ([]byte, error) {
	type NoMethod IdpCredential
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InboundSamlSsoProfile: A SAML 2.0
// (https://www.oasis-open.org/standards#samlv2.0) federation between a Google
// enterprise customer and a SAML identity provider.
type InboundSamlSsoProfile struct {
	// Customer: Immutable. The customer. For example: `customers/C0123abc`.
	Customer string `json:"customer,omitempty"`
	// DisplayName: Human-readable name of the SAML SSO profile.
	DisplayName string `json:"displayName,omitempty"`
	// IdpConfig: SAML identity provider configuration.
	IdpConfig *SamlIdpConfig `json:"idpConfig,omitempty"`
	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the SAML SSO
	// profile.
	Name string `json:"name,omitempty"`
	// SpConfig: SAML service provider configuration for this SAML SSO profile.
	// These are the service provider details provided by Google that should be
	// configured on the corresponding identity provider.
	SpConfig *SamlSpConfig `json:"spConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InboundSamlSsoProfile) MarshalJSON() ([]byte, error) {
	type NoMethod InboundSamlSsoProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InboundSsoAssignment: Targets with "set" SSO assignments and their
// respective assignments.
type InboundSsoAssignment struct {
	// Customer: Immutable. The customer. For example: `customers/C0123abc`.
	Customer string `json:"customer,omitempty"`
	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the Inbound SSO
	// Assignment.
	Name string `json:"name,omitempty"`
	// Rank: Must be zero (which is the default value so it can be omitted) for
	// assignments with `target_org_unit` set and must be greater-than-or-equal-to
	// one for assignments with `target_group` set.
	Rank int64 `json:"rank,omitempty"`
	// SamlSsoInfo: SAML SSO details. Must be set if and only if `sso_mode` is set
	// to `SAML_SSO`.
	SamlSsoInfo *SamlSsoInfo `json:"samlSsoInfo,omitempty"`
	// SignInBehavior: Assertions about users assigned to an IdP will always be
	// accepted from that IdP. This controls whether/when Google should redirect a
	// user to the IdP. Unset (defaults) is the recommended configuration.
	SignInBehavior *SignInBehavior `json:"signInBehavior,omitempty"`
	// SsoMode: Inbound SSO behavior.
	//
	// Possible values:
	//   "SSO_MODE_UNSPECIFIED" - Not allowed.
	//   "SSO_OFF" - Disable SSO for the targeted users.
	//   "SAML_SSO" - Use an external SAML Identity Provider for SSO for the
	// targeted users.
	//   "DOMAIN_WIDE_SAML_IF_ENABLED" - Use the domain-wide SAML Identity Provider
	// for the targeted users if one is configured; otherwise, this is equivalent
	// to `SSO_OFF`. Note that this will also be equivalent to `SSO_OFF` if/when
	// support for domain-wide SAML is removed. Google may disallow this mode at
	// that point and existing assignments with this mode may be automatically
	// changed to `SSO_OFF`.
	SsoMode string `json:"ssoMode,omitempty"`
	// TargetGroup: Immutable. Must be of the form `groups/{group}`.
	TargetGroup string `json:"targetGroup,omitempty"`
	// TargetOrgUnit: Immutable. Must be of the form `orgUnits/{org_unit}`.
	TargetOrgUnit string `json:"targetOrgUnit,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InboundSsoAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod InboundSsoAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IsInvitableUserResponse: Response for IsInvitableUser RPC.
type IsInvitableUserResponse struct {
	// IsInvitableUser: Returns true if the email address is invitable.
	IsInvitableUser bool `json:"isInvitableUser,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IsInvitableUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsInvitableUser") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IsInvitableUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod IsInvitableUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListClientStatesResponse: Response message that is returned in LRO result of
// ListClientStates Operation.
type ListClientStatesResponse struct {
	// ClientStates: Client states meeting the list restrictions.
	ClientStates []*ClientState `json:"clientStates,omitempty"`
	// NextPageToken: Token to retrieve the next page of results. Empty if there
	// are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientStates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientStates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListClientStatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListClientStatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDeviceUsersResponse: Response message that is returned from the
// ListDeviceUsers method.
type ListDeviceUsersResponse struct {
	// DeviceUsers: Devices meeting the list restrictions.
	DeviceUsers []*DeviceUser `json:"deviceUsers,omitempty"`
	// NextPageToken: Token to retrieve the next page of results. Empty if there
	// are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DeviceUsers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceUsers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDeviceUsersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDeviceUsersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDevicesResponse: Response message that is returned from the ListDevices
// method.
type ListDevicesResponse struct {
	// Devices: Devices meeting the list restrictions.
	Devices []*Device `json:"devices,omitempty"`
	// NextPageToken: Token to retrieve the next page of results. Empty if there
	// are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Devices") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Devices") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDevicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDevicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGroupsResponse: The response message for GroupsService.ListGroups.
type ListGroupsResponse struct {
	// Groups: The `Group` resources under the specified `parent`.
	Groups []*Group `json:"groups,omitempty"`
	// NextPageToken: A continuation token to retrieve the next page of results, or
	// empty if there are no more results available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Groups") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Groups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListIdpCredentialsResponse: Response of the
// InboundSamlSsoProfilesService.ListIdpCredentials method.
type ListIdpCredentialsResponse struct {
	// IdpCredentials: The IdpCredentials from the specified InboundSamlSsoProfile.
	IdpCredentials []*IdpCredential `json:"idpCredentials,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IdpCredentials") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdpCredentials") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListIdpCredentialsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListIdpCredentialsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListInboundSamlSsoProfilesResponse: Response of the
// InboundSamlSsoProfilesService.ListInboundSamlSsoProfiles method.
type ListInboundSamlSsoProfilesResponse struct {
	// InboundSamlSsoProfiles: List of InboundSamlSsoProfiles.
	InboundSamlSsoProfiles []*InboundSamlSsoProfile `json:"inboundSamlSsoProfiles,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InboundSamlSsoProfiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InboundSamlSsoProfiles") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListInboundSamlSsoProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListInboundSamlSsoProfilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListInboundSsoAssignmentsResponse: Response of the
// InboundSsoAssignmentsService.ListInboundSsoAssignments method.
type ListInboundSsoAssignmentsResponse struct {
	// InboundSsoAssignments: The assignments.
	InboundSsoAssignments []*InboundSsoAssignment `json:"inboundSsoAssignments,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InboundSsoAssignments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InboundSsoAssignments") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListInboundSsoAssignmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListInboundSsoAssignmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMembershipsResponse: The response message for
// MembershipsService.ListMemberships.
type ListMembershipsResponse struct {
	// Memberships: The `Membership`s under the specified `parent`.
	Memberships []*Membership `json:"memberships,omitempty"`
	// NextPageToken: A continuation token to retrieve the next page of results, or
	// empty if there are no more results available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Memberships") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Memberships") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMembershipsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMembershipsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOrgMembershipsResponse: The response message for
// OrgMembershipsService.ListOrgMemberships.
type ListOrgMembershipsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is empty, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// OrgMemberships: The non-vacuous membership in an orgUnit.
	OrgMemberships []*OrgMembership `json:"orgMemberships,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOrgMembershipsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOrgMembershipsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPoliciesResponse: The response message for PoliciesService.ListPolicies.
type ListPoliciesResponse struct {
	// NextPageToken: The pagination token to retrieve the next page of results. If
	// this field is empty, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Policies: The results
	Policies []*Policy `json:"policies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListUserInvitationsResponse: Response message for UserInvitation listing
// request.
type ListUserInvitationsResponse struct {
	// NextPageToken: The token for the next page. If not empty, indicates that
	// there may be more `UserInvitation` resources that match the listing request;
	// this value can be used in a subsequent ListUserInvitationsRequest to get
	// continued results with the current list call.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// UserInvitations: The list of UserInvitation resources.
	UserInvitations []*UserInvitation `json:"userInvitations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListUserInvitationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUserInvitationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LookupGroupNameResponse: The response message for
// GroupsService.LookupGroupName.
type LookupGroupNameResponse struct {
	// Name: Output only. The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the looked-up
	// `Group`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LookupGroupNameResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LookupGroupNameResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LookupMembershipNameResponse: The response message for
// MembershipsService.LookupMembershipName.
type LookupMembershipNameResponse struct {
	// Name: The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the looked-up
	// `Membership`. Must be of the form
	// `groups/{group_id}/memberships/{membership_id}`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LookupMembershipNameResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LookupMembershipNameResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LookupSelfDeviceUsersResponse: Response containing resource names of the
// DeviceUsers associated with the caller's credentials.
type LookupSelfDeviceUsersResponse struct {
	// Customer: The customer Id that may be passed back to other Devices API
	// methods such as List, Get, etc.
	Customer string `json:"customer,omitempty"`
	// Names: Resource names (https://cloud.google.com/apis/design/resource_names)
	// of the DeviceUsers in the format:
	// `devices/{device_id}/deviceUsers/{user_resource_id}`, where device_id is the
	// unique ID assigned to a Device and user_resource_id is the unique user ID
	Names []string `json:"names,omitempty"`
	// NextPageToken: Token to retrieve the next page of results. Empty if there
	// are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LookupSelfDeviceUsersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LookupSelfDeviceUsersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MemberRelation: Message representing a transitive membership of a group.
type MemberRelation struct {
	// Member: Resource name for this member.
	Member string `json:"member,omitempty"`
	// PreferredMemberKey: Entity key has an id and a namespace. In case of
	// discussion forums, the id will be an email address without a namespace.
	PreferredMemberKey []*EntityKey `json:"preferredMemberKey,omitempty"`
	// RelationType: The relation between the group and the transitive membership.
	//
	// Possible values:
	//   "RELATION_TYPE_UNSPECIFIED" - The relation type is undefined or
	// undetermined.
	//   "DIRECT" - The two entities have only a direct membership with each other.
	//   "INDIRECT" - The two entities have only an indirect membership with each
	// other.
	//   "DIRECT_AND_INDIRECT" - The two entities have both a direct and an
	// indirect membership with each other.
	RelationType string `json:"relationType,omitempty"`
	// Roles: The membership role details (i.e name of role and expiry time).
	Roles []*TransitiveMembershipRole `json:"roles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Member") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Member") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MemberRelation) MarshalJSON() ([]byte, error) {
	type NoMethod MemberRelation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MemberRestriction: The definition of MemberRestriction
type MemberRestriction struct {
	// Evaluation: The evaluated state of this restriction on a group.
	Evaluation *RestrictionEvaluation `json:"evaluation,omitempty"`
	// Query: Member Restriction as defined by CEL expression. Supported
	// restrictions are: `member.customer_id` and `member.type`. Valid values for
	// `member.type` are `1`, `2` and `3`. They correspond to USER,
	// SERVICE_ACCOUNT, and GROUP respectively. The value for `member.customer_id`
	// only supports `groupCustomerId()` currently which means the customer id of
	// the group will be used for restriction. Supported operators are `&&`, `||`
	// and `==`, corresponding to AND, OR, and EQUAL. Examples: Allow only service
	// accounts of given customer to be members. `member.type == 2 &&
	// member.customer_id == groupCustomerId()` Allow only users or groups to be
	// members. `member.type == 1 || member.type == 3`
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MemberRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod MemberRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Membership: A membership within the Cloud Identity Groups API. A
// `Membership` defines a relationship between a `Group` and an entity
// belonging to that `Group`, referred to as a "member".
type Membership struct {
	// CreateTime: Output only. The time when the `Membership` was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeliverySetting: Output only. Delivery setting associated with the
	// membership.
	//
	// Possible values:
	//   "DELIVERY_SETTING_UNSPECIFIED" - Default. Should not be used.
	//   "ALL_MAIL" - Represents each mail should be delivered
	//   "DIGEST" - Represents 1 email for every 25 messages.
	//   "DAILY" - Represents daily summary of messages.
	//   "NONE" - Represents no delivery.
	//   "DISABLED" - Represents disabled state.
	DeliverySetting string `json:"deliverySetting,omitempty"`
	// MemberKey: Immutable. The `EntityKey` of the member. Either `member_key` or
	// `preferred_member_key` must be set when calling
	// MembershipsService.CreateMembership but not both; both shall be set when
	// returned.
	MemberKey *EntityKey `json:"memberKey,omitempty"`
	// Name: Output only. The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the `Membership`.
	// Shall be of the form `groups/{group_id}/memberships/{membership_id}`.
	Name string `json:"name,omitempty"`
	// PreferredMemberKey: Required. Immutable. The `EntityKey` of the member.
	// Either `member_key` or `preferred_member_key` must be set when calling
	// MembershipsService.CreateMembership but not both; both shall be set when
	// returned.
	PreferredMemberKey *EntityKey `json:"preferredMemberKey,omitempty"`
	// Roles: The `MembershipRole`s that apply to the `Membership`. If unspecified,
	// defaults to a single `MembershipRole` with `name` `MEMBER`. Must not contain
	// duplicate `MembershipRole`s with the same `name`.
	Roles []*MembershipRole `json:"roles,omitempty"`
	// Type: Output only. The type of the membership.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default. Should not be used.
	//   "USER" - Represents user type.
	//   "SERVICE_ACCOUNT" - Represents service account type.
	//   "GROUP" - Represents group type.
	//   "SHARED_DRIVE" - Represents Shared drive.
	//   "CBCM_BROWSER" - Represents a CBCM-managed Chrome Browser type.
	//   "OTHER" - Represents other type.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The time when the `Membership` was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Membership) MarshalJSON() ([]byte, error) {
	type NoMethod Membership
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipAdjacencyList: Membership graph's path information as an adjacency
// list.
type MembershipAdjacencyList struct {
	// Edges: Each edge contains information about the member that belongs to this
	// group. Note: Fields returned here will help identify the specific Membership
	// resource (e.g `name`, `preferred_member_key` and `role`), but may not be a
	// comprehensive list of all fields.
	Edges []*Membership `json:"edges,omitempty"`
	// Group: Resource name of the group that the members belong to.
	Group string `json:"group,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Edges") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Edges") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipAdjacencyList) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipAdjacencyList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipRelation: Message containing membership relation.
type MembershipRelation struct {
	// Description: An extended description to help users determine the purpose of
	// a `Group`.
	Description string `json:"description,omitempty"`
	// DisplayName: The display name of the `Group`.
	DisplayName string `json:"displayName,omitempty"`
	// Group: The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the `Group`. Shall
	// be of the form `groups/{group_id}`.
	Group string `json:"group,omitempty"`
	// GroupKey: The `EntityKey` of the `Group`.
	GroupKey *EntityKey `json:"groupKey,omitempty"`
	// Labels: One or more label entries that apply to the Group. Currently
	// supported labels contain a key with an empty value.
	Labels map[string]string `json:"labels,omitempty"`
	// Membership: The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the `Membership`.
	// Shall be of the form `groups/{group_id}/memberships/{membership_id}`.
	Membership string `json:"membership,omitempty"`
	// Roles: The `MembershipRole`s that apply to the `Membership`.
	Roles []*MembershipRole `json:"roles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipRelation) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipRelation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipRole: A membership role within the Cloud Identity Groups API. A
// `MembershipRole` defines the privileges granted to a `Membership`.
type MembershipRole struct {
	// ExpiryDetail: The expiry details of the `MembershipRole`. Expiry details are
	// only supported for `MEMBER` `MembershipRoles`. May be set if `name` is
	// `MEMBER`. Must not be set if `name` is any other value.
	ExpiryDetail *ExpiryDetail `json:"expiryDetail,omitempty"`
	// Name: The name of the `MembershipRole`. Must be one of `OWNER`, `MANAGER`,
	// `MEMBER`.
	Name string `json:"name,omitempty"`
	// RestrictionEvaluations: Evaluations of restrictions applied to parent group
	// on this membership.
	RestrictionEvaluations *RestrictionEvaluations `json:"restrictionEvaluations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpiryDetail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpiryDetail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipRole) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipRole
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembershipRoleRestrictionEvaluation: The evaluated state of this
// restriction.
type MembershipRoleRestrictionEvaluation struct {
	// State: Output only. The current state of the restriction
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default. Should not be used.
	//   "COMPLIANT" - The member adheres to the parent group's restriction.
	//   "FORWARD_COMPLIANT" - The group-group membership might be currently
	// violating some parent group's restriction but in future, it will never allow
	// any new member in the child group which can violate parent group's
	// restriction.
	//   "NON_COMPLIANT" - The member violates the parent group's restriction.
	//   "EVALUATING" - The state of the membership is under evaluation.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembershipRoleRestrictionEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipRoleRestrictionEvaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModifyMembershipRolesRequest: The request message for
// MembershipsService.ModifyMembershipRoles.
type ModifyMembershipRolesRequest struct {
	// AddRoles: The `MembershipRole`s to be added. Adding or removing roles in the
	// same request as updating roles is not supported. Must not be set if
	// `update_roles_params` is set.
	AddRoles []*MembershipRole `json:"addRoles,omitempty"`
	// RemoveRoles: The `name`s of the `MembershipRole`s to be removed. Adding or
	// removing roles in the same request as updating roles is not supported. It is
	// not possible to remove the `MEMBER` `MembershipRole`. If you wish to delete
	// a `Membership`, call MembershipsService.DeleteMembership instead. Must not
	// contain `MEMBER`. Must not be set if `update_roles_params` is set.
	RemoveRoles []string `json:"removeRoles,omitempty"`
	// UpdateRolesParams: The `MembershipRole`s to be updated. Updating roles in
	// the same request as adding or removing roles is not supported. Must not be
	// set if either `add_roles` or `remove_roles` is set.
	UpdateRolesParams []*UpdateMembershipRolesParams `json:"updateRolesParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddRoles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddRoles") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyMembershipRolesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyMembershipRolesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModifyMembershipRolesResponse: The response message for
// MembershipsService.ModifyMembershipRoles.
type ModifyMembershipRolesResponse struct {
	// Membership: The `Membership` resource after modifying its `MembershipRole`s.
	Membership *Membership `json:"membership,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Membership") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyMembershipRolesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyMembershipRolesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MoveOrgMembershipRequest: The request message for
// OrgMembershipsService.MoveOrgMembership.
type MoveOrgMembershipRequest struct {
	// Customer: Required. Immutable. Customer on whose membership change is made.
	// All authorization will happen on the role assignments of this customer.
	// Format: customers/{$customerId} where `$customerId` is the `id` from the
	// Admin SDK `Customer` resource
	// (https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers).
	// You may also use `customers/my_customer` to specify your own organization.
	Customer string `json:"customer,omitempty"`
	// DestinationOrgUnit: Required. Immutable. OrgUnit where the membership will
	// be moved to. Format: orgUnits/{$orgUnitId} where `$orgUnitId` is the
	// `orgUnitId` from the Admin SDK `OrgUnit` resource
	// (https://developers.google.com/admin-sdk/directory/reference/rest/v1/orgunits).
	DestinationOrgUnit string `json:"destinationOrgUnit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MoveOrgMembershipRequest) MarshalJSON() ([]byte, error) {
	type NoMethod MoveOrgMembershipRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrgMembership: A membership in an OrgUnit. An `OrgMembership` defines a
// relationship between an `OrgUnit` and an entity belonging to that `OrgUnit`,
// referred to as a "member".
type OrgMembership struct {
	// Member: Immutable. Org member id as full resource name. Format for shared
	// drive resource: //drive.googleapis.com/drives/{$memberId} where `$memberId`
	// is the `id` from Drive API (V3) `Drive` resource
	// (https://developers.google.com/drive/api/v3/reference/drives#resource).
	Member string `json:"member,omitempty"`
	// MemberUri: Uri with which you can read the member. This follows
	// https://aip.dev/122 Format for shared drive resource:
	// https://drive.googleapis.com/drive/v3/drives/{$memberId} where `$memberId`
	// is the `id` from Drive API (V3) `Drive` resource
	// (https://developers.google.com/drive/api/v3/reference/drives#resource).
	MemberUri string `json:"memberUri,omitempty"`
	// Name: Required. Immutable. The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the OrgMembership.
	// Format: orgUnits/{$orgUnitId}/memberships/{$membership} The `$orgUnitId` is
	// the `orgUnitId` from the Admin SDK `OrgUnit` resource
	// (https://developers.google.com/admin-sdk/directory/reference/rest/v1/orgunits).
	// The `$membership` shall be of the form `{$entityType};{$memberId}`, where
	// `$entityType` is the enum value of [OrgMembership.EntityType], and
	// `memberId` is the `id` from Drive API (V3) `Drive` resource
	// (https://developers.google.com/drive/api/v3/reference/drives#resource) for
	// OrgMembership.EntityType.SHARED_DRIVE.
	Name string `json:"name,omitempty"`
	// Type: Immutable. Entity type for the org member.
	//
	// Possible values:
	//   "ENTITY_TYPE_UNSPECIFIED" - Equivalent to no resource type mentioned
	//   "SHARED_DRIVE" - Shared drive as resource type
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Member") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Member") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrgMembership) MarshalJSON() ([]byte, error) {
	type NoMethod OrgMembership
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: A Policy resource binds an instance of a single Setting with the
// scope of a PolicyQuery. The Setting instance will be applied to all entities
// that satisfy the query.
type Policy struct {
	// Customer: Immutable. Customer that the Policy belongs to. The value is in
	// the format 'customers/{customerId}'. The `customerId` must begin with "C" To
	// find your customer ID in Admin Console see
	// https://support.google.com/a/answer/10070793.
	Customer string `json:"customer,omitempty"`
	// Name: Output only. Identifier. The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the Policy. Format:
	// policies/{policy}.
	Name string `json:"name,omitempty"`
	// PolicyQuery: Required. The PolicyQuery the Setting applies to.
	PolicyQuery *PolicyQuery `json:"policyQuery,omitempty"`
	// Setting: Required. The Setting configured by this Policy.
	Setting *Setting `json:"setting,omitempty"`
	// Type: Output only. The type of the policy.
	//
	// Possible values:
	//   "POLICY_TYPE_UNSPECIFIED" - Unspecified policy type.
	//   "SYSTEM" - Policy type denoting the system-configured policies.
	//   "ADMIN" - Policy type denoting the admin-configurable policies.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyQuery: PolicyQuery
type PolicyQuery struct {
	// Group: Immutable. The group that the query applies to. This field is only
	// set if there is a single value for group that satisfies all clauses of the
	// query. If no group applies, this will be the empty string.
	Group string `json:"group,omitempty"`
	// OrgUnit: Required. Immutable. Non-empty default. The OrgUnit the query
	// applies to. This field is only set if there is a single value for org_unit
	// that satisfies all clauses of the query.
	OrgUnit string `json:"orgUnit,omitempty"`
	// Query: Immutable. The CEL query that defines which entities the Policy
	// applies to (ex. a User entity). For details about CEL see
	// https://opensource.google.com/projects/cel. The OrgUnits the Policy applies
	// to are represented by a clause like so: entity.org_units.exists(org_unit,
	// org_unit.org_unit_id == orgUnitId('{orgUnitId}')) The Group the Policy
	// applies to are represented by a clause like so: entity.groups.exists(group,
	// group.group_id == groupId('{groupId}')) The Licenses the Policy applies to
	// are represented by a clause like so: entity.licenses.exists(license, license
	// in ['/product/{productId}/sku/{skuId}']) The above clauses can be present in
	// any combination, and used in conjunction with the &&, || and ! operators.
	// The org_unit and group fields below are helper fields that contain the
	// corresponding value(s) as the query to make the query easier to use.
	Query string `json:"query,omitempty"`
	// SortOrder: Output only. The decimal sort order of this PolicyQuery. The
	// value is relative to all other policies with the same setting type for the
	// customer. (There are no duplicates within this set).
	SortOrder float64 `json:"sortOrder,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Group") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Group") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyQuery) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *PolicyQuery) UnmarshalJSON(data []byte) error {
	type NoMethod PolicyQuery
	var s1 struct {
		SortOrder gensupport.JSONFloat64 `json:"sortOrder"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SortOrder = float64(s1.SortOrder)
	return nil
}

// PosixGroup: POSIX Group definition to represent a group in a POSIX compliant
// system. Caution: POSIX groups are deprecated. As of September 26, 2024, you
// can no longer create new POSIX groups. For more information, see
// https://cloud.google.com/identity/docs/deprecations/posix-groups
type PosixGroup struct {
	// Gid: GID of the POSIX group.
	Gid uint64 `json:"gid,omitempty,string"`
	// Name: Name of the POSIX group.
	Name string `json:"name,omitempty"`
	// SystemId: System identifier for which group name and gid apply to. If not
	// specified it will default to empty value.
	SystemId string `json:"systemId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Gid") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Gid") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosixGroup) MarshalJSON() ([]byte, error) {
	type NoMethod PosixGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestrictionEvaluation: The evaluated state of this restriction.
type RestrictionEvaluation struct {
	// State: Output only. The current state of the restriction
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default. Should not be used.
	//   "EVALUATING" - The restriction state is currently being evaluated.
	//   "COMPLIANT" - All transitive memberships are adhering to restriction.
	//   "FORWARD_COMPLIANT" - Some transitive memberships violate the restriction.
	// No new violating memberships can be added.
	//   "NON_COMPLIANT" - Some transitive memberships violate the restriction. New
	// violating direct memberships will be denied while indirect memberships may
	// be added.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestrictionEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod RestrictionEvaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestrictionEvaluations: Evaluations of restrictions applied to parent group
// on this membership.
type RestrictionEvaluations struct {
	// MemberRestrictionEvaluation: Evaluation of the member restriction applied to
	// this membership. Empty if the user lacks permission to view the restriction
	// evaluation.
	MemberRestrictionEvaluation *MembershipRoleRestrictionEvaluation `json:"memberRestrictionEvaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "MemberRestrictionEvaluation") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MemberRestrictionEvaluation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestrictionEvaluations) MarshalJSON() ([]byte, error) {
	type NoMethod RestrictionEvaluations
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RsaPublicKeyInfo: Information of a RSA public key.
type RsaPublicKeyInfo struct {
	// KeySize: Key size in bits (size of the modulus).
	KeySize int64 `json:"keySize,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KeySize") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KeySize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RsaPublicKeyInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RsaPublicKeyInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SamlIdpConfig: SAML IDP (identity provider) configuration.
type SamlIdpConfig struct {
	// ChangePasswordUri: The **Change Password URL** of the identity provider.
	// Users will be sent to this URL when changing their passwords at
	// `myaccount.google.com`. This takes precedence over the change password URL
	// configured at customer-level. Must use `HTTPS`.
	ChangePasswordUri string `json:"changePasswordUri,omitempty"`
	// EntityId: Required. The SAML **Entity ID** of the identity provider.
	EntityId string `json:"entityId,omitempty"`
	// LogoutRedirectUri: The **Logout Redirect URL** (sign-out page URL) of the
	// identity provider. When a user clicks the sign-out link on a Google page,
	// they will be redirected to this URL. This is a pure redirect with no
	// attached SAML `LogoutRequest` i.e. SAML single logout is not supported. Must
	// use `HTTPS`.
	LogoutRedirectUri string `json:"logoutRedirectUri,omitempty"`
	// SingleSignOnServiceUri: Required. The `SingleSignOnService` endpoint
	// location (sign-in page URL) of the identity provider. This is the URL where
	// the `AuthnRequest` will be sent. Must use `HTTPS`. Assumed to accept the
	// `HTTP-Redirect` binding.
	SingleSignOnServiceUri string `json:"singleSignOnServiceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChangePasswordUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangePasswordUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SamlIdpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SamlIdpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SamlSpConfig: SAML SP (service provider) configuration.
type SamlSpConfig struct {
	// AssertionConsumerServiceUri: Output only. The SAML **Assertion Consumer
	// Service (ACS) URL** to be used for the IDP-initiated login. Assumed to
	// accept response messages via the `HTTP-POST` binding.
	AssertionConsumerServiceUri string `json:"assertionConsumerServiceUri,omitempty"`
	// EntityId: Output only. The SAML **Entity ID** for this service provider.
	EntityId string `json:"entityId,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AssertionConsumerServiceUri") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssertionConsumerServiceUri") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SamlSpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SamlSpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SamlSsoInfo: Details that are applicable when `sso_mode` == `SAML_SSO`.
type SamlSsoInfo struct {
	// InboundSamlSsoProfile: Required. Name of the `InboundSamlSsoProfile` to use.
	// Must be of the form `inboundSamlSsoProfiles/{inbound_saml_sso_profile}`.
	InboundSamlSsoProfile string `json:"inboundSamlSsoProfile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InboundSamlSsoProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InboundSamlSsoProfile") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SamlSsoInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SamlSsoInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchDirectGroupsResponse: The response message for
// MembershipsService.SearchDirectGroups.
type SearchDirectGroupsResponse struct {
	// Memberships: List of direct groups satisfying the query.
	Memberships []*MembershipRelation `json:"memberships,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results available for listing.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Memberships") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Memberships") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchDirectGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchDirectGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchGroupsResponse: The response message for GroupsService.SearchGroups.
type SearchGroupsResponse struct {
	// Groups: The `Group` resources that match the search query.
	Groups []*Group `json:"groups,omitempty"`
	// NextPageToken: A continuation token to retrieve the next page of results, or
	// empty if there are no more results available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Groups") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Groups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchTransitiveGroupsResponse: The response message for
// MembershipsService.SearchTransitiveGroups.
type SearchTransitiveGroupsResponse struct {
	// Memberships: List of transitive groups satisfying the query.
	Memberships []*GroupRelation `json:"memberships,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results available for listing.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Memberships") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Memberships") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchTransitiveGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchTransitiveGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchTransitiveMembershipsResponse: The response message for
// MembershipsService.SearchTransitiveMemberships.
type SearchTransitiveMembershipsResponse struct {
	// Memberships: List of transitive memberships satisfying the query.
	Memberships []*MemberRelation `json:"memberships,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Memberships") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Memberships") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchTransitiveMembershipsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchTransitiveMembershipsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecuritySettings: The definiion of security settings.
type SecuritySettings struct {
	// MemberRestriction: The Member Restriction value
	MemberRestriction *MemberRestriction `json:"memberRestriction,omitempty"`
	// Name: Output only. The resource name of the security settings. Shall be of
	// the form `groups/{group_id}/securitySettings`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MemberRestriction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MemberRestriction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod SecuritySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SendUserInvitationRequest: A request to send email for inviting target user
// corresponding to the UserInvitation.
type SendUserInvitationRequest struct {
}

// Setting: Setting
type Setting struct {
	// Type: Required. Immutable. The type of the Setting. .
	Type string `json:"type,omitempty"`
	// Value: Required. The value of the Setting.
	Value googleapi.RawMessage `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Setting) MarshalJSON() ([]byte, error) {
	type NoMethod Setting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SignInBehavior: Controls sign-in behavior.
type SignInBehavior struct {
	// RedirectCondition: When to redirect sign-ins to the IdP.
	//
	// Possible values:
	//   "REDIRECT_CONDITION_UNSPECIFIED" - Default and means "always"
	//   "NEVER" - Sign-in flows where the user is prompted for their identity will
	// not redirect to the IdP (so the user will most likely be prompted by Google
	// for a password), but special flows like IdP-initiated SAML and sign-in
	// following automatic redirection to the IdP by domain-specific service URLs
	// will accept the IdP's assertion of the user's identity.
	RedirectCondition string `json:"redirectCondition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectCondition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectCondition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SignInBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod SignInBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransitiveMembershipRole: Message representing the role of a
// TransitiveMembership.
type TransitiveMembershipRole struct {
	// Role: TransitiveMembershipRole in string format. Currently supported
	// TransitiveMembershipRoles: "MEMBER", "OWNER", and "MANAGER".
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Role") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Role") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitiveMembershipRole) MarshalJSON() ([]byte, error) {
	type NoMethod TransitiveMembershipRole
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateInboundSamlSsoProfileOperationMetadata: LRO response metadata for
// InboundSamlSsoProfilesService.UpdateInboundSamlSsoProfile.
type UpdateInboundSamlSsoProfileOperationMetadata struct {
	// State: State of this Operation Will be "awaiting-multi-party-approval" when
	// the operation is deferred due to the target customer having enabled
	// Multi-party approval for sensitive actions
	// (https://support.google.com/a/answer/13790448).
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateInboundSamlSsoProfileOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateInboundSamlSsoProfileOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateInboundSsoAssignmentOperationMetadata: LRO response metadata for
// InboundSsoAssignmentsService.UpdateInboundSsoAssignment.
type UpdateInboundSsoAssignmentOperationMetadata struct {
}

// UpdateMembershipRolesParams: The details of an update to a `MembershipRole`.
type UpdateMembershipRolesParams struct {
	// FieldMask: The fully-qualified names of fields to update. May only contain
	// the field `expiry_detail.expire_time`.
	FieldMask string `json:"fieldMask,omitempty"`
	// MembershipRole: The `MembershipRole`s to be updated. Only `MEMBER`
	// `MembershipRoles` can currently be updated. May only contain a
	// `MembershipRole` with `name` `MEMBER`.
	MembershipRole *MembershipRole `json:"membershipRole,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldMask") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldMask") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateMembershipRolesParams) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateMembershipRolesParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserInvitation: The `UserInvitation` resource represents an email that can
// be sent to an unmanaged user account inviting them to join the customer's
// Google Workspace or Cloud Identity account. An unmanaged account shares an
// email address domain with the Google Workspace or Cloud Identity account but
// is not managed by it yet. If the user accepts the `UserInvitation`, the user
// account will become managed.
type UserInvitation struct {
	// MailsSentCount: Number of invitation emails sent to the user.
	MailsSentCount int64 `json:"mailsSentCount,omitempty,string"`
	// Name: Shall be of the form
	// `customers/{customer}/userinvitations/{user_email_address}`.
	Name string `json:"name,omitempty"`
	// State: State of the `UserInvitation`.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "NOT_YET_SENT" - The `UserInvitation` has been created and is ready for
	// sending as an email.
	//   "INVITED" - The user has been invited by email.
	//   "ACCEPTED" - The user has accepted the invitation and is part of the
	// organization.
	//   "DECLINED" - The user declined the invitation.
	State string `json:"state,omitempty"`
	// UpdateTime: Time when the `UserInvitation` was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MailsSentCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MailsSentCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserInvitation) MarshalJSON() ([]byte, error) {
	type NoMethod UserInvitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WipeDeviceRequest: Request message for wiping all data on the device.
type WipeDeviceRequest struct {
	// Customer: Optional. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the customer. If
	// you're using this API for your own organization, use `customers/my_customer`
	// If you're using this API to manage another organization, use
	// `customers/{customer_id}`, where customer_id is the customer to whom the
	// device belongs.
	Customer string `json:"customer,omitempty"`
	// RemoveResetLock: Optional. Specifies if a user is able to factory reset a
	// device after a Device Wipe. On iOS, this is called "Activation Lock", while
	// on Android, this is known as "Factory Reset Protection". If true, this
	// protection will be removed from the device, so that a user can successfully
	// factory reset. If false, the setting is untouched on the device.
	RemoveResetLock bool `json:"removeResetLock,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WipeDeviceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod WipeDeviceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WipeDeviceResponse: Response message for wiping all data on the device.
type WipeDeviceResponse struct {
	// Device: Resultant Device object for the action. Note that asset tags will
	// not be returned in the device object.
	Device *Device `json:"device,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Device") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WipeDeviceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod WipeDeviceResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WipeDeviceUserRequest: Request message for starting an account wipe on
// device.
type WipeDeviceUserRequest struct {
	// Customer: Optional. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the customer. If
	// you're using this API for your own organization, use `customers/my_customer`
	// If you're using this API to manage another organization, use
	// `customers/{customer_id}`, where customer_id is the customer to whom the
	// device belongs.
	Customer string `json:"customer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WipeDeviceUserRequest) MarshalJSON() ([]byte, error) {
	type NoMethod WipeDeviceUserRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WipeDeviceUserResponse: Response message for wiping the user's account from
// the device.
type WipeDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *DeviceUser `json:"deviceUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WipeDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod WipeDeviceUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CustomersUserinvitationsCancelCall struct {
	s                           *Service
	name                        string
	canceluserinvitationrequest *CancelUserInvitationRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Cancel: Cancels a UserInvitation that was already sent.
//
//   - name: `UserInvitation` name in the format
//     `customers/{customer}/userinvitations/{user_email_address}`.
func (r *CustomersUserinvitationsService) Cancel(name string, canceluserinvitationrequest *CancelUserInvitationRequest) *CustomersUserinvitationsCancelCall {
	c := &CustomersUserinvitationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceluserinvitationrequest = canceluserinvitationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersUserinvitationsCancelCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersUserinvitationsCancelCall) Context(ctx context.Context) *CustomersUserinvitationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersUserinvitationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceluserinvitationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersUserinvitationsCancelCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersUserinvitationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a UserInvitation resource. **Note:** New consumer accounts
// with the customer's verified domain created within the previous 48 hours
// will not appear in the result. This delay also applies to newly-verified
// domains.
//
//   - name: `UserInvitation` name in the format
//     `customers/{customer}/userinvitations/{user_email_address}`.
func (r *CustomersUserinvitationsService) Get(name string) *CustomersUserinvitationsGetCall {
	c := &CustomersUserinvitationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersUserinvitationsGetCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersUserinvitationsGetCall) IfNoneMatch(entityTag string) *CustomersUserinvitationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersUserinvitationsGetCall) Context(ctx context.Context) *CustomersUserinvitationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersUserinvitationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserInvitation.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersUserinvitationsGetCall) Do(opts ...googleapi.CallOption) (*UserInvitation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserInvitation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersUserinvitationsIsInvitableUserCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// IsInvitableUser: Verifies whether a user account is eligible to receive a
// UserInvitation (is an unmanaged account). Eligibility is based on the
// following criteria: * the email address is a consumer account and it's the
// primary email address of the account, and * the domain of the email address
// matches an existing verified Google Workspace or Cloud Identity domain If
// both conditions are met, the user is eligible. **Note:** This method is not
// supported for Workspace Essentials customers.
//
//   - name: `UserInvitation` name in the format
//     `customers/{customer}/userinvitations/{user_email_address}`.
func (r *CustomersUserinvitationsService) IsInvitableUser(name string) *CustomersUserinvitationsIsInvitableUserCall {
	c := &CustomersUserinvitationsIsInvitableUserCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersUserinvitationsIsInvitableUserCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsIsInvitableUserCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersUserinvitationsIsInvitableUserCall) IfNoneMatch(entityTag string) *CustomersUserinvitationsIsInvitableUserCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersUserinvitationsIsInvitableUserCall) Context(ctx context.Context) *CustomersUserinvitationsIsInvitableUserCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersUserinvitationsIsInvitableUserCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsIsInvitableUserCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:isInvitableUser")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.isInvitableUser", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.isInvitableUser" call.
// Any non-2xx status code is an error. Response headers are in either
// *IsInvitableUserResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersUserinvitationsIsInvitableUserCall) Do(opts ...googleapi.CallOption) (*IsInvitableUserResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IsInvitableUserResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.isInvitableUser", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersUserinvitationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of UserInvitation resources. **Note:** New consumer
// accounts with the customer's verified domain created within the previous 48
// hours will not appear in the result. This delay also applies to
// newly-verified domains.
//
//   - parent: The customer ID of the Google Workspace or Cloud Identity account
//     the UserInvitation resources are associated with.
func (r *CustomersUserinvitationsService) List(parent string) *CustomersUserinvitationsListCall {
	c := &CustomersUserinvitationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A query string for filtering
// `UserInvitation` results by their current state, in the format:
// "state=='invited'".
func (c *CustomersUserinvitationsListCall) Filter(filter string) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The sort order of the list
// results. You can sort the results in descending order based on either email
// or last update timestamp but not both, using `order_by="email desc".
// Currently, sorting is supported for `update_time asc`, `update_time desc`,
// `email asc`, and `email desc`. If not specified, results will be returned
// based on `email asc` order.
func (c *CustomersUserinvitationsListCall) OrderBy(orderBy string) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// UserInvitation resources to return. If unspecified, at most 100 resources
// will be returned. The maximum value is 200; values above 200 will be set to
// 200.
func (c *CustomersUserinvitationsListCall) PageSize(pageSize int64) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListUserInvitations` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListBooks` must match the call that provided the page token.
func (c *CustomersUserinvitationsListCall) PageToken(pageToken string) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersUserinvitationsListCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersUserinvitationsListCall) IfNoneMatch(entityTag string) *CustomersUserinvitationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersUserinvitationsListCall) Context(ctx context.Context) *CustomersUserinvitationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersUserinvitationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/userinvitations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListUserInvitationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersUserinvitationsListCall) Do(opts ...googleapi.CallOption) (*ListUserInvitationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListUserInvitationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersUserinvitationsListCall) Pages(ctx context.Context, f func(*ListUserInvitationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersUserinvitationsSendCall struct {
	s                         *Service
	name                      string
	senduserinvitationrequest *SendUserInvitationRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Send: Sends a UserInvitation to email. If the `UserInvitation` does not
// exist for this request and it is a valid request, the request creates a
// `UserInvitation`. **Note:** The `get` and `list` methods have a 48-hour
// delay where newly-created consumer accounts will not appear in the results.
// You can still send a `UserInvitation` to those accounts if you know the
// unmanaged email address and IsInvitableUser==True.
//
//   - name: `UserInvitation` name in the format
//     `customers/{customer}/userinvitations/{user_email_address}`.
func (r *CustomersUserinvitationsService) Send(name string, senduserinvitationrequest *SendUserInvitationRequest) *CustomersUserinvitationsSendCall {
	c := &CustomersUserinvitationsSendCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.senduserinvitationrequest = senduserinvitationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersUserinvitationsSendCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsSendCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersUserinvitationsSendCall) Context(ctx context.Context) *CustomersUserinvitationsSendCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersUserinvitationsSendCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsSendCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.senduserinvitationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:send")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.send", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.send" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersUserinvitationsSendCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.customers.userinvitations.send", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesCancelWipeCall struct {
	s                       *Service
	name                    string
	cancelwipedevicerequest *CancelWipeDeviceRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// CancelWipe: Cancels an unfinished device wipe. This operation can be used to
// cancel device wipe in the gap between the wipe operation returning success
// and the device being wiped.
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format: `devices/{device_id}`, where device_id is the
//     unique ID assigned to the Device.
func (r *DevicesService) CancelWipe(name string, cancelwipedevicerequest *CancelWipeDeviceRequest) *DevicesCancelWipeCall {
	c := &DevicesCancelWipeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cancelwipedevicerequest = cancelwipedevicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesCancelWipeCall) Fields(s ...googleapi.Field) *DevicesCancelWipeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesCancelWipeCall) Context(ctx context.Context) *DevicesCancelWipeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesCancelWipeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesCancelWipeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cancelwipedevicerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancelWipe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.cancelWipe", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.cancelWipe" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesCancelWipeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.cancelWipe", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesCreateCall struct {
	s                   *Service
	createdevicerequest *CreateDeviceRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a device. Only company-owned device may be created.
// **Note**: This method is available only to customers who have one of the
// following SKUs: Enterprise Standard, Enterprise Plus, Enterprise for
// Education, and Cloud Identity Premium
func (r *DevicesService) Create(createdevicerequest *CreateDeviceRequest) *DevicesCreateCall {
	c := &DevicesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.createdevicerequest = createdevicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesCreateCall) Fields(s ...googleapi.Field) *DevicesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesCreateCall) Context(ctx context.Context) *DevicesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.createdevicerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/devices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified device.
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format: `devices/{device_id}`, where device_id is the
//     unique ID assigned to the Device.
func (r *DevicesService) Delete(name string) *DevicesDeleteCall {
	c := &DevicesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the customer. If
// you're using this API for your own organization, use `customers/my_customer`
// If you're using this API to manage another organization, use
// `customers/{customer_id}`, where customer_id is the customer to whom the
// device belongs.
func (c *DevicesDeleteCall) Customer(customer string) *DevicesDeleteCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeleteCall) Fields(s ...googleapi.Field) *DevicesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeleteCall) Context(ctx context.Context) *DevicesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the specified device.
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format: `devices/{device_id}`, where device_id is the
//     unique ID assigned to the Device.
func (r *DevicesService) Get(name string) *DevicesGetCall {
	c := &DevicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the Customer in
// format: `customers/{customer_id}`, where customer_id is the customer to whom
// the device belongs.
func (c *DevicesGetCall) Customer(customer string) *DevicesGetCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesGetCall) Fields(s ...googleapi.Field) *DevicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DevicesGetCall) IfNoneMatch(entityTag string) *DevicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesGetCall) Context(ctx context.Context) *DevicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Device.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesGetCall) Do(opts ...googleapi.CallOption) (*Device, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Device{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists/Searches devices.
func (r *DevicesService) List() *DevicesListCall {
	c := &DevicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the customer.
func (c *DevicesListCall) Customer(customer string) *DevicesListCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Filter sets the optional parameter "filter": Additional restrictions when
// fetching list of devices. For a list of search fields, refer to Mobile
// device search fields
// (https://developers.google.com/admin-sdk/directory/v1/search-operators).
// Multiple search fields are separated by the space character.
func (c *DevicesListCall) Filter(filter string) *DevicesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order specification for
// devices in the response. Only one of the following field names may be used
// to specify the order: `create_time`, `last_sync_time`, `model`,
// `os_version`, `device_type` and `serial_number`. `desc` may be specified
// optionally to specify results to be sorted in descending order. Default
// order is ascending.
func (c *DevicesListCall) OrderBy(orderBy string) *DevicesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// Devices to return. If unspecified, at most 20 Devices will be returned. The
// maximum value is 100; values above 100 will be coerced to 100.
func (c *DevicesListCall) PageSize(pageSize int64) *DevicesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDevices` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListDevices` must
// match the call that provided the page token.
func (c *DevicesListCall) PageToken(pageToken string) *DevicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The view to use for the List
// request.
//
// Possible values:
//
//	"VIEW_UNSPECIFIED" - Default value. The value is unused.
//	"COMPANY_INVENTORY" - This view contains all devices imported by the
//
// company admin. Each device in the response contains all information
// specified by the company admin when importing the device (i.e. asset tags).
//
//	"USER_ASSIGNED_DEVICES" - This view contains all devices with at least one
//
// user registered on the device. Each device in the response contains all
// device information, except for asset tags.
func (c *DevicesListCall) View(view string) *DevicesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesListCall) Fields(s ...googleapi.Field) *DevicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DevicesListCall) IfNoneMatch(entityTag string) *DevicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesListCall) Context(ctx context.Context) *DevicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/devices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDevicesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *DevicesListCall) Do(opts ...googleapi.CallOption) (*ListDevicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDevicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DevicesListCall) Pages(ctx context.Context, f func(*ListDevicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type DevicesWipeCall struct {
	s                 *Service
	name              string
	wipedevicerequest *WipeDeviceRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Wipe: Wipes all data on the specified device.
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format:
//     `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the
//     unique ID assigned to the Device, and device_user_id is the unique ID
//     assigned to the User.
func (r *DevicesService) Wipe(name string, wipedevicerequest *WipeDeviceRequest) *DevicesWipeCall {
	c := &DevicesWipeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.wipedevicerequest = wipedevicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesWipeCall) Fields(s ...googleapi.Field) *DevicesWipeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesWipeCall) Context(ctx context.Context) *DevicesWipeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesWipeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesWipeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.wipedevicerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:wipe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.wipe", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.wipe" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesWipeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.wipe", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesDeviceUsersApproveCall struct {
	s                        *Service
	name                     string
	approvedeviceuserrequest *ApproveDeviceUserRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Approve: Approves device to access user data.
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format:
//     `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the
//     unique ID assigned to the Device, and device_user_id is the unique ID
//     assigned to the User.
func (r *DevicesDeviceUsersService) Approve(name string, approvedeviceuserrequest *ApproveDeviceUserRequest) *DevicesDeviceUsersApproveCall {
	c := &DevicesDeviceUsersApproveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.approvedeviceuserrequest = approvedeviceuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersApproveCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersApproveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersApproveCall) Context(ctx context.Context) *DevicesDeviceUsersApproveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersApproveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersApproveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.approvedeviceuserrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:approve")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.approve", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.approve" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersApproveCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.approve", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesDeviceUsersBlockCall struct {
	s                      *Service
	name                   string
	blockdeviceuserrequest *BlockDeviceUserRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Block: Blocks device from accessing user data
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format:
//     `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the
//     unique ID assigned to the Device, and device_user_id is the unique ID
//     assigned to the User.
func (r *DevicesDeviceUsersService) Block(name string, blockdeviceuserrequest *BlockDeviceUserRequest) *DevicesDeviceUsersBlockCall {
	c := &DevicesDeviceUsersBlockCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.blockdeviceuserrequest = blockdeviceuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersBlockCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersBlockCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersBlockCall) Context(ctx context.Context) *DevicesDeviceUsersBlockCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersBlockCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersBlockCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.blockdeviceuserrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:block")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.block", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.block" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersBlockCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.block", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesDeviceUsersCancelWipeCall struct {
	s                           *Service
	name                        string
	cancelwipedeviceuserrequest *CancelWipeDeviceUserRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// CancelWipe: Cancels an unfinished user account wipe. This operation can be
// used to cancel device wipe in the gap between the wipe operation returning
// success and the device being wiped.
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format:
//     `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the
//     unique ID assigned to the Device, and device_user_id is the unique ID
//     assigned to the User.
func (r *DevicesDeviceUsersService) CancelWipe(name string, cancelwipedeviceuserrequest *CancelWipeDeviceUserRequest) *DevicesDeviceUsersCancelWipeCall {
	c := &DevicesDeviceUsersCancelWipeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cancelwipedeviceuserrequest = cancelwipedeviceuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersCancelWipeCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersCancelWipeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersCancelWipeCall) Context(ctx context.Context) *DevicesDeviceUsersCancelWipeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersCancelWipeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersCancelWipeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cancelwipedeviceuserrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancelWipe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.cancelWipe", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.cancelWipe" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersCancelWipeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.cancelWipe", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesDeviceUsersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified DeviceUser. This also revokes the user's
// access to device data.
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format:
//     `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the
//     unique ID assigned to the Device, and device_user_id is the unique ID
//     assigned to the User.
func (r *DevicesDeviceUsersService) Delete(name string) *DevicesDeviceUsersDeleteCall {
	c := &DevicesDeviceUsersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the customer. If
// you're using this API for your own organization, use `customers/my_customer`
// If you're using this API to manage another organization, use
// `customers/{customer_id}`, where customer_id is the customer to whom the
// device belongs.
func (c *DevicesDeviceUsersDeleteCall) Customer(customer string) *DevicesDeviceUsersDeleteCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersDeleteCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersDeleteCall) Context(ctx context.Context) *DevicesDeviceUsersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesDeviceUsersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the specified DeviceUser
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format:
//     `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the
//     unique ID assigned to the Device, and device_user_id is the unique ID
//     assigned to the User.
func (r *DevicesDeviceUsersService) Get(name string) *DevicesDeviceUsersGetCall {
	c := &DevicesDeviceUsersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the customer. If
// you're using this API for your own organization, use `customers/my_customer`
// If you're using this API to manage another organization, use
// `customers/{customer_id}`, where customer_id is the customer to whom the
// device belongs.
func (c *DevicesDeviceUsersGetCall) Customer(customer string) *DevicesDeviceUsersGetCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersGetCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DevicesDeviceUsersGetCall) IfNoneMatch(entityTag string) *DevicesDeviceUsersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersGetCall) Context(ctx context.Context) *DevicesDeviceUsersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DeviceUser.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersGetCall) Do(opts ...googleapi.CallOption) (*DeviceUser, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DeviceUser{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesDeviceUsersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists/Searches DeviceUsers.
//
//   - parent: To list all DeviceUsers, set this to "devices/-". To list all
//     DeviceUsers owned by a device, set this to the resource name of the
//     device. Format: devices/{device}.
func (r *DevicesDeviceUsersService) List(parent string) *DevicesDeviceUsersListCall {
	c := &DevicesDeviceUsersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the customer. If
// you're using this API for your own organization, use `customers/my_customer`
// If you're using this API to manage another organization, use
// `customers/{customer_id}`, where customer_id is the customer to whom the
// device belongs.
func (c *DevicesDeviceUsersListCall) Customer(customer string) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Filter sets the optional parameter "filter": Additional restrictions when
// fetching list of devices. For a list of search fields, refer to Mobile
// device search fields
// (https://developers.google.com/admin-sdk/directory/v1/search-operators).
// Multiple search fields are separated by the space character.
func (c *DevicesDeviceUsersListCall) Filter(filter string) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order specification for
// devices in the response.
func (c *DevicesDeviceUsersListCall) OrderBy(orderBy string) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// DeviceUsers to return. If unspecified, at most 5 DeviceUsers will be
// returned. The maximum value is 20; values above 20 will be coerced to 20.
func (c *DevicesDeviceUsersListCall) PageSize(pageSize int64) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDeviceUsers` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListBooks` must match the call that provided the page token.
func (c *DevicesDeviceUsersListCall) PageToken(pageToken string) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersListCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DevicesDeviceUsersListCall) IfNoneMatch(entityTag string) *DevicesDeviceUsersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersListCall) Context(ctx context.Context) *DevicesDeviceUsersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/deviceUsers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDeviceUsersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersListCall) Do(opts ...googleapi.CallOption) (*ListDeviceUsersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDeviceUsersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DevicesDeviceUsersListCall) Pages(ctx context.Context, f func(*ListDeviceUsersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type DevicesDeviceUsersLookupCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Lookup: Looks up resource names of the DeviceUsers associated with the
// caller's credentials, as well as the properties provided in the request.
// This method must be called with end-user credentials with the scope:
// https://www.googleapis.com/auth/cloud-identity.devices.lookup If multiple
// properties are provided, only DeviceUsers having all of these properties are
// considered as matches - i.e. the query behaves like an AND. Different
// platforms require different amounts of information from the caller to ensure
// that the DeviceUser is uniquely identified. - iOS: No properties need to be
// passed, the caller's credentials are sufficient to identify the
// corresponding DeviceUser. - Android: Specifying the 'android_id' field is
// required. - Desktop: Specifying the 'raw_resource_id' field is required.
//
//   - parent: Must be set to "devices/-/deviceUsers" to search across all
//     DeviceUser belonging to the user.
func (r *DevicesDeviceUsersService) Lookup(parent string) *DevicesDeviceUsersLookupCall {
	c := &DevicesDeviceUsersLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// AndroidId sets the optional parameter "androidId": Android Id returned by
// Settings.Secure#ANDROID_ID
// (https://developer.android.com/reference/android/provider/Settings.Secure.html#ANDROID_ID).
func (c *DevicesDeviceUsersLookupCall) AndroidId(androidId string) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("androidId", androidId)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// DeviceUsers to return. If unspecified, at most 20 DeviceUsers will be
// returned. The maximum value is 20; values above 20 will be coerced to 20.
func (c *DevicesDeviceUsersLookupCall) PageSize(pageSize int64) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `LookupDeviceUsers` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `LookupDeviceUsers` must match the call that provided the page token.
func (c *DevicesDeviceUsersLookupCall) PageToken(pageToken string) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// RawResourceId sets the optional parameter "rawResourceId": Raw Resource Id
// used by Google Endpoint Verification. If the user is enrolled into Google
// Endpoint Verification, this id will be saved as the 'device_resource_id'
// field in the following platform dependent files. Mac:
// ~/.secureConnect/context_aware_config.json Windows:
// C:\Users\%USERPROFILE%\.secureConnect\context_aware_config.json Linux:
// ~/.secureConnect/context_aware_config.json
func (c *DevicesDeviceUsersLookupCall) RawResourceId(rawResourceId string) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("rawResourceId", rawResourceId)
	return c
}

// UserId sets the optional parameter "userId": The user whose DeviceUser's
// resource name will be fetched. Must be set to 'me' to fetch the DeviceUser's
// resource name for the calling user.
func (c *DevicesDeviceUsersLookupCall) UserId(userId string) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("userId", userId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersLookupCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DevicesDeviceUsersLookupCall) IfNoneMatch(entityTag string) *DevicesDeviceUsersLookupCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersLookupCall) Context(ctx context.Context) *DevicesDeviceUsersLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.lookup", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.lookup" call.
// Any non-2xx status code is an error. Response headers are in either
// *LookupSelfDeviceUsersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersLookupCall) Do(opts ...googleapi.CallOption) (*LookupSelfDeviceUsersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LookupSelfDeviceUsersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.lookup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DevicesDeviceUsersLookupCall) Pages(ctx context.Context, f func(*LookupSelfDeviceUsersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type DevicesDeviceUsersWipeCall struct {
	s                     *Service
	name                  string
	wipedeviceuserrequest *WipeDeviceUserRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Wipe: Wipes the user's account on a device.
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the Device in format:
//     `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the
//     unique ID assigned to the Device, and device_user_id is the unique ID
//     assigned to the User.
func (r *DevicesDeviceUsersService) Wipe(name string, wipedeviceuserrequest *WipeDeviceUserRequest) *DevicesDeviceUsersWipeCall {
	c := &DevicesDeviceUsersWipeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.wipedeviceuserrequest = wipedeviceuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersWipeCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersWipeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersWipeCall) Context(ctx context.Context) *DevicesDeviceUsersWipeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersWipeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersWipeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.wipedeviceuserrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:wipe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.wipe", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.wipe" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersWipeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.wipe", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesDeviceUsersClientStatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the client state for the device user
//
//   - name: Resource name (https://cloud.google.com/apis/design/resource_names)
//     of the ClientState in format:
//     `devices/{device_id}/deviceUsers/{device_user_id}/clientStates/{partner_id}
//     `, where `device_id` is the unique ID assigned to the Device,
//     `device_user_id` is the unique ID assigned to the User and `partner_id`
//     identifies the partner storing the data. To get the client state for
//     devices belonging to your own organization, the `partnerId` is in the
//     format: `customerId-*anystring*`. Where the `customerId` is your
//     organization's customer ID and `anystring` is any suffix. This suffix is
//     used in setting up Custom Access Levels in Context-Aware Access. You may
//     use `my_customer` instead of the customer ID for devices managed by your
//     own organization. You may specify `-` in place of the `{device_id}`, so
//     the ClientState resource name can be:
//     `devices/-/deviceUsers/{device_user_resource_id}/clientStates/{partner_id}`
//     .
func (r *DevicesDeviceUsersClientStatesService) Get(name string) *DevicesDeviceUsersClientStatesGetCall {
	c := &DevicesDeviceUsersClientStatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the customer. If
// you're using this API for your own organization, use `customers/my_customer`
// If you're using this API to manage another organization, use
// `customers/{customer_id}`, where customer_id is the customer to whom the
// device belongs.
func (c *DevicesDeviceUsersClientStatesGetCall) Customer(customer string) *DevicesDeviceUsersClientStatesGetCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersClientStatesGetCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersClientStatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DevicesDeviceUsersClientStatesGetCall) IfNoneMatch(entityTag string) *DevicesDeviceUsersClientStatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersClientStatesGetCall) Context(ctx context.Context) *DevicesDeviceUsersClientStatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersClientStatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersClientStatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.clientStates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.clientStates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ClientState.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersClientStatesGetCall) Do(opts ...googleapi.CallOption) (*ClientState, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ClientState{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.clientStates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DevicesDeviceUsersClientStatesPatchCall struct {
	s           *Service
	name        string
	clientstate *ClientState
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates the client state for the device user **Note**: This method is
// available only to customers who have one of the following SKUs: Enterprise
// Standard, Enterprise Plus, Enterprise for Education, and Cloud Identity
// Premium
//
//   - name: Output only. Resource name
//     (https://cloud.google.com/apis/design/resource_names) of the ClientState
//     in format:
//     `devices/{device_id}/deviceUsers/{device_user_id}/clientState/{partner_id}`
//     , where partner_id corresponds to the partner storing the data.
func (r *DevicesDeviceUsersClientStatesService) Patch(name string, clientstate *ClientState) *DevicesDeviceUsersClientStatesPatchCall {
	c := &DevicesDeviceUsersClientStatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.clientstate = clientstate
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the customer. If
// you're using this API for your own organization, use `customers/my_customer`
// If you're using this API to manage another organization, use
// `customers/{customer_id}`, where customer_id is the customer to whom the
// device belongs.
func (c *DevicesDeviceUsersClientStatesPatchCall) Customer(customer string) *DevicesDeviceUsersClientStatesPatchCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Comma-separated list of
// fully qualified names of fields to be updated. If not specified, all
// updatable fields in ClientState are updated.
func (c *DevicesDeviceUsersClientStatesPatchCall) UpdateMask(updateMask string) *DevicesDeviceUsersClientStatesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DevicesDeviceUsersClientStatesPatchCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersClientStatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DevicesDeviceUsersClientStatesPatchCall) Context(ctx context.Context) *DevicesDeviceUsersClientStatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DevicesDeviceUsersClientStatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersClientStatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.clientstate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.clientStates.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.clientStates.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersClientStatesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.devices.deviceUsers.clientStates.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsCreateCall struct {
	s          *Service
	group      *Group
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a `Group`.
func (r *GroupsService) Create(group *Group) *GroupsCreateCall {
	c := &GroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.group = group
	return c
}

// InitialGroupConfig sets the optional parameter "initialGroupConfig":
// Required. The initial configuration option for the `Group`.
//
// Possible values:
//
//	"INITIAL_GROUP_CONFIG_UNSPECIFIED" - Default. Should not be used.
//	"WITH_INITIAL_OWNER" - The end user making the request will be added as
//
// the initial owner of the `Group`.
//
//	"EMPTY" - An empty group is created without any initial owners. This can
//
// only be used by admins of the domain.
func (c *GroupsCreateCall) InitialGroupConfig(initialGroupConfig string) *GroupsCreateCall {
	c.urlParams_.Set("initialGroupConfig", initialGroupConfig)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsCreateCall) Fields(s ...googleapi.Field) *GroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsCreateCall) Context(ctx context.Context) *GroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.group)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `Group`.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the `Group` to
//     retrieve. Must be of the form `groups/{group_id}`.
func (r *GroupsService) Delete(name string) *GroupsDeleteCall {
	c := &GroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsDeleteCall) Fields(s ...googleapi.Field) *GroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsDeleteCall) Context(ctx context.Context) *GroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `Group`.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the `Group` to
//     retrieve. Must be of the form `groups/{group_id}`.
func (r *GroupsService) Get(name string) *GroupsGetCall {
	c := &GroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsGetCall) Fields(s ...googleapi.Field) *GroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsGetCall) IfNoneMatch(entityTag string) *GroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsGetCall) Context(ctx context.Context) *GroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Group.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsGetCall) Do(opts ...googleapi.CallOption) (*Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsGetSecuritySettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSecuritySettings: Get Security Settings
//
//   - name: The security settings to retrieve. Format:
//     `groups/{group_id}/securitySettings`.
func (r *GroupsService) GetSecuritySettings(name string) *GroupsGetSecuritySettingsCall {
	c := &GroupsGetSecuritySettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ReadMask sets the optional parameter "readMask": Field-level read mask of
// which fields to return. "*" returns all fields. If not specified, all fields
// will be returned. May only contain the following field:
// `member_restriction`.
func (c *GroupsGetSecuritySettingsCall) ReadMask(readMask string) *GroupsGetSecuritySettingsCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsGetSecuritySettingsCall) Fields(s ...googleapi.Field) *GroupsGetSecuritySettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsGetSecuritySettingsCall) IfNoneMatch(entityTag string) *GroupsGetSecuritySettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsGetSecuritySettingsCall) Context(ctx context.Context) *GroupsGetSecuritySettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsGetSecuritySettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsGetSecuritySettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.getSecuritySettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.getSecuritySettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *SecuritySettings.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *GroupsGetSecuritySettingsCall) Do(opts ...googleapi.CallOption) (*SecuritySettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SecuritySettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.getSecuritySettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the `Group` resources under a customer or namespace.
func (r *GroupsService) List() *GroupsListCall {
	c := &GroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. Note that the number of results returned may be less than
// this value even if there are more available results. To fetch all results,
// clients must continue calling this method repeatedly until the response no
// longer contains a `next_page_token`. If unspecified, defaults to 200 for
// `View.BASIC` and to 50 for `View.FULL`. Must not be greater than 1000 for
// `View.BASIC` or 500 for `View.FULL`.
func (c *GroupsListCall) PageSize(pageSize int64) *GroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The `next_page_token`
// value returned from a previous list request, if any.
func (c *GroupsListCall) PageToken(pageToken string) *GroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. The parent resource
// under which to list all `Group` resources. Must be of the form
// `identitysources/{identity_source_id}` for external- identity-mapped groups
// or `customers/{customer_id}` for Google Groups. The `customer_id` must begin
// with "C" (for example, 'C046psxkn'). [Find your customer ID.]
// (https://support.google.com/cloudidentity/answer/10070793)
func (c *GroupsListCall) Parent(parent string) *GroupsListCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// View sets the optional parameter "view": The level of detail to be returned.
// If unspecified, defaults to `View.BASIC`.
//
// Possible values:
//
//	"VIEW_UNSPECIFIED" - Default. Should not be used.
//	"BASIC" - Only basic resource information is returned.
//	"FULL" - All resource information is returned.
func (c *GroupsListCall) View(view string) *GroupsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsListCall) Fields(s ...googleapi.Field) *GroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsListCall) IfNoneMatch(entityTag string) *GroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsListCall) Context(ctx context.Context) *GroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGroupsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *GroupsListCall) Do(opts ...googleapi.CallOption) (*ListGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsListCall) Pages(ctx context.Context, f func(*ListGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type GroupsLookupCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Lookup: Looks up the resource name
// (https://cloud.google.com/apis/design/resource_names) of a `Group` by its
// `EntityKey`.
func (r *GroupsService) Lookup() *GroupsLookupCall {
	c := &GroupsLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// GroupKeyId sets the optional parameter "groupKey.id": The ID of the entity.
// For Google-managed entities, the `id` must be the email address of an
// existing group or user. For external-identity-mapped entities, the `id` must
// be a string conforming to the Identity Source's requirements. Must be unique
// within a `namespace`.
func (c *GroupsLookupCall) GroupKeyId(groupKeyId string) *GroupsLookupCall {
	c.urlParams_.Set("groupKey.id", groupKeyId)
	return c
}

// GroupKeyNamespace sets the optional parameter "groupKey.namespace": The
// namespace in which the entity exists. If not specified, the `EntityKey`
// represents a Google-managed entity such as a Google user or a Google Group.
// If specified, the `EntityKey` represents an external-identity-mapped group.
// The namespace must correspond to an identity source created in Admin Console
// and must be in the form of `identitysources/{identity_source_id}`.
func (c *GroupsLookupCall) GroupKeyNamespace(groupKeyNamespace string) *GroupsLookupCall {
	c.urlParams_.Set("groupKey.namespace", groupKeyNamespace)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsLookupCall) Fields(s ...googleapi.Field) *GroupsLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsLookupCall) IfNoneMatch(entityTag string) *GroupsLookupCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsLookupCall) Context(ctx context.Context) *GroupsLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/groups:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.lookup", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.lookup" call.
// Any non-2xx status code is an error. Response headers are in either
// *LookupGroupNameResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsLookupCall) Do(opts ...googleapi.CallOption) (*LookupGroupNameResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LookupGroupNameResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.lookup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsPatchCall struct {
	s          *Service
	name       string
	group      *Group
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a `Group`.
//
//   - name: Output only. The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the `Group`.
//     Shall be of the form `groups/{group_id}`.
func (r *GroupsService) Patch(name string, group *Group) *GroupsPatchCall {
	c := &GroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.group = group
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The names of
// fields to update. May only contain the following field names:
// `display_name`, `description`, `labels`, `dynamic_group_metadata`,
// `posix_groups`.
func (c *GroupsPatchCall) UpdateMask(updateMask string) *GroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsPatchCall) Fields(s ...googleapi.Field) *GroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsPatchCall) Context(ctx context.Context) *GroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.group)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsSearchCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Searches for `Group` resources matching a specified query.
func (r *GroupsService) Search() *GroupsSearchCall {
	c := &GroupsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// OrderBy sets the optional parameter "orderBy": The ordering of groups for
// the display name or email in the search groups response. The syntax for this
// field can be found at
// https://cloud.google.com/apis/design/design_patterns#sorting_order. Example:
// Sort by the ascending name: order_by="display_name" Sort by the descending
// group key email: order_by="group_key desc"
func (c *GroupsSearchCall) OrderBy(orderBy string) *GroupsSearchCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. Note that the number of results returned may be less than
// this value even if there are more available results. To fetch all results,
// clients must continue calling this method repeatedly until the response no
// longer contains a `next_page_token`. If unspecified, defaults to 200 for
// `GroupView.BASIC` and to 50 for `GroupView.FULL`. Must not be greater than
// 1000 for `GroupView.BASIC` or 500 for `GroupView.FULL`.
func (c *GroupsSearchCall) PageSize(pageSize int64) *GroupsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The `next_page_token`
// value returned from a previous search request, if any.
func (c *GroupsSearchCall) PageToken(pageToken string) *GroupsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Required. The search query. *
// Must be specified in Common Expression Language
// (https://opensource.google/projects/cel). * Must contain equality operators
// on the parent, e.g. `parent == 'customers/{customer_id}'`. The `customer_id`
// must begin with "C" (for example, 'C046psxkn'). [Find your customer ID.]
// (https://support.google.com/cloudidentity/answer/10070793) * Can contain
// optional inclusion operators on `labels` such as
// `'cloudidentity.googleapis.com/groups.discussion_forum' in labels`). * Can
// contain an optional equality operator on `domain_name`. e.g. `domain_name ==
// 'examplepetstore.com'` * Can contain optional `startsWith/contains/equality`
// operators on `group_key`, e.g. `group_key.startsWith('dev')`,
// `group_key.contains('dev'), group_key == 'dev@examplepetstore.com'` * Can
// contain optional `startsWith/contains/equality` operators on `display_name`,
// such as `display_name.startsWith('dev')` , `display_name.contains('dev')`,
// `display_name == 'dev'`
func (c *GroupsSearchCall) Query(query string) *GroupsSearchCall {
	c.urlParams_.Set("query", query)
	return c
}

// View sets the optional parameter "view": The level of detail to be returned.
// If unspecified, defaults to `View.BASIC`.
//
// Possible values:
//
//	"BASIC" - Default. Only basic resource information is returned.
//	"FULL" - All resource information is returned.
func (c *GroupsSearchCall) View(view string) *GroupsSearchCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsSearchCall) Fields(s ...googleapi.Field) *GroupsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsSearchCall) IfNoneMatch(entityTag string) *GroupsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsSearchCall) Context(ctx context.Context) *GroupsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/groups:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchGroupsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *GroupsSearchCall) Do(opts ...googleapi.CallOption) (*SearchGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsSearchCall) Pages(ctx context.Context, f func(*SearchGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type GroupsUpdateSecuritySettingsCall struct {
	s                *Service
	name             string
	securitysettings *SecuritySettings
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// UpdateSecuritySettings: Update Security Settings
//
//   - name: Output only. The resource name of the security settings. Shall be of
//     the form `groups/{group_id}/securitySettings`.
func (r *GroupsService) UpdateSecuritySettings(name string, securitysettings *SecuritySettings) *GroupsUpdateSecuritySettingsCall {
	c := &GroupsUpdateSecuritySettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securitysettings = securitysettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// fully-qualified names of fields to update. May only contain the following
// field: `member_restriction.query`.
func (c *GroupsUpdateSecuritySettingsCall) UpdateMask(updateMask string) *GroupsUpdateSecuritySettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsUpdateSecuritySettingsCall) Fields(s ...googleapi.Field) *GroupsUpdateSecuritySettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsUpdateSecuritySettingsCall) Context(ctx context.Context) *GroupsUpdateSecuritySettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsUpdateSecuritySettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsUpdateSecuritySettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.securitysettings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.updateSecuritySettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.updateSecuritySettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsUpdateSecuritySettingsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.updateSecuritySettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsMembershipsCheckTransitiveMembershipCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CheckTransitiveMembership: Check a potential member for membership in a
// group. **Note:** This feature is only available to Google Workspace
// Enterprise Standard, Enterprise Plus, and Enterprise for Education; and
// Cloud Identity Premium accounts. A member has membership to a group as long
// as there is a single viewable transitive membership between the group and
// the member. The actor must have view permissions to at least one transitive
// membership between the member and group.
//
//   - parent: Resource name
//     (https://cloud.google.com/apis/design/resource_names) of the group to
//     check the transitive membership in. Format: `groups/{group_id}`, where
//     `group_id` is the unique id assigned to the Group to which the Membership
//     belongs to.
func (r *GroupsMembershipsService) CheckTransitiveMembership(parent string) *GroupsMembershipsCheckTransitiveMembershipCall {
	c := &GroupsMembershipsCheckTransitiveMembershipCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Query sets the optional parameter "query": Required. A CEL expression that
// MUST include member specification. This is a `required` field. Certain
// groups are uniquely identified by both a 'member_key_id' and a
// 'member_key_namespace', which requires an additional query input:
// 'member_key_namespace'. Example query: `member_key_id ==
// 'member_key_id_value'`
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Query(query string) *GroupsMembershipsCheckTransitiveMembershipCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Fields(s ...googleapi.Field) *GroupsMembershipsCheckTransitiveMembershipCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) IfNoneMatch(entityTag string) *GroupsMembershipsCheckTransitiveMembershipCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Context(ctx context.Context) *GroupsMembershipsCheckTransitiveMembershipCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsCheckTransitiveMembershipCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:checkTransitiveMembership")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.checkTransitiveMembership", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.checkTransitiveMembership" call.
// Any non-2xx status code is an error. Response headers are in either
// *CheckTransitiveMembershipResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Do(opts ...googleapi.CallOption) (*CheckTransitiveMembershipResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CheckTransitiveMembershipResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.checkTransitiveMembership", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsMembershipsCreateCall struct {
	s          *Service
	parent     string
	membership *Membership
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a `Membership`.
//
//   - parent: The parent `Group` resource under which to create the
//     `Membership`. Must be of the form `groups/{group_id}`.
func (r *GroupsMembershipsService) Create(parent string, membership *Membership) *GroupsMembershipsCreateCall {
	c := &GroupsMembershipsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.membership = membership
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsCreateCall) Fields(s ...googleapi.Field) *GroupsMembershipsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsCreateCall) Context(ctx context.Context) *GroupsMembershipsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.membership)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsMembershipsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsMembershipsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `Membership`.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the `Membership`
//     to delete. Must be of the form
//     `groups/{group_id}/memberships/{membership_id}`.
func (r *GroupsMembershipsService) Delete(name string) *GroupsMembershipsDeleteCall {
	c := &GroupsMembershipsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsDeleteCall) Fields(s ...googleapi.Field) *GroupsMembershipsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsDeleteCall) Context(ctx context.Context) *GroupsMembershipsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsMembershipsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsMembershipsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `Membership`.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the `Membership`
//     to retrieve. Must be of the form
//     `groups/{group_id}/memberships/{membership_id}`.
func (r *GroupsMembershipsService) Get(name string) *GroupsMembershipsGetCall {
	c := &GroupsMembershipsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsGetCall) Fields(s ...googleapi.Field) *GroupsMembershipsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsMembershipsGetCall) IfNoneMatch(entityTag string) *GroupsMembershipsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsGetCall) Context(ctx context.Context) *GroupsMembershipsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Membership.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsMembershipsGetCall) Do(opts ...googleapi.CallOption) (*Membership, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Membership{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsMembershipsGetMembershipGraphCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetMembershipGraph: Get a membership graph of just a member or both a member
// and a group. **Note:** This feature is only available to Google Workspace
// Enterprise Standard, Enterprise Plus, and Enterprise for Education; and
// Cloud Identity Premium accounts. Given a member, the response will contain
// all membership paths from the member. Given both a group and a member, the
// response will contain all membership paths between the group and the member.
//
//   - parent: Resource name
//     (https://cloud.google.com/apis/design/resource_names) of the group to
//     search transitive memberships in. Format: `groups/{group_id}`, where
//     `group_id` is the unique ID assigned to the Group to which the Membership
//     belongs to. group_id can be a wildcard collection id "-". When `group_id`
//     is specified, the membership graph will be constrained to paths between
//     the member (defined in the query) and the parent. If a wildcard collection
//     is provided, all membership paths connected to the member will be
//     returned.
func (r *GroupsMembershipsService) GetMembershipGraph(parent string) *GroupsMembershipsGetMembershipGraphCall {
	c := &GroupsMembershipsGetMembershipGraphCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Query sets the optional parameter "query": Required. A CEL expression that
// MUST include member specification AND label(s). Certain groups are uniquely
// identified by both a 'member_key_id' and a 'member_key_namespace', which
// requires an additional query input: 'member_key_namespace'. Example query:
// `member_key_id == 'member_key_id_value' && in labels`
func (c *GroupsMembershipsGetMembershipGraphCall) Query(query string) *GroupsMembershipsGetMembershipGraphCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsGetMembershipGraphCall) Fields(s ...googleapi.Field) *GroupsMembershipsGetMembershipGraphCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsMembershipsGetMembershipGraphCall) IfNoneMatch(entityTag string) *GroupsMembershipsGetMembershipGraphCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsGetMembershipGraphCall) Context(ctx context.Context) *GroupsMembershipsGetMembershipGraphCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsGetMembershipGraphCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsGetMembershipGraphCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:getMembershipGraph")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.getMembershipGraph", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.getMembershipGraph" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsMembershipsGetMembershipGraphCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.getMembershipGraph", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsMembershipsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the `Membership`s within a `Group`.
//
//   - parent: The parent `Group` resource under which to lookup the `Membership`
//     name. Must be of the form `groups/{group_id}`.
func (r *GroupsMembershipsService) List(parent string) *GroupsMembershipsListCall {
	c := &GroupsMembershipsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. Note that the number of results returned may be less than
// this value even if there are more available results. To fetch all results,
// clients must continue calling this method repeatedly until the response no
// longer contains a `next_page_token`. If unspecified, defaults to 200 for
// `GroupView.BASIC` and to 50 for `GroupView.FULL`. Must not be greater than
// 1000 for `GroupView.BASIC` or 500 for `GroupView.FULL`.
func (c *GroupsMembershipsListCall) PageSize(pageSize int64) *GroupsMembershipsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The `next_page_token`
// value returned from a previous search request, if any.
func (c *GroupsMembershipsListCall) PageToken(pageToken string) *GroupsMembershipsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The level of detail to be returned.
// If unspecified, defaults to `MembershipView.BASIC`.
//
// Possible values:
//
//	"BASIC" - Default. Only basic resource information is returned.
//	"FULL" - All resource information is returned.
func (c *GroupsMembershipsListCall) View(view string) *GroupsMembershipsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsListCall) Fields(s ...googleapi.Field) *GroupsMembershipsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsMembershipsListCall) IfNoneMatch(entityTag string) *GroupsMembershipsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsListCall) Context(ctx context.Context) *GroupsMembershipsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMembershipsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsListCall) Do(opts ...googleapi.CallOption) (*ListMembershipsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMembershipsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsMembershipsListCall) Pages(ctx context.Context, f func(*ListMembershipsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type GroupsMembershipsLookupCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Lookup: Looks up the resource name
// (https://cloud.google.com/apis/design/resource_names) of a `Membership` by
// its `EntityKey`.
//
//   - parent: The parent `Group` resource under which to lookup the `Membership`
//     name. Must be of the form `groups/{group_id}`.
func (r *GroupsMembershipsService) Lookup(parent string) *GroupsMembershipsLookupCall {
	c := &GroupsMembershipsLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// MemberKeyId sets the optional parameter "memberKey.id": The ID of the
// entity. For Google-managed entities, the `id` must be the email address of
// an existing group or user. For external-identity-mapped entities, the `id`
// must be a string conforming to the Identity Source's requirements. Must be
// unique within a `namespace`.
func (c *GroupsMembershipsLookupCall) MemberKeyId(memberKeyId string) *GroupsMembershipsLookupCall {
	c.urlParams_.Set("memberKey.id", memberKeyId)
	return c
}

// MemberKeyNamespace sets the optional parameter "memberKey.namespace": The
// namespace in which the entity exists. If not specified, the `EntityKey`
// represents a Google-managed entity such as a Google user or a Google Group.
// If specified, the `EntityKey` represents an external-identity-mapped group.
// The namespace must correspond to an identity source created in Admin Console
// and must be in the form of `identitysources/{identity_source_id}`.
func (c *GroupsMembershipsLookupCall) MemberKeyNamespace(memberKeyNamespace string) *GroupsMembershipsLookupCall {
	c.urlParams_.Set("memberKey.namespace", memberKeyNamespace)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsLookupCall) Fields(s ...googleapi.Field) *GroupsMembershipsLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsMembershipsLookupCall) IfNoneMatch(entityTag string) *GroupsMembershipsLookupCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsLookupCall) Context(ctx context.Context) *GroupsMembershipsLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.lookup", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.lookup" call.
// Any non-2xx status code is an error. Response headers are in either
// *LookupMembershipNameResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsLookupCall) Do(opts ...googleapi.CallOption) (*LookupMembershipNameResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LookupMembershipNameResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.lookup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsMembershipsModifyMembershipRolesCall struct {
	s                            *Service
	name                         string
	modifymembershiprolesrequest *ModifyMembershipRolesRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// ModifyMembershipRoles: Modifies the `MembershipRole`s of a `Membership`.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the `Membership`
//     whose roles are to be modified. Must be of the form
//     `groups/{group_id}/memberships/{membership_id}`.
func (r *GroupsMembershipsService) ModifyMembershipRoles(name string, modifymembershiprolesrequest *ModifyMembershipRolesRequest) *GroupsMembershipsModifyMembershipRolesCall {
	c := &GroupsMembershipsModifyMembershipRolesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.modifymembershiprolesrequest = modifymembershiprolesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsModifyMembershipRolesCall) Fields(s ...googleapi.Field) *GroupsMembershipsModifyMembershipRolesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsModifyMembershipRolesCall) Context(ctx context.Context) *GroupsMembershipsModifyMembershipRolesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsModifyMembershipRolesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsModifyMembershipRolesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.modifymembershiprolesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:modifyMembershipRoles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.modifyMembershipRoles", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.modifyMembershipRoles" call.
// Any non-2xx status code is an error. Response headers are in either
// *ModifyMembershipRolesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsModifyMembershipRolesCall) Do(opts ...googleapi.CallOption) (*ModifyMembershipRolesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ModifyMembershipRolesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.modifyMembershipRoles", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type GroupsMembershipsSearchDirectGroupsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchDirectGroups: Searches direct groups of a member.
//
//   - parent: Resource name
//     (https://cloud.google.com/apis/design/resource_names) of the group to
//     search transitive memberships in. Format: groups/{group_id}, where
//     group_id is always '-' as this API will search across all groups for a
//     given member.
func (r *GroupsMembershipsService) SearchDirectGroups(parent string) *GroupsMembershipsSearchDirectGroupsCall {
	c := &GroupsMembershipsSearchDirectGroupsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// OrderBy sets the optional parameter "orderBy": The ordering of membership
// relation for the display name or email in the response. The syntax for this
// field can be found at
// https://cloud.google.com/apis/design/design_patterns#sorting_order. Example:
// Sort by the ascending display name: order_by="group_name" or
// order_by="group_name asc". Sort by the descending display name:
// order_by="group_name desc". Sort by the ascending group key:
// order_by="group_key" or order_by="group_key asc". Sort by the descending
// group key: order_by="group_key desc".
func (c *GroupsMembershipsSearchDirectGroupsCall) OrderBy(orderBy string) *GroupsMembershipsSearchDirectGroupsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The default page size is
// 200 (max 1000).
func (c *GroupsMembershipsSearchDirectGroupsCall) PageSize(pageSize int64) *GroupsMembershipsSearchDirectGroupsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list request, if any.
func (c *GroupsMembershipsSearchDirectGroupsCall) PageToken(pageToken string) *GroupsMembershipsSearchDirectGroupsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Required. A CEL expression that
// MUST include member specification AND label(s). Users can search on label
// attributes of groups. CONTAINS match ('in') is supported on labels.
// Identity-mapped groups are uniquely identified by both a `member_key_id` and
// a `member_key_namespace`, which requires an additional query input:
// `member_key_namespace`. Example query: `member_key_id ==
// 'member_key_id_value' && 'label_value' in labels`
func (c *GroupsMembershipsSearchDirectGroupsCall) Query(query string) *GroupsMembershipsSearchDirectGroupsCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsSearchDirectGroupsCall) Fields(s ...googleapi.Field) *GroupsMembershipsSearchDirectGroupsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsMembershipsSearchDirectGroupsCall) IfNoneMatch(entityTag string) *GroupsMembershipsSearchDirectGroupsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsSearchDirectGroupsCall) Context(ctx context.Context) *GroupsMembershipsSearchDirectGroupsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsSearchDirectGroupsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsSearchDirectGroupsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:searchDirectGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.searchDirectGroups", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.searchDirectGroups" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchDirectGroupsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsSearchDirectGroupsCall) Do(opts ...googleapi.CallOption) (*SearchDirectGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchDirectGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.searchDirectGroups", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsMembershipsSearchDirectGroupsCall) Pages(ctx context.Context, f func(*SearchDirectGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type GroupsMembershipsSearchTransitiveGroupsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchTransitiveGroups: Search transitive groups of a member. **Note:** This
// feature is only available to Google Workspace Enterprise Standard,
// Enterprise Plus, and Enterprise for Education; and Cloud Identity Premium
// accounts. A transitive group is any group that has a direct or indirect
// membership to the member. Actor must have view permissions all transitive
// groups.
//
//   - parent: Resource name
//     (https://cloud.google.com/apis/design/resource_names) of the group to
//     search transitive memberships in. Format: `groups/{group_id}`, where
//     `group_id` is always '-' as this API will search across all groups for a
//     given member.
func (r *GroupsMembershipsService) SearchTransitiveGroups(parent string) *GroupsMembershipsSearchTransitiveGroupsCall {
	c := &GroupsMembershipsSearchTransitiveGroupsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The default page size is
// 200 (max 1000).
func (c *GroupsMembershipsSearchTransitiveGroupsCall) PageSize(pageSize int64) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The `next_page_token`
// value returned from a previous list request, if any.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) PageToken(pageToken string) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Required. A CEL expression that
// MUST include member specification AND label(s). This is a `required` field.
// Users can search on label attributes of groups. CONTAINS match ('in') is
// supported on labels. Identity-mapped groups are uniquely identified by both
// a `member_key_id` and a `member_key_namespace`, which requires an additional
// query input: `member_key_namespace`. Example query: `member_key_id ==
// 'member_key_id_value' && in labels` Query may optionally contain equality
// operators on the parent of the group restricting the search within a
// particular customer, e.g. `parent == 'customers/{customer_id}'`. The
// `customer_id` must begin with "C" (for example, 'C046psxkn'). This filtering
// is only supported for Admins with groups read permissions on the input
// customer. Example query: `member_key_id == 'member_key_id_value' && in
// labels && parent == 'customers/C046psxkn'`
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Query(query string) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Fields(s ...googleapi.Field) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) IfNoneMatch(entityTag string) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Context(ctx context.Context) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsSearchTransitiveGroupsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:searchTransitiveGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.searchTransitiveGroups", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.searchTransitiveGroups" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchTransitiveGroupsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Do(opts ...googleapi.CallOption) (*SearchTransitiveGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchTransitiveGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.searchTransitiveGroups", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Pages(ctx context.Context, f func(*SearchTransitiveGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type GroupsMembershipsSearchTransitiveMembershipsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchTransitiveMemberships: Search transitive memberships of a group.
// **Note:** This feature is only available to Google Workspace Enterprise
// Standard, Enterprise Plus, and Enterprise for Education; and Cloud Identity
// Premium accounts. A transitive membership is any direct or indirect
// membership of a group. Actor must have view permissions to all transitive
// memberships.
//
//   - parent: Resource name
//     (https://cloud.google.com/apis/design/resource_names) of the group to
//     search transitive memberships in. Format: `groups/{group_id}`, where
//     `group_id` is the unique ID assigned to the Group.
func (r *GroupsMembershipsService) SearchTransitiveMemberships(parent string) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c := &GroupsMembershipsSearchTransitiveMembershipsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The default page size is
// 200 (max 1000).
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) PageSize(pageSize int64) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous list request, if any.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) PageToken(pageToken string) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Fields(s ...googleapi.Field) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) IfNoneMatch(entityTag string) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Context(ctx context.Context) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsSearchTransitiveMembershipsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:searchTransitiveMemberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.searchTransitiveMemberships", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.searchTransitiveMemberships" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchTransitiveMembershipsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Do(opts ...googleapi.CallOption) (*SearchTransitiveMembershipsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchTransitiveMembershipsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.groups.memberships.searchTransitiveMemberships", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Pages(ctx context.Context, f func(*SearchTransitiveMembershipsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type InboundSamlSsoProfilesCreateCall struct {
	s                     *Service
	inboundsamlssoprofile *InboundSamlSsoProfile
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Create: Creates an InboundSamlSsoProfile for a customer. When the target
// customer has enabled Multi-party approval for sensitive actions
// (https://support.google.com/a/answer/13790448), the `Operation` in the
// response will have "done": false`, it will not have a response, and the
// metadata will have "state": "awaiting-multi-party-approval".
func (r *InboundSamlSsoProfilesService) Create(inboundsamlssoprofile *InboundSamlSsoProfile) *InboundSamlSsoProfilesCreateCall {
	c := &InboundSamlSsoProfilesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.inboundsamlssoprofile = inboundsamlssoprofile
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSamlSsoProfilesCreateCall) Fields(s ...googleapi.Field) *InboundSamlSsoProfilesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSamlSsoProfilesCreateCall) Context(ctx context.Context) *InboundSamlSsoProfilesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSamlSsoProfilesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSamlSsoProfilesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.inboundsamlssoprofile)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/inboundSamlSsoProfiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSamlSsoProfiles.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InboundSamlSsoProfilesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSamlSsoProfilesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an InboundSamlSsoProfile.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the
//     InboundSamlSsoProfile to delete. Format:
//     `inboundSamlSsoProfiles/{sso_profile_id}`.
func (r *InboundSamlSsoProfilesService) Delete(name string) *InboundSamlSsoProfilesDeleteCall {
	c := &InboundSamlSsoProfilesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSamlSsoProfilesDeleteCall) Fields(s ...googleapi.Field) *InboundSamlSsoProfilesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSamlSsoProfilesDeleteCall) Context(ctx context.Context) *InboundSamlSsoProfilesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSamlSsoProfilesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSamlSsoProfilesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSamlSsoProfiles.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InboundSamlSsoProfilesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSamlSsoProfilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an InboundSamlSsoProfile.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the
//     InboundSamlSsoProfile to get. Format:
//     `inboundSamlSsoProfiles/{sso_profile_id}`.
func (r *InboundSamlSsoProfilesService) Get(name string) *InboundSamlSsoProfilesGetCall {
	c := &InboundSamlSsoProfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSamlSsoProfilesGetCall) Fields(s ...googleapi.Field) *InboundSamlSsoProfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InboundSamlSsoProfilesGetCall) IfNoneMatch(entityTag string) *InboundSamlSsoProfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSamlSsoProfilesGetCall) Context(ctx context.Context) *InboundSamlSsoProfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSamlSsoProfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSamlSsoProfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSamlSsoProfiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InboundSamlSsoProfile.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *InboundSamlSsoProfilesGetCall) Do(opts ...googleapi.CallOption) (*InboundSamlSsoProfile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InboundSamlSsoProfile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSamlSsoProfilesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists InboundSamlSsoProfiles for a customer.
func (r *InboundSamlSsoProfilesService) List() *InboundSamlSsoProfilesListCall {
	c := &InboundSamlSsoProfilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": A Common Expression Language
// (https://github.com/google/cel-spec) expression to filter the results. The
// only supported filter is filtering by customer. For example:
// `customer=="customers/C0123abc". Omitting the filter or specifying a filter
// of `customer=="customers/my_customer" will return the profiles for the
// customer that the caller (authenticated user) belongs to.
func (c *InboundSamlSsoProfilesListCall) Filter(filter string) *InboundSamlSsoProfilesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// InboundSamlSsoProfiles to return. The service may return fewer than this
// value. If omitted (or defaulted to zero) the server will use a sensible
// default. This default may change over time. The maximum allowed value is
// 100. Requests with page_size greater than that will be silently interpreted
// as having this maximum value.
func (c *InboundSamlSsoProfilesListCall) PageSize(pageSize int64) *InboundSamlSsoProfilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListInboundSamlSsoProfiles` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided to
// `ListInboundSamlSsoProfiles` must match the call that provided the page
// token.
func (c *InboundSamlSsoProfilesListCall) PageToken(pageToken string) *InboundSamlSsoProfilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSamlSsoProfilesListCall) Fields(s ...googleapi.Field) *InboundSamlSsoProfilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InboundSamlSsoProfilesListCall) IfNoneMatch(entityTag string) *InboundSamlSsoProfilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSamlSsoProfilesListCall) Context(ctx context.Context) *InboundSamlSsoProfilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSamlSsoProfilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSamlSsoProfilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/inboundSamlSsoProfiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSamlSsoProfiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInboundSamlSsoProfilesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InboundSamlSsoProfilesListCall) Do(opts ...googleapi.CallOption) (*ListInboundSamlSsoProfilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInboundSamlSsoProfilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *InboundSamlSsoProfilesListCall) Pages(ctx context.Context, f func(*ListInboundSamlSsoProfilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type InboundSamlSsoProfilesPatchCall struct {
	s                     *Service
	name                  string
	inboundsamlssoprofile *InboundSamlSsoProfile
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Patch: Updates an InboundSamlSsoProfile. When the target customer has
// enabled Multi-party approval for sensitive actions
// (https://support.google.com/a/answer/13790448), the `Operation` in the
// response will have "done": false`, it will not have a response, and the
// metadata will have "state": "awaiting-multi-party-approval".
//
//   - name: Output only. Resource name
//     (https://cloud.google.com/apis/design/resource_names) of the SAML SSO
//     profile.
func (r *InboundSamlSsoProfilesService) Patch(name string, inboundsamlssoprofile *InboundSamlSsoProfile) *InboundSamlSsoProfilesPatchCall {
	c := &InboundSamlSsoProfilesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.inboundsamlssoprofile = inboundsamlssoprofile
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated.
func (c *InboundSamlSsoProfilesPatchCall) UpdateMask(updateMask string) *InboundSamlSsoProfilesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSamlSsoProfilesPatchCall) Fields(s ...googleapi.Field) *InboundSamlSsoProfilesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSamlSsoProfilesPatchCall) Context(ctx context.Context) *InboundSamlSsoProfilesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSamlSsoProfilesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSamlSsoProfilesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.inboundsamlssoprofile)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSamlSsoProfiles.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InboundSamlSsoProfilesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSamlSsoProfilesIdpCredentialsAddCall struct {
	s                       *Service
	parent                  string
	addidpcredentialrequest *AddIdpCredentialRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Add: Adds an IdpCredential. Up to 2 credentials are allowed. When the target
// customer has enabled Multi-party approval for sensitive actions
// (https://support.google.com/a/answer/13790448), the `Operation` in the
// response will have "done": false`, it will not have a response, and the
// metadata will have "state": "awaiting-multi-party-approval".
//
//   - parent: The InboundSamlSsoProfile that owns the IdpCredential. Format:
//     `inboundSamlSsoProfiles/{sso_profile_id}`.
func (r *InboundSamlSsoProfilesIdpCredentialsService) Add(parent string, addidpcredentialrequest *AddIdpCredentialRequest) *InboundSamlSsoProfilesIdpCredentialsAddCall {
	c := &InboundSamlSsoProfilesIdpCredentialsAddCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.addidpcredentialrequest = addidpcredentialrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSamlSsoProfilesIdpCredentialsAddCall) Fields(s ...googleapi.Field) *InboundSamlSsoProfilesIdpCredentialsAddCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSamlSsoProfilesIdpCredentialsAddCall) Context(ctx context.Context) *InboundSamlSsoProfilesIdpCredentialsAddCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSamlSsoProfilesIdpCredentialsAddCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSamlSsoProfilesIdpCredentialsAddCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addidpcredentialrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/idpCredentials:add")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.idpCredentials.add", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSamlSsoProfiles.idpCredentials.add" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InboundSamlSsoProfilesIdpCredentialsAddCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.idpCredentials.add", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSamlSsoProfilesIdpCredentialsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an IdpCredential.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the IdpCredential
//     to delete. Format:
//     `inboundSamlSsoProfiles/{sso_profile_id}/idpCredentials/{idp_credential_id}
//     `.
func (r *InboundSamlSsoProfilesIdpCredentialsService) Delete(name string) *InboundSamlSsoProfilesIdpCredentialsDeleteCall {
	c := &InboundSamlSsoProfilesIdpCredentialsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSamlSsoProfilesIdpCredentialsDeleteCall) Fields(s ...googleapi.Field) *InboundSamlSsoProfilesIdpCredentialsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSamlSsoProfilesIdpCredentialsDeleteCall) Context(ctx context.Context) *InboundSamlSsoProfilesIdpCredentialsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSamlSsoProfilesIdpCredentialsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSamlSsoProfilesIdpCredentialsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.idpCredentials.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSamlSsoProfiles.idpCredentials.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InboundSamlSsoProfilesIdpCredentialsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.idpCredentials.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSamlSsoProfilesIdpCredentialsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an IdpCredential.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the IdpCredential
//     to retrieve. Format:
//     `inboundSamlSsoProfiles/{sso_profile_id}/idpCredentials/{idp_credential_id}
//     `.
func (r *InboundSamlSsoProfilesIdpCredentialsService) Get(name string) *InboundSamlSsoProfilesIdpCredentialsGetCall {
	c := &InboundSamlSsoProfilesIdpCredentialsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSamlSsoProfilesIdpCredentialsGetCall) Fields(s ...googleapi.Field) *InboundSamlSsoProfilesIdpCredentialsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InboundSamlSsoProfilesIdpCredentialsGetCall) IfNoneMatch(entityTag string) *InboundSamlSsoProfilesIdpCredentialsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSamlSsoProfilesIdpCredentialsGetCall) Context(ctx context.Context) *InboundSamlSsoProfilesIdpCredentialsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSamlSsoProfilesIdpCredentialsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSamlSsoProfilesIdpCredentialsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.idpCredentials.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSamlSsoProfiles.idpCredentials.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *IdpCredential.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InboundSamlSsoProfilesIdpCredentialsGetCall) Do(opts ...googleapi.CallOption) (*IdpCredential, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IdpCredential{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.idpCredentials.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSamlSsoProfilesIdpCredentialsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of IdpCredentials in an InboundSamlSsoProfile.
//
//   - parent: The parent, which owns this collection of `IdpCredential`s.
//     Format: `inboundSamlSsoProfiles/{sso_profile_id}`.
func (r *InboundSamlSsoProfilesIdpCredentialsService) List(parent string) *InboundSamlSsoProfilesIdpCredentialsListCall {
	c := &InboundSamlSsoProfilesIdpCredentialsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `IdpCredential`s to return. The service may return fewer than this value.
func (c *InboundSamlSsoProfilesIdpCredentialsListCall) PageSize(pageSize int64) *InboundSamlSsoProfilesIdpCredentialsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListIdpCredentials` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListIdpCredentials` must match the call that provided the page token.
func (c *InboundSamlSsoProfilesIdpCredentialsListCall) PageToken(pageToken string) *InboundSamlSsoProfilesIdpCredentialsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSamlSsoProfilesIdpCredentialsListCall) Fields(s ...googleapi.Field) *InboundSamlSsoProfilesIdpCredentialsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InboundSamlSsoProfilesIdpCredentialsListCall) IfNoneMatch(entityTag string) *InboundSamlSsoProfilesIdpCredentialsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSamlSsoProfilesIdpCredentialsListCall) Context(ctx context.Context) *InboundSamlSsoProfilesIdpCredentialsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSamlSsoProfilesIdpCredentialsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSamlSsoProfilesIdpCredentialsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/idpCredentials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.idpCredentials.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSamlSsoProfiles.idpCredentials.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListIdpCredentialsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InboundSamlSsoProfilesIdpCredentialsListCall) Do(opts ...googleapi.CallOption) (*ListIdpCredentialsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListIdpCredentialsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSamlSsoProfiles.idpCredentials.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *InboundSamlSsoProfilesIdpCredentialsListCall) Pages(ctx context.Context, f func(*ListIdpCredentialsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type InboundSsoAssignmentsCreateCall struct {
	s                    *Service
	inboundssoassignment *InboundSsoAssignment
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Create: Creates an InboundSsoAssignment for users and devices in a
// `Customer` under a given `Group` or `OrgUnit`.
func (r *InboundSsoAssignmentsService) Create(inboundssoassignment *InboundSsoAssignment) *InboundSsoAssignmentsCreateCall {
	c := &InboundSsoAssignmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.inboundssoassignment = inboundssoassignment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSsoAssignmentsCreateCall) Fields(s ...googleapi.Field) *InboundSsoAssignmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSsoAssignmentsCreateCall) Context(ctx context.Context) *InboundSsoAssignmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSsoAssignmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSsoAssignmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.inboundssoassignment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/inboundSsoAssignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSsoAssignments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InboundSsoAssignmentsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSsoAssignmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an InboundSsoAssignment. To disable SSO, Create (or Update)
// an assignment that has `sso_mode` == `SSO_OFF`.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the
//     InboundSsoAssignment to delete. Format:
//     `inboundSsoAssignments/{assignment}`.
func (r *InboundSsoAssignmentsService) Delete(name string) *InboundSsoAssignmentsDeleteCall {
	c := &InboundSsoAssignmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSsoAssignmentsDeleteCall) Fields(s ...googleapi.Field) *InboundSsoAssignmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSsoAssignmentsDeleteCall) Context(ctx context.Context) *InboundSsoAssignmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSsoAssignmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSsoAssignmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSsoAssignments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InboundSsoAssignmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSsoAssignmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an InboundSsoAssignment.
//
//   - name: The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the
//     InboundSsoAssignment to fetch. Format:
//     `inboundSsoAssignments/{assignment}`.
func (r *InboundSsoAssignmentsService) Get(name string) *InboundSsoAssignmentsGetCall {
	c := &InboundSsoAssignmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSsoAssignmentsGetCall) Fields(s ...googleapi.Field) *InboundSsoAssignmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InboundSsoAssignmentsGetCall) IfNoneMatch(entityTag string) *InboundSsoAssignmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSsoAssignmentsGetCall) Context(ctx context.Context) *InboundSsoAssignmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSsoAssignmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSsoAssignmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSsoAssignments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InboundSsoAssignment.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *InboundSsoAssignmentsGetCall) Do(opts ...googleapi.CallOption) (*InboundSsoAssignment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InboundSsoAssignment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InboundSsoAssignmentsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the InboundSsoAssignments for a `Customer`.
func (r *InboundSsoAssignmentsService) List() *InboundSsoAssignmentsListCall {
	c := &InboundSsoAssignmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": A CEL expression to filter the
// results. The only supported filter is filtering by customer. For example:
// `customer==customers/C0123abc`. Omitting the filter or specifying a filter
// of `customer==customers/my_customer` will return the assignments for the
// customer that the caller (authenticated user) belongs to.
func (c *InboundSsoAssignmentsListCall) Filter(filter string) *InboundSsoAssignmentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// assignments to return. The service may return fewer than this value. If
// omitted (or defaulted to zero) the server will use a sensible default. This
// default may change over time. The maximum allowed value is 100, though
// requests with page_size greater than that will be silently interpreted as
// having this maximum value. This may increase in the futue.
func (c *InboundSsoAssignmentsListCall) PageSize(pageSize int64) *InboundSsoAssignmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListInboundSsoAssignments` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided to
// `ListInboundSsoAssignments` must match the call that provided the page
// token.
func (c *InboundSsoAssignmentsListCall) PageToken(pageToken string) *InboundSsoAssignmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSsoAssignmentsListCall) Fields(s ...googleapi.Field) *InboundSsoAssignmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InboundSsoAssignmentsListCall) IfNoneMatch(entityTag string) *InboundSsoAssignmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSsoAssignmentsListCall) Context(ctx context.Context) *InboundSsoAssignmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSsoAssignmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSsoAssignmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/inboundSsoAssignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSsoAssignments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInboundSsoAssignmentsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InboundSsoAssignmentsListCall) Do(opts ...googleapi.CallOption) (*ListInboundSsoAssignmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInboundSsoAssignmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *InboundSsoAssignmentsListCall) Pages(ctx context.Context, f func(*ListInboundSsoAssignmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type InboundSsoAssignmentsPatchCall struct {
	s                    *Service
	name                 string
	inboundssoassignment *InboundSsoAssignment
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Patch: Updates an InboundSsoAssignment. The body of this request is the
// `inbound_sso_assignment` field and the `update_mask` is relative to that.
// For example: a PATCH to
// `/v1beta1/inboundSsoAssignments/0abcdefg1234567&update_mask=rank` with a
// body of `{ "rank": 1 }` moves that (presumably group-targeted) SSO
// assignment to the highest priority and shifts any other group-targeted
// assignments down in priority.
//
//   - name: Output only. Resource name
//     (https://cloud.google.com/apis/design/resource_names) of the Inbound SSO
//     Assignment.
func (r *InboundSsoAssignmentsService) Patch(name string, inboundssoassignment *InboundSsoAssignment) *InboundSsoAssignmentsPatchCall {
	c := &InboundSsoAssignmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.inboundssoassignment = inboundssoassignment
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated.
func (c *InboundSsoAssignmentsPatchCall) UpdateMask(updateMask string) *InboundSsoAssignmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InboundSsoAssignmentsPatchCall) Fields(s ...googleapi.Field) *InboundSsoAssignmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InboundSsoAssignmentsPatchCall) Context(ctx context.Context) *InboundSsoAssignmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InboundSsoAssignmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InboundSsoAssignmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.inboundssoassignment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.inboundSsoAssignments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InboundSsoAssignmentsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.inboundSsoAssignments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrgUnitsMembershipsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List OrgMembership resources in an OrgUnit treated as 'parent'. Parent
// format: orgUnits/{$orgUnitId} where `$orgUnitId` is the `orgUnitId` from the
// Admin SDK `OrgUnit` resource
// (https://developers.google.com/admin-sdk/directory/reference/rest/v1/orgunits)
//
//   - parent: Immutable. OrgUnit which is queried for a list of memberships.
//     Format: orgUnits/{$orgUnitId} where `$orgUnitId` is the `orgUnitId` from
//     the Admin SDK `OrgUnit` resource
//     (https://developers.google.com/admin-sdk/directory/reference/rest/v1/orgunits).
func (r *OrgUnitsMembershipsService) List(parent string) *OrgUnitsMembershipsListCall {
	c := &OrgUnitsMembershipsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Customer sets the optional parameter "customer": Required. Immutable.
// Customer that this OrgMembership belongs to. All authorization will happen
// on the role assignments of this customer. Format: customers/{$customerId}
// where `$customerId` is the `id` from the Admin SDK `Customer` resource
// (https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers).
// You may also use `customers/my_customer` to specify your own organization.
func (c *OrgUnitsMembershipsListCall) Customer(customer string) *OrgUnitsMembershipsListCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Filter sets the optional parameter "filter": The search query. Must be
// specified in Common Expression Language
// (https://opensource.google/projects/cel). May only contain equality
// operators on the `type` (e.g., `type == 'shared_drive'`).
func (c *OrgUnitsMembershipsListCall) Filter(filter string) *OrgUnitsMembershipsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. The service may return fewer than this value. If omitted
// (or defaulted to zero) the server will default to 50. The maximum allowed
// value is 100, though requests with page_size greater than that will be
// silently interpreted as 100.
func (c *OrgUnitsMembershipsListCall) PageSize(pageSize int64) *OrgUnitsMembershipsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `OrgMembershipsService.ListOrgMemberships` call. Provide
// this to retrieve the subsequent page. When paginating, all other parameters
// provided to `ListOrgMembershipsRequest` must match the call that provided
// the page token.
func (c *OrgUnitsMembershipsListCall) PageToken(pageToken string) *OrgUnitsMembershipsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrgUnitsMembershipsListCall) Fields(s ...googleapi.Field) *OrgUnitsMembershipsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrgUnitsMembershipsListCall) IfNoneMatch(entityTag string) *OrgUnitsMembershipsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrgUnitsMembershipsListCall) Context(ctx context.Context) *OrgUnitsMembershipsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrgUnitsMembershipsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrgUnitsMembershipsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.orgUnits.memberships.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.orgUnits.memberships.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOrgMembershipsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrgUnitsMembershipsListCall) Do(opts ...googleapi.CallOption) (*ListOrgMembershipsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOrgMembershipsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.orgUnits.memberships.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrgUnitsMembershipsListCall) Pages(ctx context.Context, f func(*ListOrgMembershipsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrgUnitsMembershipsMoveCall struct {
	s                        *Service
	name                     string
	moveorgmembershiprequest *MoveOrgMembershipRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Move: Move an OrgMembership to a new OrgUnit. NOTE: This is an atomic
// copy-and-delete. The resource will have a new copy under the destination
// OrgUnit and be deleted from the source OrgUnit. The resource can only be
// searched under the destination OrgUnit afterwards.
//
//   - name: Immutable. The resource name
//     (https://cloud.google.com/apis/design/resource_names) of the
//     OrgMembership. Format: orgUnits/{$orgUnitId}/memberships/{$membership} The
//     `$orgUnitId` is the `orgUnitId` from the Admin SDK `OrgUnit` resource
//     (https://developers.google.com/admin-sdk/directory/reference/rest/v1/orgunits).
//     To manage a Membership without specifying source `orgUnitId`, this API
//     also supports the wildcard character '-' for `$orgUnitId` per
//     https://google.aip.dev/159. The `$membership` shall be of the form
//     `{$entityType};{$memberId}`, where `$entityType` is the enum value of
//     OrgMembership.EntityType, and `memberId` is the `id` from Drive API (V3)
//     `Drive` resource
//     (https://developers.google.com/drive/api/v3/reference/drives#resource) for
//     OrgMembership.EntityType.SHARED_DRIVE.
func (r *OrgUnitsMembershipsService) Move(name string, moveorgmembershiprequest *MoveOrgMembershipRequest) *OrgUnitsMembershipsMoveCall {
	c := &OrgUnitsMembershipsMoveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.moveorgmembershiprequest = moveorgmembershiprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrgUnitsMembershipsMoveCall) Fields(s ...googleapi.Field) *OrgUnitsMembershipsMoveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrgUnitsMembershipsMoveCall) Context(ctx context.Context) *OrgUnitsMembershipsMoveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrgUnitsMembershipsMoveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrgUnitsMembershipsMoveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.moveorgmembershiprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:move")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.orgUnits.memberships.move", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.orgUnits.memberships.move" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrgUnitsMembershipsMoveCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.orgUnits.memberships.move", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a Policy
//
// - name: The name of the policy to retrieve. Format: "policies/{policy}".
func (r *PoliciesService) Get(name string) *PoliciesGetCall {
	c := &PoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PoliciesGetCall) Fields(s ...googleapi.Field) *PoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PoliciesGetCall) IfNoneMatch(entityTag string) *PoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PoliciesGetCall) Context(ctx context.Context) *PoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.policies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.policies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *PoliciesGetCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.policies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PoliciesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List Policies
func (r *PoliciesService) List() *PoliciesListCall {
	c := &PoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": A CEL expression for filtering
// the results. Policies can be filtered by application with this expression:
// setting.type.matches('^settings/gmail\\..*$') Policies can be filtered by
// setting type with this expression:
// setting.type.matches('^.*\\.service_status$') A maximum of one of the above
// setting.type clauses can be used. Policies can be filtered by customer with
// this expression: customer == "customers/{customer}" Where `customer` is the
// `id` from the Admin SDK `Customer` resource
// (https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers).
// You may use `customers/my_customer` to specify your own organization. When
// no customer is mentioned it will be default to customers/my_customer. A
// maximum of one customer clause can be used. The above clauses can only be
// combined together in a single filter expression with the `&&` operator.
func (c *PoliciesListCall) Filter(filter string) *PoliciesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. The service can return fewer than this number. If omitted
// or set to 0, the default is 50 results per page. The maximum allowed value
// is 100. `page_size` values greater than 100 default to 100.
func (c *PoliciesListCall) PageSize(pageSize int64) *PoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The pagination token
// received from a prior call to PoliciesService.ListPolicies to retrieve the
// next page of results. When paginating, all other parameters provided to
// `ListPoliciesRequest` must match the call that provided the page token.
func (c *PoliciesListCall) PageToken(pageToken string) *PoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PoliciesListCall) Fields(s ...googleapi.Field) *PoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PoliciesListCall) IfNoneMatch(entityTag string) *PoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PoliciesListCall) Context(ctx context.Context) *PoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudidentity.policies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.policies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPoliciesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PoliciesListCall) Do(opts ...googleapi.CallOption) (*ListPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudidentity.policies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PoliciesListCall) Pages(ctx context.Context, f func(*ListPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
