// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package sts provides access to the Security Token Service API.
//
// For product documentation, see: http://cloud.google.com/iam/docs/workload-identity-federation
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/sts/v1"
//	...
//	ctx := context.Background()
//	stsService, err := sts.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	stsService, err := sts.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	stsService, err := sts.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package sts // import "google.golang.org/api/sts/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "sts:v1"
const apiName = "sts"
const apiVersion = "v1"
const basePath = "https://sts.googleapis.com/"
const mtlsBasePath = "https://sts.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.V1 = NewV1Service(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	V1 *V1Service
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewV1Service(s *Service) *V1Service {
	rs := &V1Service{s: s}
	return rs
}

type V1Service struct {
	s *Service
}

// GoogleIamV1Binding: Associates `members`, or principals, with a
// `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the
	// current request. If the condition evaluates to `false`, then this
	// binding does not apply to the current request. However, a different
	// role binding might grant the same role to one or more of the
	// principals in this binding. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`

	// Members: Specifies the principals requesting access for a Google
	// Cloud resource. `members` can have the following values: *
	// `allUsers`: A special identifier that represents anyone who is on the
	// internet; with or without a Google account. *
	// `allAuthenticatedUsers`: A special identifier that represents anyone
	// who is authenticated with a Google account or a service account. Does
	// not include identities that come from external identity providers
	// (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address
	// that represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
	//  An identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`.
	// * `group:{emailid}`: An email address that represents a Google group.
	// For example, `admins@example.com`. * `domain:{domain}`: The G Suite
	// domain (primary) that represents all the users of that domain. For
	// example, `google.com` or `example.com`. *
	// `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently
	// deleted. For example, `alice@example.com?uid=123456789012345678901`.
	// If the user is recovered, this value reverts to `user:{emailid}` and
	// the recovered user retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`:
	// An email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is
	// recovered, this value reverts to `group:{emailid}` and the recovered
	// group retains the role in the binding.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to the list of `members`, or principals.
	// For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1AccessBoundary: An access boundary defines the
// upper bound of what a principal may access. It includes a list of
// access boundary rules that each defines the resource that may be
// allowed as well as permissions that may be used on those resources.
type GoogleIdentityStsV1AccessBoundary struct {
	// AccessBoundaryRules: A list of access boundary rules which defines
	// the upper bound of the permission a principal may carry. If multiple
	// rules are specified, the effective access boundary is the union of
	// all the access boundary rules attached. One access boundary can
	// contain at most 10 rules.
	AccessBoundaryRules []*GoogleIdentityStsV1AccessBoundaryRule `json:"accessBoundaryRules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBoundaryRules")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBoundaryRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1AccessBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1AccessBoundary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1AccessBoundaryRule: An access boundary rule
// defines an upper bound of IAM permissions on a single resource.
type GoogleIdentityStsV1AccessBoundaryRule struct {
	// AvailabilityCondition: The availability condition further constrains
	// the access allowed by the access boundary rule. If the condition
	// evaluates to `true`, then this access boundary rule will provide
	// access to the specified resource, assuming the principal has the
	// required permissions for the resource. If the condition does not
	// evaluate to `true`, then access to the specified resource will not be
	// available. Note that all access boundary rules in an access boundary
	// are evaluated together as a union. As such, another access boundary
	// rule may allow access to the resource, even if this access boundary
	// rule does not allow access. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies). The
	// maximum length of the `expression` field is 2048 characters.
	AvailabilityCondition *GoogleTypeExpr `json:"availabilityCondition,omitempty"`

	// AvailablePermissions: A list of permissions that may be allowed for
	// use on the specified resource. The only supported values in the list
	// are IAM roles, following the format of google.iam.v1.Binding.role.
	// Example value: `inRole:roles/logging.viewer` for predefined roles and
	// `inRole:organizations/{ORGANIZATION_ID}/roles/logging.viewer` for
	// custom roles.
	AvailablePermissions []string `json:"availablePermissions,omitempty"`

	// AvailableResource: The full resource name of a Google Cloud resource
	// entity. The format definition is at
	// https://cloud.google.com/apis/design/resource_names. Example value:
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	AvailableResource string `json:"availableResource,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AvailabilityCondition") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvailabilityCondition") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1AccessBoundaryRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1AccessBoundaryRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1ExchangeOauthTokenRequest: Request message for
// ExchangeOauthToken
type GoogleIdentityStsV1ExchangeOauthTokenRequest struct {
	// ClientId: Optional. The client identifier for the OAuth 2.0 client
	// that requested the provided token. It is REQUIRED when the [client]
	// (https://www.rfc-editor.org/rfc/rfc6749#section-1.1) is not
	// authenticating with the authorization server, i.e. when
	// authentication method is [client authentication]
	// (https://www.rfc-editor.org/rfc/rfc6749#section-3.2.1).
	ClientId string `json:"clientId,omitempty"`

	// Code: Optional. The authorization code that was previously from
	// workforce identity federation's `authorize` endpoint. Required if the
	// flow is authorization code flow, i.e. if grant_type is
	// 'authorization_code'
	Code string `json:"code,omitempty"`

	// CodeVerifier: Optional. The code verifier for the PKCE request,
	// Google Cloud CLI originally generates it before the authorization
	// request. PKCE is used to protect authorization code from interception
	// attacks. See https://www.rfc-editor.org/rfc/rfc7636#section-1.1 and
	// https://www.rfc-editor.org/rfc/rfc7636#section-3. It is required when
	// the flow is authorization code flow, i.e. if grant_type is
	// 'authorization_code'
	CodeVerifier string `json:"codeVerifier,omitempty"`

	// GrantType: Required. The grant types are as follows: -
	// 'authorization_code' : an authorization code flow, i.e. exchange of
	// authorization code for the Oauth access token - 'refresh_token' : a
	// refresh token flow, i.e. obtain a new access token by providing the
	// refresh token. See https://www.rfc-editor.org/rfc/rfc6749#section-6
	GrantType string `json:"grantType,omitempty"`

	// RedirectUri: Optional. redirect_url is required when the flow is
	// authorization code flow i.e. if grant_type is `authorization_code`
	// See https://www.rfc-editor.org/rfc/rfc6749#section-4.1.3
	RedirectUri string `json:"redirectUri,omitempty"`

	// RefreshToken: Optional. The Refresh token is the credential that is
	// used to obtain a new access token when the current access token
	// becomes invalid or expires. Required when using refresh token flow,
	// i.e. if `grant_type` is 'refresh_token' See
	// https://www.rfc-editor.org/rfc/rfc6749#section-1.5 and
	// https://www.rfc-editor.org/rfc/rfc6749#section-6
	RefreshToken string `json:"refreshToken,omitempty"`

	// Scope: Optional. An optional list of scopes that are requested for
	// the token to be returned. See
	// https://www.rfc-editor.org/rfc/rfc6749#section-3.3 Must be a list of
	// space-delimited, case-sensitive strings. Note: Currently, the scopes
	// in the request are not supported
	Scope string `json:"scope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1ExchangeOauthTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1ExchangeOauthTokenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1ExchangeOauthTokenResponse: Response message for
// ExchangeOauthToken. see
// https://www.rfc-editor.org/rfc/rfc6749#section-5.1
type GoogleIdentityStsV1ExchangeOauthTokenResponse struct {
	// AccessToken: An OAuth 2.0 security token, issued by Google, in
	// response to the Oauth token exchange request for the authorization
	// code and refresh token flows. The returned access token
	// (https://www.rfc-editor.org/rfc/rfc6749#section-4.1.4). Tokens can
	// vary in size, depending, in part, on the size of mapped claims, up to
	// a maximum of 12288 bytes (12 KB). Google reserves the right to change
	// the token size and the maximum length at any time.
	AccessToken string `json:"access_token,omitempty"`

	// ExpiresIn: The amount of time, in seconds, between the time when the
	// access token was issued and the time when the access token will
	// expires.
	ExpiresIn int64 `json:"expires_in,omitempty"`

	// IdToken: Google issued ID token in response to the OAuth token
	// exchange request for ID token flow.
	IdToken string `json:"id_token,omitempty"`

	// RefreshToken: A refresh token, issued by Google, in response to the
	// OAuth token exchange request for refresh token flow
	RefreshToken string `json:"refresh_token,omitempty"`

	// Scope: A list of scopes associated with the returned token.
	Scope string `json:"scope,omitempty"`

	// TokenType: The type of token. Field reserved for RFC compliance. See
	// https://www.rfc-editor.org/rfc/rfc6749#section-5.1
	TokenType string `json:"token_type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1ExchangeOauthTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1ExchangeOauthTokenResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1ExchangeTokenRequest: Request message for
// ExchangeToken.
type GoogleIdentityStsV1ExchangeTokenRequest struct {
	// Audience: The full resource name of the identity provider; for
	// example:
	// `//iam.googleapis.com/projects//locations/global/workloadIdentityPools
	// //providers/` for workload identity pool providers, or
	// `//iam.googleapis.com/locations/global/workforcePools//providers/`
	// for workforce pool providers. Required when exchanging an external
	// credential for a Google access token.
	Audience string `json:"audience,omitempty"`

	// GrantType: Required. The grant type. Must be
	// `urn:ietf:params:oauth:grant-type:token-exchange`, which indicates a
	// token exchange.
	GrantType string `json:"grantType,omitempty"`

	// Options: A set of features that Security Token Service supports, in
	// addition to the standard OAuth 2.0 token exchange, formatted as a
	// serialized JSON object of Options. The size of the parameter value
	// must not exceed 4096 characters.
	Options string `json:"options,omitempty"`

	// RequestedTokenType: Required. An identifier for the type of requested
	// security token. Must be
	// `urn:ietf:params:oauth:token-type:access_token`.
	RequestedTokenType string `json:"requestedTokenType,omitempty"`

	// Scope: The OAuth 2.0 scopes to include on the resulting access token,
	// formatted as a list of space-delimited, case-sensitive strings.
	// Required when exchanging an external credential for a Google access
	// token.
	Scope string `json:"scope,omitempty"`

	// SubjectToken: Required. The input token. This token is either an
	// external credential issued by a workload identity pool provider, or a
	// short-lived access token issued by Google. If the token is an OIDC
	// JWT, it must use the JWT format defined in RFC 7523
	// (https://tools.ietf.org/html/rfc7523), and the `subject_token_type`
	// must be either `urn:ietf:params:oauth:token-type:jwt` or
	// `urn:ietf:params:oauth:token-type:id_token`. The following headers
	// are required: - `kid`: The identifier of the signing key securing the
	// JWT. - `alg`: The cryptographic algorithm securing the JWT. Must be
	// `RS256` or `ES256`. The following payload fields are required. For
	// more information, see RFC 7523, Section 3
	// (https://tools.ietf.org/html/rfc7523#section-3): - `iss`: The issuer
	// of the token. The issuer must provide a discovery document at the URL
	// `/.well-known/openid-configuration`, where `` is the value of this
	// field. The document must be formatted according to section 4.2 of the
	// OIDC 1.0 Discovery specification
	// (https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderConfigurationResponse).
	// - `iat`: The issue time, in seconds, since the Unix epoch. Must be in
	// the past. - `exp`: The expiration time, in seconds, since the Unix
	// epoch. Must be less than 48 hours after `iat`. Shorter expiration
	// times are more secure. If possible, we recommend setting an
	// expiration time less than 6 hours. - `sub`: The identity asserted in
	// the JWT. - `aud`: For workload identity pools, this must be a value
	// specified in the allowed audiences for the workload identity pool
	// provider, or one of the audiences allowed by default if no audiences
	// were specified. See
	// https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.workloadIdentityPools.providers#oidc.
	// For workforce pools, this must match the client ID specified in the
	// provider configuration. See
	// https://cloud.google.com/iam/docs/reference/rest/v1/locations.workforcePools.providers#oidc.
	// Example header: ``` { "alg": "RS256", "kid": "us-east-11" } ```
	// Example payload: ``` { "iss": "https://accounts.google.com", "iat":
	// 1517963104, "exp": 1517966704, "aud":
	// "//iam.googleapis.com/projects/1234567890123/locations/global/workload
	// IdentityPools/my-pool/providers/my-provider", "sub":
	// "113475438248934895348", "my_claims": { "additional_claim": "value" }
	// } ``` If `subject_token` is for AWS, it must be a serialized
	// `GetCallerIdentity` token. This token contains the same information
	// as a request to the AWS `GetCallerIdentity()`
	// (https://docs.aws.amazon.com/STS/latest/APIReference/API_GetCallerIdentity)
	// method, as well as the AWS signature
	// (https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
	// for the request information. Use Signature Version 4. Format the
	// request as URL-encoded JSON, and set the `subject_token_type`
	// parameter to `urn:ietf:params:aws:token-type:aws4_request`. The
	// following parameters are required: - `url`: The URL of the AWS STS
	// endpoint for `GetCallerIdentity()`, such as
	// `https://sts.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15
	// `. Regional endpoints are also supported. - `method`: The HTTP
	// request method: `POST`. - `headers`: The HTTP request headers, which
	// must include: - `Authorization`: The request signature. -
	// `x-amz-date`: The time you will send the request, formatted as an
	// ISO8601 Basic
	// (https://docs.aws.amazon.com/general/latest/gr/sigv4_elements.html#sigv4_elements_date)
	// string. This value is typically set to the current time and is used
	// to help prevent replay attacks. - `host`: The hostname of the `url`
	// field; for example, `sts.amazonaws.com`. -
	// `x-goog-cloud-target-resource`: The full, canonical resource name of
	// the workload identity pool provider, with or without an `https:`
	// prefix. To help ensure data integrity, we recommend including this
	// header in the `SignedHeaders` field of the signed request. For
	// example:
	// //iam.googleapis.com/projects//locations/global/workloadIdentityPools/
	// /providers/
	// https://iam.googleapis.com/projects//locations/global/workloadIdentityPools//providers/
	// If you are using temporary security credentials provided by AWS, you
	// must also include the header `x-amz-security-token`, with the value
	// set to the session token. The following example shows a
	// `GetCallerIdentity` token: ``` { "headers": [ {"key": "x-amz-date",
	// "value": "20200815T015049Z"}, {"key": "Authorization", "value":
	// "AWS4-HMAC-SHA256+Credential=$credential,+SignedHeaders=host;x-amz-dat
	// e;x-goog-cloud-target-resource,+Signature=$signature"}, {"key":
	// "x-goog-cloud-target-resource", "value":
	// "//iam.googleapis.com/projects//locations/global/workloadIdentityPools
	// //providers/"}, {"key": "host", "value": "sts.amazonaws.com"} . ],
	// "method": "POST", "url":
	// "https://sts.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15
	// " } ``` If the token is a SAML 2.0 assertion, it must use the format
	// defined in the SAML 2.0 spec
	// (https://www.oasis-open.org/committees/download.php/56776/sstc-saml-core-errata-2.0-wd-07.pdf),
	// and the `subject_token_type` must be
	// `urn:ietf:params:oauth:token-type:saml2`. See Verification of
	// external credentials
	// (https://cloud.google.com/iam/docs/using-workload-identity-federation#verification_of_external_credentials)
	// for details on how SAML 2.0 assertions are validated during token
	// exchanges. You can also use a Google-issued OAuth 2.0 access token
	// with this field to obtain an access token with new security
	// attributes applied, such as a Credential Access Boundary. In this
	// case, set `subject_token_type` to
	// `urn:ietf:params:oauth:token-type:access_token`. If an access token
	// already contains security attributes, you cannot apply additional
	// security attributes.
	SubjectToken string `json:"subjectToken,omitempty"`

	// SubjectTokenType: Required. An identifier that indicates the type of
	// the security token in the `subject_token` parameter. Supported values
	// are `urn:ietf:params:oauth:token-type:jwt`,
	// `urn:ietf:params:oauth:token-type:id_token`,
	// `urn:ietf:params:aws:token-type:aws4_request`,
	// `urn:ietf:params:oauth:token-type:access_token`, and
	// `urn:ietf:params:oauth:token-type:saml2`.
	SubjectTokenType string `json:"subjectTokenType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audience") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audience") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1ExchangeTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1ExchangeTokenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1ExchangeTokenResponse: Response message for
// ExchangeToken.
type GoogleIdentityStsV1ExchangeTokenResponse struct {
	// AccessToken: An OAuth 2.0 security token, issued by Google, in
	// response to the token exchange request. Tokens can vary in size,
	// depending in part on the size of mapped claims, up to a maximum of
	// 12288 bytes (12 KB). Google reserves the right to change the token
	// size and the maximum length at any time.
	AccessToken string `json:"access_token,omitempty"`

	// ExpiresIn: The amount of time, in seconds, between the time when the
	// access token was issued and the time when the access token will
	// expire. This field is absent when the `subject_token` in the request
	// is a Google-issued, short-lived access token. In this case, the
	// access token has the same expiration time as the `subject_token`.
	ExpiresIn int64 `json:"expires_in,omitempty"`

	// IssuedTokenType: The token type. Always matches the value of
	// `requested_token_type` from the request.
	IssuedTokenType string `json:"issued_token_type,omitempty"`

	// TokenType: The type of access token. Always has the value `Bearer`.
	TokenType string `json:"token_type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1ExchangeTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1ExchangeTokenResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1IntrospectTokenRequest: Request message for
// IntrospectToken.
type GoogleIdentityStsV1IntrospectTokenRequest struct {
	// Token: Required. The OAuth 2.0 security token issued by the Security
	// Token Service API.
	Token string `json:"token,omitempty"`

	// TokenTypeHint: Optional. The type of the given token. Supported
	// values are `urn:ietf:params:oauth:token-type:access_token` and
	// `access_token`.
	TokenTypeHint string `json:"tokenTypeHint,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Token") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Token") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1IntrospectTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1IntrospectTokenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1IntrospectTokenResponse: Response message for
// IntrospectToken.
type GoogleIdentityStsV1IntrospectTokenResponse struct {
	// Active: A boolean value that indicates whether the provided access
	// token is currently active.
	Active bool `json:"active,omitempty"`

	// ClientId: The client identifier for the OAuth 2.0 client that
	// requested the provided token.
	ClientId string `json:"client_id,omitempty"`

	// Exp: The expiration timestamp, measured in the number of seconds
	// since January 1 1970 UTC, indicating when this token will expire.
	Exp int64 `json:"exp,omitempty,string"`

	// Iat: The issued timestamp, measured in the number of seconds since
	// January 1 1970 UTC, indicating when this token was originally issued.
	Iat int64 `json:"iat,omitempty,string"`

	// Iss: The issuer of the provided token.
	Iss string `json:"iss,omitempty"`

	// Scope: A list of scopes associated with the provided token.
	Scope string `json:"scope,omitempty"`

	// Sub: The unique user ID associated with the provided token. For
	// Google Accounts, this value is based on the Google Account's user ID.
	// For federated identities, this value is based on the identity pool ID
	// and the value of the mapped `google.subject` attribute.
	Sub string `json:"sub,omitempty"`

	// Username: The human-readable identifier for the token principal
	// subject. For example, if the provided token is associated with a
	// workload identity pool, this field contains a value in the following
	// format:
	// `principal://iam.googleapis.com/projects//locations/global/workloadIde
	// ntityPools//subject/`. If the provided token is associated with a
	// workforce pool, this field contains a value in the following format:
	// `principal://iam.googleapis.com/locations/global/workforcePools//subje
	// ct/`.
	Username string `json:"username,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Active") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1IntrospectTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1IntrospectTokenResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1Options: An `Options` object configures features
// that the Security Token Service supports, but that are not supported
// by standard OAuth 2.0 token exchange endpoints, as defined in
// https://tools.ietf.org/html/rfc8693.
type GoogleIdentityStsV1Options struct {
	// AccessBoundary: An access boundary that defines the upper bound of
	// permissions the credential may have. The value should be a JSON
	// object of AccessBoundary. The access boundary can include up to 10
	// rules. The size of the parameter value should not exceed 2048
	// characters.
	AccessBoundary *GoogleIdentityStsV1AccessBoundary `json:"accessBoundary,omitempty"`

	// Audiences: The intended audience(s) of the credential. The audience
	// value(s) should be the name(s) of services intended to receive the
	// credential. Example: `["https://pubsub.googleapis.com/",
	// "https://storage.googleapis.com/"]`. A maximum of 5 audiences can be
	// included. For each provided audience, the maximum length is 262
	// characters.
	Audiences []string `json:"audiences,omitempty"`

	// UserProject: A Google project used for quota and billing purposes
	// when the credential is used to access Google APIs. The provided
	// project overrides the project bound to the credential. The value must
	// be a project number or a project ID. Example:
	// `my-sample-project-191923`. The maximum length is 32 characters.
	UserProject string `json:"userProject,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBoundary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBoundary") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1Options) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1Options
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1betaAccessBoundary: An access boundary defines the
// upper bound of what a principal may access. It includes a list of
// access boundary rules that each defines the resource that may be
// allowed as well as permissions that may be used on those resources.
type GoogleIdentityStsV1betaAccessBoundary struct {
	// AccessBoundaryRules: A list of access boundary rules which defines
	// the upper bound of the permission a principal may carry. If multiple
	// rules are specified, the effective access boundary is the union of
	// all the access boundary rules attached. One access boundary can
	// contain at most 10 rules.
	AccessBoundaryRules []*GoogleIdentityStsV1betaAccessBoundaryRule `json:"accessBoundaryRules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBoundaryRules")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBoundaryRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1betaAccessBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1betaAccessBoundary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1betaAccessBoundaryRule: An access boundary rule
// defines an upper bound of IAM permissions on a single resource.
type GoogleIdentityStsV1betaAccessBoundaryRule struct {
	// AvailabilityCondition: The availability condition further constrains
	// the access allowed by the access boundary rule. If the condition
	// evaluates to `true`, then this access boundary rule will provide
	// access to the specified resource, assuming the principal has the
	// required permissions for the resource. If the condition does not
	// evaluate to `true`, then access to the specified resource will not be
	// available. Note that all access boundary rules in an access boundary
	// are evaluated together as a union. As such, another access boundary
	// rule may allow access to the resource, even if this access boundary
	// rule does not allow access. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies). The
	// maximum length of the `expression` field is 2048 characters.
	AvailabilityCondition *GoogleTypeExpr `json:"availabilityCondition,omitempty"`

	// AvailablePermissions: A list of permissions that may be allowed for
	// use on the specified resource. The only supported values in the list
	// are IAM roles, following the format of google.iam.v1.Binding.role.
	// Example value: `inRole:roles/logging.viewer` for predefined roles and
	// `inRole:organizations/{ORGANIZATION_ID}/roles/logging.viewer` for
	// custom roles.
	AvailablePermissions []string `json:"availablePermissions,omitempty"`

	// AvailableResource: The full resource name of a Google Cloud resource
	// entity. The format definition is at
	// https://cloud.google.com/apis/design/resource_names. Example value:
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	AvailableResource string `json:"availableResource,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AvailabilityCondition") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvailabilityCondition") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1betaAccessBoundaryRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1betaAccessBoundaryRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1betaOptions: An `Options` object configures
// features that the Security Token Service supports, but that are not
// supported by standard OAuth 2.0 token exchange endpoints, as defined
// in https://tools.ietf.org/html/rfc8693.
type GoogleIdentityStsV1betaOptions struct {
	// AccessBoundary: An access boundary that defines the upper bound of
	// permissions the credential may have. The value should be a JSON
	// object of AccessBoundary. The access boundary can include up to 10
	// rules. The size of the parameter value should not exceed 2048
	// characters.
	AccessBoundary *GoogleIdentityStsV1betaAccessBoundary `json:"accessBoundary,omitempty"`

	// Audiences: The intended audience(s) of the credential. The audience
	// value(s) should be the name(s) of services intended to receive the
	// credential. Example: `["https://pubsub.googleapis.com/",
	// "https://storage.googleapis.com/"]`. A maximum of 5 audiences can be
	// included. For each provided audience, the maximum length is 262
	// characters.
	Audiences []string `json:"audiences,omitempty"`

	// UserProject: A Google project used for quota and billing purposes
	// when the credential is used to access Google APIs. The provided
	// project overrides the project bound to the credential. The value must
	// be a project number or a project ID. Example:
	// `my-sample-project-191923`. The maximum length is 32 characters.
	UserProject string `json:"userProject,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBoundary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBoundary") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1betaOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1betaOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common
// Expression Language (CEL) syntax. CEL is a C-like expression
// language. The syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec. Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "sts.introspect":

type V1IntrospectCall struct {
	s                                         *Service
	googleidentitystsv1introspecttokenrequest *GoogleIdentityStsV1IntrospectTokenRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Introspect: Gets information about a Google OAuth 2.0 access token
// issued by the Google Cloud Security Token Service API
// (https://cloud.google.com/iam/docs/reference/sts/rest).
func (r *V1Service) Introspect(googleidentitystsv1introspecttokenrequest *GoogleIdentityStsV1IntrospectTokenRequest) *V1IntrospectCall {
	c := &V1IntrospectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleidentitystsv1introspecttokenrequest = googleidentitystsv1introspecttokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1IntrospectCall) Fields(s ...googleapi.Field) *V1IntrospectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1IntrospectCall) Context(ctx context.Context) *V1IntrospectCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1IntrospectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1IntrospectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleidentitystsv1introspecttokenrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/introspect")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sts.introspect" call.
// Exactly one of *GoogleIdentityStsV1IntrospectTokenResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleIdentityStsV1IntrospectTokenResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *V1IntrospectCall) Do(opts ...googleapi.CallOption) (*GoogleIdentityStsV1IntrospectTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIdentityStsV1IntrospectTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a Google OAuth 2.0 access token issued by the Google Cloud [Security Token Service API](https://cloud.google.com/iam/docs/reference/sts/rest).",
	//   "flatPath": "v1/introspect",
	//   "httpMethod": "POST",
	//   "id": "sts.introspect",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1/introspect",
	//   "request": {
	//     "$ref": "GoogleIdentityStsV1IntrospectTokenRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIdentityStsV1IntrospectTokenResponse"
	//   }
	// }

}

// method id "sts.oauthtoken":

type V1OauthtokenCall struct {
	s                                            *Service
	googleidentitystsv1exchangeoauthtokenrequest *GoogleIdentityStsV1ExchangeOauthTokenRequest
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Oauthtoken: Exchanges a credential that represents the resource
// owner's authorization for a Google-generated [OAuth 2.0 access token]
// (https://www.rfc-editor.org/rfc/rfc6749#section-5) or [refreshes an
// accesstoken] (https://www.rfc-editor.org/rfc/rfc6749#section-6)
// following [the OAuth 2.0 authorization framework]
// (https://tools.ietf.org/html/rfc8693) The credential can be one of
// the following: - An authorization code issued by the workforce
// identity federation authorization endpoint - A refresh token
// (https://www.rfc-editor.org/rfc/rfc6749#section-10.4) issued by this
// endpoint This endpoint is only meant to be called by the Google Cloud
// CLI. Also note that this API only accepts the authorization code
// issued for workforce pools.
func (r *V1Service) Oauthtoken(googleidentitystsv1exchangeoauthtokenrequest *GoogleIdentityStsV1ExchangeOauthTokenRequest) *V1OauthtokenCall {
	c := &V1OauthtokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleidentitystsv1exchangeoauthtokenrequest = googleidentitystsv1exchangeoauthtokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1OauthtokenCall) Fields(s ...googleapi.Field) *V1OauthtokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1OauthtokenCall) Context(ctx context.Context) *V1OauthtokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1OauthtokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1OauthtokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleidentitystsv1exchangeoauthtokenrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/oauthtoken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sts.oauthtoken" call.
// Exactly one of *GoogleIdentityStsV1ExchangeOauthTokenResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleIdentityStsV1ExchangeOauthTokenResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *V1OauthtokenCall) Do(opts ...googleapi.CallOption) (*GoogleIdentityStsV1ExchangeOauthTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIdentityStsV1ExchangeOauthTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Exchanges a credential that represents the resource owner's authorization for a Google-generated [OAuth 2.0 access token] (https://www.rfc-editor.org/rfc/rfc6749#section-5) or [refreshes an accesstoken] (https://www.rfc-editor.org/rfc/rfc6749#section-6) following [the OAuth 2.0 authorization framework] (https://tools.ietf.org/html/rfc8693) The credential can be one of the following: - An authorization code issued by the workforce identity federation authorization endpoint - A [refresh token](https://www.rfc-editor.org/rfc/rfc6749#section-10.4) issued by this endpoint This endpoint is only meant to be called by the Google Cloud CLI. Also note that this API only accepts the authorization code issued for workforce pools.",
	//   "flatPath": "v1/oauthtoken",
	//   "httpMethod": "POST",
	//   "id": "sts.oauthtoken",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1/oauthtoken",
	//   "request": {
	//     "$ref": "GoogleIdentityStsV1ExchangeOauthTokenRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIdentityStsV1ExchangeOauthTokenResponse"
	//   }
	// }

}

// method id "sts.token":

type V1TokenCall struct {
	s                                       *Service
	googleidentitystsv1exchangetokenrequest *GoogleIdentityStsV1ExchangeTokenRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Token: Exchanges a credential for a Google OAuth 2.0 access token.
// The token asserts an external identity within an identity pool, or it
// applies a Credential Access Boundary to a Google access token. Note
// that workforce pools do not support Credential Access Boundaries.
// When you call this method, do not send the `Authorization` HTTP
// header in the request. This method does not require the
// `Authorization` header, and using the header can cause the request to
// fail.
func (r *V1Service) Token(googleidentitystsv1exchangetokenrequest *GoogleIdentityStsV1ExchangeTokenRequest) *V1TokenCall {
	c := &V1TokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleidentitystsv1exchangetokenrequest = googleidentitystsv1exchangetokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1TokenCall) Fields(s ...googleapi.Field) *V1TokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1TokenCall) Context(ctx context.Context) *V1TokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1TokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1TokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleidentitystsv1exchangetokenrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/token")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sts.token" call.
// Exactly one of *GoogleIdentityStsV1ExchangeTokenResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleIdentityStsV1ExchangeTokenResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *V1TokenCall) Do(opts ...googleapi.CallOption) (*GoogleIdentityStsV1ExchangeTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIdentityStsV1ExchangeTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Exchanges a credential for a Google OAuth 2.0 access token. The token asserts an external identity within an identity pool, or it applies a Credential Access Boundary to a Google access token. Note that workforce pools do not support Credential Access Boundaries. When you call this method, do not send the `Authorization` HTTP header in the request. This method does not require the `Authorization` header, and using the header can cause the request to fail.",
	//   "flatPath": "v1/token",
	//   "httpMethod": "POST",
	//   "id": "sts.token",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1/token",
	//   "request": {
	//     "$ref": "GoogleIdentityStsV1ExchangeTokenRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIdentityStsV1ExchangeTokenResponse"
	//   }
	// }

}
