// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package dataflow

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListPoolsRequest wrapper for the ListPools operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/dataflow/ListPools.go.html to see an example of how to use ListPoolsRequest.
type ListPoolsRequest struct {

	// The OCID of the compartment.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// Unique identifier for the request. If provided, the returned request ID will include this value.
	// Otherwise, a random request ID will be generated by the service.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// The maximum number of results to return in a paginated `List` call.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The value of the `opc-next-page` or `opc-prev-page` response header from the last `List` call
	// to sent back to server for getting the next page of results.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The LifecycleState of the pool.
	LifecycleState ListPoolsLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// The field used to sort the results. Multiple fields are not supported.
	SortBy ListPoolsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The ordering of results in ascending or descending order.
	SortOrder ListPoolsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The query parameter for the Spark application name.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// The OCID of the user who created the resource.
	OwnerPrincipalId *string `mandatory:"false" contributesTo:"query" name:"ownerPrincipalId"`

	// The displayName prefix.
	DisplayNameStartsWith *string `mandatory:"false" contributesTo:"query" name:"displayNameStartsWith"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListPoolsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListPoolsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListPoolsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListPoolsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListPoolsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListPoolsLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetListPoolsLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListPoolsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListPoolsSortByEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListPoolsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListPoolsSortOrderEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListPoolsResponse wrapper for the ListPools operation
type ListPoolsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of PoolCollection instances
	PoolCollection `presentIn:"body"`

	// Retrieves the previous page of results.
	// When this header appears in the response, previous pages of results exist.
	// See List Pagination (https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	OpcPrevPage *string `presentIn:"header" name:"opc-prev-page"`

	// Retrieves the next page of results. When this header appears in the response,
	// additional pages of results remain. See List Pagination (https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`

	// Unique Oracle assigned identifier for the request.
	// If you need to contact Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`
}

func (response ListPoolsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListPoolsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListPoolsLifecycleStateEnum Enum with underlying type: string
type ListPoolsLifecycleStateEnum string

// Set of constants representing the allowable values for ListPoolsLifecycleStateEnum
const (
	ListPoolsLifecycleStateAccepted  ListPoolsLifecycleStateEnum = "ACCEPTED"
	ListPoolsLifecycleStateScheduled ListPoolsLifecycleStateEnum = "SCHEDULED"
	ListPoolsLifecycleStateCreating  ListPoolsLifecycleStateEnum = "CREATING"
	ListPoolsLifecycleStateActive    ListPoolsLifecycleStateEnum = "ACTIVE"
	ListPoolsLifecycleStateStopping  ListPoolsLifecycleStateEnum = "STOPPING"
	ListPoolsLifecycleStateStopped   ListPoolsLifecycleStateEnum = "STOPPED"
	ListPoolsLifecycleStateUpdating  ListPoolsLifecycleStateEnum = "UPDATING"
	ListPoolsLifecycleStateDeleting  ListPoolsLifecycleStateEnum = "DELETING"
	ListPoolsLifecycleStateDeleted   ListPoolsLifecycleStateEnum = "DELETED"
	ListPoolsLifecycleStateFailed    ListPoolsLifecycleStateEnum = "FAILED"
)

var mappingListPoolsLifecycleStateEnum = map[string]ListPoolsLifecycleStateEnum{
	"ACCEPTED":  ListPoolsLifecycleStateAccepted,
	"SCHEDULED": ListPoolsLifecycleStateScheduled,
	"CREATING":  ListPoolsLifecycleStateCreating,
	"ACTIVE":    ListPoolsLifecycleStateActive,
	"STOPPING":  ListPoolsLifecycleStateStopping,
	"STOPPED":   ListPoolsLifecycleStateStopped,
	"UPDATING":  ListPoolsLifecycleStateUpdating,
	"DELETING":  ListPoolsLifecycleStateDeleting,
	"DELETED":   ListPoolsLifecycleStateDeleted,
	"FAILED":    ListPoolsLifecycleStateFailed,
}

var mappingListPoolsLifecycleStateEnumLowerCase = map[string]ListPoolsLifecycleStateEnum{
	"accepted":  ListPoolsLifecycleStateAccepted,
	"scheduled": ListPoolsLifecycleStateScheduled,
	"creating":  ListPoolsLifecycleStateCreating,
	"active":    ListPoolsLifecycleStateActive,
	"stopping":  ListPoolsLifecycleStateStopping,
	"stopped":   ListPoolsLifecycleStateStopped,
	"updating":  ListPoolsLifecycleStateUpdating,
	"deleting":  ListPoolsLifecycleStateDeleting,
	"deleted":   ListPoolsLifecycleStateDeleted,
	"failed":    ListPoolsLifecycleStateFailed,
}

// GetListPoolsLifecycleStateEnumValues Enumerates the set of values for ListPoolsLifecycleStateEnum
func GetListPoolsLifecycleStateEnumValues() []ListPoolsLifecycleStateEnum {
	values := make([]ListPoolsLifecycleStateEnum, 0)
	for _, v := range mappingListPoolsLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetListPoolsLifecycleStateEnumStringValues Enumerates the set of values in String for ListPoolsLifecycleStateEnum
func GetListPoolsLifecycleStateEnumStringValues() []string {
	return []string{
		"ACCEPTED",
		"SCHEDULED",
		"CREATING",
		"ACTIVE",
		"STOPPING",
		"STOPPED",
		"UPDATING",
		"DELETING",
		"DELETED",
		"FAILED",
	}
}

// GetMappingListPoolsLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListPoolsLifecycleStateEnum(val string) (ListPoolsLifecycleStateEnum, bool) {
	enum, ok := mappingListPoolsLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListPoolsSortByEnum Enum with underlying type: string
type ListPoolsSortByEnum string

// Set of constants representing the allowable values for ListPoolsSortByEnum
const (
	ListPoolsSortByTimecreated ListPoolsSortByEnum = "timeCreated"
)

var mappingListPoolsSortByEnum = map[string]ListPoolsSortByEnum{
	"timeCreated": ListPoolsSortByTimecreated,
}

var mappingListPoolsSortByEnumLowerCase = map[string]ListPoolsSortByEnum{
	"timecreated": ListPoolsSortByTimecreated,
}

// GetListPoolsSortByEnumValues Enumerates the set of values for ListPoolsSortByEnum
func GetListPoolsSortByEnumValues() []ListPoolsSortByEnum {
	values := make([]ListPoolsSortByEnum, 0)
	for _, v := range mappingListPoolsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListPoolsSortByEnumStringValues Enumerates the set of values in String for ListPoolsSortByEnum
func GetListPoolsSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
	}
}

// GetMappingListPoolsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListPoolsSortByEnum(val string) (ListPoolsSortByEnum, bool) {
	enum, ok := mappingListPoolsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListPoolsSortOrderEnum Enum with underlying type: string
type ListPoolsSortOrderEnum string

// Set of constants representing the allowable values for ListPoolsSortOrderEnum
const (
	ListPoolsSortOrderAsc  ListPoolsSortOrderEnum = "ASC"
	ListPoolsSortOrderDesc ListPoolsSortOrderEnum = "DESC"
)

var mappingListPoolsSortOrderEnum = map[string]ListPoolsSortOrderEnum{
	"ASC":  ListPoolsSortOrderAsc,
	"DESC": ListPoolsSortOrderDesc,
}

var mappingListPoolsSortOrderEnumLowerCase = map[string]ListPoolsSortOrderEnum{
	"asc":  ListPoolsSortOrderAsc,
	"desc": ListPoolsSortOrderDesc,
}

// GetListPoolsSortOrderEnumValues Enumerates the set of values for ListPoolsSortOrderEnum
func GetListPoolsSortOrderEnumValues() []ListPoolsSortOrderEnum {
	values := make([]ListPoolsSortOrderEnum, 0)
	for _, v := range mappingListPoolsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListPoolsSortOrderEnumStringValues Enumerates the set of values in String for ListPoolsSortOrderEnum
func GetListPoolsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListPoolsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListPoolsSortOrderEnum(val string) (ListPoolsSortOrderEnum, bool) {
	enum, ok := mappingListPoolsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
