// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Resource Analytics API
//
// Use the Resource Analytics API to manage Resource Analytics Instances.
//

package resourceanalytics

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ResourceAnalyticsInstanceOacNetworkDetails Details required when provisioning OAC on a private network.
// Example: `{"subnetId":"ocid...", ...}`
type ResourceAnalyticsInstanceOacNetworkDetails struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet for the private network details.
	SubnetId *string `mandatory:"true" json:"subnetId"`

	// List of Network Security Group OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm)'s for the private network details.
	// Example: `["ocid...", "ocid..."]`
	NsgIds []string `mandatory:"false" json:"nsgIds"`
}

func (m ResourceAnalyticsInstanceOacNetworkDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ResourceAnalyticsInstanceOacNetworkDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
