# Contributing

## Bug reports

- Before reporting a bug, have a look at the [issue
  list](https://github.com/jstemmer/go-junit-report/issues) to see if an issue
  already exists for your problem.
- Include as much information as you can in the bug report, e.g.: the versions
  of go-junit-report and the Go compiler, how go-junit-report was called, what
  input was given to go-junit-report, what the actual output was, was the
  expected output was.

## Pull requests

- Before sending a pull request for new features, open an issue to discuss it.
- Run `go fmt` to format your code.
- Add test coverage and run all tests.
- Prefer small PRs, avoid making unrelated changes in the same PR.
- Limit the first line of the commit message to 72 characters.
- Write commit messages in the imperative mood ("Fix bug", not "Fixed bug" or
  "Fixes bug") .
