package ansiblelocal

import (
	_ "embed"
	"fmt"
	"io/ioutil"
	"os"
	"os/exec"
	"regexp"
	"testing"

	"github.com/hashicorp/packer-plugin-sdk/acctest"
)

//go:embed test-fixtures/docker_playbookdir_template.pkr.hcl
var testPlaybookDirTemplate string

//go:embed test-fixtures/docker_playbookfiles_template.pkr.hcl
var testPlaybookFilesTemplate string

// Run with: PACKER_ACC=1 go test -count 1 -v ./provisioner/ansible-local/provisioner_acc_test.go  -timeout=120m
func TestAccAnsibleLocalProvisioner_Playbookdir(t *testing.T) {
	testCase := &acctest.PluginTestCase{
		Name:     "ansible-local_provisioner_docker_playbookdir_test",
		Init:     true,
		Template: testPlaybookDirTemplate,
		Type:     "ansible-local",
		Check: func(buildCommand *exec.Cmd, logfile string) error {
			if buildCommand.ProcessState != nil {
				if buildCommand.ProcessState.ExitCode() != 0 {
					return fmt.Errorf("Bad exit code. Logfile: %s", logfile)
				}
			}

			logs, err := os.Open(logfile)
			if err != nil {
				return fmt.Errorf("Unable find %s", logfile)
			}
			defer logs.Close()

			logsBytes, err := ioutil.ReadAll(logs)
			if err != nil {
				return fmt.Errorf("Unable to read %s", logfile)
			}
			logsString := string(logsBytes)

			provisionerOutputLog := "docker.autogenerated_1: Downloading /tmp/hello_world => hello_world"
			if matched, _ := regexp.MatchString(provisionerOutputLog+".*", logsString); !matched {
				t.Fatalf("logs doesn't contain expected foo value %q", logsString)
			}
			return nil
		},
	}
	acctest.TestPlugin(t, testCase)
}

func TestAccAnsibleLocalProvisioner_Playbookfiles(t *testing.T) {
	testCase := &acctest.PluginTestCase{
		Name:     "ansible-local_provisioner_docker_playbookfiles_test",
		Init:     true,
		Template: testPlaybookFilesTemplate,
		Type:     "ansible-local",
		Check: func(buildCommand *exec.Cmd, logfile string) error {
			if buildCommand.ProcessState != nil {
				if buildCommand.ProcessState.ExitCode() != 0 {
					return fmt.Errorf("Bad exit code. Logfile: %s", logfile)
				}
			}

			logs, err := os.Open(logfile)
			if err != nil {
				return fmt.Errorf("Unable find %s", logfile)
			}
			defer logs.Close()

			logsBytes, err := ioutil.ReadAll(logs)
			if err != nil {
				return fmt.Errorf("Unable to read %s", logfile)
			}
			logsString := string(logsBytes)

			provisionerOutputLog := "docker.autogenerated_1: Downloading /tmp/hello_world => hello_world"
			if matched, _ := regexp.MatchString(provisionerOutputLog+".*", logsString); !matched {
				t.Fatalf("logs doesn't contain expected foo value %q", logsString)
			}
			return nil
		},
	}
	acctest.TestPlugin(t, testCase)
}

/*
func TestProvisionerProvisionDocker_PlaybookFiles(t *testing.T) {
	testProvisionerProvisionDockerWithPlaybookFiles(t, playbookFilesDockerTemplate)
}

func TestProvisionerProvisionDocker_PlaybookFilesWithPlaybookDir(t *testing.T) {
	testProvisionerProvisionDockerWithPlaybookFiles(t, playbookFilesWithPlaybookDirDockerTemplate)
}

func testProvisionerProvisionDockerWithPlaybookFiles(t *testing.T, templateString string) {
	if os.Getenv("PACKER_ACC") == "" {
		t.Skip("This test is only run with PACKER_ACC=1")
	}

	// this should be a precheck
	cmd := exec.Command("docker", "-v")
	err := cmd.Run()
	if err != nil {
		t.Error("docker command not found; please make sure docker is installed")
	}

	builderT.Test(t, builderT.TestCase{
		Builder:  &docker.Builder{},
		Template: templateString,
		Check: func(a []packersdk.Artifact) error {

			actualContent, err := ioutil.ReadFile("hello_world")
			if err != nil {
				return fmt.Errorf("Expected file not found: %s", err)
			}

			expectedContent := "Hello world!"
			if string(actualContent) != expectedContent {
				return fmt.Errorf(`Unexpected file content: expected="%s", actual="%s"`, expectedContent, actualContent)
			}
			return nil
		},
		Teardown: func() error {
			os.Remove("hello_world")
			return nil
		},
		ProvisionerStore: packersdk.MapOfProvisioner{
			"ansible-local": func() (packersdk.Provisioner, error) { return &Provisioner{}, nil },
			"file":          func() (packersdk.Provisioner, error) { return &file.Provisioner{}, nil },
		},
	})
}

*/
