// Code generated by go-swagger; DO NOT EDIT.

package organization_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/preview/2019-12-10/models"
)

// NewOrganizationServiceSetNameParams creates a new OrganizationServiceSetNameParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewOrganizationServiceSetNameParams() *OrganizationServiceSetNameParams {
	return &OrganizationServiceSetNameParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewOrganizationServiceSetNameParamsWithTimeout creates a new OrganizationServiceSetNameParams object
// with the ability to set a timeout on a request.
func NewOrganizationServiceSetNameParamsWithTimeout(timeout time.Duration) *OrganizationServiceSetNameParams {
	return &OrganizationServiceSetNameParams{
		timeout: timeout,
	}
}

// NewOrganizationServiceSetNameParamsWithContext creates a new OrganizationServiceSetNameParams object
// with the ability to set a context for a request.
func NewOrganizationServiceSetNameParamsWithContext(ctx context.Context) *OrganizationServiceSetNameParams {
	return &OrganizationServiceSetNameParams{
		Context: ctx,
	}
}

// NewOrganizationServiceSetNameParamsWithHTTPClient creates a new OrganizationServiceSetNameParams object
// with the ability to set a custom HTTPClient for a request.
func NewOrganizationServiceSetNameParamsWithHTTPClient(client *http.Client) *OrganizationServiceSetNameParams {
	return &OrganizationServiceSetNameParams{
		HTTPClient: client,
	}
}

/*
OrganizationServiceSetNameParams contains all the parameters to send to the API endpoint

	for the organization service set name operation.

	Typically these are written to a http.Request.
*/
type OrganizationServiceSetNameParams struct {

	// Body.
	Body *models.HashicorpCloudResourcemanagerOrganizationSetNameRequest

	/* ID.

	   ID is the identifier of the organization.
	*/
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the organization service set name params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OrganizationServiceSetNameParams) WithDefaults() *OrganizationServiceSetNameParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the organization service set name params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OrganizationServiceSetNameParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the organization service set name params
func (o *OrganizationServiceSetNameParams) WithTimeout(timeout time.Duration) *OrganizationServiceSetNameParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the organization service set name params
func (o *OrganizationServiceSetNameParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the organization service set name params
func (o *OrganizationServiceSetNameParams) WithContext(ctx context.Context) *OrganizationServiceSetNameParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the organization service set name params
func (o *OrganizationServiceSetNameParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the organization service set name params
func (o *OrganizationServiceSetNameParams) WithHTTPClient(client *http.Client) *OrganizationServiceSetNameParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the organization service set name params
func (o *OrganizationServiceSetNameParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the organization service set name params
func (o *OrganizationServiceSetNameParams) WithBody(body *models.HashicorpCloudResourcemanagerOrganizationSetNameRequest) *OrganizationServiceSetNameParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the organization service set name params
func (o *OrganizationServiceSetNameParams) SetBody(body *models.HashicorpCloudResourcemanagerOrganizationSetNameRequest) {
	o.Body = body
}

// WithID adds the id to the organization service set name params
func (o *OrganizationServiceSetNameParams) WithID(id string) *OrganizationServiceSetNameParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the organization service set name params
func (o *OrganizationServiceSetNameParams) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *OrganizationServiceSetNameParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
