// Code generated by go-swagger; DO NOT EDIT.

package cli

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-swagger/go-swagger/examples/cli/models"
	"github.com/spf13/cobra"
)

// Schema cli for Item

// register flags to command
func registerModelItemFlags(depth int, cmdPrefix string, cmd *cobra.Command) error {

	if err := registerItemCompleted(depth, cmdPrefix, cmd); err != nil {
		return err
	}

	if err := registerItemDescription(depth, cmdPrefix, cmd); err != nil {
		return err
	}

	if err := registerItemID(depth, cmdPrefix, cmd); err != nil {
		return err
	}

	return nil
}

func registerItemCompleted(depth int, cmdPrefix string, cmd *cobra.Command) error {
	if depth > maxDepth {
		return nil
	}

	completedDescription := ``

	var completedFlagName string
	if cmdPrefix == "" {
		completedFlagName = "completed"
	} else {
		completedFlagName = fmt.Sprintf("%v.completed", cmdPrefix)
	}

	var completedFlagDefault bool

	_ = cmd.PersistentFlags().Bool(completedFlagName, completedFlagDefault, completedDescription)

	return nil
}

func registerItemDescription(depth int, cmdPrefix string, cmd *cobra.Command) error {
	if depth > maxDepth {
		return nil
	}

	descriptionDescription := `Required. `

	var descriptionFlagName string
	if cmdPrefix == "" {
		descriptionFlagName = "description"
	} else {
		descriptionFlagName = fmt.Sprintf("%v.description", cmdPrefix)
	}

	var descriptionFlagDefault string

	_ = cmd.PersistentFlags().String(descriptionFlagName, descriptionFlagDefault, descriptionDescription)

	return nil
}

func registerItemID(depth int, cmdPrefix string, cmd *cobra.Command) error {
	if depth > maxDepth {
		return nil
	}

	idDescription := ``

	var idFlagName string
	if cmdPrefix == "" {
		idFlagName = "id"
	} else {
		idFlagName = fmt.Sprintf("%v.id", cmdPrefix)
	}

	var idFlagDefault int64

	_ = cmd.PersistentFlags().Int64(idFlagName, idFlagDefault, idDescription)

	return nil
}

// retrieve flags from commands, and set value in model. Return true if any flag is passed by user to fill model field.
func retrieveModelItemFlags(depth int, m *models.Item, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	retAdded := false

	err, completedAdded := retrieveItemCompletedFlags(depth, m, cmdPrefix, cmd)
	if err != nil {
		return err, false
	}
	retAdded = retAdded || completedAdded

	err, descriptionAdded := retrieveItemDescriptionFlags(depth, m, cmdPrefix, cmd)
	if err != nil {
		return err, false
	}
	retAdded = retAdded || descriptionAdded

	err, idAdded := retrieveItemIDFlags(depth, m, cmdPrefix, cmd)
	if err != nil {
		return err, false
	}
	retAdded = retAdded || idAdded

	return nil, retAdded
}

func retrieveItemCompletedFlags(depth int, m *models.Item, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	if depth > maxDepth {
		return nil, false
	}
	retAdded := false

	completedFlagName := fmt.Sprintf("%v.completed", cmdPrefix)
	if cmd.Flags().Changed(completedFlagName) {

		var completedFlagName string
		if cmdPrefix == "" {
			completedFlagName = "completed"
		} else {
			completedFlagName = fmt.Sprintf("%v.completed", cmdPrefix)
		}

		completedFlagValue, err := cmd.Flags().GetBool(completedFlagName)
		if err != nil {
			return err, false
		}
		m.Completed = completedFlagValue

		retAdded = true
	}

	return nil, retAdded
}

func retrieveItemDescriptionFlags(depth int, m *models.Item, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	if depth > maxDepth {
		return nil, false
	}
	retAdded := false

	descriptionFlagName := fmt.Sprintf("%v.description", cmdPrefix)
	if cmd.Flags().Changed(descriptionFlagName) {

		var descriptionFlagName string
		if cmdPrefix == "" {
			descriptionFlagName = "description"
		} else {
			descriptionFlagName = fmt.Sprintf("%v.description", cmdPrefix)
		}

		descriptionFlagValue, err := cmd.Flags().GetString(descriptionFlagName)
		if err != nil {
			return err, false
		}
		m.Description = &descriptionFlagValue

		retAdded = true
	}

	return nil, retAdded
}

func retrieveItemIDFlags(depth int, m *models.Item, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	if depth > maxDepth {
		return nil, false
	}
	retAdded := false

	idFlagName := fmt.Sprintf("%v.id", cmdPrefix)
	if cmd.Flags().Changed(idFlagName) {

		var idFlagName string
		if cmdPrefix == "" {
			idFlagName = "id"
		} else {
			idFlagName = fmt.Sprintf("%v.id", cmdPrefix)
		}

		idFlagValue, err := cmd.Flags().GetInt64(idFlagName)
		if err != nil {
			return err, false
		}
		m.ID = idFlagValue

		retAdded = true
	}

	return nil, retAdded
}
