// Code generated by protoc-gen-go-aip. DO NOT EDIT.
//
// versions:
// 	protoc-gen-go-aip development
// 	protoc (unknown)
// source: coinbase/cloud/mpc_transactions/v1/mpc_transactions.proto

package v1

import (
	fmt "fmt"
	resourcename "go.einride.tech/aip/resourcename"
	strings "strings"
)

type MPCTransactionResourceName struct {
	PoolId           string
	MpcWalletId      string
	MpcTransactionId string
}

func (n MPCTransactionResourceName) Validate() error {
	if n.PoolId == "" {
		return fmt.Errorf("pool_id: empty")
	}
	if strings.IndexByte(n.PoolId, '/') != -1 {
		return fmt.Errorf("pool_id: contains illegal character '/'")
	}
	if n.MpcWalletId == "" {
		return fmt.Errorf("mpc_wallet_id: empty")
	}
	if strings.IndexByte(n.MpcWalletId, '/') != -1 {
		return fmt.Errorf("mpc_wallet_id: contains illegal character '/'")
	}
	if n.MpcTransactionId == "" {
		return fmt.Errorf("mpc_transaction_id: empty")
	}
	if strings.IndexByte(n.MpcTransactionId, '/') != -1 {
		return fmt.Errorf("mpc_transaction_id: contains illegal character '/'")
	}
	return nil
}

func (n MPCTransactionResourceName) ContainsWildcard() bool {
	return false || n.PoolId == "-" || n.MpcWalletId == "-" || n.MpcTransactionId == "-"
}

func (n MPCTransactionResourceName) String() string {
	return resourcename.Sprint(
		"pools/{pool_id}/mpcWallets/{mpc_wallet_id}/mpcTransactions/{mpc_transaction_id}",
		n.PoolId,
		n.MpcWalletId,
		n.MpcTransactionId,
	)
}

func (n MPCTransactionResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

func (n *MPCTransactionResourceName) UnmarshalString(name string) error {
	return resourcename.Sscan(
		name,
		"pools/{pool_id}/mpcWallets/{mpc_wallet_id}/mpcTransactions/{mpc_transaction_id}",
		&n.PoolId,
		&n.MpcWalletId,
		&n.MpcTransactionId,
	)
}
