// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"github.com/censys/censys-sdk-go/internal/utils"
	"time"
)

type HostObservationRange struct {
	EndTime           time.Time `json:"end_time"`
	IP                string    `json:"ip"`
	Port              int       `json:"port"`
	Protocols         []string  `json:"protocols"`
	StartTime         time.Time `json:"start_time"`
	TransportProtocol string    `json:"transport_protocol"`
}

func (h HostObservationRange) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(h, "", false)
}

func (h *HostObservationRange) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &h, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *HostObservationRange) GetEndTime() time.Time {
	if o == nil {
		return time.Time{}
	}
	return o.EndTime
}

func (o *HostObservationRange) GetIP() string {
	if o == nil {
		return ""
	}
	return o.IP
}

func (o *HostObservationRange) GetPort() int {
	if o == nil {
		return 0
	}
	return o.Port
}

func (o *HostObservationRange) GetProtocols() []string {
	if o == nil {
		return nil
	}
	return o.Protocols
}

func (o *HostObservationRange) GetStartTime() time.Time {
	if o == nil {
		return time.Time{}
	}
	return o.StartTime
}

func (o *HostObservationRange) GetTransportProtocol() string {
	if o == nil {
		return ""
	}
	return o.TransportProtocol
}
