// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCancelIngestion = "CancelIngestion"

// CancelIngestionRequest generates a "aws/request.Request" representing the
// client's request for the CancelIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelIngestion for more information on using the CancelIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelIngestionRequest method.
//	req, resp := client.CancelIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion
func (c *QuickSight) CancelIngestionRequest(input *CancelIngestionInput) (req *request.Request, output *CancelIngestionOutput) {
	op := &request.Operation{
		Name:       opCancelIngestion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &CancelIngestionInput{}
	}

	output = &CancelIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelIngestion API operation for Amazon QuickSight.
//
// Cancels an ongoing ingestion of data into SPICE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CancelIngestion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion
func (c *QuickSight) CancelIngestion(input *CancelIngestionInput) (*CancelIngestionOutput, error) {
	req, out := c.CancelIngestionRequest(input)
	return out, req.Send()
}

// CancelIngestionWithContext is the same as CancelIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See CancelIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CancelIngestionWithContext(ctx aws.Context, input *CancelIngestionInput, opts ...request.Option) (*CancelIngestionOutput, error) {
	req, out := c.CancelIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccountCustomization = "CreateAccountCustomization"

// CreateAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccountCustomization for more information on using the CreateAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccountCustomizationRequest method.
//	req, resp := client.CreateAccountCustomizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization
func (c *QuickSight) CreateAccountCustomizationRequest(input *CreateAccountCustomizationInput) (req *request.Request, output *CreateAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opCreateAccountCustomization,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &CreateAccountCustomizationInput{}
	}

	output = &CreateAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccountCustomization API operation for Amazon QuickSight.
//
// Creates Amazon QuickSight customizations for the current Amazon Web Services
// Region. Currently, you can add a custom default theme by using the CreateAccountCustomization
// or UpdateAccountCustomization API operation. To further customize Amazon
// QuickSight by removing Amazon QuickSight sample assets and videos for all
// new users, see Customizing Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html)
// in the Amazon QuickSight User Guide.
//
// You can create customizations for your Amazon Web Services account or, if
// you specify a namespace, for a QuickSight namespace instead. Customizations
// that apply to a namespace always override customizations that apply to an
// Amazon Web Services account. To find out which customizations apply, use
// the DescribeAccountCustomization API operation.
//
// Before you use the CreateAccountCustomization API operation to add a theme
// as the namespace default, make sure that you first share the theme with the
// namespace. If you don't share it with the namespace, the theme isn't visible
// to your users even if you make it the default theme. To check if the theme
// is shared, view the current permissions by using the DescribeThemePermissions
// (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html)
// API operation. To share the theme, grant permissions by using the UpdateThemePermissions
// (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html)
// API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateAccountCustomization for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization
func (c *QuickSight) CreateAccountCustomization(input *CreateAccountCustomizationInput) (*CreateAccountCustomizationOutput, error) {
	req, out := c.CreateAccountCustomizationRequest(input)
	return out, req.Send()
}

// CreateAccountCustomizationWithContext is the same as CreateAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateAccountCustomizationWithContext(ctx aws.Context, input *CreateAccountCustomizationInput, opts ...request.Option) (*CreateAccountCustomizationOutput, error) {
	req, out := c.CreateAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccountSubscription = "CreateAccountSubscription"

// CreateAccountSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccountSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccountSubscription for more information on using the CreateAccountSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccountSubscriptionRequest method.
//	req, resp := client.CreateAccountSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountSubscription
func (c *QuickSight) CreateAccountSubscriptionRequest(input *CreateAccountSubscriptionInput) (req *request.Request, output *CreateAccountSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateAccountSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/account/{AwsAccountId}",
	}

	if input == nil {
		input = &CreateAccountSubscriptionInput{}
	}

	output = &CreateAccountSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccountSubscription API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight
// Q.
//
// The Amazon Web Services Region for the account is derived from what is configured
// in the CLI or SDK.
//
// Before you use this operation, make sure that you can connect to an existing
// Amazon Web Services account. If you don't have an Amazon Web Services account,
// see Sign up for Amazon Web Services (https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html)
// in the Amazon QuickSight User Guide. The person who signs up for Amazon QuickSight
// needs to have the correct Identity and Access Management (IAM) permissions.
// For more information, see IAM Policy Examples for Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html)
// in the Amazon QuickSight User Guide.
//
// If your IAM policy includes both the Subscribe and CreateAccountSubscription
// actions, make sure that both actions are set to Allow. If either action is
// set to Deny, the Deny action prevails and your API call fails.
//
// You can't pass an existing IAM role to access other Amazon Web Services services
// using this API operation. To pass your existing IAM role to Amazon QuickSight,
// see Passing IAM roles to Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role)
// in the Amazon QuickSight User Guide.
//
// You can't set default resource access on the new account from the Amazon
// QuickSight API. Instead, add default resource access from the Amazon QuickSight
// console. For more information about setting default resource access to Amazon
// Web Services services, see Setting default resource access to Amazon Web
// Services services (https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html)
// in the Amazon QuickSight User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateAccountSubscription for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountSubscription
func (c *QuickSight) CreateAccountSubscription(input *CreateAccountSubscriptionInput) (*CreateAccountSubscriptionOutput, error) {
	req, out := c.CreateAccountSubscriptionRequest(input)
	return out, req.Send()
}

// CreateAccountSubscriptionWithContext is the same as CreateAccountSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccountSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateAccountSubscriptionWithContext(ctx aws.Context, input *CreateAccountSubscriptionInput, opts ...request.Option) (*CreateAccountSubscriptionOutput, error) {
	req, out := c.CreateAccountSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnalysis = "CreateAnalysis"

// CreateAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnalysis for more information on using the CreateAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAnalysisRequest method.
//	req, resp := client.CreateAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis
func (c *QuickSight) CreateAnalysisRequest(input *CreateAnalysisInput) (req *request.Request, output *CreateAnalysisOutput) {
	op := &request.Operation{
		Name:       opCreateAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &CreateAnalysisInput{}
	}

	output = &CreateAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnalysis API operation for Amazon QuickSight.
//
// Creates an analysis in Amazon QuickSight. Analyses can be created either
// from a template or from an AnalysisDefinition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis
func (c *QuickSight) CreateAnalysis(input *CreateAnalysisInput) (*CreateAnalysisOutput, error) {
	req, out := c.CreateAnalysisRequest(input)
	return out, req.Send()
}

// CreateAnalysisWithContext is the same as CreateAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateAnalysisWithContext(ctx aws.Context, input *CreateAnalysisInput, opts ...request.Option) (*CreateAnalysisOutput, error) {
	req, out := c.CreateAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDashboard = "CreateDashboard"

// CreateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the CreateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDashboard for more information on using the CreateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDashboardRequest method.
//	req, resp := client.CreateDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard
func (c *QuickSight) CreateDashboardRequest(input *CreateDashboardInput) (req *request.Request, output *CreateDashboardOutput) {
	op := &request.Operation{
		Name:       opCreateDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &CreateDashboardInput{}
	}

	output = &CreateDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDashboard API operation for Amazon QuickSight.
//
// Creates a dashboard from either a template or directly with a DashboardDefinition.
// To first create a template, see the CreateTemplate (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html)
// API operation.
//
// A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight
// reports, created from analyses. You can share Amazon QuickSight dashboards.
// With the right permissions, you can create scheduled email reports from them.
// If you have the correct permissions, you can create a dashboard from a template
// that exists in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDashboard for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard
func (c *QuickSight) CreateDashboard(input *CreateDashboardInput) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	return out, req.Send()
}

// CreateDashboardWithContext is the same as CreateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDashboardWithContext(ctx aws.Context, input *CreateDashboardInput, opts ...request.Option) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSet = "CreateDataSet"

// CreateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSet for more information on using the CreateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataSetRequest method.
//	req, resp := client.CreateDataSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet
func (c *QuickSight) CreateDataSetRequest(input *CreateDataSetInput) (req *request.Request, output *CreateDataSetOutput) {
	op := &request.Operation{
		Name:       opCreateDataSet,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets",
	}

	if input == nil {
		input = &CreateDataSetInput{}
	}

	output = &CreateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSet API operation for Amazon QuickSight.
//
// Creates a dataset. This operation doesn't support datasets that include uploaded
// files as a source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDataSet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet
func (c *QuickSight) CreateDataSet(input *CreateDataSetInput) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	return out, req.Send()
}

// CreateDataSetWithContext is the same as CreateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDataSetWithContext(ctx aws.Context, input *CreateDataSetInput, opts ...request.Option) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataSourceRequest method.
//	req, resp := client.CreateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource
func (c *QuickSight) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for Amazon QuickSight.
//
// Creates a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource
func (c *QuickSight) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFolder = "CreateFolder"

// CreateFolderRequest generates a "aws/request.Request" representing the
// client's request for the CreateFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFolder for more information on using the CreateFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFolderRequest method.
//	req, resp := client.CreateFolderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder
func (c *QuickSight) CreateFolderRequest(input *CreateFolderInput) (req *request.Request, output *CreateFolderOutput) {
	op := &request.Operation{
		Name:       opCreateFolder,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &CreateFolderInput{}
	}

	output = &CreateFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFolder API operation for Amazon QuickSight.
//
// Creates an empty shared folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateFolder for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder
func (c *QuickSight) CreateFolder(input *CreateFolderInput) (*CreateFolderOutput, error) {
	req, out := c.CreateFolderRequest(input)
	return out, req.Send()
}

// CreateFolderWithContext is the same as CreateFolder with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateFolderWithContext(ctx aws.Context, input *CreateFolderInput, opts ...request.Option) (*CreateFolderOutput, error) {
	req, out := c.CreateFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFolderMembership = "CreateFolderMembership"

// CreateFolderMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateFolderMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFolderMembership for more information on using the CreateFolderMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFolderMembershipRequest method.
//	req, resp := client.CreateFolderMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership
func (c *QuickSight) CreateFolderMembershipRequest(input *CreateFolderMembershipInput) (req *request.Request, output *CreateFolderMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateFolderMembership,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
	}

	if input == nil {
		input = &CreateFolderMembershipInput{}
	}

	output = &CreateFolderMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFolderMembership API operation for Amazon QuickSight.
//
// Adds an asset, such as a dashboard, analysis, or dataset into a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateFolderMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership
func (c *QuickSight) CreateFolderMembership(input *CreateFolderMembershipInput) (*CreateFolderMembershipOutput, error) {
	req, out := c.CreateFolderMembershipRequest(input)
	return out, req.Send()
}

// CreateFolderMembershipWithContext is the same as CreateFolderMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFolderMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateFolderMembershipWithContext(ctx aws.Context, input *CreateFolderMembershipInput, opts ...request.Option) (*CreateFolderMembershipOutput, error) {
	req, out := c.CreateFolderMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGroupRequest method.
//	req, resp := client.CreateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for Amazon QuickSight.
//
// Use the CreateGroup operation to create a group in Amazon QuickSight. You
// can create up to 10,000 groups in a namespace. If you want to create more
// than 10,000 groups in a namespace, contact Amazon Web Services Support.
//
// The permissions resource is arn:aws:quicksight:<your-region>:<relevant-aws-account-id>:group/default/<group-name> .
//
// The response is a group object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupMembership = "CreateGroupMembership"

// CreateGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupMembership for more information on using the CreateGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGroupMembershipRequest method.
//	req, resp := client.CreateGroupMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembershipRequest(input *CreateGroupMembershipInput) (req *request.Request, output *CreateGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateGroupMembership,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &CreateGroupMembershipInput{}
	}

	output = &CreateGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupMembership API operation for Amazon QuickSight.
//
// Adds an Amazon QuickSight user to an Amazon QuickSight group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroupMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembership(input *CreateGroupMembershipInput) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	return out, req.Send()
}

// CreateGroupMembershipWithContext is the same as CreateGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupMembershipWithContext(ctx aws.Context, input *CreateGroupMembershipInput, opts ...request.Option) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIAMPolicyAssignment = "CreateIAMPolicyAssignment"

// CreateIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIAMPolicyAssignment for more information on using the CreateIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIAMPolicyAssignmentRequest method.
//	req, resp := client.CreateIAMPolicyAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment
func (c *QuickSight) CreateIAMPolicyAssignmentRequest(input *CreateIAMPolicyAssignmentInput) (req *request.Request, output *CreateIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opCreateIAMPolicyAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/",
	}

	if input == nil {
		input = &CreateIAMPolicyAssignmentInput{}
	}

	output = &CreateIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Creates an assignment with one specified IAM policy, identified by its Amazon
// Resource Name (ARN). This policy assignment is attached to the specified
// groups or users of Amazon QuickSight. Assignment names are unique per Amazon
// Web Services account. To avoid overwriting rules in other namespaces, use
// assignment names that are unique.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConcurrentUpdatingException
//     A resource is already in a state that indicates an operation is happening
//     that must complete before a new update can be applied.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment
func (c *QuickSight) CreateIAMPolicyAssignment(input *CreateIAMPolicyAssignmentInput) (*CreateIAMPolicyAssignmentOutput, error) {
	req, out := c.CreateIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// CreateIAMPolicyAssignmentWithContext is the same as CreateIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateIAMPolicyAssignmentWithContext(ctx aws.Context, input *CreateIAMPolicyAssignmentInput, opts ...request.Option) (*CreateIAMPolicyAssignmentOutput, error) {
	req, out := c.CreateIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIngestion = "CreateIngestion"

// CreateIngestionRequest generates a "aws/request.Request" representing the
// client's request for the CreateIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIngestion for more information on using the CreateIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIngestionRequest method.
//	req, resp := client.CreateIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion
func (c *QuickSight) CreateIngestionRequest(input *CreateIngestionInput) (req *request.Request, output *CreateIngestionOutput) {
	op := &request.Operation{
		Name:       opCreateIngestion,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &CreateIngestionInput{}
	}

	output = &CreateIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIngestion API operation for Amazon QuickSight.
//
// Creates and starts a new SPICE ingestion for a dataset. You can manually
// refresh datasets in an Enterprise edition account 32 times in a 24-hour period.
// You can manually refresh datasets in a Standard edition account 8 times in
// a 24-hour period. Each 24-hour period is measured starting 24 hours before
// the current date and time.
//
// Any ingestions operating on tagged datasets inherit the same tags automatically
// for use in access control. For an example, see How do I create an IAM policy
// to control access to Amazon EC2 resources using tags? (http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/)
// in the Amazon Web Services Knowledge Center. Tags are visible on the tagged
// dataset, but not on the ingestion resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateIngestion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion
func (c *QuickSight) CreateIngestion(input *CreateIngestionInput) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	return out, req.Send()
}

// CreateIngestionWithContext is the same as CreateIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateIngestionWithContext(ctx aws.Context, input *CreateIngestionInput, opts ...request.Option) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNamespace = "CreateNamespace"

// CreateNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNamespace for more information on using the CreateNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNamespaceRequest method.
//	req, resp := client.CreateNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace
func (c *QuickSight) CreateNamespaceRequest(input *CreateNamespaceInput) (req *request.Request, output *CreateNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreateNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}",
	}

	if input == nil {
		input = &CreateNamespaceInput{}
	}

	output = &CreateNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNamespace API operation for Amazon QuickSight.
//
// (Enterprise edition only) Creates a new namespace for you to use with Amazon
// QuickSight.
//
// A namespace allows you to isolate the Amazon QuickSight users and groups
// that are registered for that namespace. Users that access the namespace can
// share assets only with other users or groups in the same namespace. They
// can't see users and groups in other namespaces. You can create a namespace
// after your Amazon Web Services account is subscribed to Amazon QuickSight.
// The namespace must be unique within the Amazon Web Services account. By default,
// there is a limit of 100 namespaces per Amazon Web Services account. To increase
// your limit, create a ticket with Amazon Web Services Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateNamespace for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace
func (c *QuickSight) CreateNamespace(input *CreateNamespaceInput) (*CreateNamespaceOutput, error) {
	req, out := c.CreateNamespaceRequest(input)
	return out, req.Send()
}

// CreateNamespaceWithContext is the same as CreateNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateNamespaceWithContext(ctx aws.Context, input *CreateNamespaceInput, opts ...request.Option) (*CreateNamespaceOutput, error) {
	req, out := c.CreateNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRefreshSchedule = "CreateRefreshSchedule"

// CreateRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRefreshSchedule for more information on using the CreateRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRefreshScheduleRequest method.
//	req, resp := client.CreateRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRefreshSchedule
func (c *QuickSight) CreateRefreshScheduleRequest(input *CreateRefreshScheduleInput) (req *request.Request, output *CreateRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opCreateRefreshSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules",
	}

	if input == nil {
		input = &CreateRefreshScheduleInput{}
	}

	output = &CreateRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRefreshSchedule API operation for Amazon QuickSight.
//
// Creates a refresh schedule for a dataset. You can create up to 5 different
// schedules for a single dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRefreshSchedule
func (c *QuickSight) CreateRefreshSchedule(input *CreateRefreshScheduleInput) (*CreateRefreshScheduleOutput, error) {
	req, out := c.CreateRefreshScheduleRequest(input)
	return out, req.Send()
}

// CreateRefreshScheduleWithContext is the same as CreateRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateRefreshScheduleWithContext(ctx aws.Context, input *CreateRefreshScheduleInput, opts ...request.Option) (*CreateRefreshScheduleOutput, error) {
	req, out := c.CreateRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoleMembership = "CreateRoleMembership"

// CreateRoleMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoleMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoleMembership for more information on using the CreateRoleMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRoleMembershipRequest method.
//	req, resp := client.CreateRoleMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRoleMembership
func (c *QuickSight) CreateRoleMembershipRequest(input *CreateRoleMembershipInput) (req *request.Request, output *CreateRoleMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateRoleMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/members/{MemberName}",
	}

	if input == nil {
		input = &CreateRoleMembershipInput{}
	}

	output = &CreateRoleMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoleMembership API operation for Amazon QuickSight.
//
// Use CreateRoleMembership to add an existing Amazon QuickSight group to an
// existing role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateRoleMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRoleMembership
func (c *QuickSight) CreateRoleMembership(input *CreateRoleMembershipInput) (*CreateRoleMembershipOutput, error) {
	req, out := c.CreateRoleMembershipRequest(input)
	return out, req.Send()
}

// CreateRoleMembershipWithContext is the same as CreateRoleMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoleMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateRoleMembershipWithContext(ctx aws.Context, input *CreateRoleMembershipInput, opts ...request.Option) (*CreateRoleMembershipOutput, error) {
	req, out := c.CreateRoleMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplate = "CreateTemplate"

// CreateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplate for more information on using the CreateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateRequest method.
//	req, resp := client.CreateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate
func (c *QuickSight) CreateTemplateRequest(input *CreateTemplateInput) (req *request.Request, output *CreateTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &CreateTemplateInput{}
	}

	output = &CreateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplate API operation for Amazon QuickSight.
//
// Creates a template either from a TemplateDefinition or from an existing Amazon
// QuickSight analysis or template. You can use the resulting template to create
// additional dashboards, templates, or analyses.
//
// A template is an entity in Amazon QuickSight that encapsulates the metadata
// required to create an analysis and that you can use to create s dashboard.
// A template adds a layer of abstraction by using placeholders to replace the
// dataset associated with the analysis. You can use templates to create dashboards
// by replacing dataset placeholders with datasets that follow the same schema
// that was used to create the source analysis and template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate
func (c *QuickSight) CreateTemplate(input *CreateTemplateInput) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	return out, req.Send()
}

// CreateTemplateWithContext is the same as CreateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTemplateWithContext(ctx aws.Context, input *CreateTemplateInput, opts ...request.Option) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplateAlias = "CreateTemplateAlias"

// CreateTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplateAlias for more information on using the CreateTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateAliasRequest method.
//	req, resp := client.CreateTemplateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias
func (c *QuickSight) CreateTemplateAliasRequest(input *CreateTemplateAliasInput) (req *request.Request, output *CreateTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateTemplateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &CreateTemplateAliasInput{}
	}

	output = &CreateTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplateAlias API operation for Amazon QuickSight.
//
// Creates a template alias for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTemplateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias
func (c *QuickSight) CreateTemplateAlias(input *CreateTemplateAliasInput) (*CreateTemplateAliasOutput, error) {
	req, out := c.CreateTemplateAliasRequest(input)
	return out, req.Send()
}

// CreateTemplateAliasWithContext is the same as CreateTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTemplateAliasWithContext(ctx aws.Context, input *CreateTemplateAliasInput, opts ...request.Option) (*CreateTemplateAliasOutput, error) {
	req, out := c.CreateTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTheme = "CreateTheme"

// CreateThemeRequest generates a "aws/request.Request" representing the
// client's request for the CreateTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTheme for more information on using the CreateTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateThemeRequest method.
//	req, resp := client.CreateThemeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme
func (c *QuickSight) CreateThemeRequest(input *CreateThemeInput) (req *request.Request, output *CreateThemeOutput) {
	op := &request.Operation{
		Name:       opCreateTheme,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &CreateThemeInput{}
	}

	output = &CreateThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTheme API operation for Amazon QuickSight.
//
// Creates a theme.
//
// A theme is set of configuration options for color and layout. Themes apply
// to analyses and dashboards. For more information, see Using Themes in Amazon
// QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html)
// in the Amazon QuickSight User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTheme for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme
func (c *QuickSight) CreateTheme(input *CreateThemeInput) (*CreateThemeOutput, error) {
	req, out := c.CreateThemeRequest(input)
	return out, req.Send()
}

// CreateThemeWithContext is the same as CreateTheme with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateThemeWithContext(ctx aws.Context, input *CreateThemeInput, opts ...request.Option) (*CreateThemeOutput, error) {
	req, out := c.CreateThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThemeAlias = "CreateThemeAlias"

// CreateThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThemeAlias for more information on using the CreateThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateThemeAliasRequest method.
//	req, resp := client.CreateThemeAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias
func (c *QuickSight) CreateThemeAliasRequest(input *CreateThemeAliasInput) (req *request.Request, output *CreateThemeAliasOutput) {
	op := &request.Operation{
		Name:       opCreateThemeAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &CreateThemeAliasInput{}
	}

	output = &CreateThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThemeAlias API operation for Amazon QuickSight.
//
// Creates a theme alias for a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateThemeAlias for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias
func (c *QuickSight) CreateThemeAlias(input *CreateThemeAliasInput) (*CreateThemeAliasOutput, error) {
	req, out := c.CreateThemeAliasRequest(input)
	return out, req.Send()
}

// CreateThemeAliasWithContext is the same as CreateThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateThemeAliasWithContext(ctx aws.Context, input *CreateThemeAliasInput, opts ...request.Option) (*CreateThemeAliasOutput, error) {
	req, out := c.CreateThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTopic = "CreateTopic"

// CreateTopicRequest generates a "aws/request.Request" representing the
// client's request for the CreateTopic operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTopic for more information on using the CreateTopic
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTopicRequest method.
//	req, resp := client.CreateTopicRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTopic
func (c *QuickSight) CreateTopicRequest(input *CreateTopicInput) (req *request.Request, output *CreateTopicOutput) {
	op := &request.Operation{
		Name:       opCreateTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/topics",
	}

	if input == nil {
		input = &CreateTopicInput{}
	}

	output = &CreateTopicOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTopic API operation for Amazon QuickSight.
//
// Creates a new Q topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTopic for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTopic
func (c *QuickSight) CreateTopic(input *CreateTopicInput) (*CreateTopicOutput, error) {
	req, out := c.CreateTopicRequest(input)
	return out, req.Send()
}

// CreateTopicWithContext is the same as CreateTopic with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTopic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTopicWithContext(ctx aws.Context, input *CreateTopicInput, opts ...request.Option) (*CreateTopicOutput, error) {
	req, out := c.CreateTopicRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTopicRefreshSchedule = "CreateTopicRefreshSchedule"

// CreateTopicRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreateTopicRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTopicRefreshSchedule for more information on using the CreateTopicRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTopicRefreshScheduleRequest method.
//	req, resp := client.CreateTopicRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTopicRefreshSchedule
func (c *QuickSight) CreateTopicRefreshScheduleRequest(input *CreateTopicRefreshScheduleInput) (req *request.Request, output *CreateTopicRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opCreateTopicRefreshSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}/schedules",
	}

	if input == nil {
		input = &CreateTopicRefreshScheduleInput{}
	}

	output = &CreateTopicRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTopicRefreshSchedule API operation for Amazon QuickSight.
//
// Creates a topic refresh schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTopicRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTopicRefreshSchedule
func (c *QuickSight) CreateTopicRefreshSchedule(input *CreateTopicRefreshScheduleInput) (*CreateTopicRefreshScheduleOutput, error) {
	req, out := c.CreateTopicRefreshScheduleRequest(input)
	return out, req.Send()
}

// CreateTopicRefreshScheduleWithContext is the same as CreateTopicRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTopicRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTopicRefreshScheduleWithContext(ctx aws.Context, input *CreateTopicRefreshScheduleInput, opts ...request.Option) (*CreateTopicRefreshScheduleOutput, error) {
	req, out := c.CreateTopicRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVPCConnection = "CreateVPCConnection"

// CreateVPCConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVPCConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVPCConnection for more information on using the CreateVPCConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVPCConnectionRequest method.
//	req, resp := client.CreateVPCConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateVPCConnection
func (c *QuickSight) CreateVPCConnectionRequest(input *CreateVPCConnectionInput) (req *request.Request, output *CreateVPCConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVPCConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/vpc-connections",
	}

	if input == nil {
		input = &CreateVPCConnectionInput{}
	}

	output = &CreateVPCConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVPCConnection API operation for Amazon QuickSight.
//
// Creates a new VPC connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateVPCConnection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateVPCConnection
func (c *QuickSight) CreateVPCConnection(input *CreateVPCConnectionInput) (*CreateVPCConnectionOutput, error) {
	req, out := c.CreateVPCConnectionRequest(input)
	return out, req.Send()
}

// CreateVPCConnectionWithContext is the same as CreateVPCConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVPCConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateVPCConnectionWithContext(ctx aws.Context, input *CreateVPCConnectionInput, opts ...request.Option) (*CreateVPCConnectionOutput, error) {
	req, out := c.CreateVPCConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountCustomization = "DeleteAccountCustomization"

// DeleteAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountCustomization for more information on using the DeleteAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccountCustomizationRequest method.
//	req, resp := client.DeleteAccountCustomizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization
func (c *QuickSight) DeleteAccountCustomizationRequest(input *DeleteAccountCustomizationInput) (req *request.Request, output *DeleteAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountCustomization,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &DeleteAccountCustomizationInput{}
	}

	output = &DeleteAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccountCustomization API operation for Amazon QuickSight.
//
// Deletes all Amazon QuickSight customizations in this Amazon Web Services
// Region for the specified Amazon Web Services account and Amazon QuickSight
// namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteAccountCustomization for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization
func (c *QuickSight) DeleteAccountCustomization(input *DeleteAccountCustomizationInput) (*DeleteAccountCustomizationOutput, error) {
	req, out := c.DeleteAccountCustomizationRequest(input)
	return out, req.Send()
}

// DeleteAccountCustomizationWithContext is the same as DeleteAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteAccountCustomizationWithContext(ctx aws.Context, input *DeleteAccountCustomizationInput, opts ...request.Option) (*DeleteAccountCustomizationOutput, error) {
	req, out := c.DeleteAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountSubscription = "DeleteAccountSubscription"

// DeleteAccountSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountSubscription for more information on using the DeleteAccountSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccountSubscriptionRequest method.
//	req, resp := client.DeleteAccountSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountSubscription
func (c *QuickSight) DeleteAccountSubscriptionRequest(input *DeleteAccountSubscriptionInput) (req *request.Request, output *DeleteAccountSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountSubscription,
		HTTPMethod: "DELETE",
		HTTPPath:   "/account/{AwsAccountId}",
	}

	if input == nil {
		input = &DeleteAccountSubscriptionInput{}
	}

	output = &DeleteAccountSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccountSubscription API operation for Amazon QuickSight.
//
// Use the DeleteAccountSubscription operation to delete an Amazon QuickSight
// account. This operation will result in an error message if you have configured
// your account termination protection settings to True. To change this setting
// and delete your account, call the UpdateAccountSettings API and set the value
// of the TerminationProtectionEnabled parameter to False, then make another
// call to the DeleteAccountSubscription API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteAccountSubscription for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountSubscription
func (c *QuickSight) DeleteAccountSubscription(input *DeleteAccountSubscriptionInput) (*DeleteAccountSubscriptionOutput, error) {
	req, out := c.DeleteAccountSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteAccountSubscriptionWithContext is the same as DeleteAccountSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteAccountSubscriptionWithContext(ctx aws.Context, input *DeleteAccountSubscriptionInput, opts ...request.Option) (*DeleteAccountSubscriptionOutput, error) {
	req, out := c.DeleteAccountSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnalysis = "DeleteAnalysis"

// DeleteAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnalysis for more information on using the DeleteAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAnalysisRequest method.
//	req, resp := client.DeleteAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis
func (c *QuickSight) DeleteAnalysisRequest(input *DeleteAnalysisInput) (req *request.Request, output *DeleteAnalysisOutput) {
	op := &request.Operation{
		Name:       opDeleteAnalysis,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &DeleteAnalysisInput{}
	}

	output = &DeleteAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAnalysis API operation for Amazon QuickSight.
//
// Deletes an analysis from Amazon QuickSight. You can optionally include a
// recovery window during which you can restore the analysis. If you don't specify
// a recovery window value, the operation defaults to 30 days. Amazon QuickSight
// attaches a DeletionTime stamp to the response that specifies the end of the
// recovery window. At the end of the recovery window, Amazon QuickSight deletes
// the analysis permanently.
//
// At any time before recovery window ends, you can use the RestoreAnalysis
// API operation to remove the DeletionTime stamp and cancel the deletion of
// the analysis. The analysis remains visible in the API until it's deleted,
// so you can describe it but you can't make a template from it.
//
// An analysis that's scheduled for deletion isn't accessible in the Amazon
// QuickSight console. To access it in the console, restore it. Deleting an
// analysis doesn't delete the dashboards that you publish from it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis
func (c *QuickSight) DeleteAnalysis(input *DeleteAnalysisInput) (*DeleteAnalysisOutput, error) {
	req, out := c.DeleteAnalysisRequest(input)
	return out, req.Send()
}

// DeleteAnalysisWithContext is the same as DeleteAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteAnalysisWithContext(ctx aws.Context, input *DeleteAnalysisInput, opts ...request.Option) (*DeleteAnalysisOutput, error) {
	req, out := c.DeleteAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDashboard = "DeleteDashboard"

// DeleteDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDashboard for more information on using the DeleteDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDashboardRequest method.
//	req, resp := client.DeleteDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard
func (c *QuickSight) DeleteDashboardRequest(input *DeleteDashboardInput) (req *request.Request, output *DeleteDashboardOutput) {
	op := &request.Operation{
		Name:       opDeleteDashboard,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &DeleteDashboardInput{}
	}

	output = &DeleteDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDashboard API operation for Amazon QuickSight.
//
// Deletes a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDashboard for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard
func (c *QuickSight) DeleteDashboard(input *DeleteDashboardInput) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	return out, req.Send()
}

// DeleteDashboardWithContext is the same as DeleteDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDashboardWithContext(ctx aws.Context, input *DeleteDashboardInput, opts ...request.Option) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSet = "DeleteDataSet"

// DeleteDataSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSet for more information on using the DeleteDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSetRequest method.
//	req, resp := client.DeleteDataSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet
func (c *QuickSight) DeleteDataSetRequest(input *DeleteDataSetInput) (req *request.Request, output *DeleteDataSetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DeleteDataSetInput{}
	}

	output = &DeleteDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSet API operation for Amazon QuickSight.
//
// Deletes a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet
func (c *QuickSight) DeleteDataSet(input *DeleteDataSetInput) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	return out, req.Send()
}

// DeleteDataSetWithContext is the same as DeleteDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSetWithContext(ctx aws.Context, input *DeleteDataSetInput, opts ...request.Option) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSetRefreshProperties = "DeleteDataSetRefreshProperties"

// DeleteDataSetRefreshPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSetRefreshProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSetRefreshProperties for more information on using the DeleteDataSetRefreshProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSetRefreshPropertiesRequest method.
//	req, resp := client.DeleteDataSetRefreshPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSetRefreshProperties
func (c *QuickSight) DeleteDataSetRefreshPropertiesRequest(input *DeleteDataSetRefreshPropertiesInput) (req *request.Request, output *DeleteDataSetRefreshPropertiesOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSetRefreshProperties,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-properties",
	}

	if input == nil {
		input = &DeleteDataSetRefreshPropertiesInput{}
	}

	output = &DeleteDataSetRefreshPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSetRefreshProperties API operation for Amazon QuickSight.
//
// Deletes the dataset refresh properties of the dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSetRefreshProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSetRefreshProperties
func (c *QuickSight) DeleteDataSetRefreshProperties(input *DeleteDataSetRefreshPropertiesInput) (*DeleteDataSetRefreshPropertiesOutput, error) {
	req, out := c.DeleteDataSetRefreshPropertiesRequest(input)
	return out, req.Send()
}

// DeleteDataSetRefreshPropertiesWithContext is the same as DeleteDataSetRefreshProperties with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSetRefreshProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSetRefreshPropertiesWithContext(ctx aws.Context, input *DeleteDataSetRefreshPropertiesInput, opts ...request.Option) (*DeleteDataSetRefreshPropertiesOutput, error) {
	req, out := c.DeleteDataSetRefreshPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSourceRequest method.
//	req, resp := client.DeleteDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource
func (c *QuickSight) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSource API operation for Amazon QuickSight.
//
// Deletes the data source permanently. This operation breaks all the datasets
// that reference the deleted data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource
func (c *QuickSight) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFolder = "DeleteFolder"

// DeleteFolderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFolder for more information on using the DeleteFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFolderRequest method.
//	req, resp := client.DeleteFolderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder
func (c *QuickSight) DeleteFolderRequest(input *DeleteFolderInput) (req *request.Request, output *DeleteFolderOutput) {
	op := &request.Operation{
		Name:       opDeleteFolder,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &DeleteFolderInput{}
	}

	output = &DeleteFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFolder API operation for Amazon QuickSight.
//
// Deletes an empty folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteFolder for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder
func (c *QuickSight) DeleteFolder(input *DeleteFolderInput) (*DeleteFolderOutput, error) {
	req, out := c.DeleteFolderRequest(input)
	return out, req.Send()
}

// DeleteFolderWithContext is the same as DeleteFolder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteFolderWithContext(ctx aws.Context, input *DeleteFolderInput, opts ...request.Option) (*DeleteFolderOutput, error) {
	req, out := c.DeleteFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFolderMembership = "DeleteFolderMembership"

// DeleteFolderMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFolderMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFolderMembership for more information on using the DeleteFolderMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFolderMembershipRequest method.
//	req, resp := client.DeleteFolderMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership
func (c *QuickSight) DeleteFolderMembershipRequest(input *DeleteFolderMembershipInput) (req *request.Request, output *DeleteFolderMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteFolderMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
	}

	if input == nil {
		input = &DeleteFolderMembershipInput{}
	}

	output = &DeleteFolderMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFolderMembership API operation for Amazon QuickSight.
//
// Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteFolderMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership
func (c *QuickSight) DeleteFolderMembership(input *DeleteFolderMembershipInput) (*DeleteFolderMembershipOutput, error) {
	req, out := c.DeleteFolderMembershipRequest(input)
	return out, req.Send()
}

// DeleteFolderMembershipWithContext is the same as DeleteFolderMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFolderMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteFolderMembershipWithContext(ctx aws.Context, input *DeleteFolderMembershipInput, opts ...request.Option) (*DeleteFolderMembershipOutput, error) {
	req, out := c.DeleteFolderMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGroupRequest method.
//	req, resp := client.DeleteGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroup API operation for Amazon QuickSight.
//
// Removes a user group from Amazon QuickSight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroupMembership = "DeleteGroupMembership"

// DeleteGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroupMembership for more information on using the DeleteGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGroupMembershipRequest method.
//	req, resp := client.DeleteGroupMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembershipRequest(input *DeleteGroupMembershipInput) (req *request.Request, output *DeleteGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteGroupMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &DeleteGroupMembershipInput{}
	}

	output = &DeleteGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroupMembership API operation for Amazon QuickSight.
//
// Removes a user from a group so that the user is no longer a member of the
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroupMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembership(input *DeleteGroupMembershipInput) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	return out, req.Send()
}

// DeleteGroupMembershipWithContext is the same as DeleteGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupMembershipWithContext(ctx aws.Context, input *DeleteGroupMembershipInput, opts ...request.Option) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIAMPolicyAssignment = "DeleteIAMPolicyAssignment"

// DeleteIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIAMPolicyAssignment for more information on using the DeleteIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIAMPolicyAssignmentRequest method.
//	req, resp := client.DeleteIAMPolicyAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment
func (c *QuickSight) DeleteIAMPolicyAssignmentRequest(input *DeleteIAMPolicyAssignmentInput) (req *request.Request, output *DeleteIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opDeleteIAMPolicyAssignment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespace/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &DeleteIAMPolicyAssignmentInput{}
	}

	output = &DeleteIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Deletes an existing IAM policy assignment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConcurrentUpdatingException
//     A resource is already in a state that indicates an operation is happening
//     that must complete before a new update can be applied.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment
func (c *QuickSight) DeleteIAMPolicyAssignment(input *DeleteIAMPolicyAssignmentInput) (*DeleteIAMPolicyAssignmentOutput, error) {
	req, out := c.DeleteIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// DeleteIAMPolicyAssignmentWithContext is the same as DeleteIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteIAMPolicyAssignmentWithContext(ctx aws.Context, input *DeleteIAMPolicyAssignmentInput, opts ...request.Option) (*DeleteIAMPolicyAssignmentOutput, error) {
	req, out := c.DeleteIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentityPropagationConfig = "DeleteIdentityPropagationConfig"

// DeleteIdentityPropagationConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentityPropagationConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdentityPropagationConfig for more information on using the DeleteIdentityPropagationConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIdentityPropagationConfigRequest method.
//	req, resp := client.DeleteIdentityPropagationConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIdentityPropagationConfig
func (c *QuickSight) DeleteIdentityPropagationConfigRequest(input *DeleteIdentityPropagationConfigInput) (req *request.Request, output *DeleteIdentityPropagationConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentityPropagationConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/identity-propagation-config/{Service}",
	}

	if input == nil {
		input = &DeleteIdentityPropagationConfigInput{}
	}

	output = &DeleteIdentityPropagationConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIdentityPropagationConfig API operation for Amazon QuickSight.
//
// Deletes all access scopes and authorized targets that are associated with
// a service from the Amazon QuickSight IAM Identity Center application.
//
// This operation is only supported for Amazon QuickSight accounts that use
// IAM Identity Center.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteIdentityPropagationConfig for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIdentityPropagationConfig
func (c *QuickSight) DeleteIdentityPropagationConfig(input *DeleteIdentityPropagationConfigInput) (*DeleteIdentityPropagationConfigOutput, error) {
	req, out := c.DeleteIdentityPropagationConfigRequest(input)
	return out, req.Send()
}

// DeleteIdentityPropagationConfigWithContext is the same as DeleteIdentityPropagationConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentityPropagationConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteIdentityPropagationConfigWithContext(ctx aws.Context, input *DeleteIdentityPropagationConfigInput, opts ...request.Option) (*DeleteIdentityPropagationConfigOutput, error) {
	req, out := c.DeleteIdentityPropagationConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamespace = "DeleteNamespace"

// DeleteNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamespace for more information on using the DeleteNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNamespaceRequest method.
//	req, resp := client.DeleteNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace
func (c *QuickSight) DeleteNamespaceRequest(input *DeleteNamespaceInput) (req *request.Request, output *DeleteNamespaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNamespace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}",
	}

	if input == nil {
		input = &DeleteNamespaceInput{}
	}

	output = &DeleteNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNamespace API operation for Amazon QuickSight.
//
// Deletes a namespace and the users and groups that are associated with the
// namespace. This is an asynchronous process. Assets including dashboards,
// analyses, datasets and data sources are not deleted. To delete these assets,
// you use the API operations for the relevant asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteNamespace for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace
func (c *QuickSight) DeleteNamespace(input *DeleteNamespaceInput) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	return out, req.Send()
}

// DeleteNamespaceWithContext is the same as DeleteNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteNamespaceWithContext(ctx aws.Context, input *DeleteNamespaceInput, opts ...request.Option) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRefreshSchedule = "DeleteRefreshSchedule"

// DeleteRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRefreshSchedule for more information on using the DeleteRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRefreshScheduleRequest method.
//	req, resp := client.DeleteRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRefreshSchedule
func (c *QuickSight) DeleteRefreshScheduleRequest(input *DeleteRefreshScheduleInput) (req *request.Request, output *DeleteRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteRefreshSchedule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules/{ScheduleId}",
	}

	if input == nil {
		input = &DeleteRefreshScheduleInput{}
	}

	output = &DeleteRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRefreshSchedule API operation for Amazon QuickSight.
//
// Deletes a refresh schedule from a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRefreshSchedule
func (c *QuickSight) DeleteRefreshSchedule(input *DeleteRefreshScheduleInput) (*DeleteRefreshScheduleOutput, error) {
	req, out := c.DeleteRefreshScheduleRequest(input)
	return out, req.Send()
}

// DeleteRefreshScheduleWithContext is the same as DeleteRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteRefreshScheduleWithContext(ctx aws.Context, input *DeleteRefreshScheduleInput, opts ...request.Option) (*DeleteRefreshScheduleOutput, error) {
	req, out := c.DeleteRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoleCustomPermission = "DeleteRoleCustomPermission"

// DeleteRoleCustomPermissionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoleCustomPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoleCustomPermission for more information on using the DeleteRoleCustomPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRoleCustomPermissionRequest method.
//	req, resp := client.DeleteRoleCustomPermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRoleCustomPermission
func (c *QuickSight) DeleteRoleCustomPermissionRequest(input *DeleteRoleCustomPermissionInput) (req *request.Request, output *DeleteRoleCustomPermissionOutput) {
	op := &request.Operation{
		Name:       opDeleteRoleCustomPermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/custom-permission",
	}

	if input == nil {
		input = &DeleteRoleCustomPermissionInput{}
	}

	output = &DeleteRoleCustomPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRoleCustomPermission API operation for Amazon QuickSight.
//
// Removes custom permissions from the role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteRoleCustomPermission for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRoleCustomPermission
func (c *QuickSight) DeleteRoleCustomPermission(input *DeleteRoleCustomPermissionInput) (*DeleteRoleCustomPermissionOutput, error) {
	req, out := c.DeleteRoleCustomPermissionRequest(input)
	return out, req.Send()
}

// DeleteRoleCustomPermissionWithContext is the same as DeleteRoleCustomPermission with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoleCustomPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteRoleCustomPermissionWithContext(ctx aws.Context, input *DeleteRoleCustomPermissionInput, opts ...request.Option) (*DeleteRoleCustomPermissionOutput, error) {
	req, out := c.DeleteRoleCustomPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoleMembership = "DeleteRoleMembership"

// DeleteRoleMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoleMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoleMembership for more information on using the DeleteRoleMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRoleMembershipRequest method.
//	req, resp := client.DeleteRoleMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRoleMembership
func (c *QuickSight) DeleteRoleMembershipRequest(input *DeleteRoleMembershipInput) (req *request.Request, output *DeleteRoleMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteRoleMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/members/{MemberName}",
	}

	if input == nil {
		input = &DeleteRoleMembershipInput{}
	}

	output = &DeleteRoleMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRoleMembership API operation for Amazon QuickSight.
//
// Removes a group from a role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteRoleMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRoleMembership
func (c *QuickSight) DeleteRoleMembership(input *DeleteRoleMembershipInput) (*DeleteRoleMembershipOutput, error) {
	req, out := c.DeleteRoleMembershipRequest(input)
	return out, req.Send()
}

// DeleteRoleMembershipWithContext is the same as DeleteRoleMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoleMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteRoleMembershipWithContext(ctx aws.Context, input *DeleteRoleMembershipInput, opts ...request.Option) (*DeleteRoleMembershipOutput, error) {
	req, out := c.DeleteRoleMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplate = "DeleteTemplate"

// DeleteTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplate for more information on using the DeleteTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateRequest method.
//	req, resp := client.DeleteTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate
func (c *QuickSight) DeleteTemplateRequest(input *DeleteTemplateInput) (req *request.Request, output *DeleteTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DeleteTemplateInput{}
	}

	output = &DeleteTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTemplate API operation for Amazon QuickSight.
//
// Deletes a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate
func (c *QuickSight) DeleteTemplate(input *DeleteTemplateInput) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	return out, req.Send()
}

// DeleteTemplateWithContext is the same as DeleteTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTemplateWithContext(ctx aws.Context, input *DeleteTemplateInput, opts ...request.Option) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplateAlias = "DeleteTemplateAlias"

// DeleteTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplateAlias for more information on using the DeleteTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateAliasRequest method.
//	req, resp := client.DeleteTemplateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias
func (c *QuickSight) DeleteTemplateAliasRequest(input *DeleteTemplateAliasInput) (req *request.Request, output *DeleteTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplateAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DeleteTemplateAliasInput{}
	}

	output = &DeleteTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTemplateAlias API operation for Amazon QuickSight.
//
// Deletes the item that the specified template alias points to. If you provide
// a specific alias, you delete the version of the template that the alias points
// to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTemplateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias
func (c *QuickSight) DeleteTemplateAlias(input *DeleteTemplateAliasInput) (*DeleteTemplateAliasOutput, error) {
	req, out := c.DeleteTemplateAliasRequest(input)
	return out, req.Send()
}

// DeleteTemplateAliasWithContext is the same as DeleteTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTemplateAliasWithContext(ctx aws.Context, input *DeleteTemplateAliasInput, opts ...request.Option) (*DeleteTemplateAliasOutput, error) {
	req, out := c.DeleteTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTheme = "DeleteTheme"

// DeleteThemeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTheme for more information on using the DeleteTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteThemeRequest method.
//	req, resp := client.DeleteThemeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme
func (c *QuickSight) DeleteThemeRequest(input *DeleteThemeInput) (req *request.Request, output *DeleteThemeOutput) {
	op := &request.Operation{
		Name:       opDeleteTheme,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &DeleteThemeInput{}
	}

	output = &DeleteThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTheme API operation for Amazon QuickSight.
//
// Deletes a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTheme for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme
func (c *QuickSight) DeleteTheme(input *DeleteThemeInput) (*DeleteThemeOutput, error) {
	req, out := c.DeleteThemeRequest(input)
	return out, req.Send()
}

// DeleteThemeWithContext is the same as DeleteTheme with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteThemeWithContext(ctx aws.Context, input *DeleteThemeInput, opts ...request.Option) (*DeleteThemeOutput, error) {
	req, out := c.DeleteThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThemeAlias = "DeleteThemeAlias"

// DeleteThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThemeAlias for more information on using the DeleteThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteThemeAliasRequest method.
//	req, resp := client.DeleteThemeAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias
func (c *QuickSight) DeleteThemeAliasRequest(input *DeleteThemeAliasInput) (req *request.Request, output *DeleteThemeAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteThemeAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DeleteThemeAliasInput{}
	}

	output = &DeleteThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteThemeAlias API operation for Amazon QuickSight.
//
// Deletes the version of the theme that the specified theme alias points to.
// If you provide a specific alias, you delete the version of the theme that
// the alias points to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteThemeAlias for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias
func (c *QuickSight) DeleteThemeAlias(input *DeleteThemeAliasInput) (*DeleteThemeAliasOutput, error) {
	req, out := c.DeleteThemeAliasRequest(input)
	return out, req.Send()
}

// DeleteThemeAliasWithContext is the same as DeleteThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteThemeAliasWithContext(ctx aws.Context, input *DeleteThemeAliasInput, opts ...request.Option) (*DeleteThemeAliasOutput, error) {
	req, out := c.DeleteThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTopic = "DeleteTopic"

// DeleteTopicRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTopic operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTopic for more information on using the DeleteTopic
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTopicRequest method.
//	req, resp := client.DeleteTopicRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTopic
func (c *QuickSight) DeleteTopicRequest(input *DeleteTopicInput) (req *request.Request, output *DeleteTopicOutput) {
	op := &request.Operation{
		Name:       opDeleteTopic,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}",
	}

	if input == nil {
		input = &DeleteTopicInput{}
	}

	output = &DeleteTopicOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTopic API operation for Amazon QuickSight.
//
// Deletes a topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTopic for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTopic
func (c *QuickSight) DeleteTopic(input *DeleteTopicInput) (*DeleteTopicOutput, error) {
	req, out := c.DeleteTopicRequest(input)
	return out, req.Send()
}

// DeleteTopicWithContext is the same as DeleteTopic with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTopic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTopicWithContext(ctx aws.Context, input *DeleteTopicInput, opts ...request.Option) (*DeleteTopicOutput, error) {
	req, out := c.DeleteTopicRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTopicRefreshSchedule = "DeleteTopicRefreshSchedule"

// DeleteTopicRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTopicRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTopicRefreshSchedule for more information on using the DeleteTopicRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTopicRefreshScheduleRequest method.
//	req, resp := client.DeleteTopicRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTopicRefreshSchedule
func (c *QuickSight) DeleteTopicRefreshScheduleRequest(input *DeleteTopicRefreshScheduleInput) (req *request.Request, output *DeleteTopicRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteTopicRefreshSchedule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}/schedules/{DatasetId}",
	}

	if input == nil {
		input = &DeleteTopicRefreshScheduleInput{}
	}

	output = &DeleteTopicRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTopicRefreshSchedule API operation for Amazon QuickSight.
//
// Deletes a topic refresh schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTopicRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTopicRefreshSchedule
func (c *QuickSight) DeleteTopicRefreshSchedule(input *DeleteTopicRefreshScheduleInput) (*DeleteTopicRefreshScheduleOutput, error) {
	req, out := c.DeleteTopicRefreshScheduleRequest(input)
	return out, req.Send()
}

// DeleteTopicRefreshScheduleWithContext is the same as DeleteTopicRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTopicRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTopicRefreshScheduleWithContext(ctx aws.Context, input *DeleteTopicRefreshScheduleInput, opts ...request.Option) (*DeleteTopicRefreshScheduleOutput, error) {
	req, out := c.DeleteTopicRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserRequest method.
//	req, resp := client.DeleteUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUser API operation for Amazon QuickSight.
//
// Deletes the Amazon QuickSight user that is associated with the identity of
// the IAM user or role that's making the call. The IAM user isn't deleted as
// a result of this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserByPrincipalId = "DeleteUserByPrincipalId"

// DeleteUserByPrincipalIdRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserByPrincipalId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserByPrincipalId for more information on using the DeleteUserByPrincipalId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserByPrincipalIdRequest method.
//	req, resp := client.DeleteUserByPrincipalIdRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalIdRequest(input *DeleteUserByPrincipalIdInput) (req *request.Request, output *DeleteUserByPrincipalIdOutput) {
	op := &request.Operation{
		Name:       opDeleteUserByPrincipalId,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}",
	}

	if input == nil {
		input = &DeleteUserByPrincipalIdInput{}
	}

	output = &DeleteUserByPrincipalIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserByPrincipalId API operation for Amazon QuickSight.
//
// Deletes a user identified by its principal ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUserByPrincipalId for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalId(input *DeleteUserByPrincipalIdInput) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	return out, req.Send()
}

// DeleteUserByPrincipalIdWithContext is the same as DeleteUserByPrincipalId with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserByPrincipalId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserByPrincipalIdWithContext(ctx aws.Context, input *DeleteUserByPrincipalIdInput, opts ...request.Option) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVPCConnection = "DeleteVPCConnection"

// DeleteVPCConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVPCConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVPCConnection for more information on using the DeleteVPCConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVPCConnectionRequest method.
//	req, resp := client.DeleteVPCConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteVPCConnection
func (c *QuickSight) DeleteVPCConnectionRequest(input *DeleteVPCConnectionInput) (req *request.Request, output *DeleteVPCConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVPCConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/vpc-connections/{VPCConnectionId}",
	}

	if input == nil {
		input = &DeleteVPCConnectionInput{}
	}

	output = &DeleteVPCConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVPCConnection API operation for Amazon QuickSight.
//
// Deletes a VPC connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteVPCConnection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteVPCConnection
func (c *QuickSight) DeleteVPCConnection(input *DeleteVPCConnectionInput) (*DeleteVPCConnectionOutput, error) {
	req, out := c.DeleteVPCConnectionRequest(input)
	return out, req.Send()
}

// DeleteVPCConnectionWithContext is the same as DeleteVPCConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVPCConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteVPCConnectionWithContext(ctx aws.Context, input *DeleteVPCConnectionInput, opts ...request.Option) (*DeleteVPCConnectionOutput, error) {
	req, out := c.DeleteVPCConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountCustomization = "DescribeAccountCustomization"

// DescribeAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountCustomization for more information on using the DescribeAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountCustomizationRequest method.
//	req, resp := client.DescribeAccountCustomizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization
func (c *QuickSight) DescribeAccountCustomizationRequest(input *DescribeAccountCustomizationInput) (req *request.Request, output *DescribeAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountCustomization,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &DescribeAccountCustomizationInput{}
	}

	output = &DescribeAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountCustomization API operation for Amazon QuickSight.
//
// Describes the customizations associated with the provided Amazon Web Services
// account and Amazon Amazon QuickSight namespace in an Amazon Web Services
// Region. The Amazon QuickSight console evaluates which customizations to apply
// by running this API operation with the Resolved flag included.
//
// To determine what customizations display when you run this command, it can
// help to visualize the relationship of the entities involved.
//
//   - Amazon Web Services account - The Amazon Web Services account exists
//     at the top of the hierarchy. It has the potential to use all of the Amazon
//     Web Services Regions and Amazon Web Services Services. When you subscribe
//     to Amazon QuickSight, you choose one Amazon Web Services Region to use
//     as your home Region. That's where your free SPICE capacity is located.
//     You can use Amazon QuickSight in any supported Amazon Web Services Region.
//
//   - Amazon Web Services Region - In each Amazon Web Services Region where
//     you sign in to Amazon QuickSight at least once, Amazon QuickSight acts
//     as a separate instance of the same service. If you have a user directory,
//     it resides in us-east-1, which is the US East (N. Virginia). Generally
//     speaking, these users have access to Amazon QuickSight in any Amazon Web
//     Services Region, unless they are constrained to a namespace. To run the
//     command in a different Amazon Web Services Region, you change your Region
//     settings. If you're using the CLI, you can use one of the following options:
//     Use command line options (https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html).
//     Use named profiles (https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html).
//     Run aws configure to change your default Amazon Web Services Region. Use
//     Enter to key the same settings for your keys. For more information, see
//     Configuring the CLI (https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html).
//
//   - Namespace - A QuickSight namespace is a partition that contains users
//     and assets (data sources, datasets, dashboards, and so on). To access
//     assets that are in a specific namespace, users and groups must also be
//     part of the same namespace. People who share a namespace are completely
//     isolated from users and assets in other namespaces, even if they are in
//     the same Amazon Web Services account and Amazon Web Services Region.
//
//   - Applied customizations - Within an Amazon Web Services Region, a set
//     of Amazon QuickSight customizations can apply to an Amazon Web Services
//     account or to a namespace. Settings that you apply to a namespace override
//     settings that you apply to an Amazon Web Services account. All settings
//     are isolated to a single Amazon Web Services Region. To apply them in
//     other Amazon Web Services Regions, run the CreateAccountCustomization
//     command in each Amazon Web Services Region where you want to apply the
//     same customizations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAccountCustomization for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization
func (c *QuickSight) DescribeAccountCustomization(input *DescribeAccountCustomizationInput) (*DescribeAccountCustomizationOutput, error) {
	req, out := c.DescribeAccountCustomizationRequest(input)
	return out, req.Send()
}

// DescribeAccountCustomizationWithContext is the same as DescribeAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAccountCustomizationWithContext(ctx aws.Context, input *DescribeAccountCustomizationInput, opts ...request.Option) (*DescribeAccountCustomizationOutput, error) {
	req, out := c.DescribeAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountSettings = "DescribeAccountSettings"

// DescribeAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountSettings for more information on using the DescribeAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountSettingsRequest method.
//	req, resp := client.DescribeAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings
func (c *QuickSight) DescribeAccountSettingsRequest(input *DescribeAccountSettingsInput) (req *request.Request, output *DescribeAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/settings",
	}

	if input == nil {
		input = &DescribeAccountSettingsInput{}
	}

	output = &DescribeAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountSettings API operation for Amazon QuickSight.
//
// Describes the settings that were used when your Amazon QuickSight subscription
// was first created in this Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings
func (c *QuickSight) DescribeAccountSettings(input *DescribeAccountSettingsInput) (*DescribeAccountSettingsOutput, error) {
	req, out := c.DescribeAccountSettingsRequest(input)
	return out, req.Send()
}

// DescribeAccountSettingsWithContext is the same as DescribeAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAccountSettingsWithContext(ctx aws.Context, input *DescribeAccountSettingsInput, opts ...request.Option) (*DescribeAccountSettingsOutput, error) {
	req, out := c.DescribeAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountSubscription = "DescribeAccountSubscription"

// DescribeAccountSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountSubscription for more information on using the DescribeAccountSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountSubscriptionRequest method.
//	req, resp := client.DescribeAccountSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSubscription
func (c *QuickSight) DescribeAccountSubscriptionRequest(input *DescribeAccountSubscriptionInput) (req *request.Request, output *DescribeAccountSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountSubscription,
		HTTPMethod: "GET",
		HTTPPath:   "/account/{AwsAccountId}",
	}

	if input == nil {
		input = &DescribeAccountSubscriptionInput{}
	}

	output = &DescribeAccountSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountSubscription API operation for Amazon QuickSight.
//
// Use the DescribeAccountSubscription operation to receive a description of
// an Amazon QuickSight account's subscription. A successful API call returns
// an AccountInfo object that includes an account's name, subscription status,
// authentication type, edition, and notification email address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAccountSubscription for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSubscription
func (c *QuickSight) DescribeAccountSubscription(input *DescribeAccountSubscriptionInput) (*DescribeAccountSubscriptionOutput, error) {
	req, out := c.DescribeAccountSubscriptionRequest(input)
	return out, req.Send()
}

// DescribeAccountSubscriptionWithContext is the same as DescribeAccountSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAccountSubscriptionWithContext(ctx aws.Context, input *DescribeAccountSubscriptionInput, opts ...request.Option) (*DescribeAccountSubscriptionOutput, error) {
	req, out := c.DescribeAccountSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnalysis = "DescribeAnalysis"

// DescribeAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnalysis for more information on using the DescribeAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAnalysisRequest method.
//	req, resp := client.DescribeAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis
func (c *QuickSight) DescribeAnalysisRequest(input *DescribeAnalysisInput) (req *request.Request, output *DescribeAnalysisOutput) {
	op := &request.Operation{
		Name:       opDescribeAnalysis,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &DescribeAnalysisInput{}
	}

	output = &DescribeAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnalysis API operation for Amazon QuickSight.
//
// Provides a summary of the metadata for an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis
func (c *QuickSight) DescribeAnalysis(input *DescribeAnalysisInput) (*DescribeAnalysisOutput, error) {
	req, out := c.DescribeAnalysisRequest(input)
	return out, req.Send()
}

// DescribeAnalysisWithContext is the same as DescribeAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAnalysisWithContext(ctx aws.Context, input *DescribeAnalysisInput, opts ...request.Option) (*DescribeAnalysisOutput, error) {
	req, out := c.DescribeAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnalysisDefinition = "DescribeAnalysisDefinition"

// DescribeAnalysisDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnalysisDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnalysisDefinition for more information on using the DescribeAnalysisDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAnalysisDefinitionRequest method.
//	req, resp := client.DescribeAnalysisDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisDefinition
func (c *QuickSight) DescribeAnalysisDefinitionRequest(input *DescribeAnalysisDefinitionInput) (req *request.Request, output *DescribeAnalysisDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeAnalysisDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}/definition",
	}

	if input == nil {
		input = &DescribeAnalysisDefinitionInput{}
	}

	output = &DescribeAnalysisDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnalysisDefinition API operation for Amazon QuickSight.
//
// Provides a detailed description of the definition of an analysis.
//
// If you do not need to know details about the content of an Analysis, for
// instance if you are trying to check the status of a recently created or updated
// Analysis, use the DescribeAnalysis (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html)
// instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAnalysisDefinition for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisDefinition
func (c *QuickSight) DescribeAnalysisDefinition(input *DescribeAnalysisDefinitionInput) (*DescribeAnalysisDefinitionOutput, error) {
	req, out := c.DescribeAnalysisDefinitionRequest(input)
	return out, req.Send()
}

// DescribeAnalysisDefinitionWithContext is the same as DescribeAnalysisDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnalysisDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAnalysisDefinitionWithContext(ctx aws.Context, input *DescribeAnalysisDefinitionInput, opts ...request.Option) (*DescribeAnalysisDefinitionOutput, error) {
	req, out := c.DescribeAnalysisDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnalysisPermissions = "DescribeAnalysisPermissions"

// DescribeAnalysisPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnalysisPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnalysisPermissions for more information on using the DescribeAnalysisPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAnalysisPermissionsRequest method.
//	req, resp := client.DescribeAnalysisPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions
func (c *QuickSight) DescribeAnalysisPermissionsRequest(input *DescribeAnalysisPermissionsInput) (req *request.Request, output *DescribeAnalysisPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAnalysisPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
	}

	if input == nil {
		input = &DescribeAnalysisPermissionsInput{}
	}

	output = &DescribeAnalysisPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnalysisPermissions API operation for Amazon QuickSight.
//
// Provides the read and write permissions for an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAnalysisPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions
func (c *QuickSight) DescribeAnalysisPermissions(input *DescribeAnalysisPermissionsInput) (*DescribeAnalysisPermissionsOutput, error) {
	req, out := c.DescribeAnalysisPermissionsRequest(input)
	return out, req.Send()
}

// DescribeAnalysisPermissionsWithContext is the same as DescribeAnalysisPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnalysisPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAnalysisPermissionsWithContext(ctx aws.Context, input *DescribeAnalysisPermissionsInput, opts ...request.Option) (*DescribeAnalysisPermissionsOutput, error) {
	req, out := c.DescribeAnalysisPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssetBundleExportJob = "DescribeAssetBundleExportJob"

// DescribeAssetBundleExportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssetBundleExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssetBundleExportJob for more information on using the DescribeAssetBundleExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAssetBundleExportJobRequest method.
//	req, resp := client.DescribeAssetBundleExportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAssetBundleExportJob
func (c *QuickSight) DescribeAssetBundleExportJobRequest(input *DescribeAssetBundleExportJobInput) (req *request.Request, output *DescribeAssetBundleExportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeAssetBundleExportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/asset-bundle-export-jobs/{AssetBundleExportJobId}",
	}

	if input == nil {
		input = &DescribeAssetBundleExportJobInput{}
	}

	output = &DescribeAssetBundleExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssetBundleExportJob API operation for Amazon QuickSight.
//
// Describes an existing export job.
//
// Poll job descriptions after a job starts to know the status of the job. When
// a job succeeds, a URL is provided to download the exported assets' data from.
// Download URLs are valid for five minutes after they are generated. You can
// call the DescribeAssetBundleExportJob API for a new download URL as needed.
//
// Job descriptions are available for 14 days after the job starts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAssetBundleExportJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAssetBundleExportJob
func (c *QuickSight) DescribeAssetBundleExportJob(input *DescribeAssetBundleExportJobInput) (*DescribeAssetBundleExportJobOutput, error) {
	req, out := c.DescribeAssetBundleExportJobRequest(input)
	return out, req.Send()
}

// DescribeAssetBundleExportJobWithContext is the same as DescribeAssetBundleExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssetBundleExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAssetBundleExportJobWithContext(ctx aws.Context, input *DescribeAssetBundleExportJobInput, opts ...request.Option) (*DescribeAssetBundleExportJobOutput, error) {
	req, out := c.DescribeAssetBundleExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssetBundleImportJob = "DescribeAssetBundleImportJob"

// DescribeAssetBundleImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssetBundleImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssetBundleImportJob for more information on using the DescribeAssetBundleImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAssetBundleImportJobRequest method.
//	req, resp := client.DescribeAssetBundleImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAssetBundleImportJob
func (c *QuickSight) DescribeAssetBundleImportJobRequest(input *DescribeAssetBundleImportJobInput) (req *request.Request, output *DescribeAssetBundleImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeAssetBundleImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/asset-bundle-import-jobs/{AssetBundleImportJobId}",
	}

	if input == nil {
		input = &DescribeAssetBundleImportJobInput{}
	}

	output = &DescribeAssetBundleImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssetBundleImportJob API operation for Amazon QuickSight.
//
// Describes an existing import job.
//
// Poll job descriptions after starting a job to know when it has succeeded
// or failed. Job descriptions are available for 14 days after job starts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAssetBundleImportJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAssetBundleImportJob
func (c *QuickSight) DescribeAssetBundleImportJob(input *DescribeAssetBundleImportJobInput) (*DescribeAssetBundleImportJobOutput, error) {
	req, out := c.DescribeAssetBundleImportJobRequest(input)
	return out, req.Send()
}

// DescribeAssetBundleImportJobWithContext is the same as DescribeAssetBundleImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssetBundleImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAssetBundleImportJobWithContext(ctx aws.Context, input *DescribeAssetBundleImportJobInput, opts ...request.Option) (*DescribeAssetBundleImportJobOutput, error) {
	req, out := c.DescribeAssetBundleImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboard = "DescribeDashboard"

// DescribeDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboard for more information on using the DescribeDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDashboardRequest method.
//	req, resp := client.DescribeDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard
func (c *QuickSight) DescribeDashboardRequest(input *DescribeDashboardInput) (req *request.Request, output *DescribeDashboardOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboard,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &DescribeDashboardInput{}
	}

	output = &DescribeDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboard API operation for Amazon QuickSight.
//
// Provides a summary for a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboard for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard
func (c *QuickSight) DescribeDashboard(input *DescribeDashboardInput) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	return out, req.Send()
}

// DescribeDashboardWithContext is the same as DescribeDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardWithContext(ctx aws.Context, input *DescribeDashboardInput, opts ...request.Option) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboardDefinition = "DescribeDashboardDefinition"

// DescribeDashboardDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboardDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboardDefinition for more information on using the DescribeDashboardDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDashboardDefinitionRequest method.
//	req, resp := client.DescribeDashboardDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardDefinition
func (c *QuickSight) DescribeDashboardDefinitionRequest(input *DescribeDashboardDefinitionInput) (req *request.Request, output *DescribeDashboardDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboardDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/definition",
	}

	if input == nil {
		input = &DescribeDashboardDefinitionInput{}
	}

	output = &DescribeDashboardDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboardDefinition API operation for Amazon QuickSight.
//
// Provides a detailed description of the definition of a dashboard.
//
// If you do not need to know details about the content of a dashboard, for
// instance if you are trying to check the status of a recently created or updated
// dashboard, use the DescribeDashboard (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html)
// instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboardDefinition for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardDefinition
func (c *QuickSight) DescribeDashboardDefinition(input *DescribeDashboardDefinitionInput) (*DescribeDashboardDefinitionOutput, error) {
	req, out := c.DescribeDashboardDefinitionRequest(input)
	return out, req.Send()
}

// DescribeDashboardDefinitionWithContext is the same as DescribeDashboardDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboardDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardDefinitionWithContext(ctx aws.Context, input *DescribeDashboardDefinitionInput, opts ...request.Option) (*DescribeDashboardDefinitionOutput, error) {
	req, out := c.DescribeDashboardDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboardPermissions = "DescribeDashboardPermissions"

// DescribeDashboardPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboardPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboardPermissions for more information on using the DescribeDashboardPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDashboardPermissionsRequest method.
//	req, resp := client.DescribeDashboardPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions
func (c *QuickSight) DescribeDashboardPermissionsRequest(input *DescribeDashboardPermissionsInput) (req *request.Request, output *DescribeDashboardPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboardPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
	}

	if input == nil {
		input = &DescribeDashboardPermissionsInput{}
	}

	output = &DescribeDashboardPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboardPermissions API operation for Amazon QuickSight.
//
// Describes read and write permissions for a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboardPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions
func (c *QuickSight) DescribeDashboardPermissions(input *DescribeDashboardPermissionsInput) (*DescribeDashboardPermissionsOutput, error) {
	req, out := c.DescribeDashboardPermissionsRequest(input)
	return out, req.Send()
}

// DescribeDashboardPermissionsWithContext is the same as DescribeDashboardPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboardPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardPermissionsWithContext(ctx aws.Context, input *DescribeDashboardPermissionsInput, opts ...request.Option) (*DescribeDashboardPermissionsOutput, error) {
	req, out := c.DescribeDashboardPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboardSnapshotJob = "DescribeDashboardSnapshotJob"

// DescribeDashboardSnapshotJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboardSnapshotJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboardSnapshotJob for more information on using the DescribeDashboardSnapshotJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDashboardSnapshotJobRequest method.
//	req, resp := client.DescribeDashboardSnapshotJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardSnapshotJob
func (c *QuickSight) DescribeDashboardSnapshotJobRequest(input *DescribeDashboardSnapshotJobInput) (req *request.Request, output *DescribeDashboardSnapshotJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboardSnapshotJob,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/snapshot-jobs/{SnapshotJobId}",
	}

	if input == nil {
		input = &DescribeDashboardSnapshotJobInput{}
	}

	output = &DescribeDashboardSnapshotJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboardSnapshotJob API operation for Amazon QuickSight.
//
// Describes an existing snapshot job.
//
// Poll job descriptions after a job starts to know the status of the job. For
// information on available status codes, see JobStatus.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboardSnapshotJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardSnapshotJob
func (c *QuickSight) DescribeDashboardSnapshotJob(input *DescribeDashboardSnapshotJobInput) (*DescribeDashboardSnapshotJobOutput, error) {
	req, out := c.DescribeDashboardSnapshotJobRequest(input)
	return out, req.Send()
}

// DescribeDashboardSnapshotJobWithContext is the same as DescribeDashboardSnapshotJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboardSnapshotJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardSnapshotJobWithContext(ctx aws.Context, input *DescribeDashboardSnapshotJobInput, opts ...request.Option) (*DescribeDashboardSnapshotJobOutput, error) {
	req, out := c.DescribeDashboardSnapshotJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboardSnapshotJobResult = "DescribeDashboardSnapshotJobResult"

// DescribeDashboardSnapshotJobResultRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboardSnapshotJobResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboardSnapshotJobResult for more information on using the DescribeDashboardSnapshotJobResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDashboardSnapshotJobResultRequest method.
//	req, resp := client.DescribeDashboardSnapshotJobResultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardSnapshotJobResult
func (c *QuickSight) DescribeDashboardSnapshotJobResultRequest(input *DescribeDashboardSnapshotJobResultInput) (req *request.Request, output *DescribeDashboardSnapshotJobResultOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboardSnapshotJobResult,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/snapshot-jobs/{SnapshotJobId}/result",
	}

	if input == nil {
		input = &DescribeDashboardSnapshotJobResultInput{}
	}

	output = &DescribeDashboardSnapshotJobResultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboardSnapshotJobResult API operation for Amazon QuickSight.
//
// Describes the result of an existing snapshot job that has finished running.
//
// A finished snapshot job will return a COMPLETED or FAILED status when you
// poll the job with a DescribeDashboardSnapshotJob API call.
//
// If the job has not finished running, this operation returns a message that
// says Dashboard Snapshot Job with id <SnapshotjobId> has not reached a terminal
// state..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboardSnapshotJobResult for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardSnapshotJobResult
func (c *QuickSight) DescribeDashboardSnapshotJobResult(input *DescribeDashboardSnapshotJobResultInput) (*DescribeDashboardSnapshotJobResultOutput, error) {
	req, out := c.DescribeDashboardSnapshotJobResultRequest(input)
	return out, req.Send()
}

// DescribeDashboardSnapshotJobResultWithContext is the same as DescribeDashboardSnapshotJobResult with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboardSnapshotJobResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardSnapshotJobResultWithContext(ctx aws.Context, input *DescribeDashboardSnapshotJobResultInput, opts ...request.Option) (*DescribeDashboardSnapshotJobResultOutput, error) {
	req, out := c.DescribeDashboardSnapshotJobResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSet = "DescribeDataSet"

// DescribeDataSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSet for more information on using the DescribeDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSetRequest method.
//	req, resp := client.DescribeDataSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet
func (c *QuickSight) DescribeDataSetRequest(input *DescribeDataSetInput) (req *request.Request, output *DescribeDataSetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSet,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DescribeDataSetInput{}
	}

	output = &DescribeDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSet API operation for Amazon QuickSight.
//
// Describes a dataset. This operation doesn't support datasets that include
// uploaded files as a source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet
func (c *QuickSight) DescribeDataSet(input *DescribeDataSetInput) (*DescribeDataSetOutput, error) {
	req, out := c.DescribeDataSetRequest(input)
	return out, req.Send()
}

// DescribeDataSetWithContext is the same as DescribeDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetWithContext(ctx aws.Context, input *DescribeDataSetInput, opts ...request.Option) (*DescribeDataSetOutput, error) {
	req, out := c.DescribeDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSetPermissions = "DescribeDataSetPermissions"

// DescribeDataSetPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSetPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSetPermissions for more information on using the DescribeDataSetPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSetPermissionsRequest method.
//	req, resp := client.DescribeDataSetPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions
func (c *QuickSight) DescribeDataSetPermissionsRequest(input *DescribeDataSetPermissionsInput) (req *request.Request, output *DescribeDataSetPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSetPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
	}

	if input == nil {
		input = &DescribeDataSetPermissionsInput{}
	}

	output = &DescribeDataSetPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSetPermissions API operation for Amazon QuickSight.
//
// Describes the permissions on a dataset.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSetPermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions
func (c *QuickSight) DescribeDataSetPermissions(input *DescribeDataSetPermissionsInput) (*DescribeDataSetPermissionsOutput, error) {
	req, out := c.DescribeDataSetPermissionsRequest(input)
	return out, req.Send()
}

// DescribeDataSetPermissionsWithContext is the same as DescribeDataSetPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSetPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetPermissionsWithContext(ctx aws.Context, input *DescribeDataSetPermissionsInput, opts ...request.Option) (*DescribeDataSetPermissionsOutput, error) {
	req, out := c.DescribeDataSetPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSetRefreshProperties = "DescribeDataSetRefreshProperties"

// DescribeDataSetRefreshPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSetRefreshProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSetRefreshProperties for more information on using the DescribeDataSetRefreshProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSetRefreshPropertiesRequest method.
//	req, resp := client.DescribeDataSetRefreshPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetRefreshProperties
func (c *QuickSight) DescribeDataSetRefreshPropertiesRequest(input *DescribeDataSetRefreshPropertiesInput) (req *request.Request, output *DescribeDataSetRefreshPropertiesOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSetRefreshProperties,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-properties",
	}

	if input == nil {
		input = &DescribeDataSetRefreshPropertiesInput{}
	}

	output = &DescribeDataSetRefreshPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSetRefreshProperties API operation for Amazon QuickSight.
//
// Describes the refresh properties of a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSetRefreshProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetRefreshProperties
func (c *QuickSight) DescribeDataSetRefreshProperties(input *DescribeDataSetRefreshPropertiesInput) (*DescribeDataSetRefreshPropertiesOutput, error) {
	req, out := c.DescribeDataSetRefreshPropertiesRequest(input)
	return out, req.Send()
}

// DescribeDataSetRefreshPropertiesWithContext is the same as DescribeDataSetRefreshProperties with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSetRefreshProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetRefreshPropertiesWithContext(ctx aws.Context, input *DescribeDataSetRefreshPropertiesInput, opts ...request.Option) (*DescribeDataSetRefreshPropertiesOutput, error) {
	req, out := c.DescribeDataSetRefreshPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSource = "DescribeDataSource"

// DescribeDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSource for more information on using the DescribeDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSourceRequest method.
//	req, resp := client.DescribeDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource
func (c *QuickSight) DescribeDataSourceRequest(input *DescribeDataSourceInput) (req *request.Request, output *DescribeDataSourceOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &DescribeDataSourceInput{}
	}

	output = &DescribeDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSource API operation for Amazon QuickSight.
//
// Describes a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource
func (c *QuickSight) DescribeDataSource(input *DescribeDataSourceInput) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	return out, req.Send()
}

// DescribeDataSourceWithContext is the same as DescribeDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSourceWithContext(ctx aws.Context, input *DescribeDataSourceInput, opts ...request.Option) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSourcePermissions = "DescribeDataSourcePermissions"

// DescribeDataSourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSourcePermissions for more information on using the DescribeDataSourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSourcePermissionsRequest method.
//	req, resp := client.DescribeDataSourcePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions
func (c *QuickSight) DescribeDataSourcePermissionsRequest(input *DescribeDataSourcePermissionsInput) (req *request.Request, output *DescribeDataSourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSourcePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &DescribeDataSourcePermissionsInput{}
	}

	output = &DescribeDataSourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSourcePermissions API operation for Amazon QuickSight.
//
// Describes the resource permissions for a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSourcePermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions
func (c *QuickSight) DescribeDataSourcePermissions(input *DescribeDataSourcePermissionsInput) (*DescribeDataSourcePermissionsOutput, error) {
	req, out := c.DescribeDataSourcePermissionsRequest(input)
	return out, req.Send()
}

// DescribeDataSourcePermissionsWithContext is the same as DescribeDataSourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSourcePermissionsWithContext(ctx aws.Context, input *DescribeDataSourcePermissionsInput, opts ...request.Option) (*DescribeDataSourcePermissionsOutput, error) {
	req, out := c.DescribeDataSourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFolder = "DescribeFolder"

// DescribeFolderRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolder for more information on using the DescribeFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFolderRequest method.
//	req, resp := client.DescribeFolderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolder
func (c *QuickSight) DescribeFolderRequest(input *DescribeFolderInput) (req *request.Request, output *DescribeFolderOutput) {
	op := &request.Operation{
		Name:       opDescribeFolder,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &DescribeFolderInput{}
	}

	output = &DescribeFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolder API operation for Amazon QuickSight.
//
// Describes a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeFolder for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolder
func (c *QuickSight) DescribeFolder(input *DescribeFolderInput) (*DescribeFolderOutput, error) {
	req, out := c.DescribeFolderRequest(input)
	return out, req.Send()
}

// DescribeFolderWithContext is the same as DescribeFolder with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderWithContext(ctx aws.Context, input *DescribeFolderInput, opts ...request.Option) (*DescribeFolderOutput, error) {
	req, out := c.DescribeFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFolderPermissions = "DescribeFolderPermissions"

// DescribeFolderPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolderPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolderPermissions for more information on using the DescribeFolderPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFolderPermissionsRequest method.
//	req, resp := client.DescribeFolderPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderPermissions
func (c *QuickSight) DescribeFolderPermissionsRequest(input *DescribeFolderPermissionsInput) (req *request.Request, output *DescribeFolderPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeFolderPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/permissions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFolderPermissionsInput{}
	}

	output = &DescribeFolderPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolderPermissions API operation for Amazon QuickSight.
//
// Describes permissions for a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeFolderPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderPermissions
func (c *QuickSight) DescribeFolderPermissions(input *DescribeFolderPermissionsInput) (*DescribeFolderPermissionsOutput, error) {
	req, out := c.DescribeFolderPermissionsRequest(input)
	return out, req.Send()
}

// DescribeFolderPermissionsWithContext is the same as DescribeFolderPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolderPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderPermissionsWithContext(ctx aws.Context, input *DescribeFolderPermissionsInput, opts ...request.Option) (*DescribeFolderPermissionsOutput, error) {
	req, out := c.DescribeFolderPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFolderPermissionsPages iterates over the pages of a DescribeFolderPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFolderPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFolderPermissions operation.
//	pageNum := 0
//	err := client.DescribeFolderPermissionsPages(params,
//	    func(page *quicksight.DescribeFolderPermissionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) DescribeFolderPermissionsPages(input *DescribeFolderPermissionsInput, fn func(*DescribeFolderPermissionsOutput, bool) bool) error {
	return c.DescribeFolderPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFolderPermissionsPagesWithContext same as DescribeFolderPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderPermissionsPagesWithContext(ctx aws.Context, input *DescribeFolderPermissionsInput, fn func(*DescribeFolderPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFolderPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFolderPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFolderPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFolderResolvedPermissions = "DescribeFolderResolvedPermissions"

// DescribeFolderResolvedPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolderResolvedPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolderResolvedPermissions for more information on using the DescribeFolderResolvedPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFolderResolvedPermissionsRequest method.
//	req, resp := client.DescribeFolderResolvedPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderResolvedPermissions
func (c *QuickSight) DescribeFolderResolvedPermissionsRequest(input *DescribeFolderResolvedPermissionsInput) (req *request.Request, output *DescribeFolderResolvedPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeFolderResolvedPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/resolved-permissions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFolderResolvedPermissionsInput{}
	}

	output = &DescribeFolderResolvedPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolderResolvedPermissions API operation for Amazon QuickSight.
//
// Describes the folder resolved permissions. Permissions consists of both folder
// direct permissions and the inherited permissions from the ancestor folders.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeFolderResolvedPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderResolvedPermissions
func (c *QuickSight) DescribeFolderResolvedPermissions(input *DescribeFolderResolvedPermissionsInput) (*DescribeFolderResolvedPermissionsOutput, error) {
	req, out := c.DescribeFolderResolvedPermissionsRequest(input)
	return out, req.Send()
}

// DescribeFolderResolvedPermissionsWithContext is the same as DescribeFolderResolvedPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolderResolvedPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderResolvedPermissionsWithContext(ctx aws.Context, input *DescribeFolderResolvedPermissionsInput, opts ...request.Option) (*DescribeFolderResolvedPermissionsOutput, error) {
	req, out := c.DescribeFolderResolvedPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFolderResolvedPermissionsPages iterates over the pages of a DescribeFolderResolvedPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFolderResolvedPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFolderResolvedPermissions operation.
//	pageNum := 0
//	err := client.DescribeFolderResolvedPermissionsPages(params,
//	    func(page *quicksight.DescribeFolderResolvedPermissionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) DescribeFolderResolvedPermissionsPages(input *DescribeFolderResolvedPermissionsInput, fn func(*DescribeFolderResolvedPermissionsOutput, bool) bool) error {
	return c.DescribeFolderResolvedPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFolderResolvedPermissionsPagesWithContext same as DescribeFolderResolvedPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderResolvedPermissionsPagesWithContext(ctx aws.Context, input *DescribeFolderResolvedPermissionsInput, fn func(*DescribeFolderResolvedPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFolderResolvedPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFolderResolvedPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFolderResolvedPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeGroup = "DescribeGroup"

// DescribeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroup for more information on using the DescribeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGroupRequest method.
//	req, resp := client.DescribeGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroupRequest(input *DescribeGroupInput) (req *request.Request, output *DescribeGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DescribeGroupInput{}
	}

	output = &DescribeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroup API operation for Amazon QuickSight.
//
// Returns an Amazon QuickSight group's description and Amazon Resource Name
// (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroup(input *DescribeGroupInput) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	return out, req.Send()
}

// DescribeGroupWithContext is the same as DescribeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeGroupWithContext(ctx aws.Context, input *DescribeGroupInput, opts ...request.Option) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroupMembership = "DescribeGroupMembership"

// DescribeGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroupMembership for more information on using the DescribeGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGroupMembershipRequest method.
//	req, resp := client.DescribeGroupMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroupMembership
func (c *QuickSight) DescribeGroupMembershipRequest(input *DescribeGroupMembershipInput) (req *request.Request, output *DescribeGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDescribeGroupMembership,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &DescribeGroupMembershipInput{}
	}

	output = &DescribeGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroupMembership API operation for Amazon QuickSight.
//
// Use the DescribeGroupMembership operation to determine if a user is a member
// of the specified group. If the user exists and is a member of the specified
// group, an associated GroupMember object is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeGroupMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroupMembership
func (c *QuickSight) DescribeGroupMembership(input *DescribeGroupMembershipInput) (*DescribeGroupMembershipOutput, error) {
	req, out := c.DescribeGroupMembershipRequest(input)
	return out, req.Send()
}

// DescribeGroupMembershipWithContext is the same as DescribeGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeGroupMembershipWithContext(ctx aws.Context, input *DescribeGroupMembershipInput, opts ...request.Option) (*DescribeGroupMembershipOutput, error) {
	req, out := c.DescribeGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIAMPolicyAssignment = "DescribeIAMPolicyAssignment"

// DescribeIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIAMPolicyAssignment for more information on using the DescribeIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIAMPolicyAssignmentRequest method.
//	req, resp := client.DescribeIAMPolicyAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment
func (c *QuickSight) DescribeIAMPolicyAssignmentRequest(input *DescribeIAMPolicyAssignmentInput) (req *request.Request, output *DescribeIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opDescribeIAMPolicyAssignment,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &DescribeIAMPolicyAssignmentInput{}
	}

	output = &DescribeIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Describes an existing IAM policy assignment, as specified by the assignment
// name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment
func (c *QuickSight) DescribeIAMPolicyAssignment(input *DescribeIAMPolicyAssignmentInput) (*DescribeIAMPolicyAssignmentOutput, error) {
	req, out := c.DescribeIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// DescribeIAMPolicyAssignmentWithContext is the same as DescribeIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIAMPolicyAssignmentWithContext(ctx aws.Context, input *DescribeIAMPolicyAssignmentInput, opts ...request.Option) (*DescribeIAMPolicyAssignmentOutput, error) {
	req, out := c.DescribeIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIngestion = "DescribeIngestion"

// DescribeIngestionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIngestion for more information on using the DescribeIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIngestionRequest method.
//	req, resp := client.DescribeIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion
func (c *QuickSight) DescribeIngestionRequest(input *DescribeIngestionInput) (req *request.Request, output *DescribeIngestionOutput) {
	op := &request.Operation{
		Name:       opDescribeIngestion,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &DescribeIngestionInput{}
	}

	output = &DescribeIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIngestion API operation for Amazon QuickSight.
//
// Describes a SPICE ingestion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIngestion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion
func (c *QuickSight) DescribeIngestion(input *DescribeIngestionInput) (*DescribeIngestionOutput, error) {
	req, out := c.DescribeIngestionRequest(input)
	return out, req.Send()
}

// DescribeIngestionWithContext is the same as DescribeIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIngestionWithContext(ctx aws.Context, input *DescribeIngestionInput, opts ...request.Option) (*DescribeIngestionOutput, error) {
	req, out := c.DescribeIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIpRestriction = "DescribeIpRestriction"

// DescribeIpRestrictionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIpRestriction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIpRestriction for more information on using the DescribeIpRestriction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIpRestrictionRequest method.
//	req, resp := client.DescribeIpRestrictionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIpRestriction
func (c *QuickSight) DescribeIpRestrictionRequest(input *DescribeIpRestrictionInput) (req *request.Request, output *DescribeIpRestrictionOutput) {
	op := &request.Operation{
		Name:       opDescribeIpRestriction,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/ip-restriction",
	}

	if input == nil {
		input = &DescribeIpRestrictionInput{}
	}

	output = &DescribeIpRestrictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIpRestriction API operation for Amazon QuickSight.
//
// Provides a summary and status of IP rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIpRestriction for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIpRestriction
func (c *QuickSight) DescribeIpRestriction(input *DescribeIpRestrictionInput) (*DescribeIpRestrictionOutput, error) {
	req, out := c.DescribeIpRestrictionRequest(input)
	return out, req.Send()
}

// DescribeIpRestrictionWithContext is the same as DescribeIpRestriction with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIpRestriction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIpRestrictionWithContext(ctx aws.Context, input *DescribeIpRestrictionInput, opts ...request.Option) (*DescribeIpRestrictionOutput, error) {
	req, out := c.DescribeIpRestrictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNamespace = "DescribeNamespace"

// DescribeNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNamespace for more information on using the DescribeNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeNamespaceRequest method.
//	req, resp := client.DescribeNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace
func (c *QuickSight) DescribeNamespaceRequest(input *DescribeNamespaceInput) (req *request.Request, output *DescribeNamespaceOutput) {
	op := &request.Operation{
		Name:       opDescribeNamespace,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}",
	}

	if input == nil {
		input = &DescribeNamespaceInput{}
	}

	output = &DescribeNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNamespace API operation for Amazon QuickSight.
//
// Describes the current namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeNamespace for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace
func (c *QuickSight) DescribeNamespace(input *DescribeNamespaceInput) (*DescribeNamespaceOutput, error) {
	req, out := c.DescribeNamespaceRequest(input)
	return out, req.Send()
}

// DescribeNamespaceWithContext is the same as DescribeNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeNamespaceWithContext(ctx aws.Context, input *DescribeNamespaceInput, opts ...request.Option) (*DescribeNamespaceOutput, error) {
	req, out := c.DescribeNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRefreshSchedule = "DescribeRefreshSchedule"

// DescribeRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRefreshSchedule for more information on using the DescribeRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRefreshScheduleRequest method.
//	req, resp := client.DescribeRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeRefreshSchedule
func (c *QuickSight) DescribeRefreshScheduleRequest(input *DescribeRefreshScheduleInput) (req *request.Request, output *DescribeRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeRefreshSchedule,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules/{ScheduleId}",
	}

	if input == nil {
		input = &DescribeRefreshScheduleInput{}
	}

	output = &DescribeRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRefreshSchedule API operation for Amazon QuickSight.
//
// Provides a summary of a refresh schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeRefreshSchedule
func (c *QuickSight) DescribeRefreshSchedule(input *DescribeRefreshScheduleInput) (*DescribeRefreshScheduleOutput, error) {
	req, out := c.DescribeRefreshScheduleRequest(input)
	return out, req.Send()
}

// DescribeRefreshScheduleWithContext is the same as DescribeRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeRefreshScheduleWithContext(ctx aws.Context, input *DescribeRefreshScheduleInput, opts ...request.Option) (*DescribeRefreshScheduleOutput, error) {
	req, out := c.DescribeRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRoleCustomPermission = "DescribeRoleCustomPermission"

// DescribeRoleCustomPermissionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRoleCustomPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRoleCustomPermission for more information on using the DescribeRoleCustomPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRoleCustomPermissionRequest method.
//	req, resp := client.DescribeRoleCustomPermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeRoleCustomPermission
func (c *QuickSight) DescribeRoleCustomPermissionRequest(input *DescribeRoleCustomPermissionInput) (req *request.Request, output *DescribeRoleCustomPermissionOutput) {
	op := &request.Operation{
		Name:       opDescribeRoleCustomPermission,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/custom-permission",
	}

	if input == nil {
		input = &DescribeRoleCustomPermissionInput{}
	}

	output = &DescribeRoleCustomPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRoleCustomPermission API operation for Amazon QuickSight.
//
// Describes all custom permissions that are mapped to a role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeRoleCustomPermission for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeRoleCustomPermission
func (c *QuickSight) DescribeRoleCustomPermission(input *DescribeRoleCustomPermissionInput) (*DescribeRoleCustomPermissionOutput, error) {
	req, out := c.DescribeRoleCustomPermissionRequest(input)
	return out, req.Send()
}

// DescribeRoleCustomPermissionWithContext is the same as DescribeRoleCustomPermission with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRoleCustomPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeRoleCustomPermissionWithContext(ctx aws.Context, input *DescribeRoleCustomPermissionInput, opts ...request.Option) (*DescribeRoleCustomPermissionOutput, error) {
	req, out := c.DescribeRoleCustomPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplate = "DescribeTemplate"

// DescribeTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplate for more information on using the DescribeTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTemplateRequest method.
//	req, resp := client.DescribeTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate
func (c *QuickSight) DescribeTemplateRequest(input *DescribeTemplateInput) (req *request.Request, output *DescribeTemplateOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DescribeTemplateInput{}
	}

	output = &DescribeTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplate API operation for Amazon QuickSight.
//
// Describes a template's metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate
func (c *QuickSight) DescribeTemplate(input *DescribeTemplateInput) (*DescribeTemplateOutput, error) {
	req, out := c.DescribeTemplateRequest(input)
	return out, req.Send()
}

// DescribeTemplateWithContext is the same as DescribeTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateWithContext(ctx aws.Context, input *DescribeTemplateInput, opts ...request.Option) (*DescribeTemplateOutput, error) {
	req, out := c.DescribeTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplateAlias = "DescribeTemplateAlias"

// DescribeTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplateAlias for more information on using the DescribeTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTemplateAliasRequest method.
//	req, resp := client.DescribeTemplateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias
func (c *QuickSight) DescribeTemplateAliasRequest(input *DescribeTemplateAliasInput) (req *request.Request, output *DescribeTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplateAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DescribeTemplateAliasInput{}
	}

	output = &DescribeTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplateAlias API operation for Amazon QuickSight.
//
// Describes the template alias for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias
func (c *QuickSight) DescribeTemplateAlias(input *DescribeTemplateAliasInput) (*DescribeTemplateAliasOutput, error) {
	req, out := c.DescribeTemplateAliasRequest(input)
	return out, req.Send()
}

// DescribeTemplateAliasWithContext is the same as DescribeTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateAliasWithContext(ctx aws.Context, input *DescribeTemplateAliasInput, opts ...request.Option) (*DescribeTemplateAliasOutput, error) {
	req, out := c.DescribeTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplateDefinition = "DescribeTemplateDefinition"

// DescribeTemplateDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplateDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplateDefinition for more information on using the DescribeTemplateDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTemplateDefinitionRequest method.
//	req, resp := client.DescribeTemplateDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateDefinition
func (c *QuickSight) DescribeTemplateDefinitionRequest(input *DescribeTemplateDefinitionInput) (req *request.Request, output *DescribeTemplateDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplateDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/definition",
	}

	if input == nil {
		input = &DescribeTemplateDefinitionInput{}
	}

	output = &DescribeTemplateDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplateDefinition API operation for Amazon QuickSight.
//
// Provides a detailed description of the definition of a template.
//
// If you do not need to know details about the content of a template, for instance
// if you are trying to check the status of a recently created or updated template,
// use the DescribeTemplate (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplate.html)
// instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplateDefinition for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateDefinition
func (c *QuickSight) DescribeTemplateDefinition(input *DescribeTemplateDefinitionInput) (*DescribeTemplateDefinitionOutput, error) {
	req, out := c.DescribeTemplateDefinitionRequest(input)
	return out, req.Send()
}

// DescribeTemplateDefinitionWithContext is the same as DescribeTemplateDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplateDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateDefinitionWithContext(ctx aws.Context, input *DescribeTemplateDefinitionInput, opts ...request.Option) (*DescribeTemplateDefinitionOutput, error) {
	req, out := c.DescribeTemplateDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplatePermissions = "DescribeTemplatePermissions"

// DescribeTemplatePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplatePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplatePermissions for more information on using the DescribeTemplatePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTemplatePermissionsRequest method.
//	req, resp := client.DescribeTemplatePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions
func (c *QuickSight) DescribeTemplatePermissionsRequest(input *DescribeTemplatePermissionsInput) (req *request.Request, output *DescribeTemplatePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplatePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
	}

	if input == nil {
		input = &DescribeTemplatePermissionsInput{}
	}

	output = &DescribeTemplatePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplatePermissions API operation for Amazon QuickSight.
//
// Describes read and write permissions on a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplatePermissions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions
func (c *QuickSight) DescribeTemplatePermissions(input *DescribeTemplatePermissionsInput) (*DescribeTemplatePermissionsOutput, error) {
	req, out := c.DescribeTemplatePermissionsRequest(input)
	return out, req.Send()
}

// DescribeTemplatePermissionsWithContext is the same as DescribeTemplatePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplatePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplatePermissionsWithContext(ctx aws.Context, input *DescribeTemplatePermissionsInput, opts ...request.Option) (*DescribeTemplatePermissionsOutput, error) {
	req, out := c.DescribeTemplatePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTheme = "DescribeTheme"

// DescribeThemeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTheme for more information on using the DescribeTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeThemeRequest method.
//	req, resp := client.DescribeThemeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme
func (c *QuickSight) DescribeThemeRequest(input *DescribeThemeInput) (req *request.Request, output *DescribeThemeOutput) {
	op := &request.Operation{
		Name:       opDescribeTheme,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &DescribeThemeInput{}
	}

	output = &DescribeThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTheme API operation for Amazon QuickSight.
//
// Describes a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTheme for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme
func (c *QuickSight) DescribeTheme(input *DescribeThemeInput) (*DescribeThemeOutput, error) {
	req, out := c.DescribeThemeRequest(input)
	return out, req.Send()
}

// DescribeThemeWithContext is the same as DescribeTheme with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeThemeWithContext(ctx aws.Context, input *DescribeThemeInput, opts ...request.Option) (*DescribeThemeOutput, error) {
	req, out := c.DescribeThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThemeAlias = "DescribeThemeAlias"

// DescribeThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThemeAlias for more information on using the DescribeThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeThemeAliasRequest method.
//	req, resp := client.DescribeThemeAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias
func (c *QuickSight) DescribeThemeAliasRequest(input *DescribeThemeAliasInput) (req *request.Request, output *DescribeThemeAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeThemeAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DescribeThemeAliasInput{}
	}

	output = &DescribeThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThemeAlias API operation for Amazon QuickSight.
//
// Describes the alias for a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeThemeAlias for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias
func (c *QuickSight) DescribeThemeAlias(input *DescribeThemeAliasInput) (*DescribeThemeAliasOutput, error) {
	req, out := c.DescribeThemeAliasRequest(input)
	return out, req.Send()
}

// DescribeThemeAliasWithContext is the same as DescribeThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeThemeAliasWithContext(ctx aws.Context, input *DescribeThemeAliasInput, opts ...request.Option) (*DescribeThemeAliasOutput, error) {
	req, out := c.DescribeThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThemePermissions = "DescribeThemePermissions"

// DescribeThemePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThemePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThemePermissions for more information on using the DescribeThemePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeThemePermissionsRequest method.
//	req, resp := client.DescribeThemePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions
func (c *QuickSight) DescribeThemePermissionsRequest(input *DescribeThemePermissionsInput) (req *request.Request, output *DescribeThemePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeThemePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/permissions",
	}

	if input == nil {
		input = &DescribeThemePermissionsInput{}
	}

	output = &DescribeThemePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThemePermissions API operation for Amazon QuickSight.
//
// Describes the read and write permissions for a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeThemePermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions
func (c *QuickSight) DescribeThemePermissions(input *DescribeThemePermissionsInput) (*DescribeThemePermissionsOutput, error) {
	req, out := c.DescribeThemePermissionsRequest(input)
	return out, req.Send()
}

// DescribeThemePermissionsWithContext is the same as DescribeThemePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThemePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeThemePermissionsWithContext(ctx aws.Context, input *DescribeThemePermissionsInput, opts ...request.Option) (*DescribeThemePermissionsOutput, error) {
	req, out := c.DescribeThemePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopic = "DescribeTopic"

// DescribeTopicRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTopic operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTopic for more information on using the DescribeTopic
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTopicRequest method.
//	req, resp := client.DescribeTopicRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTopic
func (c *QuickSight) DescribeTopicRequest(input *DescribeTopicInput) (req *request.Request, output *DescribeTopicOutput) {
	op := &request.Operation{
		Name:       opDescribeTopic,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}",
	}

	if input == nil {
		input = &DescribeTopicInput{}
	}

	output = &DescribeTopicOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTopic API operation for Amazon QuickSight.
//
// Describes a topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTopic for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTopic
func (c *QuickSight) DescribeTopic(input *DescribeTopicInput) (*DescribeTopicOutput, error) {
	req, out := c.DescribeTopicRequest(input)
	return out, req.Send()
}

// DescribeTopicWithContext is the same as DescribeTopic with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTopicWithContext(ctx aws.Context, input *DescribeTopicInput, opts ...request.Option) (*DescribeTopicOutput, error) {
	req, out := c.DescribeTopicRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicPermissions = "DescribeTopicPermissions"

// DescribeTopicPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTopicPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTopicPermissions for more information on using the DescribeTopicPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTopicPermissionsRequest method.
//	req, resp := client.DescribeTopicPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTopicPermissions
func (c *QuickSight) DescribeTopicPermissionsRequest(input *DescribeTopicPermissionsInput) (req *request.Request, output *DescribeTopicPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}/permissions",
	}

	if input == nil {
		input = &DescribeTopicPermissionsInput{}
	}

	output = &DescribeTopicPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTopicPermissions API operation for Amazon QuickSight.
//
// Describes the permissions of a topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTopicPermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTopicPermissions
func (c *QuickSight) DescribeTopicPermissions(input *DescribeTopicPermissionsInput) (*DescribeTopicPermissionsOutput, error) {
	req, out := c.DescribeTopicPermissionsRequest(input)
	return out, req.Send()
}

// DescribeTopicPermissionsWithContext is the same as DescribeTopicPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTopicPermissionsWithContext(ctx aws.Context, input *DescribeTopicPermissionsInput, opts ...request.Option) (*DescribeTopicPermissionsOutput, error) {
	req, out := c.DescribeTopicPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicRefresh = "DescribeTopicRefresh"

// DescribeTopicRefreshRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTopicRefresh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTopicRefresh for more information on using the DescribeTopicRefresh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTopicRefreshRequest method.
//	req, resp := client.DescribeTopicRefreshRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTopicRefresh
func (c *QuickSight) DescribeTopicRefreshRequest(input *DescribeTopicRefreshInput) (req *request.Request, output *DescribeTopicRefreshOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicRefresh,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}/refresh/{RefreshId}",
	}

	if input == nil {
		input = &DescribeTopicRefreshInput{}
	}

	output = &DescribeTopicRefreshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTopicRefresh API operation for Amazon QuickSight.
//
// Describes the status of a topic refresh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTopicRefresh for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTopicRefresh
func (c *QuickSight) DescribeTopicRefresh(input *DescribeTopicRefreshInput) (*DescribeTopicRefreshOutput, error) {
	req, out := c.DescribeTopicRefreshRequest(input)
	return out, req.Send()
}

// DescribeTopicRefreshWithContext is the same as DescribeTopicRefresh with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicRefresh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTopicRefreshWithContext(ctx aws.Context, input *DescribeTopicRefreshInput, opts ...request.Option) (*DescribeTopicRefreshOutput, error) {
	req, out := c.DescribeTopicRefreshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicRefreshSchedule = "DescribeTopicRefreshSchedule"

// DescribeTopicRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTopicRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTopicRefreshSchedule for more information on using the DescribeTopicRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTopicRefreshScheduleRequest method.
//	req, resp := client.DescribeTopicRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTopicRefreshSchedule
func (c *QuickSight) DescribeTopicRefreshScheduleRequest(input *DescribeTopicRefreshScheduleInput) (req *request.Request, output *DescribeTopicRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicRefreshSchedule,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}/schedules/{DatasetId}",
	}

	if input == nil {
		input = &DescribeTopicRefreshScheduleInput{}
	}

	output = &DescribeTopicRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTopicRefreshSchedule API operation for Amazon QuickSight.
//
// Deletes a topic refresh schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTopicRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTopicRefreshSchedule
func (c *QuickSight) DescribeTopicRefreshSchedule(input *DescribeTopicRefreshScheduleInput) (*DescribeTopicRefreshScheduleOutput, error) {
	req, out := c.DescribeTopicRefreshScheduleRequest(input)
	return out, req.Send()
}

// DescribeTopicRefreshScheduleWithContext is the same as DescribeTopicRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTopicRefreshScheduleWithContext(ctx aws.Context, input *DescribeTopicRefreshScheduleInput, opts ...request.Option) (*DescribeTopicRefreshScheduleOutput, error) {
	req, out := c.DescribeTopicRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeUserRequest method.
//	req, resp := client.DescribeUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon QuickSight.
//
// Returns information about a user, given the user name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVPCConnection = "DescribeVPCConnection"

// DescribeVPCConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVPCConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVPCConnection for more information on using the DescribeVPCConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVPCConnectionRequest method.
//	req, resp := client.DescribeVPCConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeVPCConnection
func (c *QuickSight) DescribeVPCConnectionRequest(input *DescribeVPCConnectionInput) (req *request.Request, output *DescribeVPCConnectionOutput) {
	op := &request.Operation{
		Name:       opDescribeVPCConnection,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/vpc-connections/{VPCConnectionId}",
	}

	if input == nil {
		input = &DescribeVPCConnectionInput{}
	}

	output = &DescribeVPCConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVPCConnection API operation for Amazon QuickSight.
//
// Describes a VPC connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeVPCConnection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeVPCConnection
func (c *QuickSight) DescribeVPCConnection(input *DescribeVPCConnectionInput) (*DescribeVPCConnectionOutput, error) {
	req, out := c.DescribeVPCConnectionRequest(input)
	return out, req.Send()
}

// DescribeVPCConnectionWithContext is the same as DescribeVPCConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVPCConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeVPCConnectionWithContext(ctx aws.Context, input *DescribeVPCConnectionInput, opts ...request.Option) (*DescribeVPCConnectionOutput, error) {
	req, out := c.DescribeVPCConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateEmbedUrlForAnonymousUser = "GenerateEmbedUrlForAnonymousUser"

// GenerateEmbedUrlForAnonymousUserRequest generates a "aws/request.Request" representing the
// client's request for the GenerateEmbedUrlForAnonymousUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateEmbedUrlForAnonymousUser for more information on using the GenerateEmbedUrlForAnonymousUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateEmbedUrlForAnonymousUserRequest method.
//	req, resp := client.GenerateEmbedUrlForAnonymousUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForAnonymousUser
func (c *QuickSight) GenerateEmbedUrlForAnonymousUserRequest(input *GenerateEmbedUrlForAnonymousUserInput) (req *request.Request, output *GenerateEmbedUrlForAnonymousUserOutput) {
	op := &request.Operation{
		Name:       opGenerateEmbedUrlForAnonymousUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/embed-url/anonymous-user",
	}

	if input == nil {
		input = &GenerateEmbedUrlForAnonymousUserInput{}
	}

	output = &GenerateEmbedUrlForAnonymousUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateEmbedUrlForAnonymousUser API operation for Amazon QuickSight.
//
// Generates an embed URL that you can use to embed an Amazon QuickSight dashboard
// or visual in your website, without having to register any reader users. Before
// you use this action, make sure that you have configured the dashboards and
// permissions.
//
// The following rules apply to the generated URL:
//
//   - It contains a temporary bearer token. It is valid for 5 minutes after
//     it is generated. Once redeemed within this period, it cannot be re-used
//     again.
//
//   - The URL validity period should not be confused with the actual session
//     lifetime that can be customized using the SessionLifetimeInMinutes (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes)
//     parameter. The resulting user session is valid for 15 minutes (minimum)
//     to 10 hours (maximum). The default session duration is 10 hours.
//
//   - You are charged only when the URL is used or there is interaction with
//     Amazon QuickSight.
//
// For more information, see Embedded Analytics (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
// in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the Amazon
// QuickSight Developer Portal (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GenerateEmbedUrlForAnonymousUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - SessionLifetimeInMinutesInvalidException
//     The number of minutes specified for the lifetime of a session isn't valid.
//     The session lifetime must be 15-600 minutes.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - UnsupportedPricingPlanException
//     This error indicates that you are calling an embedding operation in Amazon
//     QuickSight without the required pricing plan on your Amazon Web Services
//     account. Before you can use embedding for anonymous users, a QuickSight administrator
//     needs to add capacity pricing to Amazon QuickSight. You can do this on the
//     Manage Amazon QuickSight page.
//
//     After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//     API operation with the --identity-type ANONYMOUS option.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForAnonymousUser
func (c *QuickSight) GenerateEmbedUrlForAnonymousUser(input *GenerateEmbedUrlForAnonymousUserInput) (*GenerateEmbedUrlForAnonymousUserOutput, error) {
	req, out := c.GenerateEmbedUrlForAnonymousUserRequest(input)
	return out, req.Send()
}

// GenerateEmbedUrlForAnonymousUserWithContext is the same as GenerateEmbedUrlForAnonymousUser with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateEmbedUrlForAnonymousUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GenerateEmbedUrlForAnonymousUserWithContext(ctx aws.Context, input *GenerateEmbedUrlForAnonymousUserInput, opts ...request.Option) (*GenerateEmbedUrlForAnonymousUserOutput, error) {
	req, out := c.GenerateEmbedUrlForAnonymousUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateEmbedUrlForRegisteredUser = "GenerateEmbedUrlForRegisteredUser"

// GenerateEmbedUrlForRegisteredUserRequest generates a "aws/request.Request" representing the
// client's request for the GenerateEmbedUrlForRegisteredUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateEmbedUrlForRegisteredUser for more information on using the GenerateEmbedUrlForRegisteredUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateEmbedUrlForRegisteredUserRequest method.
//	req, resp := client.GenerateEmbedUrlForRegisteredUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForRegisteredUser
func (c *QuickSight) GenerateEmbedUrlForRegisteredUserRequest(input *GenerateEmbedUrlForRegisteredUserInput) (req *request.Request, output *GenerateEmbedUrlForRegisteredUserOutput) {
	op := &request.Operation{
		Name:       opGenerateEmbedUrlForRegisteredUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/embed-url/registered-user",
	}

	if input == nil {
		input = &GenerateEmbedUrlForRegisteredUserInput{}
	}

	output = &GenerateEmbedUrlForRegisteredUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateEmbedUrlForRegisteredUser API operation for Amazon QuickSight.
//
// Generates an embed URL that you can use to embed an Amazon QuickSight experience
// in your website. This action can be used for any type of user registered
// in an Amazon QuickSight account. Before you use this action, make sure that
// you have configured the relevant Amazon QuickSight resource and permissions.
//
// The following rules apply to the generated URL:
//
//   - It contains a temporary bearer token. It is valid for 5 minutes after
//     it is generated. Once redeemed within this period, it cannot be re-used
//     again.
//
//   - The URL validity period should not be confused with the actual session
//     lifetime that can be customized using the SessionLifetimeInMinutes (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes)
//     parameter. The resulting user session is valid for 15 minutes (minimum)
//     to 10 hours (maximum). The default session duration is 10 hours.
//
//   - You are charged only when the URL is used or there is interaction with
//     Amazon QuickSight.
//
// For more information, see Embedded Analytics (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
// in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the Amazon
// QuickSight Developer Portal (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GenerateEmbedUrlForRegisteredUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - UserNotFoundException
//     The user with the provided name isn't found. This error can happen in any
//     operation that requires finding a user based on a provided user name, such
//     as DeleteUser, DescribeUser, and so on.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - SessionLifetimeInMinutesInvalidException
//     The number of minutes specified for the lifetime of a session isn't valid.
//     The session lifetime must be 15-600 minutes.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - UnsupportedPricingPlanException
//     This error indicates that you are calling an embedding operation in Amazon
//     QuickSight without the required pricing plan on your Amazon Web Services
//     account. Before you can use embedding for anonymous users, a QuickSight administrator
//     needs to add capacity pricing to Amazon QuickSight. You can do this on the
//     Manage Amazon QuickSight page.
//
//     After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//     API operation with the --identity-type ANONYMOUS option.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForRegisteredUser
func (c *QuickSight) GenerateEmbedUrlForRegisteredUser(input *GenerateEmbedUrlForRegisteredUserInput) (*GenerateEmbedUrlForRegisteredUserOutput, error) {
	req, out := c.GenerateEmbedUrlForRegisteredUserRequest(input)
	return out, req.Send()
}

// GenerateEmbedUrlForRegisteredUserWithContext is the same as GenerateEmbedUrlForRegisteredUser with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateEmbedUrlForRegisteredUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GenerateEmbedUrlForRegisteredUserWithContext(ctx aws.Context, input *GenerateEmbedUrlForRegisteredUserInput, opts ...request.Option) (*GenerateEmbedUrlForRegisteredUserOutput, error) {
	req, out := c.GenerateEmbedUrlForRegisteredUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDashboardEmbedUrl = "GetDashboardEmbedUrl"

// GetDashboardEmbedUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetDashboardEmbedUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDashboardEmbedUrl for more information on using the GetDashboardEmbedUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDashboardEmbedUrlRequest method.
//	req, resp := client.GetDashboardEmbedUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrlRequest(input *GetDashboardEmbedUrlInput) (req *request.Request, output *GetDashboardEmbedUrlOutput) {
	op := &request.Operation{
		Name:       opGetDashboardEmbedUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url",
	}

	if input == nil {
		input = &GetDashboardEmbedUrlInput{}
	}

	output = &GetDashboardEmbedUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDashboardEmbedUrl API operation for Amazon QuickSight.
//
// Generates a temporary session URL and authorization code(bearer token) that
// you can use to embed an Amazon QuickSight read-only dashboard in your website
// or application. Before you use this command, make sure that you have configured
// the dashboards and permissions.
//
// Currently, you can use GetDashboardEmbedURL only from the server, not from
// the user's browser. The following rules apply to the generated URL:
//
//   - They must be used together.
//
//   - They can be used one time only.
//
//   - They are valid for 5 minutes after you run this command.
//
//   - You are charged only when the URL is used or there is interaction with
//     Amazon QuickSight.
//
//   - The resulting user session is valid for 15 minutes (default) up to 10
//     hours (maximum). You can use the optional SessionLifetimeInMinutes parameter
//     to customize session duration.
//
// For more information, see Embedding Analytics Using GetDashboardEmbedUrl
// (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html)
// in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the Amazon
// QuickSight Developer Portal (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GetDashboardEmbedUrl for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - DomainNotWhitelistedException
//     The domain specified isn't on the allow list. All domains for embedded dashboards
//     must be added to the approved list by an Amazon QuickSight admin.
//
//   - UserNotFoundException
//     The user with the provided name isn't found. This error can happen in any
//     operation that requires finding a user based on a provided user name, such
//     as DeleteUser, DescribeUser, and so on.
//
//   - IdentityTypeNotSupportedException
//     The identity type specified isn't supported. Supported identity types include
//     IAM and QUICKSIGHT.
//
//   - SessionLifetimeInMinutesInvalidException
//     The number of minutes specified for the lifetime of a session isn't valid.
//     The session lifetime must be 15-600 minutes.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - UnsupportedPricingPlanException
//     This error indicates that you are calling an embedding operation in Amazon
//     QuickSight without the required pricing plan on your Amazon Web Services
//     account. Before you can use embedding for anonymous users, a QuickSight administrator
//     needs to add capacity pricing to Amazon QuickSight. You can do this on the
//     Manage Amazon QuickSight page.
//
//     After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//     API operation with the --identity-type ANONYMOUS option.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrl(input *GetDashboardEmbedUrlInput) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	return out, req.Send()
}

// GetDashboardEmbedUrlWithContext is the same as GetDashboardEmbedUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetDashboardEmbedUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GetDashboardEmbedUrlWithContext(ctx aws.Context, input *GetDashboardEmbedUrlInput, opts ...request.Option) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSessionEmbedUrl = "GetSessionEmbedUrl"

// GetSessionEmbedUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetSessionEmbedUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSessionEmbedUrl for more information on using the GetSessionEmbedUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSessionEmbedUrlRequest method.
//	req, resp := client.GetSessionEmbedUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl
func (c *QuickSight) GetSessionEmbedUrlRequest(input *GetSessionEmbedUrlInput) (req *request.Request, output *GetSessionEmbedUrlOutput) {
	op := &request.Operation{
		Name:       opGetSessionEmbedUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/session-embed-url",
	}

	if input == nil {
		input = &GetSessionEmbedUrlInput{}
	}

	output = &GetSessionEmbedUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSessionEmbedUrl API operation for Amazon QuickSight.
//
// Generates a session URL and authorization code that you can use to embed
// the Amazon Amazon QuickSight console in your web server code. Use GetSessionEmbedUrl
// where you want to provide an authoring portal that allows users to create
// data sources, datasets, analyses, and dashboards. The users who access an
// embedded Amazon QuickSight console need belong to the author or admin security
// cohort. If you want to restrict permissions to some of these features, add
// a custom permissions profile to the user with the UpdateUser (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html)
// API operation. Use RegisterUser (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html)
// API operation to add a new user with a custom permission profile attached.
// For more information, see the following sections in the Amazon QuickSight
// User Guide:
//
//   - Embedding Analytics (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
//
//   - Customizing Access to the Amazon QuickSight Console (https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GetSessionEmbedUrl for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UserNotFoundException
//     The user with the provided name isn't found. This error can happen in any
//     operation that requires finding a user based on a provided user name, such
//     as DeleteUser, DescribeUser, and so on.
//
//   - SessionLifetimeInMinutesInvalidException
//     The number of minutes specified for the lifetime of a session isn't valid.
//     The session lifetime must be 15-600 minutes.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl
func (c *QuickSight) GetSessionEmbedUrl(input *GetSessionEmbedUrlInput) (*GetSessionEmbedUrlOutput, error) {
	req, out := c.GetSessionEmbedUrlRequest(input)
	return out, req.Send()
}

// GetSessionEmbedUrlWithContext is the same as GetSessionEmbedUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetSessionEmbedUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GetSessionEmbedUrlWithContext(ctx aws.Context, input *GetSessionEmbedUrlInput, opts ...request.Option) (*GetSessionEmbedUrlOutput, error) {
	req, out := c.GetSessionEmbedUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAnalyses = "ListAnalyses"

// ListAnalysesRequest generates a "aws/request.Request" representing the
// client's request for the ListAnalyses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnalyses for more information on using the ListAnalyses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAnalysesRequest method.
//	req, resp := client.ListAnalysesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses
func (c *QuickSight) ListAnalysesRequest(input *ListAnalysesInput) (req *request.Request, output *ListAnalysesOutput) {
	op := &request.Operation{
		Name:       opListAnalyses,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnalysesInput{}
	}

	output = &ListAnalysesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnalyses API operation for Amazon QuickSight.
//
// Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListAnalyses for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses
func (c *QuickSight) ListAnalyses(input *ListAnalysesInput) (*ListAnalysesOutput, error) {
	req, out := c.ListAnalysesRequest(input)
	return out, req.Send()
}

// ListAnalysesWithContext is the same as ListAnalyses with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnalyses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAnalysesWithContext(ctx aws.Context, input *ListAnalysesInput, opts ...request.Option) (*ListAnalysesOutput, error) {
	req, out := c.ListAnalysesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnalysesPages iterates over the pages of a ListAnalyses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnalyses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAnalyses operation.
//	pageNum := 0
//	err := client.ListAnalysesPages(params,
//	    func(page *quicksight.ListAnalysesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListAnalysesPages(input *ListAnalysesInput, fn func(*ListAnalysesOutput, bool) bool) error {
	return c.ListAnalysesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnalysesPagesWithContext same as ListAnalysesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAnalysesPagesWithContext(ctx aws.Context, input *ListAnalysesInput, fn func(*ListAnalysesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnalysesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnalysesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnalysesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssetBundleExportJobs = "ListAssetBundleExportJobs"

// ListAssetBundleExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssetBundleExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssetBundleExportJobs for more information on using the ListAssetBundleExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAssetBundleExportJobsRequest method.
//	req, resp := client.ListAssetBundleExportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAssetBundleExportJobs
func (c *QuickSight) ListAssetBundleExportJobsRequest(input *ListAssetBundleExportJobsInput) (req *request.Request, output *ListAssetBundleExportJobsOutput) {
	op := &request.Operation{
		Name:       opListAssetBundleExportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/asset-bundle-export-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetBundleExportJobsInput{}
	}

	output = &ListAssetBundleExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssetBundleExportJobs API operation for Amazon QuickSight.
//
// Lists all asset bundle export jobs that have been taken place in the last
// 14 days. Jobs created more than 14 days ago are deleted forever and are not
// returned. If you are using the same job ID for multiple jobs, ListAssetBundleExportJobs
// only returns the most recent job that uses the repeated job ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListAssetBundleExportJobs for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAssetBundleExportJobs
func (c *QuickSight) ListAssetBundleExportJobs(input *ListAssetBundleExportJobsInput) (*ListAssetBundleExportJobsOutput, error) {
	req, out := c.ListAssetBundleExportJobsRequest(input)
	return out, req.Send()
}

// ListAssetBundleExportJobsWithContext is the same as ListAssetBundleExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssetBundleExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAssetBundleExportJobsWithContext(ctx aws.Context, input *ListAssetBundleExportJobsInput, opts ...request.Option) (*ListAssetBundleExportJobsOutput, error) {
	req, out := c.ListAssetBundleExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetBundleExportJobsPages iterates over the pages of a ListAssetBundleExportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssetBundleExportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAssetBundleExportJobs operation.
//	pageNum := 0
//	err := client.ListAssetBundleExportJobsPages(params,
//	    func(page *quicksight.ListAssetBundleExportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListAssetBundleExportJobsPages(input *ListAssetBundleExportJobsInput, fn func(*ListAssetBundleExportJobsOutput, bool) bool) error {
	return c.ListAssetBundleExportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetBundleExportJobsPagesWithContext same as ListAssetBundleExportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAssetBundleExportJobsPagesWithContext(ctx aws.Context, input *ListAssetBundleExportJobsInput, fn func(*ListAssetBundleExportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetBundleExportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetBundleExportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetBundleExportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssetBundleImportJobs = "ListAssetBundleImportJobs"

// ListAssetBundleImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssetBundleImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssetBundleImportJobs for more information on using the ListAssetBundleImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAssetBundleImportJobsRequest method.
//	req, resp := client.ListAssetBundleImportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAssetBundleImportJobs
func (c *QuickSight) ListAssetBundleImportJobsRequest(input *ListAssetBundleImportJobsInput) (req *request.Request, output *ListAssetBundleImportJobsOutput) {
	op := &request.Operation{
		Name:       opListAssetBundleImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/asset-bundle-import-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetBundleImportJobsInput{}
	}

	output = &ListAssetBundleImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssetBundleImportJobs API operation for Amazon QuickSight.
//
// Lists all asset bundle import jobs that have taken place in the last 14 days.
// Jobs created more than 14 days ago are deleted forever and are not returned.
// If you are using the same job ID for multiple jobs, ListAssetBundleImportJobs
// only returns the most recent job that uses the repeated job ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListAssetBundleImportJobs for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAssetBundleImportJobs
func (c *QuickSight) ListAssetBundleImportJobs(input *ListAssetBundleImportJobsInput) (*ListAssetBundleImportJobsOutput, error) {
	req, out := c.ListAssetBundleImportJobsRequest(input)
	return out, req.Send()
}

// ListAssetBundleImportJobsWithContext is the same as ListAssetBundleImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssetBundleImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAssetBundleImportJobsWithContext(ctx aws.Context, input *ListAssetBundleImportJobsInput, opts ...request.Option) (*ListAssetBundleImportJobsOutput, error) {
	req, out := c.ListAssetBundleImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetBundleImportJobsPages iterates over the pages of a ListAssetBundleImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssetBundleImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAssetBundleImportJobs operation.
//	pageNum := 0
//	err := client.ListAssetBundleImportJobsPages(params,
//	    func(page *quicksight.ListAssetBundleImportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListAssetBundleImportJobsPages(input *ListAssetBundleImportJobsInput, fn func(*ListAssetBundleImportJobsOutput, bool) bool) error {
	return c.ListAssetBundleImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetBundleImportJobsPagesWithContext same as ListAssetBundleImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAssetBundleImportJobsPagesWithContext(ctx aws.Context, input *ListAssetBundleImportJobsInput, fn func(*ListAssetBundleImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetBundleImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetBundleImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetBundleImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDashboardVersions = "ListDashboardVersions"

// ListDashboardVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboardVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboardVersions for more information on using the ListDashboardVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDashboardVersionsRequest method.
//	req, resp := client.ListDashboardVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions
func (c *QuickSight) ListDashboardVersionsRequest(input *ListDashboardVersionsInput) (req *request.Request, output *ListDashboardVersionsOutput) {
	op := &request.Operation{
		Name:       opListDashboardVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardVersionsInput{}
	}

	output = &ListDashboardVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboardVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the dashboards in the Amazon QuickSight subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDashboardVersions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions
func (c *QuickSight) ListDashboardVersions(input *ListDashboardVersionsInput) (*ListDashboardVersionsOutput, error) {
	req, out := c.ListDashboardVersionsRequest(input)
	return out, req.Send()
}

// ListDashboardVersionsWithContext is the same as ListDashboardVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboardVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardVersionsWithContext(ctx aws.Context, input *ListDashboardVersionsInput, opts ...request.Option) (*ListDashboardVersionsOutput, error) {
	req, out := c.ListDashboardVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardVersionsPages iterates over the pages of a ListDashboardVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboardVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDashboardVersions operation.
//	pageNum := 0
//	err := client.ListDashboardVersionsPages(params,
//	    func(page *quicksight.ListDashboardVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListDashboardVersionsPages(input *ListDashboardVersionsInput, fn func(*ListDashboardVersionsOutput, bool) bool) error {
	return c.ListDashboardVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardVersionsPagesWithContext same as ListDashboardVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardVersionsPagesWithContext(ctx aws.Context, input *ListDashboardVersionsInput, fn func(*ListDashboardVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDashboards = "ListDashboards"

// ListDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboards for more information on using the ListDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDashboardsRequest method.
//	req, resp := client.ListDashboardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards
func (c *QuickSight) ListDashboardsRequest(input *ListDashboardsInput) (req *request.Request, output *ListDashboardsOutput) {
	op := &request.Operation{
		Name:       opListDashboards,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardsInput{}
	}

	output = &ListDashboardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboards API operation for Amazon QuickSight.
//
// Lists dashboards in an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDashboards for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards
func (c *QuickSight) ListDashboards(input *ListDashboardsInput) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	return out, req.Send()
}

// ListDashboardsWithContext is the same as ListDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardsWithContext(ctx aws.Context, input *ListDashboardsInput, opts ...request.Option) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardsPages iterates over the pages of a ListDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDashboards operation.
//	pageNum := 0
//	err := client.ListDashboardsPages(params,
//	    func(page *quicksight.ListDashboardsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListDashboardsPages(input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool) error {
	return c.ListDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardsPagesWithContext same as ListDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardsPagesWithContext(ctx aws.Context, input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSets = "ListDataSets"

// ListDataSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSets for more information on using the ListDataSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSetsRequest method.
//	req, resp := client.ListDataSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets
func (c *QuickSight) ListDataSetsRequest(input *ListDataSetsInput) (req *request.Request, output *ListDataSetsOutput) {
	op := &request.Operation{
		Name:       opListDataSets,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetsInput{}
	}

	output = &ListDataSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSets API operation for Amazon QuickSight.
//
// Lists all of the datasets belonging to the current Amazon Web Services account
// in an Amazon Web Services Region.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/*.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDataSets for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets
func (c *QuickSight) ListDataSets(input *ListDataSetsInput) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	return out, req.Send()
}

// ListDataSetsWithContext is the same as ListDataSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSetsWithContext(ctx aws.Context, input *ListDataSetsInput, opts ...request.Option) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSetsPages iterates over the pages of a ListDataSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSets operation.
//	pageNum := 0
//	err := client.ListDataSetsPages(params,
//	    func(page *quicksight.ListDataSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListDataSetsPages(input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool) error {
	return c.ListDataSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSetsPagesWithContext same as ListDataSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSetsPagesWithContext(ctx aws.Context, input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourcesRequest method.
//	req, resp := client.ListDataSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources
func (c *QuickSight) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for Amazon QuickSight.
//
// Lists data sources in current Amazon Web Services Region that belong to this
// Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources
func (c *QuickSight) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSources operation.
//	pageNum := 0
//	err := client.ListDataSourcesPages(params,
//	    func(page *quicksight.ListDataSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFolderMembers = "ListFolderMembers"

// ListFolderMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListFolderMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFolderMembers for more information on using the ListFolderMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFolderMembersRequest method.
//	req, resp := client.ListFolderMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolderMembers
func (c *QuickSight) ListFolderMembersRequest(input *ListFolderMembersInput) (req *request.Request, output *ListFolderMembersOutput) {
	op := &request.Operation{
		Name:       opListFolderMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFolderMembersInput{}
	}

	output = &ListFolderMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFolderMembers API operation for Amazon QuickSight.
//
// List all assets (DASHBOARD, ANALYSIS, and DATASET) in a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListFolderMembers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolderMembers
func (c *QuickSight) ListFolderMembers(input *ListFolderMembersInput) (*ListFolderMembersOutput, error) {
	req, out := c.ListFolderMembersRequest(input)
	return out, req.Send()
}

// ListFolderMembersWithContext is the same as ListFolderMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListFolderMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListFolderMembersWithContext(ctx aws.Context, input *ListFolderMembersInput, opts ...request.Option) (*ListFolderMembersOutput, error) {
	req, out := c.ListFolderMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFolderMembersPages iterates over the pages of a ListFolderMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFolderMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFolderMembers operation.
//	pageNum := 0
//	err := client.ListFolderMembersPages(params,
//	    func(page *quicksight.ListFolderMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListFolderMembersPages(input *ListFolderMembersInput, fn func(*ListFolderMembersOutput, bool) bool) error {
	return c.ListFolderMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFolderMembersPagesWithContext same as ListFolderMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListFolderMembersPagesWithContext(ctx aws.Context, input *ListFolderMembersInput, fn func(*ListFolderMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFolderMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFolderMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFolderMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFolders = "ListFolders"

// ListFoldersRequest generates a "aws/request.Request" representing the
// client's request for the ListFolders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFolders for more information on using the ListFolders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFoldersRequest method.
//	req, resp := client.ListFoldersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolders
func (c *QuickSight) ListFoldersRequest(input *ListFoldersInput) (req *request.Request, output *ListFoldersOutput) {
	op := &request.Operation{
		Name:       opListFolders,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFoldersInput{}
	}

	output = &ListFoldersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFolders API operation for Amazon QuickSight.
//
// Lists all folders in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListFolders for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolders
func (c *QuickSight) ListFolders(input *ListFoldersInput) (*ListFoldersOutput, error) {
	req, out := c.ListFoldersRequest(input)
	return out, req.Send()
}

// ListFoldersWithContext is the same as ListFolders with the addition of
// the ability to pass a context and additional request options.
//
// See ListFolders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListFoldersWithContext(ctx aws.Context, input *ListFoldersInput, opts ...request.Option) (*ListFoldersOutput, error) {
	req, out := c.ListFoldersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFoldersPages iterates over the pages of a ListFolders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFolders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFolders operation.
//	pageNum := 0
//	err := client.ListFoldersPages(params,
//	    func(page *quicksight.ListFoldersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListFoldersPages(input *ListFoldersInput, fn func(*ListFoldersOutput, bool) bool) error {
	return c.ListFoldersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFoldersPagesWithContext same as ListFoldersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListFoldersPagesWithContext(ctx aws.Context, input *ListFoldersInput, fn func(*ListFoldersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFoldersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFoldersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFoldersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroupMemberships = "ListGroupMemberships"

// ListGroupMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupMemberships for more information on using the ListGroupMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGroupMembershipsRequest method.
//	req, resp := client.ListGroupMembershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMembershipsRequest(input *ListGroupMembershipsInput) (req *request.Request, output *ListGroupMembershipsOutput) {
	op := &request.Operation{
		Name:       opListGroupMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupMembershipsInput{}
	}

	output = &ListGroupMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupMemberships API operation for Amazon QuickSight.
//
// Lists member users in a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroupMemberships for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMemberships(input *ListGroupMembershipsInput) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	return out, req.Send()
}

// ListGroupMembershipsWithContext is the same as ListGroupMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupMembershipsWithContext(ctx aws.Context, input *ListGroupMembershipsInput, opts ...request.Option) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupMembershipsPages iterates over the pages of a ListGroupMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroupMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGroupMemberships operation.
//	pageNum := 0
//	err := client.ListGroupMembershipsPages(params,
//	    func(page *quicksight.ListGroupMembershipsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListGroupMembershipsPages(input *ListGroupMembershipsInput, fn func(*ListGroupMembershipsOutput, bool) bool) error {
	return c.ListGroupMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupMembershipsPagesWithContext same as ListGroupMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupMembershipsPagesWithContext(ctx aws.Context, input *ListGroupMembershipsInput, fn func(*ListGroupMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGroupsRequest method.
//	req, resp := client.ListGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for Amazon QuickSight.
//
// Lists all user groups in Amazon QuickSight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroups for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupsPages iterates over the pages of a ListGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGroups operation.
//	pageNum := 0
//	err := client.ListGroupsPages(params,
//	    func(page *quicksight.ListGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListGroupsPages(input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool) error {
	return c.ListGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupsPagesWithContext same as ListGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupsPagesWithContext(ctx aws.Context, input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIAMPolicyAssignments = "ListIAMPolicyAssignments"

// ListIAMPolicyAssignmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListIAMPolicyAssignments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIAMPolicyAssignments for more information on using the ListIAMPolicyAssignments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIAMPolicyAssignmentsRequest method.
//	req, resp := client.ListIAMPolicyAssignmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments
func (c *QuickSight) ListIAMPolicyAssignmentsRequest(input *ListIAMPolicyAssignmentsInput) (req *request.Request, output *ListIAMPolicyAssignmentsOutput) {
	op := &request.Operation{
		Name:       opListIAMPolicyAssignments,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/v2/iam-policy-assignments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIAMPolicyAssignmentsInput{}
	}

	output = &ListIAMPolicyAssignmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIAMPolicyAssignments API operation for Amazon QuickSight.
//
// Lists the IAM policy assignments in the current Amazon QuickSight account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIAMPolicyAssignments for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments
func (c *QuickSight) ListIAMPolicyAssignments(input *ListIAMPolicyAssignmentsInput) (*ListIAMPolicyAssignmentsOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsRequest(input)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsWithContext is the same as ListIAMPolicyAssignments with the addition of
// the ability to pass a context and additional request options.
//
// See ListIAMPolicyAssignments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsInput, opts ...request.Option) (*ListIAMPolicyAssignmentsOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsPages iterates over the pages of a ListIAMPolicyAssignments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIAMPolicyAssignments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIAMPolicyAssignments operation.
//	pageNum := 0
//	err := client.ListIAMPolicyAssignmentsPages(params,
//	    func(page *quicksight.ListIAMPolicyAssignmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListIAMPolicyAssignmentsPages(input *ListIAMPolicyAssignmentsInput, fn func(*ListIAMPolicyAssignmentsOutput, bool) bool) error {
	return c.ListIAMPolicyAssignmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIAMPolicyAssignmentsPagesWithContext same as ListIAMPolicyAssignmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsPagesWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsInput, fn func(*ListIAMPolicyAssignmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIAMPolicyAssignmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIAMPolicyAssignmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIAMPolicyAssignmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIAMPolicyAssignmentsForUser = "ListIAMPolicyAssignmentsForUser"

// ListIAMPolicyAssignmentsForUserRequest generates a "aws/request.Request" representing the
// client's request for the ListIAMPolicyAssignmentsForUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIAMPolicyAssignmentsForUser for more information on using the ListIAMPolicyAssignmentsForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIAMPolicyAssignmentsForUserRequest method.
//	req, resp := client.ListIAMPolicyAssignmentsForUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser
func (c *QuickSight) ListIAMPolicyAssignmentsForUserRequest(input *ListIAMPolicyAssignmentsForUserInput) (req *request.Request, output *ListIAMPolicyAssignmentsForUserOutput) {
	op := &request.Operation{
		Name:       opListIAMPolicyAssignmentsForUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/iam-policy-assignments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIAMPolicyAssignmentsForUserInput{}
	}

	output = &ListIAMPolicyAssignmentsForUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIAMPolicyAssignmentsForUser API operation for Amazon QuickSight.
//
// Lists all of the IAM policy assignments, including the Amazon Resource Names
// (ARNs), for the IAM policies assigned to the specified user and group, or
// groups that the user belongs to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIAMPolicyAssignmentsForUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConcurrentUpdatingException
//     A resource is already in a state that indicates an operation is happening
//     that must complete before a new update can be applied.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser
func (c *QuickSight) ListIAMPolicyAssignmentsForUser(input *ListIAMPolicyAssignmentsForUserInput) (*ListIAMPolicyAssignmentsForUserOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsForUserRequest(input)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsForUserWithContext is the same as ListIAMPolicyAssignmentsForUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListIAMPolicyAssignmentsForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsForUserWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsForUserInput, opts ...request.Option) (*ListIAMPolicyAssignmentsForUserOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsForUserPages iterates over the pages of a ListIAMPolicyAssignmentsForUser operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIAMPolicyAssignmentsForUser method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIAMPolicyAssignmentsForUser operation.
//	pageNum := 0
//	err := client.ListIAMPolicyAssignmentsForUserPages(params,
//	    func(page *quicksight.ListIAMPolicyAssignmentsForUserOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListIAMPolicyAssignmentsForUserPages(input *ListIAMPolicyAssignmentsForUserInput, fn func(*ListIAMPolicyAssignmentsForUserOutput, bool) bool) error {
	return c.ListIAMPolicyAssignmentsForUserPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIAMPolicyAssignmentsForUserPagesWithContext same as ListIAMPolicyAssignmentsForUserPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsForUserPagesWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsForUserInput, fn func(*ListIAMPolicyAssignmentsForUserOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIAMPolicyAssignmentsForUserInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIAMPolicyAssignmentsForUserRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIAMPolicyAssignmentsForUserOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdentityPropagationConfigs = "ListIdentityPropagationConfigs"

// ListIdentityPropagationConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityPropagationConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityPropagationConfigs for more information on using the ListIdentityPropagationConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdentityPropagationConfigsRequest method.
//	req, resp := client.ListIdentityPropagationConfigsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIdentityPropagationConfigs
func (c *QuickSight) ListIdentityPropagationConfigsRequest(input *ListIdentityPropagationConfigsInput) (req *request.Request, output *ListIdentityPropagationConfigsOutput) {
	op := &request.Operation{
		Name:       opListIdentityPropagationConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/identity-propagation-config",
	}

	if input == nil {
		input = &ListIdentityPropagationConfigsInput{}
	}

	output = &ListIdentityPropagationConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityPropagationConfigs API operation for Amazon QuickSight.
//
// Lists all services and authorized targets that the Amazon QuickSight IAM
// Identity Center application can access.
//
// This operation is only supported for Amazon QuickSight accounts that use
// IAM Identity Center.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIdentityPropagationConfigs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIdentityPropagationConfigs
func (c *QuickSight) ListIdentityPropagationConfigs(input *ListIdentityPropagationConfigsInput) (*ListIdentityPropagationConfigsOutput, error) {
	req, out := c.ListIdentityPropagationConfigsRequest(input)
	return out, req.Send()
}

// ListIdentityPropagationConfigsWithContext is the same as ListIdentityPropagationConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityPropagationConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIdentityPropagationConfigsWithContext(ctx aws.Context, input *ListIdentityPropagationConfigsInput, opts ...request.Option) (*ListIdentityPropagationConfigsOutput, error) {
	req, out := c.ListIdentityPropagationConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIngestions = "ListIngestions"

// ListIngestionsRequest generates a "aws/request.Request" representing the
// client's request for the ListIngestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIngestions for more information on using the ListIngestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIngestionsRequest method.
//	req, resp := client.ListIngestionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions
func (c *QuickSight) ListIngestionsRequest(input *ListIngestionsInput) (req *request.Request, output *ListIngestionsOutput) {
	op := &request.Operation{
		Name:       opListIngestions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngestionsInput{}
	}

	output = &ListIngestionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIngestions API operation for Amazon QuickSight.
//
// Lists the history of SPICE ingestions for a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIngestions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions
func (c *QuickSight) ListIngestions(input *ListIngestionsInput) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	return out, req.Send()
}

// ListIngestionsWithContext is the same as ListIngestions with the addition of
// the ability to pass a context and additional request options.
//
// See ListIngestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIngestionsWithContext(ctx aws.Context, input *ListIngestionsInput, opts ...request.Option) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIngestionsPages iterates over the pages of a ListIngestions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIngestions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIngestions operation.
//	pageNum := 0
//	err := client.ListIngestionsPages(params,
//	    func(page *quicksight.ListIngestionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListIngestionsPages(input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool) error {
	return c.ListIngestionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIngestionsPagesWithContext same as ListIngestionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIngestionsPagesWithContext(ctx aws.Context, input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIngestionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIngestionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIngestionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNamespaces = "ListNamespaces"

// ListNamespacesRequest generates a "aws/request.Request" representing the
// client's request for the ListNamespaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamespaces for more information on using the ListNamespaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNamespacesRequest method.
//	req, resp := client.ListNamespacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces
func (c *QuickSight) ListNamespacesRequest(input *ListNamespacesInput) (req *request.Request, output *ListNamespacesOutput) {
	op := &request.Operation{
		Name:       opListNamespaces,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNamespacesInput{}
	}

	output = &ListNamespacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamespaces API operation for Amazon QuickSight.
//
// Lists the namespaces for the specified Amazon Web Services account. This
// operation doesn't list deleted namespaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListNamespaces for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces
func (c *QuickSight) ListNamespaces(input *ListNamespacesInput) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	return out, req.Send()
}

// ListNamespacesWithContext is the same as ListNamespaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamespaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListNamespacesWithContext(ctx aws.Context, input *ListNamespacesInput, opts ...request.Option) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNamespacesPages iterates over the pages of a ListNamespaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNamespaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNamespaces operation.
//	pageNum := 0
//	err := client.ListNamespacesPages(params,
//	    func(page *quicksight.ListNamespacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListNamespacesPages(input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool) error {
	return c.ListNamespacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNamespacesPagesWithContext same as ListNamespacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListNamespacesPagesWithContext(ctx aws.Context, input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNamespacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNamespacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNamespacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRefreshSchedules = "ListRefreshSchedules"

// ListRefreshSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRefreshSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRefreshSchedules for more information on using the ListRefreshSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRefreshSchedulesRequest method.
//	req, resp := client.ListRefreshSchedulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListRefreshSchedules
func (c *QuickSight) ListRefreshSchedulesRequest(input *ListRefreshSchedulesInput) (req *request.Request, output *ListRefreshSchedulesOutput) {
	op := &request.Operation{
		Name:       opListRefreshSchedules,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules",
	}

	if input == nil {
		input = &ListRefreshSchedulesInput{}
	}

	output = &ListRefreshSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRefreshSchedules API operation for Amazon QuickSight.
//
// Lists the refresh schedules of a dataset. Each dataset can have up to 5 schedules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListRefreshSchedules for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListRefreshSchedules
func (c *QuickSight) ListRefreshSchedules(input *ListRefreshSchedulesInput) (*ListRefreshSchedulesOutput, error) {
	req, out := c.ListRefreshSchedulesRequest(input)
	return out, req.Send()
}

// ListRefreshSchedulesWithContext is the same as ListRefreshSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRefreshSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListRefreshSchedulesWithContext(ctx aws.Context, input *ListRefreshSchedulesInput, opts ...request.Option) (*ListRefreshSchedulesOutput, error) {
	req, out := c.ListRefreshSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRoleMemberships = "ListRoleMemberships"

// ListRoleMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListRoleMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoleMemberships for more information on using the ListRoleMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRoleMembershipsRequest method.
//	req, resp := client.ListRoleMembershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListRoleMemberships
func (c *QuickSight) ListRoleMembershipsRequest(input *ListRoleMembershipsInput) (req *request.Request, output *ListRoleMembershipsOutput) {
	op := &request.Operation{
		Name:       opListRoleMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoleMembershipsInput{}
	}

	output = &ListRoleMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoleMemberships API operation for Amazon QuickSight.
//
// Lists all groups that are associated with a role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListRoleMemberships for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListRoleMemberships
func (c *QuickSight) ListRoleMemberships(input *ListRoleMembershipsInput) (*ListRoleMembershipsOutput, error) {
	req, out := c.ListRoleMembershipsRequest(input)
	return out, req.Send()
}

// ListRoleMembershipsWithContext is the same as ListRoleMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoleMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListRoleMembershipsWithContext(ctx aws.Context, input *ListRoleMembershipsInput, opts ...request.Option) (*ListRoleMembershipsOutput, error) {
	req, out := c.ListRoleMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoleMembershipsPages iterates over the pages of a ListRoleMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoleMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRoleMemberships operation.
//	pageNum := 0
//	err := client.ListRoleMembershipsPages(params,
//	    func(page *quicksight.ListRoleMembershipsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListRoleMembershipsPages(input *ListRoleMembershipsInput, fn func(*ListRoleMembershipsOutput, bool) bool) error {
	return c.ListRoleMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoleMembershipsPagesWithContext same as ListRoleMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListRoleMembershipsPagesWithContext(ctx aws.Context, input *ListRoleMembershipsInput, fn func(*ListRoleMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoleMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoleMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoleMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource
func (c *QuickSight) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon QuickSight.
//
// Lists the tags assigned to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource
func (c *QuickSight) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplateAliases = "ListTemplateAliases"

// ListTemplateAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateAliases for more information on using the ListTemplateAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplateAliasesRequest method.
//	req, resp := client.ListTemplateAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases
func (c *QuickSight) ListTemplateAliasesRequest(input *ListTemplateAliasesInput) (req *request.Request, output *ListTemplateAliasesOutput) {
	op := &request.Operation{
		Name:       opListTemplateAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateAliasesInput{}
	}

	output = &ListTemplateAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateAliases API operation for Amazon QuickSight.
//
// Lists all the aliases of a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplateAliases for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases
func (c *QuickSight) ListTemplateAliases(input *ListTemplateAliasesInput) (*ListTemplateAliasesOutput, error) {
	req, out := c.ListTemplateAliasesRequest(input)
	return out, req.Send()
}

// ListTemplateAliasesWithContext is the same as ListTemplateAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateAliasesWithContext(ctx aws.Context, input *ListTemplateAliasesInput, opts ...request.Option) (*ListTemplateAliasesOutput, error) {
	req, out := c.ListTemplateAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateAliasesPages iterates over the pages of a ListTemplateAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplateAliases operation.
//	pageNum := 0
//	err := client.ListTemplateAliasesPages(params,
//	    func(page *quicksight.ListTemplateAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListTemplateAliasesPages(input *ListTemplateAliasesInput, fn func(*ListTemplateAliasesOutput, bool) bool) error {
	return c.ListTemplateAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateAliasesPagesWithContext same as ListTemplateAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateAliasesPagesWithContext(ctx aws.Context, input *ListTemplateAliasesInput, fn func(*ListTemplateAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplateVersions = "ListTemplateVersions"

// ListTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateVersions for more information on using the ListTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplateVersionsRequest method.
//	req, resp := client.ListTemplateVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions
func (c *QuickSight) ListTemplateVersionsRequest(input *ListTemplateVersionsInput) (req *request.Request, output *ListTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opListTemplateVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateVersionsInput{}
	}

	output = &ListTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the templates in the current Amazon QuickSight
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplateVersions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions
func (c *QuickSight) ListTemplateVersions(input *ListTemplateVersionsInput) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	return out, req.Send()
}

// ListTemplateVersionsWithContext is the same as ListTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateVersionsWithContext(ctx aws.Context, input *ListTemplateVersionsInput, opts ...request.Option) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateVersionsPages iterates over the pages of a ListTemplateVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplateVersions operation.
//	pageNum := 0
//	err := client.ListTemplateVersionsPages(params,
//	    func(page *quicksight.ListTemplateVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListTemplateVersionsPages(input *ListTemplateVersionsInput, fn func(*ListTemplateVersionsOutput, bool) bool) error {
	return c.ListTemplateVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateVersionsPagesWithContext same as ListTemplateVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateVersionsPagesWithContext(ctx aws.Context, input *ListTemplateVersionsInput, fn func(*ListTemplateVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplates for more information on using the ListTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplatesRequest method.
//	req, resp := client.ListTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates
func (c *QuickSight) ListTemplatesRequest(input *ListTemplatesInput) (req *request.Request, output *ListTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	output = &ListTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplates API operation for Amazon QuickSight.
//
// Lists all the templates in the current Amazon QuickSight account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates
func (c *QuickSight) ListTemplates(input *ListTemplatesInput) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	return out, req.Send()
}

// ListTemplatesWithContext is the same as ListTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplatesWithContext(ctx aws.Context, input *ListTemplatesInput, opts ...request.Option) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplatesPages iterates over the pages of a ListTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplates operation.
//	pageNum := 0
//	err := client.ListTemplatesPages(params,
//	    func(page *quicksight.ListTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListTemplatesPages(input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool) error {
	return c.ListTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplatesPagesWithContext same as ListTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplatesPagesWithContext(ctx aws.Context, input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListThemeAliases = "ListThemeAliases"

// ListThemeAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListThemeAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemeAliases for more information on using the ListThemeAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListThemeAliasesRequest method.
//	req, resp := client.ListThemeAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases
func (c *QuickSight) ListThemeAliasesRequest(input *ListThemeAliasesInput) (req *request.Request, output *ListThemeAliasesOutput) {
	op := &request.Operation{
		Name:       opListThemeAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases",
	}

	if input == nil {
		input = &ListThemeAliasesInput{}
	}

	output = &ListThemeAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemeAliases API operation for Amazon QuickSight.
//
// Lists all the aliases of a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListThemeAliases for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases
func (c *QuickSight) ListThemeAliases(input *ListThemeAliasesInput) (*ListThemeAliasesOutput, error) {
	req, out := c.ListThemeAliasesRequest(input)
	return out, req.Send()
}

// ListThemeAliasesWithContext is the same as ListThemeAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemeAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemeAliasesWithContext(ctx aws.Context, input *ListThemeAliasesInput, opts ...request.Option) (*ListThemeAliasesOutput, error) {
	req, out := c.ListThemeAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThemeVersions = "ListThemeVersions"

// ListThemeVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListThemeVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemeVersions for more information on using the ListThemeVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListThemeVersionsRequest method.
//	req, resp := client.ListThemeVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions
func (c *QuickSight) ListThemeVersionsRequest(input *ListThemeVersionsInput) (req *request.Request, output *ListThemeVersionsOutput) {
	op := &request.Operation{
		Name:       opListThemeVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThemeVersionsInput{}
	}

	output = &ListThemeVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemeVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the themes in the current Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListThemeVersions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions
func (c *QuickSight) ListThemeVersions(input *ListThemeVersionsInput) (*ListThemeVersionsOutput, error) {
	req, out := c.ListThemeVersionsRequest(input)
	return out, req.Send()
}

// ListThemeVersionsWithContext is the same as ListThemeVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemeVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemeVersionsWithContext(ctx aws.Context, input *ListThemeVersionsInput, opts ...request.Option) (*ListThemeVersionsOutput, error) {
	req, out := c.ListThemeVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThemeVersionsPages iterates over the pages of a ListThemeVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThemeVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListThemeVersions operation.
//	pageNum := 0
//	err := client.ListThemeVersionsPages(params,
//	    func(page *quicksight.ListThemeVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListThemeVersionsPages(input *ListThemeVersionsInput, fn func(*ListThemeVersionsOutput, bool) bool) error {
	return c.ListThemeVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThemeVersionsPagesWithContext same as ListThemeVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemeVersionsPagesWithContext(ctx aws.Context, input *ListThemeVersionsInput, fn func(*ListThemeVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThemeVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThemeVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListThemeVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListThemes = "ListThemes"

// ListThemesRequest generates a "aws/request.Request" representing the
// client's request for the ListThemes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemes for more information on using the ListThemes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListThemesRequest method.
//	req, resp := client.ListThemesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes
func (c *QuickSight) ListThemesRequest(input *ListThemesInput) (req *request.Request, output *ListThemesOutput) {
	op := &request.Operation{
		Name:       opListThemes,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThemesInput{}
	}

	output = &ListThemesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemes API operation for Amazon QuickSight.
//
// Lists all the themes in the current Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListThemes for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes
func (c *QuickSight) ListThemes(input *ListThemesInput) (*ListThemesOutput, error) {
	req, out := c.ListThemesRequest(input)
	return out, req.Send()
}

// ListThemesWithContext is the same as ListThemes with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemesWithContext(ctx aws.Context, input *ListThemesInput, opts ...request.Option) (*ListThemesOutput, error) {
	req, out := c.ListThemesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThemesPages iterates over the pages of a ListThemes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThemes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListThemes operation.
//	pageNum := 0
//	err := client.ListThemesPages(params,
//	    func(page *quicksight.ListThemesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListThemesPages(input *ListThemesInput, fn func(*ListThemesOutput, bool) bool) error {
	return c.ListThemesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThemesPagesWithContext same as ListThemesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemesPagesWithContext(ctx aws.Context, input *ListThemesInput, fn func(*ListThemesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThemesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThemesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListThemesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTopicRefreshSchedules = "ListTopicRefreshSchedules"

// ListTopicRefreshSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the ListTopicRefreshSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTopicRefreshSchedules for more information on using the ListTopicRefreshSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTopicRefreshSchedulesRequest method.
//	req, resp := client.ListTopicRefreshSchedulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTopicRefreshSchedules
func (c *QuickSight) ListTopicRefreshSchedulesRequest(input *ListTopicRefreshSchedulesInput) (req *request.Request, output *ListTopicRefreshSchedulesOutput) {
	op := &request.Operation{
		Name:       opListTopicRefreshSchedules,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}/schedules",
	}

	if input == nil {
		input = &ListTopicRefreshSchedulesInput{}
	}

	output = &ListTopicRefreshSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopicRefreshSchedules API operation for Amazon QuickSight.
//
// Lists all of the refresh schedules for a topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTopicRefreshSchedules for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTopicRefreshSchedules
func (c *QuickSight) ListTopicRefreshSchedules(input *ListTopicRefreshSchedulesInput) (*ListTopicRefreshSchedulesOutput, error) {
	req, out := c.ListTopicRefreshSchedulesRequest(input)
	return out, req.Send()
}

// ListTopicRefreshSchedulesWithContext is the same as ListTopicRefreshSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopicRefreshSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTopicRefreshSchedulesWithContext(ctx aws.Context, input *ListTopicRefreshSchedulesInput, opts ...request.Option) (*ListTopicRefreshSchedulesOutput, error) {
	req, out := c.ListTopicRefreshSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTopics = "ListTopics"

// ListTopicsRequest generates a "aws/request.Request" representing the
// client's request for the ListTopics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTopics for more information on using the ListTopics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTopicsRequest method.
//	req, resp := client.ListTopicsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTopics
func (c *QuickSight) ListTopicsRequest(input *ListTopicsInput) (req *request.Request, output *ListTopicsOutput) {
	op := &request.Operation{
		Name:       opListTopics,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/topics",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTopicsInput{}
	}

	output = &ListTopicsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopics API operation for Amazon QuickSight.
//
// Lists all of the topics within an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTopics for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTopics
func (c *QuickSight) ListTopics(input *ListTopicsInput) (*ListTopicsOutput, error) {
	req, out := c.ListTopicsRequest(input)
	return out, req.Send()
}

// ListTopicsWithContext is the same as ListTopics with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTopicsWithContext(ctx aws.Context, input *ListTopicsInput, opts ...request.Option) (*ListTopicsOutput, error) {
	req, out := c.ListTopicsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTopicsPages iterates over the pages of a ListTopics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTopics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTopics operation.
//	pageNum := 0
//	err := client.ListTopicsPages(params,
//	    func(page *quicksight.ListTopicsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListTopicsPages(input *ListTopicsInput, fn func(*ListTopicsOutput, bool) bool) error {
	return c.ListTopicsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTopicsPagesWithContext same as ListTopicsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTopicsPagesWithContext(ctx aws.Context, input *ListTopicsInput, fn func(*ListTopicsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTopicsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTopicsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTopicsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserGroups = "ListUserGroups"

// ListUserGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserGroups for more information on using the ListUserGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUserGroupsRequest method.
//	req, resp := client.ListUserGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroupsRequest(input *ListUserGroupsInput) (req *request.Request, output *ListUserGroupsOutput) {
	op := &request.Operation{
		Name:       opListUserGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserGroupsInput{}
	}

	output = &ListUserGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserGroups API operation for Amazon QuickSight.
//
// Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member
// of.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUserGroups for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroups(input *ListUserGroupsInput) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	return out, req.Send()
}

// ListUserGroupsWithContext is the same as ListUserGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUserGroupsWithContext(ctx aws.Context, input *ListUserGroupsInput, opts ...request.Option) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserGroupsPages iterates over the pages of a ListUserGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUserGroups operation.
//	pageNum := 0
//	err := client.ListUserGroupsPages(params,
//	    func(page *quicksight.ListUserGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListUserGroupsPages(input *ListUserGroupsInput, fn func(*ListUserGroupsOutput, bool) bool) error {
	return c.ListUserGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserGroupsPagesWithContext same as ListUserGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUserGroupsPagesWithContext(ctx aws.Context, input *ListUserGroupsInput, fn func(*ListUserGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUsersRequest method.
//	req, resp := client.ListUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon QuickSight.
//
// Returns a list of all of the Amazon QuickSight users belonging to this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUsers operation.
//	pageNum := 0
//	err := client.ListUsersPages(params,
//	    func(page *quicksight.ListUsersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVPCConnections = "ListVPCConnections"

// ListVPCConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListVPCConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVPCConnections for more information on using the ListVPCConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVPCConnectionsRequest method.
//	req, resp := client.ListVPCConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListVPCConnections
func (c *QuickSight) ListVPCConnectionsRequest(input *ListVPCConnectionsInput) (req *request.Request, output *ListVPCConnectionsOutput) {
	op := &request.Operation{
		Name:       opListVPCConnections,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/vpc-connections",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVPCConnectionsInput{}
	}

	output = &ListVPCConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVPCConnections API operation for Amazon QuickSight.
//
// Lists all of the VPC connections in the current set Amazon Web Services Region
// of an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListVPCConnections for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListVPCConnections
func (c *QuickSight) ListVPCConnections(input *ListVPCConnectionsInput) (*ListVPCConnectionsOutput, error) {
	req, out := c.ListVPCConnectionsRequest(input)
	return out, req.Send()
}

// ListVPCConnectionsWithContext is the same as ListVPCConnections with the addition of
// the ability to pass a context and additional request options.
//
// See ListVPCConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListVPCConnectionsWithContext(ctx aws.Context, input *ListVPCConnectionsInput, opts ...request.Option) (*ListVPCConnectionsOutput, error) {
	req, out := c.ListVPCConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVPCConnectionsPages iterates over the pages of a ListVPCConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVPCConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVPCConnections operation.
//	pageNum := 0
//	err := client.ListVPCConnectionsPages(params,
//	    func(page *quicksight.ListVPCConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListVPCConnectionsPages(input *ListVPCConnectionsInput, fn func(*ListVPCConnectionsOutput, bool) bool) error {
	return c.ListVPCConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVPCConnectionsPagesWithContext same as ListVPCConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListVPCConnectionsPagesWithContext(ctx aws.Context, input *ListVPCConnectionsInput, fn func(*ListVPCConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVPCConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVPCConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVPCConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutDataSetRefreshProperties = "PutDataSetRefreshProperties"

// PutDataSetRefreshPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the PutDataSetRefreshProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDataSetRefreshProperties for more information on using the PutDataSetRefreshProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutDataSetRefreshPropertiesRequest method.
//	req, resp := client.PutDataSetRefreshPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/PutDataSetRefreshProperties
func (c *QuickSight) PutDataSetRefreshPropertiesRequest(input *PutDataSetRefreshPropertiesInput) (req *request.Request, output *PutDataSetRefreshPropertiesOutput) {
	op := &request.Operation{
		Name:       opPutDataSetRefreshProperties,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-properties",
	}

	if input == nil {
		input = &PutDataSetRefreshPropertiesInput{}
	}

	output = &PutDataSetRefreshPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutDataSetRefreshProperties API operation for Amazon QuickSight.
//
// Creates or updates the dataset refresh properties for the dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation PutDataSetRefreshProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/PutDataSetRefreshProperties
func (c *QuickSight) PutDataSetRefreshProperties(input *PutDataSetRefreshPropertiesInput) (*PutDataSetRefreshPropertiesOutput, error) {
	req, out := c.PutDataSetRefreshPropertiesRequest(input)
	return out, req.Send()
}

// PutDataSetRefreshPropertiesWithContext is the same as PutDataSetRefreshProperties with the addition of
// the ability to pass a context and additional request options.
//
// See PutDataSetRefreshProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) PutDataSetRefreshPropertiesWithContext(ctx aws.Context, input *PutDataSetRefreshPropertiesInput, opts ...request.Option) (*PutDataSetRefreshPropertiesOutput, error) {
	req, out := c.PutDataSetRefreshPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterUser = "RegisterUser"

// RegisterUserRequest generates a "aws/request.Request" representing the
// client's request for the RegisterUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterUser for more information on using the RegisterUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterUserRequest method.
//	req, resp := client.RegisterUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUserRequest(input *RegisterUserInput) (req *request.Request, output *RegisterUserOutput) {
	op := &request.Operation{
		Name:       opRegisterUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
	}

	if input == nil {
		input = &RegisterUserInput{}
	}

	output = &RegisterUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterUser API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight user whose identity is associated with the Identity
// and Access Management (IAM) identity or role specified in the request. When
// you register a new user from the Amazon QuickSight API, Amazon QuickSight
// generates a registration URL. The user accesses this registration URL to
// create their account. Amazon QuickSight doesn't send a registration email
// to users who are registered from the Amazon QuickSight API. If you want new
// users to receive a registration email, then add those users in the Amazon
// QuickSight console. For more information on registering a new user in the
// Amazon QuickSight console, see Inviting users to access Amazon QuickSight
// (https://docs.aws.amazon.com/quicksight/latest/user/managing-users.html#inviting-users).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation RegisterUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUser(input *RegisterUserInput) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	return out, req.Send()
}

// RegisterUserWithContext is the same as RegisterUser with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) RegisterUserWithContext(ctx aws.Context, input *RegisterUserInput, opts ...request.Option) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreAnalysis = "RestoreAnalysis"

// RestoreAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the RestoreAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreAnalysis for more information on using the RestoreAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreAnalysisRequest method.
//	req, resp := client.RestoreAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis
func (c *QuickSight) RestoreAnalysisRequest(input *RestoreAnalysisInput) (req *request.Request, output *RestoreAnalysisOutput) {
	op := &request.Operation{
		Name:       opRestoreAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/restore/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &RestoreAnalysisInput{}
	}

	output = &RestoreAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreAnalysis API operation for Amazon QuickSight.
//
// Restores an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation RestoreAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis
func (c *QuickSight) RestoreAnalysis(input *RestoreAnalysisInput) (*RestoreAnalysisOutput, error) {
	req, out := c.RestoreAnalysisRequest(input)
	return out, req.Send()
}

// RestoreAnalysisWithContext is the same as RestoreAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) RestoreAnalysisWithContext(ctx aws.Context, input *RestoreAnalysisInput, opts ...request.Option) (*RestoreAnalysisOutput, error) {
	req, out := c.RestoreAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchAnalyses = "SearchAnalyses"

// SearchAnalysesRequest generates a "aws/request.Request" representing the
// client's request for the SearchAnalyses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAnalyses for more information on using the SearchAnalyses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchAnalysesRequest method.
//	req, resp := client.SearchAnalysesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses
func (c *QuickSight) SearchAnalysesRequest(input *SearchAnalysesInput) (req *request.Request, output *SearchAnalysesOutput) {
	op := &request.Operation{
		Name:       opSearchAnalyses,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/analyses",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAnalysesInput{}
	}

	output = &SearchAnalysesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAnalyses API operation for Amazon QuickSight.
//
// Searches for analyses that belong to the user specified in the filter.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchAnalyses for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses
func (c *QuickSight) SearchAnalyses(input *SearchAnalysesInput) (*SearchAnalysesOutput, error) {
	req, out := c.SearchAnalysesRequest(input)
	return out, req.Send()
}

// SearchAnalysesWithContext is the same as SearchAnalyses with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAnalyses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchAnalysesWithContext(ctx aws.Context, input *SearchAnalysesInput, opts ...request.Option) (*SearchAnalysesOutput, error) {
	req, out := c.SearchAnalysesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchAnalysesPages iterates over the pages of a SearchAnalyses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchAnalyses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchAnalyses operation.
//	pageNum := 0
//	err := client.SearchAnalysesPages(params,
//	    func(page *quicksight.SearchAnalysesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchAnalysesPages(input *SearchAnalysesInput, fn func(*SearchAnalysesOutput, bool) bool) error {
	return c.SearchAnalysesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchAnalysesPagesWithContext same as SearchAnalysesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchAnalysesPagesWithContext(ctx aws.Context, input *SearchAnalysesInput, fn func(*SearchAnalysesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchAnalysesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchAnalysesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchAnalysesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchDashboards = "SearchDashboards"

// SearchDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the SearchDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDashboards for more information on using the SearchDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchDashboardsRequest method.
//	req, resp := client.SearchDashboardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards
func (c *QuickSight) SearchDashboardsRequest(input *SearchDashboardsInput) (req *request.Request, output *SearchDashboardsOutput) {
	op := &request.Operation{
		Name:       opSearchDashboards,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/dashboards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDashboardsInput{}
	}

	output = &SearchDashboardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDashboards API operation for Amazon QuickSight.
//
// Searches for dashboards that belong to a user.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchDashboards for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards
func (c *QuickSight) SearchDashboards(input *SearchDashboardsInput) (*SearchDashboardsOutput, error) {
	req, out := c.SearchDashboardsRequest(input)
	return out, req.Send()
}

// SearchDashboardsWithContext is the same as SearchDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDashboardsWithContext(ctx aws.Context, input *SearchDashboardsInput, opts ...request.Option) (*SearchDashboardsOutput, error) {
	req, out := c.SearchDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDashboardsPages iterates over the pages of a SearchDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchDashboards operation.
//	pageNum := 0
//	err := client.SearchDashboardsPages(params,
//	    func(page *quicksight.SearchDashboardsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchDashboardsPages(input *SearchDashboardsInput, fn func(*SearchDashboardsOutput, bool) bool) error {
	return c.SearchDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDashboardsPagesWithContext same as SearchDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDashboardsPagesWithContext(ctx aws.Context, input *SearchDashboardsInput, fn func(*SearchDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchDataSets = "SearchDataSets"

// SearchDataSetsRequest generates a "aws/request.Request" representing the
// client's request for the SearchDataSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDataSets for more information on using the SearchDataSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchDataSetsRequest method.
//	req, resp := client.SearchDataSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSets
func (c *QuickSight) SearchDataSetsRequest(input *SearchDataSetsInput) (req *request.Request, output *SearchDataSetsOutput) {
	op := &request.Operation{
		Name:       opSearchDataSets,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/data-sets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDataSetsInput{}
	}

	output = &SearchDataSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDataSets API operation for Amazon QuickSight.
//
// Use the SearchDataSets operation to search for datasets that belong to an
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchDataSets for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSets
func (c *QuickSight) SearchDataSets(input *SearchDataSetsInput) (*SearchDataSetsOutput, error) {
	req, out := c.SearchDataSetsRequest(input)
	return out, req.Send()
}

// SearchDataSetsWithContext is the same as SearchDataSets with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDataSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDataSetsWithContext(ctx aws.Context, input *SearchDataSetsInput, opts ...request.Option) (*SearchDataSetsOutput, error) {
	req, out := c.SearchDataSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDataSetsPages iterates over the pages of a SearchDataSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDataSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchDataSets operation.
//	pageNum := 0
//	err := client.SearchDataSetsPages(params,
//	    func(page *quicksight.SearchDataSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchDataSetsPages(input *SearchDataSetsInput, fn func(*SearchDataSetsOutput, bool) bool) error {
	return c.SearchDataSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDataSetsPagesWithContext same as SearchDataSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDataSetsPagesWithContext(ctx aws.Context, input *SearchDataSetsInput, fn func(*SearchDataSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDataSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDataSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDataSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchDataSources = "SearchDataSources"

// SearchDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the SearchDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDataSources for more information on using the SearchDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchDataSourcesRequest method.
//	req, resp := client.SearchDataSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSources
func (c *QuickSight) SearchDataSourcesRequest(input *SearchDataSourcesInput) (req *request.Request, output *SearchDataSourcesOutput) {
	op := &request.Operation{
		Name:       opSearchDataSources,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/data-sources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDataSourcesInput{}
	}

	output = &SearchDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDataSources API operation for Amazon QuickSight.
//
// Use the SearchDataSources operation to search for data sources that belong
// to an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchDataSources for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSources
func (c *QuickSight) SearchDataSources(input *SearchDataSourcesInput) (*SearchDataSourcesOutput, error) {
	req, out := c.SearchDataSourcesRequest(input)
	return out, req.Send()
}

// SearchDataSourcesWithContext is the same as SearchDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDataSourcesWithContext(ctx aws.Context, input *SearchDataSourcesInput, opts ...request.Option) (*SearchDataSourcesOutput, error) {
	req, out := c.SearchDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDataSourcesPages iterates over the pages of a SearchDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchDataSources operation.
//	pageNum := 0
//	err := client.SearchDataSourcesPages(params,
//	    func(page *quicksight.SearchDataSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchDataSourcesPages(input *SearchDataSourcesInput, fn func(*SearchDataSourcesOutput, bool) bool) error {
	return c.SearchDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDataSourcesPagesWithContext same as SearchDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDataSourcesPagesWithContext(ctx aws.Context, input *SearchDataSourcesInput, fn func(*SearchDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchFolders = "SearchFolders"

// SearchFoldersRequest generates a "aws/request.Request" representing the
// client's request for the SearchFolders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchFolders for more information on using the SearchFolders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchFoldersRequest method.
//	req, resp := client.SearchFoldersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchFolders
func (c *QuickSight) SearchFoldersRequest(input *SearchFoldersInput) (req *request.Request, output *SearchFoldersOutput) {
	op := &request.Operation{
		Name:       opSearchFolders,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/folders",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchFoldersInput{}
	}

	output = &SearchFoldersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchFolders API operation for Amazon QuickSight.
//
// Searches the subfolders in a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchFolders for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InvalidRequestException
//     You don't have this feature activated for your account. To fix this issue,
//     contact Amazon Web Services support.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchFolders
func (c *QuickSight) SearchFolders(input *SearchFoldersInput) (*SearchFoldersOutput, error) {
	req, out := c.SearchFoldersRequest(input)
	return out, req.Send()
}

// SearchFoldersWithContext is the same as SearchFolders with the addition of
// the ability to pass a context and additional request options.
//
// See SearchFolders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchFoldersWithContext(ctx aws.Context, input *SearchFoldersInput, opts ...request.Option) (*SearchFoldersOutput, error) {
	req, out := c.SearchFoldersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchFoldersPages iterates over the pages of a SearchFolders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchFolders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchFolders operation.
//	pageNum := 0
//	err := client.SearchFoldersPages(params,
//	    func(page *quicksight.SearchFoldersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchFoldersPages(input *SearchFoldersInput, fn func(*SearchFoldersOutput, bool) bool) error {
	return c.SearchFoldersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchFoldersPagesWithContext same as SearchFoldersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchFoldersPagesWithContext(ctx aws.Context, input *SearchFoldersInput, fn func(*SearchFoldersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchFoldersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchFoldersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchFoldersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchGroups = "SearchGroups"

// SearchGroupsRequest generates a "aws/request.Request" representing the
// client's request for the SearchGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchGroups for more information on using the SearchGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchGroupsRequest method.
//	req, resp := client.SearchGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchGroups
func (c *QuickSight) SearchGroupsRequest(input *SearchGroupsInput) (req *request.Request, output *SearchGroupsOutput) {
	op := &request.Operation{
		Name:       opSearchGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups-search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchGroupsInput{}
	}

	output = &SearchGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchGroups API operation for Amazon QuickSight.
//
// Use the SearchGroups operation to search groups in a specified Amazon QuickSight
// namespace using the supplied filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchGroups for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchGroups
func (c *QuickSight) SearchGroups(input *SearchGroupsInput) (*SearchGroupsOutput, error) {
	req, out := c.SearchGroupsRequest(input)
	return out, req.Send()
}

// SearchGroupsWithContext is the same as SearchGroups with the addition of
// the ability to pass a context and additional request options.
//
// See SearchGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchGroupsWithContext(ctx aws.Context, input *SearchGroupsInput, opts ...request.Option) (*SearchGroupsOutput, error) {
	req, out := c.SearchGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchGroupsPages iterates over the pages of a SearchGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchGroups operation.
//	pageNum := 0
//	err := client.SearchGroupsPages(params,
//	    func(page *quicksight.SearchGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchGroupsPages(input *SearchGroupsInput, fn func(*SearchGroupsOutput, bool) bool) error {
	return c.SearchGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchGroupsPagesWithContext same as SearchGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchGroupsPagesWithContext(ctx aws.Context, input *SearchGroupsInput, fn func(*SearchGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartAssetBundleExportJob = "StartAssetBundleExportJob"

// StartAssetBundleExportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartAssetBundleExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAssetBundleExportJob for more information on using the StartAssetBundleExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAssetBundleExportJobRequest method.
//	req, resp := client.StartAssetBundleExportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/StartAssetBundleExportJob
func (c *QuickSight) StartAssetBundleExportJobRequest(input *StartAssetBundleExportJobInput) (req *request.Request, output *StartAssetBundleExportJobOutput) {
	op := &request.Operation{
		Name:       opStartAssetBundleExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/asset-bundle-export-jobs/export",
	}

	if input == nil {
		input = &StartAssetBundleExportJobInput{}
	}

	output = &StartAssetBundleExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAssetBundleExportJob API operation for Amazon QuickSight.
//
// Starts an Asset Bundle export job.
//
// An Asset Bundle export job exports specified Amazon QuickSight assets. You
// can also choose to export any asset dependencies in the same job. Export
// jobs run asynchronously and can be polled with a DescribeAssetBundleExportJob
// API call. When a job is successfully completed, a download URL that contains
// the exported assets is returned. The URL is valid for 5 minutes and can be
// refreshed with a DescribeAssetBundleExportJob API call. Each Amazon QuickSight
// account can run up to 5 export jobs concurrently.
//
// The API caller must have the necessary permissions in their IAM role to access
// each resource before the resources can be exported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation StartAssetBundleExportJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/StartAssetBundleExportJob
func (c *QuickSight) StartAssetBundleExportJob(input *StartAssetBundleExportJobInput) (*StartAssetBundleExportJobOutput, error) {
	req, out := c.StartAssetBundleExportJobRequest(input)
	return out, req.Send()
}

// StartAssetBundleExportJobWithContext is the same as StartAssetBundleExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartAssetBundleExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) StartAssetBundleExportJobWithContext(ctx aws.Context, input *StartAssetBundleExportJobInput, opts ...request.Option) (*StartAssetBundleExportJobOutput, error) {
	req, out := c.StartAssetBundleExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAssetBundleImportJob = "StartAssetBundleImportJob"

// StartAssetBundleImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartAssetBundleImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAssetBundleImportJob for more information on using the StartAssetBundleImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAssetBundleImportJobRequest method.
//	req, resp := client.StartAssetBundleImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/StartAssetBundleImportJob
func (c *QuickSight) StartAssetBundleImportJobRequest(input *StartAssetBundleImportJobInput) (req *request.Request, output *StartAssetBundleImportJobOutput) {
	op := &request.Operation{
		Name:       opStartAssetBundleImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/asset-bundle-import-jobs/import",
	}

	if input == nil {
		input = &StartAssetBundleImportJobInput{}
	}

	output = &StartAssetBundleImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAssetBundleImportJob API operation for Amazon QuickSight.
//
// Starts an Asset Bundle import job.
//
// An Asset Bundle import job imports specified Amazon QuickSight assets into
// an Amazon QuickSight account. You can also choose to import a naming prefix
// and specified configuration overrides. The assets that are contained in the
// bundle file that you provide are used to create or update a new or existing
// asset in your Amazon QuickSight account. Each Amazon QuickSight account can
// run up to 5 import jobs concurrently.
//
// The API caller must have the necessary "create", "describe", and "update"
// permissions in their IAM role to access each resource type that is contained
// in the bundle file before the resources can be imported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation StartAssetBundleImportJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/StartAssetBundleImportJob
func (c *QuickSight) StartAssetBundleImportJob(input *StartAssetBundleImportJobInput) (*StartAssetBundleImportJobOutput, error) {
	req, out := c.StartAssetBundleImportJobRequest(input)
	return out, req.Send()
}

// StartAssetBundleImportJobWithContext is the same as StartAssetBundleImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartAssetBundleImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) StartAssetBundleImportJobWithContext(ctx aws.Context, input *StartAssetBundleImportJobInput, opts ...request.Option) (*StartAssetBundleImportJobOutput, error) {
	req, out := c.StartAssetBundleImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDashboardSnapshotJob = "StartDashboardSnapshotJob"

// StartDashboardSnapshotJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDashboardSnapshotJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDashboardSnapshotJob for more information on using the StartDashboardSnapshotJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDashboardSnapshotJobRequest method.
//	req, resp := client.StartDashboardSnapshotJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/StartDashboardSnapshotJob
func (c *QuickSight) StartDashboardSnapshotJobRequest(input *StartDashboardSnapshotJobInput) (req *request.Request, output *StartDashboardSnapshotJobOutput) {
	op := &request.Operation{
		Name:       opStartDashboardSnapshotJob,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/snapshot-jobs",
	}

	if input == nil {
		input = &StartDashboardSnapshotJobInput{}
	}

	output = &StartDashboardSnapshotJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDashboardSnapshotJob API operation for Amazon QuickSight.
//
// Starts an asynchronous job that generates a dashboard snapshot. You can request
// one of the following format configurations per API call.
//
//   - 1 paginated PDF
//
//   - 1 Excel workbook
//
//   - 5 CSVs
//
// Poll job descriptions with a DescribeDashboardSnapshotJob API call. Once
// the job succeeds, use the DescribeDashboardSnapshotJobResult API to obtain
// the download URIs that the job generates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation StartDashboardSnapshotJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - UnsupportedPricingPlanException
//     This error indicates that you are calling an embedding operation in Amazon
//     QuickSight without the required pricing plan on your Amazon Web Services
//     account. Before you can use embedding for anonymous users, a QuickSight administrator
//     needs to add capacity pricing to Amazon QuickSight. You can do this on the
//     Manage Amazon QuickSight page.
//
//     After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//     API operation with the --identity-type ANONYMOUS option.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/StartDashboardSnapshotJob
func (c *QuickSight) StartDashboardSnapshotJob(input *StartDashboardSnapshotJobInput) (*StartDashboardSnapshotJobOutput, error) {
	req, out := c.StartDashboardSnapshotJobRequest(input)
	return out, req.Send()
}

// StartDashboardSnapshotJobWithContext is the same as StartDashboardSnapshotJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDashboardSnapshotJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) StartDashboardSnapshotJobWithContext(ctx aws.Context, input *StartDashboardSnapshotJobInput, opts ...request.Option) (*StartDashboardSnapshotJobOutput, error) {
	req, out := c.StartDashboardSnapshotJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource
func (c *QuickSight) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon QuickSight.
//
// Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight
// resource.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions, by granting a user permission to access or
// change only resources with certain tag values. You can use the TagResource
// operation with a resource that already has tags. If you specify a new tag
// key for the resource, this tag is appended to the list of tags associated
// with the resource. If you specify a tag key that is already associated with
// the resource, the new tag value that you specify replaces the previous value
// for that tag.
//
// You can associate as many as 50 tags with a resource. Amazon QuickSight supports
// tagging on data set, data source, dashboard, template, topic, and user.
//
// Tagging for Amazon QuickSight works in a similar way to tagging for other
// Amazon Web Services services, except for the following:
//
//   - Tags are used to track costs for users in Amazon QuickSight. You can't
//     tag other resources that Amazon QuickSight costs are based on, such as
//     storage capacoty (SPICE), session usage, alert consumption, or reporting
//     units.
//
//   - Amazon QuickSight doesn't currently support the tag editor for Resource
//     Groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource
func (c *QuickSight) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource
func (c *QuickSight) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon QuickSight.
//
// Removes a tag or tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource
func (c *QuickSight) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountCustomization = "UpdateAccountCustomization"

// UpdateAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountCustomization for more information on using the UpdateAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountCustomizationRequest method.
//	req, resp := client.UpdateAccountCustomizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization
func (c *QuickSight) UpdateAccountCustomizationRequest(input *UpdateAccountCustomizationInput) (req *request.Request, output *UpdateAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountCustomization,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &UpdateAccountCustomizationInput{}
	}

	output = &UpdateAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountCustomization API operation for Amazon QuickSight.
//
// Updates Amazon QuickSight customizations for the current Amazon Web Services
// Region. Currently, the only customization that you can use is a theme.
//
// You can use customizations for your Amazon Web Services account or, if you
// specify a namespace, for a Amazon QuickSight namespace instead. Customizations
// that apply to a namespace override customizations that apply to an Amazon
// Web Services account. To find out which customizations apply, use the DescribeAccountCustomization
// API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAccountCustomization for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization
func (c *QuickSight) UpdateAccountCustomization(input *UpdateAccountCustomizationInput) (*UpdateAccountCustomizationOutput, error) {
	req, out := c.UpdateAccountCustomizationRequest(input)
	return out, req.Send()
}

// UpdateAccountCustomizationWithContext is the same as UpdateAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAccountCustomizationWithContext(ctx aws.Context, input *UpdateAccountCustomizationInput, opts ...request.Option) (*UpdateAccountCustomizationOutput, error) {
	req, out := c.UpdateAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountSettings = "UpdateAccountSettings"

// UpdateAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountSettings for more information on using the UpdateAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountSettingsRequest method.
//	req, resp := client.UpdateAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings
func (c *QuickSight) UpdateAccountSettingsRequest(input *UpdateAccountSettingsInput) (req *request.Request, output *UpdateAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/settings",
	}

	if input == nil {
		input = &UpdateAccountSettingsInput{}
	}

	output = &UpdateAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountSettings API operation for Amazon QuickSight.
//
// Updates the Amazon QuickSight settings in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings
func (c *QuickSight) UpdateAccountSettings(input *UpdateAccountSettingsInput) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	return out, req.Send()
}

// UpdateAccountSettingsWithContext is the same as UpdateAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAccountSettingsWithContext(ctx aws.Context, input *UpdateAccountSettingsInput, opts ...request.Option) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnalysis = "UpdateAnalysis"

// UpdateAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnalysis for more information on using the UpdateAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnalysisRequest method.
//	req, resp := client.UpdateAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis
func (c *QuickSight) UpdateAnalysisRequest(input *UpdateAnalysisInput) (req *request.Request, output *UpdateAnalysisOutput) {
	op := &request.Operation{
		Name:       opUpdateAnalysis,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &UpdateAnalysisInput{}
	}

	output = &UpdateAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnalysis API operation for Amazon QuickSight.
//
// # Updates an analysis in Amazon QuickSight
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis
func (c *QuickSight) UpdateAnalysis(input *UpdateAnalysisInput) (*UpdateAnalysisOutput, error) {
	req, out := c.UpdateAnalysisRequest(input)
	return out, req.Send()
}

// UpdateAnalysisWithContext is the same as UpdateAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAnalysisWithContext(ctx aws.Context, input *UpdateAnalysisInput, opts ...request.Option) (*UpdateAnalysisOutput, error) {
	req, out := c.UpdateAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnalysisPermissions = "UpdateAnalysisPermissions"

// UpdateAnalysisPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnalysisPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnalysisPermissions for more information on using the UpdateAnalysisPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnalysisPermissionsRequest method.
//	req, resp := client.UpdateAnalysisPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions
func (c *QuickSight) UpdateAnalysisPermissionsRequest(input *UpdateAnalysisPermissionsInput) (req *request.Request, output *UpdateAnalysisPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateAnalysisPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
	}

	if input == nil {
		input = &UpdateAnalysisPermissionsInput{}
	}

	output = &UpdateAnalysisPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnalysisPermissions API operation for Amazon QuickSight.
//
// Updates the read and write permissions for an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAnalysisPermissions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions
func (c *QuickSight) UpdateAnalysisPermissions(input *UpdateAnalysisPermissionsInput) (*UpdateAnalysisPermissionsOutput, error) {
	req, out := c.UpdateAnalysisPermissionsRequest(input)
	return out, req.Send()
}

// UpdateAnalysisPermissionsWithContext is the same as UpdateAnalysisPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnalysisPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAnalysisPermissionsWithContext(ctx aws.Context, input *UpdateAnalysisPermissionsInput, opts ...request.Option) (*UpdateAnalysisPermissionsOutput, error) {
	req, out := c.UpdateAnalysisPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboard = "UpdateDashboard"

// UpdateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboard for more information on using the UpdateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDashboardRequest method.
//	req, resp := client.UpdateDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard
func (c *QuickSight) UpdateDashboardRequest(input *UpdateDashboardInput) (req *request.Request, output *UpdateDashboardOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboard,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &UpdateDashboardInput{}
	}

	output = &UpdateDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboard API operation for Amazon QuickSight.
//
// Updates a dashboard in an Amazon Web Services account.
//
// Updating a Dashboard creates a new dashboard version but does not immediately
// publish the new version. You can update the published version of a dashboard
// by using the UpdateDashboardPublishedVersion (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html)
// API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboard for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard
func (c *QuickSight) UpdateDashboard(input *UpdateDashboardInput) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	return out, req.Send()
}

// UpdateDashboardWithContext is the same as UpdateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardWithContext(ctx aws.Context, input *UpdateDashboardInput, opts ...request.Option) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboardLinks = "UpdateDashboardLinks"

// UpdateDashboardLinksRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboardLinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboardLinks for more information on using the UpdateDashboardLinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDashboardLinksRequest method.
//	req, resp := client.UpdateDashboardLinksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardLinks
func (c *QuickSight) UpdateDashboardLinksRequest(input *UpdateDashboardLinksInput) (req *request.Request, output *UpdateDashboardLinksOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboardLinks,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/linked-entities",
	}

	if input == nil {
		input = &UpdateDashboardLinksInput{}
	}

	output = &UpdateDashboardLinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboardLinks API operation for Amazon QuickSight.
//
// Updates the linked analyses on a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboardLinks for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardLinks
func (c *QuickSight) UpdateDashboardLinks(input *UpdateDashboardLinksInput) (*UpdateDashboardLinksOutput, error) {
	req, out := c.UpdateDashboardLinksRequest(input)
	return out, req.Send()
}

// UpdateDashboardLinksWithContext is the same as UpdateDashboardLinks with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboardLinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardLinksWithContext(ctx aws.Context, input *UpdateDashboardLinksInput, opts ...request.Option) (*UpdateDashboardLinksOutput, error) {
	req, out := c.UpdateDashboardLinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboardPermissions = "UpdateDashboardPermissions"

// UpdateDashboardPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboardPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboardPermissions for more information on using the UpdateDashboardPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDashboardPermissionsRequest method.
//	req, resp := client.UpdateDashboardPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions
func (c *QuickSight) UpdateDashboardPermissionsRequest(input *UpdateDashboardPermissionsInput) (req *request.Request, output *UpdateDashboardPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboardPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
	}

	if input == nil {
		input = &UpdateDashboardPermissionsInput{}
	}

	output = &UpdateDashboardPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboardPermissions API operation for Amazon QuickSight.
//
// Updates read and write permissions on a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboardPermissions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions
func (c *QuickSight) UpdateDashboardPermissions(input *UpdateDashboardPermissionsInput) (*UpdateDashboardPermissionsOutput, error) {
	req, out := c.UpdateDashboardPermissionsRequest(input)
	return out, req.Send()
}

// UpdateDashboardPermissionsWithContext is the same as UpdateDashboardPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboardPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardPermissionsWithContext(ctx aws.Context, input *UpdateDashboardPermissionsInput, opts ...request.Option) (*UpdateDashboardPermissionsOutput, error) {
	req, out := c.UpdateDashboardPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboardPublishedVersion = "UpdateDashboardPublishedVersion"

// UpdateDashboardPublishedVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboardPublishedVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboardPublishedVersion for more information on using the UpdateDashboardPublishedVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDashboardPublishedVersionRequest method.
//	req, resp := client.UpdateDashboardPublishedVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion
func (c *QuickSight) UpdateDashboardPublishedVersionRequest(input *UpdateDashboardPublishedVersionInput) (req *request.Request, output *UpdateDashboardPublishedVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboardPublishedVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions/{VersionNumber}",
	}

	if input == nil {
		input = &UpdateDashboardPublishedVersionInput{}
	}

	output = &UpdateDashboardPublishedVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboardPublishedVersion API operation for Amazon QuickSight.
//
// Updates the published version of a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboardPublishedVersion for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion
func (c *QuickSight) UpdateDashboardPublishedVersion(input *UpdateDashboardPublishedVersionInput) (*UpdateDashboardPublishedVersionOutput, error) {
	req, out := c.UpdateDashboardPublishedVersionRequest(input)
	return out, req.Send()
}

// UpdateDashboardPublishedVersionWithContext is the same as UpdateDashboardPublishedVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboardPublishedVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardPublishedVersionWithContext(ctx aws.Context, input *UpdateDashboardPublishedVersionInput, opts ...request.Option) (*UpdateDashboardPublishedVersionOutput, error) {
	req, out := c.UpdateDashboardPublishedVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSet = "UpdateDataSet"

// UpdateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSet for more information on using the UpdateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSetRequest method.
//	req, resp := client.UpdateDataSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet
func (c *QuickSight) UpdateDataSetRequest(input *UpdateDataSetInput) (req *request.Request, output *UpdateDataSetOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSet,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &UpdateDataSetInput{}
	}

	output = &UpdateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSet API operation for Amazon QuickSight.
//
// Updates a dataset. This operation doesn't support datasets that include uploaded
// files as a source. Partial updates are not supported by this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet
func (c *QuickSight) UpdateDataSet(input *UpdateDataSetInput) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	return out, req.Send()
}

// UpdateDataSetWithContext is the same as UpdateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSetWithContext(ctx aws.Context, input *UpdateDataSetInput, opts ...request.Option) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSetPermissions = "UpdateDataSetPermissions"

// UpdateDataSetPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSetPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSetPermissions for more information on using the UpdateDataSetPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSetPermissionsRequest method.
//	req, resp := client.UpdateDataSetPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions
func (c *QuickSight) UpdateDataSetPermissionsRequest(input *UpdateDataSetPermissionsInput) (req *request.Request, output *UpdateDataSetPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSetPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
	}

	if input == nil {
		input = &UpdateDataSetPermissionsInput{}
	}

	output = &UpdateDataSetPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSetPermissions API operation for Amazon QuickSight.
//
// Updates the permissions on a dataset.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSetPermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions
func (c *QuickSight) UpdateDataSetPermissions(input *UpdateDataSetPermissionsInput) (*UpdateDataSetPermissionsOutput, error) {
	req, out := c.UpdateDataSetPermissionsRequest(input)
	return out, req.Send()
}

// UpdateDataSetPermissionsWithContext is the same as UpdateDataSetPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSetPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSetPermissionsWithContext(ctx aws.Context, input *UpdateDataSetPermissionsInput, opts ...request.Option) (*UpdateDataSetPermissionsOutput, error) {
	req, out := c.UpdateDataSetPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSourceRequest method.
//	req, resp := client.UpdateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource
func (c *QuickSight) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for Amazon QuickSight.
//
// Updates a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource
func (c *QuickSight) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSourcePermissions = "UpdateDataSourcePermissions"

// UpdateDataSourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSourcePermissions for more information on using the UpdateDataSourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSourcePermissionsRequest method.
//	req, resp := client.UpdateDataSourcePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions
func (c *QuickSight) UpdateDataSourcePermissionsRequest(input *UpdateDataSourcePermissionsInput) (req *request.Request, output *UpdateDataSourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSourcePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &UpdateDataSourcePermissionsInput{}
	}

	output = &UpdateDataSourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSourcePermissions API operation for Amazon QuickSight.
//
// Updates the permissions to a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSourcePermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions
func (c *QuickSight) UpdateDataSourcePermissions(input *UpdateDataSourcePermissionsInput) (*UpdateDataSourcePermissionsOutput, error) {
	req, out := c.UpdateDataSourcePermissionsRequest(input)
	return out, req.Send()
}

// UpdateDataSourcePermissionsWithContext is the same as UpdateDataSourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSourcePermissionsWithContext(ctx aws.Context, input *UpdateDataSourcePermissionsInput, opts ...request.Option) (*UpdateDataSourcePermissionsOutput, error) {
	req, out := c.UpdateDataSourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFolder = "UpdateFolder"

// UpdateFolderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFolder for more information on using the UpdateFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFolderRequest method.
//	req, resp := client.UpdateFolderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolder
func (c *QuickSight) UpdateFolderRequest(input *UpdateFolderInput) (req *request.Request, output *UpdateFolderOutput) {
	op := &request.Operation{
		Name:       opUpdateFolder,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &UpdateFolderInput{}
	}

	output = &UpdateFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFolder API operation for Amazon QuickSight.
//
// Updates the name of a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateFolder for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolder
func (c *QuickSight) UpdateFolder(input *UpdateFolderInput) (*UpdateFolderOutput, error) {
	req, out := c.UpdateFolderRequest(input)
	return out, req.Send()
}

// UpdateFolderWithContext is the same as UpdateFolder with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateFolderWithContext(ctx aws.Context, input *UpdateFolderInput, opts ...request.Option) (*UpdateFolderOutput, error) {
	req, out := c.UpdateFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFolderPermissions = "UpdateFolderPermissions"

// UpdateFolderPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFolderPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFolderPermissions for more information on using the UpdateFolderPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFolderPermissionsRequest method.
//	req, resp := client.UpdateFolderPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolderPermissions
func (c *QuickSight) UpdateFolderPermissionsRequest(input *UpdateFolderPermissionsInput) (req *request.Request, output *UpdateFolderPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateFolderPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/permissions",
	}

	if input == nil {
		input = &UpdateFolderPermissionsInput{}
	}

	output = &UpdateFolderPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFolderPermissions API operation for Amazon QuickSight.
//
// Updates permissions of a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateFolderPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolderPermissions
func (c *QuickSight) UpdateFolderPermissions(input *UpdateFolderPermissionsInput) (*UpdateFolderPermissionsOutput, error) {
	req, out := c.UpdateFolderPermissionsRequest(input)
	return out, req.Send()
}

// UpdateFolderPermissionsWithContext is the same as UpdateFolderPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFolderPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateFolderPermissionsWithContext(ctx aws.Context, input *UpdateFolderPermissionsInput, opts ...request.Option) (*UpdateFolderPermissionsOutput, error) {
	req, out := c.UpdateFolderPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGroupRequest method.
//	req, resp := client.UpdateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for Amazon QuickSight.
//
// Changes a group description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIAMPolicyAssignment = "UpdateIAMPolicyAssignment"

// UpdateIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIAMPolicyAssignment for more information on using the UpdateIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIAMPolicyAssignmentRequest method.
//	req, resp := client.UpdateIAMPolicyAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment
func (c *QuickSight) UpdateIAMPolicyAssignmentRequest(input *UpdateIAMPolicyAssignmentInput) (req *request.Request, output *UpdateIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opUpdateIAMPolicyAssignment,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &UpdateIAMPolicyAssignmentInput{}
	}

	output = &UpdateIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Updates an existing IAM policy assignment. This operation updates only the
// optional parameter or parameters that are specified in the request. This
// overwrites all of the users included in Identities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConcurrentUpdatingException
//     A resource is already in a state that indicates an operation is happening
//     that must complete before a new update can be applied.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment
func (c *QuickSight) UpdateIAMPolicyAssignment(input *UpdateIAMPolicyAssignmentInput) (*UpdateIAMPolicyAssignmentOutput, error) {
	req, out := c.UpdateIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// UpdateIAMPolicyAssignmentWithContext is the same as UpdateIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateIAMPolicyAssignmentWithContext(ctx aws.Context, input *UpdateIAMPolicyAssignmentInput, opts ...request.Option) (*UpdateIAMPolicyAssignmentOutput, error) {
	req, out := c.UpdateIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdentityPropagationConfig = "UpdateIdentityPropagationConfig"

// UpdateIdentityPropagationConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdentityPropagationConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdentityPropagationConfig for more information on using the UpdateIdentityPropagationConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIdentityPropagationConfigRequest method.
//	req, resp := client.UpdateIdentityPropagationConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIdentityPropagationConfig
func (c *QuickSight) UpdateIdentityPropagationConfigRequest(input *UpdateIdentityPropagationConfigInput) (req *request.Request, output *UpdateIdentityPropagationConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateIdentityPropagationConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/identity-propagation-config/{Service}",
	}

	if input == nil {
		input = &UpdateIdentityPropagationConfigInput{}
	}

	output = &UpdateIdentityPropagationConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdentityPropagationConfig API operation for Amazon QuickSight.
//
// Adds or updates services and authorized targets to configure what the Amazon
// QuickSight IAM Identity Center application can access.
//
// This operation is only supported for Amazon QuickSight accounts using IAM
// Identity Center
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateIdentityPropagationConfig for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIdentityPropagationConfig
func (c *QuickSight) UpdateIdentityPropagationConfig(input *UpdateIdentityPropagationConfigInput) (*UpdateIdentityPropagationConfigOutput, error) {
	req, out := c.UpdateIdentityPropagationConfigRequest(input)
	return out, req.Send()
}

// UpdateIdentityPropagationConfigWithContext is the same as UpdateIdentityPropagationConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdentityPropagationConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateIdentityPropagationConfigWithContext(ctx aws.Context, input *UpdateIdentityPropagationConfigInput, opts ...request.Option) (*UpdateIdentityPropagationConfigOutput, error) {
	req, out := c.UpdateIdentityPropagationConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIpRestriction = "UpdateIpRestriction"

// UpdateIpRestrictionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIpRestriction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIpRestriction for more information on using the UpdateIpRestriction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIpRestrictionRequest method.
//	req, resp := client.UpdateIpRestrictionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIpRestriction
func (c *QuickSight) UpdateIpRestrictionRequest(input *UpdateIpRestrictionInput) (req *request.Request, output *UpdateIpRestrictionOutput) {
	op := &request.Operation{
		Name:       opUpdateIpRestriction,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/ip-restriction",
	}

	if input == nil {
		input = &UpdateIpRestrictionInput{}
	}

	output = &UpdateIpRestrictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIpRestriction API operation for Amazon QuickSight.
//
// Updates the content and status of IP rules. To use this operation, you must
// provide the entire map of rules. You can use the DescribeIpRestriction operation
// to get the current rule map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateIpRestriction for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIpRestriction
func (c *QuickSight) UpdateIpRestriction(input *UpdateIpRestrictionInput) (*UpdateIpRestrictionOutput, error) {
	req, out := c.UpdateIpRestrictionRequest(input)
	return out, req.Send()
}

// UpdateIpRestrictionWithContext is the same as UpdateIpRestriction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIpRestriction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateIpRestrictionWithContext(ctx aws.Context, input *UpdateIpRestrictionInput, opts ...request.Option) (*UpdateIpRestrictionOutput, error) {
	req, out := c.UpdateIpRestrictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePublicSharingSettings = "UpdatePublicSharingSettings"

// UpdatePublicSharingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePublicSharingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePublicSharingSettings for more information on using the UpdatePublicSharingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePublicSharingSettingsRequest method.
//	req, resp := client.UpdatePublicSharingSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdatePublicSharingSettings
func (c *QuickSight) UpdatePublicSharingSettingsRequest(input *UpdatePublicSharingSettingsInput) (req *request.Request, output *UpdatePublicSharingSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdatePublicSharingSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/public-sharing-settings",
	}

	if input == nil {
		input = &UpdatePublicSharingSettingsInput{}
	}

	output = &UpdatePublicSharingSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePublicSharingSettings API operation for Amazon QuickSight.
//
// Use the UpdatePublicSharingSettings operation to turn on or turn off the
// public sharing settings of an Amazon QuickSight dashboard.
//
// To use this operation, turn on session capacity pricing for your Amazon QuickSight
// account.
//
// Before you can turn on public sharing on your account, make sure to give
// public sharing permissions to an administrative user in the Identity and
// Access Management (IAM) console. For more information on using IAM with Amazon
// QuickSight, see Using Amazon QuickSight with IAM (https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html)
// in the Amazon QuickSight User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdatePublicSharingSettings for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedPricingPlanException
//     This error indicates that you are calling an embedding operation in Amazon
//     QuickSight without the required pricing plan on your Amazon Web Services
//     account. Before you can use embedding for anonymous users, a QuickSight administrator
//     needs to add capacity pricing to Amazon QuickSight. You can do this on the
//     Manage Amazon QuickSight page.
//
//     After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//     API operation with the --identity-type ANONYMOUS option.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdatePublicSharingSettings
func (c *QuickSight) UpdatePublicSharingSettings(input *UpdatePublicSharingSettingsInput) (*UpdatePublicSharingSettingsOutput, error) {
	req, out := c.UpdatePublicSharingSettingsRequest(input)
	return out, req.Send()
}

// UpdatePublicSharingSettingsWithContext is the same as UpdatePublicSharingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePublicSharingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdatePublicSharingSettingsWithContext(ctx aws.Context, input *UpdatePublicSharingSettingsInput, opts ...request.Option) (*UpdatePublicSharingSettingsOutput, error) {
	req, out := c.UpdatePublicSharingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRefreshSchedule = "UpdateRefreshSchedule"

// UpdateRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRefreshSchedule for more information on using the UpdateRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRefreshScheduleRequest method.
//	req, resp := client.UpdateRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateRefreshSchedule
func (c *QuickSight) UpdateRefreshScheduleRequest(input *UpdateRefreshScheduleInput) (req *request.Request, output *UpdateRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateRefreshSchedule,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules",
	}

	if input == nil {
		input = &UpdateRefreshScheduleInput{}
	}

	output = &UpdateRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRefreshSchedule API operation for Amazon QuickSight.
//
// Updates a refresh schedule for a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateRefreshSchedule
func (c *QuickSight) UpdateRefreshSchedule(input *UpdateRefreshScheduleInput) (*UpdateRefreshScheduleOutput, error) {
	req, out := c.UpdateRefreshScheduleRequest(input)
	return out, req.Send()
}

// UpdateRefreshScheduleWithContext is the same as UpdateRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateRefreshScheduleWithContext(ctx aws.Context, input *UpdateRefreshScheduleInput, opts ...request.Option) (*UpdateRefreshScheduleOutput, error) {
	req, out := c.UpdateRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoleCustomPermission = "UpdateRoleCustomPermission"

// UpdateRoleCustomPermissionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoleCustomPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoleCustomPermission for more information on using the UpdateRoleCustomPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoleCustomPermissionRequest method.
//	req, resp := client.UpdateRoleCustomPermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateRoleCustomPermission
func (c *QuickSight) UpdateRoleCustomPermissionRequest(input *UpdateRoleCustomPermissionInput) (req *request.Request, output *UpdateRoleCustomPermissionOutput) {
	op := &request.Operation{
		Name:       opUpdateRoleCustomPermission,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/custom-permission",
	}

	if input == nil {
		input = &UpdateRoleCustomPermissionInput{}
	}

	output = &UpdateRoleCustomPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoleCustomPermission API operation for Amazon QuickSight.
//
// Updates the custom permissions that are associated with a role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateRoleCustomPermission for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateRoleCustomPermission
func (c *QuickSight) UpdateRoleCustomPermission(input *UpdateRoleCustomPermissionInput) (*UpdateRoleCustomPermissionOutput, error) {
	req, out := c.UpdateRoleCustomPermissionRequest(input)
	return out, req.Send()
}

// UpdateRoleCustomPermissionWithContext is the same as UpdateRoleCustomPermission with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoleCustomPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateRoleCustomPermissionWithContext(ctx aws.Context, input *UpdateRoleCustomPermissionInput, opts ...request.Option) (*UpdateRoleCustomPermissionOutput, error) {
	req, out := c.UpdateRoleCustomPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplate = "UpdateTemplate"

// UpdateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplate for more information on using the UpdateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateRequest method.
//	req, resp := client.UpdateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate
func (c *QuickSight) UpdateTemplateRequest(input *UpdateTemplateInput) (req *request.Request, output *UpdateTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &UpdateTemplateInput{}
	}

	output = &UpdateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplate API operation for Amazon QuickSight.
//
// Updates a template from an existing Amazon QuickSight analysis or another
// template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate
func (c *QuickSight) UpdateTemplate(input *UpdateTemplateInput) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	return out, req.Send()
}

// UpdateTemplateWithContext is the same as UpdateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplateWithContext(ctx aws.Context, input *UpdateTemplateInput, opts ...request.Option) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplateAlias = "UpdateTemplateAlias"

// UpdateTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplateAlias for more information on using the UpdateTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateAliasRequest method.
//	req, resp := client.UpdateTemplateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias
func (c *QuickSight) UpdateTemplateAliasRequest(input *UpdateTemplateAliasInput) (req *request.Request, output *UpdateTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplateAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &UpdateTemplateAliasInput{}
	}

	output = &UpdateTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplateAlias API operation for Amazon QuickSight.
//
// Updates the template alias of a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias
func (c *QuickSight) UpdateTemplateAlias(input *UpdateTemplateAliasInput) (*UpdateTemplateAliasOutput, error) {
	req, out := c.UpdateTemplateAliasRequest(input)
	return out, req.Send()
}

// UpdateTemplateAliasWithContext is the same as UpdateTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplateAliasWithContext(ctx aws.Context, input *UpdateTemplateAliasInput, opts ...request.Option) (*UpdateTemplateAliasOutput, error) {
	req, out := c.UpdateTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplatePermissions = "UpdateTemplatePermissions"

// UpdateTemplatePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplatePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplatePermissions for more information on using the UpdateTemplatePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplatePermissionsRequest method.
//	req, resp := client.UpdateTemplatePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions
func (c *QuickSight) UpdateTemplatePermissionsRequest(input *UpdateTemplatePermissionsInput) (req *request.Request, output *UpdateTemplatePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplatePermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
	}

	if input == nil {
		input = &UpdateTemplatePermissionsInput{}
	}

	output = &UpdateTemplatePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplatePermissions API operation for Amazon QuickSight.
//
// Updates the resource permissions for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplatePermissions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions
func (c *QuickSight) UpdateTemplatePermissions(input *UpdateTemplatePermissionsInput) (*UpdateTemplatePermissionsOutput, error) {
	req, out := c.UpdateTemplatePermissionsRequest(input)
	return out, req.Send()
}

// UpdateTemplatePermissionsWithContext is the same as UpdateTemplatePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplatePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplatePermissionsWithContext(ctx aws.Context, input *UpdateTemplatePermissionsInput, opts ...request.Option) (*UpdateTemplatePermissionsOutput, error) {
	req, out := c.UpdateTemplatePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTheme = "UpdateTheme"

// UpdateThemeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTheme for more information on using the UpdateTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateThemeRequest method.
//	req, resp := client.UpdateThemeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme
func (c *QuickSight) UpdateThemeRequest(input *UpdateThemeInput) (req *request.Request, output *UpdateThemeOutput) {
	op := &request.Operation{
		Name:       opUpdateTheme,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &UpdateThemeInput{}
	}

	output = &UpdateThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTheme API operation for Amazon QuickSight.
//
// Updates a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTheme for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme
func (c *QuickSight) UpdateTheme(input *UpdateThemeInput) (*UpdateThemeOutput, error) {
	req, out := c.UpdateThemeRequest(input)
	return out, req.Send()
}

// UpdateThemeWithContext is the same as UpdateTheme with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateThemeWithContext(ctx aws.Context, input *UpdateThemeInput, opts ...request.Option) (*UpdateThemeOutput, error) {
	req, out := c.UpdateThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThemeAlias = "UpdateThemeAlias"

// UpdateThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThemeAlias for more information on using the UpdateThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateThemeAliasRequest method.
//	req, resp := client.UpdateThemeAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias
func (c *QuickSight) UpdateThemeAliasRequest(input *UpdateThemeAliasInput) (req *request.Request, output *UpdateThemeAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateThemeAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &UpdateThemeAliasInput{}
	}

	output = &UpdateThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThemeAlias API operation for Amazon QuickSight.
//
// Updates an alias of a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateThemeAlias for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias
func (c *QuickSight) UpdateThemeAlias(input *UpdateThemeAliasInput) (*UpdateThemeAliasOutput, error) {
	req, out := c.UpdateThemeAliasRequest(input)
	return out, req.Send()
}

// UpdateThemeAliasWithContext is the same as UpdateThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateThemeAliasWithContext(ctx aws.Context, input *UpdateThemeAliasInput, opts ...request.Option) (*UpdateThemeAliasOutput, error) {
	req, out := c.UpdateThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThemePermissions = "UpdateThemePermissions"

// UpdateThemePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThemePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThemePermissions for more information on using the UpdateThemePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateThemePermissionsRequest method.
//	req, resp := client.UpdateThemePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions
func (c *QuickSight) UpdateThemePermissionsRequest(input *UpdateThemePermissionsInput) (req *request.Request, output *UpdateThemePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateThemePermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/permissions",
	}

	if input == nil {
		input = &UpdateThemePermissionsInput{}
	}

	output = &UpdateThemePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThemePermissions API operation for Amazon QuickSight.
//
// Updates the resource permissions for a theme. Permissions apply to the action
// to grant or revoke permissions on, for example "quicksight:DescribeTheme".
//
// Theme permissions apply in groupings. Valid groupings include the following
// for the three levels of permissions, which are user, owner, or no permissions:
//
//   - User "quicksight:DescribeTheme" "quicksight:DescribeThemeAlias" "quicksight:ListThemeAliases"
//     "quicksight:ListThemeVersions"
//
//   - Owner "quicksight:DescribeTheme" "quicksight:DescribeThemeAlias" "quicksight:ListThemeAliases"
//     "quicksight:ListThemeVersions" "quicksight:DeleteTheme" "quicksight:UpdateTheme"
//     "quicksight:CreateThemeAlias" "quicksight:DeleteThemeAlias" "quicksight:UpdateThemeAlias"
//     "quicksight:UpdateThemePermissions" "quicksight:DescribeThemePermissions"
//
//   - To specify no permissions, omit the permissions list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateThemePermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions
func (c *QuickSight) UpdateThemePermissions(input *UpdateThemePermissionsInput) (*UpdateThemePermissionsOutput, error) {
	req, out := c.UpdateThemePermissionsRequest(input)
	return out, req.Send()
}

// UpdateThemePermissionsWithContext is the same as UpdateThemePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThemePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateThemePermissionsWithContext(ctx aws.Context, input *UpdateThemePermissionsInput, opts ...request.Option) (*UpdateThemePermissionsOutput, error) {
	req, out := c.UpdateThemePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTopic = "UpdateTopic"

// UpdateTopicRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTopic operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTopic for more information on using the UpdateTopic
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTopicRequest method.
//	req, resp := client.UpdateTopicRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTopic
func (c *QuickSight) UpdateTopicRequest(input *UpdateTopicInput) (req *request.Request, output *UpdateTopicOutput) {
	op := &request.Operation{
		Name:       opUpdateTopic,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}",
	}

	if input == nil {
		input = &UpdateTopicInput{}
	}

	output = &UpdateTopicOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTopic API operation for Amazon QuickSight.
//
// Updates a topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTopic for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTopic
func (c *QuickSight) UpdateTopic(input *UpdateTopicInput) (*UpdateTopicOutput, error) {
	req, out := c.UpdateTopicRequest(input)
	return out, req.Send()
}

// UpdateTopicWithContext is the same as UpdateTopic with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTopic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTopicWithContext(ctx aws.Context, input *UpdateTopicInput, opts ...request.Option) (*UpdateTopicOutput, error) {
	req, out := c.UpdateTopicRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTopicPermissions = "UpdateTopicPermissions"

// UpdateTopicPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTopicPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTopicPermissions for more information on using the UpdateTopicPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTopicPermissionsRequest method.
//	req, resp := client.UpdateTopicPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTopicPermissions
func (c *QuickSight) UpdateTopicPermissionsRequest(input *UpdateTopicPermissionsInput) (req *request.Request, output *UpdateTopicPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateTopicPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}/permissions",
	}

	if input == nil {
		input = &UpdateTopicPermissionsInput{}
	}

	output = &UpdateTopicPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTopicPermissions API operation for Amazon QuickSight.
//
// Updates the permissions of a topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTopicPermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTopicPermissions
func (c *QuickSight) UpdateTopicPermissions(input *UpdateTopicPermissionsInput) (*UpdateTopicPermissionsOutput, error) {
	req, out := c.UpdateTopicPermissionsRequest(input)
	return out, req.Send()
}

// UpdateTopicPermissionsWithContext is the same as UpdateTopicPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTopicPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTopicPermissionsWithContext(ctx aws.Context, input *UpdateTopicPermissionsInput, opts ...request.Option) (*UpdateTopicPermissionsOutput, error) {
	req, out := c.UpdateTopicPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTopicRefreshSchedule = "UpdateTopicRefreshSchedule"

// UpdateTopicRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTopicRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTopicRefreshSchedule for more information on using the UpdateTopicRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTopicRefreshScheduleRequest method.
//	req, resp := client.UpdateTopicRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTopicRefreshSchedule
func (c *QuickSight) UpdateTopicRefreshScheduleRequest(input *UpdateTopicRefreshScheduleInput) (req *request.Request, output *UpdateTopicRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateTopicRefreshSchedule,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/topics/{TopicId}/schedules/{DatasetId}",
	}

	if input == nil {
		input = &UpdateTopicRefreshScheduleInput{}
	}

	output = &UpdateTopicRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTopicRefreshSchedule API operation for Amazon QuickSight.
//
// Updates a topic refresh schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTopicRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTopicRefreshSchedule
func (c *QuickSight) UpdateTopicRefreshSchedule(input *UpdateTopicRefreshScheduleInput) (*UpdateTopicRefreshScheduleOutput, error) {
	req, out := c.UpdateTopicRefreshScheduleRequest(input)
	return out, req.Send()
}

// UpdateTopicRefreshScheduleWithContext is the same as UpdateTopicRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTopicRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTopicRefreshScheduleWithContext(ctx aws.Context, input *UpdateTopicRefreshScheduleInput, opts ...request.Option) (*UpdateTopicRefreshScheduleOutput, error) {
	req, out := c.UpdateTopicRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserRequest method.
//	req, resp := client.UpdateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon QuickSight.
//
// Updates an Amazon QuickSight user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVPCConnection = "UpdateVPCConnection"

// UpdateVPCConnectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVPCConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVPCConnection for more information on using the UpdateVPCConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVPCConnectionRequest method.
//	req, resp := client.UpdateVPCConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateVPCConnection
func (c *QuickSight) UpdateVPCConnectionRequest(input *UpdateVPCConnectionInput) (req *request.Request, output *UpdateVPCConnectionOutput) {
	op := &request.Operation{
		Name:       opUpdateVPCConnection,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/vpc-connections/{VPCConnectionId}",
	}

	if input == nil {
		input = &UpdateVPCConnectionInput{}
	}

	output = &UpdateVPCConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVPCConnection API operation for Amazon QuickSight.
//
// Updates a VPC connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateVPCConnection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateVPCConnection
func (c *QuickSight) UpdateVPCConnection(input *UpdateVPCConnectionInput) (*UpdateVPCConnectionOutput, error) {
	req, out := c.UpdateVPCConnectionRequest(input)
	return out, req.Send()
}

// UpdateVPCConnectionWithContext is the same as UpdateVPCConnection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVPCConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateVPCConnectionWithContext(ctx aws.Context, input *UpdateVPCConnectionInput, opts ...request.Option) (*UpdateVPCConnectionOutput, error) {
	req, out := c.UpdateVPCConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have access to this item. The provided credentials couldn't be
// validated. You might not be authorized to carry out the request. Make sure
// that your account is authorized to use the Amazon QuickSight service, that
// your policies have the correct permissions, and that you are using the correct
// credentials.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The Amazon Web Services request ID for this request.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon QuickSight customizations associated with your Amazon Web Services
// account or a QuickSight namespace in a specific Amazon Web Services Region.
type AccountCustomization struct {
	_ struct{} `type:"structure"`

	// The default email customization template.
	DefaultEmailCustomizationTemplate *string `type:"string"`

	// The default theme for this Amazon QuickSight subscription.
	DefaultTheme *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountCustomization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountCustomization) GoString() string {
	return s.String()
}

// SetDefaultEmailCustomizationTemplate sets the DefaultEmailCustomizationTemplate field's value.
func (s *AccountCustomization) SetDefaultEmailCustomizationTemplate(v string) *AccountCustomization {
	s.DefaultEmailCustomizationTemplate = &v
	return s
}

// SetDefaultTheme sets the DefaultTheme field's value.
func (s *AccountCustomization) SetDefaultTheme(v string) *AccountCustomization {
	s.DefaultTheme = &v
	return s
}

// A structure that contains the following account information elements:
//
//   - Your Amazon QuickSight account name.
//
//   - The edition of Amazon QuickSight that your account is using.
//
//   - The notification email address that is associated with the Amazon QuickSight
//     account.
//
//   - The authentication type of the Amazon QuickSight account.
//
//   - The status of the Amazon QuickSight account's subscription.
type AccountInfo struct {
	_ struct{} `type:"structure"`

	// The account name that you provided for the Amazon QuickSight subscription
	// in your Amazon Web Services account. You create this name when you sign up
	// for Amazon QuickSight. It's unique over all of Amazon Web Services, and it
	// appears only when users sign in.
	AccountName *string `type:"string"`

	// The status of your account subscription.
	AccountSubscriptionStatus *string `type:"string"`

	// The way that your Amazon QuickSight account is authenticated.
	AuthenticationType *string `type:"string"`

	// The edition of your Amazon QuickSight account.
	Edition *string `type:"string" enum:"Edition"`

	// The Amazon Resource Name (ARN) for the IAM Identity Center instance.
	IAMIdentityCenterInstanceArn *string `type:"string"`

	// The email address that will be used for Amazon QuickSight to send notifications
	// regarding your Amazon Web Services account or Amazon QuickSight subscription.
	NotificationEmail *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountInfo) GoString() string {
	return s.String()
}

// SetAccountName sets the AccountName field's value.
func (s *AccountInfo) SetAccountName(v string) *AccountInfo {
	s.AccountName = &v
	return s
}

// SetAccountSubscriptionStatus sets the AccountSubscriptionStatus field's value.
func (s *AccountInfo) SetAccountSubscriptionStatus(v string) *AccountInfo {
	s.AccountSubscriptionStatus = &v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *AccountInfo) SetAuthenticationType(v string) *AccountInfo {
	s.AuthenticationType = &v
	return s
}

// SetEdition sets the Edition field's value.
func (s *AccountInfo) SetEdition(v string) *AccountInfo {
	s.Edition = &v
	return s
}

// SetIAMIdentityCenterInstanceArn sets the IAMIdentityCenterInstanceArn field's value.
func (s *AccountInfo) SetIAMIdentityCenterInstanceArn(v string) *AccountInfo {
	s.IAMIdentityCenterInstanceArn = &v
	return s
}

// SetNotificationEmail sets the NotificationEmail field's value.
func (s *AccountInfo) SetNotificationEmail(v string) *AccountInfo {
	s.NotificationEmail = &v
	return s
}

// The Amazon QuickSight settings associated with your Amazon Web Services account.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// The "account name" you provided for the Amazon QuickSight subscription in
	// your Amazon Web Services account. You create this name when you sign up for
	// Amazon QuickSight. It is unique in all of Amazon Web Services and it appears
	// only when users sign in.
	AccountName *string `type:"string"`

	// The default Amazon QuickSight namespace for your Amazon Web Services account.
	DefaultNamespace *string `type:"string"`

	// The edition of Amazon QuickSight that you're currently subscribed to: Enterprise
	// edition or Standard edition.
	Edition *string `type:"string" enum:"Edition"`

	// The main notification email for your Amazon QuickSight subscription.
	NotificationEmail *string `type:"string"`

	// A Boolean value that indicates whether public sharing is turned on for an
	// Amazon QuickSight account. For more information about turning on public sharing,
	// see UpdatePublicSharingSettings (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html).
	PublicSharingEnabled *bool `type:"boolean"`

	// A boolean value that determines whether or not an Amazon QuickSight account
	// can be deleted. A True value doesn't allow the account to be deleted and
	// results in an error message if a user tries to make a DeleteAccountSubsctiption
	// request. A False value will allow the ccount to be deleted.
	TerminationProtectionEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetAccountName sets the AccountName field's value.
func (s *AccountSettings) SetAccountName(v string) *AccountSettings {
	s.AccountName = &v
	return s
}

// SetDefaultNamespace sets the DefaultNamespace field's value.
func (s *AccountSettings) SetDefaultNamespace(v string) *AccountSettings {
	s.DefaultNamespace = &v
	return s
}

// SetEdition sets the Edition field's value.
func (s *AccountSettings) SetEdition(v string) *AccountSettings {
	s.Edition = &v
	return s
}

// SetNotificationEmail sets the NotificationEmail field's value.
func (s *AccountSettings) SetNotificationEmail(v string) *AccountSettings {
	s.NotificationEmail = &v
	return s
}

// SetPublicSharingEnabled sets the PublicSharingEnabled field's value.
func (s *AccountSettings) SetPublicSharingEnabled(v bool) *AccountSettings {
	s.PublicSharingEnabled = &v
	return s
}

// SetTerminationProtectionEnabled sets the TerminationProtectionEnabled field's value.
func (s *AccountSettings) SetTerminationProtectionEnabled(v bool) *AccountSettings {
	s.TerminationProtectionEnabled = &v
	return s
}

// The active Identity and Access Management (IAM) policy assignment.
type ActiveIAMPolicyAssignment struct {
	_ struct{} `type:"structure"`

	// A name for the IAM policy assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	PolicyArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveIAMPolicyAssignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveIAMPolicyAssignment) GoString() string {
	return s.String()
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *ActiveIAMPolicyAssignment) SetAssignmentName(v string) *ActiveIAMPolicyAssignment {
	s.AssignmentName = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *ActiveIAMPolicyAssignment) SetPolicyArn(v string) *ActiveIAMPolicyAssignment {
	s.PolicyArn = &v
	return s
}

// An ad hoc (one-time) filtering option.
type AdHocFilteringOption struct {
	_ struct{} `type:"structure"`

	// Availability status.
	AvailabilityStatus *string `type:"string" enum:"DashboardBehavior"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdHocFilteringOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdHocFilteringOption) GoString() string {
	return s.String()
}

// SetAvailabilityStatus sets the AvailabilityStatus field's value.
func (s *AdHocFilteringOption) SetAvailabilityStatus(v string) *AdHocFilteringOption {
	s.AvailabilityStatus = &v
	return s
}

// An aggregation function aggregates values from a dimension or measure.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AggregationFunction struct {
	_ struct{} `type:"structure"`

	// Aggregation for attributes.
	AttributeAggregationFunction *AttributeAggregationFunction `type:"structure"`

	// Aggregation for categorical values.
	//
	//    * COUNT: Aggregate by the total number of values, including duplicates.
	//
	//    * DISTINCT_COUNT: Aggregate by the total number of distinct values.
	CategoricalAggregationFunction *string `type:"string" enum:"CategoricalAggregationFunction"`

	// Aggregation for date values.
	//
	//    * COUNT: Aggregate by the total number of values, including duplicates.
	//
	//    * DISTINCT_COUNT: Aggregate by the total number of distinct values.
	//
	//    * MIN: Select the smallest date value.
	//
	//    * MAX: Select the largest date value.
	DateAggregationFunction *string `type:"string" enum:"DateAggregationFunction"`

	// Aggregation for numerical values.
	NumericalAggregationFunction *NumericalAggregationFunction `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationFunction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationFunction) GoString() string {
	return s.String()
}

// SetAttributeAggregationFunction sets the AttributeAggregationFunction field's value.
func (s *AggregationFunction) SetAttributeAggregationFunction(v *AttributeAggregationFunction) *AggregationFunction {
	s.AttributeAggregationFunction = v
	return s
}

// SetCategoricalAggregationFunction sets the CategoricalAggregationFunction field's value.
func (s *AggregationFunction) SetCategoricalAggregationFunction(v string) *AggregationFunction {
	s.CategoricalAggregationFunction = &v
	return s
}

// SetDateAggregationFunction sets the DateAggregationFunction field's value.
func (s *AggregationFunction) SetDateAggregationFunction(v string) *AggregationFunction {
	s.DateAggregationFunction = &v
	return s
}

// SetNumericalAggregationFunction sets the NumericalAggregationFunction field's value.
func (s *AggregationFunction) SetNumericalAggregationFunction(v *NumericalAggregationFunction) *AggregationFunction {
	s.NumericalAggregationFunction = v
	return s
}

// The configuration options to sort aggregated values.
type AggregationSortConfiguration struct {
	_ struct{} `type:"structure"`

	// The function that aggregates the values in Column.
	AggregationFunction *AggregationFunction `type:"structure"`

	// The column that determines the sort order of aggregated values.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`

	// The sort direction of values.
	//
	//    * ASC: Sort in ascending order.
	//
	//    * DESC: Sort in descending order.
	//
	// SortDirection is a required field
	SortDirection *string `type:"string" required:"true" enum:"SortDirection"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationSortConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationSortConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregationSortConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregationSortConfiguration"}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.SortDirection == nil {
		invalidParams.Add(request.NewErrParamRequired("SortDirection"))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationFunction sets the AggregationFunction field's value.
func (s *AggregationSortConfiguration) SetAggregationFunction(v *AggregationFunction) *AggregationSortConfiguration {
	s.AggregationFunction = v
	return s
}

// SetColumn sets the Column field's value.
func (s *AggregationSortConfiguration) SetColumn(v *ColumnIdentifier) *AggregationSortConfiguration {
	s.Column = v
	return s
}

// SetSortDirection sets the SortDirection field's value.
func (s *AggregationSortConfiguration) SetSortDirection(v string) *AggregationSortConfiguration {
	s.SortDirection = &v
	return s
}

// The configuration for applying a filter to all sheets. You can apply this
// filter to all visuals on every sheet.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AllSheetsFilterScopeConfiguration struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllSheetsFilterScopeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllSheetsFilterScopeConfiguration) GoString() string {
	return s.String()
}

// The parameters for OpenSearch.
type AmazonElasticsearchParameters struct {
	_ struct{} `type:"structure"`

	// The OpenSearch domain.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonElasticsearchParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonElasticsearchParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonElasticsearchParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonElasticsearchParameters"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *AmazonElasticsearchParameters) SetDomain(v string) *AmazonElasticsearchParameters {
	s.Domain = &v
	return s
}

// The parameters for OpenSearch.
type AmazonOpenSearchParameters struct {
	_ struct{} `type:"structure"`

	// The OpenSearch domain.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonOpenSearchParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonOpenSearchParameters"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *AmazonOpenSearchParameters) SetDomain(v string) *AmazonOpenSearchParameters {
	s.Domain = &v
	return s
}

// Metadata structure for an analysis in Amazon QuickSight
type Analysis struct {
	_ struct{} `type:"structure"`

	// The ID of the analysis.
	AnalysisId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the analysis.
	Arn *string `type:"string"`

	// The time that the analysis was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ARNs of the datasets of the analysis.
	DataSetArns []*string `type:"list"`

	// Errors associated with the analysis.
	Errors []*AnalysisError `min:"1" type:"list"`

	// The time that the analysis was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The descriptive name of the analysis.
	Name *string `min:"1" type:"string"`

	// A list of the associated sheets with the unique identifier and name of each
	// sheet.
	Sheets []*Sheet `type:"list"`

	// Status associated with the analysis.
	Status *string `type:"string" enum:"ResourceStatus"`

	// The ARN of the theme of the analysis.
	ThemeArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Analysis) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Analysis) GoString() string {
	return s.String()
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *Analysis) SetAnalysisId(v string) *Analysis {
	s.AnalysisId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Analysis) SetArn(v string) *Analysis {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Analysis) SetCreatedTime(v time.Time) *Analysis {
	s.CreatedTime = &v
	return s
}

// SetDataSetArns sets the DataSetArns field's value.
func (s *Analysis) SetDataSetArns(v []*string) *Analysis {
	s.DataSetArns = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *Analysis) SetErrors(v []*AnalysisError) *Analysis {
	s.Errors = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Analysis) SetLastUpdatedTime(v time.Time) *Analysis {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Analysis) SetName(v string) *Analysis {
	s.Name = &v
	return s
}

// SetSheets sets the Sheets field's value.
func (s *Analysis) SetSheets(v []*Sheet) *Analysis {
	s.Sheets = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Analysis) SetStatus(v string) *Analysis {
	s.Status = &v
	return s
}

// SetThemeArn sets the ThemeArn field's value.
func (s *Analysis) SetThemeArn(v string) *Analysis {
	s.ThemeArn = &v
	return s
}

// The configuration for default analysis settings.
type AnalysisDefaults struct {
	_ struct{} `type:"structure"`

	// The configuration for default new sheet settings.
	//
	// DefaultNewSheetConfiguration is a required field
	DefaultNewSheetConfiguration *DefaultNewSheetConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisDefaults) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisDefaults) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisDefaults"}
	if s.DefaultNewSheetConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultNewSheetConfiguration"))
	}
	if s.DefaultNewSheetConfiguration != nil {
		if err := s.DefaultNewSheetConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DefaultNewSheetConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultNewSheetConfiguration sets the DefaultNewSheetConfiguration field's value.
func (s *AnalysisDefaults) SetDefaultNewSheetConfiguration(v *DefaultNewSheetConfiguration) *AnalysisDefaults {
	s.DefaultNewSheetConfiguration = v
	return s
}

// The definition of an analysis.
type AnalysisDefinition struct {
	_ struct{} `type:"structure"`

	// The configuration for default analysis settings.
	AnalysisDefaults *AnalysisDefaults `type:"structure"`

	// An array of calculated field definitions for the analysis.
	CalculatedFields []*CalculatedField `type:"list"`

	// An array of analysis-level column configurations. Column configurations can
	// be used to set default formatting for a column to be used throughout an analysis.
	ColumnConfigurations []*ColumnConfiguration `type:"list"`

	// An array of dataset identifier declarations. This mapping allows the usage
	// of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.
	//
	// DataSetIdentifierDeclarations is a required field
	DataSetIdentifierDeclarations []*DataSetIdentifierDeclaration `min:"1" type:"list" required:"true"`

	// Filter definitions for an analysis.
	//
	// For more information, see Filtering Data in Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html)
	// in the Amazon QuickSight User Guide.
	FilterGroups []*FilterGroup `type:"list"`

	// An array of option definitions for an analysis.
	Options *AssetOptions `type:"structure"`

	// An array of parameter declarations for an analysis.
	//
	// Parameters are named variables that can transfer a value for use by an action
	// or an object.
	//
	// For more information, see Parameters in Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html)
	// in the Amazon QuickSight User Guide.
	ParameterDeclarations []*ParameterDeclaration `type:"list"`

	// An array of sheet definitions for an analysis. Each SheetDefinition provides
	// detailed information about a sheet within this analysis.
	Sheets []*SheetDefinition `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisDefinition"}
	if s.DataSetIdentifierDeclarations == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetIdentifierDeclarations"))
	}
	if s.DataSetIdentifierDeclarations != nil && len(s.DataSetIdentifierDeclarations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetIdentifierDeclarations", 1))
	}
	if s.AnalysisDefaults != nil {
		if err := s.AnalysisDefaults.Validate(); err != nil {
			invalidParams.AddNested("AnalysisDefaults", err.(request.ErrInvalidParams))
		}
	}
	if s.CalculatedFields != nil {
		for i, v := range s.CalculatedFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CalculatedFields", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ColumnConfigurations != nil {
		for i, v := range s.ColumnConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSetIdentifierDeclarations != nil {
		for i, v := range s.DataSetIdentifierDeclarations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetIdentifierDeclarations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FilterGroups != nil {
		for i, v := range s.FilterGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ParameterDeclarations != nil {
		for i, v := range s.ParameterDeclarations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterDeclarations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sheets != nil {
		for i, v := range s.Sheets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sheets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisDefaults sets the AnalysisDefaults field's value.
func (s *AnalysisDefinition) SetAnalysisDefaults(v *AnalysisDefaults) *AnalysisDefinition {
	s.AnalysisDefaults = v
	return s
}

// SetCalculatedFields sets the CalculatedFields field's value.
func (s *AnalysisDefinition) SetCalculatedFields(v []*CalculatedField) *AnalysisDefinition {
	s.CalculatedFields = v
	return s
}

// SetColumnConfigurations sets the ColumnConfigurations field's value.
func (s *AnalysisDefinition) SetColumnConfigurations(v []*ColumnConfiguration) *AnalysisDefinition {
	s.ColumnConfigurations = v
	return s
}

// SetDataSetIdentifierDeclarations sets the DataSetIdentifierDeclarations field's value.
func (s *AnalysisDefinition) SetDataSetIdentifierDeclarations(v []*DataSetIdentifierDeclaration) *AnalysisDefinition {
	s.DataSetIdentifierDeclarations = v
	return s
}

// SetFilterGroups sets the FilterGroups field's value.
func (s *AnalysisDefinition) SetFilterGroups(v []*FilterGroup) *AnalysisDefinition {
	s.FilterGroups = v
	return s
}

// SetOptions sets the Options field's value.
func (s *AnalysisDefinition) SetOptions(v *AssetOptions) *AnalysisDefinition {
	s.Options = v
	return s
}

// SetParameterDeclarations sets the ParameterDeclarations field's value.
func (s *AnalysisDefinition) SetParameterDeclarations(v []*ParameterDeclaration) *AnalysisDefinition {
	s.ParameterDeclarations = v
	return s
}

// SetSheets sets the Sheets field's value.
func (s *AnalysisDefinition) SetSheets(v []*SheetDefinition) *AnalysisDefinition {
	s.Sheets = v
	return s
}

// Analysis error.
type AnalysisError struct {
	_ struct{} `type:"structure"`

	// The message associated with the analysis error.
	Message *string `type:"string"`

	// The type of the analysis error.
	Type *string `type:"string" enum:"AnalysisErrorType"`

	// Lists the violated entities that caused the analysis error
	ViolatedEntities []*Entity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AnalysisError) SetMessage(v string) *AnalysisError {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *AnalysisError) SetType(v string) *AnalysisError {
	s.Type = &v
	return s
}

// SetViolatedEntities sets the ViolatedEntities field's value.
func (s *AnalysisError) SetViolatedEntities(v []*Entity) *AnalysisError {
	s.ViolatedEntities = v
	return s
}

// A filter that you apply when searching for one or more analyses.
type AnalysisSearchFilter struct {
	_ struct{} `type:"structure"`

	// The name of the value that you want to use as a filter, for example "Name":
	// "QUICKSIGHT_OWNER".
	//
	// Valid values are defined as follows:
	//
	//    * QUICKSIGHT_VIEWER_OR_OWNER: Provide an ARN of a user or group, and any
	//    analyses with that ARN listed as one of the analysis' owners or viewers
	//    are returned. Implicit permissions from folders or groups are considered.
	//
	//    * QUICKSIGHT_OWNER: Provide an ARN of a user or group, and any analyses
	//    with that ARN listed as one of the owners of the analyses are returned.
	//    Implicit permissions from folders or groups are considered.
	//
	//    * DIRECT_QUICKSIGHT_SOLE_OWNER: Provide an ARN of a user or group, and
	//    any analyses with that ARN listed as the only owner of the analysis are
	//    returned. Implicit permissions from folders or groups are not considered.
	//
	//    * DIRECT_QUICKSIGHT_OWNER: Provide an ARN of a user or group, and any
	//    analyses with that ARN listed as one of the owners of the analyses are
	//    returned. Implicit permissions from folders or groups are not considered.
	//
	//    * DIRECT_QUICKSIGHT_VIEWER_OR_OWNER: Provide an ARN of a user or group,
	//    and any analyses with that ARN listed as one of the owners or viewers
	//    of the analyses are returned. Implicit permissions from folders or groups
	//    are not considered.
	//
	//    * ANALYSIS_NAME: Any analyses whose names have a substring match to this
	//    value will be returned.
	Name *string `type:"string" enum:"AnalysisFilterAttribute"`

	// The comparison operator that you want to use as a filter, for example "Operator":
	// "StringEquals". Valid values are "StringEquals" and "StringLike".
	//
	// If you set the operator value to "StringEquals", you need to provide an ownership
	// related filter in the "NAME" field and the arn of the user or group whose
	// folders you want to search in the "Value" field. For example, "Name":"DIRECT_QUICKSIGHT_OWNER",
	// "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1".
	//
	// If you set the value to "StringLike", you need to provide the name of the
	// folders you are searching for. For example, "Name":"ANALYSIS_NAME", "Operator":
	// "StringLike", "Value": "Test". The "StringLike" operator only supports the
	// NAME value ANALYSIS_NAME.
	Operator *string `type:"string" enum:"FilterOperator"`

	// The value of the named item, in this case QUICKSIGHT_USER, that you want
	// to use as a filter, for example "Value". An example is "arn:aws:quicksight:us-east-1:1:user/default/UserName1".
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSearchFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalysisSearchFilter) SetName(v string) *AnalysisSearchFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AnalysisSearchFilter) SetOperator(v string) *AnalysisSearchFilter {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalysisSearchFilter) SetValue(v string) *AnalysisSearchFilter {
	s.Value = &v
	return s
}

// The source entity of an analysis.
type AnalysisSourceEntity struct {
	_ struct{} `type:"structure"`

	// The source template for the source entity of the analysis.
	SourceTemplate *AnalysisSourceTemplate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceEntity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisSourceEntity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisSourceEntity"}
	if s.SourceTemplate != nil {
		if err := s.SourceTemplate.Validate(); err != nil {
			invalidParams.AddNested("SourceTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceTemplate sets the SourceTemplate field's value.
func (s *AnalysisSourceEntity) SetSourceTemplate(v *AnalysisSourceTemplate) *AnalysisSourceEntity {
	s.SourceTemplate = v
	return s
}

// The source template of an analysis.
type AnalysisSourceTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source template of an analysis.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The dataset references of the source template of an analysis.
	//
	// DataSetReferences is a required field
	DataSetReferences []*DataSetReference `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceTemplate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisSourceTemplate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisSourceTemplate"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.DataSetReferences == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetReferences"))
	}
	if s.DataSetReferences != nil && len(s.DataSetReferences) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetReferences", 1))
	}
	if s.DataSetReferences != nil {
		for i, v := range s.DataSetReferences {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetReferences", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AnalysisSourceTemplate) SetArn(v string) *AnalysisSourceTemplate {
	s.Arn = &v
	return s
}

// SetDataSetReferences sets the DataSetReferences field's value.
func (s *AnalysisSourceTemplate) SetDataSetReferences(v []*DataSetReference) *AnalysisSourceTemplate {
	s.DataSetReferences = v
	return s
}

// The summary metadata that describes an analysis.
type AnalysisSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the analysis. This ID displays in the URL.
	AnalysisId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the analysis.
	Arn *string `type:"string"`

	// The time that the analysis was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The time that the analysis was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the analysis. This name is displayed in the Amazon QuickSight
	// console.
	Name *string `min:"1" type:"string"`

	// The last known status for the analysis.
	Status *string `type:"string" enum:"ResourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSummary) GoString() string {
	return s.String()
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *AnalysisSummary) SetAnalysisId(v string) *AnalysisSummary {
	s.AnalysisId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *AnalysisSummary) SetArn(v string) *AnalysisSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AnalysisSummary) SetCreatedTime(v time.Time) *AnalysisSummary {
	s.CreatedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *AnalysisSummary) SetLastUpdatedTime(v time.Time) *AnalysisSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalysisSummary) SetName(v string) *AnalysisSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalysisSummary) SetStatus(v string) *AnalysisSummary {
	s.Status = &v
	return s
}

// The date configuration of the filter.
type AnchorDateConfiguration struct {
	_ struct{} `type:"structure"`

	// The options for the date configuration. Choose one of the options below:
	//
	//    * NOW
	AnchorOption *string `type:"string" enum:"AnchorOption"`

	// The name of the parameter that is used for the anchor date configuration.
	ParameterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnchorDateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnchorDateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnchorDateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnchorDateConfiguration"}
	if s.ParameterName != nil && len(*s.ParameterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnchorOption sets the AnchorOption field's value.
func (s *AnchorDateConfiguration) SetAnchorOption(v string) *AnchorDateConfiguration {
	s.AnchorOption = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *AnchorDateConfiguration) SetParameterName(v string) *AnchorDateConfiguration {
	s.ParameterName = &v
	return s
}

// Information about the dashboard that you want to embed.
type AnonymousUserDashboardEmbeddingConfiguration struct {
	_ struct{} `type:"structure"`

	// The dashboard ID for the dashboard that you want the user to see first. This
	// ID is included in the output URL. When the URL in response is accessed, Amazon
	// QuickSight renders this dashboard.
	//
	// The Amazon Resource Name (ARN) of this dashboard must be included in the
	// AuthorizedResourceArns parameter. Otherwise, the request will fail with InvalidParameterValueException.
	//
	// InitialDashboardId is a required field
	InitialDashboardId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardEmbeddingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardEmbeddingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserDashboardEmbeddingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserDashboardEmbeddingConfiguration"}
	if s.InitialDashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialDashboardId"))
	}
	if s.InitialDashboardId != nil && len(*s.InitialDashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitialDashboardId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialDashboardId sets the InitialDashboardId field's value.
func (s *AnonymousUserDashboardEmbeddingConfiguration) SetInitialDashboardId(v string) *AnonymousUserDashboardEmbeddingConfiguration {
	s.InitialDashboardId = &v
	return s
}

// The experience that you are embedding. You can use this object to generate
// a url that embeds a visual into your application.
type AnonymousUserDashboardVisualEmbeddingConfiguration struct {
	_ struct{} `type:"structure"`

	// The visual ID for the visual that you want the user to see. This ID is included
	// in the output URL. When the URL in response is accessed, Amazon QuickSight
	// renders this visual.
	//
	// The Amazon Resource Name (ARN) of the dashboard that the visual belongs to
	// must be included in the AuthorizedResourceArns parameter. Otherwise, the
	// request will fail with InvalidParameterValueException.
	//
	// InitialDashboardVisualId is a required field
	InitialDashboardVisualId *DashboardVisualId `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardVisualEmbeddingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardVisualEmbeddingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserDashboardVisualEmbeddingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserDashboardVisualEmbeddingConfiguration"}
	if s.InitialDashboardVisualId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialDashboardVisualId"))
	}
	if s.InitialDashboardVisualId != nil {
		if err := s.InitialDashboardVisualId.Validate(); err != nil {
			invalidParams.AddNested("InitialDashboardVisualId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialDashboardVisualId sets the InitialDashboardVisualId field's value.
func (s *AnonymousUserDashboardVisualEmbeddingConfiguration) SetInitialDashboardVisualId(v *DashboardVisualId) *AnonymousUserDashboardVisualEmbeddingConfiguration {
	s.InitialDashboardVisualId = v
	return s
}

// The type of experience you want to embed. For anonymous users, you can embed
// Amazon QuickSight dashboards.
type AnonymousUserEmbeddingExperienceConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of embedding experience. In this case, Amazon QuickSight dashboards.
	Dashboard *AnonymousUserDashboardEmbeddingConfiguration `type:"structure"`

	// The type of embedding experience. In this case, Amazon QuickSight visuals.
	DashboardVisual *AnonymousUserDashboardVisualEmbeddingConfiguration `type:"structure"`

	// The Q search bar that you want to use for anonymous user embedding.
	QSearchBar *AnonymousUserQSearchBarEmbeddingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserEmbeddingExperienceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserEmbeddingExperienceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserEmbeddingExperienceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserEmbeddingExperienceConfiguration"}
	if s.Dashboard != nil {
		if err := s.Dashboard.Validate(); err != nil {
			invalidParams.AddNested("Dashboard", err.(request.ErrInvalidParams))
		}
	}
	if s.DashboardVisual != nil {
		if err := s.DashboardVisual.Validate(); err != nil {
			invalidParams.AddNested("DashboardVisual", err.(request.ErrInvalidParams))
		}
	}
	if s.QSearchBar != nil {
		if err := s.QSearchBar.Validate(); err != nil {
			invalidParams.AddNested("QSearchBar", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboard sets the Dashboard field's value.
func (s *AnonymousUserEmbeddingExperienceConfiguration) SetDashboard(v *AnonymousUserDashboardEmbeddingConfiguration) *AnonymousUserEmbeddingExperienceConfiguration {
	s.Dashboard = v
	return s
}

// SetDashboardVisual sets the DashboardVisual field's value.
func (s *AnonymousUserEmbeddingExperienceConfiguration) SetDashboardVisual(v *AnonymousUserDashboardVisualEmbeddingConfiguration) *AnonymousUserEmbeddingExperienceConfiguration {
	s.DashboardVisual = v
	return s
}

// SetQSearchBar sets the QSearchBar field's value.
func (s *AnonymousUserEmbeddingExperienceConfiguration) SetQSearchBar(v *AnonymousUserQSearchBarEmbeddingConfiguration) *AnonymousUserEmbeddingExperienceConfiguration {
	s.QSearchBar = v
	return s
}

// The settings that you want to use with the Q search bar.
type AnonymousUserQSearchBarEmbeddingConfiguration struct {
	_ struct{} `type:"structure"`

	// The QuickSight Q topic ID of the topic that you want the anonymous user to
	// see first. This ID is included in the output URL. When the URL in response
	// is accessed, Amazon QuickSight renders the Q search bar with this topic pre-selected.
	//
	// The Amazon Resource Name (ARN) of this Q topic must be included in the AuthorizedResourceArns
	// parameter. Otherwise, the request will fail with InvalidParameterValueException.
	//
	// InitialTopicId is a required field
	InitialTopicId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserQSearchBarEmbeddingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserQSearchBarEmbeddingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserQSearchBarEmbeddingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserQSearchBarEmbeddingConfiguration"}
	if s.InitialTopicId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialTopicId"))
	}
	if s.InitialTopicId != nil && len(*s.InitialTopicId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitialTopicId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialTopicId sets the InitialTopicId field's value.
func (s *AnonymousUserQSearchBarEmbeddingConfiguration) SetInitialTopicId(v string) *AnonymousUserQSearchBarEmbeddingConfiguration {
	s.InitialTopicId = &v
	return s
}

// A structure that contains the file groups that are requested for the artifact
// generation in a StartDashboardSnapshotJob API call.
type AnonymousUserSnapshotJobResult struct {
	_ struct{} `type:"structure"`

	// A list of SnapshotJobResultFileGroup objects that contain information on
	// the files that are requested during a StartDashboardSnapshotJob API call.
	// If the job succeeds, these objects contain the location where the snapshot
	// artifacts are stored. If the job fails, the objects contain information about
	// the error that caused the job to fail.
	FileGroups []*SnapshotJobResultFileGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserSnapshotJobResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserSnapshotJobResult) GoString() string {
	return s.String()
}

// SetFileGroups sets the FileGroups field's value.
func (s *AnonymousUserSnapshotJobResult) SetFileGroups(v []*SnapshotJobResultFileGroup) *AnonymousUserSnapshotJobResult {
	s.FileGroups = v
	return s
}

// The arc axis configuration of a GaugeChartVisual.
type ArcAxisConfiguration struct {
	_ struct{} `type:"structure"`

	// The arc axis range of a GaugeChartVisual.
	Range *ArcAxisDisplayRange `type:"structure"`

	// The reserved range of the arc axis.
	ReserveRange *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcAxisConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcAxisConfiguration) GoString() string {
	return s.String()
}

// SetRange sets the Range field's value.
func (s *ArcAxisConfiguration) SetRange(v *ArcAxisDisplayRange) *ArcAxisConfiguration {
	s.Range = v
	return s
}

// SetReserveRange sets the ReserveRange field's value.
func (s *ArcAxisConfiguration) SetReserveRange(v int64) *ArcAxisConfiguration {
	s.ReserveRange = &v
	return s
}

// The arc axis range of a GaugeChartVisual.
type ArcAxisDisplayRange struct {
	_ struct{} `type:"structure"`

	// The maximum value of the arc axis range.
	Max *float64 `type:"double"`

	// The minimum value of the arc axis range.
	Min *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcAxisDisplayRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcAxisDisplayRange) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *ArcAxisDisplayRange) SetMax(v float64) *ArcAxisDisplayRange {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *ArcAxisDisplayRange) SetMin(v float64) *ArcAxisDisplayRange {
	s.Min = &v
	return s
}

// The arc configuration of a GaugeChartVisual.
type ArcConfiguration struct {
	_ struct{} `type:"structure"`

	// The option that determines the arc angle of a GaugeChartVisual.
	ArcAngle *float64 `type:"double"`

	// The options that determine the arc thickness of a GaugeChartVisual.
	ArcThickness *string `type:"string" enum:"ArcThicknessOptions"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcConfiguration) GoString() string {
	return s.String()
}

// SetArcAngle sets the ArcAngle field's value.
func (s *ArcConfiguration) SetArcAngle(v float64) *ArcConfiguration {
	s.ArcAngle = &v
	return s
}

// SetArcThickness sets the ArcThickness field's value.
func (s *ArcConfiguration) SetArcThickness(v string) *ArcConfiguration {
	s.ArcThickness = &v
	return s
}

// The options that determine the arc thickness of a GaugeChartVisual.
type ArcOptions struct {
	_ struct{} `type:"structure"`

	// The arc thickness of a GaugeChartVisual.
	ArcThickness *string `type:"string" enum:"ArcThickness"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcOptions) GoString() string {
	return s.String()
}

// SetArcThickness sets the ArcThickness field's value.
func (s *ArcOptions) SetArcThickness(v string) *ArcOptions {
	s.ArcThickness = &v
	return s
}

// An optional collection of CloudFormation property configurations that control
// how the export job is generated.
type AssetBundleCloudFormationOverridePropertyConfiguration struct {
	_ struct{} `type:"structure"`

	// An optional list of structures that control how Analysis resources are parameterized
	// in the returned CloudFormation template.
	Analyses []*AssetBundleExportJobAnalysisOverrideProperties `min:"1" type:"list"`

	// An optional list of structures that control how Dashboard resources are parameterized
	// in the returned CloudFormation template.
	Dashboards []*AssetBundleExportJobDashboardOverrideProperties `min:"1" type:"list"`

	// An optional list of structures that control how DataSet resources are parameterized
	// in the returned CloudFormation template.
	DataSets []*AssetBundleExportJobDataSetOverrideProperties `min:"1" type:"list"`

	// An optional list of structures that control how DataSource resources are
	// parameterized in the returned CloudFormation template.
	DataSources []*AssetBundleExportJobDataSourceOverrideProperties `min:"1" type:"list"`

	// An optional list of structures that control how RefreshSchedule resources
	// are parameterized in the returned CloudFormation template.
	RefreshSchedules []*AssetBundleExportJobRefreshScheduleOverrideProperties `min:"1" type:"list"`

	// An optional list of structures that control how resource IDs are parameterized
	// in the returned CloudFormation template.
	ResourceIdOverrideConfiguration *AssetBundleExportJobResourceIdOverrideConfiguration `type:"structure"`

	// An optional list of structures that control how Theme resources are parameterized
	// in the returned CloudFormation template.
	Themes []*AssetBundleExportJobThemeOverrideProperties `min:"1" type:"list"`

	// An optional list of structures that control how VPCConnection resources are
	// parameterized in the returned CloudFormation template.
	VPCConnections []*AssetBundleExportJobVPCConnectionOverrideProperties `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleCloudFormationOverridePropertyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleCloudFormationOverridePropertyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleCloudFormationOverridePropertyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleCloudFormationOverridePropertyConfiguration"}
	if s.Analyses != nil && len(s.Analyses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Analyses", 1))
	}
	if s.Dashboards != nil && len(s.Dashboards) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Dashboards", 1))
	}
	if s.DataSets != nil && len(s.DataSets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSets", 1))
	}
	if s.DataSources != nil && len(s.DataSources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSources", 1))
	}
	if s.RefreshSchedules != nil && len(s.RefreshSchedules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RefreshSchedules", 1))
	}
	if s.Themes != nil && len(s.Themes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Themes", 1))
	}
	if s.VPCConnections != nil && len(s.VPCConnections) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCConnections", 1))
	}
	if s.Analyses != nil {
		for i, v := range s.Analyses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Analyses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Dashboards != nil {
		for i, v := range s.Dashboards {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dashboards", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSets != nil {
		for i, v := range s.DataSets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSources != nil {
		for i, v := range s.DataSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RefreshSchedules != nil {
		for i, v := range s.RefreshSchedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RefreshSchedules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Themes != nil {
		for i, v := range s.Themes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Themes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VPCConnections != nil {
		for i, v := range s.VPCConnections {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VPCConnections", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyses sets the Analyses field's value.
func (s *AssetBundleCloudFormationOverridePropertyConfiguration) SetAnalyses(v []*AssetBundleExportJobAnalysisOverrideProperties) *AssetBundleCloudFormationOverridePropertyConfiguration {
	s.Analyses = v
	return s
}

// SetDashboards sets the Dashboards field's value.
func (s *AssetBundleCloudFormationOverridePropertyConfiguration) SetDashboards(v []*AssetBundleExportJobDashboardOverrideProperties) *AssetBundleCloudFormationOverridePropertyConfiguration {
	s.Dashboards = v
	return s
}

// SetDataSets sets the DataSets field's value.
func (s *AssetBundleCloudFormationOverridePropertyConfiguration) SetDataSets(v []*AssetBundleExportJobDataSetOverrideProperties) *AssetBundleCloudFormationOverridePropertyConfiguration {
	s.DataSets = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *AssetBundleCloudFormationOverridePropertyConfiguration) SetDataSources(v []*AssetBundleExportJobDataSourceOverrideProperties) *AssetBundleCloudFormationOverridePropertyConfiguration {
	s.DataSources = v
	return s
}

// SetRefreshSchedules sets the RefreshSchedules field's value.
func (s *AssetBundleCloudFormationOverridePropertyConfiguration) SetRefreshSchedules(v []*AssetBundleExportJobRefreshScheduleOverrideProperties) *AssetBundleCloudFormationOverridePropertyConfiguration {
	s.RefreshSchedules = v
	return s
}

// SetResourceIdOverrideConfiguration sets the ResourceIdOverrideConfiguration field's value.
func (s *AssetBundleCloudFormationOverridePropertyConfiguration) SetResourceIdOverrideConfiguration(v *AssetBundleExportJobResourceIdOverrideConfiguration) *AssetBundleCloudFormationOverridePropertyConfiguration {
	s.ResourceIdOverrideConfiguration = v
	return s
}

// SetThemes sets the Themes field's value.
func (s *AssetBundleCloudFormationOverridePropertyConfiguration) SetThemes(v []*AssetBundleExportJobThemeOverrideProperties) *AssetBundleCloudFormationOverridePropertyConfiguration {
	s.Themes = v
	return s
}

// SetVPCConnections sets the VPCConnections field's value.
func (s *AssetBundleCloudFormationOverridePropertyConfiguration) SetVPCConnections(v []*AssetBundleExportJobVPCConnectionOverrideProperties) *AssetBundleCloudFormationOverridePropertyConfiguration {
	s.VPCConnections = v
	return s
}

// Controls how a specific Analysis resource is parameterized in the returned
// CloudFormation template.
type AssetBundleExportJobAnalysisOverrideProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the specific Analysis resource whose override properties are configured
	// in this structure.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A list of Analysis resource properties to generate variables for in the returned
	// CloudFormation template.
	//
	// Properties is a required field
	Properties []*string `min:"1" type:"list" required:"true" enum:"AssetBundleExportJobAnalysisPropertyToOverride"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobAnalysisOverrideProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobAnalysisOverrideProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleExportJobAnalysisOverrideProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleExportJobAnalysisOverrideProperties"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.Properties != nil && len(s.Properties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Properties", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobAnalysisOverrideProperties) SetArn(v string) *AssetBundleExportJobAnalysisOverrideProperties {
	s.Arn = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetBundleExportJobAnalysisOverrideProperties) SetProperties(v []*string) *AssetBundleExportJobAnalysisOverrideProperties {
	s.Properties = v
	return s
}

// Controls how a specific Dashboard resource is parameterized in the returned
// CloudFormation template.
type AssetBundleExportJobDashboardOverrideProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the specific Dashboard resource whose override properties are
	// configured in this structure.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A list of Dashboard resource properties to generate variables for in the
	// returned CloudFormation template.
	//
	// Properties is a required field
	Properties []*string `min:"1" type:"list" required:"true" enum:"AssetBundleExportJobDashboardPropertyToOverride"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobDashboardOverrideProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobDashboardOverrideProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleExportJobDashboardOverrideProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleExportJobDashboardOverrideProperties"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.Properties != nil && len(s.Properties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Properties", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobDashboardOverrideProperties) SetArn(v string) *AssetBundleExportJobDashboardOverrideProperties {
	s.Arn = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetBundleExportJobDashboardOverrideProperties) SetProperties(v []*string) *AssetBundleExportJobDashboardOverrideProperties {
	s.Properties = v
	return s
}

// Controls how a specific DataSet resource is parameterized in the returned
// CloudFormation template.
type AssetBundleExportJobDataSetOverrideProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the specific DataSet resource whose override properties are configured
	// in this structure.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A list of DataSet resource properties to generate variables for in the returned
	// CloudFormation template.
	//
	// Properties is a required field
	Properties []*string `min:"1" type:"list" required:"true" enum:"AssetBundleExportJobDataSetPropertyToOverride"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobDataSetOverrideProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobDataSetOverrideProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleExportJobDataSetOverrideProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleExportJobDataSetOverrideProperties"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.Properties != nil && len(s.Properties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Properties", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobDataSetOverrideProperties) SetArn(v string) *AssetBundleExportJobDataSetOverrideProperties {
	s.Arn = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetBundleExportJobDataSetOverrideProperties) SetProperties(v []*string) *AssetBundleExportJobDataSetOverrideProperties {
	s.Properties = v
	return s
}

// Controls how a specific DataSource resource is parameterized in the returned
// CloudFormation template.
type AssetBundleExportJobDataSourceOverrideProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the specific DataSource resource whose override properties are
	// configured in this structure.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A list of DataSource resource properties to generate variables for in the
	// returned CloudFormation template.
	//
	// Properties is a required field
	Properties []*string `min:"1" type:"list" required:"true" enum:"AssetBundleExportJobDataSourcePropertyToOverride"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobDataSourceOverrideProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobDataSourceOverrideProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleExportJobDataSourceOverrideProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleExportJobDataSourceOverrideProperties"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.Properties != nil && len(s.Properties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Properties", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobDataSourceOverrideProperties) SetArn(v string) *AssetBundleExportJobDataSourceOverrideProperties {
	s.Arn = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetBundleExportJobDataSourceOverrideProperties) SetProperties(v []*string) *AssetBundleExportJobDataSourceOverrideProperties {
	s.Properties = v
	return s
}

// Describes an error that occurred during an Asset Bundle export job.
type AssetBundleExportJobError struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource whose processing caused an error.
	Arn *string `type:"string"`

	// A description of the error.
	Message *string `type:"string"`

	// The specific error type of the error that occurred.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobError) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobError) SetArn(v string) *AssetBundleExportJobError {
	s.Arn = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AssetBundleExportJobError) SetMessage(v string) *AssetBundleExportJobError {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssetBundleExportJobError) SetType(v string) *AssetBundleExportJobError {
	s.Type = &v
	return s
}

// Controls how a specific RefreshSchedule resource is parameterized in the
// returned CloudFormation template.
type AssetBundleExportJobRefreshScheduleOverrideProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the specific RefreshSchedule resource whose override properties
	// are configured in this structure.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A list of RefreshSchedule resource properties to generate variables for in
	// the returned CloudFormation template.
	//
	// Properties is a required field
	Properties []*string `min:"1" type:"list" required:"true" enum:"AssetBundleExportJobRefreshSchedulePropertyToOverride"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobRefreshScheduleOverrideProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobRefreshScheduleOverrideProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleExportJobRefreshScheduleOverrideProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleExportJobRefreshScheduleOverrideProperties"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.Properties != nil && len(s.Properties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Properties", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobRefreshScheduleOverrideProperties) SetArn(v string) *AssetBundleExportJobRefreshScheduleOverrideProperties {
	s.Arn = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetBundleExportJobRefreshScheduleOverrideProperties) SetProperties(v []*string) *AssetBundleExportJobRefreshScheduleOverrideProperties {
	s.Properties = v
	return s
}

// An optional structure that configures resource ID overrides for the export
// job.
type AssetBundleExportJobResourceIdOverrideConfiguration struct {
	_ struct{} `type:"structure"`

	// An option to request a CloudFormation variable for a prefix to be prepended
	// to each resource's ID before import. The prefix is only added to the asset
	// IDs and does not change the name of the asset.
	PrefixForAllResources *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobResourceIdOverrideConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobResourceIdOverrideConfiguration) GoString() string {
	return s.String()
}

// SetPrefixForAllResources sets the PrefixForAllResources field's value.
func (s *AssetBundleExportJobResourceIdOverrideConfiguration) SetPrefixForAllResources(v bool) *AssetBundleExportJobResourceIdOverrideConfiguration {
	s.PrefixForAllResources = &v
	return s
}

// A summary of the export job that includes details of the job's configuration
// and its current status.
type AssetBundleExportJobSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the export job.
	Arn *string `type:"string"`

	// The ID of the export job.
	AssetBundleExportJobId *string `min:"1" type:"string"`

	// The time that the export job was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The format for the export job.
	ExportFormat *string `type:"string" enum:"AssetBundleExportFormat"`

	// The flag that determines the inclusion of resource dependencies in the returned
	// asset bundle.
	IncludeAllDependencies *bool `type:"boolean"`

	// The flag that determines the inclusion of permissions associated with each
	// resource ARN.
	IncludePermissions *bool `type:"boolean"`

	// The flag that determines the inclusion of tags associated with each resource
	// ARN.
	IncludeTags *bool `type:"boolean"`

	// The current status of the export job.
	JobStatus *string `type:"string" enum:"AssetBundleExportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobSummary) SetArn(v string) *AssetBundleExportJobSummary {
	s.Arn = &v
	return s
}

// SetAssetBundleExportJobId sets the AssetBundleExportJobId field's value.
func (s *AssetBundleExportJobSummary) SetAssetBundleExportJobId(v string) *AssetBundleExportJobSummary {
	s.AssetBundleExportJobId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AssetBundleExportJobSummary) SetCreatedTime(v time.Time) *AssetBundleExportJobSummary {
	s.CreatedTime = &v
	return s
}

// SetExportFormat sets the ExportFormat field's value.
func (s *AssetBundleExportJobSummary) SetExportFormat(v string) *AssetBundleExportJobSummary {
	s.ExportFormat = &v
	return s
}

// SetIncludeAllDependencies sets the IncludeAllDependencies field's value.
func (s *AssetBundleExportJobSummary) SetIncludeAllDependencies(v bool) *AssetBundleExportJobSummary {
	s.IncludeAllDependencies = &v
	return s
}

// SetIncludePermissions sets the IncludePermissions field's value.
func (s *AssetBundleExportJobSummary) SetIncludePermissions(v bool) *AssetBundleExportJobSummary {
	s.IncludePermissions = &v
	return s
}

// SetIncludeTags sets the IncludeTags field's value.
func (s *AssetBundleExportJobSummary) SetIncludeTags(v bool) *AssetBundleExportJobSummary {
	s.IncludeTags = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *AssetBundleExportJobSummary) SetJobStatus(v string) *AssetBundleExportJobSummary {
	s.JobStatus = &v
	return s
}

// Controls how a specific Theme resource is parameterized in the returned CloudFormation
// template.
type AssetBundleExportJobThemeOverrideProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the specific Theme resource whose override properties are configured
	// in this structure.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A list of Theme resource properties to generate variables for in the returned
	// CloudFormation template.
	//
	// Properties is a required field
	Properties []*string `min:"1" type:"list" required:"true" enum:"AssetBundleExportJobThemePropertyToOverride"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobThemeOverrideProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobThemeOverrideProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleExportJobThemeOverrideProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleExportJobThemeOverrideProperties"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.Properties != nil && len(s.Properties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Properties", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobThemeOverrideProperties) SetArn(v string) *AssetBundleExportJobThemeOverrideProperties {
	s.Arn = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetBundleExportJobThemeOverrideProperties) SetProperties(v []*string) *AssetBundleExportJobThemeOverrideProperties {
	s.Properties = v
	return s
}

// Controls how a specific VPCConnection resource is parameterized in the outputted
// CloudFormation template.
type AssetBundleExportJobVPCConnectionOverrideProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the specific VPCConnection resource whose override properties
	// are configured in this structure.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A list of VPCConnection resource properties to generate variables for in
	// the returned CloudFormation template.
	//
	// Properties is a required field
	Properties []*string `min:"1" type:"list" required:"true" enum:"AssetBundleExportJobVPCConnectionPropertyToOverride"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobVPCConnectionOverrideProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobVPCConnectionOverrideProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleExportJobVPCConnectionOverrideProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleExportJobVPCConnectionOverrideProperties"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.Properties != nil && len(s.Properties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Properties", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobVPCConnectionOverrideProperties) SetArn(v string) *AssetBundleExportJobVPCConnectionOverrideProperties {
	s.Arn = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *AssetBundleExportJobVPCConnectionOverrideProperties) SetProperties(v []*string) *AssetBundleExportJobVPCConnectionOverrideProperties {
	s.Properties = v
	return s
}

// The option to relax the validation that is required to export each asset.
// When StrictModeForAllResource is set to true, validation is skipped for specific
// UI errors.
type AssetBundleExportJobValidationStrategy struct {
	_ struct{} `type:"structure"`

	// A Boolean value that indicates whether to export resources under strict or
	// lenient mode.
	StrictModeForAllResources *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobValidationStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobValidationStrategy) GoString() string {
	return s.String()
}

// SetStrictModeForAllResources sets the StrictModeForAllResources field's value.
func (s *AssetBundleExportJobValidationStrategy) SetStrictModeForAllResources(v bool) *AssetBundleExportJobValidationStrategy {
	s.StrictModeForAllResources = &v
	return s
}

// Describes a warning that occurred during an Asset Bundle export job.
type AssetBundleExportJobWarning struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource whose processing caused a warning.
	Arn *string `type:"string"`

	// A description of the warning.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobWarning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleExportJobWarning) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetBundleExportJobWarning) SetArn(v string) *AssetBundleExportJobWarning {
	s.Arn = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AssetBundleExportJobWarning) SetMessage(v string) *AssetBundleExportJobWarning {
	s.Message = &v
	return s
}

// The override parameters for a single analysis that is being imported.
type AssetBundleImportJobAnalysisOverrideParameters struct {
	_ struct{} `type:"structure"`

	// The ID of the analysis that you ant to apply overrides to.
	//
	// AnalysisId is a required field
	AnalysisId *string `type:"string" required:"true"`

	// A new name for the analysis.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobAnalysisOverrideParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobAnalysisOverrideParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobAnalysisOverrideParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobAnalysisOverrideParameters"}
	if s.AnalysisId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *AssetBundleImportJobAnalysisOverrideParameters) SetAnalysisId(v string) *AssetBundleImportJobAnalysisOverrideParameters {
	s.AnalysisId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetBundleImportJobAnalysisOverrideParameters) SetName(v string) *AssetBundleImportJobAnalysisOverrideParameters {
	s.Name = &v
	return s
}

// An object that contains a list of permissions to be applied to a list of
// analysis IDs.
type AssetBundleImportJobAnalysisOverridePermissions struct {
	_ struct{} `type:"structure"`

	// A list of analysis IDs that you want to apply overrides to. You can use *
	// to override all analyses in this asset bundle.
	//
	// AnalysisIds is a required field
	AnalysisIds []*string `min:"1" type:"list" required:"true"`

	// A list of permissions for the analyses that you want to apply overrides to.
	//
	// Permissions is a required field
	Permissions *AssetBundleResourcePermissions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobAnalysisOverridePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobAnalysisOverridePermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobAnalysisOverridePermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobAnalysisOverridePermissions"}
	if s.AnalysisIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisIds"))
	}
	if s.AnalysisIds != nil && len(s.AnalysisIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisIds", 1))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.Permissions != nil {
		if err := s.Permissions.Validate(); err != nil {
			invalidParams.AddNested("Permissions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisIds sets the AnalysisIds field's value.
func (s *AssetBundleImportJobAnalysisOverridePermissions) SetAnalysisIds(v []*string) *AssetBundleImportJobAnalysisOverridePermissions {
	s.AnalysisIds = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *AssetBundleImportJobAnalysisOverridePermissions) SetPermissions(v *AssetBundleResourcePermissions) *AssetBundleImportJobAnalysisOverridePermissions {
	s.Permissions = v
	return s
}

// An object that contains a list of tags to be assigned to a list of analysis
// IDs.
type AssetBundleImportJobAnalysisOverrideTags struct {
	_ struct{} `type:"structure"`

	// A list of analysis IDs that you want to apply overrides to. You can use *
	// to override all analyses in this asset bundle.
	//
	// AnalysisIds is a required field
	AnalysisIds []*string `min:"1" type:"list" required:"true"`

	// A list of tags for the analyses that you want to apply overrides to.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobAnalysisOverrideTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobAnalysisOverrideTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobAnalysisOverrideTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobAnalysisOverrideTags"}
	if s.AnalysisIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisIds"))
	}
	if s.AnalysisIds != nil && len(s.AnalysisIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisIds", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisIds sets the AnalysisIds field's value.
func (s *AssetBundleImportJobAnalysisOverrideTags) SetAnalysisIds(v []*string) *AssetBundleImportJobAnalysisOverrideTags {
	s.AnalysisIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssetBundleImportJobAnalysisOverrideTags) SetTags(v []*Tag) *AssetBundleImportJobAnalysisOverrideTags {
	s.Tags = v
	return s
}

// The override parameters for a single dashboard that is being imported.
type AssetBundleImportJobDashboardOverrideParameters struct {
	_ struct{} `type:"structure"`

	// The ID of the dashboard that you want to apply overrides to.
	//
	// DashboardId is a required field
	DashboardId *string `type:"string" required:"true"`

	// A new name for the dashboard.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDashboardOverrideParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDashboardOverrideParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDashboardOverrideParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDashboardOverrideParameters"}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardId sets the DashboardId field's value.
func (s *AssetBundleImportJobDashboardOverrideParameters) SetDashboardId(v string) *AssetBundleImportJobDashboardOverrideParameters {
	s.DashboardId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetBundleImportJobDashboardOverrideParameters) SetName(v string) *AssetBundleImportJobDashboardOverrideParameters {
	s.Name = &v
	return s
}

// An object that contains a list of permissions to be applied to a list of
// dashboard IDs.
type AssetBundleImportJobDashboardOverridePermissions struct {
	_ struct{} `type:"structure"`

	// A list of dashboard IDs that you want to apply overrides to. You can use
	// * to override all dashboards in this asset bundle.
	//
	// DashboardIds is a required field
	DashboardIds []*string `min:"1" type:"list" required:"true"`

	// A structure that contains the link sharing configurations that you want to
	// apply overrides to.
	LinkSharingConfiguration *AssetBundleResourceLinkSharingConfiguration `type:"structure"`

	// A list of permissions for the dashboards that you want to apply overrides
	// to.
	Permissions *AssetBundleResourcePermissions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDashboardOverridePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDashboardOverridePermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDashboardOverridePermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDashboardOverridePermissions"}
	if s.DashboardIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardIds"))
	}
	if s.DashboardIds != nil && len(s.DashboardIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardIds", 1))
	}
	if s.LinkSharingConfiguration != nil {
		if err := s.LinkSharingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LinkSharingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		if err := s.Permissions.Validate(); err != nil {
			invalidParams.AddNested("Permissions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardIds sets the DashboardIds field's value.
func (s *AssetBundleImportJobDashboardOverridePermissions) SetDashboardIds(v []*string) *AssetBundleImportJobDashboardOverridePermissions {
	s.DashboardIds = v
	return s
}

// SetLinkSharingConfiguration sets the LinkSharingConfiguration field's value.
func (s *AssetBundleImportJobDashboardOverridePermissions) SetLinkSharingConfiguration(v *AssetBundleResourceLinkSharingConfiguration) *AssetBundleImportJobDashboardOverridePermissions {
	s.LinkSharingConfiguration = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *AssetBundleImportJobDashboardOverridePermissions) SetPermissions(v *AssetBundleResourcePermissions) *AssetBundleImportJobDashboardOverridePermissions {
	s.Permissions = v
	return s
}

// An object that contains a list of tags to be assigned to a list of dashboard
// IDs.
type AssetBundleImportJobDashboardOverrideTags struct {
	_ struct{} `type:"structure"`

	// A list of dashboard IDs that you want to apply overrides to. You can use
	// * to override all dashboards in this asset bundle.
	//
	// DashboardIds is a required field
	DashboardIds []*string `min:"1" type:"list" required:"true"`

	// A list of tags for the dashboards that you want to apply overrides to.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDashboardOverrideTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDashboardOverrideTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDashboardOverrideTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDashboardOverrideTags"}
	if s.DashboardIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardIds"))
	}
	if s.DashboardIds != nil && len(s.DashboardIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardIds", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardIds sets the DashboardIds field's value.
func (s *AssetBundleImportJobDashboardOverrideTags) SetDashboardIds(v []*string) *AssetBundleImportJobDashboardOverrideTags {
	s.DashboardIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssetBundleImportJobDashboardOverrideTags) SetTags(v []*Tag) *AssetBundleImportJobDashboardOverrideTags {
	s.Tags = v
	return s
}

// The override parameters for a single dataset that is being imported.
type AssetBundleImportJobDataSetOverrideParameters struct {
	_ struct{} `type:"structure"`

	// The ID of the dataset to apply overrides to.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// A new name for the dataset.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSetOverrideParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSetOverrideParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDataSetOverrideParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDataSetOverrideParameters"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *AssetBundleImportJobDataSetOverrideParameters) SetDataSetId(v string) *AssetBundleImportJobDataSetOverrideParameters {
	s.DataSetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetBundleImportJobDataSetOverrideParameters) SetName(v string) *AssetBundleImportJobDataSetOverrideParameters {
	s.Name = &v
	return s
}

// An object that contains a list of permissions to be applied to a list of
// dataset IDs.
type AssetBundleImportJobDataSetOverridePermissions struct {
	_ struct{} `type:"structure"`

	// A list of dataset IDs that you want to apply overrides to. You can use *
	// to override all datasets in this asset bundle.
	//
	// DataSetIds is a required field
	DataSetIds []*string `min:"1" type:"list" required:"true"`

	// A list of permissions for the datasets that you want to apply overrides to.
	//
	// Permissions is a required field
	Permissions *AssetBundleResourcePermissions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSetOverridePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSetOverridePermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDataSetOverridePermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDataSetOverridePermissions"}
	if s.DataSetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetIds"))
	}
	if s.DataSetIds != nil && len(s.DataSetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetIds", 1))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.Permissions != nil {
		if err := s.Permissions.Validate(); err != nil {
			invalidParams.AddNested("Permissions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetIds sets the DataSetIds field's value.
func (s *AssetBundleImportJobDataSetOverridePermissions) SetDataSetIds(v []*string) *AssetBundleImportJobDataSetOverridePermissions {
	s.DataSetIds = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *AssetBundleImportJobDataSetOverridePermissions) SetPermissions(v *AssetBundleResourcePermissions) *AssetBundleImportJobDataSetOverridePermissions {
	s.Permissions = v
	return s
}

// An object that contains a list of tags to be assigned to a list of dataset
// IDs.
type AssetBundleImportJobDataSetOverrideTags struct {
	_ struct{} `type:"structure"`

	// A list of dataset IDs that you want to apply overrides to. You can use *
	// to override all datasets in this asset bundle.
	//
	// DataSetIds is a required field
	DataSetIds []*string `min:"1" type:"list" required:"true"`

	// A list of tags for the datasets that you want to apply overrides to.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSetOverrideTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSetOverrideTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDataSetOverrideTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDataSetOverrideTags"}
	if s.DataSetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetIds"))
	}
	if s.DataSetIds != nil && len(s.DataSetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetIds", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetIds sets the DataSetIds field's value.
func (s *AssetBundleImportJobDataSetOverrideTags) SetDataSetIds(v []*string) *AssetBundleImportJobDataSetOverrideTags {
	s.DataSetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssetBundleImportJobDataSetOverrideTags) SetTags(v []*Tag) *AssetBundleImportJobDataSetOverrideTags {
	s.Tags = v
	return s
}

// A username and password credential pair to use to import a data source resource.
type AssetBundleImportJobDataSourceCredentialPair struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The password for the data source connection.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true"`

	// The username for the data source connection.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceCredentialPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceCredentialPair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDataSourceCredentialPair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDataSourceCredentialPair"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *AssetBundleImportJobDataSourceCredentialPair) SetPassword(v string) *AssetBundleImportJobDataSourceCredentialPair {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AssetBundleImportJobDataSourceCredentialPair) SetUsername(v string) *AssetBundleImportJobDataSourceCredentialPair {
	s.Username = &v
	return s
}

// The login credentials to use to import a data source resource.
type AssetBundleImportJobDataSourceCredentials struct {
	_ struct{} `type:"structure"`

	// A username and password credential pair to be used to create the imported
	// data source. Keep this field blank if you are using a Secrets Manager secret
	// to provide credentials.
	//
	// CredentialPair is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetBundleImportJobDataSourceCredentials's
	// String and GoString methods.
	CredentialPair *AssetBundleImportJobDataSourceCredentialPair `type:"structure" sensitive:"true"`

	// The ARN of the Secrets Manager secret that's used to create the imported
	// data source. Keep this field blank, unless you are using a secret in place
	// of a credential pair.
	SecretArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDataSourceCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDataSourceCredentials"}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.CredentialPair != nil {
		if err := s.CredentialPair.Validate(); err != nil {
			invalidParams.AddNested("CredentialPair", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialPair sets the CredentialPair field's value.
func (s *AssetBundleImportJobDataSourceCredentials) SetCredentialPair(v *AssetBundleImportJobDataSourceCredentialPair) *AssetBundleImportJobDataSourceCredentials {
	s.CredentialPair = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *AssetBundleImportJobDataSourceCredentials) SetSecretArn(v string) *AssetBundleImportJobDataSourceCredentials {
	s.SecretArn = &v
	return s
}

// The override parameters for a single data source that is being imported.
type AssetBundleImportJobDataSourceOverrideParameters struct {
	_ struct{} `type:"structure"`

	// An optional structure that provides the credentials to be used to create
	// the imported data source.
	Credentials *AssetBundleImportJobDataSourceCredentials `type:"structure"`

	// The ID of the data source to apply overrides to.
	//
	// DataSourceId is a required field
	DataSourceId *string `type:"string" required:"true"`

	// The parameters that Amazon QuickSight uses to connect to your underlying
	// data source. This is a variant type structure. For this structure to be valid,
	// only one of the attributes can be non-null.
	DataSourceParameters *DataSourceParameters `type:"structure"`

	// A new name for the data source.
	Name *string `min:"1" type:"string"`

	// Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects
	// to your underlying data source.
	SslProperties *SslProperties `type:"structure"`

	// VPC connection properties.
	VpcConnectionProperties *VpcConnectionProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceOverrideParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceOverrideParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDataSourceOverrideParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDataSourceOverrideParameters"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}
	if s.DataSourceParameters != nil {
		if err := s.DataSourceParameters.Validate(); err != nil {
			invalidParams.AddNested("DataSourceParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConnectionProperties != nil {
		if err := s.VpcConnectionProperties.Validate(); err != nil {
			invalidParams.AddNested("VpcConnectionProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentials sets the Credentials field's value.
func (s *AssetBundleImportJobDataSourceOverrideParameters) SetCredentials(v *AssetBundleImportJobDataSourceCredentials) *AssetBundleImportJobDataSourceOverrideParameters {
	s.Credentials = v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *AssetBundleImportJobDataSourceOverrideParameters) SetDataSourceId(v string) *AssetBundleImportJobDataSourceOverrideParameters {
	s.DataSourceId = &v
	return s
}

// SetDataSourceParameters sets the DataSourceParameters field's value.
func (s *AssetBundleImportJobDataSourceOverrideParameters) SetDataSourceParameters(v *DataSourceParameters) *AssetBundleImportJobDataSourceOverrideParameters {
	s.DataSourceParameters = v
	return s
}

// SetName sets the Name field's value.
func (s *AssetBundleImportJobDataSourceOverrideParameters) SetName(v string) *AssetBundleImportJobDataSourceOverrideParameters {
	s.Name = &v
	return s
}

// SetSslProperties sets the SslProperties field's value.
func (s *AssetBundleImportJobDataSourceOverrideParameters) SetSslProperties(v *SslProperties) *AssetBundleImportJobDataSourceOverrideParameters {
	s.SslProperties = v
	return s
}

// SetVpcConnectionProperties sets the VpcConnectionProperties field's value.
func (s *AssetBundleImportJobDataSourceOverrideParameters) SetVpcConnectionProperties(v *VpcConnectionProperties) *AssetBundleImportJobDataSourceOverrideParameters {
	s.VpcConnectionProperties = v
	return s
}

// An object that contains a list of permissions to be applied to a list of
// data source IDs.
type AssetBundleImportJobDataSourceOverridePermissions struct {
	_ struct{} `type:"structure"`

	// A list of data source IDs that you want to apply overrides to. You can use
	// * to override all data sources in this asset bundle.
	//
	// DataSourceIds is a required field
	DataSourceIds []*string `min:"1" type:"list" required:"true"`

	// A list of permissions for the data source that you want to apply overrides
	// to.
	//
	// Permissions is a required field
	Permissions *AssetBundleResourcePermissions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceOverridePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceOverridePermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDataSourceOverridePermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDataSourceOverridePermissions"}
	if s.DataSourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceIds"))
	}
	if s.DataSourceIds != nil && len(s.DataSourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceIds", 1))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.Permissions != nil {
		if err := s.Permissions.Validate(); err != nil {
			invalidParams.AddNested("Permissions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceIds sets the DataSourceIds field's value.
func (s *AssetBundleImportJobDataSourceOverridePermissions) SetDataSourceIds(v []*string) *AssetBundleImportJobDataSourceOverridePermissions {
	s.DataSourceIds = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *AssetBundleImportJobDataSourceOverridePermissions) SetPermissions(v *AssetBundleResourcePermissions) *AssetBundleImportJobDataSourceOverridePermissions {
	s.Permissions = v
	return s
}

// An object that contains a list of tags to be assigned to a list of data source
// IDs.
type AssetBundleImportJobDataSourceOverrideTags struct {
	_ struct{} `type:"structure"`

	// A list of data source IDs that you want to apply overrides to. You can use
	// * to override all data sources in this asset bundle.
	//
	// DataSourceIds is a required field
	DataSourceIds []*string `min:"1" type:"list" required:"true"`

	// A list of tags for the data source that you want to apply overrides to.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceOverrideTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobDataSourceOverrideTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobDataSourceOverrideTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobDataSourceOverrideTags"}
	if s.DataSourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceIds"))
	}
	if s.DataSourceIds != nil && len(s.DataSourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceIds", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceIds sets the DataSourceIds field's value.
func (s *AssetBundleImportJobDataSourceOverrideTags) SetDataSourceIds(v []*string) *AssetBundleImportJobDataSourceOverrideTags {
	s.DataSourceIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssetBundleImportJobDataSourceOverrideTags) SetTags(v []*Tag) *AssetBundleImportJobDataSourceOverrideTags {
	s.Tags = v
	return s
}

// Describes an error that occurred within an Asset Bundle import execution.
type AssetBundleImportJobError struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource whose processing caused an error.
	Arn *string `type:"string"`

	// A description of the error.
	Message *string `type:"string"`

	// The specific error type or the error that occurred.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobError) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetBundleImportJobError) SetArn(v string) *AssetBundleImportJobError {
	s.Arn = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AssetBundleImportJobError) SetMessage(v string) *AssetBundleImportJobError {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssetBundleImportJobError) SetType(v string) *AssetBundleImportJobError {
	s.Type = &v
	return s
}

// A list of overrides that modify the asset bundle resource configuration before
// the resource is imported.
type AssetBundleImportJobOverrideParameters struct {
	_ struct{} `type:"structure"`

	// A list of overrides for any Analysis resources that are present in the asset
	// bundle that is imported.
	Analyses []*AssetBundleImportJobAnalysisOverrideParameters `min:"1" type:"list"`

	// A list of overrides for any Dashboard resources that are present in the asset
	// bundle that is imported.
	Dashboards []*AssetBundleImportJobDashboardOverrideParameters `min:"1" type:"list"`

	// A list of overrides for any DataSet resources that are present in the asset
	// bundle that is imported.
	DataSets []*AssetBundleImportJobDataSetOverrideParameters `min:"1" type:"list"`

	// A list of overrides for any DataSource resources that are present in the
	// asset bundle that is imported.
	DataSources []*AssetBundleImportJobDataSourceOverrideParameters `min:"1" type:"list"`

	// A list of overrides for any RefreshSchedule resources that are present in
	// the asset bundle that is imported.
	RefreshSchedules []*AssetBundleImportJobRefreshScheduleOverrideParameters `min:"1" type:"list"`

	// An optional structure that configures resource ID overrides to be applied
	// within the import job.
	ResourceIdOverrideConfiguration *AssetBundleImportJobResourceIdOverrideConfiguration `type:"structure"`

	// A list of overrides for any Theme resources that are present in the asset
	// bundle that is imported.
	Themes []*AssetBundleImportJobThemeOverrideParameters `min:"1" type:"list"`

	// A list of overrides for any VPCConnection resources that are present in the
	// asset bundle that is imported.
	VPCConnections []*AssetBundleImportJobVPCConnectionOverrideParameters `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobOverrideParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobOverrideParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobOverrideParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobOverrideParameters"}
	if s.Analyses != nil && len(s.Analyses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Analyses", 1))
	}
	if s.Dashboards != nil && len(s.Dashboards) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Dashboards", 1))
	}
	if s.DataSets != nil && len(s.DataSets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSets", 1))
	}
	if s.DataSources != nil && len(s.DataSources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSources", 1))
	}
	if s.RefreshSchedules != nil && len(s.RefreshSchedules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RefreshSchedules", 1))
	}
	if s.Themes != nil && len(s.Themes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Themes", 1))
	}
	if s.VPCConnections != nil && len(s.VPCConnections) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCConnections", 1))
	}
	if s.Analyses != nil {
		for i, v := range s.Analyses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Analyses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Dashboards != nil {
		for i, v := range s.Dashboards {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dashboards", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSets != nil {
		for i, v := range s.DataSets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSources != nil {
		for i, v := range s.DataSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RefreshSchedules != nil {
		for i, v := range s.RefreshSchedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RefreshSchedules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Themes != nil {
		for i, v := range s.Themes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Themes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VPCConnections != nil {
		for i, v := range s.VPCConnections {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VPCConnections", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyses sets the Analyses field's value.
func (s *AssetBundleImportJobOverrideParameters) SetAnalyses(v []*AssetBundleImportJobAnalysisOverrideParameters) *AssetBundleImportJobOverrideParameters {
	s.Analyses = v
	return s
}

// SetDashboards sets the Dashboards field's value.
func (s *AssetBundleImportJobOverrideParameters) SetDashboards(v []*AssetBundleImportJobDashboardOverrideParameters) *AssetBundleImportJobOverrideParameters {
	s.Dashboards = v
	return s
}

// SetDataSets sets the DataSets field's value.
func (s *AssetBundleImportJobOverrideParameters) SetDataSets(v []*AssetBundleImportJobDataSetOverrideParameters) *AssetBundleImportJobOverrideParameters {
	s.DataSets = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *AssetBundleImportJobOverrideParameters) SetDataSources(v []*AssetBundleImportJobDataSourceOverrideParameters) *AssetBundleImportJobOverrideParameters {
	s.DataSources = v
	return s
}

// SetRefreshSchedules sets the RefreshSchedules field's value.
func (s *AssetBundleImportJobOverrideParameters) SetRefreshSchedules(v []*AssetBundleImportJobRefreshScheduleOverrideParameters) *AssetBundleImportJobOverrideParameters {
	s.RefreshSchedules = v
	return s
}

// SetResourceIdOverrideConfiguration sets the ResourceIdOverrideConfiguration field's value.
func (s *AssetBundleImportJobOverrideParameters) SetResourceIdOverrideConfiguration(v *AssetBundleImportJobResourceIdOverrideConfiguration) *AssetBundleImportJobOverrideParameters {
	s.ResourceIdOverrideConfiguration = v
	return s
}

// SetThemes sets the Themes field's value.
func (s *AssetBundleImportJobOverrideParameters) SetThemes(v []*AssetBundleImportJobThemeOverrideParameters) *AssetBundleImportJobOverrideParameters {
	s.Themes = v
	return s
}

// SetVPCConnections sets the VPCConnections field's value.
func (s *AssetBundleImportJobOverrideParameters) SetVPCConnections(v []*AssetBundleImportJobVPCConnectionOverrideParameters) *AssetBundleImportJobOverrideParameters {
	s.VPCConnections = v
	return s
}

// A structure that contains the override permission configurations that modify
// the permissions for specified resources before the resource is imported.
type AssetBundleImportJobOverridePermissions struct {
	_ struct{} `type:"structure"`

	// A list of permissions overrides for any Analysis resources that are present
	// in the asset bundle that is imported.
	Analyses []*AssetBundleImportJobAnalysisOverridePermissions `min:"1" type:"list"`

	// A list of permissions overrides for any Dashboard resources that are present
	// in the asset bundle that is imported.
	Dashboards []*AssetBundleImportJobDashboardOverridePermissions `min:"1" type:"list"`

	// A list of permissions overrides for any DataSet resources that are present
	// in the asset bundle that is imported.
	DataSets []*AssetBundleImportJobDataSetOverridePermissions `min:"1" type:"list"`

	// A list of permissions overrides for any DataSource resources that are present
	// in the asset bundle that is imported.
	DataSources []*AssetBundleImportJobDataSourceOverridePermissions `min:"1" type:"list"`

	// A list of permissions overrides for any Theme resources that are present
	// in the asset bundle that is imported.
	Themes []*AssetBundleImportJobThemeOverridePermissions `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobOverridePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobOverridePermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobOverridePermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobOverridePermissions"}
	if s.Analyses != nil && len(s.Analyses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Analyses", 1))
	}
	if s.Dashboards != nil && len(s.Dashboards) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Dashboards", 1))
	}
	if s.DataSets != nil && len(s.DataSets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSets", 1))
	}
	if s.DataSources != nil && len(s.DataSources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSources", 1))
	}
	if s.Themes != nil && len(s.Themes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Themes", 1))
	}
	if s.Analyses != nil {
		for i, v := range s.Analyses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Analyses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Dashboards != nil {
		for i, v := range s.Dashboards {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dashboards", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSets != nil {
		for i, v := range s.DataSets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSources != nil {
		for i, v := range s.DataSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Themes != nil {
		for i, v := range s.Themes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Themes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyses sets the Analyses field's value.
func (s *AssetBundleImportJobOverridePermissions) SetAnalyses(v []*AssetBundleImportJobAnalysisOverridePermissions) *AssetBundleImportJobOverridePermissions {
	s.Analyses = v
	return s
}

// SetDashboards sets the Dashboards field's value.
func (s *AssetBundleImportJobOverridePermissions) SetDashboards(v []*AssetBundleImportJobDashboardOverridePermissions) *AssetBundleImportJobOverridePermissions {
	s.Dashboards = v
	return s
}

// SetDataSets sets the DataSets field's value.
func (s *AssetBundleImportJobOverridePermissions) SetDataSets(v []*AssetBundleImportJobDataSetOverridePermissions) *AssetBundleImportJobOverridePermissions {
	s.DataSets = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *AssetBundleImportJobOverridePermissions) SetDataSources(v []*AssetBundleImportJobDataSourceOverridePermissions) *AssetBundleImportJobOverridePermissions {
	s.DataSources = v
	return s
}

// SetThemes sets the Themes field's value.
func (s *AssetBundleImportJobOverridePermissions) SetThemes(v []*AssetBundleImportJobThemeOverridePermissions) *AssetBundleImportJobOverridePermissions {
	s.Themes = v
	return s
}

// A structure that contains the override tag configuration that modify the
// tags that are assigned to specified resources before the resource is imported.
type AssetBundleImportJobOverrideTags struct {
	_ struct{} `type:"structure"`

	// A list of tag overrides for any Analysis resources that are present in the
	// asset bundle that is imported.
	Analyses []*AssetBundleImportJobAnalysisOverrideTags `min:"1" type:"list"`

	// A list of tag overrides for any Dashboard resources that are present in the
	// asset bundle that is imported.
	Dashboards []*AssetBundleImportJobDashboardOverrideTags `min:"1" type:"list"`

	// A list of tag overrides for any DataSet resources that are present in the
	// asset bundle that is imported.
	DataSets []*AssetBundleImportJobDataSetOverrideTags `min:"1" type:"list"`

	// A list of tag overrides for any DataSource resources that are present in
	// the asset bundle that is imported.
	DataSources []*AssetBundleImportJobDataSourceOverrideTags `min:"1" type:"list"`

	// A list of tag overrides for any Theme resources that are present in the asset
	// bundle that is imported.
	Themes []*AssetBundleImportJobThemeOverrideTags `min:"1" type:"list"`

	// A list of tag overrides for any VPCConnection resources that are present
	// in the asset bundle that is imported.
	VPCConnections []*AssetBundleImportJobVPCConnectionOverrideTags `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobOverrideTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobOverrideTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobOverrideTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobOverrideTags"}
	if s.Analyses != nil && len(s.Analyses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Analyses", 1))
	}
	if s.Dashboards != nil && len(s.Dashboards) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Dashboards", 1))
	}
	if s.DataSets != nil && len(s.DataSets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSets", 1))
	}
	if s.DataSources != nil && len(s.DataSources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSources", 1))
	}
	if s.Themes != nil && len(s.Themes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Themes", 1))
	}
	if s.VPCConnections != nil && len(s.VPCConnections) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCConnections", 1))
	}
	if s.Analyses != nil {
		for i, v := range s.Analyses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Analyses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Dashboards != nil {
		for i, v := range s.Dashboards {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dashboards", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSets != nil {
		for i, v := range s.DataSets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSources != nil {
		for i, v := range s.DataSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Themes != nil {
		for i, v := range s.Themes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Themes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VPCConnections != nil {
		for i, v := range s.VPCConnections {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VPCConnections", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyses sets the Analyses field's value.
func (s *AssetBundleImportJobOverrideTags) SetAnalyses(v []*AssetBundleImportJobAnalysisOverrideTags) *AssetBundleImportJobOverrideTags {
	s.Analyses = v
	return s
}

// SetDashboards sets the Dashboards field's value.
func (s *AssetBundleImportJobOverrideTags) SetDashboards(v []*AssetBundleImportJobDashboardOverrideTags) *AssetBundleImportJobOverrideTags {
	s.Dashboards = v
	return s
}

// SetDataSets sets the DataSets field's value.
func (s *AssetBundleImportJobOverrideTags) SetDataSets(v []*AssetBundleImportJobDataSetOverrideTags) *AssetBundleImportJobOverrideTags {
	s.DataSets = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *AssetBundleImportJobOverrideTags) SetDataSources(v []*AssetBundleImportJobDataSourceOverrideTags) *AssetBundleImportJobOverrideTags {
	s.DataSources = v
	return s
}

// SetThemes sets the Themes field's value.
func (s *AssetBundleImportJobOverrideTags) SetThemes(v []*AssetBundleImportJobThemeOverrideTags) *AssetBundleImportJobOverrideTags {
	s.Themes = v
	return s
}

// SetVPCConnections sets the VPCConnections field's value.
func (s *AssetBundleImportJobOverrideTags) SetVPCConnections(v []*AssetBundleImportJobVPCConnectionOverrideTags) *AssetBundleImportJobOverrideTags {
	s.VPCConnections = v
	return s
}

// An optional parameter that overrides the validation strategy for all analyses
// and dashboards before the resource is imported.
type AssetBundleImportJobOverrideValidationStrategy struct {
	_ struct{} `type:"structure"`

	// A Boolean value that indicates whether to import all analyses and dashboards
	// under strict or lenient mode.
	StrictModeForAllResources *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobOverrideValidationStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobOverrideValidationStrategy) GoString() string {
	return s.String()
}

// SetStrictModeForAllResources sets the StrictModeForAllResources field's value.
func (s *AssetBundleImportJobOverrideValidationStrategy) SetStrictModeForAllResources(v bool) *AssetBundleImportJobOverrideValidationStrategy {
	s.StrictModeForAllResources = &v
	return s
}

// A list of overrides for a specific RefreshsSchedule resource that is present
// in the asset bundle that is imported.
type AssetBundleImportJobRefreshScheduleOverrideParameters struct {
	_ struct{} `type:"structure"`

	// A partial identifier for the specific RefreshSchedule resource that is being
	// overridden. This structure is used together with the ScheduleID structure.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// A partial identifier for the specific RefreshSchedule resource being overridden.
	// This structure is used together with the DataSetId structure.
	//
	// ScheduleId is a required field
	ScheduleId *string `type:"string" required:"true"`

	// An override for the StartAfterDateTime of a RefreshSchedule. Make sure that
	// the StartAfterDateTime is set to a time that takes place in the future.
	StartAfterDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobRefreshScheduleOverrideParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobRefreshScheduleOverrideParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobRefreshScheduleOverrideParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobRefreshScheduleOverrideParameters"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.ScheduleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *AssetBundleImportJobRefreshScheduleOverrideParameters) SetDataSetId(v string) *AssetBundleImportJobRefreshScheduleOverrideParameters {
	s.DataSetId = &v
	return s
}

// SetScheduleId sets the ScheduleId field's value.
func (s *AssetBundleImportJobRefreshScheduleOverrideParameters) SetScheduleId(v string) *AssetBundleImportJobRefreshScheduleOverrideParameters {
	s.ScheduleId = &v
	return s
}

// SetStartAfterDateTime sets the StartAfterDateTime field's value.
func (s *AssetBundleImportJobRefreshScheduleOverrideParameters) SetStartAfterDateTime(v time.Time) *AssetBundleImportJobRefreshScheduleOverrideParameters {
	s.StartAfterDateTime = &v
	return s
}

// An optional structure that configures resource ID overrides for the import
// job.
type AssetBundleImportJobResourceIdOverrideConfiguration struct {
	_ struct{} `type:"structure"`

	// An option to request a CloudFormation variable for a prefix to be prepended
	// to each resource's ID before import. The prefix is only added to the asset
	// IDs and does not change the name of the asset.
	PrefixForAllResources *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobResourceIdOverrideConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobResourceIdOverrideConfiguration) GoString() string {
	return s.String()
}

// SetPrefixForAllResources sets the PrefixForAllResources field's value.
func (s *AssetBundleImportJobResourceIdOverrideConfiguration) SetPrefixForAllResources(v string) *AssetBundleImportJobResourceIdOverrideConfiguration {
	s.PrefixForAllResources = &v
	return s
}

// A summary of the import job that includes details of the requested job's
// configuration and its current status.
type AssetBundleImportJobSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the import job.
	Arn *string `type:"string"`

	// The ID of the job. This ID is unique while the job is running. After the
	// job is completed, you can reuse this ID for another job.
	AssetBundleImportJobId *string `min:"1" type:"string"`

	// The time that the import job was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The failure action for the import job.
	FailureAction *string `type:"string" enum:"AssetBundleImportFailureAction"`

	// The current status of the import job.
	JobStatus *string `type:"string" enum:"AssetBundleImportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetBundleImportJobSummary) SetArn(v string) *AssetBundleImportJobSummary {
	s.Arn = &v
	return s
}

// SetAssetBundleImportJobId sets the AssetBundleImportJobId field's value.
func (s *AssetBundleImportJobSummary) SetAssetBundleImportJobId(v string) *AssetBundleImportJobSummary {
	s.AssetBundleImportJobId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AssetBundleImportJobSummary) SetCreatedTime(v time.Time) *AssetBundleImportJobSummary {
	s.CreatedTime = &v
	return s
}

// SetFailureAction sets the FailureAction field's value.
func (s *AssetBundleImportJobSummary) SetFailureAction(v string) *AssetBundleImportJobSummary {
	s.FailureAction = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *AssetBundleImportJobSummary) SetJobStatus(v string) *AssetBundleImportJobSummary {
	s.JobStatus = &v
	return s
}

// The override parameters for a single theme that is imported.
type AssetBundleImportJobThemeOverrideParameters struct {
	_ struct{} `type:"structure"`

	// A new name for the theme.
	Name *string `min:"1" type:"string"`

	// The ID of the theme to apply overrides to.
	//
	// ThemeId is a required field
	ThemeId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobThemeOverrideParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobThemeOverrideParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobThemeOverrideParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobThemeOverrideParameters"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AssetBundleImportJobThemeOverrideParameters) SetName(v string) *AssetBundleImportJobThemeOverrideParameters {
	s.Name = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *AssetBundleImportJobThemeOverrideParameters) SetThemeId(v string) *AssetBundleImportJobThemeOverrideParameters {
	s.ThemeId = &v
	return s
}

// An object that contains a list of permissions to be applied to a list of
// theme IDs.
type AssetBundleImportJobThemeOverridePermissions struct {
	_ struct{} `type:"structure"`

	// A list of permissions for the themes that you want to apply overrides to.
	//
	// Permissions is a required field
	Permissions *AssetBundleResourcePermissions `type:"structure" required:"true"`

	// A list of theme IDs that you want to apply overrides to. You can use * to
	// override all themes in this asset bundle.
	//
	// ThemeIds is a required field
	ThemeIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobThemeOverridePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobThemeOverridePermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobThemeOverridePermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobThemeOverridePermissions"}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.ThemeIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeIds"))
	}
	if s.ThemeIds != nil && len(s.ThemeIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeIds", 1))
	}
	if s.Permissions != nil {
		if err := s.Permissions.Validate(); err != nil {
			invalidParams.AddNested("Permissions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermissions sets the Permissions field's value.
func (s *AssetBundleImportJobThemeOverridePermissions) SetPermissions(v *AssetBundleResourcePermissions) *AssetBundleImportJobThemeOverridePermissions {
	s.Permissions = v
	return s
}

// SetThemeIds sets the ThemeIds field's value.
func (s *AssetBundleImportJobThemeOverridePermissions) SetThemeIds(v []*string) *AssetBundleImportJobThemeOverridePermissions {
	s.ThemeIds = v
	return s
}

// An object that contains a list of tags to be assigned to a list of theme
// IDs.
type AssetBundleImportJobThemeOverrideTags struct {
	_ struct{} `type:"structure"`

	// A list of tags for the themes that you want to apply overrides to.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`

	// A list of theme IDs that you want to apply overrides to. You can use * to
	// override all themes in this asset bundle.
	//
	// ThemeIds is a required field
	ThemeIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobThemeOverrideTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobThemeOverrideTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobThemeOverrideTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobThemeOverrideTags"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ThemeIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeIds"))
	}
	if s.ThemeIds != nil && len(s.ThemeIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeIds", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *AssetBundleImportJobThemeOverrideTags) SetTags(v []*Tag) *AssetBundleImportJobThemeOverrideTags {
	s.Tags = v
	return s
}

// SetThemeIds sets the ThemeIds field's value.
func (s *AssetBundleImportJobThemeOverrideTags) SetThemeIds(v []*string) *AssetBundleImportJobThemeOverrideTags {
	s.ThemeIds = v
	return s
}

// The override parameters for a single VPC connection that is imported.
type AssetBundleImportJobVPCConnectionOverrideParameters struct {
	_ struct{} `type:"structure"`

	// An optional override of DNS resolvers to be used by the VPC connection.
	DnsResolvers []*string `type:"list"`

	// A new name for the VPC connection.
	Name *string `min:"1" type:"string"`

	// An optional override of the role ARN to be used by the VPC connection.
	RoleArn *string `min:"20" type:"string"`

	// A new security group ID for the VPC connection you are importing. This field
	// is required if you are importing the VPC connection from another Amazon Web
	// Services account or Region.
	SecurityGroupIds []*string `min:"1" type:"list"`

	// A list of new subnet IDs for the VPC connection you are importing. This field
	// is required if you are importing the VPC connection from another Amazon Web
	// Services account or Region.
	SubnetIds []*string `min:"2" type:"list"`

	// The ID of the VPC Connection to apply overrides to.
	//
	// VPCConnectionId is a required field
	VPCConnectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobVPCConnectionOverrideParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobVPCConnectionOverrideParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobVPCConnectionOverrideParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobVPCConnectionOverrideParameters"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 2))
	}
	if s.VPCConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCConnectionId"))
	}
	if s.VPCConnectionId != nil && len(*s.VPCConnectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCConnectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDnsResolvers sets the DnsResolvers field's value.
func (s *AssetBundleImportJobVPCConnectionOverrideParameters) SetDnsResolvers(v []*string) *AssetBundleImportJobVPCConnectionOverrideParameters {
	s.DnsResolvers = v
	return s
}

// SetName sets the Name field's value.
func (s *AssetBundleImportJobVPCConnectionOverrideParameters) SetName(v string) *AssetBundleImportJobVPCConnectionOverrideParameters {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AssetBundleImportJobVPCConnectionOverrideParameters) SetRoleArn(v string) *AssetBundleImportJobVPCConnectionOverrideParameters {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AssetBundleImportJobVPCConnectionOverrideParameters) SetSecurityGroupIds(v []*string) *AssetBundleImportJobVPCConnectionOverrideParameters {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AssetBundleImportJobVPCConnectionOverrideParameters) SetSubnetIds(v []*string) *AssetBundleImportJobVPCConnectionOverrideParameters {
	s.SubnetIds = v
	return s
}

// SetVPCConnectionId sets the VPCConnectionId field's value.
func (s *AssetBundleImportJobVPCConnectionOverrideParameters) SetVPCConnectionId(v string) *AssetBundleImportJobVPCConnectionOverrideParameters {
	s.VPCConnectionId = &v
	return s
}

// An object that contains a list of tags to be assigned to a list of VPC connection
// IDs.
type AssetBundleImportJobVPCConnectionOverrideTags struct {
	_ struct{} `type:"structure"`

	// A list of tags for the VPC connections that you want to apply overrides to.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`

	// A list of VPC connection IDs that you want to apply overrides to. You can
	// use * to override all VPC connections in this asset bundle.
	//
	// VPCConnectionIds is a required field
	VPCConnectionIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobVPCConnectionOverrideTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportJobVPCConnectionOverrideTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleImportJobVPCConnectionOverrideTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleImportJobVPCConnectionOverrideTags"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VPCConnectionIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCConnectionIds"))
	}
	if s.VPCConnectionIds != nil && len(s.VPCConnectionIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCConnectionIds", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *AssetBundleImportJobVPCConnectionOverrideTags) SetTags(v []*Tag) *AssetBundleImportJobVPCConnectionOverrideTags {
	s.Tags = v
	return s
}

// SetVPCConnectionIds sets the VPCConnectionIds field's value.
func (s *AssetBundleImportJobVPCConnectionOverrideTags) SetVPCConnectionIds(v []*string) *AssetBundleImportJobVPCConnectionOverrideTags {
	s.VPCConnectionIds = v
	return s
}

// The source of the asset bundle zip file that contains the data that you want
// to import. The file must be in QUICKSIGHT_JSON format.
type AssetBundleImportSource struct {
	_ struct{} `type:"structure"`

	// The bytes of the base64 encoded asset bundle import zip file. This file can't
	// exceed 20 MB.
	//
	// If you are calling the API operations from the Amazon Web Services SDK for
	// Java, JavaScript, Python, or PHP, the SDK encodes base64 automatically to
	// allow the direct setting of the zip file's bytes. If you are using an SDK
	// for a different language or receiving related errors, try to base64 encode
	// your data.
	//
	// Body is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetBundleImportSource's
	// String and GoString methods.
	//
	// Body is automatically base64 encoded/decoded by the SDK.
	Body []byte `type:"blob" sensitive:"true"`

	// The Amazon S3 URI for an asset bundle import file that exists in an Amazon
	// S3 bucket that the caller has read access to. The file must be a zip format
	// file and can't exceed 20 MB.
	S3Uri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportSource) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *AssetBundleImportSource) SetBody(v []byte) *AssetBundleImportSource {
	s.Body = v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *AssetBundleImportSource) SetS3Uri(v string) *AssetBundleImportSource {
	s.S3Uri = &v
	return s
}

// A description of the import source that you provide at the start of an import
// job. This value is set to either Body or S3Uri, depending on how the StartAssetBundleImportJobRequest
// is configured.
type AssetBundleImportSourceDescription struct {
	_ struct{} `type:"structure"`

	// An HTTPS download URL for the provided asset bundle that you optionally provided
	// at the start of the import job. This URL is valid for five minutes after
	// issuance. Call DescribeAssetBundleExportJob again for a fresh URL if needed.
	// The downloaded asset bundle is a .qs zip file.
	//
	// Body is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetBundleImportSourceDescription's
	// String and GoString methods.
	Body *string `type:"string" sensitive:"true"`

	// The Amazon S3 URI that you provided at the start of the import job.
	S3Uri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleImportSourceDescription) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *AssetBundleImportSourceDescription) SetBody(v string) *AssetBundleImportSourceDescription {
	s.Body = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *AssetBundleImportSourceDescription) SetS3Uri(v string) *AssetBundleImportSourceDescription {
	s.S3Uri = &v
	return s
}

// A structure that contains the configuration of a shared link to an Amazon
// QuickSight dashboard.
type AssetBundleResourceLinkSharingConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of link sharing permissions for the dashboards that you want to apply
	// overrides to.
	Permissions *AssetBundleResourcePermissions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleResourceLinkSharingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleResourceLinkSharingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleResourceLinkSharingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleResourceLinkSharingConfiguration"}
	if s.Permissions != nil {
		if err := s.Permissions.Validate(); err != nil {
			invalidParams.AddNested("Permissions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermissions sets the Permissions field's value.
func (s *AssetBundleResourceLinkSharingConfiguration) SetPermissions(v *AssetBundleResourcePermissions) *AssetBundleResourceLinkSharingConfiguration {
	s.Permissions = v
	return s
}

// A structure that contains the permissions for the resource that you want
// to override in an asset bundle import job.
type AssetBundleResourcePermissions struct {
	_ struct{} `type:"structure"`

	// A list of IAM actions to grant permissions on.
	//
	// Actions is a required field
	Actions []*string `min:"1" type:"list" required:"true"`

	// A list of principals to grant permissions on.
	//
	// Principals is a required field
	Principals []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleResourcePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetBundleResourcePermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetBundleResourcePermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetBundleResourcePermissions"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.Principals == nil {
		invalidParams.Add(request.NewErrParamRequired("Principals"))
	}
	if s.Principals != nil && len(s.Principals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Principals", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *AssetBundleResourcePermissions) SetActions(v []*string) *AssetBundleResourcePermissions {
	s.Actions = v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *AssetBundleResourcePermissions) SetPrincipals(v []*string) *AssetBundleResourcePermissions {
	s.Principals = v
	return s
}

// An array of analysis level configurations.
type AssetOptions struct {
	_ struct{} `type:"structure"`

	// Determines the timezone for the analysis.
	Timezone *string `type:"string"`

	// Determines the week start day for an analysis.
	WeekStart *string `type:"string" enum:"DayOfTheWeek"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetOptions) GoString() string {
	return s.String()
}

// SetTimezone sets the Timezone field's value.
func (s *AssetOptions) SetTimezone(v string) *AssetOptions {
	s.Timezone = &v
	return s
}

// SetWeekStart sets the WeekStart field's value.
func (s *AssetOptions) SetWeekStart(v string) *AssetOptions {
	s.WeekStart = &v
	return s
}

// Parameters for Amazon Athena.
type AthenaParameters struct {
	_ struct{} `type:"structure"`

	// Use the RoleArn structure to override an account-wide role for a specific
	// Athena data source. For example, say an account administrator has turned
	// off all Athena access with an account-wide role. The administrator can then
	// use RoleArn to bypass the account-wide role and allow Athena access for the
	// single Athena data source that is specified in the structure, even if the
	// account-wide role forbidding Athena access is still active.
	RoleArn *string `min:"20" type:"string"`

	// The workgroup that Amazon Athena uses.
	WorkGroup *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AthenaParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AthenaParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AthenaParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AthenaParameters"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.WorkGroup != nil && len(*s.WorkGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *AthenaParameters) SetRoleArn(v string) *AthenaParameters {
	s.RoleArn = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *AthenaParameters) SetWorkGroup(v string) *AthenaParameters {
	s.WorkGroup = &v
	return s
}

// Aggregation for attributes.
type AttributeAggregationFunction struct {
	_ struct{} `type:"structure"`

	// The built-in aggregation functions for attributes.
	//
	//    * UNIQUE_VALUE: Returns the unique value for a field, aggregated by the
	//    dimension fields.
	SimpleAttributeAggregation *string `type:"string" enum:"SimpleAttributeAggregationFunction"`

	// Used by the UNIQUE_VALUE aggregation function. If there are multiple values
	// for the field used by the aggregation, the value for this property will be
	// returned instead. Defaults to '*'.
	ValueForMultipleValues *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeAggregationFunction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeAggregationFunction) GoString() string {
	return s.String()
}

// SetSimpleAttributeAggregation sets the SimpleAttributeAggregation field's value.
func (s *AttributeAggregationFunction) SetSimpleAttributeAggregation(v string) *AttributeAggregationFunction {
	s.SimpleAttributeAggregation = &v
	return s
}

// SetValueForMultipleValues sets the ValueForMultipleValues field's value.
func (s *AttributeAggregationFunction) SetValueForMultipleValues(v string) *AttributeAggregationFunction {
	s.ValueForMultipleValues = &v
	return s
}

// Parameters for Amazon Aurora.
type AuroraParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuroraParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *AuroraParameters) SetDatabase(v string) *AuroraParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *AuroraParameters) SetHost(v string) *AuroraParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AuroraParameters) SetPort(v int64) *AuroraParameters {
	s.Port = &v
	return s
}

// Parameters for Amazon Aurora PostgreSQL-Compatible Edition.
type AuroraPostgreSqlParameters struct {
	_ struct{} `type:"structure"`

	// The Amazon Aurora PostgreSQL database to connect to.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// The Amazon Aurora PostgreSQL-Compatible host to connect to.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// The port that Amazon Aurora PostgreSQL is listening on.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraPostgreSqlParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraPostgreSqlParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraPostgreSqlParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuroraPostgreSqlParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *AuroraPostgreSqlParameters) SetDatabase(v string) *AuroraPostgreSqlParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *AuroraPostgreSqlParameters) SetHost(v string) *AuroraPostgreSqlParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AuroraPostgreSqlParameters) SetPort(v int64) *AuroraPostgreSqlParameters {
	s.Port = &v
	return s
}

// The authorized targets that are associated with a service.
type AuthorizedTargetsByService struct {
	_ struct{} `type:"structure"`

	// Aist of authorized targets that are represented by IAM Identity Center application
	// ARNs.
	AuthorizedTargets []*string `type:"list"`

	// The name of the Amazon Web Services service.
	Service *string `type:"string" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizedTargetsByService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizedTargetsByService) GoString() string {
	return s.String()
}

// SetAuthorizedTargets sets the AuthorizedTargets field's value.
func (s *AuthorizedTargetsByService) SetAuthorizedTargets(v []*string) *AuthorizedTargetsByService {
	s.AuthorizedTargets = v
	return s
}

// SetService sets the Service field's value.
func (s *AuthorizedTargetsByService) SetService(v string) *AuthorizedTargetsByService {
	s.Service = &v
	return s
}

// The parameters for IoT Analytics.
type AwsIotAnalyticsParameters struct {
	_ struct{} `type:"structure"`

	// Dataset name.
	//
	// DataSetName is a required field
	DataSetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIotAnalyticsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIotAnalyticsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIotAnalyticsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIotAnalyticsParameters"}
	if s.DataSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetName"))
	}
	if s.DataSetName != nil && len(*s.DataSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetName sets the DataSetName field's value.
func (s *AwsIotAnalyticsParameters) SetDataSetName(v string) *AwsIotAnalyticsParameters {
	s.DataSetName = &v
	return s
}

// The data options for an axis.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AxisDataOptions struct {
	_ struct{} `type:"structure"`

	// The options for an axis with a date field.
	DateAxisOptions *DateAxisOptions `type:"structure"`

	// The options for an axis with a numeric field.
	NumericAxisOptions *NumericAxisOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDataOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDataOptions) GoString() string {
	return s.String()
}

// SetDateAxisOptions sets the DateAxisOptions field's value.
func (s *AxisDataOptions) SetDateAxisOptions(v *DateAxisOptions) *AxisDataOptions {
	s.DateAxisOptions = v
	return s
}

// SetNumericAxisOptions sets the NumericAxisOptions field's value.
func (s *AxisDataOptions) SetNumericAxisOptions(v *NumericAxisOptions) *AxisDataOptions {
	s.NumericAxisOptions = v
	return s
}

// The options that are saved for future extension.
type AxisDisplayDataDrivenRange struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayDataDrivenRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayDataDrivenRange) GoString() string {
	return s.String()
}

// The minimum and maximum setup for an axis display range.
type AxisDisplayMinMaxRange struct {
	_ struct{} `type:"structure"`

	// The maximum setup for an axis display range.
	Maximum *float64 `type:"double"`

	// The minimum setup for an axis display range.
	Minimum *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayMinMaxRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayMinMaxRange) GoString() string {
	return s.String()
}

// SetMaximum sets the Maximum field's value.
func (s *AxisDisplayMinMaxRange) SetMaximum(v float64) *AxisDisplayMinMaxRange {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *AxisDisplayMinMaxRange) SetMinimum(v float64) *AxisDisplayMinMaxRange {
	s.Minimum = &v
	return s
}

// The display options for the axis label.
type AxisDisplayOptions struct {
	_ struct{} `type:"structure"`

	// Determines whether or not the axis line is visible.
	AxisLineVisibility *string `type:"string" enum:"Visibility"`

	// The offset value that determines the starting placement of the axis within
	// a visual's bounds.
	AxisOffset *string `type:"string"`

	// The data options for an axis.
	DataOptions *AxisDataOptions `type:"structure"`

	// Determines whether or not the grid line is visible.
	GridLineVisibility *string `type:"string" enum:"Visibility"`

	// The scroll bar options for an axis.
	ScrollbarOptions *ScrollBarOptions `type:"structure"`

	// The tick label options of an axis.
	TickLabelOptions *AxisTickLabelOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayOptions) GoString() string {
	return s.String()
}

// SetAxisLineVisibility sets the AxisLineVisibility field's value.
func (s *AxisDisplayOptions) SetAxisLineVisibility(v string) *AxisDisplayOptions {
	s.AxisLineVisibility = &v
	return s
}

// SetAxisOffset sets the AxisOffset field's value.
func (s *AxisDisplayOptions) SetAxisOffset(v string) *AxisDisplayOptions {
	s.AxisOffset = &v
	return s
}

// SetDataOptions sets the DataOptions field's value.
func (s *AxisDisplayOptions) SetDataOptions(v *AxisDataOptions) *AxisDisplayOptions {
	s.DataOptions = v
	return s
}

// SetGridLineVisibility sets the GridLineVisibility field's value.
func (s *AxisDisplayOptions) SetGridLineVisibility(v string) *AxisDisplayOptions {
	s.GridLineVisibility = &v
	return s
}

// SetScrollbarOptions sets the ScrollbarOptions field's value.
func (s *AxisDisplayOptions) SetScrollbarOptions(v *ScrollBarOptions) *AxisDisplayOptions {
	s.ScrollbarOptions = v
	return s
}

// SetTickLabelOptions sets the TickLabelOptions field's value.
func (s *AxisDisplayOptions) SetTickLabelOptions(v *AxisTickLabelOptions) *AxisDisplayOptions {
	s.TickLabelOptions = v
	return s
}

// The range setup of a numeric axis display range.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AxisDisplayRange struct {
	_ struct{} `type:"structure"`

	// The data-driven setup of an axis display range.
	DataDriven *AxisDisplayDataDrivenRange `type:"structure"`

	// The minimum and maximum setup of an axis display range.
	MinMax *AxisDisplayMinMaxRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayRange) GoString() string {
	return s.String()
}

// SetDataDriven sets the DataDriven field's value.
func (s *AxisDisplayRange) SetDataDriven(v *AxisDisplayDataDrivenRange) *AxisDisplayRange {
	s.DataDriven = v
	return s
}

// SetMinMax sets the MinMax field's value.
func (s *AxisDisplayRange) SetMinMax(v *AxisDisplayMinMaxRange) *AxisDisplayRange {
	s.MinMax = v
	return s
}

// The label options for a chart axis. You must specify the field that the label
// is targeted to.
type AxisLabelOptions struct {
	_ struct{} `type:"structure"`

	// The options that indicate which field the label belongs to.
	ApplyTo *AxisLabelReferenceOptions `type:"structure"`

	// The text for the axis label.
	CustomLabel *string `type:"string"`

	// The font configuration of the axis label.
	FontConfiguration *FontConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLabelOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLabelOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AxisLabelOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AxisLabelOptions"}
	if s.ApplyTo != nil {
		if err := s.ApplyTo.Validate(); err != nil {
			invalidParams.AddNested("ApplyTo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyTo sets the ApplyTo field's value.
func (s *AxisLabelOptions) SetApplyTo(v *AxisLabelReferenceOptions) *AxisLabelOptions {
	s.ApplyTo = v
	return s
}

// SetCustomLabel sets the CustomLabel field's value.
func (s *AxisLabelOptions) SetCustomLabel(v string) *AxisLabelOptions {
	s.CustomLabel = &v
	return s
}

// SetFontConfiguration sets the FontConfiguration field's value.
func (s *AxisLabelOptions) SetFontConfiguration(v *FontConfiguration) *AxisLabelOptions {
	s.FontConfiguration = v
	return s
}

// The reference that specifies where the axis label is applied to.
type AxisLabelReferenceOptions struct {
	_ struct{} `type:"structure"`

	// The column that the axis label is targeted to.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`

	// The field that the axis label is targeted to.
	//
	// FieldId is a required field
	FieldId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLabelReferenceOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLabelReferenceOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AxisLabelReferenceOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AxisLabelReferenceOptions"}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumn sets the Column field's value.
func (s *AxisLabelReferenceOptions) SetColumn(v *ColumnIdentifier) *AxisLabelReferenceOptions {
	s.Column = v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *AxisLabelReferenceOptions) SetFieldId(v string) *AxisLabelReferenceOptions {
	s.FieldId = &v
	return s
}

// The liner axis scale setup.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AxisLinearScale struct {
	_ struct{} `type:"structure"`

	// The step count setup of a linear axis.
	StepCount *int64 `type:"integer"`

	// The step size setup of a linear axis.
	StepSize *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLinearScale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLinearScale) GoString() string {
	return s.String()
}

// SetStepCount sets the StepCount field's value.
func (s *AxisLinearScale) SetStepCount(v int64) *AxisLinearScale {
	s.StepCount = &v
	return s
}

// SetStepSize sets the StepSize field's value.
func (s *AxisLinearScale) SetStepSize(v float64) *AxisLinearScale {
	s.StepSize = &v
	return s
}

// The logarithmic axis scale setup.
type AxisLogarithmicScale struct {
	_ struct{} `type:"structure"`

	// The base setup of a logarithmic axis scale.
	Base *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLogarithmicScale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLogarithmicScale) GoString() string {
	return s.String()
}

// SetBase sets the Base field's value.
func (s *AxisLogarithmicScale) SetBase(v float64) *AxisLogarithmicScale {
	s.Base = &v
	return s
}

// The scale setup options for a numeric axis display.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AxisScale struct {
	_ struct{} `type:"structure"`

	// The linear axis scale setup.
	Linear *AxisLinearScale `type:"structure"`

	// The logarithmic axis scale setup.
	Logarithmic *AxisLogarithmicScale `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisScale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisScale) GoString() string {
	return s.String()
}

// SetLinear sets the Linear field's value.
func (s *AxisScale) SetLinear(v *AxisLinearScale) *AxisScale {
	s.Linear = v
	return s
}

// SetLogarithmic sets the Logarithmic field's value.
func (s *AxisScale) SetLogarithmic(v *AxisLogarithmicScale) *AxisScale {
	s.Logarithmic = v
	return s
}

// The tick label options of an axis.
type AxisTickLabelOptions struct {
	_ struct{} `type:"structure"`

	// Determines whether or not the axis ticks are visible.
	LabelOptions *LabelOptions `type:"structure"`

	// The rotation angle of the axis tick labels.
	RotationAngle *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisTickLabelOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisTickLabelOptions) GoString() string {
	return s.String()
}

// SetLabelOptions sets the LabelOptions field's value.
func (s *AxisTickLabelOptions) SetLabelOptions(v *LabelOptions) *AxisTickLabelOptions {
	s.LabelOptions = v
	return s
}

// SetRotationAngle sets the RotationAngle field's value.
func (s *AxisTickLabelOptions) SetRotationAngle(v float64) *AxisTickLabelOptions {
	s.RotationAngle = &v
	return s
}

// The aggregated field wells of a bar chart.
type BarChartAggregatedFieldWells struct {
	_ struct{} `type:"structure"`

	// The category (y-axis) field well of a bar chart.
	Category []*DimensionField `type:"list"`

	// The color (group/color) field well of a bar chart.
	Colors []*DimensionField `type:"list"`

	// The small multiples field well of a bar chart.
	SmallMultiples []*DimensionField `type:"list"`

	// The value field wells of a bar chart. Values are aggregated by category.
	Values []*MeasureField `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartAggregatedFieldWells) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartAggregatedFieldWells) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BarChartAggregatedFieldWells) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BarChartAggregatedFieldWells"}
	if s.Category != nil {
		for i, v := range s.Category {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Category", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Colors != nil {
		for i, v := range 