// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package nimblestudio

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptEulas = "AcceptEulas"

// AcceptEulasRequest generates a "aws/request.Request" representing the
// client's request for the AcceptEulas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptEulas for more information on using the AcceptEulas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptEulasRequest method.
//	req, resp := client.AcceptEulasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/AcceptEulas
func (c *NimbleStudio) AcceptEulasRequest(input *AcceptEulasInput) (req *request.Request, output *AcceptEulasOutput) {
	op := &request.Operation{
		Name:       opAcceptEulas,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/eula-acceptances",
	}

	if input == nil {
		input = &AcceptEulasInput{}
	}

	output = &AcceptEulasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptEulas API operation for AmazonNimbleStudio.
//
// Accept EULAs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation AcceptEulas for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/AcceptEulas
func (c *NimbleStudio) AcceptEulas(input *AcceptEulasInput) (*AcceptEulasOutput, error) {
	req, out := c.AcceptEulasRequest(input)
	return out, req.Send()
}

// AcceptEulasWithContext is the same as AcceptEulas with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptEulas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) AcceptEulasWithContext(ctx aws.Context, input *AcceptEulasInput, opts ...request.Option) (*AcceptEulasOutput, error) {
	req, out := c.AcceptEulasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLaunchProfile = "CreateLaunchProfile"

// CreateLaunchProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateLaunchProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLaunchProfile for more information on using the CreateLaunchProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLaunchProfileRequest method.
//	req, resp := client.CreateLaunchProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateLaunchProfile
func (c *NimbleStudio) CreateLaunchProfileRequest(input *CreateLaunchProfileInput) (req *request.Request, output *CreateLaunchProfileOutput) {
	op := &request.Operation{
		Name:       opCreateLaunchProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles",
	}

	if input == nil {
		input = &CreateLaunchProfileInput{}
	}

	output = &CreateLaunchProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLaunchProfile API operation for AmazonNimbleStudio.
//
// Create a launch profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation CreateLaunchProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateLaunchProfile
func (c *NimbleStudio) CreateLaunchProfile(input *CreateLaunchProfileInput) (*CreateLaunchProfileOutput, error) {
	req, out := c.CreateLaunchProfileRequest(input)
	return out, req.Send()
}

// CreateLaunchProfileWithContext is the same as CreateLaunchProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLaunchProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) CreateLaunchProfileWithContext(ctx aws.Context, input *CreateLaunchProfileInput, opts ...request.Option) (*CreateLaunchProfileOutput, error) {
	req, out := c.CreateLaunchProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamingImage = "CreateStreamingImage"

// CreateStreamingImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamingImage for more information on using the CreateStreamingImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStreamingImageRequest method.
//	req, resp := client.CreateStreamingImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingImage
func (c *NimbleStudio) CreateStreamingImageRequest(input *CreateStreamingImageInput) (req *request.Request, output *CreateStreamingImageOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingImage,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-images",
	}

	if input == nil {
		input = &CreateStreamingImageInput{}
	}

	output = &CreateStreamingImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingImage API operation for AmazonNimbleStudio.
//
// Creates a streaming image resource in a studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation CreateStreamingImage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingImage
func (c *NimbleStudio) CreateStreamingImage(input *CreateStreamingImageInput) (*CreateStreamingImageOutput, error) {
	req, out := c.CreateStreamingImageRequest(input)
	return out, req.Send()
}

// CreateStreamingImageWithContext is the same as CreateStreamingImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamingImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) CreateStreamingImageWithContext(ctx aws.Context, input *CreateStreamingImageInput, opts ...request.Option) (*CreateStreamingImageOutput, error) {
	req, out := c.CreateStreamingImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamingSession = "CreateStreamingSession"

// CreateStreamingSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamingSession for more information on using the CreateStreamingSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStreamingSessionRequest method.
//	req, resp := client.CreateStreamingSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSession
func (c *NimbleStudio) CreateStreamingSessionRequest(input *CreateStreamingSessionInput) (req *request.Request, output *CreateStreamingSessionOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingSession,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-sessions",
	}

	if input == nil {
		input = &CreateStreamingSessionInput{}
	}

	output = &CreateStreamingSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingSession API operation for AmazonNimbleStudio.
//
// Creates a streaming session in a studio.
//
// After invoking this operation, you must poll GetStreamingSession until the
// streaming session is in state READY.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation CreateStreamingSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSession
func (c *NimbleStudio) CreateStreamingSession(input *CreateStreamingSessionInput) (*CreateStreamingSessionOutput, error) {
	req, out := c.CreateStreamingSessionRequest(input)
	return out, req.Send()
}

// CreateStreamingSessionWithContext is the same as CreateStreamingSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamingSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) CreateStreamingSessionWithContext(ctx aws.Context, input *CreateStreamingSessionInput, opts ...request.Option) (*CreateStreamingSessionOutput, error) {
	req, out := c.CreateStreamingSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamingSessionStream = "CreateStreamingSessionStream"

// CreateStreamingSessionStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingSessionStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamingSessionStream for more information on using the CreateStreamingSessionStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStreamingSessionStreamRequest method.
//	req, resp := client.CreateStreamingSessionStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSessionStream
func (c *NimbleStudio) CreateStreamingSessionStreamRequest(input *CreateStreamingSessionStreamInput) (req *request.Request, output *CreateStreamingSessionStreamOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingSessionStream,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/streams",
	}

	if input == nil {
		input = &CreateStreamingSessionStreamInput{}
	}

	output = &CreateStreamingSessionStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingSessionStream API operation for AmazonNimbleStudio.
//
// Creates a streaming session stream for a streaming session.
//
// After invoking this API, invoke GetStreamingSessionStream with the returned
// streamId to poll the resource until it is in state READY.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation CreateStreamingSessionStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSessionStream
func (c *NimbleStudio) CreateStreamingSessionStream(input *CreateStreamingSessionStreamInput) (*CreateStreamingSessionStreamOutput, error) {
	req, out := c.CreateStreamingSessionStreamRequest(input)
	return out, req.Send()
}

// CreateStreamingSessionStreamWithContext is the same as CreateStreamingSessionStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamingSessionStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) CreateStreamingSessionStreamWithContext(ctx aws.Context, input *CreateStreamingSessionStreamInput, opts ...request.Option) (*CreateStreamingSessionStreamOutput, error) {
	req, out := c.CreateStreamingSessionStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStudio = "CreateStudio"

// CreateStudioRequest generates a "aws/request.Request" representing the
// client's request for the CreateStudio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStudio for more information on using the CreateStudio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStudioRequest method.
//	req, resp := client.CreateStudioRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudio
func (c *NimbleStudio) CreateStudioRequest(input *CreateStudioInput) (req *request.Request, output *CreateStudioOutput) {
	op := &request.Operation{
		Name:       opCreateStudio,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios",
	}

	if input == nil {
		input = &CreateStudioInput{}
	}

	output = &CreateStudioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStudio API operation for AmazonNimbleStudio.
//
// Create a new Studio.
//
// When creating a Studio, two IAM roles must be provided: the admin role and
// the user Role. These roles are assumed by your users when they log in to
// the Nimble Studio portal.
//
// The user role must have the AmazonNimbleStudio-StudioUser managed policy
// attached for the portal to function properly.
//
// The Admin Role must have the AmazonNimbleStudio-StudioAdmin managed policy
// attached for the portal to function properly.
//
// You may optionally specify a KMS key in the StudioEncryptionConfiguration.
//
// In Nimble Studio, resource names, descriptions, initialization scripts, and
// other data you provide are always encrypted at rest using an KMS key. By
// default, this key is owned by Amazon Web Services and managed on your behalf.
// You may provide your own KMS key when calling CreateStudio to encrypt this
// data using a key you own and manage.
//
// When providing an KMS key during studio creation, Nimble Studio creates KMS
// grants in your account to provide your studio user and admin roles access
// to these KMS keys.
//
// If you delete this grant, the studio will no longer be accessible to your
// portal users.
//
// If you delete the studio KMS key, your studio will no longer be accessible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation CreateStudio for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudio
func (c *NimbleStudio) CreateStudio(input *CreateStudioInput) (*CreateStudioOutput, error) {
	req, out := c.CreateStudioRequest(input)
	return out, req.Send()
}

// CreateStudioWithContext is the same as CreateStudio with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStudio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) CreateStudioWithContext(ctx aws.Context, input *CreateStudioInput, opts ...request.Option) (*CreateStudioOutput, error) {
	req, out := c.CreateStudioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStudioComponent = "CreateStudioComponent"

// CreateStudioComponentRequest generates a "aws/request.Request" representing the
// client's request for the CreateStudioComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStudioComponent for more information on using the CreateStudioComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStudioComponentRequest method.
//	req, resp := client.CreateStudioComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudioComponent
func (c *NimbleStudio) CreateStudioComponentRequest(input *CreateStudioComponentInput) (req *request.Request, output *CreateStudioComponentOutput) {
	op := &request.Operation{
		Name:       opCreateStudioComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/studio-components",
	}

	if input == nil {
		input = &CreateStudioComponentInput{}
	}

	output = &CreateStudioComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStudioComponent API operation for AmazonNimbleStudio.
//
// Creates a studio component resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation CreateStudioComponent for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudioComponent
func (c *NimbleStudio) CreateStudioComponent(input *CreateStudioComponentInput) (*CreateStudioComponentOutput, error) {
	req, out := c.CreateStudioComponentRequest(input)
	return out, req.Send()
}

// CreateStudioComponentWithContext is the same as CreateStudioComponent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStudioComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) CreateStudioComponentWithContext(ctx aws.Context, input *CreateStudioComponentInput, opts ...request.Option) (*CreateStudioComponentOutput, error) {
	req, out := c.CreateStudioComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunchProfile = "DeleteLaunchProfile"

// DeleteLaunchProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunchProfile for more information on using the DeleteLaunchProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLaunchProfileRequest method.
//	req, resp := client.DeleteLaunchProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfile
func (c *NimbleStudio) DeleteLaunchProfileRequest(input *DeleteLaunchProfileInput) (req *request.Request, output *DeleteLaunchProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}",
	}

	if input == nil {
		input = &DeleteLaunchProfileInput{}
	}

	output = &DeleteLaunchProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLaunchProfile API operation for AmazonNimbleStudio.
//
// Permanently delete a launch profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation DeleteLaunchProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfile
func (c *NimbleStudio) DeleteLaunchProfile(input *DeleteLaunchProfileInput) (*DeleteLaunchProfileOutput, error) {
	req, out := c.DeleteLaunchProfileRequest(input)
	return out, req.Send()
}

// DeleteLaunchProfileWithContext is the same as DeleteLaunchProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunchProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) DeleteLaunchProfileWithContext(ctx aws.Context, input *DeleteLaunchProfileInput, opts ...request.Option) (*DeleteLaunchProfileOutput, error) {
	req, out := c.DeleteLaunchProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunchProfileMember = "DeleteLaunchProfileMember"

// DeleteLaunchProfileMemberRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchProfileMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunchProfileMember for more information on using the DeleteLaunchProfileMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLaunchProfileMemberRequest method.
//	req, resp := client.DeleteLaunchProfileMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfileMember
func (c *NimbleStudio) DeleteLaunchProfileMemberRequest(input *DeleteLaunchProfileMemberInput) (req *request.Request, output *DeleteLaunchProfileMemberOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchProfileMember,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}",
	}

	if input == nil {
		input = &DeleteLaunchProfileMemberInput{}
	}

	output = &DeleteLaunchProfileMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLaunchProfileMember API operation for AmazonNimbleStudio.
//
// Delete a user from launch profile membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation DeleteLaunchProfileMember for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfileMember
func (c *NimbleStudio) DeleteLaunchProfileMember(input *DeleteLaunchProfileMemberInput) (*DeleteLaunchProfileMemberOutput, error) {
	req, out := c.DeleteLaunchProfileMemberRequest(input)
	return out, req.Send()
}

// DeleteLaunchProfileMemberWithContext is the same as DeleteLaunchProfileMember with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunchProfileMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) DeleteLaunchProfileMemberWithContext(ctx aws.Context, input *DeleteLaunchProfileMemberInput, opts ...request.Option) (*DeleteLaunchProfileMemberOutput, error) {
	req, out := c.DeleteLaunchProfileMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStreamingImage = "DeleteStreamingImage"

// DeleteStreamingImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStreamingImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStreamingImage for more information on using the DeleteStreamingImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStreamingImageRequest method.
//	req, resp := client.DeleteStreamingImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingImage
func (c *NimbleStudio) DeleteStreamingImageRequest(input *DeleteStreamingImageInput) (req *request.Request, output *DeleteStreamingImageOutput) {
	op := &request.Operation{
		Name:       opDeleteStreamingImage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}",
	}

	if input == nil {
		input = &DeleteStreamingImageInput{}
	}

	output = &DeleteStreamingImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStreamingImage API operation for AmazonNimbleStudio.
//
// Delete streaming image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation DeleteStreamingImage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingImage
func (c *NimbleStudio) DeleteStreamingImage(input *DeleteStreamingImageInput) (*DeleteStreamingImageOutput, error) {
	req, out := c.DeleteStreamingImageRequest(input)
	return out, req.Send()
}

// DeleteStreamingImageWithContext is the same as DeleteStreamingImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStreamingImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) DeleteStreamingImageWithContext(ctx aws.Context, input *DeleteStreamingImageInput, opts ...request.Option) (*DeleteStreamingImageOutput, error) {
	req, out := c.DeleteStreamingImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStreamingSession = "DeleteStreamingSession"

// DeleteStreamingSessionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStreamingSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStreamingSession for more information on using the DeleteStreamingSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStreamingSessionRequest method.
//	req, resp := client.DeleteStreamingSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingSession
func (c *NimbleStudio) DeleteStreamingSessionRequest(input *DeleteStreamingSessionInput) (req *request.Request, output *DeleteStreamingSessionOutput) {
	op := &request.Operation{
		Name:       opDeleteStreamingSession,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}",
	}

	if input == nil {
		input = &DeleteStreamingSessionInput{}
	}

	output = &DeleteStreamingSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStreamingSession API operation for AmazonNimbleStudio.
//
// Deletes streaming session resource.
//
// After invoking this operation, use GetStreamingSession to poll the resource
// until it transitions to a DELETED state.
//
// A streaming session will count against your streaming session quota until
// it is marked DELETED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation DeleteStreamingSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingSession
func (c *NimbleStudio) DeleteStreamingSession(input *DeleteStreamingSessionInput) (*DeleteStreamingSessionOutput, error) {
	req, out := c.DeleteStreamingSessionRequest(input)
	return out, req.Send()
}

// DeleteStreamingSessionWithContext is the same as DeleteStreamingSession with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStreamingSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) DeleteStreamingSessionWithContext(ctx aws.Context, input *DeleteStreamingSessionInput, opts ...request.Option) (*DeleteStreamingSessionOutput, error) {
	req, out := c.DeleteStreamingSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStudio = "DeleteStudio"

// DeleteStudioRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStudio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStudio for more information on using the DeleteStudio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStudioRequest method.
//	req, resp := client.DeleteStudioRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudio
func (c *NimbleStudio) DeleteStudioRequest(input *DeleteStudioInput) (req *request.Request, output *DeleteStudioOutput) {
	op := &request.Operation{
		Name:       opDeleteStudio,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-08-01/studios/{studioId}",
	}

	if input == nil {
		input = &DeleteStudioInput{}
	}

	output = &DeleteStudioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStudio API operation for AmazonNimbleStudio.
//
// Delete a studio resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation DeleteStudio for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudio
func (c *NimbleStudio) DeleteStudio(input *DeleteStudioInput) (*DeleteStudioOutput, error) {
	req, out := c.DeleteStudioRequest(input)
	return out, req.Send()
}

// DeleteStudioWithContext is the same as DeleteStudio with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStudio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) DeleteStudioWithContext(ctx aws.Context, input *DeleteStudioInput, opts ...request.Option) (*DeleteStudioOutput, error) {
	req, out := c.DeleteStudioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStudioComponent = "DeleteStudioComponent"

// DeleteStudioComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStudioComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStudioComponent for more information on using the DeleteStudioComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStudioComponentRequest method.
//	req, resp := client.DeleteStudioComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioComponent
func (c *NimbleStudio) DeleteStudioComponentRequest(input *DeleteStudioComponentInput) (req *request.Request, output *DeleteStudioComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteStudioComponent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}",
	}

	if input == nil {
		input = &DeleteStudioComponentInput{}
	}

	output = &DeleteStudioComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStudioComponent API operation for AmazonNimbleStudio.
//
// Deletes a studio component resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation DeleteStudioComponent for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioComponent
func (c *NimbleStudio) DeleteStudioComponent(input *DeleteStudioComponentInput) (*DeleteStudioComponentOutput, error) {
	req, out := c.DeleteStudioComponentRequest(input)
	return out, req.Send()
}

// DeleteStudioComponentWithContext is the same as DeleteStudioComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStudioComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) DeleteStudioComponentWithContext(ctx aws.Context, input *DeleteStudioComponentInput, opts ...request.Option) (*DeleteStudioComponentOutput, error) {
	req, out := c.DeleteStudioComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStudioMember = "DeleteStudioMember"

// DeleteStudioMemberRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStudioMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStudioMember for more information on using the DeleteStudioMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStudioMemberRequest method.
//	req, resp := client.DeleteStudioMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioMember
func (c *NimbleStudio) DeleteStudioMemberRequest(input *DeleteStudioMemberInput) (req *request.Request, output *DeleteStudioMemberOutput) {
	op := &request.Operation{
		Name:       opDeleteStudioMember,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-08-01/studios/{studioId}/membership/{principalId}",
	}

	if input == nil {
		input = &DeleteStudioMemberInput{}
	}

	output = &DeleteStudioMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStudioMember API operation for AmazonNimbleStudio.
//
// Delete a user from studio membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation DeleteStudioMember for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioMember
func (c *NimbleStudio) DeleteStudioMember(input *DeleteStudioMemberInput) (*DeleteStudioMemberOutput, error) {
	req, out := c.DeleteStudioMemberRequest(input)
	return out, req.Send()
}

// DeleteStudioMemberWithContext is the same as DeleteStudioMember with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStudioMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) DeleteStudioMemberWithContext(ctx aws.Context, input *DeleteStudioMemberInput, opts ...request.Option) (*DeleteStudioMemberOutput, error) {
	req, out := c.DeleteStudioMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEula = "GetEula"

// GetEulaRequest generates a "aws/request.Request" representing the
// client's request for the GetEula operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEula for more information on using the GetEula
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEulaRequest method.
//	req, resp := client.GetEulaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetEula
func (c *NimbleStudio) GetEulaRequest(input *GetEulaInput) (req *request.Request, output *GetEulaOutput) {
	op := &request.Operation{
		Name:       opGetEula,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/eulas/{eulaId}",
	}

	if input == nil {
		input = &GetEulaInput{}
	}

	output = &GetEulaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEula API operation for AmazonNimbleStudio.
//
// Get Eula.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetEula for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetEula
func (c *NimbleStudio) GetEula(input *GetEulaInput) (*GetEulaOutput, error) {
	req, out := c.GetEulaRequest(input)
	return out, req.Send()
}

// GetEulaWithContext is the same as GetEula with the addition of
// the ability to pass a context and additional request options.
//
// See GetEula for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetEulaWithContext(ctx aws.Context, input *GetEulaInput, opts ...request.Option) (*GetEulaOutput, error) {
	req, out := c.GetEulaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLaunchProfile = "GetLaunchProfile"

// GetLaunchProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetLaunchProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLaunchProfile for more information on using the GetLaunchProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLaunchProfileRequest method.
//	req, resp := client.GetLaunchProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfile
func (c *NimbleStudio) GetLaunchProfileRequest(input *GetLaunchProfileInput) (req *request.Request, output *GetLaunchProfileOutput) {
	op := &request.Operation{
		Name:       opGetLaunchProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}",
	}

	if input == nil {
		input = &GetLaunchProfileInput{}
	}

	output = &GetLaunchProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLaunchProfile API operation for AmazonNimbleStudio.
//
// Get a launch profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetLaunchProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfile
func (c *NimbleStudio) GetLaunchProfile(input *GetLaunchProfileInput) (*GetLaunchProfileOutput, error) {
	req, out := c.GetLaunchProfileRequest(input)
	return out, req.Send()
}

// GetLaunchProfileWithContext is the same as GetLaunchProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetLaunchProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetLaunchProfileWithContext(ctx aws.Context, input *GetLaunchProfileInput, opts ...request.Option) (*GetLaunchProfileOutput, error) {
	req, out := c.GetLaunchProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLaunchProfileDetails = "GetLaunchProfileDetails"

// GetLaunchProfileDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetLaunchProfileDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLaunchProfileDetails for more information on using the GetLaunchProfileDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLaunchProfileDetailsRequest method.
//	req, resp := client.GetLaunchProfileDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileDetails
func (c *NimbleStudio) GetLaunchProfileDetailsRequest(input *GetLaunchProfileDetailsInput) (req *request.Request, output *GetLaunchProfileDetailsOutput) {
	op := &request.Operation{
		Name:       opGetLaunchProfileDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/details",
	}

	if input == nil {
		input = &GetLaunchProfileDetailsInput{}
	}

	output = &GetLaunchProfileDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLaunchProfileDetails API operation for AmazonNimbleStudio.
//
// Launch profile details include the launch profile resource and summary information
// of resources that are used by, or available to, the launch profile. This
// includes the name and description of all studio components used by the launch
// profiles, and the name and description of streaming images that can be used
// with this launch profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetLaunchProfileDetails for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileDetails
func (c *NimbleStudio) GetLaunchProfileDetails(input *GetLaunchProfileDetailsInput) (*GetLaunchProfileDetailsOutput, error) {
	req, out := c.GetLaunchProfileDetailsRequest(input)
	return out, req.Send()
}

// GetLaunchProfileDetailsWithContext is the same as GetLaunchProfileDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetLaunchProfileDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetLaunchProfileDetailsWithContext(ctx aws.Context, input *GetLaunchProfileDetailsInput, opts ...request.Option) (*GetLaunchProfileDetailsOutput, error) {
	req, out := c.GetLaunchProfileDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLaunchProfileInitialization = "GetLaunchProfileInitialization"

// GetLaunchProfileInitializationRequest generates a "aws/request.Request" representing the
// client's request for the GetLaunchProfileInitialization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLaunchProfileInitialization for more information on using the GetLaunchProfileInitialization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLaunchProfileInitializationRequest method.
//	req, resp := client.GetLaunchProfileInitializationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileInitialization
func (c *NimbleStudio) GetLaunchProfileInitializationRequest(input *GetLaunchProfileInitializationInput) (req *request.Request, output *GetLaunchProfileInitializationOutput) {
	op := &request.Operation{
		Name:       opGetLaunchProfileInitialization,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/init",
	}

	if input == nil {
		input = &GetLaunchProfileInitializationInput{}
	}

	output = &GetLaunchProfileInitializationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLaunchProfileInitialization API operation for AmazonNimbleStudio.
//
// Get a launch profile initialization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetLaunchProfileInitialization for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileInitialization
func (c *NimbleStudio) GetLaunchProfileInitialization(input *GetLaunchProfileInitializationInput) (*GetLaunchProfileInitializationOutput, error) {
	req, out := c.GetLaunchProfileInitializationRequest(input)
	return out, req.Send()
}

// GetLaunchProfileInitializationWithContext is the same as GetLaunchProfileInitialization with the addition of
// the ability to pass a context and additional request options.
//
// See GetLaunchProfileInitialization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetLaunchProfileInitializationWithContext(ctx aws.Context, input *GetLaunchProfileInitializationInput, opts ...request.Option) (*GetLaunchProfileInitializationOutput, error) {
	req, out := c.GetLaunchProfileInitializationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLaunchProfileMember = "GetLaunchProfileMember"

// GetLaunchProfileMemberRequest generates a "aws/request.Request" representing the
// client's request for the GetLaunchProfileMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLaunchProfileMember for more information on using the GetLaunchProfileMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLaunchProfileMemberRequest method.
//	req, resp := client.GetLaunchProfileMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileMember
func (c *NimbleStudio) GetLaunchProfileMemberRequest(input *GetLaunchProfileMemberInput) (req *request.Request, output *GetLaunchProfileMemberOutput) {
	op := &request.Operation{
		Name:       opGetLaunchProfileMember,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}",
	}

	if input == nil {
		input = &GetLaunchProfileMemberInput{}
	}

	output = &GetLaunchProfileMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLaunchProfileMember API operation for AmazonNimbleStudio.
//
// Get a user persona in launch profile membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetLaunchProfileMember for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileMember
func (c *NimbleStudio) GetLaunchProfileMember(input *GetLaunchProfileMemberInput) (*GetLaunchProfileMemberOutput, error) {
	req, out := c.GetLaunchProfileMemberRequest(input)
	return out, req.Send()
}

// GetLaunchProfileMemberWithContext is the same as GetLaunchProfileMember with the addition of
// the ability to pass a context and additional request options.
//
// See GetLaunchProfileMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetLaunchProfileMemberWithContext(ctx aws.Context, input *GetLaunchProfileMemberInput, opts ...request.Option) (*GetLaunchProfileMemberOutput, error) {
	req, out := c.GetLaunchProfileMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamingImage = "GetStreamingImage"

// GetStreamingImageRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamingImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamingImage for more information on using the GetStreamingImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStreamingImageRequest method.
//	req, resp := client.GetStreamingImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingImage
func (c *NimbleStudio) GetStreamingImageRequest(input *GetStreamingImageInput) (req *request.Request, output *GetStreamingImageOutput) {
	op := &request.Operation{
		Name:       opGetStreamingImage,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}",
	}

	if input == nil {
		input = &GetStreamingImageInput{}
	}

	output = &GetStreamingImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamingImage API operation for AmazonNimbleStudio.
//
// Get streaming image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetStreamingImage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingImage
func (c *NimbleStudio) GetStreamingImage(input *GetStreamingImageInput) (*GetStreamingImageOutput, error) {
	req, out := c.GetStreamingImageRequest(input)
	return out, req.Send()
}

// GetStreamingImageWithContext is the same as GetStreamingImage with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamingImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetStreamingImageWithContext(ctx aws.Context, input *GetStreamingImageInput, opts ...request.Option) (*GetStreamingImageOutput, error) {
	req, out := c.GetStreamingImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamingSession = "GetStreamingSession"

// GetStreamingSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamingSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamingSession for more information on using the GetStreamingSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStreamingSessionRequest method.
//	req, resp := client.GetStreamingSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSession
func (c *NimbleStudio) GetStreamingSessionRequest(input *GetStreamingSessionInput) (req *request.Request, output *GetStreamingSessionOutput) {
	op := &request.Operation{
		Name:       opGetStreamingSession,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}",
	}

	if input == nil {
		input = &GetStreamingSessionInput{}
	}

	output = &GetStreamingSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamingSession API operation for AmazonNimbleStudio.
//
// Gets StreamingSession resource.
//
// Invoke this operation to poll for a streaming session state while creating
// or deleting a session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetStreamingSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSession
func (c *NimbleStudio) GetStreamingSession(input *GetStreamingSessionInput) (*GetStreamingSessionOutput, error) {
	req, out := c.GetStreamingSessionRequest(input)
	return out, req.Send()
}

// GetStreamingSessionWithContext is the same as GetStreamingSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamingSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetStreamingSessionWithContext(ctx aws.Context, input *GetStreamingSessionInput, opts ...request.Option) (*GetStreamingSessionOutput, error) {
	req, out := c.GetStreamingSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamingSessionStream = "GetStreamingSessionStream"

// GetStreamingSessionStreamRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamingSessionStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamingSessionStream for more information on using the GetStreamingSessionStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStreamingSessionStreamRequest method.
//	req, resp := client.GetStreamingSessionStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSessionStream
func (c *NimbleStudio) GetStreamingSessionStreamRequest(input *GetStreamingSessionStreamInput) (req *request.Request, output *GetStreamingSessionStreamOutput) {
	op := &request.Operation{
		Name:       opGetStreamingSessionStream,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/streams/{streamId}",
	}

	if input == nil {
		input = &GetStreamingSessionStreamInput{}
	}

	output = &GetStreamingSessionStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamingSessionStream API operation for AmazonNimbleStudio.
//
// Gets a StreamingSessionStream for a streaming session.
//
// Invoke this operation to poll the resource after invoking CreateStreamingSessionStream.
//
// After the StreamingSessionStream changes to the state READY, the url property
// will contain a stream to be used with the DCV streaming client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetStreamingSessionStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSessionStream
func (c *NimbleStudio) GetStreamingSessionStream(input *GetStreamingSessionStreamInput) (*GetStreamingSessionStreamOutput, error) {
	req, out := c.GetStreamingSessionStreamRequest(input)
	return out, req.Send()
}

// GetStreamingSessionStreamWithContext is the same as GetStreamingSessionStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamingSessionStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetStreamingSessionStreamWithContext(ctx aws.Context, input *GetStreamingSessionStreamInput, opts ...request.Option) (*GetStreamingSessionStreamOutput, error) {
	req, out := c.GetStreamingSessionStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStudio = "GetStudio"

// GetStudioRequest generates a "aws/request.Request" representing the
// client's request for the GetStudio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStudio for more information on using the GetStudio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStudioRequest method.
//	req, resp := client.GetStudioRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudio
func (c *NimbleStudio) GetStudioRequest(input *GetStudioInput) (req *request.Request, output *GetStudioOutput) {
	op := &request.Operation{
		Name:       opGetStudio,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}",
	}

	if input == nil {
		input = &GetStudioInput{}
	}

	output = &GetStudioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStudio API operation for AmazonNimbleStudio.
//
// Get a Studio resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetStudio for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudio
func (c *NimbleStudio) GetStudio(input *GetStudioInput) (*GetStudioOutput, error) {
	req, out := c.GetStudioRequest(input)
	return out, req.Send()
}

// GetStudioWithContext is the same as GetStudio with the addition of
// the ability to pass a context and additional request options.
//
// See GetStudio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetStudioWithContext(ctx aws.Context, input *GetStudioInput, opts ...request.Option) (*GetStudioOutput, error) {
	req, out := c.GetStudioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStudioComponent = "GetStudioComponent"

// GetStudioComponentRequest generates a "aws/request.Request" representing the
// client's request for the GetStudioComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStudioComponent for more information on using the GetStudioComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStudioComponentRequest method.
//	req, resp := client.GetStudioComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioComponent
func (c *NimbleStudio) GetStudioComponentRequest(input *GetStudioComponentInput) (req *request.Request, output *GetStudioComponentOutput) {
	op := &request.Operation{
		Name:       opGetStudioComponent,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}",
	}

	if input == nil {
		input = &GetStudioComponentInput{}
	}

	output = &GetStudioComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStudioComponent API operation for AmazonNimbleStudio.
//
// Gets a studio component resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetStudioComponent for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioComponent
func (c *NimbleStudio) GetStudioComponent(input *GetStudioComponentInput) (*GetStudioComponentOutput, error) {
	req, out := c.GetStudioComponentRequest(input)
	return out, req.Send()
}

// GetStudioComponentWithContext is the same as GetStudioComponent with the addition of
// the ability to pass a context and additional request options.
//
// See GetStudioComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetStudioComponentWithContext(ctx aws.Context, input *GetStudioComponentInput, opts ...request.Option) (*GetStudioComponentOutput, error) {
	req, out := c.GetStudioComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStudioMember = "GetStudioMember"

// GetStudioMemberRequest generates a "aws/request.Request" representing the
// client's request for the GetStudioMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStudioMember for more information on using the GetStudioMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStudioMemberRequest method.
//	req, resp := client.GetStudioMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioMember
func (c *NimbleStudio) GetStudioMemberRequest(input *GetStudioMemberInput) (req *request.Request, output *GetStudioMemberOutput) {
	op := &request.Operation{
		Name:       opGetStudioMember,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/membership/{principalId}",
	}

	if input == nil {
		input = &GetStudioMemberInput{}
	}

	output = &GetStudioMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStudioMember API operation for AmazonNimbleStudio.
//
// Get a user's membership in a studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation GetStudioMember for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioMember
func (c *NimbleStudio) GetStudioMember(input *GetStudioMemberInput) (*GetStudioMemberOutput, error) {
	req, out := c.GetStudioMemberRequest(input)
	return out, req.Send()
}

// GetStudioMemberWithContext is the same as GetStudioMember with the addition of
// the ability to pass a context and additional request options.
//
// See GetStudioMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) GetStudioMemberWithContext(ctx aws.Context, input *GetStudioMemberInput, opts ...request.Option) (*GetStudioMemberOutput, error) {
	req, out := c.GetStudioMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEulaAcceptances = "ListEulaAcceptances"

// ListEulaAcceptancesRequest generates a "aws/request.Request" representing the
// client's request for the ListEulaAcceptances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEulaAcceptances for more information on using the ListEulaAcceptances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEulaAcceptancesRequest method.
//	req, resp := client.ListEulaAcceptancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulaAcceptances
func (c *NimbleStudio) ListEulaAcceptancesRequest(input *ListEulaAcceptancesInput) (req *request.Request, output *ListEulaAcceptancesOutput) {
	op := &request.Operation{
		Name:       opListEulaAcceptances,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/eula-acceptances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEulaAcceptancesInput{}
	}

	output = &ListEulaAcceptancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEulaAcceptances API operation for AmazonNimbleStudio.
//
// List Eula Acceptances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListEulaAcceptances for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulaAcceptances
func (c *NimbleStudio) ListEulaAcceptances(input *ListEulaAcceptancesInput) (*ListEulaAcceptancesOutput, error) {
	req, out := c.ListEulaAcceptancesRequest(input)
	return out, req.Send()
}

// ListEulaAcceptancesWithContext is the same as ListEulaAcceptances with the addition of
// the ability to pass a context and additional request options.
//
// See ListEulaAcceptances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListEulaAcceptancesWithContext(ctx aws.Context, input *ListEulaAcceptancesInput, opts ...request.Option) (*ListEulaAcceptancesOutput, error) {
	req, out := c.ListEulaAcceptancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEulaAcceptancesPages iterates over the pages of a ListEulaAcceptances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEulaAcceptances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEulaAcceptances operation.
//	pageNum := 0
//	err := client.ListEulaAcceptancesPages(params,
//	    func(page *nimblestudio.ListEulaAcceptancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NimbleStudio) ListEulaAcceptancesPages(input *ListEulaAcceptancesInput, fn func(*ListEulaAcceptancesOutput, bool) bool) error {
	return c.ListEulaAcceptancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEulaAcceptancesPagesWithContext same as ListEulaAcceptancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListEulaAcceptancesPagesWithContext(ctx aws.Context, input *ListEulaAcceptancesInput, fn func(*ListEulaAcceptancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEulaAcceptancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEulaAcceptancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEulaAcceptancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEulas = "ListEulas"

// ListEulasRequest generates a "aws/request.Request" representing the
// client's request for the ListEulas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEulas for more information on using the ListEulas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEulasRequest method.
//	req, resp := client.ListEulasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulas
func (c *NimbleStudio) ListEulasRequest(input *ListEulasInput) (req *request.Request, output *ListEulasOutput) {
	op := &request.Operation{
		Name:       opListEulas,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/eulas",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEulasInput{}
	}

	output = &ListEulasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEulas API operation for AmazonNimbleStudio.
//
// List Eulas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListEulas for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulas
func (c *NimbleStudio) ListEulas(input *ListEulasInput) (*ListEulasOutput, error) {
	req, out := c.ListEulasRequest(input)
	return out, req.Send()
}

// ListEulasWithContext is the same as ListEulas with the addition of
// the ability to pass a context and additional request options.
//
// See ListEulas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListEulasWithContext(ctx aws.Context, input *ListEulasInput, opts ...request.Option) (*ListEulasOutput, error) {
	req, out := c.ListEulasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEulasPages iterates over the pages of a ListEulas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEulas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEulas operation.
//	pageNum := 0
//	err := client.ListEulasPages(params,
//	    func(page *nimblestudio.ListEulasOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NimbleStudio) ListEulasPages(input *ListEulasInput, fn func(*ListEulasOutput, bool) bool) error {
	return c.ListEulasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEulasPagesWithContext same as ListEulasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListEulasPagesWithContext(ctx aws.Context, input *ListEulasInput, fn func(*ListEulasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEulasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEulasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEulasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLaunchProfileMembers = "ListLaunchProfileMembers"

// ListLaunchProfileMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListLaunchProfileMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLaunchProfileMembers for more information on using the ListLaunchProfileMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLaunchProfileMembersRequest method.
//	req, resp := client.ListLaunchProfileMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfileMembers
func (c *NimbleStudio) ListLaunchProfileMembersRequest(input *ListLaunchProfileMembersInput) (req *request.Request, output *ListLaunchProfileMembersOutput) {
	op := &request.Operation{
		Name:       opListLaunchProfileMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLaunchProfileMembersInput{}
	}

	output = &ListLaunchProfileMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLaunchProfileMembers API operation for AmazonNimbleStudio.
//
// Get all users in a given launch profile membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListLaunchProfileMembers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfileMembers
func (c *NimbleStudio) ListLaunchProfileMembers(input *ListLaunchProfileMembersInput) (*ListLaunchProfileMembersOutput, error) {
	req, out := c.ListLaunchProfileMembersRequest(input)
	return out, req.Send()
}

// ListLaunchProfileMembersWithContext is the same as ListLaunchProfileMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListLaunchProfileMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListLaunchProfileMembersWithContext(ctx aws.Context, input *ListLaunchProfileMembersInput, opts ...request.Option) (*ListLaunchProfileMembersOutput, error) {
	req, out := c.ListLaunchProfileMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLaunchProfileMembersPages iterates over the pages of a ListLaunchProfileMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLaunchProfileMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLaunchProfileMembers operation.
//	pageNum := 0
//	err := client.ListLaunchProfileMembersPages(params,
//	    func(page *nimblestudio.ListLaunchProfileMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NimbleStudio) ListLaunchProfileMembersPages(input *ListLaunchProfileMembersInput, fn func(*ListLaunchProfileMembersOutput, bool) bool) error {
	return c.ListLaunchProfileMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLaunchProfileMembersPagesWithContext same as ListLaunchProfileMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListLaunchProfileMembersPagesWithContext(ctx aws.Context, input *ListLaunchProfileMembersInput, fn func(*ListLaunchProfileMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLaunchProfileMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLaunchProfileMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLaunchProfileMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLaunchProfiles = "ListLaunchProfiles"

// ListLaunchProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListLaunchProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLaunchProfiles for more information on using the ListLaunchProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLaunchProfilesRequest method.
//	req, resp := client.ListLaunchProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfiles
func (c *NimbleStudio) ListLaunchProfilesRequest(input *ListLaunchProfilesInput) (req *request.Request, output *ListLaunchProfilesOutput) {
	op := &request.Operation{
		Name:       opListLaunchProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLaunchProfilesInput{}
	}

	output = &ListLaunchProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLaunchProfiles API operation for AmazonNimbleStudio.
//
// List all the launch profiles a studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListLaunchProfiles for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfiles
func (c *NimbleStudio) ListLaunchProfiles(input *ListLaunchProfilesInput) (*ListLaunchProfilesOutput, error) {
	req, out := c.ListLaunchProfilesRequest(input)
	return out, req.Send()
}

// ListLaunchProfilesWithContext is the same as ListLaunchProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListLaunchProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListLaunchProfilesWithContext(ctx aws.Context, input *ListLaunchProfilesInput, opts ...request.Option) (*ListLaunchProfilesOutput, error) {
	req, out := c.ListLaunchProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLaunchProfilesPages iterates over the pages of a ListLaunchProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLaunchProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLaunchProfiles operation.
//	pageNum := 0
//	err := client.ListLaunchProfilesPages(params,
//	    func(page *nimblestudio.ListLaunchProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NimbleStudio) ListLaunchProfilesPages(input *ListLaunchProfilesInput, fn func(*ListLaunchProfilesOutput, bool) bool) error {
	return c.ListLaunchProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLaunchProfilesPagesWithContext same as ListLaunchProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListLaunchProfilesPagesWithContext(ctx aws.Context, input *ListLaunchProfilesInput, fn func(*ListLaunchProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLaunchProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLaunchProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLaunchProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStreamingImages = "ListStreamingImages"

// ListStreamingImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListStreamingImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreamingImages for more information on using the ListStreamingImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStreamingImagesRequest method.
//	req, resp := client.ListStreamingImagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingImages
func (c *NimbleStudio) ListStreamingImagesRequest(input *ListStreamingImagesInput) (req *request.Request, output *ListStreamingImagesOutput) {
	op := &request.Operation{
		Name:       opListStreamingImages,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-images",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamingImagesInput{}
	}

	output = &ListStreamingImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreamingImages API operation for AmazonNimbleStudio.
//
// List the streaming image resources available to this studio.
//
// This list will contain both images provided by Amazon Web Services, as well
// as streaming images that you have created in your studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListStreamingImages for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingImages
func (c *NimbleStudio) ListStreamingImages(input *ListStreamingImagesInput) (*ListStreamingImagesOutput, error) {
	req, out := c.ListStreamingImagesRequest(input)
	return out, req.Send()
}

// ListStreamingImagesWithContext is the same as ListStreamingImages with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreamingImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStreamingImagesWithContext(ctx aws.Context, input *ListStreamingImagesInput, opts ...request.Option) (*ListStreamingImagesOutput, error) {
	req, out := c.ListStreamingImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamingImagesPages iterates over the pages of a ListStreamingImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreamingImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStreamingImages operation.
//	pageNum := 0
//	err := client.ListStreamingImagesPages(params,
//	    func(page *nimblestudio.ListStreamingImagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NimbleStudio) ListStreamingImagesPages(input *ListStreamingImagesInput, fn func(*ListStreamingImagesOutput, bool) bool) error {
	return c.ListStreamingImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamingImagesPagesWithContext same as ListStreamingImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStreamingImagesPagesWithContext(ctx aws.Context, input *ListStreamingImagesInput, fn func(*ListStreamingImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamingImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamingImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamingImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStreamingSessions = "ListStreamingSessions"

// ListStreamingSessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreamingSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreamingSessions for more information on using the ListStreamingSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStreamingSessionsRequest method.
//	req, resp := client.ListStreamingSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessions
func (c *NimbleStudio) ListStreamingSessionsRequest(input *ListStreamingSessionsInput) (req *request.Request, output *ListStreamingSessionsOutput) {
	op := &request.Operation{
		Name:       opListStreamingSessions,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-sessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamingSessionsInput{}
	}

	output = &ListStreamingSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreamingSessions API operation for AmazonNimbleStudio.
//
// Lists the streaming sessions in a studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListStreamingSessions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessions
func (c *NimbleStudio) ListStreamingSessions(input *ListStreamingSessionsInput) (*ListStreamingSessionsOutput, error) {
	req, out := c.ListStreamingSessionsRequest(input)
	return out, req.Send()
}

// ListStreamingSessionsWithContext is the same as ListStreamingSessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreamingSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStreamingSessionsWithContext(ctx aws.Context, input *ListStreamingSessionsInput, opts ...request.Option) (*ListStreamingSessionsOutput, error) {
	req, out := c.ListStreamingSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamingSessionsPages iterates over the pages of a ListStreamingSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreamingSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStreamingSessions operation.
//	pageNum := 0
//	err := client.ListStreamingSessionsPages(params,
//	    func(page *nimblestudio.ListStreamingSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NimbleStudio) ListStreamingSessionsPages(input *ListStreamingSessionsInput, fn func(*ListStreamingSessionsOutput, bool) bool) error {
	return c.ListStreamingSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamingSessionsPagesWithContext same as ListStreamingSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStreamingSessionsPagesWithContext(ctx aws.Context, input *ListStreamingSessionsInput, fn func(*ListStreamingSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamingSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamingSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamingSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStudioComponents = "ListStudioComponents"

// ListStudioComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListStudioComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStudioComponents for more information on using the ListStudioComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStudioComponentsRequest method.
//	req, resp := client.ListStudioComponentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioComponents
func (c *NimbleStudio) ListStudioComponentsRequest(input *ListStudioComponentsInput) (req *request.Request, output *ListStudioComponentsOutput) {
	op := &request.Operation{
		Name:       opListStudioComponents,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/studio-components",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStudioComponentsInput{}
	}

	output = &ListStudioComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStudioComponents API operation for AmazonNimbleStudio.
//
// Lists the StudioComponents in a studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListStudioComponents for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioComponents
func (c *NimbleStudio) ListStudioComponents(input *ListStudioComponentsInput) (*ListStudioComponentsOutput, error) {
	req, out := c.ListStudioComponentsRequest(input)
	return out, req.Send()
}

// ListStudioComponentsWithContext is the same as ListStudioComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListStudioComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStudioComponentsWithContext(ctx aws.Context, input *ListStudioComponentsInput, opts ...request.Option) (*ListStudioComponentsOutput, error) {
	req, out := c.ListStudioComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStudioComponentsPages iterates over the pages of a ListStudioComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStudioComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStudioComponents operation.
//	pageNum := 0
//	err := client.ListStudioComponentsPages(params,
//	    func(page *nimblestudio.ListStudioComponentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NimbleStudio) ListStudioComponentsPages(input *ListStudioComponentsInput, fn func(*ListStudioComponentsOutput, bool) bool) error {
	return c.ListStudioComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStudioComponentsPagesWithContext same as ListStudioComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStudioComponentsPagesWithContext(ctx aws.Context, input *ListStudioComponentsInput, fn func(*ListStudioComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStudioComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStudioComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStudioComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStudioMembers = "ListStudioMembers"

// ListStudioMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListStudioMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStudioMembers for more information on using the ListStudioMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStudioMembersRequest method.
//	req, resp := client.ListStudioMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioMembers
func (c *NimbleStudio) ListStudioMembersRequest(input *ListStudioMembersInput) (req *request.Request, output *ListStudioMembersOutput) {
	op := &request.Operation{
		Name:       opListStudioMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios/{studioId}/membership",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStudioMembersInput{}
	}

	output = &ListStudioMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStudioMembers API operation for AmazonNimbleStudio.
//
// Get all users in a given studio membership.
//
// ListStudioMembers only returns admin members.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListStudioMembers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioMembers
func (c *NimbleStudio) ListStudioMembers(input *ListStudioMembersInput) (*ListStudioMembersOutput, error) {
	req, out := c.ListStudioMembersRequest(input)
	return out, req.Send()
}

// ListStudioMembersWithContext is the same as ListStudioMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListStudioMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStudioMembersWithContext(ctx aws.Context, input *ListStudioMembersInput, opts ...request.Option) (*ListStudioMembersOutput, error) {
	req, out := c.ListStudioMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStudioMembersPages iterates over the pages of a ListStudioMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStudioMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStudioMembers operation.
//	pageNum := 0
//	err := client.ListStudioMembersPages(params,
//	    func(page *nimblestudio.ListStudioMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NimbleStudio) ListStudioMembersPages(input *ListStudioMembersInput, fn func(*ListStudioMembersOutput, bool) bool) error {
	return c.ListStudioMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStudioMembersPagesWithContext same as ListStudioMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStudioMembersPagesWithContext(ctx aws.Context, input *ListStudioMembersInput, fn func(*ListStudioMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStudioMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStudioMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStudioMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStudios = "ListStudios"

// ListStudiosRequest generates a "aws/request.Request" representing the
// client's request for the ListStudios operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStudios for more information on using the ListStudios
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStudiosRequest method.
//	req, resp := client.ListStudiosRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudios
func (c *NimbleStudio) ListStudiosRequest(input *ListStudiosInput) (req *request.Request, output *ListStudiosOutput) {
	op := &request.Operation{
		Name:       opListStudios,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/studios",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStudiosInput{}
	}

	output = &ListStudiosOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStudios API operation for AmazonNimbleStudio.
//
// List studios in your Amazon Web Services account in the requested Amazon
// Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListStudios for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudios
func (c *NimbleStudio) ListStudios(input *ListStudiosInput) (*ListStudiosOutput, error) {
	req, out := c.ListStudiosRequest(input)
	return out, req.Send()
}

// ListStudiosWithContext is the same as ListStudios with the addition of
// the ability to pass a context and additional request options.
//
// See ListStudios for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStudiosWithContext(ctx aws.Context, input *ListStudiosInput, opts ...request.Option) (*ListStudiosOutput, error) {
	req, out := c.ListStudiosRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStudiosPages iterates over the pages of a ListStudios operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStudios method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStudios operation.
//	pageNum := 0
//	err := client.ListStudiosPages(params,
//	    func(page *nimblestudio.ListStudiosOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NimbleStudio) ListStudiosPages(input *ListStudiosInput, fn func(*ListStudiosOutput, bool) bool) error {
	return c.ListStudiosPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStudiosPagesWithContext same as ListStudiosPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListStudiosPagesWithContext(ctx aws.Context, input *ListStudiosInput, fn func(*ListStudiosOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStudiosInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStudiosRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStudiosOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListTagsForResource
func (c *NimbleStudio) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-08-01/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AmazonNimbleStudio.
//
// Gets the tags for a resource, given its Amazon Resource Names (ARN).
//
// This operation supports ARNs for all resource types in Nimble Studio that
// support tags, including studio, studio component, launch profile, streaming
// image, and streaming session. All resources that can be tagged will contain
// an ARN property, so you do not have to create this ARN yourself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListTagsForResource
func (c *NimbleStudio) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLaunchProfileMembers = "PutLaunchProfileMembers"

// PutLaunchProfileMembersRequest generates a "aws/request.Request" representing the
// client's request for the PutLaunchProfileMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLaunchProfileMembers for more information on using the PutLaunchProfileMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutLaunchProfileMembersRequest method.
//	req, resp := client.PutLaunchProfileMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutLaunchProfileMembers
func (c *NimbleStudio) PutLaunchProfileMembersRequest(input *PutLaunchProfileMembersInput) (req *request.Request, output *PutLaunchProfileMembersOutput) {
	op := &request.Operation{
		Name:       opPutLaunchProfileMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership",
	}

	if input == nil {
		input = &PutLaunchProfileMembersInput{}
	}

	output = &PutLaunchProfileMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutLaunchProfileMembers API operation for AmazonNimbleStudio.
//
// Add/update users with given persona to launch profile membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation PutLaunchProfileMembers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutLaunchProfileMembers
func (c *NimbleStudio) PutLaunchProfileMembers(input *PutLaunchProfileMembersInput) (*PutLaunchProfileMembersOutput, error) {
	req, out := c.PutLaunchProfileMembersRequest(input)
	return out, req.Send()
}

// PutLaunchProfileMembersWithContext is the same as PutLaunchProfileMembers with the addition of
// the ability to pass a context and additional request options.
//
// See PutLaunchProfileMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) PutLaunchProfileMembersWithContext(ctx aws.Context, input *PutLaunchProfileMembersInput, opts ...request.Option) (*PutLaunchProfileMembersOutput, error) {
	req, out := c.PutLaunchProfileMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutStudioMembers = "PutStudioMembers"

// PutStudioMembersRequest generates a "aws/request.Request" representing the
// client's request for the PutStudioMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutStudioMembers for more information on using the PutStudioMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutStudioMembersRequest method.
//	req, resp := client.PutStudioMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutStudioMembers
func (c *NimbleStudio) PutStudioMembersRequest(input *PutStudioMembersInput) (req *request.Request, output *PutStudioMembersOutput) {
	op := &request.Operation{
		Name:       opPutStudioMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/membership",
	}

	if input == nil {
		input = &PutStudioMembersInput{}
	}

	output = &PutStudioMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutStudioMembers API operation for AmazonNimbleStudio.
//
// Add/update users with given persona to studio membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation PutStudioMembers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutStudioMembers
func (c *NimbleStudio) PutStudioMembers(input *PutStudioMembersInput) (*PutStudioMembersOutput, error) {
	req, out := c.PutStudioMembersRequest(input)
	return out, req.Send()
}

// PutStudioMembersWithContext is the same as PutStudioMembers with the addition of
// the ability to pass a context and additional request options.
//
// See PutStudioMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) PutStudioMembersWithContext(ctx aws.Context, input *PutStudioMembersInput, opts ...request.Option) (*PutStudioMembersOutput, error) {
	req, out := c.PutStudioMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartStreamingSession = "StartStreamingSession"

// StartStreamingSessionRequest generates a "aws/request.Request" representing the
// client's request for the StartStreamingSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartStreamingSession for more information on using the StartStreamingSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartStreamingSessionRequest method.
//	req, resp := client.StartStreamingSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStreamingSession
func (c *NimbleStudio) StartStreamingSessionRequest(input *StartStreamingSessionInput) (req *request.Request, output *StartStreamingSessionOutput) {
	op := &request.Operation{
		Name:       opStartStreamingSession,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/start",
	}

	if input == nil {
		input = &StartStreamingSessionInput{}
	}

	output = &StartStreamingSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartStreamingSession API operation for AmazonNimbleStudio.
//
// Transitions sessions from the STOPPED state into the READY state. The START_IN_PROGRESS
// state is the intermediate state between the STOPPED and READY states.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation StartStreamingSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStreamingSession
func (c *NimbleStudio) StartStreamingSession(input *StartStreamingSessionInput) (*StartStreamingSessionOutput, error) {
	req, out := c.StartStreamingSessionRequest(input)
	return out, req.Send()
}

// StartStreamingSessionWithContext is the same as StartStreamingSession with the addition of
// the ability to pass a context and additional request options.
//
// See StartStreamingSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) StartStreamingSessionWithContext(ctx aws.Context, input *StartStreamingSessionInput, opts ...request.Option) (*StartStreamingSessionOutput, error) {
	req, out := c.StartStreamingSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartStudioSSOConfigurationRepair = "StartStudioSSOConfigurationRepair"

// StartStudioSSOConfigurationRepairRequest generates a "aws/request.Request" representing the
// client's request for the StartStudioSSOConfigurationRepair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartStudioSSOConfigurationRepair for more information on using the StartStudioSSOConfigurationRepair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartStudioSSOConfigurationRepairRequest method.
//	req, resp := client.StartStudioSSOConfigurationRepairRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStudioSSOConfigurationRepair
func (c *NimbleStudio) StartStudioSSOConfigurationRepairRequest(input *StartStudioSSOConfigurationRepairInput) (req *request.Request, output *StartStudioSSOConfigurationRepairOutput) {
	op := &request.Operation{
		Name:       opStartStudioSSOConfigurationRepair,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-08-01/studios/{studioId}/sso-configuration",
	}

	if input == nil {
		input = &StartStudioSSOConfigurationRepairInput{}
	}

	output = &StartStudioSSOConfigurationRepairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartStudioSSOConfigurationRepair API operation for AmazonNimbleStudio.
//
// Repairs the IAM Identity Center configuration for a given studio.
//
// If the studio has a valid IAM Identity Center configuration currently associated
// with it, this operation will fail with a validation error.
//
// If the studio does not have a valid IAM Identity Center configuration currently
// associated with it, then a new IAM Identity Center application is created
// for the studio and the studio is changed to the READY state.
//
// After the IAM Identity Center application is repaired, you must use the Amazon
// Nimble Studio console to add administrators and users to your studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation StartStudioSSOConfigurationRepair for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStudioSSOConfigurationRepair
func (c *NimbleStudio) StartStudioSSOConfigurationRepair(input *StartStudioSSOConfigurationRepairInput) (*StartStudioSSOConfigurationRepairOutput, error) {
	req, out := c.StartStudioSSOConfigurationRepairRequest(input)
	return out, req.Send()
}

// StartStudioSSOConfigurationRepairWithContext is the same as StartStudioSSOConfigurationRepair with the addition of
// the ability to pass a context and additional request options.
//
// See StartStudioSSOConfigurationRepair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) StartStudioSSOConfigurationRepairWithContext(ctx aws.Context, input *StartStudioSSOConfigurationRepairInput, opts ...request.Option) (*StartStudioSSOConfigurationRepairOutput, error) {
	req, out := c.StartStudioSSOConfigurationRepairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopStreamingSession = "StopStreamingSession"

// StopStreamingSessionRequest generates a "aws/request.Request" representing the
// client's request for the StopStreamingSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopStreamingSession for more information on using the StopStreamingSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopStreamingSessionRequest method.
//	req, resp := client.StopStreamingSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StopStreamingSession
func (c *NimbleStudio) StopStreamingSessionRequest(input *StopStreamingSessionInput) (req *request.Request, output *StopStreamingSessionOutput) {
	op := &request.Operation{
		Name:       opStopStreamingSession,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/stop",
	}

	if input == nil {
		input = &StopStreamingSessionInput{}
	}

	output = &StopStreamingSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopStreamingSession API operation for AmazonNimbleStudio.
//
// Transitions sessions from the READY state into the STOPPED state. The STOP_IN_PROGRESS
// state is the intermediate state between the READY and STOPPED states.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation StopStreamingSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StopStreamingSession
func (c *NimbleStudio) StopStreamingSession(input *StopStreamingSessionInput) (*StopStreamingSessionOutput, error) {
	req, out := c.StopStreamingSessionRequest(input)
	return out, req.Send()
}

// StopStreamingSessionWithContext is the same as StopStreamingSession with the addition of
// the ability to pass a context and additional request options.
//
// See StopStreamingSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) StopStreamingSessionWithContext(ctx aws.Context, input *StopStreamingSessionInput, opts ...request.Option) (*StopStreamingSessionOutput, error) {
	req, out := c.StopStreamingSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/TagResource
func (c *NimbleStudio) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-08-01/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AmazonNimbleStudio.
//
// Creates tags for a resource, given its ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/TagResource
func (c *NimbleStudio) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UntagResource
func (c *NimbleStudio) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-08-01/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AmazonNimbleStudio.
//
// Deletes the tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UntagResource
func (c *NimbleStudio) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLaunchProfile = "UpdateLaunchProfile"

// UpdateLaunchProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLaunchProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLaunchProfile for more information on using the UpdateLaunchProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLaunchProfileRequest method.
//	req, resp := client.UpdateLaunchProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfile
func (c *NimbleStudio) UpdateLaunchProfileRequest(input *UpdateLaunchProfileInput) (req *request.Request, output *UpdateLaunchProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateLaunchProfile,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}",
	}

	if input == nil {
		input = &UpdateLaunchProfileInput{}
	}

	output = &UpdateLaunchProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLaunchProfile API operation for AmazonNimbleStudio.
//
// Update a launch profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation UpdateLaunchProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfile
func (c *NimbleStudio) UpdateLaunchProfile(input *UpdateLaunchProfileInput) (*UpdateLaunchProfileOutput, error) {
	req, out := c.UpdateLaunchProfileRequest(input)
	return out, req.Send()
}

// UpdateLaunchProfileWithContext is the same as UpdateLaunchProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLaunchProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) UpdateLaunchProfileWithContext(ctx aws.Context, input *UpdateLaunchProfileInput, opts ...request.Option) (*UpdateLaunchProfileOutput, error) {
	req, out := c.UpdateLaunchProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLaunchProfileMember = "UpdateLaunchProfileMember"

// UpdateLaunchProfileMemberRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLaunchProfileMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLaunchProfileMember for more information on using the UpdateLaunchProfileMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLaunchProfileMemberRequest method.
//	req, resp := client.UpdateLaunchProfileMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfileMember
func (c *NimbleStudio) UpdateLaunchProfileMemberRequest(input *UpdateLaunchProfileMemberInput) (req *request.Request, output *UpdateLaunchProfileMemberOutput) {
	op := &request.Operation{
		Name:       opUpdateLaunchProfileMember,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}",
	}

	if input == nil {
		input = &UpdateLaunchProfileMemberInput{}
	}

	output = &UpdateLaunchProfileMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLaunchProfileMember API operation for AmazonNimbleStudio.
//
// Update a user persona in launch profile membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation UpdateLaunchProfileMember for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfileMember
func (c *NimbleStudio) UpdateLaunchProfileMember(input *UpdateLaunchProfileMemberInput) (*UpdateLaunchProfileMemberOutput, error) {
	req, out := c.UpdateLaunchProfileMemberRequest(input)
	return out, req.Send()
}

// UpdateLaunchProfileMemberWithContext is the same as UpdateLaunchProfileMember with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLaunchProfileMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) UpdateLaunchProfileMemberWithContext(ctx aws.Context, input *UpdateLaunchProfileMemberInput, opts ...request.Option) (*UpdateLaunchProfileMemberOutput, error) {
	req, out := c.UpdateLaunchProfileMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStreamingImage = "UpdateStreamingImage"

// UpdateStreamingImageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStreamingImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStreamingImage for more information on using the UpdateStreamingImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStreamingImageRequest method.
//	req, resp := client.UpdateStreamingImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStreamingImage
func (c *NimbleStudio) UpdateStreamingImageRequest(input *UpdateStreamingImageInput) (req *request.Request, output *UpdateStreamingImageOutput) {
	op := &request.Operation{
		Name:       opUpdateStreamingImage,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}",
	}

	if input == nil {
		input = &UpdateStreamingImageInput{}
	}

	output = &UpdateStreamingImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStreamingImage API operation for AmazonNimbleStudio.
//
// Update streaming image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation UpdateStreamingImage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStreamingImage
func (c *NimbleStudio) UpdateStreamingImage(input *UpdateStreamingImageInput) (*UpdateStreamingImageOutput, error) {
	req, out := c.UpdateStreamingImageRequest(input)
	return out, req.Send()
}

// UpdateStreamingImageWithContext is the same as UpdateStreamingImage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStreamingImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) UpdateStreamingImageWithContext(ctx aws.Context, input *UpdateStreamingImageInput, opts ...request.Option) (*UpdateStreamingImageOutput, error) {
	req, out := c.UpdateStreamingImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStudio = "UpdateStudio"

// UpdateStudioRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStudio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStudio for more information on using the UpdateStudio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStudioRequest method.
//	req, resp := client.UpdateStudioRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudio
func (c *NimbleStudio) UpdateStudioRequest(input *UpdateStudioInput) (req *request.Request, output *UpdateStudioOutput) {
	op := &request.Operation{
		Name:       opUpdateStudio,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2020-08-01/studios/{studioId}",
	}

	if input == nil {
		input = &UpdateStudioInput{}
	}

	output = &UpdateStudioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStudio API operation for AmazonNimbleStudio.
//
// Update a Studio resource.
//
// Currently, this operation only supports updating the displayName of your
// studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation UpdateStudio for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudio
func (c *NimbleStudio) UpdateStudio(input *UpdateStudioInput) (*UpdateStudioOutput, error) {
	req, out := c.UpdateStudioRequest(input)
	return out, req.Send()
}

// UpdateStudioWithContext is the same as UpdateStudio with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStudio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) UpdateStudioWithContext(ctx aws.Context, input *UpdateStudioInput, opts ...request.Option) (*UpdateStudioOutput, error) {
	req, out := c.UpdateStudioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStudioComponent = "UpdateStudioComponent"

// UpdateStudioComponentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStudioComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStudioComponent for more information on using the UpdateStudioComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStudioComponentRequest method.
//	req, resp := client.UpdateStudioComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudioComponent
func (c *NimbleStudio) UpdateStudioComponentRequest(input *UpdateStudioComponentInput) (req *request.Request, output *UpdateStudioComponentOutput) {
	op := &request.Operation{
		Name:       opUpdateStudioComponent,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}",
	}

	if input == nil {
		input = &UpdateStudioComponentInput{}
	}

	output = &UpdateStudioComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStudioComponent API operation for AmazonNimbleStudio.
//
// Updates a studio component resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonNimbleStudio's
// API operation UpdateStudioComponent for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConflictException
//     Another operation is in progress.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You are not authorized to perform this operation. Check your IAM policies,
//     and ensure that you are using the correct access keys.
//
//   - InternalServerErrorException
//     An internal error has occurred. Please retry your request.
//
//   - ServiceQuotaExceededException
//     Your current quota does not allow you to perform the request action. You
//     can request increases for some quotas, and other quotas cannot be increased.
//
//     Please use AWS Service Quotas to request an increase.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudioComponent
func (c *NimbleStudio) UpdateStudioComponent(input *UpdateStudioComponentInput) (*UpdateStudioComponentOutput, error) {
	req, out := c.UpdateStudioComponentRequest(input)
	return out, req.Send()
}

// UpdateStudioComponentWithContext is the same as UpdateStudioComponent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStudioComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NimbleStudio) UpdateStudioComponentWithContext(ctx aws.Context, input *UpdateStudioComponentInput, opts ...request.Option) (*UpdateStudioComponentOutput, error) {
	req, out := c.UpdateStudioComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptEulasInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The EULA ID.
	EulaIds []*string `locationName:"eulaIds" type:"list"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptEulasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptEulasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptEulasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptEulasInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AcceptEulasInput) SetClientToken(v string) *AcceptEulasInput {
	s.ClientToken = &v
	return s
}

// SetEulaIds sets the EulaIds field's value.
func (s *AcceptEulasInput) SetEulaIds(v []*string) *AcceptEulasInput {
	s.EulaIds = v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *AcceptEulasInput) SetStudioId(v string) *AcceptEulasInput {
	s.StudioId = &v
	return s
}

type AcceptEulasOutput struct {
	_ struct{} `type:"structure"`

	// A collection of EULA acceptances.
	EulaAcceptances []*EulaAcceptance `locationName:"eulaAcceptances" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptEulasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptEulasOutput) GoString() string {
	return s.String()
}

// SetEulaAcceptances sets the EulaAcceptances field's value.
func (s *AcceptEulasOutput) SetEulaAcceptances(v []*EulaAcceptance) *AcceptEulasOutput {
	s.EulaAcceptances = v
	return s
}

// You are not authorized to perform this operation. Check your IAM policies,
// and ensure that you are using the correct access keys.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A more specific error code.
	Code_ *string `locationName:"code" type:"string"`

	// The exception context.
	Context map[string]*string `locationName:"context" type:"map"`

	// A human-readable description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An LDAP attribute of an Active Directory computer account, in the form of
// a name:value pair.
type ActiveDirectoryComputerAttribute struct {
	_ struct{} `type:"structure"`

	// The name for the LDAP attribute.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The value for the LDAP attribute.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveDirectoryComputerAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveDirectoryComputerAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActiveDirectoryComputerAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActiveDirectoryComputerAttribute"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ActiveDirectoryComputerAttribute) SetName(v string) *ActiveDirectoryComputerAttribute {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ActiveDirectoryComputerAttribute) SetValue(v string) *ActiveDirectoryComputerAttribute {
	s.Value = &v
	return s
}

// The configuration for a Microsoft Active Directory (Microsoft AD) studio
// resource.
type ActiveDirectoryConfiguration struct {
	_ struct{} `type:"structure"`

	// A collection of custom attributes for an Active Directory computer.
	//
	// ComputerAttributes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActiveDirectoryConfiguration's
	// String and GoString methods.
	ComputerAttributes []*ActiveDirectoryComputerAttribute `locationName:"computerAttributes" type:"list" sensitive:"true"`

	// The directory ID of the Directory Service for Microsoft Active Directory
	// to access using this studio component.
	DirectoryId *string `locationName:"directoryId" type:"string"`

	// The distinguished name (DN) and organizational unit (OU) of an Active Directory
	// computer.
	OrganizationalUnitDistinguishedName *string `locationName:"organizationalUnitDistinguishedName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveDirectoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveDirectoryConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActiveDirectoryConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActiveDirectoryConfiguration"}
	if s.OrganizationalUnitDistinguishedName != nil && len(*s.OrganizationalUnitDistinguishedName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationalUnitDistinguishedName", 1))
	}
	if s.ComputerAttributes != nil {
		for i, v := range s.ComputerAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComputerAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputerAttributes sets the ComputerAttributes field's value.
func (s *ActiveDirectoryConfiguration) SetComputerAttributes(v []*ActiveDirectoryComputerAttribute) *ActiveDirectoryConfiguration {
	s.ComputerAttributes = v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ActiveDirectoryConfiguration) SetDirectoryId(v string) *ActiveDirectoryConfiguration {
	s.DirectoryId = &v
	return s
}

// SetOrganizationalUnitDistinguishedName sets the OrganizationalUnitDistinguishedName field's value.
func (s *ActiveDirectoryConfiguration) SetOrganizationalUnitDistinguishedName(v string) *ActiveDirectoryConfiguration {
	s.OrganizationalUnitDistinguishedName = &v
	return s
}

// The configuration for a render farm that is associated with a studio resource.
type ComputeFarmConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of an Active Directory user that is used on ComputeFarm worker instances.
	ActiveDirectoryUser *string `locationName:"activeDirectoryUser" type:"string"`

	// The endpoint of the ComputeFarm that is accessed by the studio component
	// resource.
	//
	// Endpoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ComputeFarmConfiguration's
	// String and GoString methods.
	Endpoint *string `locationName:"endpoint" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeFarmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeFarmConfiguration) GoString() string {
	return s.String()
}

// SetActiveDirectoryUser sets the ActiveDirectoryUser field's value.
func (s *ComputeFarmConfiguration) SetActiveDirectoryUser(v string) *ComputeFarmConfiguration {
	s.ActiveDirectoryUser = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *ComputeFarmConfiguration) SetEndpoint(v string) *ComputeFarmConfiguration {
	s.Endpoint = &v
	return s
}

// Another operation is in progress.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A more specific error code.
	Code_ *string `locationName:"code" type:"string"`

	// The exception context.
	Context map[string]*string `locationName:"context" type:"map"`

	// A human-readable description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateLaunchProfileInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateLaunchProfileInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// Specifies the IDs of the EC2 subnets where streaming sessions will be accessible
	// from. These subnets must support the specified instance types.
	//
	// Ec2SubnetIds is a required field
	Ec2SubnetIds []*string `locationName:"ec2SubnetIds" type:"list" required:"true"`

	// The version number of the protocol that is used by the launch profile. The
	// only valid version is "2021-03-31".
	//
	// LaunchProfileProtocolVersions is a required field
	LaunchProfileProtocolVersions []*string `locationName:"launchProfileProtocolVersions" type:"list" required:"true"`

	// The name for the launch profile.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateLaunchProfileInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// A configuration for a streaming session.
	//
	// StreamConfiguration is a required field
	StreamConfiguration *StreamConfigurationCreate `locationName:"streamConfiguration" type:"structure" required:"true"`

	// Unique identifiers for a collection of studio components that can be used
	// with this launch profile.
	//
	// StudioComponentIds is a required field
	StudioComponentIds []*string `locationName:"studioComponentIds" min:"1" type:"list" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLaunchProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLaunchProfileInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Ec2SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("Ec2SubnetIds"))
	}
	if s.LaunchProfileProtocolVersions == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileProtocolVersions"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StreamConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamConfiguration"))
	}
	if s.StudioComponentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioComponentIds"))
	}
	if s.StudioComponentIds != nil && len(s.StudioComponentIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioComponentIds", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}
	if s.StreamConfiguration != nil {
		if err := s.StreamConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StreamConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateLaunchProfileInput) SetClientToken(v string) *CreateLaunchProfileInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateLaunchProfileInput) SetDescription(v string) *CreateLaunchProfileInput {
	s.Description = &v
	return s
}

// SetEc2SubnetIds sets the Ec2SubnetIds field's value.
func (s *CreateLaunchProfileInput) SetEc2SubnetIds(v []*string) *CreateLaunchProfileInput {
	s.Ec2SubnetIds = v
	return s
}

// SetLaunchProfileProtocolVersions sets the LaunchProfileProtocolVersions field's value.
func (s *CreateLaunchProfileInput) SetLaunchProfileProtocolVersions(v []*string) *CreateLaunchProfileInput {
	s.LaunchProfileProtocolVersions = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLaunchProfileInput) SetName(v string) *CreateLaunchProfileInput {
	s.Name = &v
	return s
}

// SetStreamConfiguration sets the StreamConfiguration field's value.
func (s *CreateLaunchProfileInput) SetStreamConfiguration(v *StreamConfigurationCreate) *CreateLaunchProfileInput {
	s.StreamConfiguration = v
	return s
}

// SetStudioComponentIds sets the StudioComponentIds field's value.
func (s *CreateLaunchProfileInput) SetStudioComponentIds(v []*string) *CreateLaunchProfileInput {
	s.StudioComponentIds = v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *CreateLaunchProfileInput) SetStudioId(v string) *CreateLaunchProfileInput {
	s.StudioId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLaunchProfileInput) SetTags(v map[string]*string) *CreateLaunchProfileInput {
	s.Tags = v
	return s
}

type CreateLaunchProfileOutput struct {
	_ struct{} `type:"structure"`

	// The launch profile.
	LaunchProfile *LaunchProfile `locationName:"launchProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchProfileOutput) GoString() string {
	return s.String()
}

// SetLaunchProfile sets the LaunchProfile field's value.
func (s *CreateLaunchProfileOutput) SetLaunchProfile(v *LaunchProfile) *CreateLaunchProfileOutput {
	s.LaunchProfile = v
	return s
}

type CreateStreamingImageInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// A human-readable description of the streaming image.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateStreamingImageInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of an EC2 machine image with which to create this streaming image.
	//
	// Ec2ImageId is a required field
	Ec2ImageId *string `locationName:"ec2ImageId" type:"string" required:"true"`

	// A friendly name for a streaming image resource.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateStreamingImageInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" sensitive:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingImageInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Ec2ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("Ec2ImageId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateStreamingImageInput) SetClientToken(v string) *CreateStreamingImageInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStreamingImageInput) SetDescription(v string) *CreateStreamingImageInput {
	s.Description = &v
	return s
}

// SetEc2ImageId sets the Ec2ImageId field's value.
func (s *CreateStreamingImageInput) SetEc2ImageId(v string) *CreateStreamingImageInput {
	s.Ec2ImageId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStreamingImageInput) SetName(v string) *CreateStreamingImageInput {
	s.Name = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *CreateStreamingImageInput) SetStudioId(v string) *CreateStreamingImageInput {
	s.StudioId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStreamingImageInput) SetTags(v map[string]*string) *CreateStreamingImageInput {
	s.Tags = v
	return s
}

type CreateStreamingImageOutput struct {
	_ struct{} `type:"structure"`

	// The streaming image.
	StreamingImage *StreamingImage `locationName:"streamingImage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingImageOutput) GoString() string {
	return s.String()
}

// SetStreamingImage sets the StreamingImage field's value.
func (s *CreateStreamingImageOutput) SetStreamingImage(v *StreamingImage) *CreateStreamingImageOutput {
	s.StreamingImage = v
	return s
}

type CreateStreamingSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The EC2 Instance type used for the streaming session.
	Ec2InstanceType *string `locationName:"ec2InstanceType" type:"string" enum:"StreamingInstanceType"`

	// The launch profile ID.
	LaunchProfileId *string `locationName:"launchProfileId" type:"string"`

	// The user ID of the user that owns the streaming session. The user that owns
	// the session will be logging into the session and interacting with the virtual
	// workstation.
	OwnedBy *string `locationName:"ownedBy" type:"string"`

	// The ID of the streaming image.
	StreamingImageId *string `locationName:"streamingImageId" type:"string"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingSessionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateStreamingSessionInput) SetClientToken(v string) *CreateStreamingSessionInput {
	s.ClientToken = &v
	return s
}

// SetEc2InstanceType sets the Ec2InstanceType field's value.
func (s *CreateStreamingSessionInput) SetEc2InstanceType(v string) *CreateStreamingSessionInput {
	s.Ec2InstanceType = &v
	return s
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *CreateStreamingSessionInput) SetLaunchProfileId(v string) *CreateStreamingSessionInput {
	s.LaunchProfileId = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *CreateStreamingSessionInput) SetOwnedBy(v string) *CreateStreamingSessionInput {
	s.OwnedBy = &v
	return s
}

// SetStreamingImageId sets the StreamingImageId field's value.
func (s *CreateStreamingSessionInput) SetStreamingImageId(v string) *CreateStreamingSessionInput {
	s.StreamingImageId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *CreateStreamingSessionInput) SetStudioId(v string) *CreateStreamingSessionInput {
	s.StudioId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStreamingSessionInput) SetTags(v map[string]*string) *CreateStreamingSessionInput {
	s.Tags = v
	return s
}

type CreateStreamingSessionOutput struct {
	_ struct{} `type:"structure"`

	// The session.
	Session *StreamingSession `locationName:"session" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingSessionOutput) GoString() string {
	return s.String()
}

// SetSession sets the Session field's value.
func (s *CreateStreamingSessionOutput) SetSession(v *StreamingSession) *CreateStreamingSessionOutput {
	s.Session = v
	return s
}

type CreateStreamingSessionStreamInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The expiration time in seconds.
	ExpirationInSeconds *int64 `locationName:"expirationInSeconds" min:"60" type:"integer"`

	// The streaming session ID.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingSessionStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingSessionStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingSessionStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingSessionStreamInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ExpirationInSeconds != nil && *s.ExpirationInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("ExpirationInSeconds", 60))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateStreamingSessionStreamInput) SetClientToken(v string) *CreateStreamingSessionStreamInput {
	s.ClientToken = &v
	return s
}

// SetExpirationInSeconds sets the ExpirationInSeconds field's value.
func (s *CreateStreamingSessionStreamInput) SetExpirationInSeconds(v int64) *CreateStreamingSessionStreamInput {
	s.ExpirationInSeconds = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *CreateStreamingSessionStreamInput) SetSessionId(v string) *CreateStreamingSessionStreamInput {
	s.SessionId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *CreateStreamingSessionStreamInput) SetStudioId(v string) *CreateStreamingSessionStreamInput {
	s.StudioId = &v
	return s
}

type CreateStreamingSessionStreamOutput struct {
	_ struct{} `type:"structure"`

	// The stream.
	Stream *StreamingSessionStream `locationName:"stream" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingSessionStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamingSessionStreamOutput) GoString() string {
	return s.String()
}

// SetStream sets the Stream field's value.
func (s *CreateStreamingSessionStreamOutput) SetStream(v *StreamingSessionStream) *CreateStreamingSessionStreamOutput {
	s.Stream = v
	return s
}

type CreateStudioComponentInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The configuration of the studio component, based on component type.
	Configuration *StudioComponentConfiguration `locationName:"configuration" type:"structure"`

	// The description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateStudioComponentInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The EC2 security groups that control access to the studio component.
	Ec2SecurityGroupIds []*string `locationName:"ec2SecurityGroupIds" type:"list"`

	// Initialization scripts for studio components.
	InitializationScripts []*StudioComponentInitializationScript `locationName:"initializationScripts" type:"list"`

	// The name for the studio component.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateStudioComponentInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" sensitive:"true"`

	// An IAM role attached to a Studio Component that gives the studio component
	// access to AWS resources at anytime while the instance is running.
	RuntimeRoleArn *string `locationName:"runtimeRoleArn" type:"string"`

	// Parameters for the studio component scripts.
	//
	// ScriptParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateStudioComponentInput's
	// String and GoString methods.
	ScriptParameters []*ScriptParameterKeyValue `locationName:"scriptParameters" type:"list" sensitive:"true"`

	// An IAM role attached to Studio Component when the system initialization script
	// runs which give the studio component access to AWS resources when the system
	// initialization script runs.
	SecureInitializationRoleArn *string `locationName:"secureInitializationRoleArn" type:"string"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`

	// The specific subtype of a studio component.
	Subtype *string `locationName:"subtype" type:"string" enum:"StudioComponentSubtype"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of the studio component.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"StudioComponentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStudioComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStudioComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStudioComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStudioComponentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.InitializationScripts != nil {
		for i, v := range s.InitializationScripts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InitializationScripts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScriptParameters != nil {
		for i, v := range s.ScriptParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScriptParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateStudioComponentInput) SetClientToken(v string) *CreateStudioComponentInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateStudioComponentInput) SetConfiguration(v *StudioComponentConfiguration) *CreateStudioComponentInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStudioComponentInput) SetDescription(v string) *CreateStudioComponentInput {
	s.Description = &v
	return s
}

// SetEc2SecurityGroupIds sets the Ec2SecurityGroupIds field's value.
func (s *CreateStudioComponentInput) SetEc2SecurityGroupIds(v []*string) *CreateStudioComponentInput {
	s.Ec2SecurityGroupIds = v
	return s
}

// SetInitializationScripts sets the InitializationScripts field's value.
func (s *CreateStudioComponentInput) SetInitializationScripts(v []*StudioComponentInitializationScript) *CreateStudioComponentInput {
	s.InitializationScripts = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStudioComponentInput) SetName(v string) *CreateStudioComponentInput {
	s.Name = &v
	return s
}

// SetRuntimeRoleArn sets the RuntimeRoleArn field's value.
func (s *CreateStudioComponentInput) SetRuntimeRoleArn(v string) *CreateStudioComponentInput {
	s.RuntimeRoleArn = &v
	return s
}

// SetScriptParameters sets the ScriptParameters field's value.
func (s *CreateStudioComponentInput) SetScriptParameters(v []*ScriptParameterKeyValue) *CreateStudioComponentInput {
	s.ScriptParameters = v
	return s
}

// SetSecureInitializationRoleArn sets the SecureInitializationRoleArn field's value.
func (s *CreateStudioComponentInput) SetSecureInitializationRoleArn(v string) *CreateStudioComponentInput {
	s.SecureInitializationRoleArn = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *CreateStudioComponentInput) SetStudioId(v string) *CreateStudioComponentInput {
	s.StudioId = &v
	return s
}

// SetSubtype sets the Subtype field's value.
func (s *CreateStudioComponentInput) SetSubtype(v string) *CreateStudioComponentInput {
	s.Subtype = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStudioComponentInput) SetTags(v map[string]*string) *CreateStudioComponentInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateStudioComponentInput) SetType(v string) *CreateStudioComponentInput {
	s.Type = &v
	return s
}

type CreateStudioComponentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the studio component.
	StudioComponent *StudioComponent `locationName:"studioComponent" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStudioComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStudioComponentOutput) GoString() string {
	return s.String()
}

// SetStudioComponent sets the StudioComponent field's value.
func (s *CreateStudioComponentOutput) SetStudioComponent(v *StudioComponent) *CreateStudioComponentOutput {
	s.StudioComponent = v
	return s
}

type CreateStudioInput struct {
	_ struct{} `type:"structure"`

	// The IAM role that Studio Admins will assume when logging in to the Nimble
	// Studio portal.
	//
	// AdminRoleArn is a required field
	AdminRoleArn *string `locationName:"adminRoleArn" type:"string" required:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// A friendly name for the studio.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateStudioInput's
	// String and GoString methods.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" type:"string" required:"true" sensitive:"true"`

	// The studio encryption configuration.
	StudioEncryptionConfiguration *StudioEncryptionConfiguration `locationName:"studioEncryptionConfiguration" type:"structure"`

	// The studio name that is used in the URL of the Nimble Studio portal when
	// accessed by Nimble Studio users.
	//
	// StudioName is a required field
	StudioName *string `locationName:"studioName" min:"3" type:"string" required:"true"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The IAM role that Studio Users will assume when logging in to the Nimble
	// Studio portal.
	//
	// UserRoleArn is a required field
	UserRoleArn *string `locationName:"userRoleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStudioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStudioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStudioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStudioInput"}
	if s.AdminRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminRoleArn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.StudioName == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioName"))
	}
	if s.StudioName != nil && len(*s.StudioName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("StudioName", 3))
	}
	if s.UserRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRoleArn"))
	}
	if s.StudioEncryptionConfiguration != nil {
		if err := s.StudioEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StudioEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminRoleArn sets the AdminRoleArn field's value.
func (s *CreateStudioInput) SetAdminRoleArn(v string) *CreateStudioInput {
	s.AdminRoleArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateStudioInput) SetClientToken(v string) *CreateStudioInput {
	s.ClientToken = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateStudioInput) SetDisplayName(v string) *CreateStudioInput {
	s.DisplayName = &v
	return s
}

// SetStudioEncryptionConfiguration sets the StudioEncryptionConfiguration field's value.
func (s *CreateStudioInput) SetStudioEncryptionConfiguration(v *StudioEncryptionConfiguration) *CreateStudioInput {
	s.StudioEncryptionConfiguration = v
	return s
}

// SetStudioName sets the StudioName field's value.
func (s *CreateStudioInput) SetStudioName(v string) *CreateStudioInput {
	s.StudioName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStudioInput) SetTags(v map[string]*string) *CreateStudioInput {
	s.Tags = v
	return s
}

// SetUserRoleArn sets the UserRoleArn field's value.
func (s *CreateStudioInput) SetUserRoleArn(v string) *CreateStudioInput {
	s.UserRoleArn = &v
	return s
}

type CreateStudioOutput struct {
	_ struct{} `type:"structure"`

	// Information about a studio.
	Studio *Studio `locationName:"studio" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStudioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStudioOutput) GoString() string {
	return s.String()
}

// SetStudio sets the Studio field's value.
func (s *CreateStudioOutput) SetStudio(v *Studio) *CreateStudioOutput {
	s.Studio = v
	return s
}

type DeleteLaunchProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLaunchProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLaunchProfileInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteLaunchProfileInput) SetClientToken(v string) *DeleteLaunchProfileInput {
	s.ClientToken = &v
	return s
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *DeleteLaunchProfileInput) SetLaunchProfileId(v string) *DeleteLaunchProfileInput {
	s.LaunchProfileId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *DeleteLaunchProfileInput) SetStudioId(v string) *DeleteLaunchProfileInput {
	s.StudioId = &v
	return s
}

type DeleteLaunchProfileMemberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// The principal ID. This currently supports a IAM Identity Center UserId.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchProfileMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchProfileMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLaunchProfileMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLaunchProfileMemberInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteLaunchProfileMemberInput) SetClientToken(v string) *DeleteLaunchProfileMemberInput {
	s.ClientToken = &v
	return s
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *DeleteLaunchProfileMemberInput) SetLaunchProfileId(v string) *DeleteLaunchProfileMemberInput {
	s.LaunchProfileId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DeleteLaunchProfileMemberInput) SetPrincipalId(v string) *DeleteLaunchProfileMemberInput {
	s.PrincipalId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *DeleteLaunchProfileMemberInput) SetStudioId(v string) *DeleteLaunchProfileMemberInput {
	s.StudioId = &v
	return s
}

type DeleteLaunchProfileMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchProfileMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchProfileMemberOutput) GoString() string {
	return s.String()
}

type DeleteLaunchProfileOutput struct {
	_ struct{} `type:"structure"`

	// The launch profile.
	LaunchProfile *LaunchProfile `locationName:"launchProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchProfileOutput) GoString() string {
	return s.String()
}

// SetLaunchProfile sets the LaunchProfile field's value.
func (s *DeleteLaunchProfileOutput) SetLaunchProfile(v *LaunchProfile) *DeleteLaunchProfileOutput {
	s.LaunchProfile = v
	return s
}

type DeleteStreamingImageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The streaming image ID.
	//
	// StreamingImageId is a required field
	StreamingImageId *string `location:"uri" locationName:"streamingImageId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamingImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamingImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamingImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamingImageInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.StreamingImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingImageId"))
	}
	if s.StreamingImageId != nil && len(*s.StreamingImageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamingImageId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteStreamingImageInput) SetClientToken(v string) *DeleteStreamingImageInput {
	s.ClientToken = &v
	return s
}

// SetStreamingImageId sets the StreamingImageId field's value.
func (s *DeleteStreamingImageInput) SetStreamingImageId(v string) *DeleteStreamingImageInput {
	s.StreamingImageId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *DeleteStreamingImageInput) SetStudioId(v string) *DeleteStreamingImageInput {
	s.StudioId = &v
	return s
}

type DeleteStreamingImageOutput struct {
	_ struct{} `type:"structure"`

	// The streaming image.
	StreamingImage *StreamingImage `locationName:"streamingImage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamingImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamingImageOutput) GoString() string {
	return s.String()
}

// SetStreamingImage sets the StreamingImage field's value.
func (s *DeleteStreamingImageOutput) SetStreamingImage(v *StreamingImage) *DeleteStreamingImageOutput {
	s.StreamingImage = v
	return s
}

type DeleteStreamingSessionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The streaming session ID.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamingSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamingSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamingSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamingSessionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteStreamingSessionInput) SetClientToken(v string) *DeleteStreamingSessionInput {
	s.ClientToken = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *DeleteStreamingSessionInput) SetSessionId(v string) *DeleteStreamingSessionInput {
	s.SessionId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *DeleteStreamingSessionInput) SetStudioId(v string) *DeleteStreamingSessionInput {
	s.StudioId = &v
	return s
}

type DeleteStreamingSessionOutput struct {
	_ struct{} `type:"structure"`

	// The session.
	Session *StreamingSession `locationName:"session" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamingSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamingSessionOutput) GoString() string {
	return s.String()
}

// SetSession sets the Session field's value.
func (s *DeleteStreamingSessionOutput) SetSession(v *StreamingSession) *DeleteStreamingSessionOutput {
	s.Session = v
	return s
}

type DeleteStudioComponentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The studio component ID.
	//
	// StudioComponentId is a required field
	StudioComponentId *string `location:"uri" locationName:"studioComponentId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStudioComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStudioComponentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.StudioComponentId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioComponentId"))
	}
	if s.StudioComponentId != nil && len(*s.StudioComponentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioComponentId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteStudioComponentInput) SetClientToken(v string) *DeleteStudioComponentInput {
	s.ClientToken = &v
	return s
}

// SetStudioComponentId sets the StudioComponentId field's value.
func (s *DeleteStudioComponentInput) SetStudioComponentId(v string) *DeleteStudioComponentInput {
	s.StudioComponentId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *DeleteStudioComponentInput) SetStudioId(v string) *DeleteStudioComponentInput {
	s.StudioId = &v
	return s
}

type DeleteStudioComponentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the studio component.
	StudioComponent *StudioComponent `locationName:"studioComponent" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioComponentOutput) GoString() string {
	return s.String()
}

// SetStudioComponent sets the StudioComponent field's value.
func (s *DeleteStudioComponentOutput) SetStudioComponent(v *StudioComponent) *DeleteStudioComponentOutput {
	s.StudioComponent = v
	return s
}

type DeleteStudioInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStudioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStudioInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteStudioInput) SetClientToken(v string) *DeleteStudioInput {
	s.ClientToken = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *DeleteStudioInput) SetStudioId(v string) *DeleteStudioInput {
	s.StudioId = &v
	return s
}

type DeleteStudioMemberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The principal ID. This currently supports a IAM Identity Center UserId.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStudioMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStudioMemberInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteStudioMemberInput) SetClientToken(v string) *DeleteStudioMemberInput {
	s.ClientToken = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DeleteStudioMemberInput) SetPrincipalId(v string) *DeleteStudioMemberInput {
	s.PrincipalId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *DeleteStudioMemberInput) SetStudioId(v string) *DeleteStudioMemberInput {
	s.StudioId = &v
	return s
}

type DeleteStudioMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioMemberOutput) GoString() string {
	return s.String()
}

type DeleteStudioOutput struct {
	_ struct{} `type:"structure"`

	// Information about a studio.
	//
	// Studio is a required field
	Studio *Studio `locationName:"studio" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStudioOutput) GoString() string {
	return s.String()
}

// SetStudio sets the Studio field's value.
func (s *DeleteStudioOutput) SetStudio(v *Studio) *DeleteStudioOutput {
	s.Studio = v
	return s
}

// Represents a EULA resource.
type Eula struct {
	_ struct{} `type:"structure"`

	// The EULA content.
	Content *string `locationName:"content" type:"string"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The EULA ID.
	EulaId *string `locationName:"eulaId" type:"string"`

	// The name for the EULA.
	Name *string `locationName:"name" type:"string"`

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Eula) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Eula) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *Eula) SetContent(v string) *Eula {
	s.Content = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Eula) SetCreatedAt(v time.Time) *Eula {
	s.CreatedAt = &v
	return s
}

// SetEulaId sets the EulaId field's value.
func (s *Eula) SetEulaId(v string) *Eula {
	s.EulaId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Eula) SetName(v string) *Eula {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Eula) SetUpdatedAt(v time.Time) *Eula {
	s.UpdatedAt = &v
	return s
}

// The acceptance of a EULA, required to use Amazon-provided streaming images.
type EulaAcceptance struct {
	_ struct{} `type:"structure"`

	// The Unix epoch timestamp in seconds for when the EULA was accepted.
	AcceptedAt *time.Time `locationName:"acceptedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the person who accepted the EULA.
	AcceptedBy *string `locationName:"acceptedBy" type:"string"`

	// The ID of the acceptee.
	AccepteeId *string `locationName:"accepteeId" type:"string"`

	// The EULA acceptance ID.
	EulaAcceptanceId *string `locationName:"eulaAcceptanceId" type:"string"`

	// The EULA ID.
	EulaId *string `locationName:"eulaId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EulaAcceptance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EulaAcceptance) GoString() string {
	return s.String()
}

// SetAcceptedAt sets the AcceptedAt field's value.
func (s *EulaAcceptance) SetAcceptedAt(v time.Time) *EulaAcceptance {
	s.AcceptedAt = &v
	return s
}

// SetAcceptedBy sets the AcceptedBy field's value.
func (s *EulaAcceptance) SetAcceptedBy(v string) *EulaAcceptance {
	s.AcceptedBy = &v
	return s
}

// SetAccepteeId sets the AccepteeId field's value.
func (s *EulaAcceptance) SetAccepteeId(v string) *EulaAcceptance {
	s.AccepteeId = &v
	return s
}

// SetEulaAcceptanceId sets the EulaAcceptanceId field's value.
func (s *EulaAcceptance) SetEulaAcceptanceId(v string) *EulaAcceptance {
	s.EulaAcceptanceId = &v
	return s
}

// SetEulaId sets the EulaId field's value.
func (s *EulaAcceptance) SetEulaId(v string) *EulaAcceptance {
	s.EulaId = &v
	return s
}

type GetEulaInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The EULA ID.
	//
	// EulaId is a required field
	EulaId *string `location:"uri" locationName:"eulaId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEulaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEulaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEulaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEulaInput"}
	if s.EulaId == nil {
		invalidParams.Add(request.NewErrParamRequired("EulaId"))
	}
	if s.EulaId != nil && len(*s.EulaId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EulaId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEulaId sets the EulaId field's value.
func (s *GetEulaInput) SetEulaId(v string) *GetEulaInput {
	s.EulaId = &v
	return s
}

type GetEulaOutput struct {
	_ struct{} `type:"structure"`

	// The EULA.
	Eula *Eula `locationName:"eula" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEulaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEulaOutput) GoString() string {
	return s.String()
}

// SetEula sets the Eula field's value.
func (s *GetEulaOutput) SetEula(v *Eula) *GetEulaOutput {
	s.Eula = v
	return s
}

type GetLaunchProfileDetailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLaunchProfileDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLaunchProfileDetailsInput"}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *GetLaunchProfileDetailsInput) SetLaunchProfileId(v string) *GetLaunchProfileDetailsInput {
	s.LaunchProfileId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetLaunchProfileDetailsInput) SetStudioId(v string) *GetLaunchProfileDetailsInput {
	s.StudioId = &v
	return s
}

type GetLaunchProfileDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The launch profile.
	LaunchProfile *LaunchProfile `locationName:"launchProfile" type:"structure"`

	// A collection of streaming images.
	StreamingImages []*StreamingImage `locationName:"streamingImages" type:"list"`

	// A collection of studio component summaries.
	StudioComponentSummaries []*StudioComponentSummary `locationName:"studioComponentSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileDetailsOutput) GoString() string {
	return s.String()
}

// SetLaunchProfile sets the LaunchProfile field's value.
func (s *GetLaunchProfileDetailsOutput) SetLaunchProfile(v *LaunchProfile) *GetLaunchProfileDetailsOutput {
	s.LaunchProfile = v
	return s
}

// SetStreamingImages sets the StreamingImages field's value.
func (s *GetLaunchProfileDetailsOutput) SetStreamingImages(v []*StreamingImage) *GetLaunchProfileDetailsOutput {
	s.StreamingImages = v
	return s
}

// SetStudioComponentSummaries sets the StudioComponentSummaries field's value.
func (s *GetLaunchProfileDetailsOutput) SetStudioComponentSummaries(v []*StudioComponentSummary) *GetLaunchProfileDetailsOutput {
	s.StudioComponentSummaries = v
	return s
}

type GetLaunchProfileInitializationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// The launch profile protocol versions supported by the client.
	//
	// LaunchProfileProtocolVersions is a required field
	LaunchProfileProtocolVersions []*string `location:"querystring" locationName:"launchProfileProtocolVersions" type:"list" required:"true"`

	// The launch purpose.
	//
	// LaunchPurpose is a required field
	LaunchPurpose *string `location:"querystring" locationName:"launchPurpose" type:"string" required:"true"`

	// The platform where this Launch Profile will be used, either WINDOWS or LINUX.
	//
	// Platform is a required field
	Platform *string `location:"querystring" locationName:"platform" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileInitializationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileInitializationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLaunchProfileInitializationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLaunchProfileInitializationInput"}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.LaunchProfileProtocolVersions == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileProtocolVersions"))
	}
	if s.LaunchPurpose == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchPurpose"))
	}
	if s.Platform == nil {
		invalidParams.Add(request.NewErrParamRequired("Platform"))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *GetLaunchProfileInitializationInput) SetLaunchProfileId(v string) *GetLaunchProfileInitializationInput {
	s.LaunchProfileId = &v
	return s
}

// SetLaunchProfileProtocolVersions sets the LaunchProfileProtocolVersions field's value.
func (s *GetLaunchProfileInitializationInput) SetLaunchProfileProtocolVersions(v []*string) *GetLaunchProfileInitializationInput {
	s.LaunchProfileProtocolVersions = v
	return s
}

// SetLaunchPurpose sets the LaunchPurpose field's value.
func (s *GetLaunchProfileInitializationInput) SetLaunchPurpose(v string) *GetLaunchProfileInitializationInput {
	s.LaunchPurpose = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *GetLaunchProfileInitializationInput) SetPlatform(v string) *GetLaunchProfileInitializationInput {
	s.Platform = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetLaunchProfileInitializationInput) SetStudioId(v string) *GetLaunchProfileInitializationInput {
	s.StudioId = &v
	return s
}

type GetLaunchProfileInitializationOutput struct {
	_ struct{} `type:"structure"`

	// The launch profile initialization.
	LaunchProfileInitialization *LaunchProfileInitialization `locationName:"launchProfileInitialization" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileInitializationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileInitializationOutput) GoString() string {
	return s.String()
}

// SetLaunchProfileInitialization sets the LaunchProfileInitialization field's value.
func (s *GetLaunchProfileInitializationOutput) SetLaunchProfileInitialization(v *LaunchProfileInitialization) *GetLaunchProfileInitializationOutput {
	s.LaunchProfileInitialization = v
	return s
}

type GetLaunchProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLaunchProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLaunchProfileInput"}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *GetLaunchProfileInput) SetLaunchProfileId(v string) *GetLaunchProfileInput {
	s.LaunchProfileId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetLaunchProfileInput) SetStudioId(v string) *GetLaunchProfileInput {
	s.StudioId = &v
	return s
}

type GetLaunchProfileMemberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// The principal ID. This currently supports a IAM Identity Center UserId.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLaunchProfileMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLaunchProfileMemberInput"}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *GetLaunchProfileMemberInput) SetLaunchProfileId(v string) *GetLaunchProfileMemberInput {
	s.LaunchProfileId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *GetLaunchProfileMemberInput) SetPrincipalId(v string) *GetLaunchProfileMemberInput {
	s.PrincipalId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetLaunchProfileMemberInput) SetStudioId(v string) *GetLaunchProfileMemberInput {
	s.StudioId = &v
	return s
}

type GetLaunchProfileMemberOutput struct {
	_ struct{} `type:"structure"`

	// The member.
	Member *LaunchProfileMembership `locationName:"member" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileMemberOutput) GoString() string {
	return s.String()
}

// SetMember sets the Member field's value.
func (s *GetLaunchProfileMemberOutput) SetMember(v *LaunchProfileMembership) *GetLaunchProfileMemberOutput {
	s.Member = v
	return s
}

type GetLaunchProfileOutput struct {
	_ struct{} `type:"structure"`

	// The launch profile.
	LaunchProfile *LaunchProfile `locationName:"launchProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchProfileOutput) GoString() string {
	return s.String()
}

// SetLaunchProfile sets the LaunchProfile field's value.
func (s *GetLaunchProfileOutput) SetLaunchProfile(v *LaunchProfile) *GetLaunchProfileOutput {
	s.LaunchProfile = v
	return s
}

type GetStreamingImageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The streaming image ID.
	//
	// StreamingImageId is a required field
	StreamingImageId *string `location:"uri" locationName:"streamingImageId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamingImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamingImageInput"}
	if s.StreamingImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingImageId"))
	}
	if s.StreamingImageId != nil && len(*s.StreamingImageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamingImageId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingImageId sets the StreamingImageId field's value.
func (s *GetStreamingImageInput) SetStreamingImageId(v string) *GetStreamingImageInput {
	s.StreamingImageId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetStreamingImageInput) SetStudioId(v string) *GetStreamingImageInput {
	s.StudioId = &v
	return s
}

type GetStreamingImageOutput struct {
	_ struct{} `type:"structure"`

	// The streaming image.
	StreamingImage *StreamingImage `locationName:"streamingImage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingImageOutput) GoString() string {
	return s.String()
}

// SetStreamingImage sets the StreamingImage field's value.
func (s *GetStreamingImageOutput) SetStreamingImage(v *StreamingImage) *GetStreamingImageOutput {
	s.StreamingImage = v
	return s
}

type GetStreamingSessionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The streaming session ID.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamingSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamingSessionInput"}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSessionId sets the SessionId field's value.
func (s *GetStreamingSessionInput) SetSessionId(v string) *GetStreamingSessionInput {
	s.SessionId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetStreamingSessionInput) SetStudioId(v string) *GetStreamingSessionInput {
	s.StudioId = &v
	return s
}

type GetStreamingSessionOutput struct {
	_ struct{} `type:"structure"`

	// The session.
	Session *StreamingSession `locationName:"session" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingSessionOutput) GoString() string {
	return s.String()
}

// SetSession sets the Session field's value.
func (s *GetStreamingSessionOutput) SetSession(v *StreamingSession) *GetStreamingSessionOutput {
	s.Session = v
	return s
}

type GetStreamingSessionStreamInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The streaming session ID.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`

	// The streaming session stream ID.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingSessionStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingSessionStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamingSessionStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamingSessionStreamInput"}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}
	if s.StreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSessionId sets the SessionId field's value.
func (s *GetStreamingSessionStreamInput) SetSessionId(v string) *GetStreamingSessionStreamInput {
	s.SessionId = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *GetStreamingSessionStreamInput) SetStreamId(v string) *GetStreamingSessionStreamInput {
	s.StreamId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetStreamingSessionStreamInput) SetStudioId(v string) *GetStreamingSessionStreamInput {
	s.StudioId = &v
	return s
}

type GetStreamingSessionStreamOutput struct {
	_ struct{} `type:"structure"`

	// The stream.
	Stream *StreamingSessionStream `locationName:"stream" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingSessionStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStreamingSessionStreamOutput) GoString() string {
	return s.String()
}

// SetStream sets the Stream field's value.
func (s *GetStreamingSessionStreamOutput) SetStream(v *StreamingSessionStream) *GetStreamingSessionStreamOutput {
	s.Stream = v
	return s
}

type GetStudioComponentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The studio component ID.
	//
	// StudioComponentId is a required field
	StudioComponentId *string `location:"uri" locationName:"studioComponentId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStudioComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStudioComponentInput"}
	if s.StudioComponentId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioComponentId"))
	}
	if s.StudioComponentId != nil && len(*s.StudioComponentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioComponentId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStudioComponentId sets the StudioComponentId field's value.
func (s *GetStudioComponentInput) SetStudioComponentId(v string) *GetStudioComponentInput {
	s.StudioComponentId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetStudioComponentInput) SetStudioId(v string) *GetStudioComponentInput {
	s.StudioId = &v
	return s
}

type GetStudioComponentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the studio component.
	StudioComponent *StudioComponent `locationName:"studioComponent" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioComponentOutput) GoString() string {
	return s.String()
}

// SetStudioComponent sets the StudioComponent field's value.
func (s *GetStudioComponentOutput) SetStudioComponent(v *StudioComponent) *GetStudioComponentOutput {
	s.StudioComponent = v
	return s
}

type GetStudioInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStudioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStudioInput"}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStudioId sets the StudioId field's value.
func (s *GetStudioInput) SetStudioId(v string) *GetStudioInput {
	s.StudioId = &v
	return s
}

type GetStudioMemberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The principal ID. This currently supports a IAM Identity Center UserId.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStudioMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStudioMemberInput"}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *GetStudioMemberInput) SetPrincipalId(v string) *GetStudioMemberInput {
	s.PrincipalId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetStudioMemberInput) SetStudioId(v string) *GetStudioMemberInput {
	s.StudioId = &v
	return s
}

type GetStudioMemberOutput struct {
	_ struct{} `type:"structure"`

	// The member.
	Member *StudioMembership `locationName:"member" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioMemberOutput) GoString() string {
	return s.String()
}

// SetMember sets the Member field's value.
func (s *GetStudioMemberOutput) SetMember(v *StudioMembership) *GetStudioMemberOutput {
	s.Member = v
	return s
}

type GetStudioOutput struct {
	_ struct{} `type:"structure"`

	// Information about a studio.
	//
	// Studio is a required field
	Studio *Studio `locationName:"studio" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStudioOutput) GoString() string {
	return s.String()
}

// SetStudio sets the Studio field's value.
func (s *GetStudioOutput) SetStudio(v *Studio) *GetStudioOutput {
	s.Studio = v
	return s
}

// An internal error has occurred. Please retry your request.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A more specific error code.
	Code_ *string `locationName:"code" type:"string"`

	// The exception context.
	Context map[string]*string `locationName:"context" type:"map"`

	// A human-readable description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A launch profile controls your artist workforce’s access to studio components,
// like compute farms, shared file systems, managed file systems, and license
// server configurations, as well as instance types and Amazon Machine Images
// (AMIs).
//
//	<p>Studio administrators create launch profiles in the Nimble Studio console.
//	Artists can use their launch profiles to launch an instance from the Nimble
//	Studio portal. Each user’s launch profile defines how they can launch
//	a streaming session. By default, studio admins can use all launch profiles.</p>
type LaunchProfile struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that created the launch profile.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// A human-readable description of the launch profile.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LaunchProfile's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// Unique identifiers for a collection of EC2 subnets.
	Ec2SubnetIds []*string `locationName:"ec2SubnetIds" type:"list"`

	// The launch profile ID.
	LaunchProfileId *string `locationName:"launchProfileId" type:"string"`

	// The version number of the protocol that is used by the launch profile. The
	// only valid version is "2021-03-31".
	LaunchProfileProtocolVersions []*string `locationName:"launchProfileProtocolVersions" type:"list"`

	// A friendly name for the launch profile.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LaunchProfile's
	// String and GoString methods.
	Name *string `locationName:"name" min:"1" type:"string" sensitive:"true"`

	// The current state.
	State *string `locationName:"state" type:"string" enum:"LaunchProfileState"`

	// The status code.
	StatusCode *string `locationName:"statusCode" type:"string" enum:"LaunchProfileStatusCode"`

	// The status message for the launch profile.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// A configuration for a streaming session.
	StreamConfiguration *StreamConfiguration `locationName:"streamConfiguration" type:"structure"`

	// Unique identifiers for a collection of studio components that can be used
	// with this launch profile.
	StudioComponentIds []*string `locationName:"studioComponentIds" min:"1" type:"list"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that most recently updated the resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The list of the latest validation results.
	ValidationResults []*ValidationResult `locationName:"validationResults" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *LaunchProfile) SetArn(v string) *LaunchProfile {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LaunchProfile) SetCreatedAt(v time.Time) *LaunchProfile {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *LaunchProfile) SetCreatedBy(v string) *LaunchProfile {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *LaunchProfile) SetDescription(v string) *LaunchProfile {
	s.Description = &v
	return s
}

// SetEc2SubnetIds sets the Ec2SubnetIds field's value.
func (s *LaunchProfile) SetEc2SubnetIds(v []*string) *LaunchProfile {
	s.Ec2SubnetIds = v
	return s
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *LaunchProfile) SetLaunchProfileId(v string) *LaunchProfile {
	s.LaunchProfileId = &v
	return s
}

// SetLaunchProfileProtocolVersions sets the LaunchProfileProtocolVersions field's value.
func (s *LaunchProfile) SetLaunchProfileProtocolVersions(v []*string) *LaunchProfile {
	s.LaunchProfileProtocolVersions = v
	return s
}

// SetName sets the Name field's value.
func (s *LaunchProfile) SetName(v string) *LaunchProfile {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *LaunchProfile) SetState(v string) *LaunchProfile {
	s.State = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *LaunchProfile) SetStatusCode(v string) *LaunchProfile {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *LaunchProfile) SetStatusMessage(v string) *LaunchProfile {
	s.StatusMessage = &v
	return s
}

// SetStreamConfiguration sets the StreamConfiguration field's value.
func (s *LaunchProfile) SetStreamConfiguration(v *StreamConfiguration) *LaunchProfile {
	s.StreamConfiguration = v
	return s
}

// SetStudioComponentIds sets the StudioComponentIds field's value.
func (s *LaunchProfile) SetStudioComponentIds(v []*string) *LaunchProfile {
	s.StudioComponentIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *LaunchProfile) SetTags(v map[string]*string) *LaunchProfile {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *LaunchProfile) SetUpdatedAt(v time.Time) *LaunchProfile {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *LaunchProfile) SetUpdatedBy(v string) *LaunchProfile {
	s.UpdatedBy = &v
	return s
}

// SetValidationResults sets the ValidationResults field's value.
func (s *LaunchProfile) SetValidationResults(v []*ValidationResult) *LaunchProfile {
	s.ValidationResults = v
	return s
}

// A Launch Profile Initialization contains information required for a workstation
// or server to connect to a launch profile.
//
// This includes scripts, endpoints, security groups, subnets, and other configuration.
type LaunchProfileInitialization struct {
	_ struct{} `type:"structure"`

	// A LaunchProfileInitializationActiveDirectory resource.
	ActiveDirectory *LaunchProfileInitializationActiveDirectory `locationName:"activeDirectory" type:"structure"`

	// The EC2 security groups that control access to the studio component.
	Ec2SecurityGroupIds []*string `locationName:"ec2SecurityGroupIds" min:"1" type:"list"`

	// The launch profile ID.
	LaunchProfileId *string `locationName:"launchProfileId" type:"string"`

	// The version number of the protocol that is used by the launch profile. The
	// only valid version is "2021-03-31".
	LaunchProfileProtocolVersion *string `locationName:"launchProfileProtocolVersion" type:"string"`

	// The launch purpose.
	LaunchPurpose *string `locationName:"launchPurpose" type:"string"`

	// The name for the launch profile.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LaunchProfileInitialization's
	// String and GoString methods.
	Name *string `locationName:"name" min:"1" type:"string" sensitive:"true"`

	// The platform of the launch platform, either WINDOWS or LINUX.
	Platform *string `locationName:"platform" type:"string" enum:"LaunchProfilePlatform"`

	// The system initializtion scripts.
	SystemInitializationScripts []*LaunchProfileInitializationScript `locationName:"systemInitializationScripts" type:"list"`

	// The user initializtion scripts.
	UserInitializationScripts []*LaunchProfileInitializationScript `locationName:"userInitializationScripts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfileInitialization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfileInitialization) GoString() string {
	return s.String()
}

// SetActiveDirectory sets the ActiveDirectory field's value.
func (s *LaunchProfileInitialization) SetActiveDirectory(v *LaunchProfileInitializationActiveDirectory) *LaunchProfileInitialization {
	s.ActiveDirectory = v
	return s
}

// SetEc2SecurityGroupIds sets the Ec2SecurityGroupIds field's value.
func (s *LaunchProfileInitialization) SetEc2SecurityGroupIds(v []*string) *LaunchProfileInitialization {
	s.Ec2SecurityGroupIds = v
	return s
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *LaunchProfileInitialization) SetLaunchProfileId(v string) *LaunchProfileInitialization {
	s.LaunchProfileId = &v
	return s
}

// SetLaunchProfileProtocolVersion sets the LaunchProfileProtocolVersion field's value.
func (s *LaunchProfileInitialization) SetLaunchProfileProtocolVersion(v string) *LaunchProfileInitialization {
	s.LaunchProfileProtocolVersion = &v
	return s
}

// SetLaunchPurpose sets the LaunchPurpose field's value.
func (s *LaunchProfileInitialization) SetLaunchPurpose(v string) *LaunchProfileInitialization {
	s.LaunchPurpose = &v
	return s
}

// SetName sets the Name field's value.
func (s *LaunchProfileInitialization) SetName(v string) *LaunchProfileInitialization {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *LaunchProfileInitialization) SetPlatform(v string) *LaunchProfileInitialization {
	s.Platform = &v
	return s
}

// SetSystemInitializationScripts sets the SystemInitializationScripts field's value.
func (s *LaunchProfileInitialization) SetSystemInitializationScripts(v []*LaunchProfileInitializationScript) *LaunchProfileInitialization {
	s.SystemInitializationScripts = v
	return s
}

// SetUserInitializationScripts sets the UserInitializationScripts field's value.
func (s *LaunchProfileInitialization) SetUserInitializationScripts(v []*LaunchProfileInitializationScript) *LaunchProfileInitialization {
	s.UserInitializationScripts = v
	return s
}

// The Launch Profile Initialization Active Directory contains information required
// for the launch profile to connect to the Active Directory.
type LaunchProfileInitializationActiveDirectory struct {
	_ struct{} `type:"structure"`

	// A collection of custom attributes for an Active Directory computer.
	//
	// ComputerAttributes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LaunchProfileInitializationActiveDirectory's
	// String and GoString methods.
	ComputerAttributes []*ActiveDirectoryComputerAttribute `locationName:"computerAttributes" type:"list" sensitive:"true"`

	// The directory ID of the Directory Service for Microsoft Active Directory
	// to access using this launch profile.
	DirectoryId *string `locationName:"directoryId" type:"string"`

	// The directory name.
	DirectoryName *string `locationName:"directoryName" type:"string"`

	// The DNS IP address.
	DnsIpAddresses []*string `locationName:"dnsIpAddresses" type:"list"`

	// The name for the organizational unit distinguished name.
	OrganizationalUnitDistinguishedName *string `locationName:"organizationalUnitDistinguishedName" min:"1" type:"string"`

	// The unique identifier for a studio component resource.
	StudioComponentId *string `locationName:"studioComponentId" type:"string"`

	// The name for the studio component.
	//
	// StudioComponentName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LaunchProfileInitializationActiveDirectory's
	// String and GoString methods.
	StudioComponentName *string `locationName:"studioComponentName" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfileInitializationActiveDirectory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfileInitializationActiveDirectory) GoString() string {
	return s.String()
}

// SetComputerAttributes sets the ComputerAttributes field's value.
func (s *LaunchProfileInitializationActiveDirectory) SetComputerAttributes(v []*ActiveDirectoryComputerAttribute) *LaunchProfileInitializationActiveDirectory {
	s.ComputerAttributes = v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *LaunchProfileInitializationActiveDirectory) SetDirectoryId(v string) *LaunchProfileInitializationActiveDirectory {
	s.DirectoryId = &v
	return s
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *LaunchProfileInitializationActiveDirectory) SetDirectoryName(v string) *LaunchProfileInitializationActiveDirectory {
	s.DirectoryName = &v
	return s
}

// SetDnsIpAddresses sets the DnsIpAddresses field's value.
func (s *LaunchProfileInitializationActiveDirectory) SetDnsIpAddresses(v []*string) *LaunchProfileInitializationActiveDirectory {
	s.DnsIpAddresses = v
	return s
}

// SetOrganizationalUnitDistinguishedName sets the OrganizationalUnitDistinguishedName field's value.
func (s *LaunchProfileInitializationActiveDirectory) SetOrganizationalUnitDistinguishedName(v string) *LaunchProfileInitializationActiveDirectory {
	s.OrganizationalUnitDistinguishedName = &v
	return s
}

// SetStudioComponentId sets the StudioComponentId field's value.
func (s *LaunchProfileInitializationActiveDirectory) SetStudioComponentId(v string) *LaunchProfileInitializationActiveDirectory {
	s.StudioComponentId = &v
	return s
}

// SetStudioComponentName sets the StudioComponentName field's value.
func (s *LaunchProfileInitializationActiveDirectory) SetStudioComponentName(v string) *LaunchProfileInitializationActiveDirectory {
	s.StudioComponentName = &v
	return s
}

// The Launch Profile Initialization Script is used when start streaming session
// runs.
type LaunchProfileInitializationScript struct {
	_ struct{} `type:"structure"`

	// An IAM role attached to a Studio Component that gives the studio component
	// access to AWS resources at anytime while the instance is running.
	RuntimeRoleArn *string `locationName:"runtimeRoleArn" type:"string"`

	// The initialization script.
	//
	// Script is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LaunchProfileInitializationScript's
	// String and GoString methods.
	Script *string `locationName:"script" min:"1" type:"string" sensitive:"true"`

	// An IAM role attached to Studio Component when the system initialization script
	// runs which give the studio component access to AWS resources when the system
	// initialization script runs.
	SecureInitializationRoleArn *string `locationName:"secureInitializationRoleArn" type:"string"`

	// The unique identifier for a studio component resource.
	StudioComponentId *string `locationName:"studioComponentId" type:"string"`

	// The name for the studio component.
	//
	// StudioComponentName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LaunchProfileInitializationScript's
	// String and GoString methods.
	StudioComponentName *string `locationName:"studioComponentName" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfileInitializationScript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfileInitializationScript) GoString() string {
	return s.String()
}

// SetRuntimeRoleArn sets the RuntimeRoleArn field's value.
func (s *LaunchProfileInitializationScript) SetRuntimeRoleArn(v string) *LaunchProfileInitializationScript {
	s.RuntimeRoleArn = &v
	return s
}

// SetScript sets the Script field's value.
func (s *LaunchProfileInitializationScript) SetScript(v string) *LaunchProfileInitializationScript {
	s.Script = &v
	return s
}

// SetSecureInitializationRoleArn sets the SecureInitializationRoleArn field's value.
func (s *LaunchProfileInitializationScript) SetSecureInitializationRoleArn(v string) *LaunchProfileInitializationScript {
	s.SecureInitializationRoleArn = &v
	return s
}

// SetStudioComponentId sets the StudioComponentId field's value.
func (s *LaunchProfileInitializationScript) SetStudioComponentId(v string) *LaunchProfileInitializationScript {
	s.StudioComponentId = &v
	return s
}

// SetStudioComponentName sets the StudioComponentName field's value.
func (s *LaunchProfileInitializationScript) SetStudioComponentName(v string) *LaunchProfileInitializationScript {
	s.StudioComponentName = &v
	return s
}

// Launch profile membership enables your studio admins to delegate launch profile
// access to other studio users in the Nimble Studio portal without needing
// to write or maintain complex IAM policies. A launch profile member is a user
// association from your studio identity source who is granted permissions to
// a launch profile.
//
// A launch profile member (type USER) provides the following permissions to
// that launch profile:
//
//   - GetLaunchProfile
//
//   - GetLaunchProfileInitialization
//
//   - GetLaunchProfileMembers
//
//   - GetLaunchProfileMember
//
//   - CreateStreamingSession
//
//   - GetLaunchProfileDetails
type LaunchProfileMembership struct {
	_ struct{} `type:"structure"`

	// The ID of the identity store.
	IdentityStoreId *string `locationName:"identityStoreId" type:"string"`

	// The persona.
	Persona *string `locationName:"persona" type:"string" enum:"LaunchProfilePersona"`

	// The principal ID.
	PrincipalId *string `locationName:"principalId" type:"string"`

	// The Active Directory Security Identifier for this user, if available.
	Sid *string `locationName:"sid" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfileMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchProfileMembership) GoString() string {
	return s.String()
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *LaunchProfileMembership) SetIdentityStoreId(v string) *LaunchProfileMembership {
	s.IdentityStoreId = &v
	return s
}

// SetPersona sets the Persona field's value.
func (s *LaunchProfileMembership) SetPersona(v string) *LaunchProfileMembership {
	s.Persona = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *LaunchProfileMembership) SetPrincipalId(v string) *LaunchProfileMembership {
	s.PrincipalId = &v
	return s
}

// SetSid sets the Sid field's value.
func (s *LaunchProfileMembership) SetSid(v string) *LaunchProfileMembership {
	s.Sid = &v
	return s
}

// The configuration for a license service that is associated with a studio
// resource.
type LicenseServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// The endpoint of the license service that is accessed by the studio component
	// resource.
	//
	// Endpoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LicenseServiceConfiguration's
	// String and GoString methods.
	Endpoint *string `locationName:"endpoint" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LicenseServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LicenseServiceConfiguration) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *LicenseServiceConfiguration) SetEndpoint(v string) *LicenseServiceConfiguration {
	s.Endpoint = &v
	return s
}

type ListEulaAcceptancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The list of EULA IDs that have been previously accepted.
	EulaIds []*string `location:"querystring" locationName:"eulaIds" type:"list"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEulaAcceptancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEulaAcceptancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEulaAcceptancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEulaAcceptancesInput"}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEulaIds sets the EulaIds field's value.
func (s *ListEulaAcceptancesInput) SetEulaIds(v []*string) *ListEulaAcceptancesInput {
	s.EulaIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEulaAcceptancesInput) SetNextToken(v string) *ListEulaAcceptancesInput {
	s.NextToken = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *ListEulaAcceptancesInput) SetStudioId(v string) *ListEulaAcceptancesInput {
	s.StudioId = &v
	return s
}

type ListEulaAcceptancesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of EULA acceptances.
	EulaAcceptances []*EulaAcceptance `locationName:"eulaAcceptances" type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEulaAcceptancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEulaAcceptancesOutput) GoString() string {
	return s.String()
}

// SetEulaAcceptances sets the EulaAcceptances field's value.
func (s *ListEulaAcceptancesOutput) SetEulaAcceptances(v []*EulaAcceptance) *ListEulaAcceptancesOutput {
	s.EulaAcceptances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEulaAcceptancesOutput) SetNextToken(v string) *ListEulaAcceptancesOutput {
	s.NextToken = &v
	return s
}

type ListEulasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The list of EULA IDs that should be returned
	EulaIds []*string `location:"querystring" locationName:"eulaIds" type:"list"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEulasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEulasInput) GoString() string {
	return s.String()
}

// SetEulaIds sets the EulaIds field's value.
func (s *ListEulasInput) SetEulaIds(v []*string) *ListEulasInput {
	s.EulaIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEulasInput) SetNextToken(v string) *ListEulasInput {
	s.NextToken = &v
	return s
}

type ListEulasOutput struct {
	_ struct{} `type:"structure"`

	// A collection of EULA resources.
	Eulas []*Eula `locationName:"eulas" type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEulasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEulasOutput) GoString() string {
	return s.String()
}

// SetEulas sets the Eulas field's value.
func (s *ListEulasOutput) SetEulas(v []*Eula) *ListEulasOutput {
	s.Eulas = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEulasOutput) SetNextToken(v string) *ListEulasOutput {
	s.NextToken = &v
	return s
}

type ListLaunchProfileMembersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// The max number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchProfileMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchProfileMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLaunchProfileMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLaunchProfileMembersInput"}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *ListLaunchProfileMembersInput) SetLaunchProfileId(v string) *ListLaunchProfileMembersInput {
	s.LaunchProfileId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLaunchProfileMembersInput) SetMaxResults(v int64) *ListLaunchProfileMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLaunchProfileMembersInput) SetNextToken(v string) *ListLaunchProfileMembersInput {
	s.NextToken = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *ListLaunchProfileMembersInput) SetStudioId(v string) *ListLaunchProfileMembersInput {
	s.StudioId = &v
	return s
}

type ListLaunchProfileMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of members.
	Members []*LaunchProfileMembership `locationName:"members" type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchProfileMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchProfileMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListLaunchProfileMembersOutput) SetMembers(v []*LaunchProfileMembership) *ListLaunchProfileMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLaunchProfileMembersOutput) SetNextToken(v string) *ListLaunchProfileMembersOutput {
	s.NextToken = &v
	return s
}

type ListLaunchProfilesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The max number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The principal ID. This currently supports a IAM Identity Center UserId.
	PrincipalId *string `location:"querystring" locationName:"principalId" type:"string"`

	// Filter this request to launch profiles in any of the given states.
	States []*string `location:"querystring" locationName:"states" type:"list" enum:"LaunchProfileState"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLaunchProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLaunchProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLaunchProfilesInput) SetMaxResults(v int64) *ListLaunchProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLaunchProfilesInput) SetNextToken(v string) *ListLaunchProfilesInput {
	s.NextToken = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ListLaunchProfilesInput) SetPrincipalId(v string) *ListLaunchProfilesInput {
	s.PrincipalId = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListLaunchProfilesInput) SetStates(v []*string) *ListLaunchProfilesInput {
	s.States = v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *ListLaunchProfilesInput) SetStudioId(v string) *ListLaunchProfilesInput {
	s.StudioId = &v
	return s
}

type ListLaunchProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of launch profiles.
	LaunchProfiles []*LaunchProfile `locationName:"launchProfiles" type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchProfilesOutput) GoString() string {
	return s.String()
}

// SetLaunchProfiles sets the LaunchProfiles field's value.
func (s *ListLaunchProfilesOutput) SetLaunchProfiles(v []*LaunchProfile) *ListLaunchProfilesOutput {
	s.LaunchProfiles = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLaunchProfilesOutput) SetNextToken(v string) *ListLaunchProfilesOutput {
	s.NextToken = &v
	return s
}

type ListStreamingImagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Filter this request to streaming images with the given owner
	Owner *string `location:"querystring" locationName:"owner" type:"string"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamingImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamingImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamingImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamingImagesInput"}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamingImagesInput) SetNextToken(v string) *ListStreamingImagesInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListStreamingImagesInput) SetOwner(v string) *ListStreamingImagesInput {
	s.Owner = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *ListStreamingImagesInput) SetStudioId(v string) *ListStreamingImagesInput {
	s.StudioId = &v
	return s
}

type ListStreamingImagesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A collection of streaming images.
	StreamingImages []*StreamingImage `locationName:"streamingImages" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamingImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamingImagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamingImagesOutput) SetNextToken(v string) *ListStreamingImagesOutput {
	s.NextToken = &v
	return s
}

// SetStreamingImages sets the StreamingImages field's value.
func (s *ListStreamingImagesOutput) SetStreamingImages(v []*StreamingImage) *ListStreamingImagesOutput {
	s.StreamingImages = v
	return s
}

type ListStreamingSessionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Filters the request to streaming sessions created by the given user.
	CreatedBy *string `location:"querystring" locationName:"createdBy" type:"string"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Filters the request to streaming session owned by the given user
	OwnedBy *string `location:"querystring" locationName:"ownedBy" type:"string"`

	// Filters the request to only the provided session IDs.
	SessionIds *string `location:"querystring" locationName:"sessionIds" type:"string"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamingSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamingSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamingSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamingSessionsInput"}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ListStreamingSessionsInput) SetCreatedBy(v string) *ListStreamingSessionsInput {
	s.CreatedBy = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamingSessionsInput) SetNextToken(v string) *ListStreamingSessionsInput {
	s.NextToken = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *ListStreamingSessionsInput) SetOwnedBy(v string) *ListStreamingSessionsInput {
	s.OwnedBy = &v
	return s
}

// SetSessionIds sets the SessionIds field's value.
func (s *ListStreamingSessionsInput) SetSessionIds(v string) *ListStreamingSessionsInput {
	s.SessionIds = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *ListStreamingSessionsInput) SetStudioId(v string) *ListStreamingSessionsInput {
	s.StudioId = &v
	return s
}

type ListStreamingSessionsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A collection of streaming sessions.
	Sessions []*StreamingSession `locationName:"sessions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamingSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamingSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamingSessionsOutput) SetNextToken(v string) *ListStreamingSessionsOutput {
	s.NextToken = &v
	return s
}

// SetSessions sets the Sessions field's value.
func (s *ListStreamingSessionsOutput) SetSessions(v []*StreamingSession) *ListStreamingSessionsOutput {
	s.Sessions = v
	return s
}

type ListStudioComponentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The max number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Filters the request to studio components that are in one of the given states.
	States []*string `location:"querystring" locationName:"states" type:"list" enum:"StudioComponentState"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`

	// Filters the request to studio components that are of one of the given types.
	Types []*string `location:"querystring" locationName:"types" type:"list" enum:"StudioComponentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudioComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudioComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStudioComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStudioComponentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStudioComponentsInput) SetMaxResults(v int64) *ListStudioComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStudioComponentsInput) SetNextToken(v string) *ListStudioComponentsInput {
	s.NextToken = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListStudioComponentsInput) SetStates(v []*string) *ListStudioComponentsInput {
	s.States = v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *ListStudioComponentsInput) SetStudioId(v string) *ListStudioComponentsInput {
	s.StudioId = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *ListStudioComponentsInput) SetTypes(v []*string) *ListStudioComponentsInput {
	s.Types = v
	return s
}

type ListStudioComponentsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A collection of studio components.
	StudioComponents []*StudioComponent `locationName:"studioComponents" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudioComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudioComponentsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStudioComponentsOutput) SetNextToken(v string) *ListStudioComponentsOutput {
	s.NextToken = &v
	return s
}

// SetStudioComponents sets the StudioComponents field's value.
func (s *ListStudioComponentsOutput) SetStudioComponents(v []*StudioComponent) *ListStudioComponentsOutput {
	s.StudioComponents = v
	return s
}

type ListStudioMembersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The max number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudioMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudioMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStudioMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStudioMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStudioMembersInput) SetMaxResults(v int64) *ListStudioMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStudioMembersInput) SetNextToken(v string) *ListStudioMembersInput {
	s.NextToken = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *ListStudioMembersInput) SetStudioId(v string) *ListStudioMembersInput {
	s.StudioId = &v
	return s
}

type ListStudioMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of admin members.
	Members []*StudioMembership `locationName:"members" type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudioMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudioMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListStudioMembersOutput) SetMembers(v []*StudioMembership) *ListStudioMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStudioMembersOutput) SetNextToken(v string) *ListStudioMembersOutput {
	s.NextToken = &v
	return s
}

type ListStudiosInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudiosInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudiosInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStudiosInput) SetNextToken(v string) *ListStudiosInput {
	s.NextToken = &v
	return s
}

type ListStudiosOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A collection of studios.
	//
	// Studios is a required field
	Studios []*Studio `locationName:"studios" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudiosOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStudiosOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStudiosOutput) SetNextToken(v string) *ListStudiosOutput {
	s.NextToken = &v
	return s
}

// SetStudios sets the Studios field's value.
func (s *ListStudiosOutput) SetStudios(v []*Studio) *ListStudiosOutput {
	s.Studios = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource for which you want to list
	// tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A new member that is added to a launch profile.
type NewLaunchProfileMember struct {
	_ struct{} `type:"structure"`

	// The persona.
	//
	// Persona is a required field
	Persona *string `locationName:"persona" type:"string" required:"true" enum:"LaunchProfilePersona"`

	// The principal ID.
	//
	// PrincipalId is a required field
	PrincipalId *string `locationName:"principalId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewLaunchProfileMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewLaunchProfileMember) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewLaunchProfileMember) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewLaunchProfileMember"}
	if s.Persona == nil {
		invalidParams.Add(request.NewErrParamRequired("Persona"))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPersona sets the Persona field's value.
func (s *NewLaunchProfileMember) SetPersona(v string) *NewLaunchProfileMember {
	s.Persona = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *NewLaunchProfileMember) SetPrincipalId(v string) *NewLaunchProfileMember {
	s.PrincipalId = &v
	return s
}

// A new studio user's membership.
type NewStudioMember struct {
	_ struct{} `type:"structure"`

	// The persona.
	//
	// Persona is a required field
	Persona *string `locationName:"persona" type:"string" required:"true" enum:"StudioPersona"`

	// The principal ID.
	//
	// PrincipalId is a required field
	PrincipalId *string `locationName:"principalId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewStudioMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewStudioMember) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewStudioMember) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewStudioMember"}
	if s.Persona == nil {
		invalidParams.Add(request.NewErrParamRequired("Persona"))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPersona sets the Persona field's value.
func (s *NewStudioMember) SetPersona(v string) *NewStudioMember {
	s.Persona = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *NewStudioMember) SetPrincipalId(v string) *NewStudioMember {
	s.PrincipalId = &v
	return s
}

type PutLaunchProfileMembersInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" type:"string" required:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// A list of members.
	//
	// Members is a required field
	Members []*NewLaunchProfileMember `locationName:"members" min:"1" type:"list" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLaunchProfileMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLaunchProfileMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLaunchProfileMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLaunchProfileMembersInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.Members == nil {
		invalidParams.Add(request.NewErrParamRequired("Members"))
	}
	if s.Members != nil && len(s.Members) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Members", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}
	if s.Members != nil {
		for i, v := range s.Members {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Members", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *PutLaunchProfileMembersInput) SetClientToken(v string) *PutLaunchProfileMembersInput {
	s.ClientToken = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *PutLaunchProfileMembersInput) SetIdentityStoreId(v string) *PutLaunchProfileMembersInput {
	s.IdentityStoreId = &v
	return s
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *PutLaunchProfileMembersInput) SetLaunchProfileId(v string) *PutLaunchProfileMembersInput {
	s.LaunchProfileId = &v
	return s
}

// SetMembers sets the Members field's value.
func (s *PutLaunchProfileMembersInput) SetMembers(v []*NewLaunchProfileMember) *PutLaunchProfileMembersInput {
	s.Members = v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *PutLaunchProfileMembersInput) SetStudioId(v string) *PutLaunchProfileMembersInput {
	s.StudioId = &v
	return s
}

type PutLaunchProfileMembersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLaunchProfileMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLaunchProfileMembersOutput) GoString() string {
	return s.String()
}

type PutStudioMembersInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" type:"string" required:"true"`

	// A list of members.
	//
	// Members is a required field
	Members []*NewStudioMember `locationName:"members" min:"1" type:"list" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutStudioMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutStudioMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutStudioMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutStudioMembersInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.Members == nil {
		invalidParams.Add(request.NewErrParamRequired("Members"))
	}
	if s.Members != nil && len(s.Members) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Members", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}
	if s.Members != nil {
		for i, v := range s.Members {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Members", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *PutStudioMembersInput) SetClientToken(v string) *PutStudioMembersInput {
	s.ClientToken = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *PutStudioMembersInput) SetIdentityStoreId(v string) *PutStudioMembersInput {
	s.IdentityStoreId = &v
	return s
}

// SetMembers sets the Members field's value.
func (s *PutStudioMembersInput) SetMembers(v []*NewStudioMember) *PutStudioMembersInput {
	s.Members = v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *PutStudioMembersInput) SetStudioId(v string) *PutStudioMembersInput {
	s.StudioId = &v
	return s
}

type PutStudioMembersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutStudioMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutStudioMembersOutput) GoString() string {
	return s.String()
}

// The specified resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A more specific error code.
	Code_ *string `locationName:"code" type:"string"`

	// The exception context.
	Context map[string]*string `locationName:"context" type:"map"`

	// A human-readable description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A parameter for a studio component script, in the form of a key:value pair.
type ScriptParameterKeyValue struct {
	_ struct{} `type:"structure"`

	// A script parameter key.
	Key *string `locationName:"key" min:"1" type:"string"`

	// A script parameter value.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScriptParameterKeyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScriptParameterKeyValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScriptParameterKeyValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScriptParameterKeyValue"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ScriptParameterKeyValue) SetKey(v string) *ScriptParameterKeyValue {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ScriptParameterKeyValue) SetValue(v string) *ScriptParameterKeyValue {
	s.Value = &v
	return s
}

// Your current quota does not allow you to perform the request action. You
// can request increases for some quotas, and other quotas cannot be increased.
//
// Please use AWS Service Quotas to request an increase.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A more specific error code.
	Code_ *string `locationName:"code" type:"string"`

	// The exception context.
	Context map[string]*string `locationName:"context" type:"map"`

	// A human-readable description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for a shared file storage system that is associated with
// a studio resource.
type SharedFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The endpoint of the shared file system that is accessed by the studio component
	// resource.
	//
	// Endpoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SharedFileSystemConfiguration's
	// String and GoString methods.
	Endpoint *string `locationName:"endpoint" type:"string" sensitive:"true"`

	// The unique identifier for a file system.
	FileSystemId *string `locationName:"fileSystemId" type:"string"`

	// The mount location for a shared file system on a Linux virtual workstation.
	//
	// LinuxMountPoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SharedFileSystemConfiguration's
	// String and GoString methods.
	LinuxMountPoint *string `locationName:"linuxMountPoint" type:"string" sensitive:"true"`

	// The name of the file share.
	//
	// ShareName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SharedFileSystemConfiguration's
	// String and GoString methods.
	ShareName *string `locationName:"shareName" type:"string" sensitive:"true"`

	// The mount location for a shared file system on a Windows virtual workstation.
	WindowsMountDrive *string `locationName:"windowsMountDrive" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharedFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharedFileSystemConfiguration) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *SharedFileSystemConfiguration) SetEndpoint(v string) *SharedFileSystemConfiguration {
	s.Endpoint = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *SharedFileSystemConfiguration) SetFileSystemId(v string) *SharedFileSystemConfiguration {
	s.FileSystemId = &v
	return s
}

// SetLinuxMountPoint sets the LinuxMountPoint field's value.
func (s *SharedFileSystemConfiguration) SetLinuxMountPoint(v string) *SharedFileSystemConfiguration {
	s.LinuxMountPoint = &v
	return s
}

// SetShareName sets the ShareName field's value.
func (s *SharedFileSystemConfiguration) SetShareName(v string) *SharedFileSystemConfiguration {
	s.ShareName = &v
	return s
}

// SetWindowsMountDrive sets the WindowsMountDrive field's value.
func (s *SharedFileSystemConfiguration) SetWindowsMountDrive(v string) *SharedFileSystemConfiguration {
	s.WindowsMountDrive = &v
	return s
}

type StartStreamingSessionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The streaming session ID for the StartStreamingSessionRequest.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`

	// The studio ID for the StartStreamingSessionRequest.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamingSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamingSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStreamingSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartStreamingSessionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartStreamingSessionInput) SetClientToken(v string) *StartStreamingSessionInput {
	s.ClientToken = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StartStreamingSessionInput) SetSessionId(v string) *StartStreamingSessionInput {
	s.SessionId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *StartStreamingSessionInput) SetStudioId(v string) *StartStreamingSessionInput {
	s.StudioId = &v
	return s
}

type StartStreamingSessionOutput struct {
	_ struct{} `type:"structure"`

	// A streaming session is a virtual workstation created using a particular launch
	// profile.
	Session *StreamingSession `locationName:"session" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamingSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamingSessionOutput) GoString() string {
	return s.String()
}

// SetSession sets the Session field's value.
func (s *StartStreamingSessionOutput) SetSession(v *StreamingSession) *StartStreamingSessionOutput {
	s.Session = v
	return s
}

type StartStudioSSOConfigurationRepairInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStudioSSOConfigurationRepairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStudioSSOConfigurationRepairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStudioSSOConfigurationRepairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartStudioSSOConfigurationRepairInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartStudioSSOConfigurationRepairInput) SetClientToken(v string) *StartStudioSSOConfigurationRepairInput {
	s.ClientToken = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *StartStudioSSOConfigurationRepairInput) SetStudioId(v string) *StartStudioSSOConfigurationRepairInput {
	s.StudioId = &v
	return s
}

type StartStudioSSOConfigurationRepairOutput struct {
	_ struct{} `type:"structure"`

	// Information about a studio.
	//
	// Studio is a required field
	Studio *Studio `locationName:"studio" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStudioSSOConfigurationRepairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStudioSSOConfigurationRepairOutput) GoString() string {
	return s.String()
}

// SetStudio sets the Studio field's value.
func (s *StartStudioSSOConfigurationRepairOutput) SetStudio(v *Studio) *StartStudioSSOConfigurationRepairOutput {
	s.Studio = v
	return s
}

type StopStreamingSessionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The streaming session ID for the StopStreamingSessionRequest.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`

	// The studioId for the StopStreamingSessionRequest.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamingSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamingSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStreamingSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopStreamingSessionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StopStreamingSessionInput) SetClientToken(v string) *StopStreamingSessionInput {
	s.ClientToken = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StopStreamingSessionInput) SetSessionId(v string) *StopStreamingSessionInput {
	s.SessionId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *StopStreamingSessionInput) SetStudioId(v string) *StopStreamingSessionInput {
	s.StudioId = &v
	return s
}

type StopStreamingSessionOutput struct {
	_ struct{} `type:"structure"`

	// A streaming session is a virtual workstation created using a particular launch
	// profile.
	Session *StreamingSession `locationName:"session" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamingSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamingSessionOutput) GoString() string {
	return s.String()
}

// SetSession sets the Session field's value.
func (s *StopStreamingSessionOutput) SetSession(v *StreamingSession) *StopStreamingSessionOutput {
	s.Session = v
	return s
}

// A configuration for a streaming session.
type StreamConfiguration struct {
	_ struct{} `type:"structure"`

	// Enable or disable the use of the system clipboard to copy and paste between
	// the streaming session and streaming client.
	//
	// ClipboardMode is a required field
	ClipboardMode *string `locationName:"clipboardMode" type:"string" required:"true" enum:"StreamingClipboardMode"`

	// The EC2 instance types that users can select from when launching a streaming
	// session with this launch profile.
	//
	// Ec2InstanceTypes is a required field
	Ec2InstanceTypes []*string `locationName:"ec2InstanceTypes" min:"1" type:"list" required:"true" enum:"StreamingInstanceType"`

	// The length of time, in minutes, that a streaming session can be active before
	// it is stopped or terminated. After this point, Nimble Studio automatically
	// terminates or stops the session. The default length of time is 690 minutes,
	// and the maximum length of time is 30 days.
	MaxSessionLengthInMinutes *int64 `locationName:"maxSessionLengthInMinutes" min:"1" type:"integer"`

	// Integer that determines if you can start and stop your sessions and how long
	// a session can stay in the STOPPED state. The default value is 0. The maximum
	// value is 5760.
	//
	// If the value is missing or set to 0, your sessions can’t be stopped. If
	// you then call StopStreamingSession, the session fails. If the time that a
	// session stays in the READY state exceeds the maxSessionLengthInMinutes value,
	// the session will automatically be terminated (instead of stopped).
	//
	// If the value is set to a positive number, the session can be stopped. You
	// can call StopStreamingSession to stop sessions in the READY state. If the
	// time that a session stays in the READY state exceeds the maxSessionLengthInMinutes
	// value, the session will automatically be stopped (instead of terminated).
	MaxStoppedSessionLengthInMinutes *int64 `locationName:"maxStoppedSessionLengthInMinutes" type:"integer"`

	// (Optional) The upload storage for a streaming session.
	SessionStorage *StreamConfigurationSessionStorage `locationName:"sessionStorage" type:"structure"`

	// The streaming images that users can select from when launching a streaming
	// session with this launch profile.
	//
	// StreamingImageIds is a required field
	StreamingImageIds []*string `locationName:"streamingImageIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamConfiguration) GoString() string {
	return s.String()
}

// SetClipboardMode sets the ClipboardMode field's value.
func (s *StreamConfiguration) SetClipboardMode(v string) *StreamConfiguration {
	s.ClipboardMode = &v
	return s
}

// SetEc2InstanceTypes sets the Ec2InstanceTypes field's value.
func (s *StreamConfiguration) SetEc2InstanceTypes(v []*string) *StreamConfiguration {
	s.Ec2InstanceTypes = v
	return s
}

// SetMaxSessionLengthInMinutes sets the MaxSessionLengthInMinutes field's value.
func (s *StreamConfiguration) SetMaxSessionLengthInMinutes(v int64) *StreamConfiguration {
	s.MaxSessionLengthInMinutes = &v
	return s
}

// SetMaxStoppedSessionLengthInMinutes sets the MaxStoppedSessionLengthInMinutes field's value.
func (s *StreamConfiguration) SetMaxStoppedSessionLengthInMinutes(v int64) *StreamConfiguration {
	s.MaxStoppedSessionLengthInMinutes = &v
	return s
}

// SetSessionStorage sets the SessionStorage field's value.
func (s *StreamConfiguration) SetSessionStorage(v *StreamConfigurationSessionStorage) *StreamConfiguration {
	s.SessionStorage = v
	return s
}

// SetStreamingImageIds sets the StreamingImageIds field's value.
func (s *StreamConfiguration) SetStreamingImageIds(v []*string) *StreamConfiguration {
	s.StreamingImageIds = v
	return s
}

// Configuration for streaming workstations created using this launch profile.
type StreamConfigurationCreate struct {
	_ struct{} `type:"structure"`

	// Enable or disable the use of the system clipboard to copy and paste between
	// the streaming session and streaming client.
	//
	// ClipboardMode is a required field
	ClipboardMode *string `locationName:"clipboardMode" type:"string" required:"true" enum:"StreamingClipboardMode"`

	// The EC2 instance types that users can select from when launching a streaming
	// session with this launch profile.
	//
	// Ec2InstanceTypes is a required field
	Ec2InstanceTypes []*string `locationName:"ec2InstanceTypes" min:"1" type:"list" required:"true" enum:"StreamingInstanceType"`

	// The length of time, in minutes, that a streaming session can be active before
	// it is stopped or terminated. After this point, Nimble Studio automatically
	// terminates or stops the session. The default length of time is 690 minutes,
	// and the maximum length of time is 30 days.
	MaxSessionLengthInMinutes *int64 `locationName:"maxSessionLengthInMinutes" min:"1" type:"integer"`

	// Integer that determines if you can start and stop your sessions and how long
	// a session can stay in the STOPPED state. The default value is 0. The maximum
	// value is 5760.
	//
	// If the value is missing or set to 0, your sessions can’t be stopped. If
	// you then call StopStreamingSession, the session fails. If the time that a
	// session stays in the READY state exceeds the maxSessionLengthInMinutes value,
	// the session will automatically be terminated (instead of stopped).
	//
	// If the value is set to a positive number, the session can be stopped. You
	// can call StopStreamingSession to stop sessions in the READY state. If the
	// time that a session stays in the READY state exceeds the maxSessionLengthInMinutes
	// value, the session will automatically be stopped (instead of terminated).
	MaxStoppedSessionLengthInMinutes *int64 `locationName:"maxStoppedSessionLengthInMinutes" type:"integer"`

	// (Optional) The upload storage for a streaming workstation that is created
	// using this launch profile.
	SessionStorage *StreamConfigurationSessionStorage `locationName:"sessionStorage" type:"structure"`

	// The streaming images that users can select from when launching a streaming
	// session with this launch profile.
	//
	// StreamingImageIds is a required field
	StreamingImageIds []*string `locationName:"streamingImageIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamConfigurationCreate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamConfigurationCreate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamConfigurationCreate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamConfigurationCreate"}
	if s.ClipboardMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ClipboardMode"))
	}
	if s.Ec2InstanceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("Ec2InstanceTypes"))
	}
	if s.Ec2InstanceTypes != nil && len(s.Ec2InstanceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ec2InstanceTypes", 1))
	}
	if s.MaxSessionLengthInMinutes != nil && *s.MaxSessionLengthInMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSessionLengthInMinutes", 1))
	}
	if s.StreamingImageIds == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingImageIds"))
	}
	if s.StreamingImageIds != nil && len(s.StreamingImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamingImageIds", 1))
	}
	if s.SessionStorage != nil {
		if err := s.SessionStorage.Validate(); err != nil {
			invalidParams.AddNested("SessionStorage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClipboardMode sets the ClipboardMode field's value.
func (s *StreamConfigurationCreate) SetClipboardMode(v string) *StreamConfigurationCreate {
	s.ClipboardMode = &v
	return s
}

// SetEc2InstanceTypes sets the Ec2InstanceTypes field's value.
func (s *StreamConfigurationCreate) SetEc2InstanceTypes(v []*string) *StreamConfigurationCreate {
	s.Ec2InstanceTypes = v
	return s
}

// SetMaxSessionLengthInMinutes sets the MaxSessionLengthInMinutes field's value.
func (s *StreamConfigurationCreate) SetMaxSessionLengthInMinutes(v int64) *StreamConfigurationCreate {
	s.MaxSessionLengthInMinutes = &v
	return s
}

// SetMaxStoppedSessionLengthInMinutes sets the MaxStoppedSessionLengthInMinutes field's value.
func (s *StreamConfigurationCreate) SetMaxStoppedSessionLengthInMinutes(v int64) *StreamConfigurationCreate {
	s.MaxStoppedSessionLengthInMinutes = &v
	return s
}

// SetSessionStorage sets the SessionStorage field's value.
func (s *StreamConfigurationCreate) SetSessionStorage(v *StreamConfigurationSessionStorage) *StreamConfigurationCreate {
	s.SessionStorage = v
	return s
}

// SetStreamingImageIds sets the StreamingImageIds field's value.
func (s *StreamConfigurationCreate) SetStreamingImageIds(v []*string) *StreamConfigurationCreate {
	s.StreamingImageIds = v
	return s
}

// The configuration for a streaming session’s upload storage.
type StreamConfigurationSessionStorage struct {
	_ struct{} `type:"structure"`

	// Allows artists to upload files to their workstations. The only valid option
	// is UPLOAD.
	//
	// Mode is a required field
	Mode []*string `locationName:"mode" min:"1" type:"list" required:"true" enum:"StreamingSessionStorageMode"`

	// The configuration for the upload storage root of the streaming session.
	Root *StreamingSessionStorageRoot `locationName:"root" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamConfigurationSessionStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamConfigurationSessionStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamConfigurationSessionStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamConfigurationSessionStorage"}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}
	if s.Mode != nil && len(s.Mode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Mode", 1))
	}
	if s.Root != nil {
		if err := s.Root.Validate(); err != nil {
			invalidParams.AddNested("Root", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMode sets the Mode field's value.
func (s *StreamConfigurationSessionStorage) SetMode(v []*string) *StreamConfigurationSessionStorage {
	s.Mode = v
	return s
}

// SetRoot sets the Root field's value.
func (s *StreamConfigurationSessionStorage) SetRoot(v *StreamingSessionStorageRoot) *StreamConfigurationSessionStorage {
	s.Root = v
	return s
}

// Represents a streaming image resource.
//
// Streaming images are used by studio users to select which operating system
// and software they want to use in a Nimble Studio streaming session.
//
// Amazon provides a number of streaming images that include popular 3rd-party
// software.
//
// You can create your own streaming images using an Amazon Elastic Compute
// Cloud (Amazon EC2) machine image that you create for this purpose. You can
// also include software that your users require.
type StreamingImage struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// A human-readable description of the streaming image.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StreamingImage's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of an EC2 machine image with which to create the streaming image.
	Ec2ImageId *string `locationName:"ec2ImageId" type:"string"`

	// The encryption configuration.
	EncryptionConfiguration *StreamingImageEncryptionConfiguration `locationName:"encryptionConfiguration" type:"structure"`

	// The list of EULAs that must be accepted before a Streaming Session can be
	// started using this streaming image.
	EulaIds []*string `locationName:"eulaIds" type:"list"`

	// A friendly name for a streaming image resource.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StreamingImage's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The owner of the streaming image, either the studioId that contains the streaming
	// image, or 'amazon' for images that are provided by Amazon Nimble Studio.
	Owner *string `locationName:"owner" type:"string"`

	// The platform of the streaming image, either WINDOWS or LINUX.
	Platform *string `locationName:"platform" type:"string"`

	// The current state.
	State *string `locationName:"state" type:"string" enum:"StreamingImageState"`

	// The status code.
	StatusCode *string `locationName:"statusCode" type:"string" enum:"StreamingImageStatusCode"`

	// The status message for the streaming image.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The ID of the streaming image.
	StreamingImageId *string `locationName:"streamingImageId" type:"string"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingImage) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StreamingImage) SetArn(v string) *StreamingImage {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StreamingImage) SetDescription(v string) *StreamingImage {
	s.Description = &v
	return s
}

// SetEc2ImageId sets the Ec2ImageId field's value.
func (s *StreamingImage) SetEc2ImageId(v string) *StreamingImage {
	s.Ec2ImageId = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *StreamingImage) SetEncryptionConfiguration(v *StreamingImageEncryptionConfiguration) *StreamingImage {
	s.EncryptionConfiguration = v
	return s
}

// SetEulaIds sets the EulaIds field's value.
func (s *StreamingImage) SetEulaIds(v []*string) *StreamingImage {
	s.EulaIds = v
	return s
}

// SetName sets the Name field's value.
func (s *StreamingImage) SetName(v string) *StreamingImage {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *StreamingImage) SetOwner(v string) *StreamingImage {
	s.Owner = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *StreamingImage) SetPlatform(v string) *StreamingImage {
	s.Platform = &v
	return s
}

// SetState sets the State field's value.
func (s *StreamingImage) SetState(v string) *StreamingImage {
	s.State = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *StreamingImage) SetStatusCode(v string) *StreamingImage {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *StreamingImage) SetStatusMessage(v string) *StreamingImage {
	s.StatusMessage = &v
	return s
}

// SetStreamingImageId sets the StreamingImageId field's value.
func (s *StreamingImage) SetStreamingImageId(v string) *StreamingImage {
	s.StreamingImageId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StreamingImage) SetTags(v map[string]*string) *StreamingImage {
	s.Tags = v
	return s
}

// Specifies how a streaming image is encrypted.
type StreamingImageEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN for a KMS key that is used to encrypt studio data.
	KeyArn *string `locationName:"keyArn" min:"4" type:"string"`

	// The type of KMS key that is used to encrypt studio data.
	//
	// KeyType is a required field
	KeyType *string `locationName:"keyType" type:"string" required:"true" enum:"StreamingImageEncryptionConfigurationKeyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingImageEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingImageEncryptionConfiguration) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *StreamingImageEncryptionConfiguration) SetKeyArn(v string) *StreamingImageEncryptionConfiguration {
	s.KeyArn = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *StreamingImageEncryptionConfiguration) SetKeyType(v string) *StreamingImageEncryptionConfiguration {
	s.KeyType = &v
	return s
}

// A streaming session is a virtual workstation created using a particular launch
// profile.
type StreamingSession struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that created the streaming session.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The EC2 Instance type used for the streaming session.
	Ec2InstanceType *string `locationName:"ec2InstanceType" type:"string"`

	// The ID of the launch profile used to control access from the streaming session.
	LaunchProfileId *string `locationName:"launchProfileId" type:"string"`

	// The user ID of the user that owns the streaming session. The user that owns
	// the session will be logging into the session and interacting with the virtual
	// workstation.
	OwnedBy *string `locationName:"ownedBy" type:"string"`

	// The session ID.
	SessionId *string `locationName:"sessionId" type:"string"`

	// The time the session entered START_IN_PROGRESS state.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that started the streaming session.
	StartedBy *string `locationName:"startedBy" type:"string"`

	// The current state.
	State *string `locationName:"state" type:"string" enum:"StreamingSessionState"`

	// The status code.
	StatusCode *string `locationName:"statusCode" type:"string" enum:"StreamingSessionStatusCode"`

	// The status message for the streaming session.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The time the streaming session will automatically be stopped if the user
	// doesn’t stop the session themselves.
	StopAt *time.Time `locationName:"stopAt" type:"timestamp" timestampFormat:"iso8601"`

	// The time the session entered STOP_IN_PROGRESS state.
	StoppedAt *time.Time `locationName:"stoppedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that stopped the streaming session.
	StoppedBy *string `locationName:"stoppedBy" type:"string"`

	// The ID of the streaming image.
	StreamingImageId *string `locationName:"streamingImageId" type:"string"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The time the streaming session will automatically terminate if not terminated
	// by the user.
	TerminateAt *time.Time `locationName:"terminateAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that most recently updated the resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingSession) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StreamingSession) SetArn(v string) *StreamingSession {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *StreamingSession) SetCreatedAt(v time.Time) *StreamingSession {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *StreamingSession) SetCreatedBy(v string) *StreamingSession {
	s.CreatedBy = &v
	return s
}

// SetEc2InstanceType sets the Ec2InstanceType field's value.
func (s *StreamingSession) SetEc2InstanceType(v string) *StreamingSession {
	s.Ec2InstanceType = &v
	return s
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *StreamingSession) SetLaunchProfileId(v string) *StreamingSession {
	s.LaunchProfileId = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *StreamingSession) SetOwnedBy(v string) *StreamingSession {
	s.OwnedBy = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StreamingSession) SetSessionId(v string) *StreamingSession {
	s.SessionId = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *StreamingSession) SetStartedAt(v time.Time) *StreamingSession {
	s.StartedAt = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *StreamingSession) SetStartedBy(v string) *StreamingSession {
	s.StartedBy = &v
	return s
}

// SetState sets the State field's value.
func (s *StreamingSession) SetState(v string) *StreamingSession {
	s.State = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *StreamingSession) SetStatusCode(v string) *StreamingSession {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *StreamingSession) SetStatusMessage(v string) *StreamingSession {
	s.StatusMessage = &v
	return s
}

// SetStopAt sets the StopAt field's value.
func (s *StreamingSession) SetStopAt(v time.Time) *StreamingSession {
	s.StopAt = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *StreamingSession) SetStoppedAt(v time.Time) *StreamingSession {
	s.StoppedAt = &v
	return s
}

// SetStoppedBy sets the StoppedBy field's value.
func (s *StreamingSession) SetStoppedBy(v string) *StreamingSession {
	s.StoppedBy = &v
	return s
}

// SetStreamingImageId sets the StreamingImageId field's value.
func (s *StreamingSession) SetStreamingImageId(v string) *StreamingSession {
	s.StreamingImageId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StreamingSession) SetTags(v map[string]*string) *StreamingSession {
	s.Tags = v
	return s
}

// SetTerminateAt sets the TerminateAt field's value.
func (s *StreamingSession) SetTerminateAt(v time.Time) *StreamingSession {
	s.TerminateAt = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *StreamingSession) SetUpdatedAt(v time.Time) *StreamingSession {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *StreamingSession) SetUpdatedBy(v string) *StreamingSession {
	s.UpdatedBy = &v
	return s
}

// The upload storage root location (folder) on streaming workstations where
// files are uploaded.
type StreamingSessionStorageRoot struct {
	_ struct{} `type:"structure"`

	// The folder path in Linux workstations where files are uploaded.
	//
	// Linux is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StreamingSessionStorageRoot's
	// String and GoString methods.
	Linux *string `locationName:"linux" min:"1" type:"string" sensitive:"true"`

	// The folder path in Windows workstations where files are uploaded.
	//
	// Windows is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StreamingSessionStorageRoot's
	// String and GoString methods.
	Windows *string `locationName:"windows" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingSessionStorageRoot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingSessionStorageRoot) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingSessionStorageRoot) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingSessionStorageRoot"}
	if s.Linux != nil && len(*s.Linux) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Linux", 1))
	}
	if s.Windows != nil && len(*s.Windows) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Windows", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLinux sets the Linux field's value.
func (s *StreamingSessionStorageRoot) SetLinux(v string) *StreamingSessionStorageRoot {
	s.Linux = &v
	return s
}

// SetWindows sets the Windows field's value.
func (s *StreamingSessionStorageRoot) SetWindows(v string) *StreamingSessionStorageRoot {
	s.Windows = &v
	return s
}

// A stream is an active connection to a streaming session, enabling a studio
// user to control the streaming session using a compatible client. Streaming
// session streams are compatible with the NICE DCV web client, included in
// the Nimble Studio portal, or the NICE DCV desktop client.
type StreamingSessionStream struct {
	_ struct{} `type:"structure"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that created the streaming session stream.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The Unix epoch timestamp in seconds for when the resource expires.
	ExpiresAt *time.Time `locationName:"expiresAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that owns the streaming session. The user that owns
	// the session will be logging into the session and interacting with the virtual
	// workstation.
	OwnedBy *string `locationName:"ownedBy" type:"string"`

	// The current state.
	State *string `locationName:"state" type:"string" enum:"StreamingSessionStreamState"`

	// The streaming session stream status code.
	StatusCode *string `locationName:"statusCode" type:"string" enum:"StreamingSessionStreamStatusCode"`

	// The stream ID.
	StreamId *string `locationName:"streamId" type:"string"`

	// The URL to connect to this stream using the DCV client.
	//
	// Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StreamingSessionStream's
	// String and GoString methods.
	Url *string `locationName:"url" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingSessionStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingSessionStream) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *StreamingSessionStream) SetCreatedAt(v time.Time) *StreamingSessionStream {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *StreamingSessionStream) SetCreatedBy(v string) *StreamingSessionStream {
	s.CreatedBy = &v
	return s
}

// SetExpiresAt sets the ExpiresAt field's value.
func (s *StreamingSessionStream) SetExpiresAt(v time.Time) *StreamingSessionStream {
	s.ExpiresAt = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *StreamingSessionStream) SetOwnedBy(v string) *StreamingSessionStream {
	s.OwnedBy = &v
	return s
}

// SetState sets the State field's value.
func (s *StreamingSessionStream) SetState(v string) *StreamingSessionStream {
	s.State = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *StreamingSessionStream) SetStatusCode(v string) *StreamingSessionStream {
	s.StatusCode = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *StreamingSessionStream) SetStreamId(v string) *StreamingSessionStream {
	s.StreamId = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *StreamingSessionStream) SetUrl(v string) *StreamingSessionStream {
	s.Url = &v
	return s
}

// Represents a studio resource.
//
// A studio is the core resource used with Nimble Studio. You must create a
// studio first, before any other resource type can be created. All other resources
// you create and manage in Nimble Studio are contained within a studio.
//
// When creating a studio, you must provides two IAM roles for use with the
// Nimble Studio portal. These roles are assumed by your users when they log
// in to the Nimble Studio portal via IAM Identity Center and your identity
// source.
//
// The user role must have the AmazonNimbleStudio-StudioUser managed policy
// attached for the portal to function properly.
//
// The admin role must have the AmazonNimbleStudio-StudioAdmin managed policy
// attached for the portal to function properly.
//
// Your studio roles must trust the identity.nimble.amazonaws.com service principal
// to function properly.
type Studio struct {
	_ struct{} `type:"structure"`

	// The IAM role that studio admins assume when logging in to the Nimble Studio
	// portal.
	AdminRoleArn *string `locationName:"adminRoleArn" type:"string"`

	// The Amazon Resource Name (ARN) that is assigned to a studio resource and
	// uniquely identifies it. ARNs are unique across all Regions.
	Arn *string `locationName:"arn" type:"string"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// A friendly name for the studio.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Studio's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" type:"string" sensitive:"true"`

	// The Amazon Web Services Region where the studio resource is located.
	HomeRegion *string `locationName:"homeRegion" type:"string"`

	// The IAM Identity Center application client ID used to integrate with IAM
	// Identity Center to enable IAM Identity Center users to log in to Nimble Studio
	// portal.
	SsoClientId *string `locationName:"ssoClientId" type:"string"`

	// The current state of the studio resource.
	State *string `locationName:"state" type:"string" enum:"StudioState"`

	// Status codes that provide additional detail on the studio state.
	StatusCode *string `locationName:"statusCode" type:"string" enum:"StudioStatusCode"`

	// Additional detail on the studio state.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Configuration of the encryption method that is used for the studio.
	StudioEncryptionConfiguration *StudioEncryptionConfiguration `locationName:"studioEncryptionConfiguration" type:"structure"`

	// The unique identifier for a studio resource. In Nimble Studio, all other
	// resources are contained in a studio resource.
	StudioId *string `locationName:"studioId" type:"string"`

	// The name of the studio, as included in the URL when accessing it in the Nimble
	// Studio portal.
	StudioName *string `locationName:"studioName" min:"3" type:"string"`

	// The address of the web page for the studio.
	StudioUrl *string `locationName:"studioUrl" type:"string"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The IAM role that studio users assume when logging in to the Nimble Studio
	// portal.
	UserRoleArn *string `locationName:"userRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Studio) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Studio) GoString() string {
	return s.String()
}

// SetAdminRoleArn sets the AdminRoleArn field's value.
func (s *Studio) SetAdminRoleArn(v string) *Studio {
	s.AdminRoleArn = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Studio) SetArn(v string) *Studio {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Studio) SetCreatedAt(v time.Time) *Studio {
	s.CreatedAt = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Studio) SetDisplayName(v string) *Studio {
	s.DisplayName = &v
	return s
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *Studio) SetHomeRegion(v string) *Studio {
	s.HomeRegion = &v
	return s
}

// SetSsoClientId sets the SsoClientId field's value.
func (s *Studio) SetSsoClientId(v string) *Studio {
	s.SsoClientId = &v
	return s
}

// SetState sets the State field's value.
func (s *Studio) SetState(v string) *Studio {
	s.State = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *Studio) SetStatusCode(v string) *Studio {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Studio) SetStatusMessage(v string) *Studio {
	s.StatusMessage = &v
	return s
}

// SetStudioEncryptionConfiguration sets the StudioEncryptionConfiguration field's value.
func (s *Studio) SetStudioEncryptionConfiguration(v *StudioEncryptionConfiguration) *Studio {
	s.StudioEncryptionConfiguration = v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *Studio) SetStudioId(v string) *Studio {
	s.StudioId = &v
	return s
}

// SetStudioName sets the StudioName field's value.
func (s *Studio) SetStudioName(v string) *Studio {
	s.StudioName = &v
	return s
}

// SetStudioUrl sets the StudioUrl field's value.
func (s *Studio) SetStudioUrl(v string) *Studio {
	s.StudioUrl = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Studio) SetTags(v map[string]*string) *Studio {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Studio) SetUpdatedAt(v time.Time) *Studio {
	s.UpdatedAt = &v
	return s
}

// SetUserRoleArn sets the UserRoleArn field's value.
func (s *Studio) SetUserRoleArn(v string) *Studio {
	s.UserRoleArn = &v
	return s
}

// A studio component represents a network resource to be used by a studio's
// users and workflows. A typical studio contains studio components for each
// of the following: render farm, Active Directory, licensing, and file system.
//
// Access to a studio component is managed by specifying security groups for
// the resource, as well as its endpoint.
//
// A studio component also has a set of initialization scripts that are returned
// by GetLaunchProfileInitialization. These initialization scripts run on streaming
// sessions when they start. They provide users with flexibility in controlling
// how the studio resources are configured on a streaming session.
type StudioComponent struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The configuration of the studio component, based on component type.
	Configuration *StudioComponentConfiguration `locationName:"configuration" type:"structure"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that created the studio component.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// A human-readable description for the studio component resource.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StudioComponent's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The EC2 security groups that control access to the studio component.
	Ec2SecurityGroupIds []*string `locationName:"ec2SecurityGroupIds" type:"list"`

	// Initialization scripts for studio components.
	InitializationScripts []*StudioComponentInitializationScript `locationName:"initializationScripts" type:"list"`

	// A friendly name for the studio component resource.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StudioComponent's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// An IAM role attached to a Studio Component that gives the studio component
	// access to AWS resources at anytime while the instance is running.
	RuntimeRoleArn *string `locationName:"runtimeRoleArn" type:"string"`

	// Parameters for the studio component scripts.
	//
	// ScriptParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StudioComponent's
	// String and GoString methods.
	ScriptParameters []*ScriptParameterKeyValue `locationName:"scriptParameters" type:"list" sensitive:"true"`

	// An IAM role attached to Studio Component when the system initialization script
	// runs which give the studio component access to AWS resources when the system
	// initialization script runs.
	SecureInitializationRoleArn *string `locationName:"secureInitializationRoleArn" type:"string"`

	// The current state.
	State *string `locationName:"state" type:"string" enum:"StudioComponentState"`

	// The status code.
	StatusCode *string `locationName:"statusCode" type:"string" enum:"StudioComponentStatusCode"`

	// The status message for the studio component.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The unique identifier for a studio component resource.
	StudioComponentId *string `locationName:"studioComponentId" type:"string"`

	// The specific subtype of a studio component.
	Subtype *string `locationName:"subtype" type:"string" enum:"StudioComponentSubtype"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of the studio component.
	Type *string `locationName:"type" type:"string" enum:"StudioComponentType"`

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that most recently updated the resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioComponent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioComponent) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StudioComponent) SetArn(v string) *StudioComponent {
	s.Arn = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *StudioComponent) SetConfiguration(v *StudioComponentConfiguration) *StudioComponent {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *StudioComponent) SetCreatedAt(v time.Time) *StudioComponent {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *StudioComponent) SetCreatedBy(v string) *StudioComponent {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StudioComponent) SetDescription(v string) *StudioComponent {
	s.Description = &v
	return s
}

// SetEc2SecurityGroupIds sets the Ec2SecurityGroupIds field's value.
func (s *StudioComponent) SetEc2SecurityGroupIds(v []*string) *StudioComponent {
	s.Ec2SecurityGroupIds = v
	return s
}

// SetInitializationScripts sets the InitializationScripts field's value.
func (s *StudioComponent) SetInitializationScripts(v []*StudioComponentInitializationScript) *StudioComponent {
	s.InitializationScripts = v
	return s
}

// SetName sets the Name field's value.
func (s *StudioComponent) SetName(v string) *StudioComponent {
	s.Name = &v
	return s
}

// SetRuntimeRoleArn sets the RuntimeRoleArn field's value.
func (s *StudioComponent) SetRuntimeRoleArn(v string) *StudioComponent {
	s.RuntimeRoleArn = &v
	return s
}

// SetScriptParameters sets the ScriptParameters field's value.
func (s *StudioComponent) SetScriptParameters(v []*ScriptParameterKeyValue) *StudioComponent {
	s.ScriptParameters = v
	return s
}

// SetSecureInitializationRoleArn sets the SecureInitializationRoleArn field's value.
func (s *StudioComponent) SetSecureInitializationRoleArn(v string) *StudioComponent {
	s.SecureInitializationRoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *StudioComponent) SetState(v string) *StudioComponent {
	s.State = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *StudioComponent) SetStatusCode(v string) *StudioComponent {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *StudioComponent) SetStatusMessage(v string) *StudioComponent {
	s.StatusMessage = &v
	return s
}

// SetStudioComponentId sets the StudioComponentId field's value.
func (s *StudioComponent) SetStudioComponentId(v string) *StudioComponent {
	s.StudioComponentId = &v
	return s
}

// SetSubtype sets the Subtype field's value.
func (s *StudioComponent) SetSubtype(v string) *StudioComponent {
	s.Subtype = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StudioComponent) SetTags(v map[string]*string) *StudioComponent {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *StudioComponent) SetType(v string) *StudioComponent {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *StudioComponent) SetUpdatedAt(v time.Time) *StudioComponent {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *StudioComponent) SetUpdatedBy(v string) *StudioComponent {
	s.UpdatedBy = &v
	return s
}

// The configuration of the studio component, based on component type.
type StudioComponentConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for a Microsoft Active Directory (Microsoft AD) studio
	// resource.
	ActiveDirectoryConfiguration *ActiveDirectoryConfiguration `locationName:"activeDirectoryConfiguration" type:"structure"`

	// The configuration for a render farm that is associated with a studio resource.
	ComputeFarmConfiguration *ComputeFarmConfiguration `locationName:"computeFarmConfiguration" type:"structure"`

	// The configuration for a license service that is associated with a studio
	// resource.
	LicenseServiceConfiguration *LicenseServiceConfiguration `locationName:"licenseServiceConfiguration" type:"structure"`

	// The configuration for a shared file storage system that is associated with
	// a studio resource.
	SharedFileSystemConfiguration *SharedFileSystemConfiguration `locationName:"sharedFileSystemConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioComponentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioComponentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StudioComponentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StudioComponentConfiguration"}
	if s.ActiveDirectoryConfiguration != nil {
		if err := s.ActiveDirectoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ActiveDirectoryConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActiveDirectoryConfiguration sets the ActiveDirectoryConfiguration field's value.
func (s *StudioComponentConfiguration) SetActiveDirectoryConfiguration(v *ActiveDirectoryConfiguration) *StudioComponentConfiguration {
	s.ActiveDirectoryConfiguration = v
	return s
}

// SetComputeFarmConfiguration sets the ComputeFarmConfiguration field's value.
func (s *StudioComponentConfiguration) SetComputeFarmConfiguration(v *ComputeFarmConfiguration) *StudioComponentConfiguration {
	s.ComputeFarmConfiguration = v
	return s
}

// SetLicenseServiceConfiguration sets the LicenseServiceConfiguration field's value.
func (s *StudioComponentConfiguration) SetLicenseServiceConfiguration(v *LicenseServiceConfiguration) *StudioComponentConfiguration {
	s.LicenseServiceConfiguration = v
	return s
}

// SetSharedFileSystemConfiguration sets the SharedFileSystemConfiguration field's value.
func (s *StudioComponentConfiguration) SetSharedFileSystemConfiguration(v *SharedFileSystemConfiguration) *StudioComponentConfiguration {
	s.SharedFileSystemConfiguration = v
	return s
}

// Initialization scripts for studio components.
type StudioComponentInitializationScript struct {
	_ struct{} `type:"structure"`

	// The version number of the protocol that is used by the launch profile. The
	// only valid version is "2021-03-31".
	LaunchProfileProtocolVersion *string `locationName:"launchProfileProtocolVersion" type:"string"`

	// The platform of the initialization script, either WINDOWS or LINUX.
	Platform *string `locationName:"platform" type:"string" enum:"LaunchProfilePlatform"`

	// The method to use when running the initialization script.
	RunContext *string `locationName:"runContext" type:"string" enum:"StudioComponentInitializationScriptRunContext"`

	// The initialization script.
	//
	// Script is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StudioComponentInitializationScript's
	// String and GoString methods.
	Script *string `locationName:"script" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioComponentInitializationScript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioComponentInitializationScript) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StudioComponentInitializationScript) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StudioComponentInitializationScript"}
	if s.Script != nil && len(*s.Script) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Script", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchProfileProtocolVersion sets the LaunchProfileProtocolVersion field's value.
func (s *StudioComponentInitializationScript) SetLaunchProfileProtocolVersion(v string) *StudioComponentInitializationScript {
	s.LaunchProfileProtocolVersion = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *StudioComponentInitializationScript) SetPlatform(v string) *StudioComponentInitializationScript {
	s.Platform = &v
	return s
}

// SetRunContext sets the RunContext field's value.
func (s *StudioComponentInitializationScript) SetRunContext(v string) *StudioComponentInitializationScript {
	s.RunContext = &v
	return s
}

// SetScript sets the Script field's value.
func (s *StudioComponentInitializationScript) SetScript(v string) *StudioComponentInitializationScript {
	s.Script = &v
	return s
}

// The studio component's summary.
type StudioComponentSummary struct {
	_ struct{} `type:"structure"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that created the studio component.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StudioComponentSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name for the studio component.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StudioComponentSummary's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The unique identifier for a studio component resource.
	StudioComponentId *string `locationName:"studioComponentId" type:"string"`

	// The specific subtype of a studio component.
	Subtype *string `locationName:"subtype" type:"string" enum:"StudioComponentSubtype"`

	// The type of the studio component.
	Type *string `locationName:"type" type:"string" enum:"StudioComponentType"`

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user ID of the user that most recently updated the resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioComponentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioComponentSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *StudioComponentSummary) SetCreatedAt(v time.Time) *StudioComponentSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *StudioComponentSummary) SetCreatedBy(v string) *StudioComponentSummary {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StudioComponentSummary) SetDescription(v string) *StudioComponentSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *StudioComponentSummary) SetName(v string) *StudioComponentSummary {
	s.Name = &v
	return s
}

// SetStudioComponentId sets the StudioComponentId field's value.
func (s *StudioComponentSummary) SetStudioComponentId(v string) *StudioComponentSummary {
	s.StudioComponentId = &v
	return s
}

// SetSubtype sets the Subtype field's value.
func (s *StudioComponentSummary) SetSubtype(v string) *StudioComponentSummary {
	s.Subtype = &v
	return s
}

// SetType sets the Type field's value.
func (s *StudioComponentSummary) SetType(v string) *StudioComponentSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *StudioComponentSummary) SetUpdatedAt(v time.Time) *StudioComponentSummary {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *StudioComponentSummary) SetUpdatedBy(v string) *StudioComponentSummary {
	s.UpdatedBy = &v
	return s
}

// Configuration of the encryption method that is used for the studio.
type StudioEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN for a KMS key that is used to encrypt studio data.
	KeyArn *string `locationName:"keyArn" min:"4" type:"string"`

	// The type of KMS key that is used to encrypt studio data.
	//
	// KeyType is a required field
	KeyType *string `locationName:"keyType" type:"string" required:"true" enum:"StudioEncryptionConfigurationKeyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioEncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StudioEncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StudioEncryptionConfiguration"}
	if s.KeyArn != nil && len(*s.KeyArn) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("KeyArn", 4))
	}
	if s.KeyType == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyArn sets the KeyArn field's value.
func (s *StudioEncryptionConfiguration) SetKeyArn(v string) *StudioEncryptionConfiguration {
	s.KeyArn = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *StudioEncryptionConfiguration) SetKeyType(v string) *StudioEncryptionConfiguration {
	s.KeyType = &v
	return s
}

// A studio member is an association of a user from your studio identity source
// to elevated permissions that they are granted in the studio.
//
// When you add a user to your studio using the Nimble Studio console, they
// are given access to the studio's IAM Identity Center application and are
// given access to log in to the Nimble Studio portal. These users have the
// permissions provided by the studio's user IAM role and do not appear in the
// studio membership collection. Only studio admins appear in studio membership.
//
// When you add a user to studio membership with the persona ADMIN, upon logging
// in to the Nimble Studio portal, they are granted permissions specified by
// the Studio's Admin IAM role.
type StudioMembership struct {
	_ struct{} `type:"structure"`

	// The ID of the identity store.
	IdentityStoreId *string `locationName:"identityStoreId" type:"string"`

	// The persona.
	Persona *string `locationName:"persona" type:"string" enum:"StudioPersona"`

	// The principal ID.
	PrincipalId *string `locationName:"principalId" type:"string"`

	// The Active Directory Security Identifier for this user, if available.
	Sid *string `locationName:"sid" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StudioMembership) GoString() string {
	return s.String()
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *StudioMembership) SetIdentityStoreId(v string) *StudioMembership {
	s.IdentityStoreId = &v
	return s
}

// SetPersona sets the Persona field's value.
func (s *StudioMembership) SetPersona(v string) *StudioMembership {
	s.Persona = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *StudioMembership) SetPrincipalId(v string) *StudioMembership {
	s.PrincipalId = &v
	return s
}

// SetSid sets the Sid field's value.
func (s *StudioMembership) SetSid(v string) *StudioMembership {
	s.Sid = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to add tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request throughput limit was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A more specific error code.
	Code_ *string `locationName:"code" type:"string"`

	// The exception context.
	Context map[string]*string `locationName:"context" type:"map"`

	// A human-readable description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifies the Amazon Resource Name(ARN) key from which you are removing
	// tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// One or more tag keys. Specify only the tag keys, not the tag values.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateLaunchProfileInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateLaunchProfileInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// The version number of the protocol that is used by the launch profile. The
	// only valid version is "2021-03-31".
	LaunchProfileProtocolVersions []*string `locationName:"launchProfileProtocolVersions" type:"list"`

	// The name for the launch profile.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateLaunchProfileInput's
	// String and GoString methods.
	Name *string `locationName:"name" min:"1" type:"string" sensitive:"true"`

	// A configuration for a streaming session.
	StreamConfiguration *StreamConfigurationCreate `locationName:"streamConfiguration" type:"structure"`

	// Unique identifiers for a collection of studio components that can be used
	// with this launch profile.
	StudioComponentIds []*string `locationName:"studioComponentIds" min:"1" type:"list"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLaunchProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLaunchProfileInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StudioComponentIds != nil && len(s.StudioComponentIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioComponentIds", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}
	if s.StreamConfiguration != nil {
		if err := s.StreamConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StreamConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateLaunchProfileInput) SetClientToken(v string) *UpdateLaunchProfileInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateLaunchProfileInput) SetDescription(v string) *UpdateLaunchProfileInput {
	s.Description = &v
	return s
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *UpdateLaunchProfileInput) SetLaunchProfileId(v string) *UpdateLaunchProfileInput {
	s.LaunchProfileId = &v
	return s
}

// SetLaunchProfileProtocolVersions sets the LaunchProfileProtocolVersions field's value.
func (s *UpdateLaunchProfileInput) SetLaunchProfileProtocolVersions(v []*string) *UpdateLaunchProfileInput {
	s.LaunchProfileProtocolVersions = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLaunchProfileInput) SetName(v string) *UpdateLaunchProfileInput {
	s.Name = &v
	return s
}

// SetStreamConfiguration sets the StreamConfiguration field's value.
func (s *UpdateLaunchProfileInput) SetStreamConfiguration(v *StreamConfigurationCreate) *UpdateLaunchProfileInput {
	s.StreamConfiguration = v
	return s
}

// SetStudioComponentIds sets the StudioComponentIds field's value.
func (s *UpdateLaunchProfileInput) SetStudioComponentIds(v []*string) *UpdateLaunchProfileInput {
	s.StudioComponentIds = v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *UpdateLaunchProfileInput) SetStudioId(v string) *UpdateLaunchProfileInput {
	s.StudioId = &v
	return s
}

type UpdateLaunchProfileMemberInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The Launch Profile ID.
	//
	// LaunchProfileId is a required field
	LaunchProfileId *string `location:"uri" locationName:"launchProfileId" type:"string" required:"true"`

	// The persona.
	//
	// Persona is a required field
	Persona *string `locationName:"persona" type:"string" required:"true" enum:"LaunchProfilePersona"`

	// The principal ID. This currently supports a IAM Identity Center UserId.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchProfileMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchProfileMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLaunchProfileMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLaunchProfileMemberInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.LaunchProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchProfileId"))
	}
	if s.LaunchProfileId != nil && len(*s.LaunchProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchProfileId", 1))
	}
	if s.Persona == nil {
		invalidParams.Add(request.NewErrParamRequired("Persona"))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateLaunchProfileMemberInput) SetClientToken(v string) *UpdateLaunchProfileMemberInput {
	s.ClientToken = &v
	return s
}

// SetLaunchProfileId sets the LaunchProfileId field's value.
func (s *UpdateLaunchProfileMemberInput) SetLaunchProfileId(v string) *UpdateLaunchProfileMemberInput {
	s.LaunchProfileId = &v
	return s
}

// SetPersona sets the Persona field's value.
func (s *UpdateLaunchProfileMemberInput) SetPersona(v string) *UpdateLaunchProfileMemberInput {
	s.Persona = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *UpdateLaunchProfileMemberInput) SetPrincipalId(v string) *UpdateLaunchProfileMemberInput {
	s.PrincipalId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *UpdateLaunchProfileMemberInput) SetStudioId(v string) *UpdateLaunchProfileMemberInput {
	s.StudioId = &v
	return s
}

type UpdateLaunchProfileMemberOutput struct {
	_ struct{} `type:"structure"`

	// The updated member.
	Member *LaunchProfileMembership `locationName:"member" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchProfileMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchProfileMemberOutput) GoString() string {
	return s.String()
}

// SetMember sets the Member field's value.
func (s *UpdateLaunchProfileMemberOutput) SetMember(v *LaunchProfileMembership) *UpdateLaunchProfileMemberOutput {
	s.Member = v
	return s
}

type UpdateLaunchProfileOutput struct {
	_ struct{} `type:"structure"`

	// The launch profile.
	LaunchProfile *LaunchProfile `locationName:"launchProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchProfileOutput) GoString() string {
	return s.String()
}

// SetLaunchProfile sets the LaunchProfile field's value.
func (s *UpdateLaunchProfileOutput) SetLaunchProfile(v *LaunchProfile) *UpdateLaunchProfileOutput {
	s.LaunchProfile = v
	return s
}

type UpdateStreamingImageInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateStreamingImageInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name for the streaming image.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateStreamingImageInput's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The streaming image ID.
	//
	// StreamingImageId is a required field
	StreamingImageId *string `location:"uri" locationName:"streamingImageId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamingImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamingImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStreamingImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStreamingImageInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.StreamingImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingImageId"))
	}
	if s.StreamingImageId != nil && len(*s.StreamingImageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamingImageId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateStreamingImageInput) SetClientToken(v string) *UpdateStreamingImageInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateStreamingImageInput) SetDescription(v string) *UpdateStreamingImageInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStreamingImageInput) SetName(v string) *UpdateStreamingImageInput {
	s.Name = &v
	return s
}

// SetStreamingImageId sets the StreamingImageId field's value.
func (s *UpdateStreamingImageInput) SetStreamingImageId(v string) *UpdateStreamingImageInput {
	s.StreamingImageId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *UpdateStreamingImageInput) SetStudioId(v string) *UpdateStreamingImageInput {
	s.StudioId = &v
	return s
}

type UpdateStreamingImageOutput struct {
	_ struct{} `type:"structure"`

	// Represents a streaming image resource.
	//
	// Streaming images are used by studio users to select which operating system
	// and software they want to use in a Nimble Studio streaming session.
	//
	// Amazon provides a number of streaming images that include popular 3rd-party
	// software.
	//
	// You can create your own streaming images using an Amazon Elastic Compute
	// Cloud (Amazon EC2) machine image that you create for this purpose. You can
	// also include software that your users require.
	StreamingImage *StreamingImage `locationName:"streamingImage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamingImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamingImageOutput) GoString() string {
	return s.String()
}

// SetStreamingImage sets the StreamingImage field's value.
func (s *UpdateStreamingImageOutput) SetStreamingImage(v *StreamingImage) *UpdateStreamingImageOutput {
	s.StreamingImage = v
	return s
}

type UpdateStudioComponentInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The configuration of the studio component, based on component type.
	Configuration *StudioComponentConfiguration `locationName:"configuration" type:"structure"`

	// The description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateStudioComponentInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The EC2 security groups that control access to the studio component.
	Ec2SecurityGroupIds []*string `locationName:"ec2SecurityGroupIds" type:"list"`

	// Initialization scripts for studio components.
	InitializationScripts []*StudioComponentInitializationScript `locationName:"initializationScripts" type:"list"`

	// The name for the studio component.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateStudioComponentInput's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// An IAM role attached to a Studio Component that gives the studio component
	// access to AWS resources at anytime while the instance is running.
	RuntimeRoleArn *string `locationName:"runtimeRoleArn" type:"string"`

	// Parameters for the studio component scripts.
	//
	// ScriptParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateStudioComponentInput's
	// String and GoString methods.
	ScriptParameters []*ScriptParameterKeyValue `locationName:"scriptParameters" type:"list" sensitive:"true"`

	// An IAM role attached to Studio Component when the system initialization script
	// runs which give the studio component access to AWS resources when the system
	// initialization script runs.
	SecureInitializationRoleArn *string `locationName:"secureInitializationRoleArn" type:"string"`

	// The studio component ID.
	//
	// StudioComponentId is a required field
	StudioComponentId *string `location:"uri" locationName:"studioComponentId" type:"string" required:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`

	// The specific subtype of a studio component.
	Subtype *string `locationName:"subtype" type:"string" enum:"StudioComponentSubtype"`

	// The type of the studio component.
	Type *string `locationName:"type" type:"string" enum:"StudioComponentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStudioComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStudioComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStudioComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStudioComponentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.StudioComponentId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioComponentId"))
	}
	if s.StudioComponentId != nil && len(*s.StudioComponentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioComponentId", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.InitializationScripts != nil {
		for i, v := range s.InitializationScripts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InitializationScripts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScriptParameters != nil {
		for i, v := range s.ScriptParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScriptParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateStudioComponentInput) SetClientToken(v string) *UpdateStudioComponentInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateStudioComponentInput) SetConfiguration(v *StudioComponentConfiguration) *UpdateStudioComponentInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateStudioComponentInput) SetDescription(v string) *UpdateStudioComponentInput {
	s.Description = &v
	return s
}

// SetEc2SecurityGroupIds sets the Ec2SecurityGroupIds field's value.
func (s *UpdateStudioComponentInput) SetEc2SecurityGroupIds(v []*string) *UpdateStudioComponentInput {
	s.Ec2SecurityGroupIds = v
	return s
}

// SetInitializationScripts sets the InitializationScripts field's value.
func (s *UpdateStudioComponentInput) SetInitializationScripts(v []*StudioComponentInitializationScript) *UpdateStudioComponentInput {
	s.InitializationScripts = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStudioComponentInput) SetName(v string) *UpdateStudioComponentInput {
	s.Name = &v
	return s
}

// SetRuntimeRoleArn sets the RuntimeRoleArn field's value.
func (s *UpdateStudioComponentInput) SetRuntimeRoleArn(v string) *UpdateStudioComponentInput {
	s.RuntimeRoleArn = &v
	return s
}

// SetScriptParameters sets the ScriptParameters field's value.
func (s *UpdateStudioComponentInput) SetScriptParameters(v []*ScriptParameterKeyValue) *UpdateStudioComponentInput {
	s.ScriptParameters = v
	return s
}

// SetSecureInitializationRoleArn sets the SecureInitializationRoleArn field's value.
func (s *UpdateStudioComponentInput) SetSecureInitializationRoleArn(v string) *UpdateStudioComponentInput {
	s.SecureInitializationRoleArn = &v
	return s
}

// SetStudioComponentId sets the StudioComponentId field's value.
func (s *UpdateStudioComponentInput) SetStudioComponentId(v string) *UpdateStudioComponentInput {
	s.StudioComponentId = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *UpdateStudioComponentInput) SetStudioId(v string) *UpdateStudioComponentInput {
	s.StudioId = &v
	return s
}

// SetSubtype sets the Subtype field's value.
func (s *UpdateStudioComponentInput) SetSubtype(v string) *UpdateStudioComponentInput {
	s.Subtype = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateStudioComponentInput) SetType(v string) *UpdateStudioComponentInput {
	s.Type = &v
	return s
}

type UpdateStudioComponentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the studio component.
	StudioComponent *StudioComponent `locationName:"studioComponent" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStudioComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStudioComponentOutput) GoString() string {
	return s.String()
}

// SetStudioComponent sets the StudioComponent field's value.
func (s *UpdateStudioComponentOutput) SetStudioComponent(v *StudioComponent) *UpdateStudioComponentOutput {
	s.StudioComponent = v
	return s
}

type UpdateStudioInput struct {
	_ struct{} `type:"structure"`

	// The IAM role that Studio Admins will assume when logging in to the Nimble
	// Studio portal.
	AdminRoleArn *string `locationName:"adminRoleArn" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don’t specify a client token, the AWS SDK automatically
	// generates a client token and uses it for the request to ensure idempotency.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// A friendly name for the studio.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateStudioInput's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" type:"string" sensitive:"true"`

	// The studio ID.
	//
	// StudioId is a required field
	StudioId *string `location:"uri" locationName:"studioId" type:"string" required:"true"`

	// The IAM role that Studio Users will assume when logging in to the Nimble
	// Studio portal.
	UserRoleArn *string `locationName:"userRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStudioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStudioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStudioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStudioInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}
	if s.StudioId != nil && len(*s.StudioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StudioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminRoleArn sets the AdminRoleArn field's value.
func (s *UpdateStudioInput) SetAdminRoleArn(v string) *UpdateStudioInput {
	s.AdminRoleArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateStudioInput) SetClientToken(v string) *UpdateStudioInput {
	s.ClientToken = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateStudioInput) SetDisplayName(v string) *UpdateStudioInput {
	s.DisplayName = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *UpdateStudioInput) SetStudioId(v string) *UpdateStudioInput {
	s.StudioId = &v
	return s
}

// SetUserRoleArn sets the UserRoleArn field's value.
func (s *UpdateStudioInput) SetUserRoleArn(v string) *UpdateStudioInput {
	s.UserRoleArn = &v
	return s
}

type UpdateStudioOutput struct {
	_ struct{} `type:"structure"`

	// Information about a studio.
	//
	// Studio is a required field
	Studio *Studio `locationName:"studio" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStudioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStudioOutput) GoString() string {
	return s.String()
}

// SetStudio sets the Studio field's value.
func (s *UpdateStudioOutput) SetStudio(v *Studio) *UpdateStudioOutput {
	s.Studio = v
	return s
}

// One of the parameters in the request is invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A more specific error code.
	Code_ *string `locationName:"code" type:"string"`

	// The exception context.
	Context map[string]*string `locationName:"context" type:"map"`

	// A human-readable description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The launch profile validation result.
type ValidationResult struct {
	_ struct{} `type:"structure"`

	// The current state.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"LaunchProfileValidationState"`

	// The status code. This will contain the failure reason if the state is VALIDATION_FAILED.
	//
	// StatusCode is a required field
	StatusCode *string `locationName:"statusCode" type:"string" required:"true" enum:"LaunchProfileValidationStatusCode"`

	// The status message for the validation result.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// The type of the validation result.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"LaunchProfileValidationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationResult) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *ValidationResult) SetState(v string) *ValidationResult {
	s.State = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ValidationResult) SetStatusCode(v string) *ValidationResult {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ValidationResult) SetStatusMessage(v string) *ValidationResult {
	s.StatusMessage = &v
	return s
}

// SetType sets the Type field's value.
func (s *ValidationResult) SetType(v string) *ValidationResult {
	s.Type = &v
	return s
}

const (
	// LaunchProfilePersonaUser is a LaunchProfilePersona enum value
	LaunchProfilePersonaUser = "USER"
)

// LaunchProfilePersona_Values returns all elements of the LaunchProfilePersona enum
func LaunchProfilePersona_Values() []string {
	return []string{
		LaunchProfilePersonaUser,
	}
}

const (
	// LaunchProfilePlatformLinux is a LaunchProfilePlatform enum value
	LaunchProfilePlatformLinux = "LINUX"

	// LaunchProfilePlatformWindows is a LaunchProfilePlatform enum value
	LaunchProfilePlatformWindows = "WINDOWS"
)

// LaunchProfilePlatform_Values returns all elements of the LaunchProfilePlatform enum
func LaunchProfilePlatform_Values() []string {
	return []string{
		LaunchProfilePlatformLinux,
		LaunchProfilePlatformWindows,
	}
}

const (
	// LaunchProfileStateCreateInProgress is a LaunchProfileState enum value
	LaunchProfileStateCreateInProgress = "CREATE_IN_PROGRESS"

	// LaunchProfileStateReady is a LaunchProfileState enum value
	LaunchProfileStateReady = "READY"

	// LaunchProfileStateUpdateInProgress is a LaunchProfileState enum value
	LaunchProfileStateUpdateInProgress = "UPDATE_IN_PROGRESS"

	// LaunchProfileStateDeleteInProgress is a LaunchProfileState enum value
	LaunchProfileStateDeleteInProgress = "DELETE_IN_PROGRESS"

	// LaunchProfileStateDeleted is a LaunchProfileState enum value
	LaunchProfileStateDeleted = "DELETED"

	// LaunchProfileStateDeleteFailed is a LaunchProfileState enum value
	LaunchProfileStateDeleteFailed = "DELETE_FAILED"

	// LaunchProfileStateCreateFailed is a LaunchProfileState enum value
	LaunchProfileStateCreateFailed = "CREATE_FAILED"

	// LaunchProfileStateUpdateFailed is a LaunchProfileState enum value
	LaunchProfileStateUpdateFailed = "UPDATE_FAILED"
)

// LaunchProfileState_Values returns all elements of the LaunchProfileState enum
func LaunchProfileState_Values() []string {
	return []string{
		LaunchProfileStateCreateInProgress,
		LaunchProfileStateReady,
		LaunchProfileStateUpdateInProgress,
		LaunchProfileStateDeleteInProgress,
		LaunchProfileStateDeleted,
		LaunchProfileStateDeleteFailed,
		LaunchProfileStateCreateFailed,
		LaunchProfileStateUpdateFailed,
	}
}

const (
	// LaunchProfileStatusCodeLaunchProfileCreated is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeLaunchProfileCreated = "LAUNCH_PROFILE_CREATED"

	// LaunchProfileStatusCodeLaunchProfileUpdated is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeLaunchProfileUpdated = "LAUNCH_PROFILE_UPDATED"

	// LaunchProfileStatusCodeLaunchProfileDeleted is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeLaunchProfileDeleted = "LAUNCH_PROFILE_DELETED"

	// LaunchProfileStatusCodeLaunchProfileCreateInProgress is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeLaunchProfileCreateInProgress = "LAUNCH_PROFILE_CREATE_IN_PROGRESS"

	// LaunchProfileStatusCodeLaunchProfileUpdateInProgress is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeLaunchProfileUpdateInProgress = "LAUNCH_PROFILE_UPDATE_IN_PROGRESS"

	// LaunchProfileStatusCodeLaunchProfileDeleteInProgress is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeLaunchProfileDeleteInProgress = "LAUNCH_PROFILE_DELETE_IN_PROGRESS"

	// LaunchProfileStatusCodeInternalError is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeInternalError = "INTERNAL_ERROR"

	// LaunchProfileStatusCodeStreamingImageNotFound is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeStreamingImageNotFound = "STREAMING_IMAGE_NOT_FOUND"

	// LaunchProfileStatusCodeStreamingImageNotReady is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeStreamingImageNotReady = "STREAMING_IMAGE_NOT_READY"

	// LaunchProfileStatusCodeLaunchProfileWithStreamSessionsNotDeleted is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeLaunchProfileWithStreamSessionsNotDeleted = "LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED"

	// LaunchProfileStatusCodeEncryptionKeyAccessDenied is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeEncryptionKeyAccessDenied = "ENCRYPTION_KEY_ACCESS_DENIED"

	// LaunchProfileStatusCodeEncryptionKeyNotFound is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeEncryptionKeyNotFound = "ENCRYPTION_KEY_NOT_FOUND"

	// LaunchProfileStatusCodeInvalidSubnetsProvided is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeInvalidSubnetsProvided = "INVALID_SUBNETS_PROVIDED"

	// LaunchProfileStatusCodeInvalidInstanceTypesProvided is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeInvalidInstanceTypesProvided = "INVALID_INSTANCE_TYPES_PROVIDED"

	// LaunchProfileStatusCodeInvalidSubnetsCombination is a LaunchProfileStatusCode enum value
	LaunchProfileStatusCodeInvalidSubnetsCombination = "INVALID_SUBNETS_COMBINATION"
)

// LaunchProfileStatusCode_Values returns all elements of the LaunchProfileStatusCode enum
func LaunchProfileStatusCode_Values() []string {
	return []string{
		LaunchProfileStatusCodeLaunchProfileCreated,
		LaunchProfileStatusCodeLaunchProfileUpdated,
		LaunchProfileStatusCodeLaunchProfileDeleted,
		LaunchProfileStatusCodeLaunchProfileCreateInProgress,
		LaunchProfileStatusCodeLaunchProfileUpdateInProgress,
		LaunchProfileStatusCodeLaunchProfileDeleteInProgress,
		LaunchProfileStatusCodeInternalError,
		LaunchProfileStatusCodeStreamingImageNotFound,
		LaunchProfileStatusCodeStreamingImageNotReady,
		LaunchProfileStatusCodeLaunchProfileWithStreamSessionsNotDeleted,
		LaunchProfileStatusCodeEncryptionKeyAccessDenied,
		LaunchProfileStatusCodeEncryptionKeyNotFound,
		LaunchProfileStatusCodeInvalidSubnetsProvided,
		LaunchProfileStatusCodeInvalidInstanceTypesProvided,
		LaunchProfileStatusCodeInvalidSubnetsCombination,
	}
}

const (
	// LaunchProfileValidationStateValidationNotStarted is a LaunchProfileValidationState enum value
	LaunchProfileValidationStateValidationNotStarted = "VALIDATION_NOT_STARTED"

	// LaunchProfileValidationStateValidationInProgress is a LaunchProfileValidationState enum value
	LaunchProfileValidationStateValidationInProgress = "VALIDATION_IN_PROGRESS"

	// LaunchProfileValidationStateValidationSuccess is a LaunchProfileValidationState enum value
	LaunchProfileValidationStateValidationSuccess = "VALIDATION_SUCCESS"

	// LaunchProfileValidationStateValidationFailed is a LaunchProfileValidationState enum value
	LaunchProfileValidationStateValidationFailed = "VALIDATION_FAILED"

	// LaunchProfileValidationStateValidationFailedInternalServerError is a LaunchProfileValidationState enum value
	LaunchProfileValidationStateValidationFailedInternalServerError = "VALIDATION_FAILED_INTERNAL_SERVER_ERROR"
)

// LaunchProfileValidationState_Values returns all elements of the LaunchProfileValidationState enum
func LaunchProfileValidationState_Values() []string {
	return []string{
		LaunchProfileValidationStateValidationNotStarted,
		LaunchProfileValidationStateValidationInProgress,
		LaunchProfileValidationStateValidationSuccess,
		LaunchProfileValidationStateValidationFailed,
		LaunchProfileValidationStateValidationFailedInternalServerError,
	}
}

const (
	// LaunchProfileValidationStatusCodeValidationNotStarted is a LaunchProfileValidationStatusCode enum value
	LaunchProfileValidationStatusCodeValidationNotStarted = "VALIDATION_NOT_STARTED"

	// LaunchProfileValidationStatusCodeValidationInProgress is a LaunchProfileValidationStatusCode enum value
	LaunchProfileValidationStatusCodeValidationInProgress = "VALIDATION_IN_PROGRESS"

	// LaunchProfileValidationStatusCodeValidationSuccess is a LaunchProfileValidationStatusCode enum value
	LaunchProfileValidationStatusCodeValidationSuccess = "VALIDATION_SUCCESS"

	// LaunchProfileValidationStatusCodeValidationFailedInvalidSubnetRouteTableAssociation is a LaunchProfileValidationStatusCode enum value
	LaunchProfileValidationStatusCodeValidationFailedInvalidSubnetRouteTableAssociation = "VALIDATION_FAILED_INVALID_SUBNET_ROUTE_TABLE_ASSOCIATION"

	// LaunchProfileValidationStatusCodeValidationFailedSubnetNotFound is a LaunchProfileValidationStatusCode enum value
	LaunchProfileValidationStatusCodeValidationFailedSubnetNotFound = "VALIDATION_FAILED_SUBNET_NOT_FOUND"

	// LaunchProfileValidationStatusCodeValidationFailedInvalidSecurityGroupAssociation is a LaunchProfileValidationStatusCode enum value
	LaunchProfileValidationStatusCodeValidationFailedInvalidSecurityGroupAssociation = "VALIDATION_FAILED_INVALID_SECURITY_GROUP_ASSOCIATION"

	// LaunchProfileValidationStatusCodeValidationFailedInvalidActiveDirectory is a LaunchProfileValidationStatusCode enum value
	LaunchProfileValidationStatusCodeValidationFailedInvalidActiveDirectory = "VALIDATION_FAILED_INVALID_ACTIVE_DIRECTORY"

	// LaunchProfileValidationStatusCodeValidationFailedUnauthorized is a LaunchProfileValidationStatusCode enum value
	LaunchProfileValidationStatusCodeValidationFailedUnauthorized = "VALIDATION_FAILED_UNAUTHORIZED"

	// LaunchProfileValidationStatusCodeValidationFailedInternalServerError is a LaunchProfileValidationStatusCode enum value
	LaunchProfileValidationStatusCodeValidationFailedInternalServerError = "VALIDATION_FAILED_INTERNAL_SERVER_ERROR"
)

// LaunchProfileValidationStatusCode_Values returns all elements of the LaunchProfileValidationStatusCode enum
func LaunchProfileValidationStatusCode_Values() []string {
	return []string{
		LaunchProfileValidationStatusCodeValidationNotStarted,
		LaunchProfileValidationStatusCodeValidationInProgress,
		LaunchProfileValidationStatusCodeValidationSuccess,
		LaunchProfileValidationStatusCodeValidationFailedInvalidSubnetRouteTableAssociation,
		LaunchProfileValidationStatusCodeValidationFailedSubnetNotFound,
		LaunchProfileValidationStatusCodeValidationFailedInvalidSecurityGroupAssociation,
		LaunchProfileValidationStatusCodeValidationFailedInvalidActiveDirectory,
		LaunchProfileValidationStatusCodeValidationFailedUnauthorized,
		LaunchProfileValidationStatusCodeValidationFailedInternalServerError,
	}
}

const (
	// LaunchProfileValidationTypeValidateActiveDirectoryStudioComponent is a LaunchProfileValidationType enum value
	LaunchProfileValidationTypeValidateActiveDirectoryStudioComponent = "VALIDATE_ACTIVE_DIRECTORY_STUDIO_COMPONENT"

	// LaunchProfileValidationTypeValidateSubnetAssociation is a LaunchProfileValidationType enum value
	LaunchProfileValidationTypeValidateSubnetAssociation = "VALIDATE_SUBNET_ASSOCIATION"

	// LaunchProfileValidationTypeValidateNetworkAclAssociation is a LaunchProfileValidationType enum value
	LaunchProfileValidationTypeValidateNetworkAclAssociation = "VALIDATE_NETWORK_ACL_ASSOCIATION"

	// LaunchProfileValidationTypeValidateSecurityGroupAssociation is a LaunchProfileValidationType enum value
	LaunchProfileValidationTypeValidateSecurityGroupAssociation = "VALIDATE_SECURITY_GROUP_ASSOCIATION"
)

// LaunchProfileValidationType_Values returns all elements of the LaunchProfileValidationType enum
func LaunchProfileValidationType_Values() []string {
	return []string{
		LaunchProfileValidationTypeValidateActiveDirectoryStudioComponent,
		LaunchProfileValidationTypeValidateSubnetAssociation,
		LaunchProfileValidationTypeValidateNetworkAclAssociation,
		LaunchProfileValidationTypeValidateSecurityGroupAssociation,
	}
}

const (
	// StreamingClipboardModeEnabled is a StreamingClipboardMode enum value
	StreamingClipboardModeEnabled = "ENABLED"

	// StreamingClipboardModeDisabled is a StreamingClipboardMode enum value
	StreamingClipboardModeDisabled = "DISABLED"
)

// StreamingClipboardMode_Values returns all elements of the StreamingClipboardMode enum
func StreamingClipboardMode_Values() []string {
	return []string{
		StreamingClipboardModeEnabled,
		StreamingClipboardModeDisabled,
	}
}

const (
	// StreamingImageEncryptionConfigurationKeyTypeCustomerManagedKey is a StreamingImageEncryptionConfigurationKeyType enum value
	StreamingImageEncryptionConfigurationKeyTypeCustomerManagedKey = "CUSTOMER_MANAGED_KEY"
)

// StreamingImageEncryptionConfigurationKeyType_Values returns all elements of the StreamingImageEncryptionConfigurationKeyType enum
func StreamingImageEncryptionConfigurationKeyType_Values() []string {
	return []string{
		StreamingImageEncryptionConfigurationKeyTypeCustomerManagedKey,
	}
}

const (
	// StreamingImageStateCreateInProgress is a StreamingImageState enum value
	StreamingImageStateCreateInProgress = "CREATE_IN_PROGRESS"

	// StreamingImageStateReady is a StreamingImageState enum value
	StreamingImageStateReady = "READY"

	// StreamingImageStateDeleteInProgress is a StreamingImageState enum value
	StreamingImageStateDeleteInProgress = "DELETE_IN_PROGRESS"

	// StreamingImageStateDeleted is a StreamingImageState enum value
	StreamingImageStateDeleted = "DELETED"

	// StreamingImageStateUpdateInProgress is a StreamingImageState enum value
	StreamingImageStateUpdateInProgress = "UPDATE_IN_PROGRESS"

	// StreamingImageStateUpdateFailed is a StreamingImageState enum value
	StreamingImageStateUpdateFailed = "UPDATE_FAILED"

	// StreamingImageStateCreateFailed is a StreamingImageState enum value
	StreamingImageStateCreateFailed = "CREATE_FAILED"

	// StreamingImageStateDeleteFailed is a StreamingImageState enum value
	StreamingImageStateDeleteFailed = "DELETE_FAILED"
)

// StreamingImageState_Values returns all elements of the StreamingImageState enum
func StreamingImageState_Values() []string {
	return []string{
		StreamingImageStateCreateInProgress,
		StreamingImageStateReady,
		StreamingImageStateDeleteInProgress,
		StreamingImageStateDeleted,
		StreamingImageStateUpdateInProgress,
		StreamingImageStateUpdateFailed,
		StreamingImageStateCreateFailed,
		StreamingImageStateDeleteFailed,
	}
}

// The status code.
const (
	// StreamingImageStatusCodeStreamingImageCreateInProgress is a StreamingImageStatusCode enum value
	StreamingImageStatusCodeStreamingImageCreateInProgress = "STREAMING_IMAGE_CREATE_IN_PROGRESS"

	// StreamingImageStatusCodeStreamingImageReady is a StreamingImageStatusCode enum value
	StreamingImageStatusCodeStreamingImageReady = "STREAMING_IMAGE_READY"

	// StreamingImageStatusCodeStreamingImageDeleteInProgress is a StreamingImageStatusCode enum value
	StreamingImageStatusCodeStreamingImageDeleteInProgress = "STREAMING_IMAGE_DELETE_IN_PROGRESS"

	// StreamingImageStatusCodeStreamingImageDeleted is a StreamingImageStatusCode enum value
	StreamingImageStatusCodeStreamingImageDeleted = "STREAMING_IMAGE_DELETED"

	// StreamingImageStatusCodeStreamingImageUpdateInProgress is a StreamingImageStatusCode enum value
	StreamingImageStatusCodeStreamingImageUpdateInProgress = "STREAMING_IMAGE_UPDATE_IN_PROGRESS"

	// StreamingImageStatusCodeInternalError is a StreamingImageStatusCode enum value
	StreamingImageStatusCodeInternalError = "INTERNAL_ERROR"

	// StreamingImageStatusCodeAccessDenied is a StreamingImageStatusCode enum value
	StreamingImageStatusCodeAccessDenied = "ACCESS_DENIED"
)

// StreamingImageStatusCode_Values returns all elements of the StreamingImageStatusCode enum
func StreamingImageStatusCode_Values() []string {
	return []string{
		StreamingImageStatusCodeStreamingImageCreateInProgress,
		StreamingImageStatusCodeStreamingImageReady,
		StreamingImageStatusCodeStreamingImageDeleteInProgress,
		StreamingImageStatusCodeStreamingImageDeleted,
		StreamingImageStatusCodeStreamingImageUpdateInProgress,
		StreamingImageStatusCodeInternalError,
		StreamingImageStatusCodeAccessDenied,
	}
}

const (
	// StreamingInstanceTypeG4dnXlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG4dnXlarge = "g4dn.xlarge"

	// StreamingInstanceTypeG4dn2xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG4dn2xlarge = "g4dn.2xlarge"

	// StreamingInstanceTypeG4dn4xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG4dn4xlarge = "g4dn.4xlarge"

	// StreamingInstanceTypeG4dn8xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG4dn8xlarge = "g4dn.8xlarge"

	// StreamingInstanceTypeG4dn12xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG4dn12xlarge = "g4dn.12xlarge"

	// StreamingInstanceTypeG4dn16xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG4dn16xlarge = "g4dn.16xlarge"

	// StreamingInstanceTypeG34xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG34xlarge = "g3.4xlarge"

	// StreamingInstanceTypeG3sXlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG3sXlarge = "g3s.xlarge"

	// StreamingInstanceTypeG5Xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG5Xlarge = "g5.xlarge"

	// StreamingInstanceTypeG52xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG52xlarge = "g5.2xlarge"

	// StreamingInstanceTypeG54xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG54xlarge = "g5.4xlarge"

	// StreamingInstanceTypeG58xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG58xlarge = "g5.8xlarge"

	// StreamingInstanceTypeG516xlarge is a StreamingInstanceType enum value
	StreamingInstanceTypeG516xlarge = "g5.16xlarge"
)

// StreamingInstanceType_Values returns all elements of the StreamingInstanceType enum
func StreamingInstanceType_Values() []string {
	return []string{
		StreamingInstanceTypeG4dnXlarge,
		StreamingInstanceTypeG4dn2xlarge,
		StreamingInstanceTypeG4dn4xlarge,
		StreamingInstanceTypeG4dn8xlarge,
		StreamingInstanceTypeG4dn12xlarge,
		StreamingInstanceTypeG4dn16xlarge,
		StreamingInstanceTypeG34xlarge,
		StreamingInstanceTypeG3sXlarge,
		StreamingInstanceTypeG5Xlarge,
		StreamingInstanceTypeG52xlarge,
		StreamingInstanceTypeG54xlarge,
		StreamingInstanceTypeG58xlarge,
		StreamingInstanceTypeG516xlarge,
	}
}

// The streaming session state.
const (
	// StreamingSessionStateCreateInProgress is a StreamingSessionState enum value
	StreamingSessionStateCreateInProgress = "CREATE_IN_PROGRESS"

	// StreamingSessionStateDeleteInProgress is a StreamingSessionState enum value
	StreamingSessionStateDeleteInProgress = "DELETE_IN_PROGRESS"

	// StreamingSessionStateReady is a StreamingSessionState enum value
	StreamingSessionStateReady = "READY"

	// StreamingSessionStateDeleted is a StreamingSessionState enum value
	StreamingSessionStateDeleted = "DELETED"

	// StreamingSessionStateCreateFailed is a StreamingSessionState enum value
	StreamingSessionStateCreateFailed = "CREATE_FAILED"

	// StreamingSessionStateDeleteFailed is a StreamingSessionState enum value
	StreamingSessionStateDeleteFailed = "DELETE_FAILED"

	// StreamingSessionStateStopInProgress is a StreamingSessionState enum value
	StreamingSessionStateStopInProgress = "STOP_IN_PROGRESS"

	// StreamingSessionStateStartInProgress is a StreamingSessionState enum value
	StreamingSessionStateStartInProgress = "START_IN_PROGRESS"

	// StreamingSessionStateStopped is a StreamingSessionState enum value
	StreamingSessionStateStopped = "STOPPED"

	// StreamingSessionStateStopFailed is a StreamingSessionState enum value
	StreamingSessionStateStopFailed = "STOP_FAILED"

	// StreamingSessionStateStartFailed is a StreamingSessionState enum value
	StreamingSessionStateStartFailed = "START_FAILED"
)

// StreamingSessionState_Values returns all elements of the StreamingSessionState enum
func StreamingSessionState_Values() []string {
	return []string{
		StreamingSessionStateCreateInProgress,
		StreamingSessionStateDeleteInProgress,
		StreamingSessionStateReady,
		StreamingSessionStateDeleted,
		StreamingSessionStateCreateFailed,
		StreamingSessionStateDeleteFailed,
		StreamingSessionStateStopInProgress,
		StreamingSessionStateStartInProgress,
		StreamingSessionStateStopped,
		StreamingSessionStateStopFailed,
		StreamingSessionStateStartFailed,
	}
}

const (
	// StreamingSessionStatusCodeStreamingSessionReady is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeStreamingSessionReady = "STREAMING_SESSION_READY"

	// StreamingSessionStatusCodeStreamingSessionDeleted is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeStreamingSessionDeleted = "STREAMING_SESSION_DELETED"

	// StreamingSessionStatusCodeStreamingSessionCreateInProgress is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeStreamingSessionCreateInProgress = "STREAMING_SESSION_CREATE_IN_PROGRESS"

	// StreamingSessionStatusCodeStreamingSessionDeleteInProgress is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeStreamingSessionDeleteInProgress = "STREAMING_SESSION_DELETE_IN_PROGRESS"

	// StreamingSessionStatusCodeInternalError is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeInternalError = "INTERNAL_ERROR"

	// StreamingSessionStatusCodeInsufficientCapacity is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeInsufficientCapacity = "INSUFFICIENT_CAPACITY"

	// StreamingSessionStatusCodeActiveDirectoryDomainJoinError is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeActiveDirectoryDomainJoinError = "ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR"

	// StreamingSessionStatusCodeNetworkConnectionError is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeNetworkConnectionError = "NETWORK_CONNECTION_ERROR"

	// StreamingSessionStatusCodeInitializationScriptError is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeInitializationScriptError = "INITIALIZATION_SCRIPT_ERROR"

	// StreamingSessionStatusCodeDecryptStreamingImageError is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeDecryptStreamingImageError = "DECRYPT_STREAMING_IMAGE_ERROR"

	// StreamingSessionStatusCodeNetworkInterfaceError is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeNetworkInterfaceError = "NETWORK_INTERFACE_ERROR"

	// StreamingSessionStatusCodeStreamingSessionStopped is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeStreamingSessionStopped = "STREAMING_SESSION_STOPPED"

	// StreamingSessionStatusCodeStreamingSessionStarted is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeStreamingSessionStarted = "STREAMING_SESSION_STARTED"

	// StreamingSessionStatusCodeStreamingSessionStopInProgress is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeStreamingSessionStopInProgress = "STREAMING_SESSION_STOP_IN_PROGRESS"

	// StreamingSessionStatusCodeStreamingSessionStartInProgress is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeStreamingSessionStartInProgress = "STREAMING_SESSION_START_IN_PROGRESS"

	// StreamingSessionStatusCodeAmiValidationError is a StreamingSessionStatusCode enum value
	StreamingSessionStatusCodeAmiValidationError = "AMI_VALIDATION_ERROR"
)

// StreamingSessionStatusCode_Values returns all elements of the StreamingSessionStatusCode enum
func StreamingSessionStatusCode_Values() []string {
	return []string{
		StreamingSessionStatusCodeStreamingSessionReady,
		StreamingSessionStatusCodeStreamingSessionDeleted,
		StreamingSessionStatusCodeStreamingSessionCreateInProgress,
		StreamingSessionStatusCodeStreamingSessionDeleteInProgress,
		StreamingSessionStatusCodeInternalError,
		StreamingSessionStatusCodeInsufficientCapacity,
		StreamingSessionStatusCodeActiveDirectoryDomainJoinError,
		StreamingSessionStatusCodeNetworkConnectionError,
		StreamingSessionStatusCodeInitializationScriptError,
		StreamingSessionStatusCodeDecryptStreamingImageError,
		StreamingSessionStatusCodeNetworkInterfaceError,
		StreamingSessionStatusCodeStreamingSessionStopped,
		StreamingSessionStatusCodeStreamingSessionStarted,
		StreamingSessionStatusCodeStreamingSessionStopInProgress,
		StreamingSessionStatusCodeStreamingSessionStartInProgress,
		StreamingSessionStatusCodeAmiValidationError,
	}
}

const (
	// StreamingSessionStorageModeUpload is a StreamingSessionStorageMode enum value
	StreamingSessionStorageModeUpload = "UPLOAD"
)

// StreamingSessionStorageMode_Values returns all elements of the StreamingSessionStorageMode enum
func StreamingSessionStorageMode_Values() []string {
	return []string{
		StreamingSessionStorageModeUpload,
	}
}

const (
	// StreamingSessionStreamStateReady is a StreamingSessionStreamState enum value
	StreamingSessionStreamStateReady = "READY"

	// StreamingSessionStreamStateCreateInProgress is a StreamingSessionStreamState enum value
	StreamingSessionStreamStateCreateInProgress = "CREATE_IN_PROGRESS"

	// StreamingSessionStreamStateDeleteInProgress is a StreamingSessionStreamState enum value
	StreamingSessionStreamStateDeleteInProgress = "DELETE_IN_PROGRESS"

	// StreamingSessionStreamStateDeleted is a StreamingSessionStreamState enum value
	StreamingSessionStreamStateDeleted = "DELETED"

	// StreamingSessionStreamStateCreateFailed is a StreamingSessionStreamState enum value
	StreamingSessionStreamStateCreateFailed = "CREATE_FAILED"

	// StreamingSessionStreamStateDeleteFailed is a StreamingSessionStreamState enum value
	StreamingSessionStreamStateDeleteFailed = "DELETE_FAILED"
)

// StreamingSessionStreamState_Values returns all elements of the StreamingSessionStreamState enum
func StreamingSessionStreamState_Values() []string {
	return []string{
		StreamingSessionStreamStateReady,
		StreamingSessionStreamStateCreateInProgress,
		StreamingSessionStreamStateDeleteInProgress,
		StreamingSessionStreamStateDeleted,
		StreamingSessionStreamStateCreateFailed,
		StreamingSessionStreamStateDeleteFailed,
	}
}

const (
	// StreamingSessionStreamStatusCodeStreamCreateInProgress is a StreamingSessionStreamStatusCode enum value
	StreamingSessionStreamStatusCodeStreamCreateInProgress = "STREAM_CREATE_IN_PROGRESS"

	// StreamingSessionStreamStatusCodeStreamReady is a StreamingSessionStreamStatusCode enum value
	StreamingSessionStreamStatusCodeStreamReady = "STREAM_READY"

	// StreamingSessionStreamStatusCodeStreamDeleteInProgress is a StreamingSessionStreamStatusCode enum value
	StreamingSessionStreamStatusCodeStreamDeleteInProgress = "STREAM_DELETE_IN_PROGRESS"

	// StreamingSessionStreamStatusCodeStreamDeleted is a StreamingSessionStreamStatusCode enum value
	StreamingSessionStreamStatusCodeStreamDeleted = "STREAM_DELETED"

	// StreamingSessionStreamStatusCodeInternalError is a StreamingSessionStreamStatusCode enum value
	StreamingSessionStreamStatusCodeInternalError = "INTERNAL_ERROR"

	// StreamingSessionStreamStatusCodeNetworkConnectionError is a StreamingSessionStreamStatusCode enum value
	StreamingSessionStreamStatusCodeNetworkConnectionError = "NETWORK_CONNECTION_ERROR"
)

// StreamingSessionStreamStatusCode_Values returns all elements of the StreamingSessionStreamStatusCode enum
func StreamingSessionStreamStatusCode_Values() []string {
	return []string{
		StreamingSessionStreamStatusCodeStreamCreateInProgress,
		StreamingSessionStreamStatusCodeStreamReady,
		StreamingSessionStreamStatusCodeStreamDeleteInProgress,
		StreamingSessionStreamStatusCodeStreamDeleted,
		StreamingSessionStreamStatusCodeInternalError,
		StreamingSessionStreamStatusCodeNetworkConnectionError,
	}
}

const (
	// StudioComponentInitializationScriptRunContextSystemInitialization is a StudioComponentInitializationScriptRunContext enum value
	StudioComponentInitializationScriptRunContextSystemInitialization = "SYSTEM_INITIALIZATION"

	// StudioComponentInitializationScriptRunContextUserInitialization is a StudioComponentInitializationScriptRunContext enum value
	StudioComponentInitializationScriptRunContextUserInitialization = "USER_INITIALIZATION"
)

// StudioComponentInitializationScriptRunContext_Values returns all elements of the StudioComponentInitializationScriptRunContext enum
func StudioComponentInitializationScriptRunContext_Values() []string {
	return []string{
		StudioComponentInitializationScriptRunContextSystemInitialization,
		StudioComponentInitializationScriptRunContextUserInitialization,
	}
}

// The current state of the studio component resource.
//
// While a studio component is being created, modified, or deleted, its state
// will equal "CREATE_IN_PROGRESS", "UPDATE_IN_PROGRESS", or "DELETE_IN_PROGRESS"
//
// These are called 'transition states'.
//
// No modifications may be made to the studio component while it is in a transition
// state.
//
// If creation of the resource fails, the state will change to `CREATE_FAILED`.
// The resource StatusCode and StatusMessage will provide more information of
// why creation failed. The resource in this state will automatically be deleted
// from your account after a period of time.
//
// If updating the resource fails, the state will change to `UPDATE_FAILED`.
// The resource StatusCode and StatusMessage will provide more information of
// why the update failed. The resource will be returned to the state it was
// in when the update request was invoked.
//
// If deleting the resource fails, the state will change to `DELETE_FAILED`.
// The resource StatusCode and StatusMessage will provide more information of
// why the update failed. The resource will be returned to the state it was
// in when the update request was invoked. After the resource is deleted successfully,
// it will change to the "DELETED" state. The resource will no longer count
// against service quotas and cannot be used or acted upon any futher. It will
// be removed from your account after a period of time.
const (
	// StudioComponentStateCreateInProgress is a StudioComponentState enum value
	StudioComponentStateCreateInProgress = "CREATE_IN_PROGRESS"

	// StudioComponentStateReady is a StudioComponentState enum value
	StudioComponentStateReady = "READY"

	// StudioComponentStateUpdateInProgress is a StudioComponentState enum value
	StudioComponentStateUpdateInProgress = "UPDATE_IN_PROGRESS"

	// StudioComponentStateDeleteInProgress is a StudioComponentState enum value
	StudioComponentStateDeleteInProgress = "DELETE_IN_PROGRESS"

	// StudioComponentStateDeleted is a StudioComponentState enum value
	StudioComponentStateDeleted = "DELETED"

	// StudioComponentStateDeleteFailed is a StudioComponentState enum value
	StudioComponentStateDeleteFailed = "DELETE_FAILED"

	// StudioComponentStateCreateFailed is a StudioComponentState enum value
	StudioComponentStateCreateFailed = "CREATE_FAILED"

	// StudioComponentStateUpdateFailed is a StudioComponentState enum value
	StudioComponentStateUpdateFailed = "UPDATE_FAILED"
)

// StudioComponentState_Values returns all elements of the StudioComponentState enum
func StudioComponentState_Values() []string {
	return []string{
		StudioComponentStateCreateInProgress,
		StudioComponentStateReady,
		StudioComponentStateUpdateInProgress,
		StudioComponentStateDeleteInProgress,
		StudioComponentStateDeleted,
		StudioComponentStateDeleteFailed,
		StudioComponentStateCreateFailed,
		StudioComponentStateUpdateFailed,
	}
}

// The current status of the studio component resource.
//
// When the resource is in the 'READY' state, the status code signals what the
// last mutation made to the resource was.
//
// When the resource is in a CREATE_FAILED/UPDATE_FAILED/DELETE_FAILED state,
// the status code signals what went wrong and why the mutation failed.
const (
	// StudioComponentStatusCodeActiveDirectoryAlreadyExists is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeActiveDirectoryAlreadyExists = "ACTIVE_DIRECTORY_ALREADY_EXISTS"

	// StudioComponentStatusCodeStudioComponentCreated is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeStudioComponentCreated = "STUDIO_COMPONENT_CREATED"

	// StudioComponentStatusCodeStudioComponentUpdated is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeStudioComponentUpdated = "STUDIO_COMPONENT_UPDATED"

	// StudioComponentStatusCodeStudioComponentDeleted is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeStudioComponentDeleted = "STUDIO_COMPONENT_DELETED"

	// StudioComponentStatusCodeEncryptionKeyAccessDenied is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeEncryptionKeyAccessDenied = "ENCRYPTION_KEY_ACCESS_DENIED"

	// StudioComponentStatusCodeEncryptionKeyNotFound is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeEncryptionKeyNotFound = "ENCRYPTION_KEY_NOT_FOUND"

	// StudioComponentStatusCodeStudioComponentCreateInProgress is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeStudioComponentCreateInProgress = "STUDIO_COMPONENT_CREATE_IN_PROGRESS"

	// StudioComponentStatusCodeStudioComponentUpdateInProgress is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeStudioComponentUpdateInProgress = "STUDIO_COMPONENT_UPDATE_IN_PROGRESS"

	// StudioComponentStatusCodeStudioComponentDeleteInProgress is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeStudioComponentDeleteInProgress = "STUDIO_COMPONENT_DELETE_IN_PROGRESS"

	// StudioComponentStatusCodeInternalError is a StudioComponentStatusCode enum value
	StudioComponentStatusCodeInternalError = "INTERNAL_ERROR"
)

// StudioComponentStatusCode_Values returns all elements of the StudioComponentStatusCode enum
func StudioComponentStatusCode_Values() []string {
	return []string{
		StudioComponentStatusCodeActiveDirectoryAlreadyExists,
		StudioComponentStatusCodeStudioComponentCreated,
		StudioComponentStatusCodeStudioComponentUpdated,
		StudioComponentStatusCodeStudioComponentDeleted,
		StudioComponentStatusCodeEncryptionKeyAccessDenied,
		StudioComponentStatusCodeEncryptionKeyNotFound,
		StudioComponentStatusCodeStudioComponentCreateInProgress,
		StudioComponentStatusCodeStudioComponentUpdateInProgress,
		StudioComponentStatusCodeStudioComponentDeleteInProgress,
		StudioComponentStatusCodeInternalError,
	}
}

const (
	// StudioComponentSubtypeAwsManagedMicrosoftAd is a StudioComponentSubtype enum value
	StudioComponentSubtypeAwsManagedMicrosoftAd = "AWS_MANAGED_MICROSOFT_AD"

	// StudioComponentSubtypeAmazonFsxForWindows is a StudioComponentSubtype enum value
	StudioComponentSubtypeAmazonFsxForWindows = "AMAZON_FSX_FOR_WINDOWS"

	// StudioComponentSubtypeAmazonFsxForLustre is a StudioComponentSubtype enum value
	StudioComponentSubtypeAmazonFsxForLustre = "AMAZON_FSX_FOR_LUSTRE"

	// StudioComponentSubtypeCustom is a StudioComponentSubtype enum value
	StudioComponentSubtypeCustom = "CUSTOM"
)

// StudioComponentSubtype_Values returns all elements of the StudioComponentSubtype enum
func StudioComponentSubtype_Values() []string {
	return []string{
		StudioComponentSubtypeAwsManagedMicrosoftAd,
		StudioComponentSubtypeAmazonFsxForWindows,
		StudioComponentSubtypeAmazonFsxForLustre,
		StudioComponentSubtypeCustom,
	}
}

const (
	// StudioComponentTypeActiveDirectory is a StudioComponentType enum value
	StudioComponentTypeActiveDirectory = "ACTIVE_DIRECTORY"

	// StudioComponentTypeSharedFileSystem is a StudioComponentType enum value
	StudioComponentTypeSharedFileSystem = "SHARED_FILE_SYSTEM"

	// StudioComponentTypeComputeFarm is a StudioComponentType enum value
	StudioComponentTypeComputeFarm = "COMPUTE_FARM"

	// StudioComponentTypeLicenseService is a StudioComponentType enum value
	StudioComponentTypeLicenseService = "LICENSE_SERVICE"

	// StudioComponentTypeCustom is a StudioComponentType enum value
	StudioComponentTypeCustom = "CUSTOM"
)

// StudioComponentType_Values returns all elements of the StudioComponentType enum
func StudioComponentType_Values() []string {
	return []string{
		StudioComponentTypeActiveDirectory,
		StudioComponentTypeSharedFileSystem,
		StudioComponentTypeComputeFarm,
		StudioComponentTypeLicenseService,
		StudioComponentTypeCustom,
	}
}

// The type of KMS key that is used to encrypt studio data.
const (
	// StudioEncryptionConfigurationKeyTypeAwsOwnedKey is a StudioEncryptionConfigurationKeyType enum value
	StudioEncryptionConfigurationKeyTypeAwsOwnedKey = "AWS_OWNED_KEY"

	// StudioEncryptionConfigurationKeyTypeCustomerManagedKey is a StudioEncryptionConfigurationKeyType enum value
	StudioEncryptionConfigurationKeyTypeCustomerManagedKey = "CUSTOMER_MANAGED_KEY"
)

// StudioEncryptionConfigurationKeyType_Values returns all elements of the StudioEncryptionConfigurationKeyType enum
func StudioEncryptionConfigurationKeyType_Values() []string {
	return []string{
		StudioEncryptionConfigurationKeyTypeAwsOwnedKey,
		StudioEncryptionConfigurationKeyTypeCustomerManagedKey,
	}
}

const (
	// StudioPersonaAdministrator is a StudioPersona enum value
	StudioPersonaAdministrator = "ADMINISTRATOR"
)

// StudioPersona_Values returns all elements of the StudioPersona enum
func StudioPersona_Values() []string {
	return []string{
		StudioPersonaAdministrator,
	}
}

const (
	// StudioStateCreateInProgress is a StudioState enum value
	StudioStateCreateInProgress = "CREATE_IN_PROGRESS"

	// StudioStateReady is a StudioState enum value
	StudioStateReady = "READY"

	// StudioStateUpdateInProgress is a StudioState enum value
	StudioStateUpdateInProgress = "UPDATE_IN_PROGRESS"

	// StudioStateDeleteInProgress is a StudioState enum value
	StudioStateDeleteInProgress = "DELETE_IN_PROGRESS"

	// StudioStateDeleted is a StudioState enum value
	StudioStateDeleted = "DELETED"

	// StudioStateDeleteFailed is a StudioState enum value
	StudioStateDeleteFailed = "DELETE_FAILED"

	// StudioStateCreateFailed is a StudioState enum value
	StudioStateCreateFailed = "CREATE_FAILED"

	// StudioStateUpdateFailed is a StudioState enum value
	StudioStateUpdateFailed = "UPDATE_FAILED"
)

// StudioState_Values returns all elements of the StudioState enum
func StudioState_Values() []string {
	return []string{
		StudioStateCreateInProgress,
		StudioStateReady,
		StudioStateUpdateInProgress,
		StudioStateDeleteInProgress,
		StudioStateDeleted,
		StudioStateDeleteFailed,
		StudioStateCreateFailed,
		StudioStateUpdateFailed,
	}
}

// The status code.
const (
	// StudioStatusCodeStudioCreated is a StudioStatusCode enum value
	StudioStatusCodeStudioCreated = "STUDIO_CREATED"

	// StudioStatusCodeStudioDeleted is a StudioStatusCode enum value
	StudioStatusCodeStudioDeleted = "STUDIO_DELETED"

	// StudioStatusCodeStudioUpdated is a StudioStatusCode enum value
	StudioStatusCodeStudioUpdated = "STUDIO_UPDATED"

	// StudioStatusCodeStudioCreateInProgress is a StudioStatusCode enum value
	StudioStatusCodeStudioCreateInProgress = "STUDIO_CREATE_IN_PROGRESS"

	// StudioStatusCodeStudioUpdateInProgress is a StudioStatusCode enum value
	StudioStatusCodeStudioUpdateInProgress = "STUDIO_UPDATE_IN_PROGRESS"

	// StudioStatusCodeStudioDeleteInProgress is a StudioStatusCode enum value
	StudioStatusCodeStudioDeleteInProgress = "STUDIO_DELETE_IN_PROGRESS"

	// StudioStatusCodeStudioWithLaunchProfilesNotDeleted is a StudioStatusCode enum value
	StudioStatusCodeStudioWithLaunchProfilesNotDeleted = "STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED"

	// StudioStatusCodeStudioWithStudioComponentsNotDeleted is a StudioStatusCode enum value
	StudioStatusCodeStudioWithStudioComponentsNotDeleted = "STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED"

	// StudioStatusCodeStudioWithStreamingImagesNotDeleted is a StudioStatusCode enum value
	StudioStatusCodeStudioWithStreamingImagesNotDeleted = "STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED"

	// StudioStatusCodeAwsSsoNotEnabled is a StudioStatusCode enum value
	StudioStatusCodeAwsSsoNotEnabled = "AWS_SSO_NOT_ENABLED"

	// StudioStatusCodeAwsSsoAccessDenied is a StudioStatusCode enum value
	StudioStatusCodeAwsSsoAccessDenied = "AWS_SSO_ACCESS_DENIED"

	// StudioStatusCodeRoleNotOwnedByStudioOwner is a StudioStatusCode enum value
	StudioStatusCodeRoleNotOwnedByStudioOwner = "ROLE_NOT_OWNED_BY_STUDIO_OWNER"

	// StudioStatusCodeRoleCouldNotBeAssumed is a StudioStatusCode enum value
	StudioStatusCodeRoleCouldNotBeAssumed = "ROLE_COULD_NOT_BE_ASSUMED"

	// StudioStatusCodeInternalError is a StudioStatusCode enum value
	StudioStatusCodeInternalError = "INTERNAL_ERROR"

	// StudioStatusCodeEncryptionKeyNotFound is a StudioStatusCode enum value
	StudioStatusCodeEncryptionKeyNotFound = "ENCRYPTION_KEY_NOT_FOUND"

	// StudioStatusCodeEncryptionKeyAccessDenied is a StudioStatusCode enum value
	StudioStatusCodeEncryptionKeyAccessDenied = "ENCRYPTION_KEY_ACCESS_DENIED"

	// StudioStatusCodeAwsSsoConfigurationRepaired is a StudioStatusCode enum value
	StudioStatusCodeAwsSsoConfigurationRepaired = "AWS_SSO_CONFIGURATION_REPAIRED"

	// StudioStatusCodeAwsSsoConfigurationRepairInProgress is a StudioStatusCode enum value
	StudioStatusCodeAwsSsoConfigurationRepairInProgress = "AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS"
)

// StudioStatusCode_Values returns all elements of the StudioStatusCode enum
func StudioStatusCode_Values() []string {
	return []string{
		StudioStatusCodeStudioCreated,
		StudioStatusCodeStudioDeleted,
		StudioStatusCodeStudioUpdated,
		StudioStatusCodeStudioCreateInProgress,
		StudioStatusCodeStudioUpdateInProgress,
		StudioStatusCodeStudioDeleteInProgress,
		StudioStatusCodeStudioWithLaunchProfilesNotDeleted,
		StudioStatusCodeStudioWithStudioComponentsNotDeleted,
		StudioStatusCodeStudioWithStreamingImagesNotDeleted,
		StudioStatusCodeAwsSsoNotEnabled,
		StudioStatusCodeAwsSsoAccessDenied,
		StudioStatusCodeRoleNotOwnedByStudioOwner,
		StudioStatusCodeRoleCouldNotBeAssumed,
		StudioStatusCodeInternalError,
		StudioStatusCodeEncryptionKeyNotFound,
		StudioStatusCodeEncryptionKeyAccessDenied,
		StudioStatusCodeAwsSsoConfigurationRepaired,
		StudioStatusCodeAwsSsoConfigurationRepairInProgress,
	}
}
