// Code generated by smithy-go-codegen DO NOT EDIT.

package codecommit

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codecommit/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about one or more merge conflicts in the attempted merge of
// two commit specifiers using the squash or three-way merge strategy. If the merge
// option for the attempted merge is specified as FAST_FORWARD_MERGE, an exception
// is thrown.
func (c *Client) DescribeMergeConflicts(ctx context.Context, params *DescribeMergeConflictsInput, optFns ...func(*Options)) (*DescribeMergeConflictsOutput, error) {
	if params == nil {
		params = &DescribeMergeConflictsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeMergeConflicts", params, optFns, c.addOperationDescribeMergeConflictsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeMergeConflictsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeMergeConflictsInput struct {

	// The branch, tag, HEAD, or other fully qualified reference used to identify a
	// commit (for example, a branch name or a full commit ID).
	//
	// This member is required.
	DestinationCommitSpecifier *string

	// The path of the target files used to describe the conflicts.
	//
	// This member is required.
	FilePath *string

	// The merge option or strategy you want to use to merge the code.
	//
	// This member is required.
	MergeOption types.MergeOptionTypeEnum

	// The name of the repository where you want to get information about a merge
	// conflict.
	//
	// This member is required.
	RepositoryName *string

	// The branch, tag, HEAD, or other fully qualified reference used to identify a
	// commit (for example, a branch name or a full commit ID).
	//
	// This member is required.
	SourceCommitSpecifier *string

	// The level of conflict detail to use. If unspecified, the default FILE_LEVEL is
	// used, which returns a not-mergeable result if the same file has differences in
	// both branches. If LINE_LEVEL is specified, a conflict is considered not
	// mergeable if the same file in both branches has differences on the same line.
	ConflictDetailLevel types.ConflictDetailLevelTypeEnum

	// Specifies which branch to use when resolving conflicts, or whether to attempt
	// automatically merging two versions of a file. The default is NONE, which
	// requires any conflicts to be resolved manually before the merge operation is
	// successful.
	ConflictResolutionStrategy types.ConflictResolutionStrategyTypeEnum

	// The maximum number of merge hunks to include in the output.
	MaxMergeHunks *int32

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeMergeConflictsOutput struct {

	// Contains metadata about the conflicts found in the merge.
	//
	// This member is required.
	ConflictMetadata *types.ConflictMetadata

	// The commit ID of the destination commit specifier that was used in the merge
	// evaluation.
	//
	// This member is required.
	DestinationCommitId *string

	// A list of merge hunks of the differences between the files or lines.
	//
	// This member is required.
	MergeHunks []types.MergeHunk

	// The commit ID of the source commit specifier that was used in the merge
	// evaluation.
	//
	// This member is required.
	SourceCommitId *string

	// The commit ID of the merge base.
	BaseCommitId *string

	// An enumeration token that can be used in a request to return the next batch of
	// the results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeMergeConflictsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeMergeConflicts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeMergeConflicts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeMergeConflicts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeMergeConflictsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeMergeConflicts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeMergeConflictsPaginatorOptions is the paginator options for
// DescribeMergeConflicts
type DescribeMergeConflictsPaginatorOptions struct {
	// The maximum number of merge hunks to include in the output.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeMergeConflictsPaginator is a paginator for DescribeMergeConflicts
type DescribeMergeConflictsPaginator struct {
	options   DescribeMergeConflictsPaginatorOptions
	client    DescribeMergeConflictsAPIClient
	params    *DescribeMergeConflictsInput
	nextToken *string
	firstPage bool
}

// NewDescribeMergeConflictsPaginator returns a new DescribeMergeConflictsPaginator
func NewDescribeMergeConflictsPaginator(client DescribeMergeConflictsAPIClient, params *DescribeMergeConflictsInput, optFns ...func(*DescribeMergeConflictsPaginatorOptions)) *DescribeMergeConflictsPaginator {
	if params == nil {
		params = &DescribeMergeConflictsInput{}
	}

	options := DescribeMergeConflictsPaginatorOptions{}
	if params.MaxMergeHunks != nil {
		options.Limit = *params.MaxMergeHunks
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeMergeConflictsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeMergeConflictsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeMergeConflicts page.
func (p *DescribeMergeConflictsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeMergeConflictsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxMergeHunks = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeMergeConflicts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeMergeConflictsAPIClient is a client that implements the
// DescribeMergeConflicts operation.
type DescribeMergeConflictsAPIClient interface {
	DescribeMergeConflicts(context.Context, *DescribeMergeConflictsInput, ...func(*Options)) (*DescribeMergeConflictsOutput, error)
}

var _ DescribeMergeConflictsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeMergeConflicts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeMergeConflicts",
	}
}
