package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterDevices invokes the vs.DescribeClusterDevices API synchronously
func (client *Client) DescribeClusterDevices(request *DescribeClusterDevicesRequest) (response *DescribeClusterDevicesResponse, err error) {
	response = CreateDescribeClusterDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterDevicesWithChan invokes the vs.DescribeClusterDevices API asynchronously
func (client *Client) DescribeClusterDevicesWithChan(request *DescribeClusterDevicesRequest) (<-chan *DescribeClusterDevicesResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterDevicesWithCallback invokes the vs.DescribeClusterDevices API asynchronously
func (client *Client) DescribeClusterDevicesWithCallback(request *DescribeClusterDevicesRequest, callback func(response *DescribeClusterDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterDevicesResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterDevicesRequest is the request struct for api DescribeClusterDevices
type DescribeClusterDevicesRequest struct {
	*requests.RpcRequest
	Description   string           `position:"Query" name:"Description"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
	Specification string           `position:"Query" name:"Specification"`
	ClusterId     string           `position:"Query" name:"ClusterId"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	PageNo        requests.Integer `position:"Query" name:"PageNo"`
}

// DescribeClusterDevicesResponse is the response struct for api DescribeClusterDevices
type DescribeClusterDevicesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Total     int64    `json:"Total" xml:"Total"`
	Devices   []Device `json:"Devices" xml:"Devices"`
}

// CreateDescribeClusterDevicesRequest creates a request to invoke DescribeClusterDevices API
func CreateDescribeClusterDevicesRequest() (request *DescribeClusterDevicesRequest) {
	request = &DescribeClusterDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeClusterDevices", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterDevicesResponse creates a response to parse from DescribeClusterDevices response
func CreateDescribeClusterDevicesResponse() (response *DescribeClusterDevicesResponse) {
	response = &DescribeClusterDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
