package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPersonTraceDetails invokes the vcs.ListPersonTraceDetails API synchronously
func (client *Client) ListPersonTraceDetails(request *ListPersonTraceDetailsRequest) (response *ListPersonTraceDetailsResponse, err error) {
	response = CreateListPersonTraceDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPersonTraceDetailsWithChan invokes the vcs.ListPersonTraceDetails API asynchronously
func (client *Client) ListPersonTraceDetailsWithChan(request *ListPersonTraceDetailsRequest) (<-chan *ListPersonTraceDetailsResponse, <-chan error) {
	responseChan := make(chan *ListPersonTraceDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPersonTraceDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPersonTraceDetailsWithCallback invokes the vcs.ListPersonTraceDetails API asynchronously
func (client *Client) ListPersonTraceDetailsWithCallback(request *ListPersonTraceDetailsRequest, callback func(response *ListPersonTraceDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPersonTraceDetailsResponse
		var err error
		defer close(result)
		response, err = client.ListPersonTraceDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPersonTraceDetailsRequest is the request struct for api ListPersonTraceDetails
type ListPersonTraceDetailsRequest struct {
	*requests.RpcRequest
	CorpId       string           `position:"Body" name:"CorpId"`
	EndTime      string           `position:"Body" name:"EndTime"`
	StartTime    string           `position:"Body" name:"StartTime"`
	PageNumber   requests.Integer `position:"Body" name:"PageNumber"`
	SubId        string           `position:"Body" name:"SubId"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	DataSourceId string           `position:"Body" name:"DataSourceId"`
	PersonId     string           `position:"Body" name:"PersonId"`
}

// ListPersonTraceDetailsResponse is the response struct for api ListPersonTraceDetails
type ListPersonTraceDetailsResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListPersonTraceDetailsRequest creates a request to invoke ListPersonTraceDetails API
func CreateListPersonTraceDetailsRequest() (request *ListPersonTraceDetailsRequest) {
	request = &ListPersonTraceDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "ListPersonTraceDetails", "", "")
	request.Method = requests.POST
	return
}

// CreateListPersonTraceDetailsResponse creates a response to parse from ListPersonTraceDetails response
func CreateListPersonTraceDetailsResponse() (response *ListPersonTraceDetailsResponse) {
	response = &ListPersonTraceDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
