package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyQos invokes the smartag.ModifyQos API synchronously
func (client *Client) ModifyQos(request *ModifyQosRequest) (response *ModifyQosResponse, err error) {
	response = CreateModifyQosResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyQosWithChan invokes the smartag.ModifyQos API asynchronously
func (client *Client) ModifyQosWithChan(request *ModifyQosRequest) (<-chan *ModifyQosResponse, <-chan error) {
	responseChan := make(chan *ModifyQosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyQos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyQosWithCallback invokes the smartag.ModifyQos API asynchronously
func (client *Client) ModifyQosWithCallback(request *ModifyQosRequest, callback func(response *ModifyQosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyQosResponse
		var err error
		defer close(result)
		response, err = client.ModifyQos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyQosRequest is the request struct for api ModifyQos
type ModifyQosRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	QosId                string           `position:"Query" name:"QosId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	QosName              string           `position:"Query" name:"QosName"`
	QosDescription       string           `position:"Query" name:"QosDescription"`
}

// ModifyQosResponse is the response struct for api ModifyQos
type ModifyQosResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyQosRequest creates a request to invoke ModifyQos API
func CreateModifyQosRequest() (request *ModifyQosRequest) {
	request = &ModifyQosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifyQos", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyQosResponse creates a response to parse from ModifyQos response
func CreateModifyQosResponse() (response *ModifyQosResponse) {
	response = &ModifyQosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
