package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DelayEmbedToken invokes the quickbi_public.DelayEmbedToken API synchronously
func (client *Client) DelayEmbedToken(request *DelayEmbedTokenRequest) (response *DelayEmbedTokenResponse, err error) {
	response = CreateDelayEmbedTokenResponse()
	err = client.DoAction(request, response)
	return
}

// DelayEmbedTokenWithChan invokes the quickbi_public.DelayEmbedToken API asynchronously
func (client *Client) DelayEmbedTokenWithChan(request *DelayEmbedTokenRequest) (<-chan *DelayEmbedTokenResponse, <-chan error) {
	responseChan := make(chan *DelayEmbedTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DelayEmbedToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DelayEmbedTokenWithCallback invokes the quickbi_public.DelayEmbedToken API asynchronously
func (client *Client) DelayEmbedTokenWithCallback(request *DelayEmbedTokenRequest, callback func(response *DelayEmbedTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DelayEmbedTokenResponse
		var err error
		defer close(result)
		response, err = client.DelayEmbedToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DelayEmbedTokenRequest is the request struct for api DelayEmbedToken
type DelayEmbedTokenRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	SignType    string           `position:"Query" name:"SignType"`
	ExpireMin   requests.Integer `position:"Query" name:"ExpireMin"`
	Token       string           `position:"Query" name:"Token"`
}

// DelayEmbedTokenResponse is the response struct for api DelayEmbedToken
type DelayEmbedTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDelayEmbedTokenRequest creates a request to invoke DelayEmbedToken API
func CreateDelayEmbedTokenRequest() (request *DelayEmbedTokenRequest) {
	request = &DelayEmbedTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2021-03-25", "DelayEmbedToken", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDelayEmbedTokenResponse creates a response to parse from DelayEmbedToken response
func CreateDelayEmbedTokenResponse() (response *DelayEmbedTokenResponse) {
	response = &DelayEmbedTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
