package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSortScriptFile invokes the opensearch.DeleteSortScriptFile API synchronously
func (client *Client) DeleteSortScriptFile(request *DeleteSortScriptFileRequest) (response *DeleteSortScriptFileResponse, err error) {
	response = CreateDeleteSortScriptFileResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSortScriptFileWithChan invokes the opensearch.DeleteSortScriptFile API asynchronously
func (client *Client) DeleteSortScriptFileWithChan(request *DeleteSortScriptFileRequest) (<-chan *DeleteSortScriptFileResponse, <-chan error) {
	responseChan := make(chan *DeleteSortScriptFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSortScriptFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSortScriptFileWithCallback invokes the opensearch.DeleteSortScriptFile API asynchronously
func (client *Client) DeleteSortScriptFileWithCallback(request *DeleteSortScriptFileRequest, callback func(response *DeleteSortScriptFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSortScriptFileResponse
		var err error
		defer close(result)
		response, err = client.DeleteSortScriptFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSortScriptFileRequest is the request struct for api DeleteSortScriptFile
type DeleteSortScriptFileRequest struct {
	*requests.RoaRequest
	AppVersionId     string `position:"Path" name:"appVersionId"`
	FileName         string `position:"Path" name:"fileName"`
	ScriptName       string `position:"Path" name:"scriptName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// DeleteSortScriptFileResponse is the response struct for api DeleteSortScriptFile
type DeleteSortScriptFileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateDeleteSortScriptFileRequest creates a request to invoke DeleteSortScriptFile API
func CreateDeleteSortScriptFileRequest() (request *DeleteSortScriptFileRequest) {
	request = &DeleteSortScriptFileRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "DeleteSortScriptFile", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appVersionId]/sort-scripts/[scriptName]/files/src/[fileName]", "opensearch", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteSortScriptFileResponse creates a response to parse from DeleteSortScriptFile response
func CreateDeleteSortScriptFileResponse() (response *DeleteSortScriptFileResponse) {
	response = &DeleteSortScriptFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
