package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCellClusterOrder invokes the foas.CreateCellClusterOrder API synchronously
func (client *Client) CreateCellClusterOrder(request *CreateCellClusterOrderRequest) (response *CreateCellClusterOrderResponse, err error) {
	response = CreateCreateCellClusterOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCellClusterOrderWithChan invokes the foas.CreateCellClusterOrder API asynchronously
func (client *Client) CreateCellClusterOrderWithChan(request *CreateCellClusterOrderRequest) (<-chan *CreateCellClusterOrderResponse, <-chan error) {
	responseChan := make(chan *CreateCellClusterOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCellClusterOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCellClusterOrderWithCallback invokes the foas.CreateCellClusterOrder API asynchronously
func (client *Client) CreateCellClusterOrderWithCallback(request *CreateCellClusterOrderRequest, callback func(response *CreateCellClusterOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCellClusterOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateCellClusterOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCellClusterOrderRequest is the request struct for api CreateCellClusterOrder
type CreateCellClusterOrderRequest struct {
	*requests.RoaRequest
	Period     requests.Integer `position:"Body" name:"period"`
	SlaveNum   requests.Integer `position:"Body" name:"slaveNum"`
	SlaveSpec  string           `position:"Body" name:"slaveSpec"`
	Region     string           `position:"Body" name:"region"`
	MasterNum  requests.Integer `position:"Body" name:"masterNum"`
	MasterSpec string           `position:"Body" name:"masterSpec"`
	PayModel   string           `position:"Body" name:"payModel"`
}

// CreateCellClusterOrderResponse is the response struct for api CreateCellClusterOrder
type CreateCellClusterOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateCreateCellClusterOrderRequest creates a request to invoke CreateCellClusterOrder API
func CreateCreateCellClusterOrderRequest() (request *CreateCellClusterOrderRequest) {
	request = &CreateCellClusterOrderRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "CreateCellClusterOrder", "/api/v2/realtime-compute/cell/buy", "foas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCellClusterOrderResponse creates a response to parse from CreateCellClusterOrder response
func CreateCreateCellClusterOrderResponse() (response *CreateCellClusterOrderResponse) {
	response = &CreateCellClusterOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
