package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDevopsProjectSprint invokes the devops_rdc.UpdateDevopsProjectSprint API synchronously
func (client *Client) UpdateDevopsProjectSprint(request *UpdateDevopsProjectSprintRequest) (response *UpdateDevopsProjectSprintResponse, err error) {
	response = CreateUpdateDevopsProjectSprintResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDevopsProjectSprintWithChan invokes the devops_rdc.UpdateDevopsProjectSprint API asynchronously
func (client *Client) UpdateDevopsProjectSprintWithChan(request *UpdateDevopsProjectSprintRequest) (<-chan *UpdateDevopsProjectSprintResponse, <-chan error) {
	responseChan := make(chan *UpdateDevopsProjectSprintResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDevopsProjectSprint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDevopsProjectSprintWithCallback invokes the devops_rdc.UpdateDevopsProjectSprint API asynchronously
func (client *Client) UpdateDevopsProjectSprintWithCallback(request *UpdateDevopsProjectSprintRequest, callback func(response *UpdateDevopsProjectSprintResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDevopsProjectSprintResponse
		var err error
		defer close(result)
		response, err = client.UpdateDevopsProjectSprint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDevopsProjectSprintRequest is the request struct for api UpdateDevopsProjectSprint
type UpdateDevopsProjectSprintRequest struct {
	*requests.RpcRequest
	ExecutorId  string `position:"Body" name:"ExecutorId"`
	Description string `position:"Body" name:"Description"`
	StartDate   string `position:"Body" name:"StartDate"`
	OrgId       string `position:"Body" name:"OrgId"`
	SprintId    string `position:"Body" name:"SprintId"`
	DueDate     string `position:"Body" name:"DueDate"`
	Name        string `position:"Body" name:"Name"`
	ProjectId   string `position:"Body" name:"ProjectId"`
}

// UpdateDevopsProjectSprintResponse is the response struct for api UpdateDevopsProjectSprint
type UpdateDevopsProjectSprintResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     bool   `json:"Object" xml:"Object"`
}

// CreateUpdateDevopsProjectSprintRequest creates a request to invoke UpdateDevopsProjectSprint API
func CreateUpdateDevopsProjectSprintRequest() (request *UpdateDevopsProjectSprintRequest) {
	request = &UpdateDevopsProjectSprintRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "UpdateDevopsProjectSprint", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDevopsProjectSprintResponse creates a response to parse from UpdateDevopsProjectSprint response
func CreateUpdateDevopsProjectSprintResponse() (response *UpdateDevopsProjectSprintResponse) {
	response = &UpdateDevopsProjectSprintResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
