package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceCountTrend invokes the dataworks_public.GetInstanceCountTrend API synchronously
func (client *Client) GetInstanceCountTrend(request *GetInstanceCountTrendRequest) (response *GetInstanceCountTrendResponse, err error) {
	response = CreateGetInstanceCountTrendResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceCountTrendWithChan invokes the dataworks_public.GetInstanceCountTrend API asynchronously
func (client *Client) GetInstanceCountTrendWithChan(request *GetInstanceCountTrendRequest) (<-chan *GetInstanceCountTrendResponse, <-chan error) {
	responseChan := make(chan *GetInstanceCountTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceCountTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceCountTrendWithCallback invokes the dataworks_public.GetInstanceCountTrend API asynchronously
func (client *Client) GetInstanceCountTrendWithCallback(request *GetInstanceCountTrendRequest, callback func(response *GetInstanceCountTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceCountTrendResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceCountTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceCountTrendRequest is the request struct for api GetInstanceCountTrend
type GetInstanceCountTrendRequest struct {
	*requests.RpcRequest
	BeginDate string           `position:"Body" name:"BeginDate"`
	EndDate   string           `position:"Body" name:"EndDate"`
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
}

// GetInstanceCountTrendResponse is the response struct for api GetInstanceCountTrend
type GetInstanceCountTrendResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	InstanceCounts []IntanceCounts `json:"InstanceCounts" xml:"InstanceCounts"`
}

// CreateGetInstanceCountTrendRequest creates a request to invoke GetInstanceCountTrend API
func CreateGetInstanceCountTrendRequest() (request *GetInstanceCountTrendRequest) {
	request = &GetInstanceCountTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetInstanceCountTrend", "", "")
	request.Method = requests.POST
	return
}

// CreateGetInstanceCountTrendResponse creates a response to parse from GetInstanceCountTrend response
func CreateGetInstanceCountTrendResponse() (response *GetInstanceCountTrendResponse) {
	response = &GetInstanceCountTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
