package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGroupMember invokes the codeup.DeleteGroupMember API synchronously
func (client *Client) DeleteGroupMember(request *DeleteGroupMemberRequest) (response *DeleteGroupMemberResponse, err error) {
	response = CreateDeleteGroupMemberResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGroupMemberWithChan invokes the codeup.DeleteGroupMember API asynchronously
func (client *Client) DeleteGroupMemberWithChan(request *DeleteGroupMemberRequest) (<-chan *DeleteGroupMemberResponse, <-chan error) {
	responseChan := make(chan *DeleteGroupMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGroupMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGroupMemberWithCallback invokes the codeup.DeleteGroupMember API asynchronously
func (client *Client) DeleteGroupMemberWithCallback(request *DeleteGroupMemberRequest, callback func(response *DeleteGroupMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGroupMemberResponse
		var err error
		defer close(result)
		response, err = client.DeleteGroupMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGroupMemberRequest is the request struct for api DeleteGroupMember
type DeleteGroupMemberRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	GroupId        requests.Integer `position:"Path" name:"GroupId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	UserId         requests.Integer `position:"Path" name:"UserId"`
}

// DeleteGroupMemberResponse is the response struct for api DeleteGroupMember
type DeleteGroupMemberResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateDeleteGroupMemberRequest creates a request to invoke DeleteGroupMember API
func CreateDeleteGroupMemberRequest() (request *DeleteGroupMemberRequest) {
	request = &DeleteGroupMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "DeleteGroupMember", "/api/v3/groups/[GroupId]/members/[UserId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteGroupMemberResponse creates a response to parse from DeleteGroupMember response
func CreateDeleteGroupMemberResponse() (response *DeleteGroupMemberResponse) {
	response = &DeleteGroupMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
