package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeviceBatchCreate invokes the cloudwf.DeviceBatchCreate API synchronously
// api document: https://help.aliyun.com/api/cloudwf/devicebatchcreate.html
func (client *Client) DeviceBatchCreate(request *DeviceBatchCreateRequest) (response *DeviceBatchCreateResponse, err error) {
	response = CreateDeviceBatchCreateResponse()
	err = client.DoAction(request, response)
	return
}

// DeviceBatchCreateWithChan invokes the cloudwf.DeviceBatchCreate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/devicebatchcreate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeviceBatchCreateWithChan(request *DeviceBatchCreateRequest) (<-chan *DeviceBatchCreateResponse, <-chan error) {
	responseChan := make(chan *DeviceBatchCreateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeviceBatchCreate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeviceBatchCreateWithCallback invokes the cloudwf.DeviceBatchCreate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/devicebatchcreate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeviceBatchCreateWithCallback(request *DeviceBatchCreateRequest, callback func(response *DeviceBatchCreateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeviceBatchCreateResponse
		var err error
		defer close(result)
		response, err = client.DeviceBatchCreate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeviceBatchCreateRequest is the request struct for api DeviceBatchCreate
type DeviceBatchCreateRequest struct {
	*requests.RpcRequest
	Sn         string           `position:"Query" name:"Sn"`
	DeviceType requests.Integer `position:"Query" name:"DeviceType"`
}

// DeviceBatchCreateResponse is the response struct for api DeviceBatchCreate
type DeviceBatchCreateResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDeviceBatchCreateRequest creates a request to invoke DeviceBatchCreate API
func CreateDeviceBatchCreateRequest() (request *DeviceBatchCreateRequest) {
	request = &DeviceBatchCreateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DeviceBatchCreate", "cloudwf", "openAPI")
	return
}

// CreateDeviceBatchCreateResponse creates a response to parse from DeviceBatchCreate response
func CreateDeviceBatchCreateResponse() (response *DeviceBatchCreateResponse) {
	response = &DeviceBatchCreateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
