package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDispatchGameSlot invokes the cloudgameapi.BatchDispatchGameSlot API synchronously
func (client *Client) BatchDispatchGameSlot(request *BatchDispatchGameSlotRequest) (response *BatchDispatchGameSlotResponse, err error) {
	response = CreateBatchDispatchGameSlotResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDispatchGameSlotWithChan invokes the cloudgameapi.BatchDispatchGameSlot API asynchronously
func (client *Client) BatchDispatchGameSlotWithChan(request *BatchDispatchGameSlotRequest) (<-chan *BatchDispatchGameSlotResponse, <-chan error) {
	responseChan := make(chan *BatchDispatchGameSlotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDispatchGameSlot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDispatchGameSlotWithCallback invokes the cloudgameapi.BatchDispatchGameSlot API asynchronously
func (client *Client) BatchDispatchGameSlotWithCallback(request *BatchDispatchGameSlotRequest, callback func(response *BatchDispatchGameSlotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDispatchGameSlotResponse
		var err error
		defer close(result)
		response, err = client.BatchDispatchGameSlot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDispatchGameSlotRequest is the request struct for api BatchDispatchGameSlot
type BatchDispatchGameSlotRequest struct {
	*requests.RpcRequest
	QueueUserList string `position:"Body" name:"QueueUserList"`
}

// BatchDispatchGameSlotResponse is the response struct for api BatchDispatchGameSlot
type BatchDispatchGameSlotResponse struct {
	*responses.BaseResponse
	RequestId       string     `json:"RequestId" xml:"RequestId"`
	QueueResultList []DataList `json:"QueueResultList" xml:"QueueResultList"`
}

// CreateBatchDispatchGameSlotRequest creates a request to invoke BatchDispatchGameSlot API
func CreateBatchDispatchGameSlotRequest() (request *BatchDispatchGameSlotRequest) {
	request = &BatchDispatchGameSlotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "BatchDispatchGameSlot", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchDispatchGameSlotResponse creates a response to parse from BatchDispatchGameSlot response
func CreateBatchDispatchGameSlotResponse() (response *BatchDispatchGameSlotResponse) {
	response = &BatchDispatchGameSlotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
