package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVnInstance invokes the cloudcallcenter.ModifyVnInstance API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvninstance.html
func (client *Client) ModifyVnInstance(request *ModifyVnInstanceRequest) (response *ModifyVnInstanceResponse, err error) {
	response = CreateModifyVnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVnInstanceWithChan invokes the cloudcallcenter.ModifyVnInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnInstanceWithChan(request *ModifyVnInstanceRequest) (<-chan *ModifyVnInstanceResponse, <-chan error) {
	responseChan := make(chan *ModifyVnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVnInstanceWithCallback invokes the cloudcallcenter.ModifyVnInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnInstanceWithCallback(request *ModifyVnInstanceRequest, callback func(response *ModifyVnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVnInstanceResponse
		var err error
		defer close(result)
		response, err = client.ModifyVnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVnInstanceRequest is the request struct for api ModifyVnInstance
type ModifyVnInstanceRequest struct {
	*requests.RpcRequest
	Description       string           `position:"Query" name:"Description"`
	Concurrency       requests.Integer `position:"Query" name:"Concurrency"`
	InstanceId        string           `position:"Query" name:"InstanceId"`
	ChatbotInstanceId string           `position:"Query" name:"ChatbotInstanceId"`
}

// ModifyVnInstanceResponse is the response struct for api ModifyVnInstance
type ModifyVnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVnInstanceRequest creates a request to invoke ModifyVnInstance API
func CreateModifyVnInstanceRequest() (request *ModifyVnInstanceRequest) {
	request = &ModifyVnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyVnInstance", "", "")
	request.Method = requests.GET
	return
}

// CreateModifyVnInstanceResponse creates a response to parse from ModifyVnInstance response
func CreateModifyVnInstanceResponse() (response *ModifyVnInstanceResponse) {
	response = &ModifyVnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
