package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDetailOfSkillGroup invokes the cloudcallcenter.ListDetailOfSkillGroup API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listdetailofskillgroup.html
func (client *Client) ListDetailOfSkillGroup(request *ListDetailOfSkillGroupRequest) (response *ListDetailOfSkillGroupResponse, err error) {
	response = CreateListDetailOfSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListDetailOfSkillGroupWithChan invokes the cloudcallcenter.ListDetailOfSkillGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listdetailofskillgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDetailOfSkillGroupWithChan(request *ListDetailOfSkillGroupRequest) (<-chan *ListDetailOfSkillGroupResponse, <-chan error) {
	responseChan := make(chan *ListDetailOfSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDetailOfSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDetailOfSkillGroupWithCallback invokes the cloudcallcenter.ListDetailOfSkillGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listdetailofskillgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDetailOfSkillGroupWithCallback(request *ListDetailOfSkillGroupRequest, callback func(response *ListDetailOfSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDetailOfSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.ListDetailOfSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDetailOfSkillGroupRequest is the request struct for api ListDetailOfSkillGroup
type ListDetailOfSkillGroupRequest struct {
	*requests.RpcRequest
	InstanceId   string           `position:"Query" name:"InstanceId"`
	StartDay     string           `position:"Query" name:"StartDay"`
	EndDay       string           `position:"Query" name:"EndDay"`
	SkillGroupId string           `position:"Query" name:"SkillGroupId"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
}

// ListDetailOfSkillGroupResponse is the response struct for api ListDetailOfSkillGroup
type ListDetailOfSkillGroupResponse struct {
	*responses.BaseResponse
	RequestId      string                           `json:"RequestId" xml:"RequestId"`
	Success        bool                             `json:"Success" xml:"Success"`
	Code           string                           `json:"Code" xml:"Code"`
	Message        string                           `json:"Message" xml:"Message"`
	HttpStatusCode int                              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DataList       DataListInListDetailOfSkillGroup `json:"DataList" xml:"DataList"`
}

// CreateListDetailOfSkillGroupRequest creates a request to invoke ListDetailOfSkillGroup API
func CreateListDetailOfSkillGroupRequest() (request *ListDetailOfSkillGroupRequest) {
	request = &ListDetailOfSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListDetailOfSkillGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateListDetailOfSkillGroupResponse creates a response to parse from ListDetailOfSkillGroup response
func CreateListDetailOfSkillGroupResponse() (response *ListDetailOfSkillGroupResponse) {
	response = &ListDetailOfSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
