package guestconfiguration

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionAfterReboot enumerates the values for action after reboot.
type ActionAfterReboot string

const (
	// ActionAfterRebootContinueConfiguration ...
	ActionAfterRebootContinueConfiguration ActionAfterReboot = "ContinueConfiguration"
	// ActionAfterRebootStopConfiguration ...
	ActionAfterRebootStopConfiguration ActionAfterReboot = "StopConfiguration"
)

// PossibleActionAfterRebootValues returns an array of possible values for the ActionAfterReboot const type.
func PossibleActionAfterRebootValues() []ActionAfterReboot {
	return []ActionAfterReboot{ActionAfterRebootContinueConfiguration, ActionAfterRebootStopConfiguration}
}

// AssignmentType enumerates the values for assignment type.
type AssignmentType string

const (
	// AssignmentTypeApplyAndAutoCorrect ...
	AssignmentTypeApplyAndAutoCorrect AssignmentType = "ApplyAndAutoCorrect"
	// AssignmentTypeApplyAndMonitor ...
	AssignmentTypeApplyAndMonitor AssignmentType = "ApplyAndMonitor"
	// AssignmentTypeAudit ...
	AssignmentTypeAudit AssignmentType = "Audit"
	// AssignmentTypeDeployAndAutoCorrect ...
	AssignmentTypeDeployAndAutoCorrect AssignmentType = "DeployAndAutoCorrect"
)

// PossibleAssignmentTypeValues returns an array of possible values for the AssignmentType const type.
func PossibleAssignmentTypeValues() []AssignmentType {
	return []AssignmentType{AssignmentTypeApplyAndAutoCorrect, AssignmentTypeApplyAndMonitor, AssignmentTypeAudit, AssignmentTypeDeployAndAutoCorrect}
}

// ComplianceStatus enumerates the values for compliance status.
type ComplianceStatus string

const (
	// ComplianceStatusCompliant ...
	ComplianceStatusCompliant ComplianceStatus = "Compliant"
	// ComplianceStatusNonCompliant ...
	ComplianceStatusNonCompliant ComplianceStatus = "NonCompliant"
	// ComplianceStatusPending ...
	ComplianceStatusPending ComplianceStatus = "Pending"
)

// PossibleComplianceStatusValues returns an array of possible values for the ComplianceStatus const type.
func PossibleComplianceStatusValues() []ComplianceStatus {
	return []ComplianceStatus{ComplianceStatusCompliant, ComplianceStatusNonCompliant, ComplianceStatusPending}
}

// ConfigurationMode enumerates the values for configuration mode.
type ConfigurationMode string

const (
	// ConfigurationModeApplyAndAutoCorrect ...
	ConfigurationModeApplyAndAutoCorrect ConfigurationMode = "ApplyAndAutoCorrect"
	// ConfigurationModeApplyAndMonitor ...
	ConfigurationModeApplyAndMonitor ConfigurationMode = "ApplyAndMonitor"
	// ConfigurationModeApplyOnly ...
	ConfigurationModeApplyOnly ConfigurationMode = "ApplyOnly"
)

// PossibleConfigurationModeValues returns an array of possible values for the ConfigurationMode const type.
func PossibleConfigurationModeValues() []ConfigurationMode {
	return []ConfigurationMode{ConfigurationModeApplyAndAutoCorrect, ConfigurationModeApplyAndMonitor, ConfigurationModeApplyOnly}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindDSC ...
	KindDSC Kind = "DSC"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindDSC}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreated ...
	ProvisioningStateCreated ProvisioningState = "Created"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreated, ProvisioningStateFailed, ProvisioningStateSucceeded}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeConsistency ...
	TypeConsistency Type = "Consistency"
	// TypeInitial ...
	TypeInitial Type = "Initial"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeConsistency, TypeInitial}
}
