package diagnostics

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2021-05-01-preview/diagnostics"

// AccessModeSettings properties that define the scope private link mode settings.
type AccessModeSettings struct {
	// QueryAccessMode - Specifies the default access mode of queries through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array. Possible values include: 'AccessModeOpen', 'AccessModePrivateOnly'
	QueryAccessMode AccessMode `json:"queryAccessMode,omitempty"`
	// IngestionAccessMode - Specifies the default access mode of ingestion through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array. Possible values include: 'AccessModeOpen', 'AccessModePrivateOnly'
	IngestionAccessMode AccessMode `json:"ingestionAccessMode,omitempty"`
	// Exclusions - List of exclusions that override the default access mode settings for specific private endpoint connections.
	Exclusions *[]AccessModeSettingsExclusion `json:"exclusions,omitempty"`
}

// AccessModeSettingsExclusion properties that define the scope private link mode settings exclusion item.
// This setting applies to a specific private endpoint connection and overrides the default settings for
// that private endpoint connection.
type AccessModeSettingsExclusion struct {
	// PrivateEndpointConnectionName - The private endpoint connection name associated to the private endpoint on which we want to apply the specific access mode settings.
	PrivateEndpointConnectionName *string `json:"privateEndpointConnectionName,omitempty"`
	// QueryAccessMode - Specifies the access mode of queries through the specified private endpoint connection in the exclusion. Possible values include: 'AccessModeOpen', 'AccessModePrivateOnly'
	QueryAccessMode AccessMode `json:"queryAccessMode,omitempty"`
	// IngestionAccessMode - Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion. Possible values include: 'AccessModeOpen', 'AccessModePrivateOnly'
	IngestionAccessMode AccessMode `json:"ingestionAccessMode,omitempty"`
}

// ActionDetail the action detail
type ActionDetail struct {
	// MechanismType - The mechanism type
	MechanismType *string `json:"MechanismType,omitempty"`
	// Name - The name of the action
	Name *string `json:"Name,omitempty"`
	// Status - The status of the action
	Status *string `json:"Status,omitempty"`
	// SubState - The substatus of the action
	SubState *string `json:"SubState,omitempty"`
	// SendTime - The send time
	SendTime *string `json:"SendTime,omitempty"`
	// Detail - The detail of the friendly error message
	Detail *string `json:"Detail,omitempty"`
}

// ActionGroup an Azure action group.
type ActionGroup struct {
	// GroupShortName - The short name of the action group. This will be used in SMS messages.
	GroupShortName *string `json:"groupShortName,omitempty"`
	// Enabled - Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
	Enabled *bool `json:"enabled,omitempty"`
	// EmailReceivers - The list of email receivers that are part of this action group.
	EmailReceivers *[]EmailReceiver `json:"emailReceivers,omitempty"`
	// SmsReceivers - The list of SMS receivers that are part of this action group.
	SmsReceivers *[]SmsReceiver `json:"smsReceivers,omitempty"`
	// WebhookReceivers - The list of webhook receivers that are part of this action group.
	WebhookReceivers *[]WebhookReceiver `json:"webhookReceivers,omitempty"`
	// ItsmReceivers - The list of ITSM receivers that are part of this action group.
	ItsmReceivers *[]ItsmReceiver `json:"itsmReceivers,omitempty"`
	// AzureAppPushReceivers - The list of AzureAppPush receivers that are part of this action group.
	AzureAppPushReceivers *[]AzureAppPushReceiver `json:"azureAppPushReceivers,omitempty"`
	// AutomationRunbookReceivers - The list of AutomationRunbook receivers that are part of this action group.
	AutomationRunbookReceivers *[]AutomationRunbookReceiver `json:"automationRunbookReceivers,omitempty"`
	// VoiceReceivers - The list of voice receivers that are part of this action group.
	VoiceReceivers *[]VoiceReceiver `json:"voiceReceivers,omitempty"`
	// LogicAppReceivers - The list of logic app receivers that are part of this action group.
	LogicAppReceivers *[]LogicAppReceiver `json:"logicAppReceivers,omitempty"`
	// AzureFunctionReceivers - The list of azure function receivers that are part of this action group.
	AzureFunctionReceivers *[]AzureFunctionReceiver `json:"azureFunctionReceivers,omitempty"`
	// ArmRoleReceivers - The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
	ArmRoleReceivers *[]ArmRoleReceiver `json:"armRoleReceivers,omitempty"`
	// EventHubReceivers - The list of event hub receivers that are part of this action group.
	EventHubReceivers *[]EventHubReceiver `json:"eventHubReceivers,omitempty"`
}

// ActionGroupList a list of action groups.
type ActionGroupList struct {
	autorest.Response `json:"-"`
	// Value - The list of action groups.
	Value *[]ActionGroupResource `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`
}

// ActionGroupPatch an Azure action group for patch operations.
type ActionGroupPatch struct {
	// Enabled - Indicates whether this action group is enabled. If an action group is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// ActionGroupPatchBody an action group object for the body of patch operations.
type ActionGroupPatchBody struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ActionGroupPatch - The action group settings for an update operation.
	*ActionGroupPatch `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionGroupPatchBody.
func (agpb ActionGroupPatchBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpb.Tags != nil {
		objectMap["tags"] = agpb.Tags
	}
	if agpb.ActionGroupPatch != nil {
		objectMap["properties"] = agpb.ActionGroupPatch
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionGroupPatchBody struct.
func (agpb *ActionGroupPatchBody) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agpb.Tags = tags
			}
		case "properties":
			if v != nil {
				var actionGroupPatch ActionGroupPatch
				err = json.Unmarshal(*v, &actionGroupPatch)
				if err != nil {
					return err
				}
				agpb.ActionGroupPatch = &actionGroupPatch
			}
		}
	}

	return nil
}

// ActionGroupResource an action group resource.
type ActionGroupResource struct {
	autorest.Response `json:"-"`
	// ActionGroup - The action groups properties of the resource.
	*ActionGroup `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - READ-ONLY; Azure resource kind
	Kind *string `json:"kind,omitempty"`
	// Identity - READ-ONLY; Azure resource identity
	Identity *string `json:"identity,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ActionGroupResource.
func (agr ActionGroupResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agr.ActionGroup != nil {
		objectMap["properties"] = agr.ActionGroup
	}
	if agr.Location != nil {
		objectMap["location"] = agr.Location
	}
	if agr.Tags != nil {
		objectMap["tags"] = agr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionGroupResource struct.
func (agr *ActionGroupResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var actionGroup ActionGroup
				err = json.Unmarshal(*v, &actionGroup)
				if err != nil {
					return err
				}
				agr.ActionGroup = &actionGroup
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agr.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				agr.Kind = &kind
			}
		case "identity":
			if v != nil {
				var identity string
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				agr.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				agr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agr.Tags = tags
			}
		}
	}

	return nil
}

// ActionGroupsPostTestNotificationsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ActionGroupsPostTestNotificationsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ActionGroupsClient) (TestNotificationResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ActionGroupsPostTestNotificationsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ActionGroupsPostTestNotificationsFuture.Result.
func (future *ActionGroupsPostTestNotificationsFuture) result(client ActionGroupsClient) (tnr TestNotificationResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "diagnostics.ActionGroupsPostTestNotificationsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tnr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("diagnostics.ActionGroupsPostTestNotificationsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tnr.Response.Response, err = future.GetResult(sender); err == nil && tnr.Response.Response.StatusCode != http.StatusNoContent {
		tnr, err = client.PostTestNotificationsResponder(tnr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "diagnostics.ActionGroupsPostTestNotificationsFuture", "Result", tnr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ArmRoleReceiver an arm role receiver.
type ArmRoleReceiver struct {
	// Name - The name of the arm role receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// RoleID - The arm role id.
	RoleID *string `json:"roleId,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AutomationRunbookReceiver the Azure Automation Runbook notification receiver.
type AutomationRunbookReceiver struct {
	// AutomationAccountID - The Azure automation account Id which holds this runbook and authenticate to Azure resource.
	AutomationAccountID *string `json:"automationAccountId,omitempty"`
	// RunbookName - The name for this runbook.
	RunbookName *string `json:"runbookName,omitempty"`
	// WebhookResourceID - The resource id for webhook linked to this runbook.
	WebhookResourceID *string `json:"webhookResourceId,omitempty"`
	// IsGlobalRunbook - Indicates whether this instance is global runbook.
	IsGlobalRunbook *bool `json:"isGlobalRunbook,omitempty"`
	// Name - Indicates name of the webhook.
	Name *string `json:"name,omitempty"`
	// ServiceURI - The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AutoscaleErrorResponse describes the format of Error response.
type AutoscaleErrorResponse struct {
	// Error - The error object.
	Error *AutoscaleErrorResponseError `json:"error,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to the response.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoscaleErrorResponse.
func (aer AutoscaleErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aer.Error != nil {
		objectMap["error"] = aer.Error
	}
	return json.Marshal(objectMap)
}

// AutoscaleErrorResponseError the error object.
type AutoscaleErrorResponseError struct {
	// Code - One of a server-defined set of error codes.
	Code *string `json:"code,omitempty"`
	// Message - A human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error.
	Target *string `json:"target,omitempty"`
	// Details - A human-readable representation of the error's details.
	Details *string `json:"details,omitempty"`
}

// AutoscaleNotification autoscale notification.
type AutoscaleNotification struct {
	// Operation - the operation associated with the notification and its value must be "scale"
	Operation *string `json:"operation,omitempty"`
	// Email - the email notification.
	Email *EmailNotification `json:"email,omitempty"`
	// Webhooks - the collection of webhook notifications.
	Webhooks *[]WebhookNotification `json:"webhooks,omitempty"`
}

// AutoscaleProfile autoscale profile.
type AutoscaleProfile struct {
	// Name - the name of the profile.
	Name *string `json:"name,omitempty"`
	// Capacity - the number of instances that can be used during this profile.
	Capacity *ScaleCapacity `json:"capacity,omitempty"`
	// Rules - the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
	Rules *[]ScaleRule `json:"rules,omitempty"`
	// FixedDate - the specific date-time for the profile. This element is not used if the Recurrence element is used.
	FixedDate *TimeWindow `json:"fixedDate,omitempty"`
	// Recurrence - the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
	Recurrence *Recurrence `json:"recurrence,omitempty"`
}

// AutoscaleSetting a setting that contains all of the configuration for the automatic scaling of a
// resource.
type AutoscaleSetting struct {
	// Profiles - the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
	Profiles *[]AutoscaleProfile `json:"profiles,omitempty"`
	// Notifications - the collection of notifications.
	Notifications *[]AutoscaleNotification `json:"notifications,omitempty"`
	// Enabled - the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'true'.
	Enabled *bool `json:"enabled,omitempty"`
	// PredictiveAutoscalePolicy - the predictive autoscale policy mode.
	PredictiveAutoscalePolicy *PredictiveAutoscalePolicy `json:"predictiveAutoscalePolicy,omitempty"`
	// Name - the name of the autoscale setting.
	Name *string `json:"name,omitempty"`
	// TargetResourceURI - the resource identifier of the resource that the autoscale setting should be added to.
	TargetResourceURI *string `json:"targetResourceUri,omitempty"`
	// TargetResourceLocation - the location of the resource that the autoscale setting should be added to.
	TargetResourceLocation *string `json:"targetResourceLocation,omitempty"`
}

// AutoscaleSettingResource the autoscale setting resource.
type AutoscaleSettingResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
	Tags map[string]*string `json:"tags"`
	// AutoscaleSetting - The autoscale setting of the resource.
	*AutoscaleSetting `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to the response.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoscaleSettingResource.
func (asr AutoscaleSettingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asr.Location != nil {
		objectMap["location"] = asr.Location
	}
	if asr.Tags != nil {
		objectMap["tags"] = asr.Tags
	}
	if asr.AutoscaleSetting != nil {
		objectMap["properties"] = asr.AutoscaleSetting
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoscaleSettingResource struct.
func (asr *AutoscaleSettingResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asr.Tags = tags
			}
		case "properties":
			if v != nil {
				var autoscaleSetting AutoscaleSetting
				err = json.Unmarshal(*v, &autoscaleSetting)
				if err != nil {
					return err
				}
				asr.AutoscaleSetting = &autoscaleSetting
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				asr.SystemData = &systemData
			}
		}
	}

	return nil
}

// AutoscaleSettingResourceCollection represents a collection of autoscale setting resources.
type AutoscaleSettingResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the autoscale setting resources.
	Value *[]AutoscaleSettingResource `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AutoscaleSettingResourceCollectionIterator provides access to a complete listing of
// AutoscaleSettingResource values.
type AutoscaleSettingResourceCollectionIterator struct {
	i    int
	page AutoscaleSettingResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutoscaleSettingResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoscaleSettingResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutoscaleSettingResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutoscaleSettingResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutoscaleSettingResourceCollectionIterator) Response() AutoscaleSettingResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutoscaleSettingResourceCollectionIterator) Value() AutoscaleSettingResource {
	if !iter.page.NotDone() {
		return AutoscaleSettingResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutoscaleSettingResourceCollectionIterator type.
func NewAutoscaleSettingResourceCollectionIterator(page AutoscaleSettingResourceCollectionPage) AutoscaleSettingResourceCollectionIterator {
	return AutoscaleSettingResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asrc AutoscaleSettingResourceCollection) IsEmpty() bool {
	return asrc.Value == nil || len(*asrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asrc AutoscaleSettingResourceCollection) hasNextLink() bool {
	return asrc.NextLink != nil && len(*asrc.NextLink) != 0
}

// autoscaleSettingResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asrc AutoscaleSettingResourceCollection) autoscaleSettingResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !asrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asrc.NextLink)))
}

// AutoscaleSettingResourceCollectionPage contains a page of AutoscaleSettingResource values.
type AutoscaleSettingResourceCollectionPage struct {
	fn   func(context.Context, AutoscaleSettingResourceCollection) (AutoscaleSettingResourceCollection, error)
	asrc AutoscaleSettingResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutoscaleSettingResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoscaleSettingResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asrc)
		if err != nil {
			return err
		}
		page.asrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutoscaleSettingResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutoscaleSettingResourceCollectionPage) NotDone() bool {
	return !page.asrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutoscaleSettingResourceCollectionPage) Response() AutoscaleSettingResourceCollection {
	return page.asrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutoscaleSettingResourceCollectionPage) Values() []AutoscaleSettingResource {
	if page.asrc.IsEmpty() {
		return nil
	}
	return *page.asrc.Value
}

// Creates a new instance of the AutoscaleSettingResourceCollectionPage type.
func NewAutoscaleSettingResourceCollectionPage(cur AutoscaleSettingResourceCollection, getNextPage func(context.Context, AutoscaleSettingResourceCollection) (AutoscaleSettingResourceCollection, error)) AutoscaleSettingResourceCollectionPage {
	return AutoscaleSettingResourceCollectionPage{
		fn:   getNextPage,
		asrc: cur,
	}
}

// AutoscaleSettingResourcePatch the autoscale setting object for patch operations.
type AutoscaleSettingResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// AutoscaleSetting - The autoscale setting properties of the update operation.
	*AutoscaleSetting `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoscaleSettingResourcePatch.
func (asrp AutoscaleSettingResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asrp.Tags != nil {
		objectMap["tags"] = asrp.Tags
	}
	if asrp.AutoscaleSetting != nil {
		objectMap["properties"] = asrp.AutoscaleSetting
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoscaleSettingResourcePatch struct.
func (asrp *AutoscaleSettingResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asrp.Tags = tags
			}
		case "properties":
			if v != nil {
				var autoscaleSetting AutoscaleSetting
				err = json.Unmarshal(*v, &autoscaleSetting)
				if err != nil {
					return err
				}
				asrp.AutoscaleSetting = &autoscaleSetting
			}
		}
	}

	return nil
}

// AzureAppPushReceiver the Azure mobile App push notification receiver.
type AzureAppPushReceiver struct {
	// Name - The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// EmailAddress - The email address registered for the Azure mobile app.
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureFunctionReceiver an azure function receiver.
type AzureFunctionReceiver struct {
	// Name - The name of the azure function receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// FunctionAppResourceID - The azure resource id of the function app.
	FunctionAppResourceID *string `json:"functionAppResourceId,omitempty"`
	// FunctionName - The function name in the function app.
	FunctionName *string `json:"functionName,omitempty"`
	// HTTPTriggerURL - The http trigger url where http request sent to.
	HTTPTriggerURL *string `json:"httpTriggerUrl,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AzureMonitorPrivateLinkScope an Azure Monitor PrivateLinkScope definition.
type AzureMonitorPrivateLinkScope struct {
	autorest.Response `json:"-"`
	// AzureMonitorPrivateLinkScopeProperties - Properties that define a Azure Monitor PrivateLinkScope resource.
	*AzureMonitorPrivateLinkScopeProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; System data
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMonitorPrivateLinkScope.
func (ampls AzureMonitorPrivateLinkScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ampls.AzureMonitorPrivateLinkScopeProperties != nil {
		objectMap["properties"] = ampls.AzureMonitorPrivateLinkScopeProperties
	}
	if ampls.Tags != nil {
		objectMap["tags"] = ampls.Tags
	}
	if ampls.Location != nil {
		objectMap["location"] = ampls.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureMonitorPrivateLinkScope struct.
func (ampls *AzureMonitorPrivateLinkScope) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureMonitorPrivateLinkScopeProperties AzureMonitorPrivateLinkScopeProperties
				err = json.Unmarshal(*v, &azureMonitorPrivateLinkScopeProperties)
				if err != nil {
					return err
				}
				ampls.AzureMonitorPrivateLinkScopeProperties = &azureMonitorPrivateLinkScopeProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ampls.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ampls.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ampls.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ampls.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ampls.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ampls.Type = &typeVar
			}
		}
	}

	return nil
}

// AzureMonitorPrivateLinkScopeListResult describes the list of Azure Monitor PrivateLinkScope resources.
type AzureMonitorPrivateLinkScopeListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Azure Monitor PrivateLinkScope definitions.
	Value *[]AzureMonitorPrivateLinkScope `json:"value,omitempty"`
	// NextLink - The URI to get the next set of Azure Monitor PrivateLinkScope definitions if too many PrivateLinkScopes where returned in the result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureMonitorPrivateLinkScopeListResultIterator provides access to a complete listing of
// AzureMonitorPrivateLinkScope values.
type AzureMonitorPrivateLinkScopeListResultIterator struct {
	i    int
	page AzureMonitorPrivateLinkScopeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureMonitorPrivateLinkScopeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureMonitorPrivateLinkScopeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureMonitorPrivateLinkScopeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureMonitorPrivateLinkScopeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureMonitorPrivateLinkScopeListResultIterator) Response() AzureMonitorPrivateLinkScopeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureMonitorPrivateLinkScopeListResultIterator) Value() AzureMonitorPrivateLinkScope {
	if !iter.page.NotDone() {
		return AzureMonitorPrivateLinkScope{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureMonitorPrivateLinkScopeListResultIterator type.
func NewAzureMonitorPrivateLinkScopeListResultIterator(page AzureMonitorPrivateLinkScopeListResultPage) AzureMonitorPrivateLinkScopeListResultIterator {
	return AzureMonitorPrivateLinkScopeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (amplslr AzureMonitorPrivateLinkScopeListResult) IsEmpty() bool {
	return amplslr.Value == nil || len(*amplslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (amplslr AzureMonitorPrivateLinkScopeListResult) hasNextLink() bool {
	return amplslr.NextLink != nil && len(*amplslr.NextLink) != 0
}

// azureMonitorPrivateLinkScopeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (amplslr AzureMonitorPrivateLinkScopeListResult) azureMonitorPrivateLinkScopeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !amplslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(amplslr.NextLink)))
}

// AzureMonitorPrivateLinkScopeListResultPage contains a page of AzureMonitorPrivateLinkScope values.
type AzureMonitorPrivateLinkScopeListResultPage struct {
	fn      func(context.Context, AzureMonitorPrivateLinkScopeListResult) (AzureMonitorPrivateLinkScopeListResult, error)
	amplslr AzureMonitorPrivateLinkScopeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureMonitorPrivateLinkScopeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureMonitorPrivateLinkScopeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.amplslr)
		if err != nil {
			return err
		}
		page.amplslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureMonitorPrivateLinkScopeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureMonitorPrivateLinkScopeListResultPage) NotDone() bool {
	return !page.amplslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureMonitorPrivateLinkScopeListResultPage) Response() AzureMonitorPrivateLinkScopeListResult {
	return page.amplslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureMonitorPrivateLinkScopeListResultPage) Values() []AzureMonitorPrivateLinkScope {
	if page.amplslr.IsEmpty() {
		return nil
	}
	return *page.amplslr.Value
}

// Creates a new instance of the AzureMonitorPrivateLinkScopeListResultPage type.
func NewAzureMonitorPrivateLinkScopeListResultPage(cur AzureMonitorPrivateLinkScopeListResult, getNextPage func(context.Context, AzureMonitorPrivateLinkScopeListResult) (AzureMonitorPrivateLinkScopeListResult, error)) AzureMonitorPrivateLinkScopeListResultPage {
	return AzureMonitorPrivateLinkScopeListResultPage{
		fn:      getNextPage,
		amplslr: cur,
	}
}

// AzureMonitorPrivateLinkScopeProperties properties that define a Azure Monitor PrivateLinkScope resource.
type AzureMonitorPrivateLinkScopeProperties struct {
	// ProvisioningState - READ-ONLY; Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// AccessModeSettings - Access mode settings
	AccessModeSettings *AccessModeSettings `json:"accessModeSettings,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMonitorPrivateLinkScopeProperties.
func (amplsp AzureMonitorPrivateLinkScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if amplsp.AccessModeSettings != nil {
		objectMap["accessModeSettings"] = amplsp.AccessModeSettings
	}
	return json.Marshal(objectMap)
}

// AzureResource an azure resource object
type AzureResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - READ-ONLY; Azure resource kind
	Kind *string `json:"kind,omitempty"`
	// Identity - READ-ONLY; Azure resource identity
	Identity *string `json:"identity,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AzureResource.
func (ar AzureResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	if ar.Tags != nil {
		objectMap["tags"] = ar.Tags
	}
	return json.Marshal(objectMap)
}

// Context the context info
type Context struct {
	// NotificationSource - The source of the notification request
	NotificationSource *string `json:"NotificationSource,omitempty"`
	// ContextType - The context id type
	ContextType *string `json:"ContextType,omitempty"`
}

// DefaultErrorResponse common error response for all Azure Resource Manager APIs to return error details
// for failed operations. (This also follows the OData error response format.).
type DefaultErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// EmailNotification email notification of an autoscale event.
type EmailNotification struct {
	// SendToSubscriptionAdministrator - a value indicating whether to send email to subscription administrator.
	SendToSubscriptionAdministrator *bool `json:"sendToSubscriptionAdministrator,omitempty"`
	// SendToSubscriptionCoAdministrators - a value indicating whether to send email to subscription co-administrators.
	SendToSubscriptionCoAdministrators *bool `json:"sendToSubscriptionCoAdministrators,omitempty"`
	// CustomEmails - the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
	CustomEmails *[]string `json:"customEmails,omitempty"`
}

// EmailReceiver an email receiver.
type EmailReceiver struct {
	// Name - The name of the email receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// EmailAddress - The email address of this receiver.
	EmailAddress *string `json:"emailAddress,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
	// Status - READ-ONLY; The receiver status of the e-mail. Possible values include: 'ReceiverStatusNotSpecified', 'ReceiverStatusEnabled', 'ReceiverStatusDisabled'
	Status ReceiverStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for EmailReceiver.
func (er EmailReceiver) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if er.Name != nil {
		objectMap["name"] = er.Name
	}
	if er.EmailAddress != nil {
		objectMap["emailAddress"] = er.EmailAddress
	}
	if er.UseCommonAlertSchema != nil {
		objectMap["useCommonAlertSchema"] = er.UseCommonAlertSchema
	}
	return json.Marshal(objectMap)
}

// EnableRequest describes a receiver that should be resubscribed.
type EnableRequest struct {
	// ReceiverName - The name of the receiver to resubscribe.
	ReceiverName *string `json:"receiverName,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse describes the format of Error response.
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// EventHubReceiver an Event hub receiver.
type EventHubReceiver struct {
	// Name - The name of the Event hub receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// EventHubNameSpace - The Event Hub namespace
	EventHubNameSpace *string `json:"eventHubNameSpace,omitempty"`
	// EventHubName - The name of the specific Event Hub queue
	EventHubName *string `json:"eventHubName,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
	// TenantID - The tenant Id for the subscription containing this event hub
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The Id for the subscription containing this event hub
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

// ItsmReceiver an Itsm receiver.
type ItsmReceiver struct {
	// Name - The name of the Itsm receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// WorkspaceID - OMS LA instance identifier.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// ConnectionID - Unique identification of ITSM connection among multiple defined in above workspace.
	ConnectionID *string `json:"connectionId,omitempty"`
	// TicketConfiguration - JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
	TicketConfiguration *string `json:"ticketConfiguration,omitempty"`
	// Region - Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
	Region *string `json:"region,omitempty"`
}

// LogicAppReceiver a logic app receiver.
type LogicAppReceiver struct {
	// Name - The name of the logic app receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// ResourceID - The azure resource id of the logic app receiver.
	ResourceID *string `json:"resourceId,omitempty"`
	// CallbackURL - The callback url where http request sent to.
	CallbackURL *string `json:"callbackUrl,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// LogSettings part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
type LogSettings struct {
	// Category - Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
	Category *string `json:"category,omitempty"`
	// CategoryGroup - Name of a Diagnostic Log category group for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
	CategoryGroup *string `json:"categoryGroup,omitempty"`
	// Enabled - a value indicating whether this log is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionPolicy - the retention policy for this log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// ManagementGroupDiagnosticSettings the management group diagnostic settings.
type ManagementGroupDiagnosticSettings struct {
	// StorageAccountID - The resource ID of the storage account to which you would like to send Diagnostic Logs.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// ServiceBusRuleID - The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`
	// EventHubAuthorizationRuleID - The resource Id for the event hub authorization rule.
	EventHubAuthorizationRuleID *string `json:"eventHubAuthorizationRuleId,omitempty"`
	// EventHubName - The name of the event hub. If none is specified, the default event hub will be selected.
	EventHubName *string `json:"eventHubName,omitempty"`
	// Logs - The list of logs settings.
	Logs *[]ManagementGroupLogSettings `json:"logs,omitempty"`
	// WorkspaceID - The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// MarketplacePartnerID - The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
	MarketplacePartnerID *string `json:"marketplacePartnerId,omitempty"`
}

// ManagementGroupDiagnosticSettingsResource the management group diagnostic setting resource.
type ManagementGroupDiagnosticSettingsResource struct {
	autorest.Response `json:"-"`
	// ManagementGroupDiagnosticSettings - Properties of a Management Group Diagnostic Settings Resource.
	*ManagementGroupDiagnosticSettings `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementGroupDiagnosticSettingsResource.
func (mgdsr ManagementGroupDiagnosticSettingsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mgdsr.ManagementGroupDiagnosticSettings != nil {
		objectMap["properties"] = mgdsr.ManagementGroupDiagnosticSettings
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagementGroupDiagnosticSettingsResource struct.
func (mgdsr *ManagementGroupDiagnosticSettingsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managementGroupDiagnosticSettings ManagementGroupDiagnosticSettings
				err = json.Unmarshal(*v, &managementGroupDiagnosticSettings)
				if err != nil {
					return err
				}
				mgdsr.ManagementGroupDiagnosticSettings = &managementGroupDiagnosticSettings
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mgdsr.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mgdsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mgdsr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mgdsr.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagementGroupDiagnosticSettingsResourceCollection represents a collection of management group
// diagnostic settings resources.
type ManagementGroupDiagnosticSettingsResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The collection of management group diagnostic settings resources.
	Value *[]ManagementGroupDiagnosticSettingsResource `json:"value,omitempty"`
}

// ManagementGroupLogSettings part of Management Group diagnostic setting. Specifies the settings for a
// particular log.
type ManagementGroupLogSettings struct {
	// Category - Name of a Management Group Diagnostic Log category for a resource type this setting is applied to.
	Category *string `json:"category,omitempty"`
	// CategoryGroup - Name of a Management Group Diagnostic Log category group for a resource type this setting is applied to.
	CategoryGroup *string `json:"categoryGroup,omitempty"`
	// Enabled - a value indicating whether this log is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// MetricSettings part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
type MetricSettings struct {
	// TimeGrain - the timegrain of the metric in ISO8601 format.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Category - Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
	Category *string `json:"category,omitempty"`
	// Enabled - a value indicating whether this category is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionPolicy - the retention policy for this category.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// MetricTrigger the trigger that results in a scaling action.
type MetricTrigger struct {
	// MetricName - the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`
	// MetricNamespace - the namespace of the metric that defines what the rule monitors.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// MetricResourceURI - the resource identifier of the resource the rule monitors.
	MetricResourceURI *string `json:"metricResourceUri,omitempty"`
	// MetricResourceLocation - the location of the resource the rule monitors.
	MetricResourceLocation *string `json:"metricResourceLocation,omitempty"`
	// TimeGrain - the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Statistic - the metric statistic type. How the metrics from multiple instances are combined. Possible values include: 'MetricStatisticTypeAverage', 'MetricStatisticTypeMin', 'MetricStatisticTypeMax', 'MetricStatisticTypeSum', 'MetricStatisticTypeCount'
	Statistic MetricStatisticType `json:"statistic,omitempty"`
	// TimeWindow - the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
	TimeWindow *string `json:"timeWindow,omitempty"`
	// TimeAggregation - time aggregation type. How the data that is collected should be combined over time. The default value is Average. Possible values include: 'TimeAggregationTypeAverage', 'TimeAggregationTypeMinimum', 'TimeAggregationTypeMaximum', 'TimeAggregationTypeTotal', 'TimeAggregationTypeCount', 'TimeAggregationTypeLast'
	TimeAggregation TimeAggregationType `json:"timeAggregation,omitempty"`
	// Operator - the operator that is used to compare the metric data and the threshold. Possible values include: 'ComparisonOperationTypeEquals', 'ComparisonOperationTypeNotEquals', 'ComparisonOperationTypeGreaterThan', 'ComparisonOperationTypeGreaterThanOrEqual', 'ComparisonOperationTypeLessThan', 'ComparisonOperationTypeLessThanOrEqual'
	Operator ComparisonOperationType `json:"operator,omitempty"`
	// Threshold - the threshold of the metric that triggers the scale action.
	Threshold *float64 `json:"threshold,omitempty"`
	// Dimensions - List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
	Dimensions *[]ScaleRuleMetricDimension `json:"dimensions,omitempty"`
	// DividePerInstance - a value indicating whether metric should divide per instance.
	DividePerInstance *bool `json:"dividePerInstance,omitempty"`
}

// NotificationRequestBody the request body which contain contact detail metadata
type NotificationRequestBody struct {
	// AlertType - The name of the supported alert type.
	AlertType *string `json:"alertType,omitempty"`
	// EmailReceivers - The list of email receivers that are part of this action group.
	EmailReceivers *[]EmailReceiver `json:"emailReceivers,omitempty"`
	// SmsReceivers - The list of SMS receivers that are part of this action group.
	SmsReceivers *[]SmsReceiver `json:"smsReceivers,omitempty"`
	// WebhookReceivers - The list of webhook receivers that are part of this action group.
	WebhookReceivers *[]WebhookReceiver `json:"webhookReceivers,omitempty"`
	// ItsmReceivers - The list of ITSM receivers that are part of this action group.
	ItsmReceivers *[]ItsmReceiver `json:"itsmReceivers,omitempty"`
	// AzureAppPushReceivers - The list of AzureAppPush receivers that are part of this action group.
	AzureAppPushReceivers *[]AzureAppPushReceiver `json:"azureAppPushReceivers,omitempty"`
	// AutomationRunbookReceivers - The list of AutomationRunbook receivers that are part of this action group.
	AutomationRunbookReceivers *[]AutomationRunbookReceiver `json:"automationRunbookReceivers,omitempty"`
	// VoiceReceivers - The list of voice receivers that are part of this action group.
	VoiceReceivers *[]VoiceReceiver `json:"voiceReceivers,omitempty"`
	// LogicAppReceivers - The list of logic app receivers that are part of this action group.
	LogicAppReceivers *[]LogicAppReceiver `json:"logicAppReceivers,omitempty"`
	// AzureFunctionReceivers - The list of azure function receivers that are part of this action group.
	AzureFunctionReceivers *[]AzureFunctionReceiver `json:"azureFunctionReceivers,omitempty"`
	// ArmRoleReceivers - The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
	ArmRoleReceivers *[]ArmRoleReceiver `json:"armRoleReceivers,omitempty"`
	// EventHubReceivers - The list of event hub receivers that are part of this action group.
	EventHubReceivers *[]EventHubReceiver `json:"eventHubReceivers,omitempty"`
}

// OperationStatus the status of operation.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - The operation Id.
	ID *string `json:"id,omitempty"`
	// Name - The operation name.
	Name *string `json:"name,omitempty"`
	// StartTime - Start time of the job in standard ISO8601 format.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the job in standard ISO8601 format.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Error - The error detail of the operation if any.
	Error *ErrorDetail `json:"error,omitempty"`
}

// PredictiveAutoscalePolicy the parameters for enabling predictive autoscale.
type PredictiveAutoscalePolicy struct {
	// ScaleMode - the predictive autoscale mode. Possible values include: 'PredictiveAutoscalePolicyScaleModeDisabled', 'PredictiveAutoscalePolicyScaleModeForecastOnly', 'PredictiveAutoscalePolicyScaleModeEnabled'
	ScaleMode PredictiveAutoscalePolicyScaleMode `json:"scaleMode,omitempty"`
	// ScaleLookAheadTime - the amount of time to specify by which instances are launched in advance. It must be between 1 minute and 60 minutes in ISO 8601 format.
	ScaleLookAheadTime *string `json:"scaleLookAheadTime,omitempty"`
}

// PredictiveResponse the response to a metrics query.
type PredictiveResponse struct {
	autorest.Response `json:"-"`
	// Timespan - The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested.
	Timespan *string `json:"timespan,omitempty"`
	// Interval - The interval (window size) for which the metric data was returned in.  This may be adjusted in the future and returned back from what was originally requested.  This is not present if a metadata request was made.
	Interval *string `json:"interval,omitempty"`
	// MetricName - The metrics being queried
	MetricName *string `json:"metricName,omitempty"`
	// TargetResourceID - resource of the predictive metric.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// Data - the value of the collection.
	Data *[]PredictiveValue `json:"data,omitempty"`
}

// PredictiveValue represents a predictive metric value in the given bucket.
type PredictiveValue struct {
	// TimeStamp - the timestamp for the metric value in ISO 8601 format.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// Value - Predictive value in this time bucket.
	Value *float64 `json:"value,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// storage account
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "diagnostics.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("diagnostics.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "diagnostics.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "diagnostics.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("diagnostics.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkScopedResourcesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateLinkScopedResourcesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkScopedResourcesClient) (ScopedResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateLinkScopedResourcesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateLinkScopedResourcesCreateOrUpdateFuture.Result.
func (future *PrivateLinkScopedResourcesCreateOrUpdateFuture) result(client PrivateLinkScopedResourcesClient) (sr ScopedResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "diagnostics.PrivateLinkScopedResourcesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("diagnostics.PrivateLinkScopedResourcesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.CreateOrUpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "diagnostics.PrivateLinkScopedResourcesCreateOrUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateLinkScopedResourcesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateLinkScopedResourcesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkScopedResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateLinkScopedResourcesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateLinkScopedResourcesDeleteFuture.Result.
func (future *PrivateLinkScopedResourcesDeleteFuture) result(client PrivateLinkScopedResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "diagnostics.PrivateLinkScopedResourcesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("diagnostics.PrivateLinkScopedResourcesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkScopesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateLinkScopesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkScopesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateLinkScopesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateLinkScopesDeleteFuture.Result.
func (future *PrivateLinkScopesDeleteFuture) result(client PrivateLinkScopesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "diagnostics.PrivateLinkScopesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("diagnostics.PrivateLinkScopesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Recurrence the repeating times at which this profile begins. This element is not used if the FixedDate
// element is used.
type Recurrence struct {
	// Frequency - the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly. Possible values include: 'RecurrenceFrequencyNone', 'RecurrenceFrequencySecond', 'RecurrenceFrequencyMinute', 'RecurrenceFrequencyHour', 'RecurrenceFrequencyDay', 'RecurrenceFrequencyWeek', 'RecurrenceFrequencyMonth', 'RecurrenceFrequencyYear'
	Frequency RecurrenceFrequency `json:"frequency,omitempty"`
	// Schedule - the scheduling constraints for when the profile begins.
	Schedule *RecurrentSchedule `json:"schedule,omitempty"`
}

// RecurrentSchedule the scheduling constraints for when the profile begins.
type RecurrentSchedule struct {
	// TimeZone - the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
	// Days - the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
	Days *[]string `json:"days,omitempty"`
	// Hours - A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
	Hours *[]int32 `json:"hours,omitempty"`
	// Minutes - A collection of minutes at which the profile takes effect at.
	Minutes *[]int32 `json:"minutes,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RetentionPolicy specifies the retention policy for the log.
type RetentionPolicy struct {
	// Enabled - a value indicating whether the retention policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Days - the number of days for the retention in days. A value of 0 will retain the events indefinitely.
	Days *int32 `json:"days,omitempty"`
}

// ScaleAction the parameters for the scaling action.
type ScaleAction struct {
	// Direction - the scale direction. Whether the scaling action increases or decreases the number of instances. Possible values include: 'ScaleDirectionNone', 'ScaleDirectionIncrease', 'ScaleDirectionDecrease'
	Direction ScaleDirection `json:"direction,omitempty"`
	// Type - the type of action that should occur when the scale rule fires. Possible values include: 'ScaleTypeChangeCount', 'ScaleTypePercentChangeCount', 'ScaleTypeExactCount', 'ScaleTypeServiceAllowedNextValue'
	Type ScaleType `json:"type,omitempty"`
	// Value - the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
	Value *string `json:"value,omitempty"`
	// Cooldown - the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
	Cooldown *string `json:"cooldown,omitempty"`
}

// ScaleCapacity the number of instances that can be used during this profile.
type ScaleCapacity struct {
	// Minimum - the minimum number of instances for the resource.
	Minimum *string `json:"minimum,omitempty"`
	// Maximum - the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
	Maximum *string `json:"maximum,omitempty"`
	// Default - the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
	Default *string `json:"default,omitempty"`
}

// ScaleRule a rule that provide the triggers and parameters for the scaling action.
type ScaleRule struct {
	// MetricTrigger - the trigger that results in a scaling action.
	MetricTrigger *MetricTrigger `json:"metricTrigger,omitempty"`
	// ScaleAction - the parameters for the scaling action.
	ScaleAction *ScaleAction `json:"scaleAction,omitempty"`
}

// ScaleRuleMetricDimension specifies an auto scale rule metric dimension.
type ScaleRuleMetricDimension struct {
	// DimensionName - Name of the dimension.
	DimensionName *string `json:"DimensionName,omitempty"`
	// Operator - the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values. Possible values include: 'ScaleRuleMetricDimensionOperationTypeEquals', 'ScaleRuleMetricDimensionOperationTypeNotEquals'
	Operator ScaleRuleMetricDimensionOperationType `json:"Operator,omitempty"`
	// Values - list of dimension values. For example: ["App1","App2"].
	Values *[]string `json:"Values,omitempty"`
}

// ScopedResource a private link scoped resource
type ScopedResource struct {
	autorest.Response `json:"-"`
	// ScopedResourceProperties - Resource properties.
	*ScopedResourceProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; System data
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopedResource.
func (sr ScopedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.ScopedResourceProperties != nil {
		objectMap["properties"] = sr.ScopedResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScopedResource struct.
func (sr *ScopedResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scopedResourceProperties ScopedResourceProperties
				err = json.Unmarshal(*v, &scopedResourceProperties)
				if err != nil {
					return err
				}
				sr.ScopedResourceProperties = &scopedResourceProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sr.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		}
	}

	return nil
}

// ScopedResourceListResult a list of scoped resources in a private link scope.
type ScopedResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ScopedResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopedResourceListResult.
func (srlr ScopedResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ScopedResourceListResultIterator provides access to a complete listing of ScopedResource values.
type ScopedResourceListResultIterator struct {
	i    int
	page ScopedResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScopedResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScopedResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScopedResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScopedResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScopedResourceListResultIterator) Response() ScopedResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScopedResourceListResultIterator) Value() ScopedResource {
	if !iter.page.NotDone() {
		return ScopedResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScopedResourceListResultIterator type.
func NewScopedResourceListResultIterator(page ScopedResourceListResultPage) ScopedResourceListResultIterator {
	return ScopedResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srlr ScopedResourceListResult) IsEmpty() bool {
	return srlr.Value == nil || len(*srlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srlr ScopedResourceListResult) hasNextLink() bool {
	return srlr.NextLink != nil && len(*srlr.NextLink) != 0
}

// scopedResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srlr ScopedResourceListResult) scopedResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !srlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srlr.NextLink)))
}

// ScopedResourceListResultPage contains a page of ScopedResource values.
type ScopedResourceListResultPage struct {
	fn   func(context.Context, ScopedResourceListResult) (ScopedResourceListResult, error)
	srlr ScopedResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScopedResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScopedResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srlr)
		if err != nil {
			return err
		}
		page.srlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScopedResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScopedResourceListResultPage) NotDone() bool {
	return !page.srlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScopedResourceListResultPage) Response() ScopedResourceListResult {
	return page.srlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScopedResourceListResultPage) Values() []ScopedResource {
	if page.srlr.IsEmpty() {
		return nil
	}
	return *page.srlr.Value
}

// Creates a new instance of the ScopedResourceListResultPage type.
func NewScopedResourceListResultPage(cur ScopedResourceListResult, getNextPage func(context.Context, ScopedResourceListResult) (ScopedResourceListResult, error)) ScopedResourceListResultPage {
	return ScopedResourceListResultPage{
		fn:   getNextPage,
		srlr: cur,
	}
}

// ScopedResourceProperties properties of a private link scoped resource.
type ScopedResourceProperties struct {
	// LinkedResourceID - The resource id of the scoped Azure monitor resource.
	LinkedResourceID *string `json:"linkedResourceId,omitempty"`
	// ProvisioningState - READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopedResourceProperties.
func (srp ScopedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srp.LinkedResourceID != nil {
		objectMap["linkedResourceId"] = srp.LinkedResourceID
	}
	return json.Marshal(objectMap)
}

// Settings the diagnostic settings.
type Settings struct {
	// StorageAccountID - The resource ID of the storage account to which you would like to send Diagnostic Logs.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// ServiceBusRuleID - The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`
	// EventHubAuthorizationRuleID - The resource Id for the event hub authorization rule.
	EventHubAuthorizationRuleID *string `json:"eventHubAuthorizationRuleId,omitempty"`
	// EventHubName - The name of the event hub. If none is specified, the default event hub will be selected.
	EventHubName *string `json:"eventHubName,omitempty"`
	// Metrics - The list of metric settings.
	Metrics *[]MetricSettings `json:"metrics,omitempty"`
	// Logs - The list of logs settings.
	Logs *[]LogSettings `json:"logs,omitempty"`
	// WorkspaceID - The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// MarketplacePartnerID - The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
	MarketplacePartnerID *string `json:"marketplacePartnerId,omitempty"`
	// LogAnalyticsDestinationType - A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics, or use a destination type constructed as follows: <normalized service identity>_<normalized category name>. Possible values are: Dedicated and null (null is default.)
	LogAnalyticsDestinationType *string `json:"logAnalyticsDestinationType,omitempty"`
}

// SettingsCategory the diagnostic settings Category.
type SettingsCategory struct {
	// CategoryType - The type of the diagnostic settings category. Possible values include: 'CategoryTypeMetrics', 'CategoryTypeLogs'
	CategoryType CategoryType `json:"categoryType,omitempty"`
	// CategoryGroups - the collection of what category groups are supported.
	CategoryGroups *[]string `json:"categoryGroups,omitempty"`
}

// SettingsCategoryResource the diagnostic settings category resource.
type SettingsCategoryResource struct {
	autorest.Response `json:"-"`
	// SettingsCategory - The properties of a Diagnostic Settings Category.
	*SettingsCategory `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SettingsCategoryResource.
func (scr SettingsCategoryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scr.SettingsCategory != nil {
		objectMap["properties"] = scr.SettingsCategory
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SettingsCategoryResource struct.
func (scr *SettingsCategoryResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var settingsCategory SettingsCategory
				err = json.Unmarshal(*v, &settingsCategory)
				if err != nil {
					return err
				}
				scr.SettingsCategory = &settingsCategory
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				scr.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scr.Type = &typeVar
			}
		}
	}

	return nil
}

// SettingsCategoryResourceCollection represents a collection of diagnostic setting category resources.
type SettingsCategoryResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The collection of diagnostic settings category resources.
	Value *[]SettingsCategoryResource `json:"value,omitempty"`
}

// SettingsResource the diagnostic setting resource.
type SettingsResource struct {
	autorest.Response `json:"-"`
	// Settings - Properties of a Diagnostic Settings Resource.
	*Settings `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SettingsResource.
func (sr SettingsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Settings != nil {
		objectMap["properties"] = sr.Settings
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SettingsResource struct.
func (sr *SettingsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var settings Settings
				err = json.Unmarshal(*v, &settings)
				if err != nil {
					return err
				}
				sr.Settings = &settings
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sr.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		}
	}

	return nil
}

// SettingsResourceCollection represents a collection of alert rule resources.
type SettingsResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The collection of diagnostic settings resources;.
	Value *[]SettingsResource `json:"value,omitempty"`
}

// SmsReceiver an SMS receiver.
type SmsReceiver struct {
	// Name - The name of the SMS receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// CountryCode - The country code of the SMS receiver.
	CountryCode *string `json:"countryCode,omitempty"`
	// PhoneNumber - The phone number of the SMS receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`
	// Status - READ-ONLY; The status of the receiver. Possible values include: 'ReceiverStatusNotSpecified', 'ReceiverStatusEnabled', 'ReceiverStatusDisabled'
	Status ReceiverStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for SmsReceiver.
func (sr SmsReceiver) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.CountryCode != nil {
		objectMap["countryCode"] = sr.CountryCode
	}
	if sr.PhoneNumber != nil {
		objectMap["phoneNumber"] = sr.PhoneNumber
	}
	return json.Marshal(objectMap)
}

// SubscriptionDiagnosticSettings the subscription diagnostic settings.
type SubscriptionDiagnosticSettings struct {
	// StorageAccountID - The resource ID of the storage account to which you would like to send Diagnostic Logs.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// ServiceBusRuleID - The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`
	// EventHubAuthorizationRuleID - The resource Id for the event hub authorization rule.
	EventHubAuthorizationRuleID *string `json:"eventHubAuthorizationRuleId,omitempty"`
	// EventHubName - The name of the event hub. If none is specified, the default event hub will be selected.
	EventHubName *string `json:"eventHubName,omitempty"`
	// Logs - The list of logs settings.
	Logs *[]SubscriptionLogSettings `json:"logs,omitempty"`
	// WorkspaceID - The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// MarketplacePartnerID - The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
	MarketplacePartnerID *string `json:"marketplacePartnerId,omitempty"`
}

// SubscriptionDiagnosticSettingsResource the subscription diagnostic setting resource.
type SubscriptionDiagnosticSettingsResource struct {
	autorest.Response `json:"-"`
	// SubscriptionDiagnosticSettings - Properties of a Subscription Diagnostic Settings Resource.
	*SubscriptionDiagnosticSettings `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionDiagnosticSettingsResource.
func (sdsr SubscriptionDiagnosticSettingsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdsr.SubscriptionDiagnosticSettings != nil {
		objectMap["properties"] = sdsr.SubscriptionDiagnosticSettings
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionDiagnosticSettingsResource struct.
func (sdsr *SubscriptionDiagnosticSettingsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionDiagnosticSettings SubscriptionDiagnosticSettings
				err = json.Unmarshal(*v, &subscriptionDiagnosticSettings)
				if err != nil {
					return err
				}
				sdsr.SubscriptionDiagnosticSettings = &subscriptionDiagnosticSettings
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sdsr.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sdsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sdsr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sdsr.Type = &typeVar
			}
		}
	}

	return nil
}

// SubscriptionDiagnosticSettingsResourceCollection represents a collection of subscription diagnostic
// settings resources.
type SubscriptionDiagnosticSettingsResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The collection of subscription diagnostic settings resources.
	Value *[]SubscriptionDiagnosticSettingsResource `json:"value,omitempty"`
}

// SubscriptionLogSettings part of Subscription diagnostic setting. Specifies the settings for a particular
// log.
type SubscriptionLogSettings struct {
	// Category - Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
	Category *string `json:"category,omitempty"`
	// CategoryGroup - Name of a Subscription Diagnostic Log category group for a resource type this setting is applied to.
	CategoryGroup *string `json:"categoryGroup,omitempty"`
	// Enabled - a value indicating whether this log is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags on a
// PrivateLinkScope instance.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TestNotificationDetailsResponse the details of the test notification results.
type TestNotificationDetailsResponse struct {
	autorest.Response `json:"-"`
	Context           *Context `json:"Context,omitempty"`
	// State - The overall state
	State *string `json:"State,omitempty"`
	// CompletedTime - The completed time
	CompletedTime *string `json:"CompletedTime,omitempty"`
	// CreatedTime - The created time
	CreatedTime *string `json:"CreatedTime,omitempty"`
	// ActionDetails - The list of action detail
	ActionDetails *[]ActionDetail `json:"ActionDetails,omitempty"`
}

// TestNotificationResponse the response when test notification succeeded
type TestNotificationResponse struct {
	autorest.Response `json:"-"`
	// NotificationID - The notification id
	NotificationID *string `json:"notificationId,omitempty"`
	// CorrelationID - The correlation id
	CorrelationID *string `json:"correlationId,omitempty"`
	// CreatedTime - The created time
	CreatedTime *string `json:"createdTime,omitempty"`
}

// TimeWindow a specific date-time for the profile.
type TimeWindow struct {
	// TimeZone - the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
	// Start - the start time for the profile in ISO 8601 format.
	Start *date.Time `json:"start,omitempty"`
	// End - the end time for the profile in ISO 8601 format.
	End *date.Time `json:"end,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// VoiceReceiver a voice receiver.
type VoiceReceiver struct {
	// Name - The name of the voice receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// CountryCode - The country code of the voice receiver.
	CountryCode *string `json:"countryCode,omitempty"`
	// PhoneNumber - The phone number of the voice receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}

// WebhookNotification webhook notification of an autoscale event.
type WebhookNotification struct {
	// ServiceURI - the service address to receive the notification.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// Properties - a property bag of settings. This value can be empty.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for WebhookNotification.
func (wn WebhookNotification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wn.ServiceURI != nil {
		objectMap["serviceUri"] = wn.ServiceURI
	}
	if wn.Properties != nil {
		objectMap["properties"] = wn.Properties
	}
	return json.Marshal(objectMap)
}

// WebhookReceiver a webhook receiver.
type WebhookReceiver struct {
	// Name - The name of the webhook receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// ServiceURI - The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// UseCommonAlertSchema - Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
	// UseAadAuth - Indicates whether or not use AAD authentication.
	UseAadAuth *bool `json:"useAadAuth,omitempty"`
	// ObjectID - Indicates the webhook app object Id for aad auth.
	ObjectID *string `json:"objectId,omitempty"`
	// IdentifierURI - Indicates the identifier uri for aad auth.
	IdentifierURI *string `json:"identifierUri,omitempty"`
	// TenantID - Indicates the tenant id for aad auth.
	TenantID *string `json:"tenantId,omitempty"`
}
