package labservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/labservices/mgmt/2021-11-15-preview/labservices"

// AutoShutdownProfile profile for how to handle shutting down virtual machines.
type AutoShutdownProfile struct {
	// ShutdownOnDisconnect - Whether shutdown on disconnect is enabled. Possible values include: 'EnableStateEnabled', 'EnableStateDisabled'
	ShutdownOnDisconnect EnableState `json:"shutdownOnDisconnect,omitempty"`
	// ShutdownWhenNotConnected - Whether a VM will get shutdown when it hasn't been connected to after a period of time. Possible values include: 'EnableStateEnabled', 'EnableStateDisabled'
	ShutdownWhenNotConnected EnableState `json:"shutdownWhenNotConnected,omitempty"`
	// ShutdownOnIdle - Whether a VM will get shutdown when it has idled for a period of time. Possible values include: 'ShutdownOnIdleModeNone', 'ShutdownOnIdleModeUserAbsence', 'ShutdownOnIdleModeLowUsage'
	ShutdownOnIdle ShutdownOnIdleMode `json:"shutdownOnIdle,omitempty"`
	// DisconnectDelay - The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
	DisconnectDelay *string `json:"disconnectDelay,omitempty"`
	// NoConnectDelay - The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
	NoConnectDelay *string `json:"noConnectDelay,omitempty"`
	// IdleDelay - The amount of time a VM will idle before it is shutdown if this behavior is enabled.
	IdleDelay *string `json:"idleDelay,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectionProfile connection profile for how users connect to lab virtual machines.
type ConnectionProfile struct {
	// WebSSHAccess - The enabled access level for Web Access over SSH. Possible values include: 'ConnectionTypePublic', 'ConnectionTypePrivate', 'ConnectionTypeNone'
	WebSSHAccess ConnectionType `json:"webSshAccess,omitempty"`
	// WebRdpAccess - The enabled access level for Web Access over RDP. Possible values include: 'ConnectionTypePublic', 'ConnectionTypePrivate', 'ConnectionTypeNone'
	WebRdpAccess ConnectionType `json:"webRdpAccess,omitempty"`
	// ClientSSHAccess - The enabled access level for Client Access over SSH. Possible values include: 'ConnectionTypePublic', 'ConnectionTypePrivate', 'ConnectionTypeNone'
	ClientSSHAccess ConnectionType `json:"clientSshAccess,omitempty"`
	// ClientRdpAccess - The enabled access level for Client Access over RDP. Possible values include: 'ConnectionTypePublic', 'ConnectionTypePrivate', 'ConnectionTypeNone'
	ClientRdpAccess ConnectionType `json:"clientRdpAccess,omitempty"`
}

// Credentials credentials for a user on a lab VM.
type Credentials struct {
	// Username - The username to use when signing in to lab VMs.
	Username *string `json:"username,omitempty"`
	// Password - The password for the user. This is required for the TemplateVM createOption.
	Password *string `json:"password,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// Image lab services virtual machine image
type Image struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the image.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ImageProperties - Image resource properties
	*ImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Image.
func (i Image) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.ImageProperties != nil {
		objectMap["properties"] = i.ImageProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Image struct.
func (i *Image) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				i.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var imageProperties ImageProperties
				err = json.Unmarshal(*v, &imageProperties)
				if err != nil {
					return err
				}
				i.ImageProperties = &imageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		}
	}

	return nil
}

// ImageProperties properties of an image resource.
type ImageProperties struct {
	// ProvisioningState - READ-ONLY; Current provisioning state of the image. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateLocked'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// DisplayName - READ-ONLY; The image display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; A description of the image.
	Description *string `json:"description,omitempty"`
	// IconURL - READ-ONLY; URL of the image icon.
	IconURL *string `json:"iconUrl,omitempty"`
	// Author - READ-ONLY; The image author.
	Author *string `json:"author,omitempty"`
	// OsType - READ-ONLY; The OS Type of the image. Possible values include: 'OsTypeWindows', 'OsTypeLinux'
	OsType OsType `json:"osType,omitempty"`
	// Plan - READ-ONLY; The ID of marketplace plan associated with the image (optional).
	Plan *string `json:"plan,omitempty"`
	// TermsStatus - READ-ONLY; The status of image terms of use (enabled = accepted, disabled = not accepted). Possible values include: 'EnableStateEnabled', 'EnableStateDisabled'
	TermsStatus EnableState `json:"termsStatus,omitempty"`
	// Offer - READ-ONLY; The ID of an offer associated with the image.
	Offer *string `json:"offer,omitempty"`
	// Publisher - READ-ONLY; The ID of the publisher of the image.
	Publisher *string `json:"publisher,omitempty"`
	// Sku - READ-ONLY; The image SKU.
	Sku *string `json:"sku,omitempty"`
	// Version - READ-ONLY; The image version.
	Version *string `json:"version,omitempty"`
	// SharedGalleryID - READ-ONLY; The ID for the image in the shared gallery.
	SharedGalleryID *string `json:"sharedGalleryId,omitempty"`
	// AvailableRegions - The available regions of the image in the shared gallery.
	AvailableRegions *[]string `json:"availableRegions,omitempty"`
	// OsState - READ-ONLY; The OS State of the image. Possible values include: 'OsStateGeneralized', 'OsStateSpecialized'
	OsState OsState `json:"osState,omitempty"`
	// EnabledState - Is the image enabled. Possible values include: 'EnableStateEnabled', 'EnableStateDisabled'
	EnabledState EnableState `json:"enabledState,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageProperties.
func (IP ImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.AvailableRegions != nil {
		objectMap["availableRegions"] = IP.AvailableRegions
	}
	if IP.EnabledState != "" {
		objectMap["enabledState"] = IP.EnabledState
	}
	return json.Marshal(objectMap)
}

// ImageReference image reference information. Used in the virtual machine profile.
type ImageReference struct {
	// ID - Image resource ID
	ID *string `json:"id,omitempty"`
	// Offer - The image offer if applicable.
	Offer *string `json:"offer,omitempty"`
	// Publisher - The image publisher
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The image SKU
	Sku *string `json:"sku,omitempty"`
	// Version - The image version specified on creation.
	Version *string `json:"version,omitempty"`
	// ExactVersion - READ-ONLY; The actual version of the image after use.
	ExactVersion *string `json:"exactVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageReference.
func (ir ImageReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ir.ID != nil {
		objectMap["id"] = ir.ID
	}
	if ir.Offer != nil {
		objectMap["offer"] = ir.Offer
	}
	if ir.Publisher != nil {
		objectMap["publisher"] = ir.Publisher
	}
	if ir.Sku != nil {
		objectMap["sku"] = ir.Sku
	}
	if ir.Version != nil {
		objectMap["version"] = ir.Version
	}
	return json.Marshal(objectMap)
}

// ImageUpdate lab services virtual machine image for updates.
type ImageUpdate struct {
	// ImageUpdateProperties - Image resource properties
	*ImageUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageUpdate.
func (iu ImageUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iu.ImageUpdateProperties != nil {
		objectMap["properties"] = iu.ImageUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImageUpdate struct.
func (iu *ImageUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var imageUpdateProperties ImageUpdateProperties
				err = json.Unmarshal(*v, &imageUpdateProperties)
				if err != nil {
					return err
				}
				iu.ImageUpdateProperties = &imageUpdateProperties
			}
		}
	}

	return nil
}

// ImageUpdateProperties properties of an image resource update
type ImageUpdateProperties struct {
	// EnabledState - Is the image enabled. Possible values include: 'EnableStateEnabled', 'EnableStateDisabled'
	EnabledState EnableState `json:"enabledState,omitempty"`
}

// InviteBody body for a user invite request
type InviteBody struct {
	// Text - Custom text for the invite email.
	Text *string `json:"text,omitempty"`
}

// Lab the lab resource.
type Lab struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the lab.
	SystemData *SystemData `json:"systemData,omitempty"`
	// LabProperties - Lab resource properties
	*LabProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Lab.
func (l Lab) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.LabProperties != nil {
		objectMap["properties"] = l.LabProperties
	}
	if l.Tags != nil {
		objectMap["tags"] = l.Tags
	}
	if l.Location != nil {
		objectMap["location"] = l.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Lab struct.
func (l *Lab) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				l.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var labProperties LabProperties
				err = json.Unmarshal(*v, &labProperties)
				if err != nil {
					return err
				}
				l.LabProperties = &labProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				l.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				l.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				l.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				l.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				l.Type = &typeVar
			}
		}
	}

	return nil
}

// LabNetworkProfile profile for how to handle networking for Labs.
type LabNetworkProfile struct {
	// SubnetID - The external subnet resource id
	SubnetID *string `json:"subnetId,omitempty"`
	// LoadBalancerID - The external load balancer resource id
	LoadBalancerID *string `json:"loadBalancerId,omitempty"`
	// PublicIPID - The external public IP resource id
	PublicIPID *string `json:"publicIpId,omitempty"`
}

// LabPlan lab Plans act as a permission container for creating labs via labs.azure.com. Additionally, they
// can provide a set of default configurations that will apply at the time of creating a lab, but these
// defaults can still be overwritten.
type LabPlan struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the lab plan.
	SystemData *SystemData `json:"systemData,omitempty"`
	// LabPlanProperties - Lab plan resource properties
	*LabPlanProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LabPlan.
func (lp LabPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lp.LabPlanProperties != nil {
		objectMap["properties"] = lp.LabPlanProperties
	}
	if lp.Tags != nil {
		objectMap["tags"] = lp.Tags
	}
	if lp.Location != nil {
		objectMap["location"] = lp.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabPlan struct.
func (lp *LabPlan) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				lp.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var labPlanProperties LabPlanProperties
				err = json.Unmarshal(*v, &labPlanProperties)
				if err != nil {
					return err
				}
				lp.LabPlanProperties = &labPlanProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lp.Type = &typeVar
			}
		}
	}

	return nil
}

// LabPlanNetworkProfile profile for how to handle networking for Lab Plans.
type LabPlanNetworkProfile struct {
	// SubnetID - The external subnet resource id
	SubnetID *string `json:"subnetId,omitempty"`
}

// LabPlanProperties lab plan resource properties
type LabPlanProperties struct {
	// ProvisioningState - READ-ONLY; Current provisioning state of the lab plan. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateLocked'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// DefaultConnectionProfile - The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
	DefaultConnectionProfile *ConnectionProfile `json:"defaultConnectionProfile,omitempty"`
	// DefaultAutoShutdownProfile - The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
	DefaultAutoShutdownProfile *AutoShutdownProfile `json:"defaultAutoShutdownProfile,omitempty"`
	// DefaultNetworkProfile - The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan.
	DefaultNetworkProfile *LabPlanNetworkProfile `json:"defaultNetworkProfile,omitempty"`
	// AllowedRegions - The allowed regions for the lab creator to use when creating labs using this lab plan.
	AllowedRegions *[]string `json:"allowedRegions,omitempty"`
	// SharedGalleryID - Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it will be persisted in this gallery. Shared images from the gallery can be made available to use when creating new labs.
	SharedGalleryID *string `json:"sharedGalleryId,omitempty"`
	// SupportInfo - Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan.
	SupportInfo *SupportInfo `json:"supportInfo,omitempty"`
	// LinkedLmsInstance - Base Url of the lms instance this lab plan can link lab rosters against.
	LinkedLmsInstance *string `json:"linkedLmsInstance,omitempty"`
}

// MarshalJSON is the custom marshaler for LabPlanProperties.
func (lpp LabPlanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lpp.DefaultConnectionProfile != nil {
		objectMap["defaultConnectionProfile"] = lpp.DefaultConnectionProfile
	}
	if lpp.DefaultAutoShutdownProfile != nil {
		objectMap["defaultAutoShutdownProfile"] = lpp.DefaultAutoShutdownProfile
	}
	if lpp.DefaultNetworkProfile != nil {
		objectMap["defaultNetworkProfile"] = lpp.DefaultNetworkProfile
	}
	if lpp.AllowedRegions != nil {
		objectMap["allowedRegions"] = lpp.AllowedRegions
	}
	if lpp.SharedGalleryID != nil {
		objectMap["sharedGalleryId"] = lpp.SharedGalleryID
	}
	if lpp.SupportInfo != nil {
		objectMap["supportInfo"] = lpp.SupportInfo
	}
	if lpp.LinkedLmsInstance != nil {
		objectMap["linkedLmsInstance"] = lpp.LinkedLmsInstance
	}
	return json.Marshal(objectMap)
}

// LabPlansCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabPlansCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabPlansClient) (LabPlan, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabPlansCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabPlansCreateOrUpdateFuture.Result.
func (future *LabPlansCreateOrUpdateFuture) result(client LabPlansClient) (lp LabPlan, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabPlansCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		lp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabPlansCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lp.Response.Response, err = future.GetResult(sender); err == nil && lp.Response.Response.StatusCode != http.StatusNoContent {
		lp, err = client.CreateOrUpdateResponder(lp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "labservices.LabPlansCreateOrUpdateFuture", "Result", lp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LabPlansDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabPlansDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabPlansClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabPlansDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabPlansDeleteFuture.Result.
func (future *LabPlansDeleteFuture) result(client LabPlansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabPlansDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabPlansDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabPlansSaveImageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabPlansSaveImageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabPlansClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabPlansSaveImageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabPlansSaveImageFuture.Result.
func (future *LabPlansSaveImageFuture) result(client LabPlansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabPlansSaveImageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabPlansSaveImageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabPlansUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabPlansUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabPlansClient) (LabPlan, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabPlansUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabPlansUpdateFuture.Result.
func (future *LabPlansUpdateFuture) result(client LabPlansClient) (lp LabPlan, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabPlansUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		lp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabPlansUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lp.Response.Response, err = future.GetResult(sender); err == nil && lp.Response.Response.StatusCode != http.StatusNoContent {
		lp, err = client.UpdateResponder(lp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "labservices.LabPlansUpdateFuture", "Result", lp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LabPlanUpdate contains lab configuration and default settings. This variant is used for PATCH.
type LabPlanUpdate struct {
	// LabPlanUpdateProperties - Lab plan resource update properties
	*LabPlanUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags *[]string `json:"tags,omitempty"`
}

// MarshalJSON is the custom marshaler for LabPlanUpdate.
func (lpu LabPlanUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lpu.LabPlanUpdateProperties != nil {
		objectMap["properties"] = lpu.LabPlanUpdateProperties
	}
	if lpu.Tags != nil {
		objectMap["tags"] = lpu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabPlanUpdate struct.
func (lpu *LabPlanUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labPlanUpdateProperties LabPlanUpdateProperties
				err = json.Unmarshal(*v, &labPlanUpdateProperties)
				if err != nil {
					return err
				}
				lpu.LabPlanUpdateProperties = &labPlanUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags []string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lpu.Tags = &tags
			}
		}
	}

	return nil
}

// LabPlanUpdateProperties lab plan resource properties for updates
type LabPlanUpdateProperties struct {
	// DefaultConnectionProfile - The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
	DefaultConnectionProfile *ConnectionProfile `json:"defaultConnectionProfile,omitempty"`
	// DefaultAutoShutdownProfile - The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
	DefaultAutoShutdownProfile *AutoShutdownProfile `json:"defaultAutoShutdownProfile,omitempty"`
	// DefaultNetworkProfile - The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan.
	DefaultNetworkProfile *LabPlanNetworkProfile `json:"defaultNetworkProfile,omitempty"`
	// AllowedRegions - The allowed regions for the lab creator to use when creating labs using this lab plan.
	AllowedRegions *[]string `json:"allowedRegions,omitempty"`
	// SharedGalleryID - Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it will be persisted in this gallery. Shared images from the gallery can be made available to use when creating new labs.
	SharedGalleryID *string `json:"sharedGalleryId,omitempty"`
	// SupportInfo - Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan.
	SupportInfo *SupportInfo `json:"supportInfo,omitempty"`
	// LinkedLmsInstance - Base Url of the lms instance this lab plan can link lab rosters against.
	LinkedLmsInstance *string `json:"linkedLmsInstance,omitempty"`
}

// LabProperties properties of a lab resource.
type LabProperties struct {
	// ProvisioningState - READ-ONLY; Current provisioning state of the lab. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateLocked'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// NetworkProfile - The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created.
	NetworkProfile *LabNetworkProfile `json:"networkProfile,omitempty"`
	// State - READ-ONLY; The lab state. Possible values include: 'LabStateDraft', 'LabStatePublishing', 'LabStateScaling', 'LabStateSyncing', 'LabStatePublished'
	State LabState `json:"state,omitempty"`
	// AutoShutdownProfile - The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle.
	AutoShutdownProfile *AutoShutdownProfile `json:"autoShutdownProfile,omitempty"`
	// ConnectionProfile - The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open.
	ConnectionProfile *ConnectionProfile `json:"connectionProfile,omitempty"`
	// VirtualMachineProfile - The profile used for creating lab virtual machines.
	VirtualMachineProfile *VirtualMachineProfile `json:"virtualMachineProfile,omitempty"`
	// SecurityProfile - The lab security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// RosterProfile - The lab user list management profile.
	RosterProfile *RosterProfile `json:"rosterProfile,omitempty"`
	// LabPlanID - The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization..
	LabPlanID *string `json:"labPlanId,omitempty"`
	// Title - The title of the lab.
	Title *string `json:"title,omitempty"`
	// Description - The description of the lab.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for LabProperties.
func (lp LabProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lp.NetworkProfile != nil {
		objectMap["networkProfile"] = lp.NetworkProfile
	}
	if lp.AutoShutdownProfile != nil {
		objectMap["autoShutdownProfile"] = lp.AutoShutdownProfile
	}
	if lp.ConnectionProfile != nil {
		objectMap["connectionProfile"] = lp.ConnectionProfile
	}
	if lp.VirtualMachineProfile != nil {
		objectMap["virtualMachineProfile"] = lp.VirtualMachineProfile
	}
	if lp.SecurityProfile != nil {
		objectMap["securityProfile"] = lp.SecurityProfile
	}
	if lp.RosterProfile != nil {
		objectMap["rosterProfile"] = lp.RosterProfile
	}
	if lp.LabPlanID != nil {
		objectMap["labPlanId"] = lp.LabPlanID
	}
	if lp.Title != nil {
		objectMap["title"] = lp.Title
	}
	if lp.Description != nil {
		objectMap["description"] = lp.Description
	}
	return json.Marshal(objectMap)
}

// LabsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (Lab, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsCreateOrUpdateFuture.Result.
func (future *LabsCreateOrUpdateFuture) result(client LabsClient) (l Lab, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		l.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if l.Response.Response, err = future.GetResult(sender); err == nil && l.Response.Response.StatusCode != http.StatusNoContent {
		l, err = client.CreateOrUpdateResponder(l.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "labservices.LabsCreateOrUpdateFuture", "Result", l.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LabsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LabsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsDeleteFuture.Result.
func (future *LabsDeleteFuture) result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsPublishFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LabsPublishFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsPublishFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsPublishFuture.Result.
func (future *LabsPublishFuture) result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabsPublishFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabsPublishFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsSyncGroupFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsSyncGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsSyncGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsSyncGroupFuture.Result.
func (future *LabsSyncGroupFuture) result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabsSyncGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabsSyncGroupFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LabsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (Lab, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsUpdateFuture.Result.
func (future *LabsUpdateFuture) result(client LabsClient) (l Lab, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		l.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if l.Response.Response, err = future.GetResult(sender); err == nil && l.Response.Response.StatusCode != http.StatusNoContent {
		l, err = client.UpdateResponder(l.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "labservices.LabsUpdateFuture", "Result", l.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LabUpdate the lab resource for updates.
type LabUpdate struct {
	// LabUpdateProperties - Lab resource properties
	*LabUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags *[]string `json:"tags,omitempty"`
}

// MarshalJSON is the custom marshaler for LabUpdate.
func (lu LabUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lu.LabUpdateProperties != nil {
		objectMap["properties"] = lu.LabUpdateProperties
	}
	if lu.Tags != nil {
		objectMap["tags"] = lu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabUpdate struct.
func (lu *LabUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labUpdateProperties LabUpdateProperties
				err = json.Unmarshal(*v, &labUpdateProperties)
				if err != nil {
					return err
				}
				lu.LabUpdateProperties = &labUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags []string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lu.Tags = &tags
			}
		}
	}

	return nil
}

// LabUpdateProperties properties of a lab resource used for updates.
type LabUpdateProperties struct {
	// AutoShutdownProfile - The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle.
	AutoShutdownProfile *AutoShutdownProfile `json:"autoShutdownProfile,omitempty"`
	// ConnectionProfile - The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open.
	ConnectionProfile *ConnectionProfile `json:"connectionProfile,omitempty"`
	// VirtualMachineProfile - The profile used for creating lab virtual machines.
	VirtualMachineProfile *VirtualMachineProfile `json:"virtualMachineProfile,omitempty"`
	// SecurityProfile - The lab security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// RosterProfile - The lab user list management profile.
	RosterProfile *RosterProfile `json:"rosterProfile,omitempty"`
	// LabPlanID - The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization..
	LabPlanID *string `json:"labPlanId,omitempty"`
	// Title - The title of the lab.
	Title *string `json:"title,omitempty"`
	// Description - The description of the lab.
	Description *string `json:"description,omitempty"`
}

// ListUsagesResult list of Core Usages.
type ListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The array page of Usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link to get the next page of Usage result.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListUsagesResult.
func (lur ListUsagesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListUsagesResultIterator provides access to a complete listing of Usage values.
type ListUsagesResultIterator struct {
	i    int
	page ListUsagesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListUsagesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListUsagesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListUsagesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListUsagesResultIterator) Response() ListUsagesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListUsagesResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListUsagesResultIterator type.
func NewListUsagesResultIterator(page ListUsagesResultPage) ListUsagesResultIterator {
	return ListUsagesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lur ListUsagesResult) IsEmpty() bool {
	return lur.Value == nil || len(*lur.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lur ListUsagesResult) hasNextLink() bool {
	return lur.NextLink != nil && len(*lur.NextLink) != 0
}

// listUsagesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lur ListUsagesResult) listUsagesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lur.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lur.NextLink)))
}

// ListUsagesResultPage contains a page of Usage values.
type ListUsagesResultPage struct {
	fn  func(context.Context, ListUsagesResult) (ListUsagesResult, error)
	lur ListUsagesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListUsagesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lur)
		if err != nil {
			return err
		}
		page.lur = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListUsagesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListUsagesResultPage) NotDone() bool {
	return !page.lur.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListUsagesResultPage) Response() ListUsagesResult {
	return page.lur
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListUsagesResultPage) Values() []Usage {
	if page.lur.IsEmpty() {
		return nil
	}
	return *page.lur.Value
}

// Creates a new instance of the ListUsagesResultPage type.
func NewListUsagesResultPage(cur ListUsagesResult, getNextPage func(context.Context, ListUsagesResult) (ListUsagesResult, error)) ListUsagesResultPage {
	return ListUsagesResultPage{
		fn:  getNextPage,
		lur: cur,
	}
}

// Operation details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Name - READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane operations.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is "user,system". Possible values include: 'OriginUser', 'OriginSystem', 'OriginUsersystem'
	Origin Origin `json:"origin,omitempty"`
	// ActionType - READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs. Possible values include: 'ActionTypeInternal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay localized display information for this particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft Compute".
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job Schedule Collections".
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult a list of REST API operations supported by an Azure Resource Provider. It contains
// an URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the resource provider
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationResult a long running operation result
type OperationResult struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Status - The operation status. Possible values include: 'OperationStatusNotStarted', 'OperationStatusInProgress', 'OperationStatusSucceeded', 'OperationStatusFailed', 'OperationStatusCanceled'
	Status OperationStatus `json:"status,omitempty"`
	// StartTime - Start time
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - Percent completion
	PercentComplete *float64 `json:"percentComplete,omitempty"`
	// Error - The error for a failure if the operation failed.
	Error *ErrorDetail `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationResult.
func (or OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.Status != "" {
		objectMap["status"] = or.Status
	}
	if or.StartTime != nil {
		objectMap["startTime"] = or.StartTime
	}
	if or.EndTime != nil {
		objectMap["endTime"] = or.EndTime
	}
	if or.PercentComplete != nil {
		objectMap["percentComplete"] = or.PercentComplete
	}
	if or.Error != nil {
		objectMap["error"] = or.Error
	}
	return json.Marshal(objectMap)
}

// PagedImages paged list of Lab services virtual machine images.
type PagedImages struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The array page of virtual machine images.
	Value *[]Image `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link to get the next page of image results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PagedImages.
func (pi PagedImages) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PagedImagesIterator provides access to a complete listing of Image values.
type PagedImagesIterator struct {
	i    int
	page PagedImagesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PagedImagesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedImagesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PagedImagesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PagedImagesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PagedImagesIterator) Response() PagedImages {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PagedImagesIterator) Value() Image {
	if !iter.page.NotDone() {
		return Image{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PagedImagesIterator type.
func NewPagedImagesIterator(page PagedImagesPage) PagedImagesIterator {
	return PagedImagesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pi PagedImages) IsEmpty() bool {
	return pi.Value == nil || len(*pi.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pi PagedImages) hasNextLink() bool {
	return pi.NextLink != nil && len(*pi.NextLink) != 0
}

// pagedImagesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pi PagedImages) pagedImagesPreparer(ctx context.Context) (*http.Request, error) {
	if !pi.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pi.NextLink)))
}

// PagedImagesPage contains a page of Image values.
type PagedImagesPage struct {
	fn func(context.Context, PagedImages) (PagedImages, error)
	pi PagedImages
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PagedImagesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedImagesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pi)
		if err != nil {
			return err
		}
		page.pi = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PagedImagesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PagedImagesPage) NotDone() bool {
	return !page.pi.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PagedImagesPage) Response() PagedImages {
	return page.pi
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PagedImagesPage) Values() []Image {
	if page.pi.IsEmpty() {
		return nil
	}
	return *page.pi.Value
}

// Creates a new instance of the PagedImagesPage type.
func NewPagedImagesPage(cur PagedImages, getNextPage func(context.Context, PagedImages) (PagedImages, error)) PagedImagesPage {
	return PagedImagesPage{
		fn: getNextPage,
		pi: cur,
	}
}

// PagedLabPlans paged list of lab plans.
type PagedLabPlans struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The array page of lab plans.
	Value *[]LabPlan `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link to get the next page of lab plan results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PagedLabPlans.
func (plp PagedLabPlans) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PagedLabPlansIterator provides access to a complete listing of LabPlan values.
type PagedLabPlansIterator struct {
	i    int
	page PagedLabPlansPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PagedLabPlansIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedLabPlansIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PagedLabPlansIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PagedLabPlansIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PagedLabPlansIterator) Response() PagedLabPlans {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PagedLabPlansIterator) Value() LabPlan {
	if !iter.page.NotDone() {
		return LabPlan{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PagedLabPlansIterator type.
func NewPagedLabPlansIterator(page PagedLabPlansPage) PagedLabPlansIterator {
	return PagedLabPlansIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plp PagedLabPlans) IsEmpty() bool {
	return plp.Value == nil || len(*plp.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plp PagedLabPlans) hasNextLink() bool {
	return plp.NextLink != nil && len(*plp.NextLink) != 0
}

// pagedLabPlansPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plp PagedLabPlans) pagedLabPlansPreparer(ctx context.Context) (*http.Request, error) {
	if !plp.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plp.NextLink)))
}

// PagedLabPlansPage contains a page of LabPlan values.
type PagedLabPlansPage struct {
	fn  func(context.Context, PagedLabPlans) (PagedLabPlans, error)
	plp PagedLabPlans
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PagedLabPlansPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedLabPlansPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plp)
		if err != nil {
			return err
		}
		page.plp = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PagedLabPlansPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PagedLabPlansPage) NotDone() bool {
	return !page.plp.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PagedLabPlansPage) Response() PagedLabPlans {
	return page.plp
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PagedLabPlansPage) Values() []LabPlan {
	if page.plp.IsEmpty() {
		return nil
	}
	return *page.plp.Value
}

// Creates a new instance of the PagedLabPlansPage type.
func NewPagedLabPlansPage(cur PagedLabPlans, getNextPage func(context.Context, PagedLabPlans) (PagedLabPlans, error)) PagedLabPlansPage {
	return PagedLabPlansPage{
		fn:  getNextPage,
		plp: cur,
	}
}

// PagedLabs paged list of labs.
type PagedLabs struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The array page of lab results.
	Value *[]Lab `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link to get the next page of image results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PagedLabs.
func (pl PagedLabs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PagedLabServicesSkus paged list of lab services skus.
type PagedLabServicesSkus struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The array page of sku results.
	Value *[]SkuType `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link to get the next page of sku results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PagedLabServicesSkus.
func (plss PagedLabServicesSkus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PagedLabServicesSkusIterator provides access to a complete listing of SkuType values.
type PagedLabServicesSkusIterator struct {
	i    int
	page PagedLabServicesSkusPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PagedLabServicesSkusIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedLabServicesSkusIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PagedLabServicesSkusIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PagedLabServicesSkusIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PagedLabServicesSkusIterator) Response() PagedLabServicesSkus {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PagedLabServicesSkusIterator) Value() SkuType {
	if !iter.page.NotDone() {
		return SkuType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PagedLabServicesSkusIterator type.
func NewPagedLabServicesSkusIterator(page PagedLabServicesSkusPage) PagedLabServicesSkusIterator {
	return PagedLabServicesSkusIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plss PagedLabServicesSkus) IsEmpty() bool {
	return plss.Value == nil || len(*plss.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plss PagedLabServicesSkus) hasNextLink() bool {
	return plss.NextLink != nil && len(*plss.NextLink) != 0
}

// pagedLabServicesSkusPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plss PagedLabServicesSkus) pagedLabServicesSkusPreparer(ctx context.Context) (*http.Request, error) {
	if !plss.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plss.NextLink)))
}

// PagedLabServicesSkusPage contains a page of SkuType values.
type PagedLabServicesSkusPage struct {
	fn   func(context.Context, PagedLabServicesSkus) (PagedLabServicesSkus, error)
	plss PagedLabServicesSkus
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PagedLabServicesSkusPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedLabServicesSkusPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plss)
		if err != nil {
			return err
		}
		page.plss = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PagedLabServicesSkusPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PagedLabServicesSkusPage) NotDone() bool {
	return !page.plss.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PagedLabServicesSkusPage) Response() PagedLabServicesSkus {
	return page.plss
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PagedLabServicesSkusPage) Values() []SkuType {
	if page.plss.IsEmpty() {
		return nil
	}
	return *page.plss.Value
}

// Creates a new instance of the PagedLabServicesSkusPage type.
func NewPagedLabServicesSkusPage(cur PagedLabServicesSkus, getNextPage func(context.Context, PagedLabServicesSkus) (PagedLabServicesSkus, error)) PagedLabServicesSkusPage {
	return PagedLabServicesSkusPage{
		fn:   getNextPage,
		plss: cur,
	}
}

// PagedLabsIterator provides access to a complete listing of Lab values.
type PagedLabsIterator struct {
	i    int
	page PagedLabsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PagedLabsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedLabsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PagedLabsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PagedLabsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PagedLabsIterator) Response() PagedLabs {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PagedLabsIterator) Value() Lab {
	if !iter.page.NotDone() {
		return Lab{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PagedLabsIterator type.
func NewPagedLabsIterator(page PagedLabsPage) PagedLabsIterator {
	return PagedLabsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pl PagedLabs) IsEmpty() bool {
	return pl.Value == nil || len(*pl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pl PagedLabs) hasNextLink() bool {
	return pl.NextLink != nil && len(*pl.NextLink) != 0
}

// pagedLabsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pl PagedLabs) pagedLabsPreparer(ctx context.Context) (*http.Request, error) {
	if !pl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pl.NextLink)))
}

// PagedLabsPage contains a page of Lab values.
type PagedLabsPage struct {
	fn func(context.Context, PagedLabs) (PagedLabs, error)
	pl PagedLabs
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PagedLabsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedLabsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pl)
		if err != nil {
			return err
		}
		page.pl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PagedLabsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PagedLabsPage) NotDone() bool {
	return !page.pl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PagedLabsPage) Response() PagedLabs {
	return page.pl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PagedLabsPage) Values() []Lab {
	if page.pl.IsEmpty() {
		return nil
	}
	return *page.pl.Value
}

// Creates a new instance of the PagedLabsPage type.
func NewPagedLabsPage(cur PagedLabs, getNextPage func(context.Context, PagedLabs) (PagedLabs, error)) PagedLabsPage {
	return PagedLabsPage{
		fn: getNextPage,
		pl: cur,
	}
}

// PagedSchedules paged list of schedules.
type PagedSchedules struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The array page of schedule results.
	Value *[]Schedule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link to get the next page of schedule results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PagedSchedules.
func (ps PagedSchedules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PagedSchedulesIterator provides access to a complete listing of Schedule values.
type PagedSchedulesIterator struct {
	i    int
	page PagedSchedulesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PagedSchedulesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedSchedulesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PagedSchedulesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PagedSchedulesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PagedSchedulesIterator) Response() PagedSchedules {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PagedSchedulesIterator) Value() Schedule {
	if !iter.page.NotDone() {
		return Schedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PagedSchedulesIterator type.
func NewPagedSchedulesIterator(page PagedSchedulesPage) PagedSchedulesIterator {
	return PagedSchedulesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ps PagedSchedules) IsEmpty() bool {
	return ps.Value == nil || len(*ps.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ps PagedSchedules) hasNextLink() bool {
	return ps.NextLink != nil && len(*ps.NextLink) != 0
}

// pagedSchedulesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ps PagedSchedules) pagedSchedulesPreparer(ctx context.Context) (*http.Request, error) {
	if !ps.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ps.NextLink)))
}

// PagedSchedulesPage contains a page of Schedule values.
type PagedSchedulesPage struct {
	fn func(context.Context, PagedSchedules) (PagedSchedules, error)
	ps PagedSchedules
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PagedSchedulesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedSchedulesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ps)
		if err != nil {
			return err
		}
		page.ps = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PagedSchedulesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PagedSchedulesPage) NotDone() bool {
	return !page.ps.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PagedSchedulesPage) Response() PagedSchedules {
	return page.ps
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PagedSchedulesPage) Values() []Schedule {
	if page.ps.IsEmpty() {
		return nil
	}
	return *page.ps.Value
}

// Creates a new instance of the PagedSchedulesPage type.
func NewPagedSchedulesPage(cur PagedSchedules, getNextPage func(context.Context, PagedSchedules) (PagedSchedules, error)) PagedSchedulesPage {
	return PagedSchedulesPage{
		fn: getNextPage,
		ps: cur,
	}
}

// PagedUsers paged list of users.
type PagedUsers struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The array page of user results.
	Value *[]User `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link to get the next page of image results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PagedUsers.
func (pu PagedUsers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PagedUsersIterator provides access to a complete listing of User values.
type PagedUsersIterator struct {
	i    int
	page PagedUsersPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PagedUsersIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedUsersIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PagedUsersIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PagedUsersIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PagedUsersIterator) Response() PagedUsers {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PagedUsersIterator) Value() User {
	if !iter.page.NotDone() {
		return User{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PagedUsersIterator type.
func NewPagedUsersIterator(page PagedUsersPage) PagedUsersIterator {
	return PagedUsersIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pu PagedUsers) IsEmpty() bool {
	return pu.Value == nil || len(*pu.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pu PagedUsers) hasNextLink() bool {
	return pu.NextLink != nil && len(*pu.NextLink) != 0
}

// pagedUsersPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pu PagedUsers) pagedUsersPreparer(ctx context.Context) (*http.Request, error) {
	if !pu.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pu.NextLink)))
}

// PagedUsersPage contains a page of User values.
type PagedUsersPage struct {
	fn func(context.Context, PagedUsers) (PagedUsers, error)
	pu PagedUsers
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PagedUsersPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedUsersPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pu)
		if err != nil {
			return err
		}
		page.pu = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PagedUsersPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PagedUsersPage) NotDone() bool {
	return !page.pu.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PagedUsersPage) Response() PagedUsers {
	return page.pu
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PagedUsersPage) Values() []User {
	if page.pu.IsEmpty() {
		return nil
	}
	return *page.pu.Value
}

// Creates a new instance of the PagedUsersPage type.
func NewPagedUsersPage(cur PagedUsers, getNextPage func(context.Context, PagedUsers) (PagedUsers, error)) PagedUsersPage {
	return PagedUsersPage{
		fn: getNextPage,
		pu: cur,
	}
}

// PagedVirtualMachines paged list of lab services virtual machines.
type PagedVirtualMachines struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The array page of virtual machine results.
	Value *[]VirtualMachine `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link to get the next page of virtual machine results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PagedVirtualMachines.
func (pvm PagedVirtualMachines) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PagedVirtualMachinesIterator provides access to a complete listing of VirtualMachine values.
type PagedVirtualMachinesIterator struct {
	i    int
	page PagedVirtualMachinesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PagedVirtualMachinesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedVirtualMachinesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PagedVirtualMachinesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PagedVirtualMachinesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PagedVirtualMachinesIterator) Response() PagedVirtualMachines {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PagedVirtualMachinesIterator) Value() VirtualMachine {
	if !iter.page.NotDone() {
		return VirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PagedVirtualMachinesIterator type.
func NewPagedVirtualMachinesIterator(page PagedVirtualMachinesPage) PagedVirtualMachinesIterator {
	return PagedVirtualMachinesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pvm PagedVirtualMachines) IsEmpty() bool {
	return pvm.Value == nil || len(*pvm.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pvm PagedVirtualMachines) hasNextLink() bool {
	return pvm.NextLink != nil && len(*pvm.NextLink) != 0
}

// pagedVirtualMachinesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pvm PagedVirtualMachines) pagedVirtualMachinesPreparer(ctx context.Context) (*http.Request, error) {
	if !pvm.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pvm.NextLink)))
}

// PagedVirtualMachinesPage contains a page of VirtualMachine values.
type PagedVirtualMachinesPage struct {
	fn  func(context.Context, PagedVirtualMachines) (PagedVirtualMachines, error)
	pvm PagedVirtualMachines
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PagedVirtualMachinesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedVirtualMachinesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pvm)
		if err != nil {
			return err
		}
		page.pvm = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PagedVirtualMachinesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PagedVirtualMachinesPage) NotDone() bool {
	return !page.pvm.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PagedVirtualMachinesPage) Response() PagedVirtualMachines {
	return page.pvm
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PagedVirtualMachinesPage) Values() []VirtualMachine {
	if page.pvm.IsEmpty() {
		return nil
	}
	return *page.pvm.Value
}

// Creates a new instance of the PagedVirtualMachinesPage type.
func NewPagedVirtualMachinesPage(cur PagedVirtualMachines, getNextPage func(context.Context, PagedVirtualMachines) (PagedVirtualMachines, error)) PagedVirtualMachinesPage {
	return PagedVirtualMachinesPage{
		fn:  getNextPage,
		pvm: cur,
	}
}

// Plan plan for the resource.
type Plan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecurrencePattern recurrence pattern of a lab schedule.
type RecurrencePattern struct {
	// Frequency - The frequency of the recurrence. Possible values include: 'RecurrenceFrequencyDaily', 'RecurrenceFrequencyWeekly'
	Frequency RecurrenceFrequency `json:"frequency,omitempty"`
	// WeekDays - The week days the schedule runs. Used for when the Frequency is set to Weekly.
	WeekDays *[]WeekDay `json:"weekDays,omitempty"`
	// Interval - The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days. When no interval is supplied, an interval of 1 is used.
	Interval *int32 `json:"interval,omitempty"`
	// ExpirationDate - When the recurrence will expire. This date is inclusive.
	ExpirationDate *date.Date `json:"expirationDate,omitempty"`
}

// ResetPasswordBody body of a reset password request.
type ResetPasswordBody struct {
	// Username - The user whose password is being reset
	Username *string `json:"username,omitempty"`
	// Password - The password
	Password *string `json:"password,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySet the resource model definition containing the full set of allowed
// properties for a resource. Except properties bag, there cannot be a top level property outside of this
// set.
type ResourceModelWithAllowedPropertySet struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ManagedBy - The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Kind - Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
	Kind *string `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags     map[string]*string                           `json:"tags"`
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`
	Sku      *ResourceModelWithAllowedPropertySetSku      `json:"sku,omitempty"`
	Plan     *ResourceModelWithAllowedPropertySetPlan     `json:"plan,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySet.
func (rmwaps ResourceModelWithAllowedPropertySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Location != nil {
		objectMap["location"] = rmwaps.Location
	}
	if rmwaps.ManagedBy != nil {
		objectMap["managedBy"] = rmwaps.ManagedBy
	}
	if rmwaps.Kind != nil {
		objectMap["kind"] = rmwaps.Kind
	}
	if rmwaps.Tags != nil {
		objectMap["tags"] = rmwaps.Tags
	}
	if rmwaps.Identity != nil {
		objectMap["identity"] = rmwaps.Identity
	}
	if rmwaps.Sku != nil {
		objectMap["sku"] = rmwaps.Sku
	}
	if rmwaps.Plan != nil {
		objectMap["plan"] = rmwaps.Plan
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetIdentity ...
type ResourceModelWithAllowedPropertySetIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySetIdentity.
func (rmwaps ResourceModelWithAllowedPropertySetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Type != "" {
		objectMap["type"] = rmwaps.Type
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetPlan ...
type ResourceModelWithAllowedPropertySetPlan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// ResourceModelWithAllowedPropertySetSku ...
type ResourceModelWithAllowedPropertySetSku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// RosterProfile the lab user list management profile.
type RosterProfile struct {
	// ActiveDirectoryGroupID - The AAD group ID which this lab roster is populated from. Having this set enables AAD sync mode.
	ActiveDirectoryGroupID *string `json:"activeDirectoryGroupId,omitempty"`
	// LtiContextID - The unique context identifier for the lab in the lms.
	LtiContextID *string `json:"ltiContextId,omitempty"`
	// LmsInstance - The base URI identifying the lms instance.
	LmsInstance *string `json:"lmsInstance,omitempty"`
	// LtiClientID - The unique id of the azure lab services tool in the lms.
	LtiClientID *string `json:"ltiClientId,omitempty"`
	// LtiRosterEndpoint - The uri of the names and roles service endpoint on the lms for the class attached to this lab.
	LtiRosterEndpoint *string `json:"ltiRosterEndpoint,omitempty"`
}

// SaveImageBody body for the save image POST
type SaveImageBody struct {
	// Name - The name for the image we create.
	Name *string `json:"name,omitempty"`
	// LabVirtualMachineID - The ID of the lab virtual machine you want to save an image from.
	LabVirtualMachineID *string `json:"labVirtualMachineId,omitempty"`
}

// Schedule schedule for automatically turning virtual machines in a lab on and off at specified times.
type Schedule struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the schedule.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ScheduleProperties - Schedule resource properties
	*ScheduleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ScheduleProperties != nil {
		objectMap["properties"] = s.ScheduleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Schedule struct.
func (s *Schedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				s.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var scheduleProperties ScheduleProperties
				err = json.Unmarshal(*v, &scheduleProperties)
				if err != nil {
					return err
				}
				s.ScheduleProperties = &scheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ScheduleProperties schedule resource properties
type ScheduleProperties struct {
	// ProvisioningState - READ-ONLY; Current provisioning state of the schedule. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateLocked'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// StartAt - When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
	StartAt *date.Time `json:"startAt,omitempty"`
	// StopAt - When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
	StopAt *date.Time `json:"stopAt,omitempty"`
	// RecurrencePattern - The recurrence pattern of the scheduled actions.
	RecurrencePattern *RecurrencePattern `json:"recurrencePattern,omitempty"`
	// TimeZoneID - The IANA timezone id for the schedule.
	TimeZoneID *string `json:"timeZoneId,omitempty"`
	// Notes - Notes for this schedule.
	Notes *string `json:"notes,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleProperties.
func (sp ScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.StartAt != nil {
		objectMap["startAt"] = sp.StartAt
	}
	if sp.StopAt != nil {
		objectMap["stopAt"] = sp.StopAt
	}
	if sp.RecurrencePattern != nil {
		objectMap["recurrencePattern"] = sp.RecurrencePattern
	}
	if sp.TimeZoneID != nil {
		objectMap["timeZoneId"] = sp.TimeZoneID
	}
	if sp.Notes != nil {
		objectMap["notes"] = sp.Notes
	}
	return json.Marshal(objectMap)
}

// SchedulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SchedulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SchedulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SchedulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SchedulesDeleteFuture.Result.
func (future *SchedulesDeleteFuture) result(client SchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.SchedulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ScheduleUpdate schedule for automatically turning virtual machines in a lab on and off at specified
// times. Used for updates.
type ScheduleUpdate struct {
	// ScheduleUpdateProperties - Schedule resource properties
	*ScheduleUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleUpdate.
func (su ScheduleUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.ScheduleUpdateProperties != nil {
		objectMap["properties"] = su.ScheduleUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScheduleUpdate struct.
func (su *ScheduleUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduleUpdateProperties ScheduleUpdateProperties
				err = json.Unmarshal(*v, &scheduleUpdateProperties)
				if err != nil {
					return err
				}
				su.ScheduleUpdateProperties = &scheduleUpdateProperties
			}
		}
	}

	return nil
}

// ScheduleUpdateProperties schedule resource properties used for updates.
type ScheduleUpdateProperties struct {
	// StartAt - When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
	StartAt *date.Time `json:"startAt,omitempty"`
	// StopAt - When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
	StopAt *date.Time `json:"stopAt,omitempty"`
	// RecurrencePattern - The recurrence pattern of the scheduled actions.
	RecurrencePattern *RecurrencePattern `json:"recurrencePattern,omitempty"`
	// TimeZoneID - The IANA timezone id for the schedule.
	TimeZoneID *string `json:"timeZoneId,omitempty"`
	// Notes - Notes for this schedule.
	Notes *string `json:"notes,omitempty"`
}

// SecurityProfile the lab security profile.
type SecurityProfile struct {
	// RegistrationCode - READ-ONLY; The registration code for the lab.
	RegistrationCode *string `json:"registrationCode,omitempty"`
	// OpenAccess - Whether any user or only specified users can register to a lab. Possible values include: 'EnableStateEnabled', 'EnableStateDisabled'
	OpenAccess EnableState `json:"openAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityProfile.
func (sp SecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.OpenAccess != "" {
		objectMap["openAccess"] = sp.OpenAccess
	}
	return json.Marshal(objectMap)
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SkuCapabilities the array of capabilities of a lab services SKU.
type SkuCapabilities struct {
	// Name - READ-ONLY; The name of the capability for a SKU.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; The value of the capability for a SKU.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuCapabilities.
func (sc SkuCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SkuCapacity the scale out/in options of the SKU.
type SkuCapacity struct {
	// Default - READ-ONLY; The default capacity for this resource.
	Default *int64 `json:"default,omitempty"`
	// Minimum - READ-ONLY; The lowest permitted capacity for this resource.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - READ-ONLY; The highest permitted capacity for this resource.
	Maximum *int64 `json:"maximum,omitempty"`
	// ScaleType - READ-ONLY; The localized name of the resource. Possible values include: 'ScaleTypeNone', 'ScaleTypeManual', 'ScaleTypeAutomatic'
	ScaleType ScaleType `json:"scaleType,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuCapacity.
func (sc SkuCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SkuCost the array of costs of a lab services SKU.
type SkuCost struct {
	// MeterID - READ-ONLY; The meter id.
	MeterID *string `json:"meterId,omitempty"`
	// Quantity - READ-ONLY; The quantity of units charged.
	Quantity *float64 `json:"quantity,omitempty"`
	// ExtendedUnit - READ-ONLY; The extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuCost.
func (sc SkuCost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SkuRestrictions the restriction details.
type SkuRestrictions struct {
	// Type - READ-ONLY; The type of restriction. Possible values include: 'RestrictionTypeLocation'
	Type RestrictionType `json:"type,omitempty"`
	// Values - READ-ONLY; The values of the restriction.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - READ-ONLY; The reason for the restriction. Possible values include: 'RestrictionReasonCodeQuotaID', 'RestrictionReasonCodeNotAvailableForSubscription'
	ReasonCode RestrictionReasonCode `json:"reasonCode,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuRestrictions.
func (sr SkuRestrictions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SkuType azure Lab Services resource SKUs
type SkuType struct {
	// ResourceType - READ-ONLY; The lab services resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY; The name of the SKU.
	Name *string `json:"name,omitempty"`
	// Tier - READ-ONLY; The tier of the SKU. Possible values include: 'SkuTierEnumStandard', 'SkuTierEnumPremium'
	Tier SkuTierEnum `json:"tier,omitempty"`
	// Size - READ-ONLY; The SKU size.
	Size *string `json:"size,omitempty"`
	// Family - READ-ONLY; The family of the SKU.
	Family   *string      `json:"family,omitempty"`
	Capacity *SkuCapacity `json:"capacity,omitempty"`
	// Capabilities - READ-ONLY; The capabilities of the SKU.
	Capabilities *[]SkuCapabilities `json:"capabilities,omitempty"`
	// Locations - READ-ONLY; List of locations that are available for a size.
	Locations *[]string `json:"locations,omitempty"`
	// Costs - READ-ONLY; Metadata for retrieving price info of a lab services SKUs.
	Costs *[]SkuCost `json:"costs,omitempty"`
	// Restrictions - READ-ONLY; Restrictions of a lab services SKUs.
	Restrictions *[]SkuRestrictions `json:"restrictions,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuType.
func (st SkuType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if st.Capacity != nil {
		objectMap["capacity"] = st.Capacity
	}
	return json.Marshal(objectMap)
}

// SupportInfo support contact information and instructions.
type SupportInfo struct {
	// URL - Support web address.
	URL *string `json:"url,omitempty"`
	// Email - Support contact email address.
	Email *string `json:"email,omitempty"`
	// Phone - Support contact phone number.
	Phone *string `json:"phone,omitempty"`
	// Instructions - Support instructions.
	Instructions *string `json:"instructions,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TrackedResourceUpdate base tracked resource type for all PATCH updates.
type TrackedResourceUpdate struct {
	// Tags - Resource tags.
	Tags *[]string `json:"tags,omitempty"`
}

// Usage the core usage details.
type Usage struct {
	// CurrentValue - The current usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The limit integer.
	Limit *int64 `json:"limit,omitempty"`
	// Unit - The unit details. Possible values include: 'UsageUnitCount'
	Unit UsageUnit `json:"unit,omitempty"`
	// Name - The name.
	Name *UsageName `json:"name,omitempty"`
	// ID - The fully qualified arm resource id.
	ID *string `json:"id,omitempty"`
}

// UsageName the Usage Names.
type UsageName struct {
	// LocalizedValue - The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
	// Value - The name of the resource.
	Value *string `json:"value,omitempty"`
}

// User user of a lab that can register for and use virtual machines within the lab.
type User struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the user resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// UserProperties - User resource properties
	*UserProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				u.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		}
	}

	return nil
}

// UserProperties user resource properties
type UserProperties struct {
	// ProvisioningState - READ-ONLY; Current provisioning state of the user resource. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateLocked'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// DisplayName - READ-ONLY; Display name of the user, for example user's full name.
	DisplayName *string `json:"displayName,omitempty"`
	// Email - Email address of the user.
	Email *string `json:"email,omitempty"`
	// RegistrationState - READ-ONLY; State of the user's registration within the lab. Possible values include: 'RegistrationStateRegistered', 'RegistrationStateNotRegistered'
	RegistrationState RegistrationState `json:"registrationState,omitempty"`
	// InvitationState - READ-ONLY; State of the invitation message for the user. Possible values include: 'InvitationStateNotSent', 'InvitationStateSending', 'InvitationStateSent', 'InvitationStateFailed'
	InvitationState InvitationState `json:"invitationState,omitempty"`
	// InvitationSent - READ-ONLY; Date and time when the invitation message was sent to the user.
	InvitationSent *date.Time `json:"invitationSent,omitempty"`
	// TotalUsage - READ-ONLY; How long the user has used their virtual machines in this lab.
	TotalUsage *string `json:"totalUsage,omitempty"`
	// AdditionalUsageQuota - The amount of usage quota time the user gets in addition to the lab usage quota.
	AdditionalUsageQuota *string `json:"additionalUsageQuota,omitempty"`
}

// MarshalJSON is the custom marshaler for UserProperties.
func (up UserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.Email != nil {
		objectMap["email"] = up.Email
	}
	if up.AdditionalUsageQuota != nil {
		objectMap["additionalUsageQuota"] = up.AdditionalUsageQuota
	}
	return json.Marshal(objectMap)
}

// UsersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type UsersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (User, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersCreateOrUpdateFuture.Result.
func (future *UsersCreateOrUpdateFuture) result(client UsersClient) (u User, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.UsersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		u.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.UsersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.CreateOrUpdateResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "labservices.UsersCreateOrUpdateFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UsersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UsersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersDeleteFuture.Result.
func (future *UsersDeleteFuture) result(client UsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.UsersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.UsersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// UsersInviteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UsersInviteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersInviteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersInviteFuture.Result.
func (future *UsersInviteFuture) result(client UsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.UsersInviteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.UsersInviteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// UsersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UsersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (User, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersUpdateFuture.Result.
func (future *UsersUpdateFuture) result(client UsersClient) (u User, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.UsersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		u.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.UsersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.UpdateResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "labservices.UsersUpdateFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UserUpdate user of a lab that can register for and use virtual machines within the lab. Used for
// updates.
type UserUpdate struct {
	// UserUpdateProperties - User resource properties
	*UserUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UserUpdate.
func (uu UserUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uu.UserUpdateProperties != nil {
		objectMap["properties"] = uu.UserUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserUpdate struct.
func (uu *UserUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userUpdateProperties UserUpdateProperties
				err = json.Unmarshal(*v, &userUpdateProperties)
				if err != nil {
					return err
				}
				uu.UserUpdateProperties = &userUpdateProperties
			}
		}
	}

	return nil
}

// UserUpdateProperties user resource properties used for updates.
type UserUpdateProperties struct {
	// AdditionalUsageQuota - The amount of usage quota time the user gets in addition to the lab usage quota.
	AdditionalUsageQuota *string `json:"additionalUsageQuota,omitempty"`
}

// VirtualMachine a lab virtual machine resource.
type VirtualMachine struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; System data of the Lab virtual machine.
	SystemData *SystemData `json:"systemData,omitempty"`
	// VirtualMachineProperties - Virtual machine resource properties
	*VirtualMachineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachine.
func (VM VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if VM.VirtualMachineProperties != nil {
		objectMap["properties"] = VM.VirtualMachineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachine struct.
func (VM *VirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				VM.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var virtualMachineProperties VirtualMachineProperties
				err = json.Unmarshal(*v, &virtualMachineProperties)
				if err != nil {
					return err
				}
				VM.VirtualMachineProperties = &virtualMachineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				VM.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				VM.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				VM.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualMachineAdditionalCapabilities the additional capabilities for a lab VM.
type VirtualMachineAdditionalCapabilities struct {
	// InstallGpuDrivers - Flag to pre-install dedicated GPU drivers. Possible values include: 'EnableStateEnabled', 'EnableStateDisabled'
	InstallGpuDrivers EnableState `json:"installGpuDrivers,omitempty"`
}

// VirtualMachineConnectionProfile the connection information for the virtual machine
type VirtualMachineConnectionProfile struct {
	// PrivateIPAddress - READ-ONLY; The private IP address of the virtual machine.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// SSHAuthority - READ-ONLY; Port and host name separated by semicolon for connecting via SSH protocol to the virtual machine.
	SSHAuthority *string `json:"sshAuthority,omitempty"`
	// SSHInBrowserURL - READ-ONLY; URL for connecting via SSH protocol to the virtual machine in browser.
	SSHInBrowserURL *string `json:"sshInBrowserUrl,omitempty"`
	// RdpAuthority - READ-ONLY; Port and host name separated by semicolon for connecting via RDP protocol to the virtual machine.
	RdpAuthority *string `json:"rdpAuthority,omitempty"`
	// RdpInBrowserURL - READ-ONLY; URL for connecting via RDP protocol to the virtual machine in browser.
	RdpInBrowserURL *string `json:"rdpInBrowserUrl,omitempty"`
	// AdminUsername - READ-ONLY; The username used to log on to the virtual machine as admin.
	AdminUsername *string `json:"adminUsername,omitempty"`
	// NonAdminUsername - READ-ONLY; The username used to log on to the virtual machine as non-admin, if one exists.
	NonAdminUsername *string `json:"nonAdminUsername,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineConnectionProfile.
func (vmcp VirtualMachineConnectionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineProfile the base virtual machine configuration for a lab.
type VirtualMachineProfile struct {
	// CreateOption - Indicates what lab virtual machines are created from. Possible values include: 'CreateOptionImage', 'CreateOptionTemplateVM'
	CreateOption CreateOption `json:"createOption,omitempty"`
	// ImageReference - The image configuration for lab virtual machines.
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// OsType - READ-ONLY; The OS type of the image. Possible values include: 'OsTypeWindows', 'OsTypeLinux'
	OsType OsType `json:"osType,omitempty"`
	// Sku - The SKU for the lab. Defines the type of virtual machines used in the lab.
	Sku *Sku `json:"sku,omitempty"`
	// AdditionalCapabilities - Additional VM capabilities.
	AdditionalCapabilities *VirtualMachineAdditionalCapabilities `json:"additionalCapabilities,omitempty"`
	// UsageQuota - The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours.
	UsageQuota *string `json:"usageQuota,omitempty"`
	// UseSharedPassword - Enabling this option will use the same password for all user VMs. Possible values include: 'EnableStateEnabled', 'EnableStateDisabled'
	UseSharedPassword EnableState `json:"useSharedPassword,omitempty"`
	// AdminUser - Credentials for the admin user on the VM.
	AdminUser *Credentials `json:"adminUser,omitempty"`
	// NonAdminUser - Credentials for the non-admin user on the VM, if one exists.
	NonAdminUser *Credentials `json:"nonAdminUser,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineProfile.
func (vmp VirtualMachineProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmp.CreateOption != "" {
		objectMap["createOption"] = vmp.CreateOption
	}
	if vmp.ImageReference != nil {
		objectMap["imageReference"] = vmp.ImageReference
	}
	if vmp.Sku != nil {
		objectMap["sku"] = vmp.Sku
	}
	if vmp.AdditionalCapabilities != nil {
		objectMap["additionalCapabilities"] = vmp.AdditionalCapabilities
	}
	if vmp.UsageQuota != nil {
		objectMap["usageQuota"] = vmp.UsageQuota
	}
	if vmp.UseSharedPassword != "" {
		objectMap["useSharedPassword"] = vmp.UseSharedPassword
	}
	if vmp.AdminUser != nil {
		objectMap["adminUser"] = vmp.AdminUser
	}
	if vmp.NonAdminUser != nil {
		objectMap["nonAdminUser"] = vmp.NonAdminUser
	}
	return json.Marshal(objectMap)
}

// VirtualMachineProperties virtual machine resource properties
type VirtualMachineProperties struct {
	// ProvisioningState - READ-ONLY; Current provisioning state of the virtual machine. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateLocked'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// State - READ-ONLY; The current state of the virtual machine. Possible values include: 'VirtualMachineStateStopped', 'VirtualMachineStateStarting', 'VirtualMachineStateRunning', 'VirtualMachineStateStopping', 'VirtualMachineStateResettingPassword', 'VirtualMachineStateReimaging', 'VirtualMachineStateRedeploying'
	State VirtualMachineState `json:"state,omitempty"`
	// ConnectionProfile - READ-ONLY; Profile for information about connecting to the virtual machine.
	ConnectionProfile *VirtualMachineConnectionProfile `json:"connectionProfile,omitempty"`
	// ClaimedByUserID - READ-ONLY; The lab user ID (not the PUID!) of who claimed the virtual machine.
	ClaimedByUserID *string `json:"claimedByUserId,omitempty"`
	// VMType - READ-ONLY; The type of this VM resource. Possible values include: 'VirtualMachineTypeUser', 'VirtualMachineTypeTemplate'
	VMType VirtualMachineType `json:"vmType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineProperties.
func (vmp VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachinesRedeployFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesRedeployFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesRedeployFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesRedeployFuture.Result.
func (future *VirtualMachinesRedeployFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesRedeployFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.VirtualMachinesRedeployFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesReimageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesReimageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesReimageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesReimageFuture.Result.
func (future *VirtualMachinesReimageFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesReimageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.VirtualMachinesReimageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesResetPasswordFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesResetPasswordFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesResetPasswordFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesResetPasswordFuture.Result.
func (future *VirtualMachinesResetPasswordFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesResetPasswordFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.VirtualMachinesResetPasswordFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesStartFuture.Result.
func (future *VirtualMachinesStartFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.VirtualMachinesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesStopFuture.Result.
func (future *VirtualMachinesStopFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.VirtualMachinesStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.VirtualMachinesStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}
