//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package documentdb

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/cosmos-db/mgmt/2021-10-15/documentdb"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type APIType = original.APIType

const (
	APITypeCassandra APIType = original.APITypeCassandra
	APITypeGremlin   APIType = original.APITypeGremlin
	APITypeGremlinV2 APIType = original.APITypeGremlinV2
	APITypeMongoDB   APIType = original.APITypeMongoDB
	APITypeSQL       APIType = original.APITypeSQL
	APITypeTable     APIType = original.APITypeTable
)

type AnalyticalStorageSchemaType = original.AnalyticalStorageSchemaType

const (
	AnalyticalStorageSchemaTypeFullFidelity AnalyticalStorageSchemaType = original.AnalyticalStorageSchemaTypeFullFidelity
	AnalyticalStorageSchemaTypeWellDefined  AnalyticalStorageSchemaType = original.AnalyticalStorageSchemaTypeWellDefined
)

type AuthenticationMethod = original.AuthenticationMethod

const (
	AuthenticationMethodCassandra AuthenticationMethod = original.AuthenticationMethodCassandra
	AuthenticationMethodNone      AuthenticationMethod = original.AuthenticationMethodNone
)

type BackupPolicyMigrationStatus = original.BackupPolicyMigrationStatus

const (
	BackupPolicyMigrationStatusCompleted  BackupPolicyMigrationStatus = original.BackupPolicyMigrationStatusCompleted
	BackupPolicyMigrationStatusFailed     BackupPolicyMigrationStatus = original.BackupPolicyMigrationStatusFailed
	BackupPolicyMigrationStatusInProgress BackupPolicyMigrationStatus = original.BackupPolicyMigrationStatusInProgress
	BackupPolicyMigrationStatusInvalid    BackupPolicyMigrationStatus = original.BackupPolicyMigrationStatusInvalid
)

type BackupPolicyType = original.BackupPolicyType

const (
	BackupPolicyTypeContinuous BackupPolicyType = original.BackupPolicyTypeContinuous
	BackupPolicyTypePeriodic   BackupPolicyType = original.BackupPolicyTypePeriodic
)

type BackupStorageRedundancy = original.BackupStorageRedundancy

const (
	BackupStorageRedundancyGeo   BackupStorageRedundancy = original.BackupStorageRedundancyGeo
	BackupStorageRedundancyLocal BackupStorageRedundancy = original.BackupStorageRedundancyLocal
	BackupStorageRedundancyZone  BackupStorageRedundancy = original.BackupStorageRedundancyZone
)

type CompositePathSortOrder = original.CompositePathSortOrder

const (
	CompositePathSortOrderAscending  CompositePathSortOrder = original.CompositePathSortOrderAscending
	CompositePathSortOrderDescending CompositePathSortOrder = original.CompositePathSortOrderDescending
)

type ConflictResolutionMode = original.ConflictResolutionMode

const (
	ConflictResolutionModeCustom         ConflictResolutionMode = original.ConflictResolutionModeCustom
	ConflictResolutionModeLastWriterWins ConflictResolutionMode = original.ConflictResolutionModeLastWriterWins
)

type ConnectionState = original.ConnectionState

const (
	ConnectionStateDatacenterToDatacenterNetworkError           ConnectionState = original.ConnectionStateDatacenterToDatacenterNetworkError
	ConnectionStateInternalError                                ConnectionState = original.ConnectionStateInternalError
	ConnectionStateInternalOperatorToDataCenterCertificateError ConnectionState = original.ConnectionStateInternalOperatorToDataCenterCertificateError
	ConnectionStateOK                                           ConnectionState = original.ConnectionStateOK
	ConnectionStateOperatorToDataCenterNetworkError             ConnectionState = original.ConnectionStateOperatorToDataCenterNetworkError
	ConnectionStateUnknown                                      ConnectionState = original.ConnectionStateUnknown
)

type ConnectorOffer = original.ConnectorOffer

const (
	ConnectorOfferSmall ConnectorOffer = original.ConnectorOfferSmall
)

type CreateMode = original.CreateMode

const (
	CreateModeDefault CreateMode = original.CreateModeDefault
	CreateModeRestore CreateMode = original.CreateModeRestore
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DataType = original.DataType

const (
	DataTypeLineString   DataType = original.DataTypeLineString
	DataTypeMultiPolygon DataType = original.DataTypeMultiPolygon
	DataTypeNumber       DataType = original.DataTypeNumber
	DataTypePoint        DataType = original.DataTypePoint
	DataTypePolygon      DataType = original.DataTypePolygon
	DataTypeString       DataType = original.DataTypeString
)

type DatabaseAccountKind = original.DatabaseAccountKind

const (
	DatabaseAccountKindGlobalDocumentDB DatabaseAccountKind = original.DatabaseAccountKindGlobalDocumentDB
	DatabaseAccountKindMongoDB          DatabaseAccountKind = original.DatabaseAccountKindMongoDB
	DatabaseAccountKindParse            DatabaseAccountKind = original.DatabaseAccountKindParse
)

type DatabaseAccountOfferType = original.DatabaseAccountOfferType

const (
	DatabaseAccountOfferTypeStandard DatabaseAccountOfferType = original.DatabaseAccountOfferTypeStandard
)

type DefaultConsistencyLevel = original.DefaultConsistencyLevel

const (
	DefaultConsistencyLevelBoundedStaleness DefaultConsistencyLevel = original.DefaultConsistencyLevelBoundedStaleness
	DefaultConsistencyLevelConsistentPrefix DefaultConsistencyLevel = original.DefaultConsistencyLevelConsistentPrefix
	DefaultConsistencyLevelEventual         DefaultConsistencyLevel = original.DefaultConsistencyLevelEventual
	DefaultConsistencyLevelSession          DefaultConsistencyLevel = original.DefaultConsistencyLevelSession
	DefaultConsistencyLevelStrong           DefaultConsistencyLevel = original.DefaultConsistencyLevelStrong
)

type IndexKind = original.IndexKind

const (
	IndexKindHash    IndexKind = original.IndexKindHash
	IndexKindRange   IndexKind = original.IndexKindRange
	IndexKindSpatial IndexKind = original.IndexKindSpatial
)

type IndexingMode = original.IndexingMode

const (
	IndexingModeConsistent IndexingMode = original.IndexingModeConsistent
	IndexingModeLazy       IndexingMode = original.IndexingModeLazy
	IndexingModeNone       IndexingMode = original.IndexingModeNone
)

type KeyKind = original.KeyKind

const (
	KeyKindPrimary           KeyKind = original.KeyKindPrimary
	KeyKindPrimaryReadonly   KeyKind = original.KeyKindPrimaryReadonly
	KeyKindSecondary         KeyKind = original.KeyKindSecondary
	KeyKindSecondaryReadonly KeyKind = original.KeyKindSecondaryReadonly
)

type ManagedCassandraProvisioningState = original.ManagedCassandraProvisioningState

const (
	ManagedCassandraProvisioningStateCanceled  ManagedCassandraProvisioningState = original.ManagedCassandraProvisioningStateCanceled
	ManagedCassandraProvisioningStateCreating  ManagedCassandraProvisioningState = original.ManagedCassandraProvisioningStateCreating
	ManagedCassandraProvisioningStateDeleting  ManagedCassandraProvisioningState = original.ManagedCassandraProvisioningStateDeleting
	ManagedCassandraProvisioningStateFailed    ManagedCassandraProvisioningState = original.ManagedCassandraProvisioningStateFailed
	ManagedCassandraProvisioningStateSucceeded ManagedCassandraProvisioningState = original.ManagedCassandraProvisioningStateSucceeded
	ManagedCassandraProvisioningStateUpdating  ManagedCassandraProvisioningState = original.ManagedCassandraProvisioningStateUpdating
)

type ManagedCassandraResourceIdentityType = original.ManagedCassandraResourceIdentityType

const (
	ManagedCassandraResourceIdentityTypeNone           ManagedCassandraResourceIdentityType = original.ManagedCassandraResourceIdentityTypeNone
	ManagedCassandraResourceIdentityTypeSystemAssigned ManagedCassandraResourceIdentityType = original.ManagedCassandraResourceIdentityTypeSystemAssigned
)

type NetworkACLBypass = original.NetworkACLBypass

const (
	NetworkACLBypassAzureServices NetworkACLBypass = original.NetworkACLBypassAzureServices
	NetworkACLBypassNone          NetworkACLBypass = original.NetworkACLBypassNone
)

type NodeState = original.NodeState

const (
	NodeStateJoining NodeState = original.NodeStateJoining
	NodeStateLeaving NodeState = original.NodeStateLeaving
	NodeStateMoving  NodeState = original.NodeStateMoving
	NodeStateNormal  NodeState = original.NodeStateNormal
	NodeStateStopped NodeState = original.NodeStateStopped
)

type NodeStatus = original.NodeStatus

const (
	NodeStatusDown NodeStatus = original.NodeStatusDown
	NodeStatusUp   NodeStatus = original.NodeStatusUp
)

type OperationType = original.OperationType

const (
	OperationTypeCreate          OperationType = original.OperationTypeCreate
	OperationTypeDelete          OperationType = original.OperationTypeDelete
	OperationTypeReplace         OperationType = original.OperationTypeReplace
	OperationTypeSystemOperation OperationType = original.OperationTypeSystemOperation
)

type PartitionKind = original.PartitionKind

const (
	PartitionKindHash      PartitionKind = original.PartitionKindHash
	PartitionKindMultiHash PartitionKind = original.PartitionKindMultiHash
	PartitionKindRange     PartitionKind = original.PartitionKindRange
)

type PrimaryAggregationType = original.PrimaryAggregationType

const (
	PrimaryAggregationTypeAverage PrimaryAggregationType = original.PrimaryAggregationTypeAverage
	PrimaryAggregationTypeLast    PrimaryAggregationType = original.PrimaryAggregationTypeLast
	PrimaryAggregationTypeMaximum PrimaryAggregationType = original.PrimaryAggregationTypeMaximum
	PrimaryAggregationTypeMinimum PrimaryAggregationType = original.PrimaryAggregationTypeMinimum
	PrimaryAggregationTypeNone    PrimaryAggregationType = original.PrimaryAggregationTypeNone
	PrimaryAggregationTypeTotal   PrimaryAggregationType = original.PrimaryAggregationTypeTotal
)

type PublicNetworkAccess = original.PublicNetworkAccess

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = original.PublicNetworkAccessDisabled
	PublicNetworkAccessEnabled  PublicNetworkAccess = original.PublicNetworkAccessEnabled
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone                       ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeSystemAssigned             ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssignedUserAssigned
	ResourceIdentityTypeUserAssigned               ResourceIdentityType = original.ResourceIdentityTypeUserAssigned
)

type RestoreMode = original.RestoreMode

const (
	RestoreModePointInTime RestoreMode = original.RestoreModePointInTime
)

type RoleDefinitionType = original.RoleDefinitionType

const (
	RoleDefinitionTypeBuiltInRole RoleDefinitionType = original.RoleDefinitionTypeBuiltInRole
	RoleDefinitionTypeCustomRole  RoleDefinitionType = original.RoleDefinitionTypeCustomRole
)

type ServerVersion = original.ServerVersion

const (
	ServerVersionFourFullStopZero ServerVersion = original.ServerVersionFourFullStopZero
	ServerVersionThreeFullStopSix ServerVersion = original.ServerVersionThreeFullStopSix
	ServerVersionThreeFullStopTwo ServerVersion = original.ServerVersionThreeFullStopTwo
)

type SpatialType = original.SpatialType

const (
	SpatialTypeLineString   SpatialType = original.SpatialTypeLineString
	SpatialTypeMultiPolygon SpatialType = original.SpatialTypeMultiPolygon
	SpatialTypePoint        SpatialType = original.SpatialTypePoint
	SpatialTypePolygon      SpatialType = original.SpatialTypePolygon
)

type TriggerOperation = original.TriggerOperation

const (
	TriggerOperationAll     TriggerOperation = original.TriggerOperationAll
	TriggerOperationCreate  TriggerOperation = original.TriggerOperationCreate
	TriggerOperationDelete  TriggerOperation = original.TriggerOperationDelete
	TriggerOperationReplace TriggerOperation = original.TriggerOperationReplace
	TriggerOperationUpdate  TriggerOperation = original.TriggerOperationUpdate
)

type TriggerType = original.TriggerType

const (
	TriggerTypePost TriggerType = original.TriggerTypePost
	TriggerTypePre  TriggerType = original.TriggerTypePre
)

type Type = original.Type

const (
	TypeBackupPolicy Type = original.TypeBackupPolicy
	TypeContinuous   Type = original.TypeContinuous
	TypePeriodic     Type = original.TypePeriodic
)

type UnitType = original.UnitType

const (
	UnitTypeBytes          UnitType = original.UnitTypeBytes
	UnitTypeBytesPerSecond UnitType = original.UnitTypeBytesPerSecond
	UnitTypeCount          UnitType = original.UnitTypeCount
	UnitTypeCountPerSecond UnitType = original.UnitTypeCountPerSecond
	UnitTypeMilliseconds   UnitType = original.UnitTypeMilliseconds
	UnitTypePercent        UnitType = original.UnitTypePercent
	UnitTypeSeconds        UnitType = original.UnitTypeSeconds
)

type APIProperties = original.APIProperties
type ARMProxyResource = original.ARMProxyResource
type ARMResourceProperties = original.ARMResourceProperties
type AnalyticalStorageConfiguration = original.AnalyticalStorageConfiguration
type AutoUpgradePolicyResource = original.AutoUpgradePolicyResource
type AutoscaleSettings = original.AutoscaleSettings
type AutoscaleSettingsResource = original.AutoscaleSettingsResource
type AzureEntityResource = original.AzureEntityResource
type BackupInformation = original.BackupInformation
type BackupPolicy = original.BackupPolicy
type BackupPolicyMigrationState = original.BackupPolicyMigrationState
type BaseClient = original.BaseClient
type BasicBackupPolicy = original.BasicBackupPolicy
type Capability = original.Capability
type Capacity = original.Capacity
type CassandraClusterPublicStatus = original.CassandraClusterPublicStatus
type CassandraClusterPublicStatusDataCentersItem = original.CassandraClusterPublicStatusDataCentersItem
type CassandraClusterPublicStatusDataCentersItemNodesItem = original.CassandraClusterPublicStatusDataCentersItemNodesItem
type CassandraClustersClient = original.CassandraClustersClient
type CassandraClustersCreateUpdateFuture = original.CassandraClustersCreateUpdateFuture
type CassandraClustersDeallocateFuture = original.CassandraClustersDeallocateFuture
type CassandraClustersDeleteFuture = original.CassandraClustersDeleteFuture
type CassandraClustersInvokeCommandFuture = original.CassandraClustersInvokeCommandFuture
type CassandraClustersStartFuture = original.CassandraClustersStartFuture
type CassandraClustersUpdateFuture = original.CassandraClustersUpdateFuture
type CassandraDataCentersClient = original.CassandraDataCentersClient
type CassandraDataCentersCreateUpdateFuture = original.CassandraDataCentersCreateUpdateFuture
type CassandraDataCentersDeleteFuture = original.CassandraDataCentersDeleteFuture
type CassandraDataCentersUpdateFuture = original.CassandraDataCentersUpdateFuture
type CassandraKeyspaceCreateUpdateParameters = original.CassandraKeyspaceCreateUpdateParameters
type CassandraKeyspaceCreateUpdateProperties = original.CassandraKeyspaceCreateUpdateProperties
type CassandraKeyspaceGetProperties = original.CassandraKeyspaceGetProperties
type CassandraKeyspaceGetPropertiesOptions = original.CassandraKeyspaceGetPropertiesOptions
type CassandraKeyspaceGetPropertiesResource = original.CassandraKeyspaceGetPropertiesResource
type CassandraKeyspaceGetResults = original.CassandraKeyspaceGetResults
type CassandraKeyspaceListResult = original.CassandraKeyspaceListResult
type CassandraKeyspaceResource = original.CassandraKeyspaceResource
type CassandraPartitionKey = original.CassandraPartitionKey
type CassandraResourcesClient = original.CassandraResourcesClient
type CassandraResourcesCreateUpdateCassandraKeyspaceFuture = original.CassandraResourcesCreateUpdateCassandraKeyspaceFuture
type CassandraResourcesCreateUpdateCassandraTableFuture = original.CassandraResourcesCreateUpdateCassandraTableFuture
type CassandraResourcesDeleteCassandraKeyspaceFuture = original.CassandraResourcesDeleteCassandraKeyspaceFuture
type CassandraResourcesDeleteCassandraTableFuture = original.CassandraResourcesDeleteCassandraTableFuture
type CassandraResourcesMigrateCassandraKeyspaceToAutoscaleFuture = original.CassandraResourcesMigrateCassandraKeyspaceToAutoscaleFuture
type CassandraResourcesMigrateCassandraKeyspaceToManualThroughputFuture = original.CassandraResourcesMigrateCassandraKeyspaceToManualThroughputFuture
type CassandraResourcesMigrateCassandraTableToAutoscaleFuture = original.CassandraResourcesMigrateCassandraTableToAutoscaleFuture
type CassandraResourcesMigrateCassandraTableToManualThroughputFuture = original.CassandraResourcesMigrateCassandraTableToManualThroughputFuture
type CassandraResourcesUpdateCassandraKeyspaceThroughputFuture = original.CassandraResourcesUpdateCassandraKeyspaceThroughputFuture
type CassandraResourcesUpdateCassandraTableThroughputFuture = original.CassandraResourcesUpdateCassandraTableThroughputFuture
type CassandraSchema = original.CassandraSchema
type CassandraTableCreateUpdateParameters = original.CassandraTableCreateUpdateParameters
type CassandraTableCreateUpdateProperties = original.CassandraTableCreateUpdateProperties
type CassandraTableGetProperties = original.CassandraTableGetProperties
type CassandraTableGetPropertiesOptions = original.CassandraTableGetPropertiesOptions
type CassandraTableGetPropertiesResource = original.CassandraTableGetPropertiesResource
type CassandraTableGetResults = original.CassandraTableGetResults
type CassandraTableListResult = original.CassandraTableListResult
type CassandraTableResource = original.CassandraTableResource
type Certificate = original.Certificate
type CloudError = original.CloudError
type ClusterKey = original.ClusterKey
type ClusterResource = original.ClusterResource
type ClusterResourceProperties = original.ClusterResourceProperties
type CollectionClient = original.CollectionClient
type CollectionPartitionClient = original.CollectionPartitionClient
type CollectionPartitionRegionClient = original.CollectionPartitionRegionClient
type CollectionRegionClient = original.CollectionRegionClient
type Column = original.Column
type CommandOutput = original.CommandOutput
type CommandPostBody = original.CommandPostBody
type CompositePath = original.CompositePath
type ConflictResolutionPolicy = original.ConflictResolutionPolicy
type ConnectionError = original.ConnectionError
type ConsistencyPolicy = original.ConsistencyPolicy
type ContainerPartitionKey = original.ContainerPartitionKey
type ContinuousBackupInformation = original.ContinuousBackupInformation
type ContinuousBackupRestoreLocation = original.ContinuousBackupRestoreLocation
type ContinuousModeBackupPolicy = original.ContinuousModeBackupPolicy
type CorsPolicy = original.CorsPolicy
type CreateUpdateOptions = original.CreateUpdateOptions
type DataCenterResource = original.DataCenterResource
type DataCenterResourceProperties = original.DataCenterResourceProperties
type DatabaseAccountConnectionString = original.DatabaseAccountConnectionString
type DatabaseAccountCreateUpdateParameters = original.DatabaseAccountCreateUpdateParameters
type DatabaseAccountCreateUpdateProperties = original.DatabaseAccountCreateUpdateProperties
type DatabaseAccountGetProperties = original.DatabaseAccountGetProperties
type DatabaseAccountGetResults = original.DatabaseAccountGetResults
type DatabaseAccountListConnectionStringsResult = original.DatabaseAccountListConnectionStringsResult
type DatabaseAccountListKeysResult = original.DatabaseAccountListKeysResult
type DatabaseAccountListReadOnlyKeysResult = original.DatabaseAccountListReadOnlyKeysResult
type DatabaseAccountRegenerateKeyParameters = original.DatabaseAccountRegenerateKeyParameters
type DatabaseAccountRegionClient = original.DatabaseAccountRegionClient
type DatabaseAccountUpdateParameters = original.DatabaseAccountUpdateParameters
type DatabaseAccountUpdateProperties = original.DatabaseAccountUpdateProperties
type DatabaseAccountsClient = original.DatabaseAccountsClient
type DatabaseAccountsCreateOrUpdateFuture = original.DatabaseAccountsCreateOrUpdateFuture
type DatabaseAccountsDeleteFuture = original.DatabaseAccountsDeleteFuture
type DatabaseAccountsFailoverPriorityChangeFuture = original.DatabaseAccountsFailoverPriorityChangeFuture
type DatabaseAccountsListResult = original.DatabaseAccountsListResult
type DatabaseAccountsOfflineRegionFuture = original.DatabaseAccountsOfflineRegionFuture
type DatabaseAccountsOnlineRegionFuture = original.DatabaseAccountsOnlineRegionFuture
type DatabaseAccountsRegenerateKeyFuture = original.DatabaseAccountsRegenerateKeyFuture
type DatabaseAccountsUpdateFuture = original.DatabaseAccountsUpdateFuture
type DatabaseClient = original.DatabaseClient
type DatabaseRestoreResource = original.DatabaseRestoreResource
type ErrorResponse = original.ErrorResponse
type ExcludedPath = original.ExcludedPath
type ExtendedResourceProperties = original.ExtendedResourceProperties
type FailoverPolicies = original.FailoverPolicies
type FailoverPolicy = original.FailoverPolicy
type GremlinDatabaseCreateUpdateParameters = original.GremlinDatabaseCreateUpdateParameters
type GremlinDatabaseCreateUpdateProperties = original.GremlinDatabaseCreateUpdateProperties
type GremlinDatabaseGetProperties = original.GremlinDatabaseGetProperties
type GremlinDatabaseGetPropertiesOptions = original.GremlinDatabaseGetPropertiesOptions
type GremlinDatabaseGetPropertiesResource = original.GremlinDatabaseGetPropertiesResource
type GremlinDatabaseGetResults = original.GremlinDatabaseGetResults
type GremlinDatabaseListResult = original.GremlinDatabaseListResult
type GremlinDatabaseResource = original.GremlinDatabaseResource
type GremlinGraphCreateUpdateParameters = original.GremlinGraphCreateUpdateParameters
type GremlinGraphCreateUpdateProperties = original.GremlinGraphCreateUpdateProperties
type GremlinGraphGetProperties = original.GremlinGraphGetProperties
type GremlinGraphGetPropertiesOptions = original.GremlinGraphGetPropertiesOptions
type GremlinGraphGetPropertiesResource = original.GremlinGraphGetPropertiesResource
type GremlinGraphGetResults = original.GremlinGraphGetResults
type GremlinGraphListResult = original.GremlinGraphListResult
type GremlinGraphResource = original.GremlinGraphResource
type GremlinResourcesClient = original.GremlinResourcesClient
type GremlinResourcesCreateUpdateGremlinDatabaseFuture = original.GremlinResourcesCreateUpdateGremlinDatabaseFuture
type GremlinResourcesCreateUpdateGremlinGraphFuture = original.GremlinResourcesCreateUpdateGremlinGraphFuture
type GremlinResourcesDeleteGremlinDatabaseFuture = original.GremlinResourcesDeleteGremlinDatabaseFuture
type GremlinResourcesDeleteGremlinGraphFuture = original.GremlinResourcesDeleteGremlinGraphFuture
type GremlinResourcesMigrateGremlinDatabaseToAutoscaleFuture = original.GremlinResourcesMigrateGremlinDatabaseToAutoscaleFuture
type GremlinResourcesMigrateGremlinDatabaseToManualThroughputFuture = original.GremlinResourcesMigrateGremlinDatabaseToManualThroughputFuture
type GremlinResourcesMigrateGremlinGraphToAutoscaleFuture = original.GremlinResourcesMigrateGremlinGraphToAutoscaleFuture
type GremlinResourcesMigrateGremlinGraphToManualThroughputFuture = original.GremlinResourcesMigrateGremlinGraphToManualThroughputFuture
type GremlinResourcesUpdateGremlinDatabaseThroughputFuture = original.GremlinResourcesUpdateGremlinDatabaseThroughputFuture
type GremlinResourcesUpdateGremlinGraphThroughputFuture = original.GremlinResourcesUpdateGremlinGraphThroughputFuture
type IPAddressOrRange = original.IPAddressOrRange
type IncludedPath = original.IncludedPath
type Indexes = original.Indexes
type IndexingPolicy = original.IndexingPolicy
type ListClusters = original.ListClusters
type ListDataCenters = original.ListDataCenters
type Location = original.Location
type LocationGetResult = original.LocationGetResult
type LocationListResult = original.LocationListResult
type LocationProperties = original.LocationProperties
type LocationsClient = original.LocationsClient
type ManagedCassandraARMResourceProperties = original.ManagedCassandraARMResourceProperties
type ManagedCassandraManagedServiceIdentity = original.ManagedCassandraManagedServiceIdentity
type ManagedCassandraReaperStatus = original.ManagedCassandraReaperStatus
type ManagedServiceIdentity = original.ManagedServiceIdentity
type ManagedServiceIdentityUserAssignedIdentitiesValue = original.ManagedServiceIdentityUserAssignedIdentitiesValue
type Metric = original.Metric
type MetricAvailability = original.MetricAvailability
type MetricDefinition = original.MetricDefinition
type MetricDefinitionsListResult = original.MetricDefinitionsListResult
type MetricListResult = original.MetricListResult
type MetricName = original.MetricName
type MetricValue = original.MetricValue
type MongoDBCollectionCreateUpdateParameters = original.MongoDBCollectionCreateUpdateParameters
type MongoDBCollectionCreateUpdateProperties = original.MongoDBCollectionCreateUpdateProperties
type MongoDBCollectionGetProperties = original.MongoDBCollectionGetProperties
type MongoDBCollectionGetPropertiesOptions = original.MongoDBCollectionGetPropertiesOptions
type MongoDBCollectionGetPropertiesResource = original.MongoDBCollectionGetPropertiesResource
type MongoDBCollectionGetResults = original.MongoDBCollectionGetResults
type MongoDBCollectionListResult = original.MongoDBCollectionListResult
type MongoDBCollectionResource = original.MongoDBCollectionResource
type MongoDBDatabaseCreateUpdateParameters = original.MongoDBDatabaseCreateUpdateParameters
type MongoDBDatabaseCreateUpdateProperties = original.MongoDBDatabaseCreateUpdateProperties
type MongoDBDatabaseGetProperties = original.MongoDBDatabaseGetProperties
type MongoDBDatabaseGetPropertiesOptions = original.MongoDBDatabaseGetPropertiesOptions
type MongoDBDatabaseGetPropertiesResource = original.MongoDBDatabaseGetPropertiesResource
type MongoDBDatabaseGetResults = original.MongoDBDatabaseGetResults
type MongoDBDatabaseListResult = original.MongoDBDatabaseListResult
type MongoDBDatabaseResource = original.MongoDBDatabaseResource
type MongoDBResourcesClient = original.MongoDBResourcesClient
type MongoDBResourcesCreateUpdateMongoDBCollectionFuture = original.MongoDBResourcesCreateUpdateMongoDBCollectionFuture
type MongoDBResourcesCreateUpdateMongoDBDatabaseFuture = original.MongoDBResourcesCreateUpdateMongoDBDatabaseFuture
type MongoDBResourcesDeleteMongoDBCollectionFuture = original.MongoDBResourcesDeleteMongoDBCollectionFuture
type MongoDBResourcesDeleteMongoDBDatabaseFuture = original.MongoDBResourcesDeleteMongoDBDatabaseFuture
type MongoDBResourcesMigrateMongoDBCollectionToAutoscaleFuture = original.MongoDBResourcesMigrateMongoDBCollectionToAutoscaleFuture
type MongoDBResourcesMigrateMongoDBCollectionToManualThroughputFuture = original.MongoDBResourcesMigrateMongoDBCollectionToManualThroughputFuture
type MongoDBResourcesMigrateMongoDBDatabaseToAutoscaleFuture = original.MongoDBResourcesMigrateMongoDBDatabaseToAutoscaleFuture
type MongoDBResourcesMigrateMongoDBDatabaseToManualThroughputFuture = original.MongoDBResourcesMigrateMongoDBDatabaseToManualThroughputFuture
type MongoDBResourcesRetrieveContinuousBackupInformationFuture = original.MongoDBResourcesRetrieveContinuousBackupInformationFuture
type MongoDBResourcesUpdateMongoDBCollectionThroughputFuture = original.MongoDBResourcesUpdateMongoDBCollectionThroughputFuture
type MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture = original.MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture
type MongoIndex = original.MongoIndex
type MongoIndexKeys = original.MongoIndexKeys
type MongoIndexOptions = original.MongoIndexOptions
type NotebookWorkspace = original.NotebookWorkspace
type NotebookWorkspaceConnectionInfoResult = original.NotebookWorkspaceConnectionInfoResult
type NotebookWorkspaceCreateUpdateParameters = original.NotebookWorkspaceCreateUpdateParameters
type NotebookWorkspaceListResult = original.NotebookWorkspaceListResult
type NotebookWorkspaceProperties = original.NotebookWorkspaceProperties
type NotebookWorkspacesClient = original.NotebookWorkspacesClient
type NotebookWorkspacesCreateOrUpdateFuture = original.NotebookWorkspacesCreateOrUpdateFuture
type NotebookWorkspacesDeleteFuture = original.NotebookWorkspacesDeleteFuture
type NotebookWorkspacesRegenerateAuthTokenFuture = original.NotebookWorkspacesRegenerateAuthTokenFuture
type NotebookWorkspacesStartFuture = original.NotebookWorkspacesStartFuture
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type OptionsResource = original.OptionsResource
type PartitionKeyRangeIDClient = original.PartitionKeyRangeIDClient
type PartitionKeyRangeIDRegionClient = original.PartitionKeyRangeIDRegionClient
type PartitionMetric = original.PartitionMetric
type PartitionMetricListResult = original.PartitionMetricListResult
type PartitionUsage = original.PartitionUsage
type PartitionUsagesResult = original.PartitionUsagesResult
type PercentileClient = original.PercentileClient
type PercentileMetric = original.PercentileMetric
type PercentileMetricListResult = original.PercentileMetricListResult
type PercentileMetricValue = original.PercentileMetricValue
type PercentileSourceTargetClient = original.PercentileSourceTargetClient
type PercentileTargetClient = original.PercentileTargetClient
type PeriodicModeBackupPolicy = original.PeriodicModeBackupPolicy
type PeriodicModeProperties = original.PeriodicModeProperties
type Permission = original.Permission
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateEndpointConnectionsCreateOrUpdateFuture = original.PrivateEndpointConnectionsCreateOrUpdateFuture
type PrivateEndpointConnectionsDeleteFuture = original.PrivateEndpointConnectionsDeleteFuture
type PrivateEndpointProperty = original.PrivateEndpointProperty
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceListResult = original.PrivateLinkResourceListResult
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkServiceConnectionStateProperty = original.PrivateLinkServiceConnectionStateProperty
type ProxyResource = original.ProxyResource
type RegionForOnlineOffline = original.RegionForOnlineOffline
type Resource = original.Resource
type RestorableDatabaseAccountGetResult = original.RestorableDatabaseAccountGetResult
type RestorableDatabaseAccountProperties = original.RestorableDatabaseAccountProperties
type RestorableDatabaseAccountsClient = original.RestorableDatabaseAccountsClient
type RestorableDatabaseAccountsListResult = original.RestorableDatabaseAccountsListResult
type RestorableLocationResource = original.RestorableLocationResource
type RestorableMongodbCollectionGetResult = original.RestorableMongodbCollectionGetResult
type RestorableMongodbCollectionProperties = original.RestorableMongodbCollectionProperties
type RestorableMongodbCollectionPropertiesResource = original.RestorableMongodbCollectionPropertiesResource
type RestorableMongodbCollectionsClient = original.RestorableMongodbCollectionsClient
type RestorableMongodbCollectionsListResult = original.RestorableMongodbCollectionsListResult
type RestorableMongodbDatabaseGetResult = original.RestorableMongodbDatabaseGetResult
type RestorableMongodbDatabaseProperties = original.RestorableMongodbDatabaseProperties
type RestorableMongodbDatabasePropertiesResource = original.RestorableMongodbDatabasePropertiesResource
type RestorableMongodbDatabasesClient = original.RestorableMongodbDatabasesClient
type RestorableMongodbDatabasesListResult = original.RestorableMongodbDatabasesListResult
type RestorableMongodbResourcesClient = original.RestorableMongodbResourcesClient
type RestorableMongodbResourcesListResult = original.RestorableMongodbResourcesListResult
type RestorableSQLContainerGetResult = original.RestorableSQLContainerGetResult
type RestorableSQLContainerProperties = original.RestorableSQLContainerProperties
type RestorableSQLContainerPropertiesResource = original.RestorableSQLContainerPropertiesResource
type RestorableSQLContainerPropertiesResourceContainer = original.RestorableSQLContainerPropertiesResourceContainer
type RestorableSQLContainersClient = original.RestorableSQLContainersClient
type RestorableSQLContainersListResult = original.RestorableSQLContainersListResult
type RestorableSQLDatabaseGetResult = original.RestorableSQLDatabaseGetResult
type RestorableSQLDatabaseProperties = original.RestorableSQLDatabaseProperties
type RestorableSQLDatabasePropertiesResource = original.RestorableSQLDatabasePropertiesResource
type RestorableSQLDatabasePropertiesResourceDatabase = original.RestorableSQLDatabasePropertiesResourceDatabase
type RestorableSQLDatabasesClient = original.RestorableSQLDatabasesClient
type RestorableSQLDatabasesListResult = original.RestorableSQLDatabasesListResult
type RestorableSQLResourcesClient = original.RestorableSQLResourcesClient
type RestorableSQLResourcesListResult = original.RestorableSQLResourcesListResult
type RestoreParameters = original.RestoreParameters
type SQLContainerCreateUpdateParameters = original.SQLContainerCreateUpdateParameters
type SQLContainerCreateUpdateProperties = original.SQLContainerCreateUpdateProperties
type SQLContainerGetProperties = original.SQLContainerGetProperties
type SQLContainerGetPropertiesOptions = original.SQLContainerGetPropertiesOptions
type SQLContainerGetPropertiesResource = original.SQLContainerGetPropertiesResource
type SQLContainerGetResults = original.SQLContainerGetResults
type SQLContainerListResult = original.SQLContainerListResult
type SQLContainerResource = original.SQLContainerResource
type SQLDatabaseCreateUpdateParameters = original.SQLDatabaseCreateUpdateParameters
type SQLDatabaseCreateUpdateProperties = original.SQLDatabaseCreateUpdateProperties
type SQLDatabaseGetProperties = original.SQLDatabaseGetProperties
type SQLDatabaseGetPropertiesOptions = original.SQLDatabaseGetPropertiesOptions
type SQLDatabaseGetPropertiesResource = original.SQLDatabaseGetPropertiesResource
type SQLDatabaseGetResults = original.SQLDatabaseGetResults
type SQLDatabaseListResult = original.SQLDatabaseListResult
type SQLDatabaseResource = original.SQLDatabaseResource
type SQLResourcesClient = original.SQLResourcesClient
type SQLResourcesCreateUpdateSQLContainerFuture = original.SQLResourcesCreateUpdateSQLContainerFuture
type SQLResourcesCreateUpdateSQLDatabaseFuture = original.SQLResourcesCreateUpdateSQLDatabaseFuture
type SQLResourcesCreateUpdateSQLRoleAssignmentFuture = original.SQLResourcesCreateUpdateSQLRoleAssignmentFuture
type SQLResourcesCreateUpdateSQLRoleDefinitionFuture = original.SQLResourcesCreateUpdateSQLRoleDefinitionFuture
type SQLResourcesCreateUpdateSQLStoredProcedureFuture = original.SQLResourcesCreateUpdateSQLStoredProcedureFuture
type SQLResourcesCreateUpdateSQLTriggerFuture = original.SQLResourcesCreateUpdateSQLTriggerFuture
type SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture = original.SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture
type SQLResourcesDeleteSQLContainerFuture = original.SQLResourcesDeleteSQLContainerFuture
type SQLResourcesDeleteSQLDatabaseFuture = original.SQLResourcesDeleteSQLDatabaseFuture
type SQLResourcesDeleteSQLRoleAssignmentFuture = original.SQLResourcesDeleteSQLRoleAssignmentFuture
type SQLResourcesDeleteSQLRoleDefinitionFuture = original.SQLResourcesDeleteSQLRoleDefinitionFuture
type SQLResourcesDeleteSQLStoredProcedureFuture = original.SQLResourcesDeleteSQLStoredProcedureFuture
type SQLResourcesDeleteSQLTriggerFuture = original.SQLResourcesDeleteSQLTriggerFuture
type SQLResourcesDeleteSQLUserDefinedFunctionFuture = original.SQLResourcesDeleteSQLUserDefinedFunctionFuture
type SQLResourcesMigrateSQLContainerToAutoscaleFuture = original.SQLResourcesMigrateSQLContainerToAutoscaleFuture
type SQLResourcesMigrateSQLContainerToManualThroughputFuture = original.SQLResourcesMigrateSQLContainerToManualThroughputFuture
type SQLResourcesMigrateSQLDatabaseToAutoscaleFuture = original.SQLResourcesMigrateSQLDatabaseToAutoscaleFuture
type SQLResourcesMigrateSQLDatabaseToManualThroughputFuture = original.SQLResourcesMigrateSQLDatabaseToManualThroughputFuture
type SQLResourcesRetrieveContinuousBackupInformationFuture = original.SQLResourcesRetrieveContinuousBackupInformationFuture
type SQLResourcesUpdateSQLContainerThroughputFuture = original.SQLResourcesUpdateSQLContainerThroughputFuture
type SQLResourcesUpdateSQLDatabaseThroughputFuture = original.SQLResourcesUpdateSQLDatabaseThroughputFuture
type SQLRoleAssignmentCreateUpdateParameters = original.SQLRoleAssignmentCreateUpdateParameters
type SQLRoleAssignmentGetResults = original.SQLRoleAssignmentGetResults
type SQLRoleAssignmentListResult = original.SQLRoleAssignmentListResult
type SQLRoleAssignmentResource = original.SQLRoleAssignmentResource
type SQLRoleDefinitionCreateUpdateParameters = original.SQLRoleDefinitionCreateUpdateParameters
type SQLRoleDefinitionGetResults = original.SQLRoleDefinitionGetResults
type SQLRoleDefinitionListResult = original.SQLRoleDefinitionListResult
type SQLRoleDefinitionResource = original.SQLRoleDefinitionResource
type SQLStoredProcedureCreateUpdateParameters = original.SQLStoredProcedureCreateUpdateParameters
type SQLStoredProcedureCreateUpdateProperties = original.SQLStoredProcedureCreateUpdateProperties
type SQLStoredProcedureGetProperties = original.SQLStoredProcedureGetProperties
type SQLStoredProcedureGetPropertiesResource = original.SQLStoredProcedureGetPropertiesResource
type SQLStoredProcedureGetResults = original.SQLStoredProcedureGetResults
type SQLStoredProcedureListResult = original.SQLStoredProcedureListResult
type SQLStoredProcedureResource = original.SQLStoredProcedureResource
type SQLTriggerCreateUpdateParameters = original.SQLTriggerCreateUpdateParameters
type SQLTriggerCreateUpdateProperties = original.SQLTriggerCreateUpdateProperties
type SQLTriggerGetProperties = original.SQLTriggerGetProperties
type SQLTriggerGetPropertiesResource = original.SQLTriggerGetPropertiesResource
type SQLTriggerGetResults = original.SQLTriggerGetResults
type SQLTriggerListResult = original.SQLTriggerListResult
type SQLTriggerResource = original.SQLTriggerResource
type SQLUserDefinedFunctionCreateUpdateParameters = original.SQLUserDefinedFunctionCreateUpdateParameters
type SQLUserDefinedFunctionCreateUpdateProperties = original.SQLUserDefinedFunctionCreateUpdateProperties
type SQLUserDefinedFunctionGetProperties = original.SQLUserDefinedFunctionGetProperties
type SQLUserDefinedFunctionGetPropertiesResource = original.SQLUserDefinedFunctionGetPropertiesResource
type SQLUserDefinedFunctionGetResults = original.SQLUserDefinedFunctionGetResults
type SQLUserDefinedFunctionListResult = original.SQLUserDefinedFunctionListResult
type SQLUserDefinedFunctionResource = original.SQLUserDefinedFunctionResource
type SeedNode = original.SeedNode
type SpatialSpec = original.SpatialSpec
type SystemData = original.SystemData
type TableCreateUpdateParameters = original.TableCreateUpdateParameters
type TableCreateUpdateProperties = original.TableCreateUpdateProperties
type TableGetProperties = original.TableGetProperties
type TableGetPropertiesOptions = original.TableGetPropertiesOptions
type TableGetPropertiesResource = original.TableGetPropertiesResource
type TableGetResults = original.TableGetResults
type TableListResult = original.TableListResult
type TableResource = original.TableResource
type TableResourcesClient = original.TableResourcesClient
type TableResourcesCreateUpdateTableFuture = original.TableResourcesCreateUpdateTableFuture
type TableResourcesDeleteTableFuture = original.TableResourcesDeleteTableFuture
type TableResourcesMigrateTableToAutoscaleFuture = original.TableResourcesMigrateTableToAutoscaleFuture
type TableResourcesMigrateTableToManualThroughputFuture = original.TableResourcesMigrateTableToManualThroughputFuture
type TableResourcesUpdateTableThroughputFuture = original.TableResourcesUpdateTableThroughputFuture
type ThroughputPolicyResource = original.ThroughputPolicyResource
type ThroughputSettingsGetProperties = original.ThroughputSettingsGetProperties
type ThroughputSettingsGetPropertiesResource = original.ThroughputSettingsGetPropertiesResource
type ThroughputSettingsGetResults = original.ThroughputSettingsGetResults
type ThroughputSettingsResource = original.ThroughputSettingsResource
type ThroughputSettingsUpdateParameters = original.ThroughputSettingsUpdateParameters
type ThroughputSettingsUpdateProperties = original.ThroughputSettingsUpdateProperties
type TrackedResource = original.TrackedResource
type UniqueKey = original.UniqueKey
type UniqueKeyPolicy = original.UniqueKeyPolicy
type Usage = original.Usage
type UsagesResult = original.UsagesResult
type VirtualNetworkRule = original.VirtualNetworkRule

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewCassandraClustersClient(subscriptionID string) CassandraClustersClient {
	return original.NewCassandraClustersClient(subscriptionID)
}
func NewCassandraClustersClientWithBaseURI(baseURI string, subscriptionID string) CassandraClustersClient {
	return original.NewCassandraClustersClientWithBaseURI(baseURI, subscriptionID)
}
func NewCassandraDataCentersClient(subscriptionID string) CassandraDataCentersClient {
	return original.NewCassandraDataCentersClient(subscriptionID)
}
func NewCassandraDataCentersClientWithBaseURI(baseURI string, subscriptionID string) CassandraDataCentersClient {
	return original.NewCassandraDataCentersClientWithBaseURI(baseURI, subscriptionID)
}
func NewCassandraResourcesClient(subscriptionID string) CassandraResourcesClient {
	return original.NewCassandraResourcesClient(subscriptionID)
}
func NewCassandraResourcesClientWithBaseURI(baseURI string, subscriptionID string) CassandraResourcesClient {
	return original.NewCassandraResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewCollectionClient(subscriptionID string) CollectionClient {
	return original.NewCollectionClient(subscriptionID)
}
func NewCollectionClientWithBaseURI(baseURI string, subscriptionID string) CollectionClient {
	return original.NewCollectionClientWithBaseURI(baseURI, subscriptionID)
}
func NewCollectionPartitionClient(subscriptionID string) CollectionPartitionClient {
	return original.NewCollectionPartitionClient(subscriptionID)
}
func NewCollectionPartitionClientWithBaseURI(baseURI string, subscriptionID string) CollectionPartitionClient {
	return original.NewCollectionPartitionClientWithBaseURI(baseURI, subscriptionID)
}
func NewCollectionPartitionRegionClient(subscriptionID string) CollectionPartitionRegionClient {
	return original.NewCollectionPartitionRegionClient(subscriptionID)
}
func NewCollectionPartitionRegionClientWithBaseURI(baseURI string, subscriptionID string) CollectionPartitionRegionClient {
	return original.NewCollectionPartitionRegionClientWithBaseURI(baseURI, subscriptionID)
}
func NewCollectionRegionClient(subscriptionID string) CollectionRegionClient {
	return original.NewCollectionRegionClient(subscriptionID)
}
func NewCollectionRegionClientWithBaseURI(baseURI string, subscriptionID string) CollectionRegionClient {
	return original.NewCollectionRegionClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseAccountRegionClient(subscriptionID string) DatabaseAccountRegionClient {
	return original.NewDatabaseAccountRegionClient(subscriptionID)
}
func NewDatabaseAccountRegionClientWithBaseURI(baseURI string, subscriptionID string) DatabaseAccountRegionClient {
	return original.NewDatabaseAccountRegionClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseAccountsClient(subscriptionID string) DatabaseAccountsClient {
	return original.NewDatabaseAccountsClient(subscriptionID)
}
func NewDatabaseAccountsClientWithBaseURI(baseURI string, subscriptionID string) DatabaseAccountsClient {
	return original.NewDatabaseAccountsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseClient(subscriptionID string) DatabaseClient {
	return original.NewDatabaseClient(subscriptionID)
}
func NewDatabaseClientWithBaseURI(baseURI string, subscriptionID string) DatabaseClient {
	return original.NewDatabaseClientWithBaseURI(baseURI, subscriptionID)
}
func NewGremlinResourcesClient(subscriptionID string) GremlinResourcesClient {
	return original.NewGremlinResourcesClient(subscriptionID)
}
func NewGremlinResourcesClientWithBaseURI(baseURI string, subscriptionID string) GremlinResourcesClient {
	return original.NewGremlinResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocationsClient(subscriptionID string) LocationsClient {
	return original.NewLocationsClient(subscriptionID)
}
func NewLocationsClientWithBaseURI(baseURI string, subscriptionID string) LocationsClient {
	return original.NewLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMongoDBResourcesClient(subscriptionID string) MongoDBResourcesClient {
	return original.NewMongoDBResourcesClient(subscriptionID)
}
func NewMongoDBResourcesClientWithBaseURI(baseURI string, subscriptionID string) MongoDBResourcesClient {
	return original.NewMongoDBResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewNotebookWorkspacesClient(subscriptionID string) NotebookWorkspacesClient {
	return original.NewNotebookWorkspacesClient(subscriptionID)
}
func NewNotebookWorkspacesClientWithBaseURI(baseURI string, subscriptionID string) NotebookWorkspacesClient {
	return original.NewNotebookWorkspacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPartitionKeyRangeIDClient(subscriptionID string) PartitionKeyRangeIDClient {
	return original.NewPartitionKeyRangeIDClient(subscriptionID)
}
func NewPartitionKeyRangeIDClientWithBaseURI(baseURI string, subscriptionID string) PartitionKeyRangeIDClient {
	return original.NewPartitionKeyRangeIDClientWithBaseURI(baseURI, subscriptionID)
}
func NewPartitionKeyRangeIDRegionClient(subscriptionID string) PartitionKeyRangeIDRegionClient {
	return original.NewPartitionKeyRangeIDRegionClient(subscriptionID)
}
func NewPartitionKeyRangeIDRegionClientWithBaseURI(baseURI string, subscriptionID string) PartitionKeyRangeIDRegionClient {
	return original.NewPartitionKeyRangeIDRegionClientWithBaseURI(baseURI, subscriptionID)
}
func NewPercentileClient(subscriptionID string) PercentileClient {
	return original.NewPercentileClient(subscriptionID)
}
func NewPercentileClientWithBaseURI(baseURI string, subscriptionID string) PercentileClient {
	return original.NewPercentileClientWithBaseURI(baseURI, subscriptionID)
}
func NewPercentileSourceTargetClient(subscriptionID string) PercentileSourceTargetClient {
	return original.NewPercentileSourceTargetClient(subscriptionID)
}
func NewPercentileSourceTargetClientWithBaseURI(baseURI string, subscriptionID string) PercentileSourceTargetClient {
	return original.NewPercentileSourceTargetClientWithBaseURI(baseURI, subscriptionID)
}
func NewPercentileTargetClient(subscriptionID string) PercentileTargetClient {
	return original.NewPercentileTargetClient(subscriptionID)
}
func NewPercentileTargetClientWithBaseURI(baseURI string, subscriptionID string) PercentileTargetClient {
	return original.NewPercentileTargetClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorableDatabaseAccountsClient(subscriptionID string) RestorableDatabaseAccountsClient {
	return original.NewRestorableDatabaseAccountsClient(subscriptionID)
}
func NewRestorableDatabaseAccountsClientWithBaseURI(baseURI string, subscriptionID string) RestorableDatabaseAccountsClient {
	return original.NewRestorableDatabaseAccountsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorableMongodbCollectionsClient(subscriptionID string) RestorableMongodbCollectionsClient {
	return original.NewRestorableMongodbCollectionsClient(subscriptionID)
}
func NewRestorableMongodbCollectionsClientWithBaseURI(baseURI string, subscriptionID string) RestorableMongodbCollectionsClient {
	return original.NewRestorableMongodbCollectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorableMongodbDatabasesClient(subscriptionID string) RestorableMongodbDatabasesClient {
	return original.NewRestorableMongodbDatabasesClient(subscriptionID)
}
func NewRestorableMongodbDatabasesClientWithBaseURI(baseURI string, subscriptionID string) RestorableMongodbDatabasesClient {
	return original.NewRestorableMongodbDatabasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorableMongodbResourcesClient(subscriptionID string) RestorableMongodbResourcesClient {
	return original.NewRestorableMongodbResourcesClient(subscriptionID)
}
func NewRestorableMongodbResourcesClientWithBaseURI(baseURI string, subscriptionID string) RestorableMongodbResourcesClient {
	return original.NewRestorableMongodbResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorableSQLContainersClient(subscriptionID string) RestorableSQLContainersClient {
	return original.NewRestorableSQLContainersClient(subscriptionID)
}
func NewRestorableSQLContainersClientWithBaseURI(baseURI string, subscriptionID string) RestorableSQLContainersClient {
	return original.NewRestorableSQLContainersClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorableSQLDatabasesClient(subscriptionID string) RestorableSQLDatabasesClient {
	return original.NewRestorableSQLDatabasesClient(subscriptionID)
}
func NewRestorableSQLDatabasesClientWithBaseURI(baseURI string, subscriptionID string) RestorableSQLDatabasesClient {
	return original.NewRestorableSQLDatabasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorableSQLResourcesClient(subscriptionID string) RestorableSQLResourcesClient {
	return original.NewRestorableSQLResourcesClient(subscriptionID)
}
func NewRestorableSQLResourcesClientWithBaseURI(baseURI string, subscriptionID string) RestorableSQLResourcesClient {
	return original.NewRestorableSQLResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLResourcesClient(subscriptionID string) SQLResourcesClient {
	return original.NewSQLResourcesClient(subscriptionID)
}
func NewSQLResourcesClientWithBaseURI(baseURI string, subscriptionID string) SQLResourcesClient {
	return original.NewSQLResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewTableResourcesClient(subscriptionID string) TableResourcesClient {
	return original.NewTableResourcesClient(subscriptionID)
}
func NewTableResourcesClientWithBaseURI(baseURI string, subscriptionID string) TableResourcesClient {
	return original.NewTableResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAPITypeValues() []APIType {
	return original.PossibleAPITypeValues()
}
func PossibleAnalyticalStorageSchemaTypeValues() []AnalyticalStorageSchemaType {
	return original.PossibleAnalyticalStorageSchemaTypeValues()
}
func PossibleAuthenticationMethodValues() []AuthenticationMethod {
	return original.PossibleAuthenticationMethodValues()
}
func PossibleBackupPolicyMigrationStatusValues() []BackupPolicyMigrationStatus {
	return original.PossibleBackupPolicyMigrationStatusValues()
}
func PossibleBackupPolicyTypeValues() []BackupPolicyType {
	return original.PossibleBackupPolicyTypeValues()
}
func PossibleBackupStorageRedundancyValues() []BackupStorageRedundancy {
	return original.PossibleBackupStorageRedundancyValues()
}
func PossibleCompositePathSortOrderValues() []CompositePathSortOrder {
	return original.PossibleCompositePathSortOrderValues()
}
func PossibleConflictResolutionModeValues() []ConflictResolutionMode {
	return original.PossibleConflictResolutionModeValues()
}
func PossibleConnectionStateValues() []ConnectionState {
	return original.PossibleConnectionStateValues()
}
func PossibleConnectorOfferValues() []ConnectorOffer {
	return original.PossibleConnectorOfferValues()
}
func PossibleCreateModeValues() []CreateMode {
	return original.PossibleCreateModeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDataTypeValues() []DataType {
	return original.PossibleDataTypeValues()
}
func PossibleDatabaseAccountKindValues() []DatabaseAccountKind {
	return original.PossibleDatabaseAccountKindValues()
}
func PossibleDatabaseAccountOfferTypeValues() []DatabaseAccountOfferType {
	return original.PossibleDatabaseAccountOfferTypeValues()
}
func PossibleDefaultConsistencyLevelValues() []DefaultConsistencyLevel {
	return original.PossibleDefaultConsistencyLevelValues()
}
func PossibleIndexKindValues() []IndexKind {
	return original.PossibleIndexKindValues()
}
func PossibleIndexingModeValues() []IndexingMode {
	return original.PossibleIndexingModeValues()
}
func PossibleKeyKindValues() []KeyKind {
	return original.PossibleKeyKindValues()
}
func PossibleManagedCassandraProvisioningStateValues() []ManagedCassandraProvisioningState {
	return original.PossibleManagedCassandraProvisioningStateValues()
}
func PossibleManagedCassandraResourceIdentityTypeValues() []ManagedCassandraResourceIdentityType {
	return original.PossibleManagedCassandraResourceIdentityTypeValues()
}
func PossibleNetworkACLBypassValues() []NetworkACLBypass {
	return original.PossibleNetworkACLBypassValues()
}
func PossibleNodeStateValues() []NodeState {
	return original.PossibleNodeStateValues()
}
func PossibleNodeStatusValues() []NodeStatus {
	return original.PossibleNodeStatusValues()
}
func PossibleOperationTypeValues() []OperationType {
	return original.PossibleOperationTypeValues()
}
func PossiblePartitionKindValues() []PartitionKind {
	return original.PossiblePartitionKindValues()
}
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return original.PossiblePrimaryAggregationTypeValues()
}
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return original.PossiblePublicNetworkAccessValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleRestoreModeValues() []RestoreMode {
	return original.PossibleRestoreModeValues()
}
func PossibleRoleDefinitionTypeValues() []RoleDefinitionType {
	return original.PossibleRoleDefinitionTypeValues()
}
func PossibleServerVersionValues() []ServerVersion {
	return original.PossibleServerVersionValues()
}
func PossibleSpatialTypeValues() []SpatialType {
	return original.PossibleSpatialTypeValues()
}
func PossibleTriggerOperationValues() []TriggerOperation {
	return original.PossibleTriggerOperationValues()
}
func PossibleTriggerTypeValues() []TriggerType {
	return original.PossibleTriggerTypeValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleUnitTypeValues() []UnitType {
	return original.PossibleUnitTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
