10 PRINT "PROGRAM FILE 134: KOMOLGOROV-SMIRNOV UNIFORMITY TEST FOR"
15 PRINT "        RND FUNCTION."
20 PRINT "    ANSI STANDARD 8.4"
30 PRINT
40 PRINT "SECTION 134.1: KOMOLGOROV-SMIRNOV UNIFORMITY TEST FOR"
50 PRINT "        RND FUNCTION."
60 PRINT
70 PRINT "THIS PROGRAM RUNS 30 TESTS OF 1000 SAMPLES EACH TO CHECK"
80 PRINT "UNIFORMITY OF DISTRIBUTION OF RANDOM NUMBERS. KOMOLGOROV-"
90 PRINT "SMIRNOV (K-S) STATISTICS (K+ AND K-) ARE GENERATED FOR"
100 PRINT "EACH TEST. THESE TWO NUMBERS ARE A MEASURE OF THE GREATEST"
110 PRINT "DEVIATION, IN THE POSITIVE AND NEGATIVE DIRECTION, OF THE"
120 PRINT "ACCUMULATION OF THE 1000 NUMBERS FROM THE IDEAL DISTRIBUTION"
130 PRINT "OF F(X)=X, 0<=X<1."
140 PRINT
150 PRINT "THESE TWO SETS (K+ AND K-) OF 30 STATISTICS THEMSELVES HAVE"
160 PRINT "AN EXPECTED DISTRIBUTION OF F(X) = 1 - EXP(-2*X*X). THE"
170 PRINT "K-S TEST IS RUN AGAIN ON EACH OF THESE TWO SETS, AND IF"
180 PRINT "THE DEVIATION IS TOO GREAT (TOP OR BOTTOM 1%) FOR ANY ONE "
190 PRINT "OF THE RESULTING STATISTICS, THEN THE TEST FAILS."
200 PRINT
210 PRINT "                 BEGIN TEST"
220 PRINT
230 DIM P(1200),Q(30),R(30)
240 REM SET #TRIALS PER EXPERIMENT
250 LET N=1000
260 REM SET #SLOTS USED IN ARRAY
270 LET N8=INT(1.1*N)
280 REM SET #EXPERIMENTS
290 LET N9=30
300 PRINT
310 REM BEGIN TEST LOOP
320 PRINT "TEST","K+","K-"
330 FOR L=1 TO N9
340 REM MARK SLOTS AS EMPTY
350 FOR I=1 TO N8
360 LET P(I)=3
370 NEXT I
380 REM FILL SLOTS WITH RANDOM VALUES, APPROXIMATELY IN ORDER
390 FOR I=1 TO N
400 LET X=RND
410 LET X1=INT(N8*X)
411 REM    MR. HAM ADDED NEXT 2 LINES TO FIX TEST
412 IF X1>0 THEN 420
413 LET X1=X1+1
420 IF P(X1)<>3 THEN 460
430 LET P(X1)=X
440 GOTO 590
450 REM IF PRIMARY SLOT FILLED, SEARCH FOR NEAREST EMPTY SLOT
460 FOR J=1 TO N8
470 IF X1-J<1 THEN 510
480 IF P(X1-J)<>3 THEN 510
490 LET P(X1-J)=X
500 GOTO 590
510 IF X1+J>N8 THEN 550
520 IF P(X1+J)<>3 THEN 550
530 LET P(X1+J)=X
540 GOTO 590
550 NEXT J
560 PRINT "RED ALERT - NO SLOT FOUND",I,X
570 PRINT "FATAL ERROR IN PROGRAM ALGORITHM"
580 STOP
590 NEXT I
600 REM FIND GROUPS SEPARATED BY EMPTY SLOTS
605 REM ASSERT ALL ELEMENTS OF ONE GROUP < ALL ELEMENTS OF NEXT GROUP
607 REM THEREFORE, NEED SORT ONLY WITHIN GROUPS
610 LET I=1
620 FOR I8=I TO N8
630 IF P(I8)<>3 THEN 660
640 NEXT I8
650 GOTO 930
660 FOR I9=I8 TO N8
670 IF P(I9)=3 THEN 700
680 NEXT I9
690 LET I9=N8+1
700 IF I8>=I9-1 THEN 720
710 GOSUB 750
720 LET I=I9
730 GOTO 620
740 REM BUBBLE-SORT A GROUP
750 LET I5=I8
760 LET I6=I9-2
770 LET I7=1
780 LET A3=0
790 FOR J1=I5 TO I6 STEP I7
800 IF P(J1)<=P(J1+1) THEN 850
810 LET A3=9
820 LET W=P(J1)
830 LET P(J1)=P(J1+1)
840 LET P(J1+1)=W
850 NEXT J1
860 REM REVERSE DIRECTION OF SCAN
870 LET W=I5
880 LET I5=I6
890 LET I6=W
900 LET I7=0-I7
910 IF A3<>0 THEN 780
920 RETURN
930 REM GROUPS SORTED, DO COMPRESS
940 LET S1=0
950 FOR R1=1 TO N
960 LET S1=S1+1
970 IF P(S1)=3 THEN 960
980 LET P(R1)=P(S1)
990 NEXT R1
1000 LET M1=-1E38
1010 LET M2=-1E38
1020 REM FIND K+ AND K- ON PRIMARY DATA
1030 FOR I=1 TO N
1040 LET N1=(I/N)-P(I)
1050 LET N2=P(I)-((I-1)/N)
1060 IF N1<M1 THEN 1080
1070 LET M1=N1
1080 IF N2<M2 THEN 1100
1090 LET M2=N2
1100 NEXT I
1110 LET N5=SQR(N)
1120 LET M1=M1*N5
1130 LET M2=M2*N5
1140 LET Q(L)=M1
1150 LET R(L)=M2
1160 PRINT L,M1,M2
1170 NEXT L
1180 LET F=0
1190 PRINT
1200 PRINT "SUMMARY K-S STATISTICS FOR THE K+ VALUES"
1210 GOSUB 1430
1220 PRINT
1230 PRINT "SUMMARY K-S STATISTICS FOR THE K- VALUES"
1240 REM SET UP Q-ARRAY FOR SUBROUTINE
1250 FOR L=1 TO N9
1260 LET Q(L)=R(L)
1270 NEXT L
1280 GOSUB 1430
1290 PRINT
1300 REM BASED ON 30 TRIALS
1310 PRINT "ALL RESULTS SHOULD FALL BETWEEN .04354 AND 1.4801"
1320 PRINT
1330 IF F=0 THEN 1360
1340 PRINT "*** TEST FAILED ***"
1350 GOTO 1370
1360 PRINT "*** TEST PASSED ***"
1370 PRINT
1380 PRINT
1390 PRINT "               END TEST"
1400 PRINT
1410 PRINT "END PROGRAM 134"
1420 STOP
1430 REM FIND K+ AND K- ON KS-STATS FROM PRIMARY DATA
1440 FOR I=1 TO N9-1
1450 FOR J=I+1 TO N9
1460 IF Q(I)<=Q(J) THEN 1500
1470 LET W=Q(I)
1480 LET Q(I)=Q(J)
1490 LET Q(J)=W
1500 NEXT J
1510 NEXT I
1520 LET M1=-1E38
1530 LET M2=-1E38
1550 FOR I=1 TO N9
1560 LET F1=1-EXP(-2*Q(I)*Q(I))
1570 LET N1=(I/N9) - F1
1580 LET N2=F1 - ((I-1)/N9)
1590 IF N1<M1 THEN 1610
1600 LET M1=N1
1610 IF N2<M2 THEN 1630
1620 LET M2=N2
1630 NEXT I
1640 LET N5=SQR(N9)
1650 LET M1=M1*N5
1660 LET M2=M2*N5
1670 PRINT "K+ = ";M1;"        K- = ";M2
1680 PRINT
1690 REM VALUES BASED ON 30 TRIALS
1700 IF M1<.04354 THEN 1750
1710 IF M1>1.4801 THEN 1750
1720 IF M2<.04354 THEN 1750
1730 IF M2>1.4801 THEN 1750
1740 GOTO 1760
1750 LET F=F+1
1760 RETURN
1770 END
