/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.osgi.framework.Bundle;

public class BundleResourceURLConnection
extends URLConnection {
    private final Bundle bundle;
    private final String bundlePath;
    private URLConnection delegatee;

    protected BundleResourceURLConnection(Bundle bundle, String bundlePath, URL url) {
        super(url);
        this.bundle = bundle;
        this.bundlePath = bundlePath;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (!this.connected) {
            URL url = this.bundle.getEntry(this.bundlePath);
            if (url == null) {
                throw new IOException("Cannot find entry " + this.bundlePath + " in bundle " + this.bundle + " for URL " + url);
            }
            this.delegatee = url.openConnection();
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.delegatee.getInputStream();
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return -1;
        }
        return this.delegatee.getContentLength();
    }

    @Override
    public long getLastModified() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return 0L;
        }
        return this.bundle.getLastModified();
    }

    @Override
    public String getContentType() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return null;
        }
        return this.delegatee.getContentType();
    }
}

