/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.builder.impl;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.builder.impl.HttpSessionImpl;
import org.apache.sling.api.request.builder.impl.RequestParameterMapImpl;
import org.apache.sling.api.request.builder.impl.SlingHttpServletRequestBuilderImpl;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class SlingJakartaHttpServletRequestImpl
extends SlingAdaptable
implements SlingJakartaHttpServletRequest {
    private final SlingHttpServletRequestBuilderImpl builder;

    public SlingJakartaHttpServletRequestImpl(SlingHttpServletRequestBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Resource getResource() {
        return this.builder.resource;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.getResource().getResourceResolver();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.builder.session == null && create) {
            this.builder.session = this.builder.sessionProvider != null ? this.builder.sessionProvider.getSession(create) : new HttpSessionImpl(this.builder.servletContext);
        }
        return this.builder.session;
    }

    @Override
    public RequestPathInfo getRequestPathInfo() {
        return this.builder.requestPathInfo;
    }

    public Object getAttribute(String name) {
        if (this.builder.attributesProvider != null) {
            return this.builder.attributesProvider.getAttribute(name);
        }
        return this.builder.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.builder.attributesProvider != null) {
            return this.builder.attributesProvider.getAttributeNames();
        }
        return Collections.enumeration(this.builder.attributeMap.keySet());
    }

    public void removeAttribute(String name) {
        if (this.builder.attributesProvider != null) {
            this.builder.attributesProvider.removeAttribute(name);
        } else {
            this.builder.attributeMap.remove(name);
        }
    }

    public void setAttribute(String name, Object object) {
        if (this.builder.attributesProvider != null) {
            this.builder.attributesProvider.setAttribute(name, object);
        } else {
            this.builder.attributeMap.put(name, object);
        }
    }

    public String getParameter(String name) {
        String[] values = this.builder.parameters.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.builder.parameters);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.builder.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.builder.parameters.get(name);
    }

    @Override
    public RequestParameter getRequestParameter(String name) {
        return this.getRequestParameterMap().getValue(name);
    }

    @Override
    public RequestParameterMap getRequestParameterMap() {
        if (this.builder.requestParameterMap == null) {
            this.builder.requestParameterMap = new RequestParameterMapImpl(this.builder.parameters);
        }
        return this.builder.requestParameterMap;
    }

    @Override
    public RequestParameter[] getRequestParameters(String name) {
        return (RequestParameter[])this.getRequestParameterMap().get(name);
    }

    @Override
    public List<RequestParameter> getRequestParameterList() {
        ArrayList<RequestParameter> params = new ArrayList<RequestParameter>();
        for (RequestParameter[] requestParameters : this.getRequestParameterMap().values()) {
            params.addAll(Arrays.asList(requestParameters));
        }
        return params;
    }

    public Collection<Part> getParts() {
        return Collections.emptyList();
    }

    public Part getPart(String name) {
        return null;
    }

    public Locale getLocale() {
        return this.builder.locale;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Collections.singleton(this.getLocale()));
    }

    public String getContextPath() {
        return this.builder.contextPath;
    }

    public String getQueryString() {
        return this.builder.queryString;
    }

    public String getScheme() {
        return this.builder.scheme;
    }

    public String getServerName() {
        return this.builder.serverName;
    }

    public int getServerPort() {
        return this.builder.serverPort;
    }

    public boolean isSecure() {
        return "https".equals(this.builder.scheme);
    }

    public String getMethod() {
        return this.builder.requestMethod;
    }

    public long getDateHeader(String name) {
        return this.builder.headerSupport.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.builder.headerSupport.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.builder.headerSupport.getHeaderNames());
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.builder.headerSupport.getHeaders(name));
    }

    public int getIntHeader(String name) {
        return this.builder.headerSupport.getIntHeader(name);
    }

    @Override
    public Cookie getCookie(String name) {
        return this.builder.cookies.get(name);
    }

    public Cookie[] getCookies() {
        if (this.builder.cookies.isEmpty()) {
            return null;
        }
        return this.builder.cookies.values().toArray(new Cookie[this.builder.cookies.size()]);
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    @Override
    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return SlingHttpServletRequestBuilderImpl.EMPTY_RESOURCE_BUNDLE;
    }

    public String getCharacterEncoding() {
        return this.builder.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.builder.characterEncoding = encoding;
    }

    public String getContentType() {
        if (this.builder.contentType == null) {
            return null;
        }
        if (this.builder.characterEncoding == null) {
            return this.builder.contentType;
        }
        return this.builder.contentType.concat(";charset=").concat(this.builder.characterEncoding);
    }

    public ServletInputStream getInputStream() {
        if (this.builder.getReaderCalled) {
            throw new IllegalStateException();
        }
        this.builder.getInputStreamCalled = true;
        return new ServletInputStream(){
            private final InputStream is;
            {
                this.is = new ByteArrayInputStream(SlingJakartaHttpServletRequestImpl.this.builder.body.getBytes(StandardCharsets.UTF_8));
            }

            public int read() throws IOException {
                return this.is.read();
            }

            public boolean isReady() {
                return true;
            }

            public boolean isFinished() {
                throw new UnsupportedOperationException();
            }

            public void setReadListener(ReadListener readListener) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public BufferedReader getReader() {
        if (this.builder.getInputStreamCalled) {
            throw new IllegalStateException();
        }
        this.builder.getReaderCalled = true;
        return new BufferedReader(new StringReader(this.builder.body));
    }

    public int getContentLength() {
        return this.builder.body.length();
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.builder.requestDispatcherProvider != null) {
            return this.builder.requestDispatcherProvider.getRequestDispatcher(path);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path, RequestDispatcherOptions options) {
        if (this.builder.requestDispatcherProvider != null) {
            return this.builder.requestDispatcherProvider.getRequestDispatcher(path, options);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(Resource resource) {
        if (this.builder.requestDispatcherProvider != null) {
            return this.builder.requestDispatcherProvider.getRequestDispatcher(resource);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(Resource resource, RequestDispatcherOptions options) {
        if (this.builder.requestDispatcherProvider != null) {
            return this.builder.requestDispatcherProvider.getRequestDispatcher(resource, options);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRemoteUser() {
        return this.builder.remoteUser;
    }

    public String getRemoteAddr() {
        return this.builder.remoteAddr;
    }

    public String getRemoteHost() {
        return this.builder.remoteHost;
    }

    public int getRemotePort() {
        return this.builder.remotePort;
    }

    public String getServletPath() {
        return this.builder.servletPath;
    }

    public String getPathInfo() {
        return this.builder.pathInfo;
    }

    public String getRequestURI() {
        StringBuilder requestUri = new StringBuilder();
        requestUri.append(this.builder.contextPath);
        requestUri.append(this.builder.servletPath);
        requestUri.append(this.builder.pathInfo);
        return requestUri.toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer requestUrl = new StringBuffer();
        requestUrl.append(this.builder.scheme);
        requestUrl.append("://");
        requestUrl.append(this.builder.serverName);
        boolean includePort = true;
        if ("http".equals(this.builder.scheme) && this.builder.serverPort == 80 || "https".equals(this.builder.scheme) && this.builder.serverPort == 443) {
            includePort = false;
        }
        if (includePort) {
            requestUrl.append(':');
            requestUrl.append(this.builder.serverPort);
        }
        requestUrl.append(this.getRequestURI());
        return requestUrl;
    }

    @Override
    public String getAuthType() {
        return this.builder.authType;
    }

    @Override
    public String getResponseContentType() {
        return this.builder.responseContentType;
    }

    @Override
    public Enumeration<String> getResponseContentTypes() {
        return Collections.enumeration(Collections.singleton(this.builder.responseContentType));
    }

    @Override
    public RequestProgressTracker getRequestProgressTracker() {
        return this.builder.progressTracker;
    }

    public ServletContext getServletContext() {
        return this.builder.servletContext;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    public void login(String pUsername, String password) {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public String getProtocolRequestId() {
        throw new UnsupportedOperationException();
    }

    public String getRequestId() {
        throw new UnsupportedOperationException();
    }

    public ServletConnection getServletConnection() {
        throw new UnsupportedOperationException();
    }
}

