/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static List<Server> serversModel(io.swagger.v3.oas.annotations.servers.Server[] servers) {
        if (servers == null) {
            return null;
        }
        return Arrays.stream(servers).map(AnnotationUtils::convertServer).collect(Collectors.toList());
    }

    public static Server convertServer(io.swagger.v3.oas.annotations.servers.Server server) {
        Server item = new Server();
        item.setUrl(server.url());
        item.setDescription(server.description());
        return item;
    }

    public static io.swagger.v3.oas.models.info.Info infoModel(Info infoAnnotation) {
        if (infoAnnotation == null) {
            return null;
        }
        io.swagger.v3.oas.models.info.Info info = new io.swagger.v3.oas.models.info.Info();
        info.setTitle(infoAnnotation.title());
        info.setVersion(infoAnnotation.version());
        if (StringUtils.isNotEmpty((CharSequence)infoAnnotation.description())) {
            info.setDescription(infoAnnotation.description());
        }
        if (StringUtils.isNotEmpty((CharSequence)infoAnnotation.termsOfService())) {
            info.setTermsOfService(infoAnnotation.termsOfService());
        }
        info.setContact(AnnotationUtils.contactModel(infoAnnotation.contact()));
        info.setLicense(AnnotationUtils.licenseModel(infoAnnotation.license()));
        info.setExtensions(AnnotationUtils.extensionsModel(infoAnnotation.extensions()));
        return info;
    }

    public static License licenseModel(io.swagger.v3.oas.annotations.info.License licenseAnnotation) {
        License license = new License();
        if (StringUtils.isNotEmpty((CharSequence)licenseAnnotation.name())) {
            license.setName(licenseAnnotation.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)licenseAnnotation.url())) {
            license.setUrl(licenseAnnotation.url());
        }
        if (StringUtils.isEmpty((CharSequence)license.getName()) && StringUtils.isEmpty((CharSequence)license.getUrl())) {
            return null;
        }
        return license;
    }

    public static Contact contactModel(io.swagger.v3.oas.annotations.info.Contact contactAnnotation) {
        Contact contact = new Contact();
        if (StringUtils.isNotEmpty((CharSequence)contactAnnotation.name())) {
            contact.setName(contactAnnotation.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)contactAnnotation.url())) {
            contact.setUrl(contactAnnotation.url());
        }
        if (StringUtils.isNotEmpty((CharSequence)contactAnnotation.email())) {
            contact.setEmail(contactAnnotation.email());
        }
        if (StringUtils.isEmpty((CharSequence)contact.getName()) && StringUtils.isEmpty((CharSequence)contact.getUrl()) && StringUtils.isEmpty((CharSequence)contact.getEmail())) {
            return null;
        }
        return contact;
    }

    public static List<io.swagger.v3.oas.models.tags.Tag> tagsModel(Tag[] tagArray) {
        if (tagArray == null) {
            return null;
        }
        List<io.swagger.v3.oas.models.tags.Tag> tags = Arrays.stream(tagArray).filter(t -> !t.name().isEmpty()).map(AnnotationUtils::tagModel).collect(Collectors.toList());
        return tags.isEmpty() ? null : tags;
    }

    public static List<String> tagsModel(String[] tagArray) {
        if (tagArray == null) {
            return null;
        }
        List<String> tags = Arrays.stream(tagArray).filter(t -> !t.isEmpty()).collect(Collectors.toList());
        return tags.isEmpty() ? null : tags;
    }

    public static io.swagger.v3.oas.models.tags.Tag tagModel(Tag tagAnnotation) {
        io.swagger.v3.oas.models.tags.Tag tag = new io.swagger.v3.oas.models.tags.Tag();
        tag.setName(tagAnnotation.name());
        tag.setDescription(tagAnnotation.description());
        tag.setExternalDocs(AnnotationUtils.externalDocumentationModel(tagAnnotation.externalDocs()));
        tag.setExtensions(AnnotationUtils.extensionsModel(tagAnnotation.extensions()));
        return tag;
    }

    public static ExternalDocumentation externalDocumentationModel(io.swagger.v3.oas.annotations.ExternalDocumentation externalDocs) {
        ExternalDocumentation doc = new ExternalDocumentation();
        doc.setUrl(externalDocs.url());
        doc.setDescription(externalDocs.description());
        return doc;
    }

    public static Map<String, Object> extensionsModel(Extension[] extensions) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Stream.of(extensions).forEach(e -> result.put(e.name(), AnnotationUtils.extensionPropertiesModel(e.properties())));
        return result;
    }

    public static Map<String, String> extensionPropertiesModel(ExtensionProperty[] properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        Stream.of(properties).forEach(e -> result.put(e.name(), e.value()));
        return result;
    }

    public static String responseCodeModel(io.swagger.v3.oas.annotations.responses.ApiResponse apiResponse) {
        if (StringUtils.isEmpty((CharSequence)apiResponse.responseCode())) {
            return "200";
        }
        return apiResponse.responseCode();
    }

    public static io.swagger.v3.oas.models.responses.ApiResponses apiResponsesModel(OpenAPI openAPI, ApiResponses apiResponses) {
        io.swagger.v3.oas.models.responses.ApiResponses result = new io.swagger.v3.oas.models.responses.ApiResponses();
        result.setExtensions(AnnotationUtils.extensionsModel(apiResponses.extensions()));
        for (io.swagger.v3.oas.annotations.responses.ApiResponse apiResponse : apiResponses.value()) {
            result.addApiResponse(AnnotationUtils.responseCodeModel(apiResponse), AnnotationUtils.apiResponseModel(openAPI, apiResponse));
        }
        return result;
    }

    public static io.swagger.v3.oas.models.responses.ApiResponses apiResponsesModel(OpenAPI openAPI, io.swagger.v3.oas.annotations.responses.ApiResponse[] apiResponses) {
        io.swagger.v3.oas.models.responses.ApiResponses result = new io.swagger.v3.oas.models.responses.ApiResponses();
        for (io.swagger.v3.oas.annotations.responses.ApiResponse apiResponse : apiResponses) {
            if (result.get((Object)AnnotationUtils.responseCodeModel(apiResponse)) != null) {
                throw new IllegalStateException("not support too many ApiResponse with same status code");
            }
            result.addApiResponse(AnnotationUtils.responseCodeModel(apiResponse), AnnotationUtils.apiResponseModel(openAPI, apiResponse));
        }
        return result;
    }

    public static ApiResponse apiResponseModel(OpenAPI openAPI, io.swagger.v3.oas.annotations.responses.ApiResponse apiResponse) {
        ApiResponse result = new ApiResponse();
        result.setDescription(apiResponse.description());
        result.setContent(AnnotationUtils.contentModel(openAPI, apiResponse.content()));
        result.setHeaders(AnnotationUtils.headersModel(openAPI, apiResponse.headers()));
        return result;
    }

    public static Map<String, Header> headersModel(OpenAPI openAPI, io.swagger.v3.oas.annotations.headers.Header[] headers) {
        HashMap<String, Header> result = new HashMap<String, Header>();
        for (io.swagger.v3.oas.annotations.headers.Header header : headers) {
            Header model = new Header();
            model.setDescription(header.description());
            model.setSchema(AnnotationUtils.schemaModel(openAPI, header.schema()));
            result.put(header.name(), model);
        }
        return result;
    }

    public static Content contentModel(OpenAPI openAPI, io.swagger.v3.oas.annotations.media.Content[] contents) {
        Content result = new Content();
        for (io.swagger.v3.oas.annotations.media.Content content : contents) {
            boolean isForm;
            String mediaTypeName = AnnotationUtils.mediaTypeModel(content);
            MediaType mediaType = (MediaType)result.get((Object)mediaTypeName);
            boolean bl = isForm = "application/x-www-form-urlencoded".equals(mediaTypeName) || "multipart/form-data".equals(mediaTypeName);
            if (mediaType == null) {
                mediaType = new MediaType();
                if (isForm) {
                    io.swagger.v3.oas.models.media.Schema schema = new io.swagger.v3.oas.models.media.Schema();
                    schema.setProperties(new HashMap());
                    schema.addProperty(content.schema().name(), AnnotationUtils.schemaModel(openAPI, content.schema(), content.examples()));
                    mediaType.setSchema(schema);
                } else {
                    mediaType.setSchema(AnnotationUtils.schemaModel(openAPI, content.schema(), content.examples()));
                }
                result.addMediaType(mediaTypeName, mediaType);
                continue;
            }
            if (isForm) {
                mediaType.getSchema().addProperty(content.schema().name(), AnnotationUtils.schemaModel(openAPI, content.schema(), content.examples()));
                continue;
            }
            throw new IllegalStateException("Not allowed to define duplicated content type for " + mediaTypeName);
        }
        return result;
    }

    public static RequestBody requestBodyModel(OpenAPI openAPI, io.swagger.v3.oas.annotations.parameters.RequestBody requestBody) {
        if (requestBody == null || AnnotationUtils.isOperationDefaultRequestBody(requestBody)) {
            return null;
        }
        RequestBody result = new RequestBody();
        result.setContent(AnnotationUtils.contentModel(openAPI, requestBody.content()));
        return result;
    }

    private static boolean isOperationDefaultRequestBody(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody) {
        return "".equals(requestBody.description()) && requestBody.content().length == 0 && !requestBody.required() && requestBody.extensions().length == 0;
    }

    private static String mediaTypeModel(io.swagger.v3.oas.annotations.media.Content content) {
        if (StringUtils.isEmpty((CharSequence)content.mediaType())) {
            return "application/json";
        }
        return content.mediaType();
    }

    public static io.swagger.v3.oas.models.media.Schema schemaModel(OpenAPI openAPI, Schema schema) {
        if (schema.implementation() != Void.class) {
            io.swagger.v3.oas.models.media.Schema result = SwaggerUtils.resolveTypeSchemas(openAPI, schema.implementation());
            result.setDescription(schema.description());
            result.setExample((Object)schema.example());
            result.setNullable(Boolean.valueOf(schema.nullable()));
            return result;
        }
        io.swagger.v3.oas.models.media.Schema result = new io.swagger.v3.oas.models.media.Schema();
        result.setType(schema.type());
        result.setFormat(schema.format());
        result.setDescription(schema.description());
        result.setExample((Object)schema.example());
        result.setNullable(Boolean.valueOf(schema.nullable()));
        return result;
    }

    public static io.swagger.v3.oas.models.media.Schema schemaModel(OpenAPI openAPI, Schema schema, ExampleObject[] exampleObjects) {
        io.swagger.v3.oas.models.media.Schema result = AnnotationUtils.schemaModel(openAPI, schema);
        ArrayList<CallSite> examples = new ArrayList<CallSite>();
        for (ExampleObject exampleObject : exampleObjects) {
            examples.add((CallSite)((Object)(exampleObject.name() + ":" + exampleObject.value())));
        }
        result.setExamples(examples);
        return result;
    }

    public static Operation operationModel(OpenAPI openAPI, io.swagger.v3.oas.annotations.Operation apiOperationAnnotation) {
        Operation result = new Operation();
        result.setSummary(apiOperationAnnotation.summary());
        result.setDescription(apiOperationAnnotation.description());
        result.setExtensions(AnnotationUtils.extensionsModel(apiOperationAnnotation.extensions()));
        result.setResponses(AnnotationUtils.apiResponsesModel(openAPI, apiOperationAnnotation.responses()));
        result.setOperationId(apiOperationAnnotation.operationId());
        result.setTags(AnnotationUtils.tagsModel(apiOperationAnnotation.tags()));
        result.setRequestBody(AnnotationUtils.requestBodyModel(openAPI, apiOperationAnnotation.requestBody()));
        return result;
    }
}

