/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteString;
import io.protostuff.LinkedBuffer;
import io.protostuff.OutputEx;
import io.protostuff.SchemaWriter;
import io.protostuff.StringSerializer;
import io.protostuff.WriteSession;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ProtobufOutputEx
extends WriteSession
implements OutputEx {
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    public ProtobufOutputEx() {
        super(LinkedBuffer.allocate());
    }

    public ProtobufOutputEx(LinkedBuffer buffer) {
        super(buffer);
    }

    public ProtobufOutputEx(LinkedBuffer buffer, int nextBufferSize) {
        super(buffer, nextBufferSize);
    }

    public ProtobufOutputEx clear() {
        super.clear();
        return this;
    }

    @Override
    public void writeInt32(int tag, int tagSize, int value) {
        if (value < 0) {
            this.tail = ProtobufOutputEx.writeTagAndRawVarInt64(tag, tagSize, value, this, this.tail);
            return;
        }
        this.tail = ProtobufOutputEx.writeTagAndRawVarInt32(tag, tagSize, value, this, this.tail);
    }

    @Override
    public void writeUInt32(int tag, int tagSize, int value) {
        this.tail = ProtobufOutputEx.writeTagAndRawVarInt32(tag, tagSize, value, this, this.tail);
    }

    @Override
    public void writeSInt32(int tag, int tagSize, int value) {
        this.tail = ProtobufOutputEx.writeTagAndRawVarInt32(tag, tagSize, ProtobufOutputEx.encodeZigZag32(value), this, this.tail);
    }

    @Override
    public void writeFixed32(int tag, int tagSize, int value) {
        this.tail = ProtobufOutputEx.writeTagAndRawLittleEndian32(tag, tagSize, value, this, this.tail);
    }

    @Override
    public void writeSFixed32(int tag, int tagSize, int value) {
        this.tail = ProtobufOutputEx.writeTagAndRawLittleEndian32(tag, tagSize, value, this, this.tail);
    }

    @Override
    public void writeInt64(int tag, int tagSize, long value) {
        this.tail = ProtobufOutputEx.writeTagAndRawVarInt64(tag, tagSize, value, this, this.tail);
    }

    @Override
    public void writeUInt64(int tag, int tagSize, long value) {
        this.tail = ProtobufOutputEx.writeTagAndRawVarInt64(tag, tagSize, value, this, this.tail);
    }

    @Override
    public void writeSInt64(int tag, int tagSize, long value) {
        this.tail = ProtobufOutputEx.writeTagAndRawVarInt64(tag, tagSize, ProtobufOutputEx.encodeZigZag64(value), this, this.tail);
    }

    @Override
    public void writeFixed64(int tag, int tagSize, long value) {
        this.tail = ProtobufOutputEx.writeTagAndRawLittleEndian64(tag, tagSize, value, this, this.tail);
    }

    @Override
    public void writeSFixed64(int tag, int tagSize, long value) {
        this.tail = ProtobufOutputEx.writeTagAndRawLittleEndian64(tag, tagSize, value, this, this.tail);
    }

    @Override
    public void writeFloat(int tag, int tagSize, float value) {
        this.tail = ProtobufOutputEx.writeTagAndRawLittleEndian32(tag, tagSize, Float.floatToRawIntBits(value), this, this.tail);
    }

    @Override
    public void writeDouble(int tag, int tagSize, double value) {
        this.tail = ProtobufOutputEx.writeTagAndRawLittleEndian64(tag, tagSize, Double.doubleToRawLongBits(value), this, this.tail);
    }

    @Override
    public void writeBool(int tag, int tagSize, boolean value) {
        this.tail = ProtobufOutputEx.writeTagAndRawVarInt32(tag, tagSize, value ? 1 : 0, this, this.tail);
    }

    @Override
    public void writeEnum(int tag, int tagSize, int number) {
        this.writeInt32(tag, tagSize, number);
    }

    @Override
    public void writeString(int tag, int tagSize, String value) {
        this.tail = StringSerializer.writeUTF8VarDelimited((CharSequence)value, (WriteSession)this, (LinkedBuffer)ProtobufOutputEx.writeRawVarInt32(tag, this, this.tail));
    }

    @Override
    public void writeBytes(int tag, int tagSize, ByteString value) {
        this.writeByteArray(tag, tagSize, value.getBytes());
    }

    @Override
    public void writeByteArray(int tag, int tagSize, byte[] bytes) {
        this.tail = ProtobufOutputEx.writeTagAndByteArray(tag, tagSize, bytes, 0, bytes.length, this, this.tail);
    }

    @Override
    public void writeByteRange(boolean utf8String, int tag, int tagSize, byte[] value, int offset, int length) {
        this.tail = ProtobufOutputEx.writeTagAndByteArray(tag, tagSize, value, offset, length, this, this.tail);
    }

    @Override
    public <T> void writeObject(int tag, int tagSize, T value, SchemaWriter<T> schemaWriter) throws IOException {
        LinkedBuffer lastBuffer;
        if (tagSize == 1 && this.tail.offset != this.tail.buffer.length) {
            lastBuffer = this.tail;
            ++this.size;
            lastBuffer.buffer[lastBuffer.offset++] = (byte)tag;
        } else {
            this.tail = lastBuffer = ProtobufOutputEx.writeRawVarInt32(tag, this, this.tail);
        }
        int lastOffset = this.tail.offset;
        int lastSize = this.size++;
        if (lastOffset == lastBuffer.buffer.length) {
            LinkedBuffer nextBuffer;
            this.tail = nextBuffer = new LinkedBuffer(this.nextBufferSize);
            schemaWriter.writeTo(this, value);
            int msgSize = this.size - lastSize;
            byte[] delimited = new byte[ProtobufOutputEx.computeRawVarint32Size(msgSize)];
            ProtobufOutputEx.writeRawVarInt32(msgSize, delimited, 0);
            this.size += delimited.length;
            new LinkedBuffer((byte[])delimited, (int)0, (int)delimited.length, (LinkedBuffer)lastBuffer).next = nextBuffer;
            return;
        }
        ++lastBuffer.offset;
        schemaWriter.writeTo(this, value);
        int msgSize = this.size - lastSize - 1;
        if (msgSize < 128) {
            lastBuffer.buffer[lastOffset] = (byte)msgSize;
            return;
        }
        LinkedBuffer view = new LinkedBuffer(lastBuffer.buffer, lastOffset + 1, lastBuffer.offset);
        if (lastBuffer == this.tail) {
            this.tail = view;
        } else {
            view.next = lastBuffer.next;
        }
        lastBuffer.offset = lastOffset;
        byte[] delimited = new byte[ProtobufOutputEx.computeRawVarint32Size(msgSize)];
        ProtobufOutputEx.writeRawVarInt32(msgSize, delimited, 0);
        this.size += delimited.length - 1;
        new LinkedBuffer((byte[])delimited, (int)0, (int)delimited.length, (LinkedBuffer)lastBuffer).next = view;
    }

    public static LinkedBuffer writeRawVarInt32(int value, WriteSession session, LinkedBuffer lb) {
        int size = ProtobufOutputEx.computeRawVarint32Size(value);
        if (lb.offset + size > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += size;
        session.size += size;
        if (size == 1) {
            buffer[offset] = (byte)value;
        } else {
            int i = 0;
            int last = size - 1;
            while (i < last) {
                buffer[offset++] = (byte)(value & 0x7F | 0x80);
                ++i;
                value >>>= 7;
            }
            buffer[offset] = (byte)value;
        }
        return lb;
    }

    public static LinkedBuffer writeTagAndByteArray(int tag, int tagSize, byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) {
        if (valueLen == 0) {
            return ProtobufOutputEx.writeTagAndRawVarInt32(tag, tagSize, valueLen, session, lb);
        }
        lb = ProtobufOutputEx.writeTagAndRawVarInt32(tag, tagSize, valueLen, session, lb);
        session.size += valueLen;
        int available = lb.buffer.length - lb.offset;
        if (valueLen > available) {
            if (available + session.nextBufferSize < valueLen) {
                if (available == 0) {
                    return new LinkedBuffer(session.nextBufferSize, new LinkedBuffer(value, offset, offset + valueLen, lb));
                }
                return new LinkedBuffer(lb, new LinkedBuffer(value, offset, offset + valueLen, lb));
            }
            System.arraycopy(value, offset, lb.buffer, lb.offset, available);
            lb.offset += available;
            lb = new LinkedBuffer(session.nextBufferSize, lb);
            int leftover = valueLen - available;
            System.arraycopy(value, offset + available, lb.buffer, 0, leftover);
            lb.offset += leftover;
            return lb;
        }
        System.arraycopy(value, offset, lb.buffer, lb.offset, valueLen);
        lb.offset += valueLen;
        return lb;
    }

    public static LinkedBuffer writeTagAndRawVarInt32(int tag, int tagSize, int value, WriteSession session, LinkedBuffer lb) {
        int last;
        int i;
        int size = ProtobufOutputEx.computeRawVarint32Size(value);
        int totalSize = tagSize + size;
        if (lb.offset + totalSize > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += totalSize;
        session.size += totalSize;
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            i = 0;
            last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        if (size == 1) {
            buffer[offset] = (byte)value;
        } else {
            i = 0;
            last = size - 1;
            while (i < last) {
                buffer[offset++] = (byte)(value & 0x7F | 0x80);
                ++i;
                value >>>= 7;
            }
            buffer[offset] = (byte)value;
        }
        return lb;
    }

    public static LinkedBuffer writeTagAndRawVarInt64(int tag, int tagSize, long value, WriteSession session, LinkedBuffer lb) {
        int last;
        int i;
        int size = ProtobufOutputEx.computeRawVarint64Size(value);
        int totalSize = tagSize + size;
        if (lb.offset + totalSize > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += totalSize;
        session.size += totalSize;
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            i = 0;
            last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        if (size == 1) {
            buffer[offset] = (byte)value;
        } else {
            i = 0;
            last = size - 1;
            while (i < last) {
                buffer[offset++] = (byte)((int)value & 0x7F | 0x80);
                ++i;
                value >>>= 7;
            }
            buffer[offset] = (byte)value;
        }
        return lb;
    }

    public static LinkedBuffer writeTagAndRawLittleEndian32(int tag, int tagSize, int value, WriteSession session, LinkedBuffer lb) {
        int totalSize = tagSize + 4;
        if (lb.offset + totalSize > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += totalSize;
        session.size += totalSize;
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            int i = 0;
            int last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        ProtobufOutputEx.writeRawLittleEndian32(value, buffer, offset);
        return lb;
    }

    public static LinkedBuffer writeTagAndRawLittleEndian64(int tag, int tagSize, long value, WriteSession session, LinkedBuffer lb) {
        int totalSize = tagSize + 8;
        if (lb.offset + totalSize > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += totalSize;
        session.size += totalSize;
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            int i = 0;
            int last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        ProtobufOutputEx.writeRawLittleEndian64(value, buffer, offset);
        return lb;
    }

    public static void writeRawVarInt32(int value, byte[] buf, int offset) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buf[offset] = (byte)value;
                return;
            }
            buf[offset++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int writeRawLittleEndian32(int value, byte[] buffer, int offset) {
        if (buffer.length - offset < 4) {
            throw new IllegalArgumentException("buffer capacity not enough.");
        }
        buffer[offset++] = (byte)(value & 0xFF);
        buffer[offset++] = (byte)(value >> 8 & 0xFF);
        buffer[offset++] = (byte)(value >> 16 & 0xFF);
        buffer[offset] = (byte)(value >> 24 & 0xFF);
        return 4;
    }

    public static int writeRawLittleEndian64(long value, byte[] buffer, int offset) {
        if (buffer.length - offset < 8) {
            throw new IllegalArgumentException("buffer capacity not enough.");
        }
        buffer[offset++] = (byte)(value & 0xFFL);
        buffer[offset++] = (byte)(value >> 8 & 0xFFL);
        buffer[offset++] = (byte)(value >> 16 & 0xFFL);
        buffer[offset++] = (byte)(value >> 24 & 0xFFL);
        buffer[offset++] = (byte)(value >> 32 & 0xFFL);
        buffer[offset++] = (byte)(value >> 40 & 0xFFL);
        buffer[offset++] = (byte)(value >> 48 & 0xFFL);
        buffer[offset] = (byte)(value >> 56 & 0xFFL);
        return 8;
    }

    public static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeRawVarint64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    @Override
    public void writeBytes(int tag, int tagSize, ByteBuffer value) {
        this.writeByteRange(false, tag, tagSize, value.array(), value.arrayOffset() + value.position(), value.remaining());
    }

    public void toOutputStream(OutputStream outputStream) throws IOException {
        LinkedBuffer.writeTo((OutputStream)outputStream, (LinkedBuffer)this.head);
    }

    @Override
    public void writePackedInt32(int value) {
        if (value >= 0) {
            this.tail = ProtobufOutputEx.writeRawVarInt32(value, this, this.tail);
            return;
        }
        this.writePackedUInt64(value);
    }

    @Override
    public void writeScalarInt32(int tag, int tagSize, int value) {
        if (value != 0) {
            this.writeInt32(tag, tagSize, value);
        }
    }

    @Override
    public void writeScalarInt64(int tag, int tagSize, long value) {
        if (value != 0L) {
            this.writeInt64(tag, tagSize, value);
        }
    }

    @Override
    public void writePackedUInt32(int value) {
        this.tail = ProtobufOutputEx.writeRawVarInt32(value, this, this.tail);
    }

    @Override
    public void writeScalarUInt32(int tag, int tagSize, int value) {
        if (value != 0) {
            this.writeUInt32(tag, tagSize, value);
        }
    }

    @Override
    public void writePackedUInt64(long value) {
        int size = ProtobufOutputEx.computeRawVarint64Size(value);
        if (this.tail.offset + size > this.tail.buffer.length) {
            this.tail = new LinkedBuffer(this.nextBufferSize, this.tail);
        }
        byte[] buffer = this.tail.buffer;
        int offset = this.tail.offset;
        this.tail.offset += size;
        this.size += size;
        if (size == 1) {
            buffer[offset] = (byte)value;
        } else {
            int i = 0;
            int last = size - 1;
            while (i < last) {
                buffer[offset++] = (byte)((int)value & 0x7F | 0x80);
                ++i;
                value >>>= 7;
            }
            buffer[offset] = (byte)value;
        }
    }

    @Override
    public void writeScalarUInt64(int tag, int tagSize, long value) {
        if (value != 0L) {
            this.writeUInt64(tag, tagSize, value);
        }
    }

    @Override
    public void writePackedSInt32(int value) {
        this.tail = ProtobufOutputEx.writeRawVarInt32(ProtobufOutputEx.encodeZigZag32(value), this, this.tail);
    }

    @Override
    public void writeScalarSInt32(int tag, int tagSize, int value) {
        if (value != 0) {
            this.writeSInt32(tag, tagSize, value);
        }
    }

    @Override
    public void writeScalarSInt64(int tag, int tagSize, long value) {
        if (value != 0L) {
            this.writeSInt64(tag, tagSize, value);
        }
    }

    @Override
    public void writePackedFixed32(int value) {
        int size = 4;
        if (this.tail.offset + 4 > this.tail.buffer.length) {
            this.tail = new LinkedBuffer(this.nextBufferSize, this.tail);
        }
        byte[] buffer = this.tail.buffer;
        int offset = this.tail.offset;
        this.tail.offset += 4;
        this.size += 4;
        buffer[offset++] = (byte)(value & 0xFF);
        buffer[offset++] = (byte)(value >> 8 & 0xFF);
        buffer[offset++] = (byte)(value >> 16 & 0xFF);
        buffer[offset] = (byte)(value >> 24 & 0xFF);
    }

    @Override
    public void writeScalarFixed32(int tag, int tagSize, int value) {
        if (value != 0) {
            this.writeFixed32(tag, tagSize, value);
        }
    }

    @Override
    public void writePackedFixed64(long value) {
        int size = 8;
        if (this.tail.offset + 8 > this.tail.buffer.length) {
            this.tail = new LinkedBuffer(this.nextBufferSize, this.tail);
        }
        byte[] buffer = this.tail.buffer;
        int offset = this.tail.offset;
        this.tail.offset += 8;
        this.size += 8;
        buffer[offset++] = (byte)(value & 0xFFL);
        buffer[offset++] = (byte)(value >> 8 & 0xFFL);
        buffer[offset++] = (byte)(value >> 16 & 0xFFL);
        buffer[offset++] = (byte)(value >> 24 & 0xFFL);
        buffer[offset++] = (byte)(value >> 32 & 0xFFL);
        buffer[offset++] = (byte)(value >> 40 & 0xFFL);
        buffer[offset++] = (byte)(value >> 48 & 0xFFL);
        buffer[offset] = (byte)(value >> 56 & 0xFFL);
    }

    @Override
    public void writeScalarFixed64(int tag, int tagSize, long value) {
        if (value != 0L) {
            this.writeFixed64(tag, tagSize, value);
        }
    }

    @Override
    public void writeScalarSFixed32(int tag, int tagSize, int value) {
        if (value != 0) {
            this.writeSFixed32(tag, tagSize, value);
        }
    }

    @Override
    public void writeScalarSFixed64(int tag, int tagSize, long value) {
        if (value != 0L) {
            this.writeSFixed64(tag, tagSize, value);
        }
    }

    @Override
    public void writeScalarFloat(int tag, int tagSize, float value) {
        if (value != 0.0f) {
            this.writeFloat(tag, tagSize, value);
        }
    }

    @Override
    public void writeScalarDouble(int tag, int tagSize, double value) {
        if (value != 0.0) {
            this.writeDouble(tag, tagSize, value);
        }
    }

    @Override
    public void writePackedBool(boolean value) {
        boolean size = true;
        if (this.tail.offset + 1 > this.tail.buffer.length) {
            this.tail = new LinkedBuffer(this.nextBufferSize, this.tail);
        }
        byte[] buffer = this.tail.buffer;
        int offset = this.tail.offset++;
        ++this.size;
        buffer[offset] = (byte)(value ? 1 : 0);
    }

    @Override
    public void writeScalarBool(int tag, int tagSize, boolean value) {
        if (value) {
            this.writeBool(tag, tagSize, value);
        }
    }

    @Override
    public void writeScalarEnum(int tag, int tagSize, int value) {
        this.writeScalarInt32(tag, tagSize, value);
    }

    @Override
    public void writeScalarString(int tag, int tagSize, String value) {
        this.writeString(tag, tagSize, value);
    }
}

