/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;

public class State {
    public static final State INITIAL = State.of(UUID.fromString("2c9f1b12-b35a-43e6-9af2-0106fb53a943"));
    private final UUID value;

    public static State of(UUID value) {
        Preconditions.checkNotNull((Object)value, (Object)"State 'value' should not be null.");
        return new State(value);
    }

    private State(UUID value) {
        this.value = value;
    }

    public UUID getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof State) {
            State state = (State)o;
            return Objects.equals(this.value, state.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }

    public static class DefaultFactory
    implements Factory {
        @Override
        public State generate() {
            return State.of(UUID.randomUUID());
        }
    }

    public static interface Factory {
        public static final Factory DEFAULT = new DefaultFactory();

        public State generate();
    }
}

