/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
abstract class ProxySocketFactory
extends SocketFactory {
    private final int connectTimeoutMillis;
    @NotNull
    private final Proxy proxy;
    @Nullable
    private final SSLSocketFactory sslSocketFactory;

    protected ProxySocketFactory(@NotNull Proxy proxy, int connectTimeoutMillis, @Nullable SSLSocketFactory sslSocketFactory) {
        this.proxy = proxy;
        this.connectTimeoutMillis = Math.max(connectTimeoutMillis, 0);
        this.sslSocketFactory = sslSocketFactory;
    }

    @Override
    @NotNull
    public final Socket createSocket() throws UnsupportedOperationException {
        if (this.sslSocketFactory == null) {
            return new Socket(this.proxy);
        }
        throw new UnsupportedOperationException(UtilityMessages.ERR_PROXY_SF_CANNOT_CREATE_UNCONNECTED_SOCKET.get());
    }

    @Override
    @NotNull
    public final Socket createSocket(@NotNull String host, int port) throws IOException {
        Socket socket = new Socket(this.proxy);
        socket.connect(new InetSocketAddress(host, port), this.connectTimeoutMillis);
        return this.secureSocket(socket, host, port);
    }

    @Override
    @NotNull
    public final Socket createSocket(@NotNull String host, int port, @Nullable InetAddress localHost, int localPort) throws IOException {
        Socket socket = new Socket(this.proxy);
        socket.bind(new InetSocketAddress(localHost, localPort));
        socket.connect(new InetSocketAddress(host, port), this.connectTimeoutMillis);
        return this.secureSocket(socket, host, port);
    }

    @Override
    @NotNull
    public final Socket createSocket(@NotNull InetAddress host, int port) throws IOException {
        Socket socket = new Socket(this.proxy);
        socket.connect(new InetSocketAddress(host, port), this.connectTimeoutMillis);
        return this.secureSocket(socket, host.getHostName(), port);
    }

    @Override
    @NotNull
    public final Socket createSocket(@NotNull InetAddress host, int port, @Nullable InetAddress localHost, int localPort) throws IOException {
        Socket socket = new Socket(this.proxy);
        socket.bind(new InetSocketAddress(localHost, localPort));
        socket.connect(new InetSocketAddress(host, port), this.connectTimeoutMillis);
        return this.secureSocket(socket, host.getHostName(), port);
    }

    @NotNull
    private Socket secureSocket(@NotNull Socket socket, @NotNull String host, int port) throws IOException {
        if (this.sslSocketFactory == null) {
            return socket;
        }
        try {
            return this.sslSocketFactory.createSocket(socket, host, port, true);
        }
        catch (IOException e) {
            Debug.debugException(e);
            try {
                socket.close();
            }
            catch (Exception e2) {
                Debug.debugException(e2);
            }
            throw e;
        }
    }
}

